/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.spi.MapperProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

final class MapperManagerImpl
implements MapperManager {
    private final List<MapperProvider> providers;
    private final Map<ClassCacheKey, Mapper<?, ?>> classCache = new ConcurrentHashMap();
    private final Map<GenericCacheKey, Mapper<?, ?>> typeCache = new ConcurrentHashMap();

    MapperManagerImpl(MapperManager.Builder builder) {
        this.providers = builder.mapperProviders();
    }

    @Override
    public <SOURCE, TARGET> TARGET map(SOURCE source, GenericType<SOURCE> sourceType, GenericType<TARGET> targetType, String ... qualifiers) {
        try {
            return this.findMapper(sourceType, targetType, false, qualifiers).map(source);
        }
        catch (MapperException e) {
            throw e;
        }
        catch (Exception e) {
            throw MapperManagerImpl.createMapperException(source, sourceType, targetType, e);
        }
    }

    @Override
    public <SOURCE, TARGET> TARGET map(SOURCE source, Class<SOURCE> sourceType, Class<TARGET> targetType, String ... qualifiers) {
        try {
            return this.findMapper(sourceType, targetType, false, qualifiers).map(source);
        }
        catch (MapperException e) {
            throw e;
        }
        catch (Exception e) {
            throw MapperManagerImpl.createMapperException(source, GenericType.create(sourceType), GenericType.create(targetType), e);
        }
    }

    @Override
    public <SOURCE, TARGET> Optional<Mapper<SOURCE, TARGET>> mapper(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType, String ... qualifiers) {
        Mapper<SOURCE, TARGET> mapper = this.findMapper(sourceType, targetType, false, qualifiers);
        if (mapper instanceof NotFoundMapper) {
            return Optional.empty();
        }
        return Optional.of(mapper);
    }

    private static <SOURCE, TARGET> Mapper<SOURCE, TARGET> notFoundMapper(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType, String ... qualifier) {
        return new NotFoundMapper(sourceType, targetType, qualifier);
    }

    private static RuntimeException createMapperException(Object source, GenericType<?> sourceType, GenericType<?> targetType, Throwable throwable) {
        throw new MapperException(sourceType, targetType, "Failed to map source of class '" + source.getClass().getName() + "'", throwable);
    }

    private <SOURCE, TARGET> Mapper<SOURCE, TARGET> findMapper(Class<SOURCE> sourceType, Class<TARGET> targetType, boolean fromTypes, String ... qualifiers) {
        Mapper mapper = this.classCache.computeIfAbsent(new ClassCacheKey(sourceType, targetType, qualifiers), key -> this.fromProviders(sourceType, targetType, qualifiers).orElseGet(() -> {
            GenericType sourceGenericType = GenericType.create((Class)sourceType);
            GenericType targetGenericType = GenericType.create((Class)targetType);
            if (fromTypes) {
                return MapperManagerImpl.notFoundMapper(sourceGenericType, targetGenericType, qualifiers);
            }
            return this.findMapper(sourceGenericType, targetGenericType, true, qualifiers);
        }));
        return mapper;
    }

    private <SOURCE, TARGET> Mapper<SOURCE, TARGET> findMapper(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType, boolean fromClasses, String ... qualifiers) {
        Mapper mapper = this.typeCache.computeIfAbsent(new GenericCacheKey(sourceType, targetType, qualifiers), key -> this.fromProviders(sourceType, targetType, qualifiers).orElseGet(() -> {
            if (!fromClasses && sourceType.isClass() && targetType.isClass()) {
                return this.findMapper(sourceType.rawType(), targetType.rawType(), true, qualifiers);
            }
            return MapperManagerImpl.notFoundMapper(sourceType, targetType, qualifiers);
        }));
        return mapper;
    }

    private Optional<Mapper<?, ?>> fromProviders(BiFunction<MapperProvider, String, MapperProvider.ProviderResponse> qualifiedMapper, String ... qualifiers) {
        Mapper<?, ?> compatible = null;
        for (int i = 0; i < qualifiers.length; ++i) {
            String fullQ = i == 0 ? String.join((CharSequence)"/", qualifiers) : String.join((CharSequence)"/", Arrays.copyOf(qualifiers, qualifiers.length - i));
            for (MapperProvider provider : this.providers) {
                MapperProvider.ProviderResponse response = qualifiedMapper.apply(provider, fullQ);
                switch (response.support()) {
                    case SUPPORTED: {
                        return Optional.of(response.mapper());
                    }
                    case COMPATIBLE: {
                        compatible = compatible == null ? response.mapper() : compatible;
                        break;
                    }
                }
            }
        }
        if (qualifiers.length == 0 || !qualifiers[0].isEmpty()) {
            for (MapperProvider provider : this.providers) {
                MapperProvider.ProviderResponse response = qualifiedMapper.apply(provider, "");
                switch (response.support()) {
                    case SUPPORTED: {
                        return Optional.of(response.mapper());
                    }
                    case COMPATIBLE: {
                        compatible = compatible == null ? response.mapper() : compatible;
                        break;
                    }
                }
            }
        }
        return Optional.ofNullable(compatible);
    }

    private <SOURCE, TARGET> Optional<Mapper<?, ?>> fromProviders(Class<SOURCE> sourceType, Class<TARGET> targetType, String ... qualifiers) {
        return this.fromProviders((MapperProvider provider, String qualifier) -> provider.mapper(sourceType, targetType, (String)qualifier), qualifiers);
    }

    private <SOURCE, TARGET> Optional<Mapper<?, ?>> fromProviders(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType, String ... qualifiers) {
        return this.fromProviders((MapperProvider provider, String qualifier) -> provider.mapper(sourceType, targetType, (String)qualifier), qualifiers);
    }

    private static class NotFoundMapper
    implements Mapper {
        private final GenericType sourceType;
        private final GenericType targetType;
        private final String qualifierString;

        private NotFoundMapper(GenericType sourceType, GenericType targetType, String[] qualifier) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.qualifierString = String.join((CharSequence)",", qualifier);
        }

        public Object map(Object source) {
            throw new MapperException(this.sourceType, this.targetType, "Failed to find mapper. Qualifiers: " + this.qualifierString + ", source of class '" + source.getClass().getName() + "'");
        }
    }

    private record ClassCacheKey(Class<?> sourceType, Class<?> targetType, String[] qualifiers) {
    }

    private record GenericCacheKey(GenericType<?> sourceType, GenericType<?> targetType, String[] qualifiers) {
    }
}

