/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.mapper.Value;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class ValueBacked<T>
implements OptionalValue<T> {
    private final MapperManager mapperManager;
    private final String name;
    private final T value;
    private final GenericType<T> type;
    private final String[] qualifiers;

    ValueBacked(MapperManager mapperManager, String name, T value, GenericType<T> type, String[] qualifiers) {
        Objects.requireNonNull(mapperManager);
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.name = name;
        this.mapperManager = mapperManager;
        this.value = value;
        this.type = type;
        this.qualifiers = qualifiers;
    }

    ValueBacked(MapperManager mapperManager, String name, T value, String[] qualifiers) {
        this(mapperManager, name, value, null, qualifiers);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<T> asOptional() throws MapperException {
        return Optional.of(this.value);
    }

    @Override
    public <N> OptionalValue<N> as(Function<? super T, ? extends N> mapper) {
        N result = mapper.apply(this.value);
        return new ValueBacked<N>(this.mapperManager, this.name(), result, this.qualifiers);
    }

    @Override
    public <N> OptionalValue<N> as(Class<N> type) throws MapperException {
        GenericType myType = this.type == null ? GenericType.create(this.value) : this.type;
        return OptionalValue.create(this.mapperManager, this.name, this.mapperManager.map(this.value, myType, GenericType.create(type), this.qualifiers), new String[0]);
    }

    @Override
    public <N> OptionalValue<N> as(GenericType<N> type) throws MapperException {
        GenericType myType = this.type == null ? GenericType.create(this.value) : this.type;
        return OptionalValue.create(this.mapperManager, this.name, this.mapperManager.map(this.value, myType, type, this.qualifiers), new String[0]);
    }

    @Override
    public T get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.asOptional(), other.asOptional());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

