/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.parameters;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.mapper.Value;
import io.helidon.common.parameters.Parameters;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class ParametersSingleValueMap
implements Parameters {
    private final MapperManager mapperManager;
    private final String component;
    private final Map<String, String> params;
    private final String[] qualifiers;

    ParametersSingleValueMap(MapperManager mapperManager, String component, Map<String, String> params) {
        this.qualifiers = component.split("/");
        this.mapperManager = mapperManager;
        this.component = component;
        this.params = params;
    }

    @Override
    public List<String> all(String name) throws NoSuchElementException {
        String value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return List.of(value);
    }

    @Override
    public List<Value<String>> allValues(String name) throws NoSuchElementException {
        String value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return List.of(Value.create((MapperManager)this.mapperManager, (String)name, (Object)value, (String[])this.qualifiers));
    }

    @Override
    public String get(String name) throws NoSuchElementException {
        String value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return value;
    }

    @Override
    public boolean contains(String name) {
        return this.params.containsKey(name);
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public Set<String> names() {
        return Set.copyOf(this.params.keySet());
    }

    @Override
    public String component() {
        return this.component;
    }

    public String toString() {
        return this.component + ": " + String.valueOf(this.params);
    }

    @Override
    public OptionalValue<String> first(String name) {
        if (this.contains(name)) {
            return OptionalValue.create((MapperManager)this.mapperManager, (String)name, (Object)this.get(name), (GenericType)GenericType.STRING, (String[])this.qualifiers);
        }
        return OptionalValue.create((MapperManager)this.mapperManager, (String)name, (GenericType)GenericType.STRING, (String[])this.qualifiers);
    }
}

