/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsReloadableComponent;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

class TlsReloadableX509KeyManager
extends X509ExtendedKeyManager
implements TlsReloadableComponent {
    private static final System.Logger LOGGER = System.getLogger(TlsReloadableX509KeyManager.class.getName());
    private volatile X509KeyManager keyManager;

    private TlsReloadableX509KeyManager(X509KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.keyManager.getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManager.chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.keyManager.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.keyManager.chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.keyManager.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.keyManager.getPrivateKey(s);
    }

    @Override
    public void reload(Tls tls) {
        tls.keyManager().ifPresent(this::reload);
    }

    void reload(X509KeyManager keyManager) {
        Objects.requireNonNull(keyManager, "Cannot unset key manager");
        TlsReloadableX509KeyManager.assertValid(keyManager);
        LOGGER.log(System.Logger.Level.DEBUG, "Reloading TLS X509KeyManager");
        this.keyManager = keyManager;
    }

    static TlsReloadableX509KeyManager create(X509KeyManager keyManager) {
        if (keyManager instanceof TlsReloadableX509KeyManager) {
            return (TlsReloadableX509KeyManager)keyManager;
        }
        TlsReloadableX509KeyManager.assertValid(keyManager);
        return new TlsReloadableX509KeyManager(keyManager);
    }

    static void assertValid(X509KeyManager keyManager) {
        if (keyManager instanceof TlsReloadableX509KeyManager) {
            throw new IllegalArgumentException();
        }
    }

    static class NotReloadableKeyManager
    extends TlsReloadableX509KeyManager {
        NotReloadableKeyManager() {
            super(null);
        }

        @Override
        public void reload(Tls tls) {
            if (tls.keyManager().isPresent()) {
                throw new UnsupportedOperationException("Cannot reload key manager if one was not set during server start");
            }
        }

        @Override
        void reload(X509KeyManager keyManager) {
            throw new UnsupportedOperationException("Cannot reload key manager if one was not set during server start");
        }
    }
}

