/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class UriEncoding {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] HEX_TABLE = UriEncoding.initHexTable();
    private static final String[] SCHEME = new String[]{"0-9", "A-Z", "a-z", "+", "-", "."};
    private static final String[] UNRESERVED = new String[]{"0-9", "A-Z", "a-z", "-", ".", "_", "~"};
    private static final String[] SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static final boolean[][] ENCODING_TABLES = UriEncoding.initEncodingTables();

    private UriEncoding() {
    }

    public static String decodeUri(String uriSegment) {
        if (uriSegment.isEmpty()) {
            return "";
        }
        if (uriSegment.indexOf(37) == -1 && uriSegment.indexOf(43) == -1) {
            return uriSegment;
        }
        return UriEncoding.decode(uriSegment);
    }

    public static String encodeUri(String uriSegment) {
        if (uriSegment.isEmpty()) {
            return "";
        }
        return UriEncoding.encode(uriSegment);
    }

    public static String encode(String s, Type t) {
        int codePoint;
        Objects.requireNonNull(s, "String to encode must not be null");
        Objects.requireNonNull(t, "Type of encoded component must not be null");
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        StringBuilder sb = new StringBuilder();
        for (int offset = 0; offset < s.length(); offset += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(offset);
            if (codePoint < 128 && table[codePoint]) {
                sb.append((char)codePoint);
                continue;
            }
            if (codePoint == 37) {
                sb.append("%25");
                continue;
            }
            if (codePoint < 128) {
                if (codePoint == 32 && t == Type.QUERY_PARAM) {
                    sb.append('+');
                    continue;
                }
                UriEncoding.appendEscape(sb, (char)codePoint);
                continue;
            }
            UriEncoding.appendUTF8EncodedCharacter(sb, codePoint);
        }
        return sb.toString();
    }

    private static String encode(String uriSegment) {
        return UriEncoding.encode(uriSegment, Type.PATH);
    }

    private static void appendEscape(StringBuilder appender, int b) {
        appender.append('%');
        appender.append(HEX_DIGITS[b >> 4]);
        appender.append(HEX_DIGITS[b & 0xF]);
    }

    private static String decode(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        ByteBuffer bb = ByteBuffer.allocate(len);
        char c = string.charAt(0);
        boolean betweenBrackets = false;
        int i = 0;
        while (i < len) {
            assert (c == string.charAt(i));
            if (c == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c == '+' && !betweenBrackets ? (char)' ' : c);
                if (++i >= len) break;
                c = string.charAt(i);
                continue;
            }
            bb.clear();
            do {
                bb.put(UriEncoding.decode(string.charAt(++i), string.charAt(++i)));
            } while (++i < len && (c = (char)string.charAt(i)) == 37);
            bb.flip();
            CharBuffer cb = StandardCharsets.UTF_8.decode(bb);
            sb.append(cb);
        }
        return sb.toString();
    }

    private static byte decode(char c1, char c2) {
        return (byte)((UriEncoding.decode(c1) & 0xF) << 4 | UriEncoding.decode(c2) & 0xF);
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static void appendUTF8EncodedCharacter(StringBuilder sb, int codePoint) {
        CharBuffer chars = CharBuffer.wrap(Character.toChars(codePoint));
        ByteBuffer bytes = StandardCharsets.UTF_8.encode(chars);
        while (bytes.hasRemaining()) {
            UriEncoding.appendEscape(sb, bytes.get() & 0xFF);
        }
    }

    private static int[] initHexTable() {
        int c;
        int[] table = new int[128];
        Arrays.fill(table, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            table[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            table[c] = c - 65 + 10;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            table[c] = c - 97 + 10;
        }
        return table;
    }

    private static boolean[][] initEncodingTables() {
        boolean[][] tables = new boolean[Type.values().length][];
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(SCHEME));
        tables[Type.SCHEME.ordinal()] = UriEncoding.initEncodingTable(l);
        l.clear();
        l.addAll(Arrays.asList(UNRESERVED));
        tables[Type.UNRESERVED.ordinal()] = UriEncoding.initEncodingTable(l);
        l.addAll(Arrays.asList(SUB_DELIMS));
        tables[Type.HOST.ordinal()] = UriEncoding.initEncodingTable(l);
        tables[Type.PORT.ordinal()] = UriEncoding.initEncodingTable(Arrays.asList("0-9"));
        l.add(":");
        tables[Type.USER_INFO.ordinal()] = UriEncoding.initEncodingTable(l);
        l.add("@");
        tables[Type.AUTHORITY.ordinal()] = UriEncoding.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()] = UriEncoding.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()][59] = false;
        tables[Type.MATRIX_PARAM.ordinal()] = (boolean[])tables[Type.PATH_SEGMENT.ordinal()].clone();
        tables[Type.MATRIX_PARAM.ordinal()][61] = false;
        l.add("/");
        tables[Type.PATH.ordinal()] = UriEncoding.initEncodingTable(l);
        tables[Type.QUERY.ordinal()] = UriEncoding.initEncodingTable(l);
        tables[Type.QUERY.ordinal()][33] = false;
        tables[Type.QUERY.ordinal()][42] = false;
        tables[Type.QUERY.ordinal()][39] = false;
        tables[Type.QUERY.ordinal()][40] = false;
        tables[Type.QUERY.ordinal()][41] = false;
        tables[Type.QUERY.ordinal()][59] = false;
        tables[Type.QUERY.ordinal()][58] = false;
        tables[Type.QUERY.ordinal()][64] = false;
        tables[Type.QUERY.ordinal()][36] = false;
        tables[Type.QUERY.ordinal()][44] = false;
        tables[Type.QUERY.ordinal()][47] = false;
        tables[Type.QUERY.ordinal()][63] = false;
        tables[Type.QUERY_PARAM.ordinal()] = Arrays.copyOf(tables[Type.QUERY.ordinal()], tables[Type.QUERY.ordinal()].length);
        tables[Type.QUERY_PARAM.ordinal()][61] = false;
        tables[Type.QUERY_PARAM.ordinal()][43] = false;
        tables[Type.QUERY_PARAM.ordinal()][38] = false;
        tables[Type.QUERY_PARAM_SPACE_ENCODED.ordinal()] = tables[Type.QUERY_PARAM.ordinal()];
        tables[Type.FRAGMENT.ordinal()] = tables[Type.QUERY.ordinal()];
        return tables;
    }

    private static boolean[] initEncodingTable(List<String> allowed) {
        boolean[] table = new boolean[128];
        for (String range : allowed) {
            if (range.length() == 1) {
                table[range.charAt((int)0)] = true;
                continue;
            }
            if (range.length() != 3 || range.charAt(1) != '-') continue;
            for (int i = range.charAt(0); i <= range.charAt(2); ++i) {
                table[i] = true;
            }
        }
        return table;
    }

    private static boolean isHexCharacter(char c) {
        return c < '\u0080' && HEX_TABLE[c] != -1;
    }

    public static enum Type {
        UNRESERVED,
        SCHEME,
        AUTHORITY,
        USER_INFO,
        HOST,
        PORT,
        PATH,
        PATH_SEGMENT,
        MATRIX_PARAM,
        QUERY,
        QUERY_PARAM,
        QUERY_PARAM_SPACE_ENCODED,
        FRAGMENT;

    }
}

