/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.cors;

import io.helidon.common.config.Config;
import io.helidon.cors.Aggregator;
import io.helidon.cors.CorsRequestAdapter;
import io.helidon.cors.CorsResponseAdapter;
import io.helidon.cors.CorsSetter;
import io.helidon.cors.CorsSupportHelper;
import io.helidon.cors.CrossOriginConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class CorsSupportBase<Q, R, T extends CorsSupportBase<Q, R, T, B>, B extends Builder<Q, R, T, B>> {
    private static final System.Logger LOGGER = System.getLogger(CorsSupportBase.class.getName());
    private final String name;
    private final CorsSupportHelper<Q, R> helper;

    protected CorsSupportBase(Builder<Q, R, T, B> builder) {
        this.name = builder.name;
        builder.helperBuilder.name(builder.name);
        if (builder.requestDefaultBehaviorIfNone) {
            builder.helperBuilder.requestDefaultBehaviorIfNone();
        }
        this.helper = builder.helperBuilder.build();
    }

    protected Optional<R> processRequest(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        return this.helper.processRequest(requestAdapter, responseAdapter);
    }

    protected void prepareResponse(CorsRequestAdapter<Q> requestAdapter, CorsResponseAdapter<R> responseAdapter) {
        this.helper.prepareResponse(requestAdapter, responseAdapter);
    }

    protected CorsSupportHelper<Q, R> helper() {
        return this.helper;
    }

    protected String describe() {
        return this.helper.toString();
    }

    protected String name() {
        return this.name;
    }

    public static abstract class Builder<Q, R, T extends CorsSupportBase<Q, R, T, B>, B extends Builder<Q, R, T, B>>
    implements io.helidon.common.Builder<B, CorsSupportBase<Q, R, T, B>>,
    CorsSetter<Builder<Q, R, T, B>> {
        private String name = "";
        private final CorsSupportHelper.Builder<Q, R> helperBuilder = CorsSupportHelper.builder();
        private final Aggregator.Builder aggregatorBuilder = this.helperBuilder.aggregatorBuilder();
        private boolean requestDefaultBehaviorIfNone = false;

        protected Builder() {
        }

        public abstract T build();

        public B config(Config config) {
            this.reportUseOfMissingConfig(config);
            this.helperBuilder.config(config);
            return (B)((Builder)this.identity());
        }

        public B mappedConfig(Config config) {
            this.reportUseOfMissingConfig(config);
            this.helperBuilder.mappedConfig(config);
            return (B)((Builder)this.identity());
        }

        @Override
        public B enabled(boolean value) {
            this.aggregatorBuilder.enabled(value);
            return (B)((Builder)this.identity());
        }

        public B addCrossOrigin(String path, CrossOriginConfig crossOrigin) {
            this.aggregatorBuilder.addCrossOrigin(path, crossOrigin);
            return (B)((Builder)this.identity());
        }

        public B addCrossOrigin(CrossOriginConfig crossOrigin) {
            this.aggregatorBuilder.addPathlessCrossOrigin(crossOrigin);
            return (B)((Builder)this.identity());
        }

        public B name(String name) {
            Objects.requireNonNull(name, "CorsSupport name is optional but cannot be null");
            this.name = name;
            this.helperBuilder.name(name);
            return (B)((Builder)this.identity());
        }

        @Override
        public B allowOrigins(String ... origins) {
            this.aggregatorBuilder.allowOrigins(origins);
            return (B)((Builder)this.identity());
        }

        @Override
        public B allowHeaders(String ... allowHeaders) {
            this.aggregatorBuilder.allowHeaders(allowHeaders);
            return (B)((Builder)this.identity());
        }

        @Override
        public B exposeHeaders(String ... exposeHeaders) {
            this.aggregatorBuilder.exposeHeaders(exposeHeaders);
            return (B)((Builder)this.identity());
        }

        @Override
        public B allowMethods(String ... allowMethods) {
            this.aggregatorBuilder.allowMethods(allowMethods);
            return (B)((Builder)this.identity());
        }

        @Override
        public B allowCredentials(boolean allowCredentials) {
            this.aggregatorBuilder.allowCredentials(allowCredentials);
            return (B)((Builder)this.identity());
        }

        @Override
        public B maxAgeSeconds(long maxAgeSeconds) {
            this.aggregatorBuilder.maxAgeSeconds(maxAgeSeconds);
            return (B)((Builder)this.identity());
        }

        protected B secondaryLookupSupplier(Supplier<Optional<CrossOriginConfig>> secondaryLookupSupplier) {
            this.helperBuilder.secondaryLookupSupplier(secondaryLookupSupplier);
            return (B)((Builder)this.identity());
        }

        protected B requestDefaultBehaviorIfNone() {
            this.requestDefaultBehaviorIfNone = true;
            return (B)((Builder)this.identity());
        }

        private void reportUseOfMissingConfig(Config config) {
            if (!config.exists()) {
                LOGGER.log(System.Logger.Level.TRACE, String.format("Attempt to load %s using empty config with key '%s'; continuing with default CORS information", this.getClass().getSuperclass().getSimpleName(), config.key().toString()));
            }
        }
    }
}

