/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.cors;

import io.helidon.cors.CorsRequestAdapter;
import io.helidon.cors.CorsSupportHelper;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class LogHelper {
    static final Level DECISION_LEVEL = Level.FINE;
    static final Level DETAILED_DECISION_LEVEL = Level.FINER;

    private LogHelper() {
    }

    static <T> void logIsRequestTypeNormalNoOrigin(boolean silent, CorsRequestAdapter<T> requestAdapter) {
        if (silent || !CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            return;
        }
        CorsSupportHelper.LOGGER.log(DECISION_LEVEL, String.format("Request %s is not cross-host: %s", requestAdapter, List.of("header " + String.valueOf(HeaderNames.ORIGIN) + " is absent")));
    }

    static <T> void logOpaqueOrigin(boolean silent, CorsRequestAdapter<T> requestAdapter) {
        if (silent || !CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            return;
        }
        CorsSupportHelper.LOGGER.log(DECISION_LEVEL, String.format("Request %s specifies opaque origin: %s", requestAdapter, List.of("header " + String.valueOf(HeaderNames.ORIGIN))));
    }

    static <T> void logIsRequestTypeNormal(boolean result, boolean silent, CorsRequestAdapter<T> requestAdapter, Optional<String> originOpt, String effectiveOrigin, String host) {
        if (silent || !CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            return;
        }
        ArrayList<Object> reasonsWhyNormal = new ArrayList<Object>();
        ArrayList<String> factorsWhyCrossHost = new ArrayList<String>();
        if (originOpt.isEmpty()) {
            reasonsWhyNormal.add("header " + String.valueOf(HeaderNames.ORIGIN) + " is absent");
        } else {
            factorsWhyCrossHost.add(String.format("header %s is present (%s)", HeaderNames.ORIGIN, effectiveOrigin));
        }
        if (host.isEmpty()) {
            reasonsWhyNormal.add("header " + String.valueOf(HeaderNames.HOST) + "/requested URI is absent");
        } else {
            factorsWhyCrossHost.add(String.format("header %s/requested URI is present (%s)", HeaderNames.HOST, host));
        }
        if (originOpt.isPresent()) {
            String partOfOriginMatchingHost = "://" + host;
            if (originOpt.get().contains(partOfOriginMatchingHost)) {
                reasonsWhyNormal.add(String.format("header %s '%s' matches header/requested URI %s '%s'", HeaderNames.ORIGIN, effectiveOrigin, HeaderNames.HOST, host));
            } else {
                factorsWhyCrossHost.add(String.format("header %s '%s' does not match header/requested URI %s '%s'", HeaderNames.ORIGIN, effectiveOrigin, HeaderNames.HOST, host));
            }
        }
        if (result) {
            if (CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
                CorsSupportHelper.LOGGER.log(DECISION_LEVEL, String.format("Request %s is not cross-host: %s", requestAdapter, reasonsWhyNormal));
            }
        } else if (CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            CorsSupportHelper.LOGGER.log(DECISION_LEVEL, () -> String.format("Request %s is cross-host: %s", requestAdapter, factorsWhyCrossHost));
        }
    }

    static <T> void logInferRequestType(CorsSupportHelper.RequestType result, boolean silent, CorsRequestAdapter<T> requestAdapter, String methodName, boolean requestContainsAccessControlRequestMethodHeader) {
        if (silent || !CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            return;
        }
        ArrayList<String> reasonsWhyCORS = new ArrayList<String>();
        ArrayList<String> factorsWhyPreflight = new ArrayList<String>();
        if (!methodName.equalsIgnoreCase(Method.OPTIONS.text())) {
            reasonsWhyCORS.add(String.format("method is %s, not %s", methodName, Method.OPTIONS.text()));
        } else {
            factorsWhyPreflight.add(String.format("method is %s", methodName));
        }
        if (!requestContainsAccessControlRequestMethodHeader) {
            reasonsWhyCORS.add(String.format("header %s is absent", HeaderNames.ACCESS_CONTROL_REQUEST_METHOD.defaultCase()));
        } else {
            factorsWhyPreflight.add(String.format("header %s is present(%s)", HeaderNames.ACCESS_CONTROL_REQUEST_METHOD.defaultCase(), requestAdapter.firstHeader(HeaderNames.ACCESS_CONTROL_REQUEST_METHOD)));
        }
        if (CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            CorsSupportHelper.LOGGER.log(DECISION_LEVEL, String.format("Request %s is of type %s; %s", requestAdapter, result.name(), result == CorsSupportHelper.RequestType.PREFLIGHT ? factorsWhyPreflight : reasonsWhyCORS));
        }
    }

    static class MatcherChecks<T> {
        private final Map<CrossOriginConfig, MatcherCheck> checks;
        private final Logger logger;
        private final boolean isLoggable;
        private final Function<T, CrossOriginConfig> getter;

        MatcherChecks(Logger logger, Function<T, CrossOriginConfig> getter) {
            this.logger = logger;
            this.isLoggable = logger.isLoggable(DETAILED_DECISION_LEVEL);
            this.getter = getter;
            this.checks = this.isLoggable ? new LinkedHashMap() : null;
        }

        void put(T matcher) {
            if (this.isLoggable) {
                this.checks.put(this.getter.apply(matcher), new MatcherCheck());
            }
        }

        void matched(T matcher) {
            if (this.isLoggable) {
                this.checks.get(this.getter.apply(matcher)).matched(true);
            }
        }

        void enabled(CrossOriginConfig crossOriginConfig) {
            if (this.isLoggable) {
                this.checks.get(crossOriginConfig).enabled(true);
            }
        }

        void log() {
            if (!this.isLoggable) {
                return;
            }
            ArrayList results = new ArrayList();
            this.checks.forEach((k, v) -> results.add(v.toString((CrossOriginConfig)k)));
            this.logger.log(DETAILED_DECISION_LEVEL, results.stream().collect(Collectors.joining(System.lineSeparator(), "Matching results: [", "]")));
        }

        private static class MatcherCheck {
            private boolean matched;
            private boolean enabled;

            private MatcherCheck() {
            }

            void matched(boolean value) {
                this.matched = value;
            }

            void enabled(boolean value) {
                this.enabled = value;
            }

            public String toString(CrossOriginConfig crossOriginConfig) {
                return new StringJoiner(", ", MatcherCheck.class.getSimpleName() + "{", "}").add("crossOriginConfig=" + String.valueOf(crossOriginConfig)).add("matched=" + this.matched).add("enabled=" + this.enabled).toString();
            }
        }
    }

    static class Headers {
        private final List<Map.Entry<HeaderName, Object>> headers = new ArrayList<Map.Entry<HeaderName, Object>>();
        private final List<String> notes = CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL) ? new ArrayList() : null;

        Headers() {
        }

        Headers add(HeaderName key, Object value) {
            this.headers.add(new AbstractMap.SimpleEntry<HeaderName, Object>(key, value));
            return this;
        }

        Headers add(HeaderName key, Object value, String note) {
            this.add(key, value);
            if (this.notes != null) {
                this.notes.add(note);
            }
            return this;
        }

        void setAndLog(BiConsumer<HeaderName, Object> consumer, String note) {
            this.headers.forEach(entry -> consumer.accept((HeaderName)entry.getKey(), entry.getValue()));
            CorsSupportHelper.LOGGER.log(DECISION_LEVEL, () -> note + ": " + String.valueOf(this.headers) + String.valueOf(this.notes == null ? "" : this.notes));
        }
    }
}

