/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.common.NativeImageHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.mp.MpConfig;
import io.helidon.microprofile.config.ConfigBeanDescriptor;
import io.helidon.microprofile.config.ConfigPropertyLiteral;
import io.helidon.microprofile.config.DefaultConfigValue;
import io.helidon.microprofile.config.FieldTypes;
import io.helidon.microprofile.config.SerializableConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(ConfigCdiExtension.class.getName());
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\,", 16);
    private static final Annotation CONFIG_PROPERTY_LITERAL = new ConfigPropertyLiteral();
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private final List<InjectionPoint> ips = new LinkedList<InjectionPoint>();
    private final Map<Class<?>, ConfigBeanDescriptor> configBeans = new HashMap();

    public ConfigCdiExtension() {
        LOGGER.log(System.Logger.Level.DEBUG, "ConfigCdiExtension instantiated");
    }

    private void harvestConfigPropertyInjectionPointsFromEnabledBean(@Observes ProcessBean<?> event) {
        Bean bean = event.getBean();
        Set beanInjectionPoints = bean.getInjectionPoints();
        if (beanInjectionPoints != null) {
            for (InjectionPoint beanInjectionPoint : beanInjectionPoints) {
                if (beanInjectionPoint == null) continue;
                Set qualifiers = beanInjectionPoint.getQualifiers();
                assert (qualifiers != null);
                for (Annotation qualifier : qualifiers) {
                    if (!(qualifier instanceof ConfigProperty)) continue;
                    this.ips.add(beanInjectionPoint);
                }
            }
        }
    }

    private void processAnnotatedType(@Observes @WithAnnotations(value={ConfigProperties.class}) ProcessAnnotatedType<?> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        ConfigProperties configProperties = (ConfigProperties)annotatedType.getAnnotation(ConfigProperties.class);
        if (configProperties == null) {
            return;
        }
        this.configBeans.put(annotatedType.getJavaClass(), ConfigBeanDescriptor.create(annotatedType, configProperties));
        event.veto();
    }

    private <X> void harvestConfigPropertyInjectionPointsFromEnabledObserverMethod(@Observes ProcessObserverMethod<?, X> event, BeanManager beanManager) {
        List annotatedParameters;
        AnnotatedMethod annotatedMethod = event.getAnnotatedMethod();
        if (annotatedMethod != null && !annotatedMethod.getDeclaringType().isAnnotationPresent(Vetoed.class) && (annotatedParameters = annotatedMethod.getParameters()) != null) {
            block0: for (AnnotatedParameter annotatedParameter : annotatedParameters) {
                if (annotatedParameter == null || annotatedParameter.isAnnotationPresent(Observes.class)) continue;
                InjectionPoint injectionPoint = beanManager.createInjectionPoint(annotatedParameter);
                Set qualifiers = injectionPoint.getQualifiers();
                assert (qualifiers != null);
                for (Annotation qualifier : qualifiers) {
                    if (!(qualifier instanceof ConfigProperty)) continue;
                    this.ips.add(injectionPoint);
                    continue block0;
                }
            }
        }
    }

    private void registerConfigProducer(@Observes AfterBeanDiscovery abd) {
        abd.addBean().addTransitiveTypeClosure(org.eclipse.microprofile.config.Config.class).beanClass(org.eclipse.microprofile.config.Config.class).scope(ApplicationScoped.class).createWith(creationalContext -> new SerializableConfig());
        abd.addBean().addTransitiveTypeClosure(Config.class).beanClass(Config.class).scope(ApplicationScoped.class).createWith(creationalContext -> {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (config instanceof Config) {
                return config;
            }
            return MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)config);
        });
        Set<Type> types = this.ips.stream().map(InjectionPoint::getType).map(it -> {
            Class clazz;
            if (it instanceof Class && (clazz = (Class)it).isPrimitive()) {
                return REPLACED_TYPES.getOrDefault(clazz, clazz);
            }
            return it;
        }).collect(Collectors.toSet());
        types.forEach(type -> abd.addBean().addType(type).scope(Dependent.class).addQualifier(CONFIG_PROPERTY_LITERAL).produceWith(it -> this.produce((InjectionPoint)it.select(InjectionPoint.class, new Annotation[0]).get())));
        this.configBeans.values().forEach(beanDescriptor -> abd.addBean().addType(beanDescriptor.type()).addTransitiveTypeClosure(beanDescriptor.type()).qualifiers(new Annotation[]{ConfigProperties.Literal.NO_PREFIX}).scope(Dependent.class).produceWith(it -> beanDescriptor.produce((InjectionPoint)it.select(InjectionPoint.class, new Annotation[0]).get(), ConfigProvider.getConfig())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(@Observes AfterDeploymentValidation add, BeanManager beanManager) {
        CreationalContext cc = beanManager.createCreationalContext(null);
        try {
            this.ips.forEach(ip -> {
                try {
                    beanManager.getInjectableReference(ip, cc);
                }
                catch (NoSuchElementException e) {
                    add.addDeploymentProblem((Throwable)new ConfigException("Failed to validate injection point: " + String.valueOf(ip), (Throwable)e));
                }
                catch (Exception e) {
                    add.addDeploymentProblem((Throwable)e);
                }
            });
        }
        finally {
            cc.release();
        }
        this.ips.clear();
    }

    private Object produce(InjectionPoint ip) {
        ConfigProperty annotation = (ConfigProperty)ip.getAnnotated().getAnnotation(ConfigProperty.class);
        String injectedName = ConfigCdiExtension.injectedName(ip);
        String fullPath = ip.getMember().getDeclaringClass().getName() + "." + injectedName;
        String configKey = this.configKey(annotation, fullPath);
        if (NativeImageHelper.isBuildTime()) {
            System.err.println("You are accessing configuration key '" + configKey + "' during container initialization. This will not work nicely with Graal native-image");
        }
        return this.produce(configKey, ip.getType(), this.defaultValue(annotation), configKey.equals(fullPath.replace('$', '.')));
    }

    private Object produce(String configKey, Type type, String defaultValue, boolean defaultConfigKey) {
        FieldTypes fieldTypes = FieldTypes.create(type);
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        try {
            config = (org.eclipse.microprofile.config.Config)config.unwrap(org.eclipse.microprofile.config.Config.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fieldTypes.field0().rawType().equals(ConfigValue.class)) {
            ConfigValue configValue = config.getConfigValue(configKey);
            if (defaultValue != null && configValue.getValue() == null) {
                return new DefaultConfigValue(configKey, defaultValue);
            }
            return configValue;
        }
        Object value = this.configValue(config, fieldTypes, configKey, defaultValue, defaultConfigKey);
        if (value == null) {
            throw new NoSuchElementException("Cannot find value for key: " + configKey);
        }
        return value;
    }

    private Object configValue(org.eclipse.microprofile.config.Config config, FieldTypes fieldTypes, String configKey, String defaultValue, boolean defaultConfigKey) {
        Class<?> type0 = fieldTypes.field0().rawType();
        Class<?> type1 = fieldTypes.field1().rawType();
        Class<?> type2 = fieldTypes.field2().rawType();
        if (type0.equals(type1)) {
            return ConfigCdiExtension.withDefault(config, configKey, type0, defaultValue, true);
        }
        return ConfigCdiExtension.parameterizedConfigValue(config, configKey, defaultConfigKey, defaultValue, type0, type1, type2);
    }

    private static <T> T withDefault(org.eclipse.microprofile.config.Config config, String key, Class<T> type, String configuredDefault, boolean required) {
        String defaultValue;
        String string = defaultValue = configuredDefault == null || configuredDefault.isEmpty() ? null : configuredDefault;
        if (OptionalInt.class.equals(type)) {
            return type.cast(config.getOptionalValue(key, Integer.class).map(OptionalInt::of).orElseGet(OptionalInt::empty));
        }
        if (OptionalLong.class.equals(type)) {
            return type.cast(config.getOptionalValue(key, Long.class).map(OptionalLong::of).orElseGet(OptionalLong::empty));
        }
        if (OptionalDouble.class.equals(type)) {
            return type.cast(config.getOptionalValue(key, Double.class).map(OptionalDouble::of).orElseGet(OptionalDouble::empty));
        }
        Optional stringValue = config.getOptionalValue(key, String.class);
        if (stringValue.isEmpty()) {
            return ConfigCdiExtension.convert(key, config, defaultValue, type);
        }
        Converter converter = (Converter)config.getConverter(type).orElseThrow(() -> new IllegalArgumentException("There is no converter for type \"" + type.getName() + "\""));
        Object value = converter.convert((String)stringValue.get());
        if (value == null && required) {
            throw new NoSuchElementException("Converter returned null for a required property. This is not allowed as per section 6.4. of the specification. Key: " + key + ", configured value: " + String.valueOf(stringValue) + ", converter: " + converter.getClass().getName());
        }
        return (T)value;
    }

    private static <T> T convert(String key, org.eclipse.microprofile.config.Config config, String value, Class<T> type) {
        if (null == value) {
            return null;
        }
        if (String.class.equals(type)) {
            return (T)value;
        }
        return (T)((Converter)config.getConverter(type).orElseThrow(() -> new IllegalArgumentException("Did not find converter for type " + type.getName() + ", for key " + key))).convert(value);
    }

    private static Object parameterizedConfigValue(org.eclipse.microprofile.config.Config config, String configKey, boolean defaultConfigKey, String defaultValue, Class<?> rawType, Class<?> typeArg, Class<?> typeArg2) {
        if (Optional.class.isAssignableFrom(rawType)) {
            if (typeArg.equals(typeArg2)) {
                return Optional.ofNullable(ConfigCdiExtension.withDefault(config, configKey, typeArg, defaultValue, false));
            }
            return Optional.ofNullable(ConfigCdiExtension.parameterizedConfigValue(config, configKey, defaultConfigKey, defaultValue, typeArg, typeArg2, typeArg2));
        }
        if (List.class.isAssignableFrom(rawType)) {
            return ConfigCdiExtension.asList(config, configKey, typeArg, defaultValue);
        }
        if (Supplier.class.isAssignableFrom(rawType)) {
            if (typeArg.equals(typeArg2)) {
                return () -> ConfigCdiExtension.withDefault(config, configKey, typeArg, defaultValue, true);
            }
            return () -> ConfigCdiExtension.parameterizedConfigValue(config, configKey, defaultConfigKey, defaultValue, typeArg, typeArg2, typeArg2);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            HashMap result = new HashMap();
            config.getPropertyNames().forEach(name -> {
                if (defaultConfigKey || name.startsWith(configKey)) {
                    String key = ConfigCdiExtension.removePrefix(configKey, defaultConfigKey, name);
                    config.getOptionalValue(name, String.class).ifPresent(value -> result.put(key, value));
                }
            });
            return result;
        }
        if (Set.class.isAssignableFrom(rawType)) {
            return new LinkedHashSet(ConfigCdiExtension.asList(config, configKey, typeArg, defaultValue));
        }
        throw new IllegalArgumentException("Cannot create config property for " + String.valueOf(rawType) + "<" + String.valueOf(typeArg) + ">, key: " + configKey);
    }

    private static String removePrefix(String prefix, boolean defaultConfigKey, String key) {
        if (defaultConfigKey) {
            return key;
        }
        String intermediate = key.substring(prefix.length());
        if (intermediate.startsWith(".")) {
            return intermediate.substring(1);
        }
        return intermediate;
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = ESCAPED_COMMA_PATTERN.matcher(value).replaceAll(Matcher.quoteReplacement(","));
        }
        return values;
    }

    private static <T> List<T> asList(org.eclipse.microprofile.config.Config config, String configKey, Class<T> typeArg, String defaultValue) {
        Optional optionalValue = config.getOptionalValue(configKey, String.class);
        if (optionalValue.isPresent()) {
            return ConfigCdiExtension.toList(configKey, config, (String)optionalValue.get(), typeArg);
        }
        String indexedConfigKey = configKey + ".0";
        optionalValue = config.getOptionalValue(indexedConfigKey, String.class);
        if (optionalValue.isPresent()) {
            LinkedList<T> result = new LinkedList<T>();
            result.add(ConfigCdiExtension.convert(indexedConfigKey, config, (String)optionalValue.get(), typeArg));
            for (int i = 1; i < 1000 && (optionalValue = config.getOptionalValue(indexedConfigKey = configKey + "." + i, String.class)).isPresent(); ++i) {
                result.add(ConfigCdiExtension.convert(indexedConfigKey, config, (String)optionalValue.get(), typeArg));
            }
            return result;
        }
        if (null == defaultValue) {
            throw new NoSuchElementException("Missing list value for key " + configKey);
        }
        return ConfigCdiExtension.toList(configKey, config, defaultValue, typeArg);
    }

    private static <T> List<T> toList(String configKey, org.eclipse.microprofile.config.Config config, String stringValue, Class<T> typeArg) {
        if (stringValue.isEmpty()) {
            return List.of();
        }
        LinkedList<T> result = new LinkedList<T>();
        for (String value : ConfigCdiExtension.toArray(stringValue)) {
            result.add(ConfigCdiExtension.convert(configKey, config, value, typeArg));
        }
        return result;
    }

    private String defaultValue(ConfigProperty annotation) {
        String defaultFromAnnotation = annotation.defaultValue();
        if (defaultFromAnnotation.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
            return null;
        }
        return defaultFromAnnotation;
    }

    private String configKey(ConfigProperty annotation, String fullPath) {
        String keyFromAnnotation = annotation.name();
        if (keyFromAnnotation.isEmpty()) {
            return fullPath.replace('$', '.');
        }
        return keyFromAnnotation;
    }

    private static String injectedName(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            AnnotatedField f = (AnnotatedField)annotated;
            return f.getJavaMember().getName();
        }
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter p = (AnnotatedParameter)annotated;
            Member member = ip.getMember();
            if (member instanceof Method) {
                return member.getName() + "_" + p.getPosition();
            }
            if (member instanceof Constructor) {
                return "new_" + p.getPosition();
            }
        }
        return ip.getMember().getName();
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }
}

