/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.MetricsCdiExtension;
import io.helidon.microprofile.metrics.MetricsInterceptorBase;
import io.helidon.microprofile.metrics.SyntheticRestRequest;
import io.helidon.microprofile.metrics.SyntheticRestRequestWorkItem;
import io.helidon.microprofile.servicecommon.HelidonInterceptor;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.observe.metrics.PostRequestMetricsSupport;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.core.Context;
import java.lang.reflect.Executable;
import java.time.Duration;
import org.eclipse.microprofile.metrics.Metric;

@SyntheticRestRequest
@Interceptor
@Priority(value=10)
final class InterceptorSyntheticRestRequest
extends HelidonInterceptor.Base<SyntheticRestRequestWorkItem>
implements HelidonInterceptor<SyntheticRestRequestWorkItem> {
    private static final System.Logger LOGGER = System.getLogger(InterceptorSyntheticRestRequest.class.getName());
    private long startNanos;
    @Inject
    private MetricsCdiExtension extension;
    @Context
    private ServerRequest request;

    InterceptorSyntheticRestRequest() {
    }

    public Iterable<SyntheticRestRequestWorkItem> workItems(Executable executable) {
        return this.extension.workItems(executable, SyntheticRestRequest.class, SyntheticRestRequestWorkItem.class);
    }

    public void preInvocation(InvocationContext context, SyntheticRestRequestWorkItem workItem) {
        MetricsInterceptorBase.verifyMetric(workItem.successfulTimerMetricID(), (Metric)workItem.successfulTimer());
        MetricsInterceptorBase.verifyMetric(workItem.unmappedExceptionCounterMetricID(), (Metric)workItem.unmappedExceptionCounter());
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, String.format("%s (%s) is starting processing of a REST request on %s triggered by @%s", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), MetricsInterceptorBase.ActionType.PREINVOKE, context.getMethod() != null ? context.getMethod() : context.getConstructor(), SyntheticRestRequest.class.getSimpleName()}));
        }
        PostCompletionMetricsUpdate update = new PostCompletionMetricsUpdate(workItem);
        PostRequestMetricsSupport.recordPostProcessingWork((ServerRequest)this.request, update::updateRestRequestMetrics);
        this.startNanos = System.nanoTime();
    }

    private class PostCompletionMetricsUpdate {
        private final SyntheticRestRequestWorkItem workItem;

        private PostCompletionMetricsUpdate(SyntheticRestRequestWorkItem workItem) {
            this.workItem = workItem;
        }

        void updateRestRequestMetrics(ServerResponse serverResponse, Throwable throwable) {
            long endNanos = System.nanoTime();
            if (throwable == null) {
                long elapsedNanos = endNanos > InterceptorSyntheticRestRequest.this.startNanos ? endNanos - InterceptorSyntheticRestRequest.this.startNanos : 1L;
                this.workItem.successfulTimer().update(Duration.ofNanos(elapsedNanos));
            } else {
                this.workItem.unmappedExceptionCounter().inc();
            }
        }
    }
}

