/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.uri.UriInfo;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Header;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.http.RoutedPath;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.ProxyProtocolData;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1Connection;
import io.helidon.webserver.http1.Http1ServerRequestNoEntity;
import io.helidon.webserver.http1.Http1ServerRequestWithEntity;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;

abstract class Http1ServerRequest
implements RoutingRequest {
    private static final RequestedUriDiscoveryContext DEFAULT_REQUESTED_URI_DISCOVERY_CONTEXT = RequestedUriDiscoveryContext.builder().build();
    private final ServerRequestHeaders headers;
    private final ConnectionContext ctx;
    private final HttpSecurity security;
    private final int requestId;
    private final LazyValue<UriInfo> uriInfo = LazyValue.create(this::createUriInfo);
    private RoutedPath path;
    private WritableHeaders<?> writable;
    private HttpPrologue prologue;
    private Context context;

    Http1ServerRequest(ConnectionContext ctx, HttpSecurity security, HttpPrologue prologue, Headers headers, int requestId) {
        this.ctx = ctx;
        this.security = security;
        this.headers = ServerRequestHeaders.create((Headers)headers);
        this.requestId = requestId;
        this.prologue = prologue;
    }

    static Http1ServerRequest create(ConnectionContext ctx, HttpSecurity security, HttpPrologue prologue, Headers headers, int requestId) {
        return new Http1ServerRequestNoEntity(ctx, security, prologue, headers, requestId);
    }

    static Http1ServerRequest create(ConnectionContext ctx, Http1Connection connection, Http1Config http1Config, HttpSecurity security, HttpPrologue prologue, ServerRequestHeaders headers, ContentDecoder decoder, int requestId, boolean expectContinue, CountDownLatch entityReadLatch, Supplier<BufferData> entitySupplier) {
        return new Http1ServerRequestWithEntity(ctx, connection, http1Config, security, prologue, headers, decoder, requestId, expectContinue, entityReadLatch, entitySupplier);
    }

    @Override
    public boolean isSecure() {
        return this.ctx.isSecure();
    }

    @Override
    public RoutedPath path() {
        return this.path;
    }

    @Override
    public String socketId() {
        return this.ctx.childSocketId();
    }

    @Override
    public String serverSocketId() {
        return this.ctx.socketId();
    }

    @Override
    public Context context() {
        if (this.context == null) {
            this.context = Contexts.context().orElseGet(() -> Context.builder().parent(this.ctx.listenerContext().context()).id("[" + this.serverSocketId() + " " + this.socketId() + "] http/1.1: " + this.requestId).build());
        }
        return this.context;
    }

    @Override
    public ListenerContext listenerContext() {
        return this.ctx.listenerContext();
    }

    @Override
    public HttpSecurity security() {
        return this.security;
    }

    @Override
    public HttpPrologue prologue() {
        return this.prologue;
    }

    @Override
    public ServerRequestHeaders headers() {
        return this.writable == null ? this.headers : ServerRequestHeaders.create(this.writable);
    }

    @Override
    public UriQuery query() {
        return this.prologue().query();
    }

    @Override
    public PeerInfo remotePeer() {
        return this.ctx.remotePeer();
    }

    @Override
    public PeerInfo localPeer() {
        return this.ctx.localPeer();
    }

    @Override
    public String authority() {
        return this.headers.get(HeaderNames.HOST).value();
    }

    @Override
    public void header(Header header) {
        if (this.writable == null) {
            this.writable = WritableHeaders.create((Headers)this.headers);
        }
        this.writable.set(header);
    }

    @Override
    public int id() {
        return this.requestId;
    }

    @Override
    public Http1ServerRequest path(RoutedPath routedPath) {
        this.path = routedPath;
        return this;
    }

    @Override
    public Http1ServerRequest prologue(HttpPrologue newPrologue) {
        this.prologue = newPrologue;
        return this;
    }

    @Override
    public UriInfo requestedUri() {
        return (UriInfo)this.uriInfo.get();
    }

    @Override
    public Optional<ProxyProtocolData> proxyProtocolData() {
        return this.ctx.proxyProtocolData();
    }

    private UriInfo createUriInfo() {
        return this.ctx.listenerContext().config().requestedUriDiscoveryContext().orElse(DEFAULT_REQUESTED_URI_DISCOVERY_CONTEXT).uriInfo(this.remotePeer().address().toString(), this.localPeer().address().toString(), this.path.absolute().path(), this.headers, this.query(), this.isSecure());
    }
}

