/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webserver.observe.ObserverConfigBaseBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.observe.ObserverConfigBaseBlueprint")
public interface ObserverConfigBase
extends ObserverConfigBaseBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObserverConfigBase instance) {
        return (Builder)ObserverConfigBase.builder().from(instance);
    }

    public static class Builder
    extends BuilderBase<Builder, ObserverConfigBase>
    implements io.helidon.common.Builder<Builder, ObserverConfigBase> {
        Builder() {
        }

        public ObserverConfigBase buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ObserverConfigBaseImpl(this);
        }

        public ObserverConfigBase build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ObserverConfigBase>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enabled = true;
        private Config config;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(ObserverConfigBase prototype) {
            this.enabled(prototype.enabled());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            builder.name().ifPresent(this::name);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ObserverConfigBaseBuilder{enabled=" + this.enabled + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" is required, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ObserverConfigBaseImpl
        implements ObserverConfigBase {
            private final boolean enabled;
            private final String name;

            protected ObserverConfigBaseImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.name = builder.name().get();
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                return "ObserverConfigBase{enabled=" + this.enabled + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ObserverConfigBase)) {
                    return false;
                }
                ObserverConfigBase other = (ObserverConfigBase)o;
                return this.enabled == other.enabled() && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.name);
            }
        }
    }
}

