/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type;

import io.hypersistence.utils.hibernate.type.array.BooleanArrayType;
import io.hypersistence.utils.hibernate.type.array.DateArrayType;
import io.hypersistence.utils.hibernate.type.array.DecimalArrayType;
import io.hypersistence.utils.hibernate.type.array.DoubleArrayType;
import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateTimeArrayType;
import io.hypersistence.utils.hibernate.type.array.LongArrayType;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.type.array.TimestampArrayType;
import io.hypersistence.utils.hibernate.type.array.UUIDArrayType;
import io.hypersistence.utils.hibernate.type.basic.Iso8601MonthType;
import io.hypersistence.utils.hibernate.type.basic.MonthDayDateType;
import io.hypersistence.utils.hibernate.type.basic.MonthDayIntegerType;
import io.hypersistence.utils.hibernate.type.basic.NullableCharacterType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLEnumType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLHStoreType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLInetType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthDateType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthEpochType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthIntegerType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthTimestampType;
import io.hypersistence.utils.hibernate.type.interval.OracleIntervalDayToSecondType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLIntervalType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLPeriodType;
import io.hypersistence.utils.hibernate.type.json.JsonNodeStringType;
import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        boolean enableJson;
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Dialect dialect = jdbcServices.getDialect();
        boolean bl = enableJson = ReflectionUtils.getClassOrNull("com.fasterxml.jackson.databind.ObjectMapper") != null;
        if (dialect instanceof PostgreSQLDialect) {
            typeContributions.contributeType((UserType)BooleanArrayType.INSTANCE);
            typeContributions.contributeType((UserType)DateArrayType.INSTANCE);
            typeContributions.contributeType((UserType)DecimalArrayType.INSTANCE);
            typeContributions.contributeType((UserType)DoubleArrayType.INSTANCE);
            typeContributions.contributeType((UserType)EnumArrayType.INSTANCE);
            typeContributions.contributeType((UserType)IntArrayType.INSTANCE);
            typeContributions.contributeType((UserType)LocalDateArrayType.INSTANCE);
            typeContributions.contributeType((UserType)LocalDateTimeArrayType.INSTANCE);
            typeContributions.contributeType((UserType)LongArrayType.INSTANCE);
            typeContributions.contributeType((UserType)StringArrayType.INSTANCE);
            typeContributions.contributeType((UserType)TimestampArrayType.INSTANCE);
            typeContributions.contributeType((UserType)UUIDArrayType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLIntervalType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLPeriodType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLEnumType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLHStoreType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLInetType.INSTANCE);
            typeContributions.contributeType((UserType)PostgreSQLRangeType.INSTANCE);
            if (ReflectionUtils.getClassOrNull("com.google.common.collect.Range") != null) {
                typeContributions.contributeType((UserType)PostgreSQLGuavaRangeType.INSTANCE);
            }
        } else if (dialect instanceof MySQLDialect) {
            if (enableJson) {
                typeContributions.contributeType((UserType)JsonNodeStringType.INSTANCE);
            }
        } else if (dialect instanceof OracleDialect) {
            typeContributions.contributeType((UserType)OracleIntervalDayToSecondType.INSTANCE);
        }
        typeContributions.contributeType((UserType)NullableCharacterType.INSTANCE);
        typeContributions.contributeType((UserType)Iso8601MonthType.INSTANCE);
        typeContributions.contributeType((UserType)MonthDayDateType.INSTANCE);
        typeContributions.contributeType((UserType)MonthDayIntegerType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthDateType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthEpochType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthIntegerType.INSTANCE);
        typeContributions.contributeType((UserType)YearMonthTimestampType.INSTANCE);
    }
}

