/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.internal;

import io.hypersistence.utils.hibernate.type.json.internal.JdbcTypeSetter;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperWrapper;
import io.hypersistence.utils.hibernate.util.LogUtils;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BlobJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.usertype.DynamicParameterizedType;

public class JsonJavaTypeDescriptor
extends AbstractClassJavaType<Object>
implements DynamicParameterizedType,
JdbcTypeSetter {
    private Type propertyType;
    private Class propertyClass;
    private ObjectMapperWrapper objectMapperWrapper;
    private JdbcType jdbcType;
    private static List<Class> validatedTypes = new ArrayList<Class>();

    public JsonJavaTypeDescriptor() {
        this((Type)((Object)Object.class));
    }

    public JsonJavaTypeDescriptor(Type type) {
        this((Class)type, ObjectMapperWrapper.INSTANCE);
    }

    public JsonJavaTypeDescriptor(Class clazz, final ObjectMapperWrapper objectMapperWrapper) {
        super(clazz, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

            protected Object deepCopyNotNull(Object value) {
                return objectMapperWrapper.clone(value);
            }
        });
        this.objectMapperWrapper = objectMapperWrapper;
        this.setPropertyClass(clazz);
    }

    public JsonJavaTypeDescriptor(ObjectMapperWrapper objectMapperWrapper) {
        this(Object.class, objectMapperWrapper);
    }

    public JsonJavaTypeDescriptor(ObjectMapperWrapper objectMapperWrapper, Type type) {
        this((Class)type, objectMapperWrapper);
        this.setPropertyClass(type);
    }

    public void setParameterValues(Properties parameters) {
        XProperty xProperty = (XProperty)parameters.get("org.hibernate.type.ParameterType.xproperty");
        Class type = null;
        if (xProperty instanceof JavaXMember) {
            type = ((JavaXMember)xProperty).getJavaType();
        } else {
            Object parameterType = parameters.get("org.hibernate.type.ParameterType");
            if (parameterType instanceof DynamicParameterizedType.ParameterType) {
                type = ((DynamicParameterizedType.ParameterType)parameterType).getReturnedClass();
            } else if (parameterType instanceof String) {
                type = ReflectionUtils.getClass((String)parameterType);
            }
        }
        if (type == null) {
            throw new HibernateException("Could not resolve property type!");
        }
        this.setPropertyClass(type);
    }

    public boolean areEqual(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one instanceof String && another instanceof String) {
            return one.equals(another);
        }
        if (one instanceof Collection && another instanceof Collection || one instanceof Map && another instanceof Map) {
            return Objects.equals(one, another);
        }
        if (one.getClass().equals(another.getClass()) && ReflectionUtils.getDeclaredMethodOrNull(one.getClass(), "equals", Object.class) != null) {
            return one.equals(another);
        }
        return this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(one)).equals((Object)this.objectMapperWrapper.toJsonNode(this.objectMapperWrapper.toString(another)));
    }

    public String toString(Object value) {
        return this.objectMapperWrapper.toString(value);
    }

    public Object fromString(CharSequence string) {
        if (this.propertyClass == null) {
            throw new HibernateException("The propertyClass in JsonTypeDescriptor is null, hence it doesn't know to what Java Object type to map the JSON column value that was read from the database!");
        }
        if (String.class.isAssignableFrom(this.propertyClass)) {
            return string;
        }
        return this.objectMapperWrapper.fromString((String)string, this.propertyType);
    }

    public <X> X unwrap(Object value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)(value instanceof String ? value : this.toString(value));
        }
        if (BinaryStream.class.isAssignableFrom(type) || byte[].class.isAssignableFrom(type)) {
            String stringValue = value instanceof String ? (String)value : this.toString(value);
            return (X)new BinaryStreamImpl(DataHelper.extractBytes((InputStream)new ByteArrayInputStream(stringValue.getBytes())));
        }
        if (Blob.class.isAssignableFrom(type)) {
            String stringValue = value instanceof String ? (String)value : this.toString(value);
            Blob blob = BlobJavaType.INSTANCE.fromString((CharSequence)stringValue);
            return (X)blob;
        }
        if (Object.class.isAssignableFrom(type)) {
            String stringValue = value instanceof String ? (String)value : this.toString(value);
            return (X)this.objectMapperWrapper.toJsonNode(stringValue);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> Object wrap(X value, WrapperOptions options) {
        String stringValue;
        if (value == null) {
            return null;
        }
        Blob blob = null;
        if (Blob.class.isAssignableFrom(value.getClass())) {
            blob = options.getLobCreator().wrap((Blob)value);
        } else if (byte[].class.isAssignableFrom(value.getClass())) {
            blob = options.getLobCreator().createBlob((byte[])value);
        } else if (InputStream.class.isAssignableFrom(value.getClass())) {
            InputStream inputStream = (InputStream)value;
            try {
                blob = options.getLobCreator().createBlob(inputStream, (long)inputStream.available());
            }
            catch (IOException e) {
                throw this.unknownWrap(value.getClass());
            }
        }
        try {
            stringValue = blob != null ? new String(DataHelper.extractBytes((InputStream)blob.getBinaryStream())) : value.toString();
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to extract binary stream from Blob", (Throwable)e);
        }
        return this.fromString(stringValue);
    }

    private void setPropertyClass(Type type) {
        this.propertyType = type;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)((Object)type)).getRawType();
        } else if (type instanceof TypeVariable) {
            type = ((TypeVariable)((Object)type)).getGenericDeclaration().getClass();
        }
        this.propertyClass = type;
        this.validatePropertyType();
    }

    private void validatePropertyType() {
        if (Collection.class.isAssignableFrom(this.propertyClass) && this.propertyType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.propertyType;
            for (Class genericType : ReflectionUtils.getGenericTypes(parameterizedType)) {
                if (validatedTypes.contains(genericType)) continue;
                validatedTypes.add(genericType);
                Method equalsMethod = ReflectionUtils.getMethodOrNull(genericType, "equals", Object.class);
                Method hashCodeMethod = ReflectionUtils.getMethodOrNull(genericType, "hashCode", new Class[0]);
                if (equalsMethod != null && hashCodeMethod != null && !Object.class.equals(equalsMethod.getDeclaringClass()) && !Object.class.equals(hashCodeMethod.getDeclaringClass())) continue;
                LogUtils.LOGGER.warn("The {} class should override both the equals and hashCode methods based on the JSON object value it represents!", (Object)genericType);
            }
        }
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return this.jdbcType;
    }

    @Override
    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }
}

