package com.outsystems.plugins.barcode.controller

import android.graphics.Bitmap
import androidx.camera.core.ImageProxy
import com.outsystems.plugins.barcode.model.OSBARCError
import com.outsystems.plugins.barcode.model.OSBARCScanResult

/**
 * Interface that provides the signature of the scanBarcode method
 */
fun interface OSBARCScanLibraryInterface {
    fun scanBarcode(
        imageProxy: ImageProxy,
        imageBitmap: Bitmap,
        onSuccess: (OSBARCScanResult) -> Unit,
        onError: (OSBARCError) -> Unit
    )
}