/*
 * Decompiled with CFR 0.152.
 */
package com.outsystems.plugins.barcode.controller;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.compose.runtime.internal.StabilityInferred;
import com.outsystems.plugins.barcode.controller.OSBARCScanLibraryInterface;
import com.outsystems.plugins.barcode.controller.helper.OSBARCImageHelperInterface;
import com.outsystems.plugins.barcode.model.OSBARCError;
import com.outsystems.plugins.barcode.model.OSBARCScanResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/outsystems/plugins/barcode/controller/OSBARCBarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "scanLibrary", "Lcom/outsystems/plugins/barcode/controller/OSBARCScanLibraryInterface;", "imageHelper", "Lcom/outsystems/plugins/barcode/controller/helper/OSBARCImageHelperInterface;", "onBarcodeScanned", "Lkotlin/Function1;", "Lcom/outsystems/plugins/barcode/model/OSBARCScanResult;", "", "onScanningError", "Lcom/outsystems/plugins/barcode/model/OSBARCError;", "(Lcom/outsystems/plugins/barcode/controller/OSBARCScanLibraryInterface;Lcom/outsystems/plugins/barcode/controller/helper/OSBARCImageHelperInterface;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "isPortrait", "", "()Z", "setPortrait", "(Z)V", "analyze", "image", "Landroidx/camera/core/ImageProxy;", "cropBitmap", "Landroid/graphics/Bitmap;", "bitmap", "Companion", "OSBarcodeLib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOSBARCBarcodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSBARCBarcodeAnalyzer.kt\ncom/outsystems/plugins/barcode/controller/OSBARCBarcodeAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class OSBARCBarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OSBARCScanLibraryInterface scanLibrary;
    @NotNull
    private final OSBARCImageHelperInterface imageHelper;
    @NotNull
    private final Function1<OSBARCScanResult, Unit> onBarcodeScanned;
    @NotNull
    private final Function1<OSBARCError, Unit> onScanningError;
    private boolean isPortrait;
    public static final int $stable = 8;
    @NotNull
    private static final String LOG_TAG = "OSBARCBarcodeAnalyzer";

    public OSBARCBarcodeAnalyzer(@NotNull OSBARCScanLibraryInterface scanLibrary, @NotNull OSBARCImageHelperInterface imageHelper, @NotNull Function1<? super OSBARCScanResult, Unit> onBarcodeScanned, @NotNull Function1<? super OSBARCError, Unit> onScanningError) {
        Intrinsics.checkNotNullParameter((Object)scanLibrary, (String)"scanLibrary");
        Intrinsics.checkNotNullParameter((Object)imageHelper, (String)"imageHelper");
        Intrinsics.checkNotNullParameter(onBarcodeScanned, (String)"onBarcodeScanned");
        Intrinsics.checkNotNullParameter(onScanningError, (String)"onScanningError");
        this.scanLibrary = scanLibrary;
        this.imageHelper = imageHelper;
        this.onBarcodeScanned = onBarcodeScanned;
        this.onScanningError = onScanningError;
        this.isPortrait = true;
    }

    public final boolean isPortrait() {
        return this.isPortrait;
    }

    public final void setPortrait(boolean bl) {
        this.isPortrait = bl;
    }

    public void analyze(@NotNull ImageProxy image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        try {
            Bitmap bitmap = image.toBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"toBitmap(...)");
            this.scanLibrary.scanBarcode(image, this.cropBitmap(bitmap), (Function1<? super OSBARCScanResult, Unit>)((Function1)new Function1<OSBARCScanResult, Unit>(this){
                final /* synthetic */ OSBARCBarcodeAnalyzer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull OSBARCScanResult it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    OSBARCBarcodeAnalyzer.access$getOnBarcodeScanned$p(this.this$0).invoke((Object)it);
                }
            }), (Function1<? super OSBARCError, Unit>)((Function1)new Function1<OSBARCError, Unit>(this){
                final /* synthetic */ OSBARCBarcodeAnalyzer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull OSBARCError it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    OSBARCBarcodeAnalyzer.access$getOnScanningError$p(this.this$0).invoke((Object)((Object)it));
                }
            }));
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.e((String)LOG_TAG, (String)it);
            }
            this.onScanningError.invoke((Object)OSBARCError.SCANNING_GENERAL_ERROR);
        }
        image.close();
    }

    private final Bitmap cropBitmap(Bitmap bitmap) {
        int rectWidth = 0;
        int rectHeight = 0;
        if (this.isPortrait) {
            rectHeight = rectWidth = (int)((double)bitmap.getHeight() * 0.6);
        } else {
            rectWidth = (int)((double)bitmap.getWidth() * 0.6);
            rectHeight = (int)((double)bitmap.getHeight() * 0.5);
        }
        int rectLeft = (bitmap.getWidth() - rectWidth) / 2;
        int rectTop = (bitmap.getHeight() - rectHeight) / 2;
        return this.imageHelper.createSubsetBitmapFromSource(bitmap, rectLeft, rectTop, rectWidth, rectHeight);
    }

    public static final /* synthetic */ Function1 access$getOnBarcodeScanned$p(OSBARCBarcodeAnalyzer $this) {
        return $this.onBarcodeScanned;
    }

    public static final /* synthetic */ Function1 access$getOnScanningError$p(OSBARCBarcodeAnalyzer $this) {
        return $this.onScanningError;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/outsystems/plugins/barcode/controller/OSBARCBarcodeAnalyzer$Companion;", "", "()V", "LOG_TAG", "", "OSBarcodeLib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

