/*
 * Decompiled with CFR 0.152.
 */
package com.outsystems.plugins.barcode.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.IntentCompat;
import com.outsystems.plugins.barcode.model.OSBARCError;
import com.outsystems.plugins.barcode.model.OSBARCScanParameters;
import com.outsystems.plugins.barcode.model.OSBARCScanResult;
import com.outsystems.plugins.barcode.view.OSBARCScannerActivity;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\u000bJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lcom/outsystems/plugins/barcode/controller/OSBARCController;", "", "()V", "handleActivityResult", "", "requestCode", "", "resultCode", "intent", "Landroid/content/Intent;", "onSuccess", "Lkotlin/Function1;", "Lcom/outsystems/plugins/barcode/model/OSBARCScanResult;", "onError", "Lcom/outsystems/plugins/barcode/model/OSBARCError;", "scanCode", "activity", "Landroid/app/Activity;", "parameters", "Lcom/outsystems/plugins/barcode/model/OSBARCScanParameters;", "Companion", "OSBarcodeLib_release"})
@StabilityInferred(parameters=1)
public final class OSBARCController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final int SCAN_REQUEST_CODE = 112;
    @NotNull
    private static final String SCAN_PARAMETERS = "SCAN_PARAMETERS";
    @NotNull
    private static final String SCAN_RESULT = "scanResult";
    @NotNull
    private static final String LOG_TAG = "OSBARCController";

    public final void scanCode(@NotNull Activity activity, @NotNull OSBARCScanParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        activity.startActivityForResult(new Intent((Context)activity, OSBARCScannerActivity.class).putExtra(SCAN_PARAMETERS, (Serializable)parameters), 112);
    }

    public final void handleActivityResult(int requestCode, int resultCode, @Nullable Intent intent, @NotNull Function1<? super OSBARCScanResult, Unit> onSuccess, @NotNull Function1<? super OSBARCError, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        if (requestCode == 112) {
            int n = resultCode;
            if (n == -1) {
                OSBARCScanResult result;
                OSBARCScanResult oSBARCScanResult;
                Intent intent2 = intent;
                if (intent2 != null) {
                    Intent it = intent2;
                    boolean bl = false;
                    oSBARCScanResult = (OSBARCScanResult)IntentCompat.getSerializableExtra((Intent)intent, (String)SCAN_RESULT, OSBARCScanResult.class);
                } else {
                    oSBARCScanResult = result = null;
                }
                if (result == null || ((CharSequence)result.getText()).length() == 0) {
                    onError.invoke((Object)OSBARCError.SCANNING_GENERAL_ERROR);
                    return;
                }
                onSuccess.invoke((Object)result);
            } else if (n == 0) {
                onError.invoke((Object)OSBARCError.SCAN_CANCELLED_ERROR);
            } else if (n == OSBARCError.SCAN_CANCELLED_ERROR.getCode()) {
                onError.invoke((Object)OSBARCError.SCAN_CANCELLED_ERROR);
            } else if (n == OSBARCError.CAMERA_PERMISSION_DENIED_ERROR.getCode()) {
                onError.invoke((Object)OSBARCError.CAMERA_PERMISSION_DENIED_ERROR);
            } else if (n == OSBARCError.SCANNING_GENERAL_ERROR.getCode()) {
                onError.invoke((Object)OSBARCError.SCANNING_GENERAL_ERROR);
            } else if (n == OSBARCError.ZXING_LIBRARY_ERROR.getCode()) {
                onError.invoke((Object)OSBARCError.ZXING_LIBRARY_ERROR);
            } else if (n == OSBARCError.MLKIT_LIBRARY_ERROR.getCode()) {
                onError.invoke((Object)OSBARCError.MLKIT_LIBRARY_ERROR);
            } else {
                Log.d((String)LOG_TAG, (String)"Invalid result code");
                onError.invoke((Object)OSBARCError.SCANNING_GENERAL_ERROR);
            }
        } else {
            Log.d((String)LOG_TAG, (String)"Invalid request code");
            onError.invoke((Object)OSBARCError.SCANNING_GENERAL_ERROR);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/outsystems/plugins/barcode/controller/OSBARCController$Companion;", "", "()V", "LOG_TAG", "", "SCAN_PARAMETERS", "SCAN_REQUEST_CODE", "", "SCAN_RESULT", "OSBarcodeLib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

