/*
 * Decompiled with CFR 0.152.
 */
package com.outsystems.plugins.barcode.controller.helper;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.outsystems.plugins.barcode.controller.helper.OSBARCZXingHelperInterface;
import com.outsystems.plugins.barcode.model.OSBARCScanResult;
import com.outsystems.plugins.barcode.model.OSBARCScannerHint;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u000e\u0010\u001b\u001a\u00020\u0003*\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001c*\u0004\u0018\u00010\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelper;", "Lcom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelperInterface;", "hint", "Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;", "(Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;)V", "reader", "Lcom/google/zxing/MultiFormatReader;", "getReader", "()Lcom/google/zxing/MultiFormatReader;", "reader$delegate", "Lkotlin/Lazy;", "decodeImage", "", "pixels", "", "width", "", "height", "onSuccess", "Lkotlin/Function1;", "Lcom/outsystems/plugins/barcode/model/OSBARCScanResult;", "onError", "Lkotlin/Function0;", "rotateBitmap", "Landroid/graphics/Bitmap;", "bitmap", "rotationDegrees", "toOSBARCScannerHint", "Lcom/google/zxing/BarcodeFormat;", "toZXingBarcodeFormat", "Companion", "OSBarcodeLib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOSBARCZXingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSBARCZXingHelper.kt\ncom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class OSBARCZXingHelper
implements OSBARCZXingHelperInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OSBARCScannerHint hint;
    @NotNull
    private final Lazy reader$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final String LOG_TAG = "OSBARCZXingHelper";

    public OSBARCZXingHelper(@Nullable OSBARCScannerHint hint) {
        this.hint = hint;
        this.reader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MultiFormatReader>(this){
            final /* synthetic */ OSBARCZXingHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MultiFormatReader invoke() {
                MultiFormatReader multiFormatReader;
                BarcodeFormat format = OSBARCZXingHelper.access$toZXingBarcodeFormat(this.this$0, OSBARCZXingHelper.access$getHint$p(this.this$0));
                MultiFormatReader $this$invoke_u24lambda_u240 = multiFormatReader = new MultiFormatReader();
                boolean bl = false;
                if (format != null) {
                    $this$invoke_u24lambda_u240.setHints(MapsKt.mapOf((Pair)TuplesKt.to((Object)DecodeHintType.POSSIBLE_FORMATS, (Object)SetsKt.setOf((Object)format))));
                }
                return multiFormatReader;
            }
        }));
    }

    private final MultiFormatReader getReader() {
        Lazy lazy = this.reader$delegate;
        return (MultiFormatReader)lazy.getValue();
    }

    @Override
    @NotNull
    public Bitmap rotateBitmap(@NotNull Bitmap bitmap, int rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotationDegrees);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        return bitmap2;
    }

    @Override
    public void decodeImage(@NotNull int[] pixels, int width, int height, @NotNull Function1<? super OSBARCScanResult, Unit> onSuccess, @NotNull Function0<Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        try {
            RGBLuminanceSource source = new RGBLuminanceSource(width, height, pixels);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            Result result = this.getReader().decodeWithState(binaryBitmap);
            String string = result.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            onSuccess.invoke((Object)new OSBARCScanResult(string, this.toOSBARCScannerHint(result.getBarcodeFormat())));
        }
        catch (NotFoundException e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.d((String)LOG_TAG, (String)it);
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.e((String)LOG_TAG, (String)it);
            }
            onError.invoke();
        }
    }

    private final BarcodeFormat toZXingBarcodeFormat(OSBARCScannerHint $this$toZXingBarcodeFormat) {
        BarcodeFormat barcodeFormat;
        OSBARCScannerHint oSBARCScannerHint = $this$toZXingBarcodeFormat;
        switch (oSBARCScannerHint == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oSBARCScannerHint.ordinal()]) {
            case 1: {
                barcodeFormat = BarcodeFormat.QR_CODE;
                break;
            }
            case 2: {
                barcodeFormat = BarcodeFormat.AZTEC;
                break;
            }
            case 3: {
                barcodeFormat = BarcodeFormat.CODABAR;
                break;
            }
            case 4: {
                barcodeFormat = BarcodeFormat.CODE_39;
                break;
            }
            case 5: {
                barcodeFormat = BarcodeFormat.CODE_93;
                break;
            }
            case 6: {
                barcodeFormat = BarcodeFormat.CODE_128;
                break;
            }
            case 7: {
                barcodeFormat = BarcodeFormat.DATA_MATRIX;
                break;
            }
            case 8: {
                barcodeFormat = BarcodeFormat.MAXICODE;
                break;
            }
            case 9: {
                barcodeFormat = BarcodeFormat.ITF;
                break;
            }
            case 10: {
                barcodeFormat = BarcodeFormat.EAN_13;
                break;
            }
            case 11: {
                barcodeFormat = BarcodeFormat.EAN_8;
                break;
            }
            case 12: {
                barcodeFormat = BarcodeFormat.PDF_417;
                break;
            }
            case 13: {
                barcodeFormat = BarcodeFormat.RSS_14;
                break;
            }
            case 14: {
                barcodeFormat = BarcodeFormat.RSS_EXPANDED;
                break;
            }
            case 15: {
                barcodeFormat = BarcodeFormat.UPC_A;
                break;
            }
            case 16: {
                barcodeFormat = BarcodeFormat.UPC_E;
                break;
            }
            case 17: {
                barcodeFormat = BarcodeFormat.UPC_EAN_EXTENSION;
                break;
            }
            case 18: {
                barcodeFormat = null;
                break;
            }
            case -1: {
                barcodeFormat = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return barcodeFormat;
    }

    private final OSBARCScannerHint toOSBARCScannerHint(BarcodeFormat $this$toOSBARCScannerHint) {
        OSBARCScannerHint oSBARCScannerHint;
        BarcodeFormat barcodeFormat = $this$toOSBARCScannerHint;
        switch (barcodeFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$1[barcodeFormat.ordinal()]) {
            case 1: {
                oSBARCScannerHint = OSBARCScannerHint.QR_CODE;
                break;
            }
            case 2: {
                oSBARCScannerHint = OSBARCScannerHint.AZTEC;
                break;
            }
            case 3: {
                oSBARCScannerHint = OSBARCScannerHint.CODABAR;
                break;
            }
            case 4: {
                oSBARCScannerHint = OSBARCScannerHint.CODE_39;
                break;
            }
            case 5: {
                oSBARCScannerHint = OSBARCScannerHint.CODE_93;
                break;
            }
            case 6: {
                oSBARCScannerHint = OSBARCScannerHint.CODE_128;
                break;
            }
            case 7: {
                oSBARCScannerHint = OSBARCScannerHint.DATA_MATRIX;
                break;
            }
            case 8: {
                oSBARCScannerHint = OSBARCScannerHint.MAXICODE;
                break;
            }
            case 9: {
                oSBARCScannerHint = OSBARCScannerHint.ITF;
                break;
            }
            case 10: {
                oSBARCScannerHint = OSBARCScannerHint.EAN_13;
                break;
            }
            case 11: {
                oSBARCScannerHint = OSBARCScannerHint.EAN_8;
                break;
            }
            case 12: {
                oSBARCScannerHint = OSBARCScannerHint.PDF_417;
                break;
            }
            case 13: {
                oSBARCScannerHint = OSBARCScannerHint.RSS_14;
                break;
            }
            case 14: {
                oSBARCScannerHint = OSBARCScannerHint.RSS_EXPANDED;
                break;
            }
            case 15: {
                oSBARCScannerHint = OSBARCScannerHint.UPC_A;
                break;
            }
            case 16: {
                oSBARCScannerHint = OSBARCScannerHint.UPC_E;
                break;
            }
            case 17: {
                oSBARCScannerHint = OSBARCScannerHint.UPC_EAN_EXTENSION;
                break;
            }
            default: {
                oSBARCScannerHint = OSBARCScannerHint.UNKNOWN;
            }
        }
        return oSBARCScannerHint;
    }

    public static final /* synthetic */ BarcodeFormat access$toZXingBarcodeFormat(OSBARCZXingHelper $this, OSBARCScannerHint $receiver) {
        return $this.toZXingBarcodeFormat($receiver);
    }

    public static final /* synthetic */ OSBARCScannerHint access$getHint$p(OSBARCZXingHelper $this) {
        return $this.hint;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/outsystems/plugins/barcode/controller/helper/OSBARCZXingHelper$Companion;", "", "()V", "LOG_TAG", "", "OSBarcodeLib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OSBARCScannerHint.values().length];
            try {
                nArray[OSBARCScannerHint.QR_CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.AZTEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.CODABAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.CODE_39.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.CODE_93.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.CODE_128.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.DATA_MATRIX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.MAXICODE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.ITF.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.EAN_13.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.EAN_8.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.PDF_417.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.RSS_14.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.RSS_EXPANDED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.UPC_A.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.UPC_E.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.UPC_EAN_EXTENSION.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSBARCScannerHint.UNKNOWN.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BarcodeFormat.values().length];
            try {
                nArray[BarcodeFormat.QR_CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.AZTEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.CODABAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.CODE_39.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.CODE_93.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.CODE_128.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.DATA_MATRIX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.MAXICODE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.ITF.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.EAN_13.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.EAN_8.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.PDF_417.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.RSS_14.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.RSS_EXPANDED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.UPC_A.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.UPC_E.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.UPC_EAN_EXTENSION.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

