/*
 * Decompiled with CFR 0.152.
 */
package io.ionic.libs.ionfiletransferlib.helpers;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import io.ionic.libs.ionfiletransferlib.helpers.FileToUploadInfo;
import io.ionic.libs.ionfiletransferlib.model.IONFLTRException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ!\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lio/ionic/libs/ionfiletransferlib/helpers/IONFLTRFileHelper;", "", "contentResolver", "Landroid/content/ContentResolver;", "(Landroid/content/ContentResolver;)V", "getContentResolver", "()Landroid/content/ContentResolver;", "createParentDirectories", "", "file", "Ljava/io/File;", "getFileToUploadInfo", "Lio/ionic/libs/ionfiletransferlib/helpers/FileToUploadInfo;", "filePath", "", "getMimeType", "getNameForContentUri", "cursor", "Landroid/database/Cursor;", "getSizeForContentUri", "", "uri", "Landroid/net/Uri;", "normalizeFilePath", "getColumnIndexForNames", "", "columnNames", "", "(Landroid/database/Cursor;Ljava/util/List;)Ljava/lang/Integer;", "IONFileTransferLib_release"})
@SourceDebugExtension(value={"SMAP\nIONFLTRFileHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IONFLTRFileHelper.kt\nio/ionic/libs/ionfiletransferlib/helpers/IONFLTRFileHelper\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n29#2:142\n1#3:143\n*S KotlinDebug\n*F\n+ 1 IONFLTRFileHelper.kt\nio/ionic/libs/ionfiletransferlib/helpers/IONFLTRFileHelper\n*L\n28#1:142\n*E\n"})
public final class IONFLTRFileHelper {
    @NotNull
    private final ContentResolver contentResolver;

    public IONFLTRFileHelper(@NotNull ContentResolver contentResolver) {
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        this.contentResolver = contentResolver;
    }

    @NotNull
    public final ContentResolver getContentResolver() {
        return this.contentResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FileToUploadInfo getFileToUploadInfo(@NotNull String filePath) {
        FileToUploadInfo fileToUploadInfo;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (StringsKt.startsWith$default((String)filePath, (String)"content://", (boolean)false, (int)2, null)) {
            String $this$toUri$iv = filePath;
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Cursor cursor = this.contentResolver.query(uri, null, null, null, null);
            if (cursor == null) {
                throw new IONFLTRException.FileDoesNotExist(null, 1, null);
            }
            Cursor cursor2 = cursor;
            Closeable closeable = (Closeable)cursor2;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                String string = this.getNameForContentUri(cursor2);
                if (string == null) {
                    throw new IONFLTRException.FileDoesNotExist(null, 1, null);
                }
                String fileName = string;
                long fileSize = this.getSizeForContentUri(cursor2, uri);
                InputStream inputStream = this.contentResolver.openInputStream(uri);
                if (inputStream == null) {
                    throw new IONFLTRException.FileDoesNotExist(null, 1, null);
                }
                InputStream inputStream2 = inputStream;
                Intrinsics.checkNotNull((Object)inputStream2);
                InputStream inputStream3 = inputStream2;
                FileToUploadInfo fileToUploadInfo2 = new FileToUploadInfo(fileName, fileSize, inputStream3);
                fileToUploadInfo = fileToUploadInfo2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            String cleanFilePath = this.normalizeFilePath(filePath);
            File fileObject = new File(new URI(cleanFilePath).getPath());
            if (!fileObject.exists()) {
                throw new IONFLTRException.FileDoesNotExist(null, 1, null);
            }
            String string = fileObject.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            fileToUploadInfo = new FileToUploadInfo(string, fileObject.length(), new FileInputStream(fileObject));
        }
        return fileToUploadInfo;
    }

    @NotNull
    public final String normalizeFilePath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String path = StringsKt.startsWith$default((String)filePath, (String)"file://", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)filePath, (CharSequence)"file://") : (StringsKt.startsWith$default((String)filePath, (String)"file:/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)filePath, (CharSequence)"file:/") : (StringsKt.startsWith$default((String)filePath, (String)"file:", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)filePath, (CharSequence)"file:") : filePath));
        String string = URLEncoder.encode(URLDecoder.decode(path, Charsets.UTF_8.toString()), Charsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getMimeType(@Nullable String filePath) {
        String string;
        String string2 = filePath;
        String string3 = string2;
        if (string2 == null) return null;
        String it = string3;
        boolean bl = false;
        String string4 = this.normalizeFilePath(it);
        string3 = string4;
        if (string4 == null) return null;
        String normalizedPath = string3;
        boolean bl2 = false;
        String string5 = string = MimeTypeMap.getFileExtensionFromUrl((String)normalizedPath);
        if (string5 == null) return null;
        Intrinsics.checkNotNull((Object)string5);
        String extension = string;
        boolean bl3 = false;
        String string6 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        return string6;
    }

    public final void createParentDirectories(@NotNull File file) throws IONFLTRException.CannotCreateDirectory {
        boolean created;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !(created = parent.mkdirs())) {
            String string = parent.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            throw new IONFLTRException.CannotCreateDirectory(string, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getSizeForContentUri(Cursor cursor, Uri uri) {
        long l;
        Long l2;
        int index = ((Number)cursor.getColumnIndex("_size")).intValue();
        boolean bl = false;
        if (index >= 0) {
            String string = cursor.getString(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            l2 = StringsKt.toLongOrNull((String)string);
        } else {
            l2 = null;
        }
        if (l2 != null) {
            l = l2;
        } else {
            Long l3;
            AssetFileDescriptor assetFileDescriptor = this.contentResolver.openAssetFileDescriptor(uri, "r");
            if (assetFileDescriptor != null) {
                Closeable closeable = (Closeable)assetFileDescriptor;
                Throwable throwable = null;
                try {
                    AssetFileDescriptor it = (AssetFileDescriptor)closeable;
                    boolean bl2 = false;
                    Long l4 = it.getLength();
                    l3 = l4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                l3 = null;
            }
            l = l3 != null ? l3 : 0L;
        }
        return l;
    }

    private final String getNameForContentUri(Cursor cursor) {
        String string;
        Integer columnIndex;
        Object[] objectArray = new String[]{"_display_name", "_display_name", "_display_name"};
        Integer n = columnIndex = this.getColumnIndexForNames(cursor, CollectionsKt.listOf((Object[])objectArray));
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string = cursor.getString(columnIndex.intValue());
        } else {
            string = null;
        }
        return string;
    }

    private final Integer getColumnIndexForNames(Cursor $this$getColumnIndexForNames, List<String> columnNames) {
        Integer n;
        block1: {
            for (String it : (Iterable)columnNames) {
                boolean bl = false;
                Integer n2 = $this$getColumnIndexForNames.getColumnIndex(it);
                int index = ((Number)n2).intValue();
                boolean bl2 = false;
                Integer n3 = index >= 0 ? n2 : null;
                if (n3 == null) continue;
                n = n3;
                break block1;
            }
            n = null;
        }
        return n;
    }
}

