/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.springboot.starter;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.config.runtime.AnnotationConfiguration;
import io.javaoperatorsdk.operator.springboot.starter.KubernetesClientProperties;
import io.javaoperatorsdk.operator.springboot.starter.KubernetesConfigCustomizer;
import io.javaoperatorsdk.operator.springboot.starter.NaiveResourceClassResolver;
import io.javaoperatorsdk.operator.springboot.starter.OperatorConfigurationProperties;
import io.javaoperatorsdk.operator.springboot.starter.ReconcilerProperties;
import io.javaoperatorsdk.operator.springboot.starter.ResourceClassResolver;
import io.javaoperatorsdk.operator.springboot.starter.RetryProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OperatorConfigurationProperties.class})
public class OperatorAutoConfiguration
extends AbstractConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(OperatorAutoConfiguration.class);
    @Autowired
    private OperatorConfigurationProperties configuration;
    @Autowired(required=false)
    private KubernetesConfigCustomizer configCustomizer;

    public OperatorAutoConfiguration() {
        super(Utils.loadFromProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Optional<HttpClient.Factory> httpClientFactory) {
        Config config = this.getClientConfiguration();
        return this.configuration.getClient().isOpenshift() ? (KubernetesClient)httpClientFactory.map(it -> new DefaultOpenShiftClient(it.createHttpClient(config), new OpenShiftConfig(config))).orElseGet(() -> new DefaultOpenShiftClient(config)) : (KubernetesClient)httpClientFactory.map(it -> new DefaultKubernetesClient(it.createHttpClient(config), config)).orElseGet(() -> new DefaultKubernetesClient(config));
    }

    public Config getClientConfiguration() {
        return this.configuration.getClient().getContext().map(Config::autoConfigure).map(it -> {
            if (this.configCustomizer != null) {
                ConfigBuilder builder = new ConfigBuilder(it);
                this.configCustomizer.customize(builder);
                return builder.build();
            }
            return it;
        }).orElseGet(() -> {
            KubernetesClientProperties clientCfg = this.configuration.getClient();
            ConfigBuilder config = new ConfigBuilder();
            config.withTrustCerts(clientCfg.isTrustSelfSignedCertificates());
            clientCfg.getMasterUrl().ifPresent(arg_0 -> ((ConfigBuilder)config).withMasterUrl(arg_0));
            clientCfg.getUsername().ifPresent(arg_0 -> ((ConfigBuilder)config).withUsername(arg_0));
            clientCfg.getPassword().ifPresent(arg_0 -> ((ConfigBuilder)config).withPassword(arg_0));
            if (this.configCustomizer != null) {
                this.configCustomizer.customize(config);
            }
            return config.build();
        });
    }

    public boolean checkCRDAndValidateLocalModel() {
        return this.configuration.getCheckCrdAndValidateLocalModel();
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceClassResolver.class})
    public ResourceClassResolver resourceClassResolver() {
        return new NaiveResourceClassResolver();
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean(value={Operator.class})
    public Operator operator(KubernetesClient kubernetesClient, List<Reconciler<?>> reconcilers, ResourceClassResolver resourceClassResolver) {
        Operator operator = new Operator(kubernetesClient, (ConfigurationService)this);
        reconcilers.forEach(r -> operator.register(this.processReconciler((Reconciler<?>)r, resourceClassResolver)));
        if (!reconcilers.isEmpty()) {
            operator.start();
        } else {
            log.warn("No Reconcilers found in the application context: Not starting the Operator");
        }
        return operator;
    }

    @Bean
    @ConditionalOnMissingBean(name={"reconciliationExecutorService"})
    public ExecutorService reconciliationExecutorService() {
        return super.getExecutorService();
    }

    @Bean
    @ConditionalOnMissingBean(value={Metrics.class})
    public Metrics metrics() {
        return super.getMetrics();
    }

    private Reconciler<?> processReconciler(Reconciler<?> reconciler, ResourceClassResolver resourceClassResolver) {
        Map<String, ReconcilerProperties> reconcilerPropertiesMap = this.configuration.getReconcilers();
        String name = ReconcilerUtils.getNameFor(reconciler);
        ReconcilerProperties controllerProps = reconcilerPropertiesMap.get(name);
        this.register((ControllerConfiguration)new ConfigurationWrapper(reconciler, controllerProps, resourceClassResolver));
        return reconciler;
    }

    public Metrics getMetrics() {
        return this.metrics();
    }

    public ExecutorService getExecutorService() {
        return this.reconciliationExecutorService();
    }

    public int concurrentReconciliationThreads() {
        return this.configuration.getConcurrentReconciliationThreads();
    }

    private static class ConfigurationWrapper<R extends CustomResource<?, ?>>
    extends AnnotationConfiguration<R> {
        private final Optional<ReconcilerProperties> properties;
        private final Reconciler<R> reconciler;
        private final ResourceClassResolver resourceClassResolver;

        private ConfigurationWrapper(Reconciler<R> reconciler, ReconcilerProperties properties, ResourceClassResolver resourceClassResolver) {
            super(reconciler);
            this.reconciler = reconciler;
            this.properties = Optional.ofNullable(properties);
            this.resourceClassResolver = resourceClassResolver;
        }

        public String getName() {
            return super.getName();
        }

        public String getFinalizer() {
            return this.properties.map(ReconcilerProperties::getFinalizer).orElse(super.getFinalizer());
        }

        public boolean isGenerationAware() {
            return this.properties.map(ReconcilerProperties::isGenerationAware).orElse(super.isGenerationAware());
        }

        public Class<R> getResourceClass() {
            return this.resourceClassResolver.resolveCustomResourceClass(this.reconciler);
        }

        public Set<String> getNamespaces() {
            return this.properties.map(ReconcilerProperties::getNamespaces).orElse(super.getNamespaces());
        }

        public boolean watchAllNamespaces() {
            return super.watchAllNamespaces();
        }

        public RetryConfiguration getRetryConfiguration() {
            return this.properties.map(ReconcilerProperties::getRetry).map(RetryProperties::asRetryConfiguration).orElse(RetryConfiguration.DEFAULT);
        }
    }
}

