/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.springboot.starter;

import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.springboot.starter.CRDApplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class OperatorStarter {
    private static final Logger log = LoggerFactory.getLogger(OperatorStarter.class);
    private final Operator operator;
    private final CRDApplier crdApplier;

    public OperatorStarter(Operator operator, CRDApplier crdApplier) {
        this.operator = operator;
        this.crdApplier = crdApplier;
    }

    @EventListener
    public void start(ApplicationReadyEvent event) {
        if (!this.operator.getRegisteredControllers().isEmpty()) {
            try {
                this.crdApplier.apply();
                this.operator.start();
            }
            catch (Exception ex) {
                log.error("Could not start operator", (Throwable)ex);
                SpringApplication.exit((ApplicationContext)event.getApplicationContext(), (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
            }
        } else {
            log.warn("No Reconcilers found in the application context: Not starting the Operator, not looking for CRDs");
        }
    }
}

