/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.ExportConfig;
import io.jenkins.blueocean.commons.stapler.export.XmlChars;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Stack;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse;

final class XMLDataWriter
implements DataWriter {
    private String name;
    private final Stack<String> objectNames = new Stack();
    private final Stack<Boolean> isArray = new Stack();
    private final Writer out;
    private ExportConfig config;
    private String classAttr;
    private final ExportConfig exportConfig;
    private static final String CLASS_ATTRIBUTE_PREFIX = " _class='";

    XMLDataWriter(Object bean, Writer out, ExportConfig config) throws IOException {
        Class<?> c = bean.getClass();
        while (c.isAnonymousClass()) {
            c = c.getSuperclass();
        }
        this.name = Introspector.decapitalize(c.getSimpleName());
        this.out = out;
        this.config = config;
        this.isArray.push(false);
        this.exportConfig = config;
    }

    XMLDataWriter(Object bean, StaplerResponse rsp, ExportConfig config) throws IOException {
        this(bean, rsp.getWriter(), config);
    }

    @Override
    @NonNull
    public ExportConfig getExportConfig() {
        return this.exportConfig;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public void valuePrimitive(Object v) throws IOException {
        this.value(v.toString());
    }

    @Override
    public void value(String v) throws IOException {
        String n = this.adjustName();
        this.out.write("<" + n + ">");
        this.out.write(Stapler.escape((String)v));
        this.out.write("</" + n + ">");
    }

    @Override
    public void valueNull() {
    }

    @Override
    public void startArray() {
        this.isArray.push(true);
    }

    @Override
    public void endArray() {
        this.isArray.pop();
    }

    public void type(Type expected, Class actual) throws IOException {
        this.classAttr = this.config.getClassAttribute().print(expected, actual);
    }

    @Override
    public void startObject() throws IOException {
        this.objectNames.push(this.name);
        this.out.write("<" + this.adjustName());
        this.isArray.push(false);
        if (this.classAttr != null) {
            this.out.write(CLASS_ATTRIBUTE_PREFIX + this.classAttr + "'");
            this.classAttr = null;
        }
        this.out.write(62);
    }

    @Override
    public void endObject() throws IOException {
        this.isArray.pop();
        this.name = this.objectNames.pop();
        this.out.write("</" + this.adjustName() + ">");
    }

    private String adjustName() {
        String escaped = XMLDataWriter.makeXmlName(this.name);
        if (this.isArray.peek().booleanValue()) {
            return XMLDataWriter.toSingular(escaped);
        }
        return escaped;
    }

    static String toSingular(String name) {
        return name.replaceFirst("ies$", "y").replaceFirst("s$", "");
    }

    static String makeXmlName(String name) {
        if (((String)name).length() == 0) {
            name = "_";
        }
        if (!XmlChars.isNameStart(((String)name).charAt(0))) {
            name = ((String)name).length() > 1 && XmlChars.isNameStart(((String)name).charAt(1)) ? ((String)name).substring(1) : "_" + (String)name;
        }
        int i = 1;
        while (i < ((String)name).length()) {
            if (XmlChars.isNameChar(((String)name).charAt(i))) {
                ++i;
                continue;
            }
            name = ((String)name).substring(0, i) + ((String)name).substring(i + 1);
        }
        return name;
    }
}

