'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PipelineService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _desc, _value, _class;

var _Pager = require('./Pager');

var _rest = require('../paths/rest');

var _fetch = require('../fetch');

var _utils = require('../utils');

var _BunkerService2 = require('./BunkerService');

var _mobx = require('mobx');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
    var desc = {};
    Object['ke' + 'ys'](descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
    });
    desc.enumerable = !!desc.enumerable;
    desc.configurable = !!desc.configurable;

    if ('value' in desc || desc.initializer) {
        desc.writable = true;
    }

    desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
    }, desc);

    if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
    }

    if (desc.initializer === void 0) {
        Object['define' + 'Property'](target, property, desc);
        desc = null;
    }

    return desc;
}

/**
 * This class handles pipeline related data. This includes pipelines, branches and pullrequests as they are
 * all pipelines in the backend.
 *
 * @export
 * @class PipelineService
 * @extends {BunkerService}
 */
var PipelineService = exports.PipelineService = (_class = function (_BunkerService) {
    _inherits(PipelineService, _BunkerService);

    /**
     * Creates an instance of PipelineService.
     *
     * @param {PagerService} pagerService
     * @param {ActivityService} activityService
     */
    function PipelineService(pagerService, activityService) {
        _classCallCheck(this, PipelineService);

        var _this = _possibleConstructorReturn(this, (PipelineService.__proto__ || Object.getPrototypeOf(PipelineService)).call(this, pagerService));

        _this.bunkerMapper = function (pipelineData) {
            var data = _utils.Utils.clone(pipelineData);
            var latestRun = data.latestRun;

            if (latestRun) {
                data.latestRun = _this.activityService.setItem(latestRun);
            }

            return data;
        };

        _this.activityService = activityService;
        return _this;
    }

    /**
     * Gets pager for /blue/organization/:organization/pipelines
     *
     * @param {searchText} search text for filtering pipelines by name.
     * @param {organization} organization organization pager belongs to.
     * @returns {Pager}
     */


    _createClass(PipelineService, [{
        key: 'pipelinesPager',
        value: function pipelinesPager(organization, searchText) {
            var _this2 = this;

            return this.pagerService.getPager({
                key: 'searchPipelinesPager/' + searchText + '/' + organization,
                lazyPager: function lazyPager() {
                    return new _Pager.Pager(_rest.RestPaths.pipelines(organization, searchText), 25, _this2);
                }
            });
        }

        /**
         * Gets pager for /blue/organization/:organization/pipelines/:pipeline/branches
         *
         * @param {string} organization
         * @param {string} pipeline
         * @returns {Pager}
         */

    }, {
        key: 'branchPager',
        value: function branchPager(organization, pipeline) {
            var _this3 = this;

            return this.pagerService.getPager({
                key: 'Branches/' + organization + '-' + pipeline,
                lazyPager: function lazyPager() {
                    return new _Pager.Pager(_rest.RestPaths.branches(organization, pipeline), 25, _this3);
                }
            });
        }

        /**
         * Gets pager for /blue/organization/:organization/pipelines/:pipeline/pullRequests
         *
         * @param {string} organization
         * @param {string} pipeline
         * @returns {Pager}
         */

    }, {
        key: 'prPager',
        value: function prPager(organization, pipeline) {
            var _this4 = this;

            return this.pagerService.getPager({
                key: 'PRs/' + organization + '-' + pipeline,
                lazyPager: function lazyPager() {
                    return new _Pager.Pager(_rest.RestPaths.pullRequests(organization, pipeline), 25, _this4);
                }
            });
        }
        /**
         * Adds the latest run to the [@link ActivityService], and sets the latestRun as a mobx computed value.
         *
         * @param {Object} pipelineData Raw data from backend.
         * @return {Object} mapped pipelineData with latestRun set to be a mobx computed value.
         */

    }, {
        key: 'getPipeline',

        /**
         * Gets a pipeline from the store
         *
         * @param {string} href - Self href of the pipeline.
         * @returns {Object} - Mobx computed value of the pipeline.
         */
        value: function getPipeline(href) {
            return this.getItem(href);
        }

        /**
         * Fetches pipeline from the backend and stores it in
         *
         * @param {string} href - Self href of the pipeline.
         * @param {Object} options
         * @param {boolean} options.useCache - If true fetch from the store if it exists.
         * @returns
         */

    }, {
        key: 'fetchPipeline',
        value: function fetchPipeline(href) {
            var _this5 = this;

            var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                useCache = _ref.useCache;

            if (useCache && this.hasItem(href)) {
                return Promise.resolve(this.getItem(href));
            }

            return _fetch.Fetch.fetchJSON(href).then(function (data) {
                return _this5.setItem(data);
            });
        }

        /**
         * MobX Action to update the latest run on a pipeline. Use for SSE. This will cause a reaction
         * and rerender anything that uses the latest run of this pipeline.
         *
         * @param {Object} run An activity from activityService.getItem().
         */

    }, {
        key: 'updateLatestRun',
        value: function updateLatestRun(run) {
            var pipeline = this.getItem(run._links.parent.href);
            if (pipeline) {
                pipeline.latestRun = run;
            }
        }
    }]);

    return PipelineService;
}(_BunkerService2.BunkerService), (_applyDecoratedDescriptor(_class.prototype, 'updateLatestRun', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'updateLatestRun'), _class.prototype)), _class);
//# sourceMappingURL=PipelineService.js.map
