'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.execute = execute;

var _jsModules = require('@jenkins-cd/js-modules');

var modules = _interopRequireWildcard(_jsModules);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

/**
 * Executes extension init and hack for blueocean-web i18n
 */
function execute(done, config) {
    // Get the extension list metadata from Jenkins.
    // have a special handling for core-js, must load the web bundle...
    var Extensions = require('@jenkins-cd/js-extensions');
    var appRoot = document.getElementsByTagName('head')[0].getAttribute('data-appurl');

    Extensions.init({
        extensionData: window.$blueocean.jsExtensions,
        classMetadataProvider: function classMetadataProvider(type, cb) {
            var fetch = require('./fetch').Fetch;
            var fetchOptions = {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json'
                }
            };
            fetch.fetchJSON(appRoot + '/rest/classes/' + type + '/', { fetchOptions: fetchOptions }).then(cb).catch(fetch.consoleError);
        }
    });
    require('./i18n/bundle-startup').execute(done, { hpiPluginId: 'blueocean-web' });
}
//# sourceMappingURL=bundleStartup.js.map
