[{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/LoadingIndicator.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\n\nfunction _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }\n\n/**\n * This contains a bit that reuses the index.jelly progress bar\n * so React components can just add a <PageLoading/> indicator,\n * and overlapping loading should just extend the time, etc.\n */\nvar loadingCount = 0;\nvar timeouts = [];\n\n// use a short timeout so fast connections aren't seeing\n// flashes of the progress bar all the time\nvar delay = 350;\nvar loadbar = typeof document !== 'undefined' && document.getElementById('loadbar');\n\n/**\n * Remove queued progress additions\n */\nfunction clearTimeouts() {\n    while (timeouts.length) {\n        clearTimeout(timeouts.pop());\n    }\n}\n\n/**\n * Add a timeout to transition the loading animation differently\n */\nfunction setLoaderClass(c, t) {\n    timeouts.push(setTimeout(function () {\n        loadbar.classList.add(c);\n    }, t));\n}\n\n/**\n * Simple mostly css-based loading animation\n */\nvar loadingIndicator = exports.loadingIndicator = {\n    show: function show() {\n        if (loadbar) {\n            if (loadingCount === 0) {\n                // (re)start the loading animation\n                clearTimeouts();\n                loadbar.classList.remove('complete');\n                setLoaderClass('go', delay); // these times need to match the index.jelly CSS definitions\n                setLoaderClass('long', delay + 1000);\n                setLoaderClass('longer', delay + 6000);\n            }\n            loadingCount++;\n        }\n    },\n    hide: function hide() {\n        if (loadbar) {\n            if (loadingCount > 0) {\n                loadingCount--;\n            }\n\n            if (loadingCount === 0) {\n                // stop the loading animation\n                clearTimeouts();\n                setLoaderClass('complete', 10);\n                timeouts.push(setTimeout(function () {\n                    // The Element.classList is a read-only property\n                    var classList = loadbar.classList;\n                    if (classList && classList.length && classList.length > 0) {\n                        // remove all items - compatible with older browser\n                        classList.remove.apply(classList, [].concat(_toConsumableArray(classList)));\n                    }\n                }, 500));\n            }\n        }\n    },\n\n\n    // TODO should make this a stack to push/pop\n    setDarkBackground: function setDarkBackground() {\n        if (loadbar) document.getElementsByTagName('body')[0].classList.add('loadbar-light');\n    },\n    setLightBackground: function setLightBackground() {\n        if (loadbar) document.getElementsByTagName('body')[0].classList.remove('loadbar-light');\n    }\n};","deps":{}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/CapabilityApi.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.CapabilityApi = undefined;\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 9/8/16.\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */\n\n\nvar _fetch = require('../fetch');\n\nvar _urlconfig = require('../urlconfig');\n\nvar _utils = require('../utils');\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nvar CapabilityApi = exports.CapabilityApi = function () {\n    function CapabilityApi() {\n        _classCallCheck(this, CapabilityApi);\n    }\n\n    _createClass(CapabilityApi, [{\n        key: 'fetchCapabilities',\n\n        /**\n         * Fetch the capabilities for one or more class names.\n         *\n         * @param {Array} classNames\n         * @returns {Promise} with fulfilled {object} keyed by className, with an array of string capability names.\n         * @private\n         */\n        value: function fetchCapabilities(classNames) {\n            var noDuplicates = classNames.filter(function (item, index, self) {\n                return self.indexOf(item) === index;\n            });\n            var path = _urlconfig.UrlConfig.getJenkinsRootURL();\n            var classesUrl = _utils.Utils.cleanSlashes(path + '/blue/rest/classes/');\n\n            var fetchOptions = {\n                method: 'POST',\n                headers: {\n                    'Content-Type': 'application/json'\n                },\n                body: JSON.stringify({ q: noDuplicates })\n            };\n\n            return _fetch.Fetch.fetchJSON(classesUrl, { disableCapabilities: true, fetchOptions: fetchOptions });\n        }\n    }]);\n\n    return CapabilityApi;\n}();","deps":{"../fetch":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/fetch.js","../urlconfig":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/urlconfig.js","../utils":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/utils.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/CapabilityAugmenter.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; };\n\nfunction _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/**\n * Created by cmeyers on 9/8/16.\n */\n\nvar addClass = function addClass(clazz, classMap) {\n    var className = void 0;\n\n    if (Array.isArray(clazz._class)) {\n        // If it's an array of class names, just take the first.\n        // TODO: Hmmm ... not sure if this is the right thing to do when we have an array of class names.\n        // Not sure what the array is about tbh. What are the relationships?\n        if (clazz._class.length > 0) {\n            className = clazz._class[0];\n        } else {\n            return;\n        }\n    } else {\n        className = clazz._class;\n    }\n\n    if (!classMap[className]) {\n        // eslint-disable-next-line no-param-reassign\n        classMap[className] = [];\n    }\n\n    classMap[className].push(clazz);\n};\n\nvar canWalk = function canWalk(item) {\n    return item && ((typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object' || Array.isArray(item));\n};\n\nvar DEFAULT_IGNORED_PROPS = ['_links'];\n\n/**\n * Decorate an object graph with a '_capabilities' property for each object with a valid '_class'\n * Usage:\n *      import { capabilityAugmenter } from '@jenkins-cd/blueocean-core-js';\n *      const augmentCapability = capabilityAugmenter.augmentCapability;\n *\n *      fetch(url, fetchOptions)\n *          .then(data => augmentCapability(data));\n */\n\nvar CapabilityAugmenter = exports.CapabilityAugmenter = function () {\n    function CapabilityAugmenter(capabilityStore) {\n        _classCallCheck(this, CapabilityAugmenter);\n\n        this._capabilityStore = capabilityStore;\n        this._perfLoggingEnabled = false;\n        this._warnLoggingEnabled = false;\n    }\n\n    /**\n     * Add \"_capabilities\" data or all objects with a \"_class\" property.\n     *\n     * @param {object|Array} data\n     * @returns {Promise}\n     */\n\n\n    _createClass(CapabilityAugmenter, [{\n        key: 'augmentCapabilities',\n        value: function augmentCapabilities(data) {\n            var classMap = this._findClassesInTree(data);\n            return this._resolveCapabilities(data, classMap);\n        }\n    }, {\n        key: 'enablePerfLogging',\n        value: function enablePerfLogging() {\n            this._perfLoggingEnabled = true;\n        }\n    }, {\n        key: 'enableWarningLogging',\n        value: function enableWarningLogging() {\n            this._warnLoggingEnabled = true;\n        }\n\n        /**\n         * Find all of the distinct \"_class\" values in supplied object.\n         *\n         * @param {object|Array} data\n         * @returns {object} key= \"_class\" name, value= array of all objects of that class.\n         * @private\n         */\n\n    }, {\n        key: '_findClassesInTree',\n        value: function _findClassesInTree(data) {\n            var classMap = {};\n            var nodesToWalk = [data];\n            var nodesAlreadyWalked = [];\n            var ignoredProps = DEFAULT_IGNORED_PROPS.slice();\n\n            var started = new Date().getTime();\n\n            var node = nodesToWalk.shift();\n\n            while (node) {\n                nodesAlreadyWalked.push(node);\n\n                // save a ref to the class so we can attach capabilities later\n                if ((typeof node === 'undefined' ? 'undefined' : _typeof(node)) === 'object' && node._class) {\n                    addClass(node, classMap);\n                }\n\n                var nodeKeys = Object.keys(node);\n\n                var _iteratorNormalCompletion = true;\n                var _didIteratorError = false;\n                var _iteratorError = undefined;\n\n                try {\n                    for (var _iterator = nodeKeys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n                        var key = _step.value;\n\n                        var value = node[key];\n\n                        // walk this node at a later iteration as long as\n                        // - we didn't already walk it (cycles cause an infinite loop otherwise)\n                        // - the property name isn't on the blacklist\n                        if (canWalk(value) && nodesAlreadyWalked.indexOf(value) === -1 && ignoredProps.indexOf(key) === -1) {\n                            nodesToWalk.push(value);\n                        }\n                    }\n                } catch (err) {\n                    _didIteratorError = true;\n                    _iteratorError = err;\n                } finally {\n                    try {\n                        if (!_iteratorNormalCompletion && _iterator.return) {\n                            _iterator.return();\n                        }\n                    } finally {\n                        if (_didIteratorError) {\n                            throw _iteratorError;\n                        }\n                    }\n                }\n\n                node = nodesToWalk.shift();\n            }\n\n            if (this._perfLoggingEnabled) {\n                console.debug('augmenter.parse: ' + (new Date().getTime() - started) + 'ms');\n            }\n\n            return classMap;\n        }\n    }, {\n        key: '_resolveCapabilities',\n        value: function _resolveCapabilities(data, classMap) {\n            var _capabilityStore,\n                _this = this;\n\n            var classNames = Object.keys(classMap);\n\n            return (_capabilityStore = this._capabilityStore).resolveCapabilities.apply(_capabilityStore, _toConsumableArray(classNames)).then(function (capabilitiesMap) {\n                return _this._injectCapabilities(classMap, capabilitiesMap);\n            }).then(function () {\n                return data;\n            });\n        }\n\n        /**\n         * Add the capabilities to the \"_capabilities\" property of all objects in the class map.\n         *\n         * @param classMap\n         * @param capabilitiesMap\n         * @returns {object} classMap\n         * @private\n         */\n\n    }, {\n        key: '_injectCapabilities',\n        value: function _injectCapabilities(classMap, capabilitiesMap) {\n            var started = new Date().getTime();\n            var unresolved = [];\n\n            var _iteratorNormalCompletion2 = true;\n            var _didIteratorError2 = false;\n            var _iteratorError2 = undefined;\n\n            try {\n                for (var _iterator2 = Object.keys(classMap)[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {\n                    var _className = _step2.value;\n                    var _iteratorNormalCompletion4 = true;\n                    var _didIteratorError4 = false;\n                    var _iteratorError4 = undefined;\n\n                    try {\n                        for (var _iterator4 = classMap[_className][Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {\n                            var target = _step4.value;\n\n                            var capabilities = capabilitiesMap[_className];\n\n                            if (!capabilities && unresolved.indexOf(_className) === -1) {\n                                unresolved.push(_className);\n                            }\n\n                            target._capabilities = capabilities || [];\n                        }\n                    } catch (err) {\n                        _didIteratorError4 = true;\n                        _iteratorError4 = err;\n                    } finally {\n                        try {\n                            if (!_iteratorNormalCompletion4 && _iterator4.return) {\n                                _iterator4.return();\n                            }\n                        } finally {\n                            if (_didIteratorError4) {\n                                throw _iteratorError4;\n                            }\n                        }\n                    }\n                }\n            } catch (err) {\n                _didIteratorError2 = true;\n                _iteratorError2 = err;\n            } finally {\n                try {\n                    if (!_iteratorNormalCompletion2 && _iterator2.return) {\n                        _iterator2.return();\n                    }\n                } finally {\n                    if (_didIteratorError2) {\n                        throw _iteratorError2;\n                    }\n                }\n            }\n\n            if (this._perfLoggingEnabled) {\n                console.debug('augmenter.inject: ' + (new Date().getTime() - started) + 'ms');\n            }\n\n            if (this._warnLoggingEnabled) {\n                var _iteratorNormalCompletion3 = true;\n                var _didIteratorError3 = false;\n                var _iteratorError3 = undefined;\n\n                try {\n                    for (var _iterator3 = unresolved[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {\n                        var className = _step3.value;\n\n                        console.warn('could not resolve capabilities for ' + className + '; an error may have occurred during lookup');\n                    }\n                } catch (err) {\n                    _didIteratorError3 = true;\n                    _iteratorError3 = err;\n                } finally {\n                    try {\n                        if (!_iteratorNormalCompletion3 && _iterator3.return) {\n                            _iterator3.return();\n                        }\n                    } finally {\n                        if (_didIteratorError3) {\n                            throw _iteratorError3;\n                        }\n                    }\n                }\n            }\n\n            return classMap;\n        }\n    }]);\n\n    return CapabilityAugmenter;\n}();","deps":{}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/CapabilityStore.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.CapabilityStore = undefined;\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 8/31/16.\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */\n\n\nvar _bluebird = require('bluebird');\n\nvar _bluebird2 = _interopRequireDefault(_bluebird);\n\nvar _storage = require('../storage');\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n// Create a dedicated storage namespace that we use to store classes\n// info in the browser, eliminating client REST call overhead for classes\n// info. This storage namespace will be auto-cleared if the jenkins version\n// changes, or if the active plugins change.\nvar classesInfoNS = _storage.installInfo.subspace('classesInfo');\n\n/**\n * Retrieves capability metadata for class names.\n * Uses an internal cache to minimize REST API calls.\n */\n\nvar CapabilityStore = exports.CapabilityStore = function () {\n    function CapabilityStore(capabilityApi) {\n        _classCallCheck(this, CapabilityStore);\n\n        this._localStore = {};\n        this._capabilityApi = capabilityApi;\n    }\n\n    /**\n     * Fetch the capabilities for one or more class names.\n     * Will used cached values if available.\n     *\n     * @param classNames\n     * @returns {Promise} with fulfilled {object} keyed by className, with an array of string capability names.\n     */\n\n\n    _createClass(CapabilityStore, [{\n        key: 'resolveCapabilities',\n        value: function resolveCapabilities() {\n            var result = {};\n            var classesToFetch = [];\n\n            // determine which class names are already in the cache and which aren't\n\n            for (var _len = arguments.length, classNames = Array(_len), _key = 0; _key < _len; _key++) {\n                classNames[_key] = arguments[_key];\n            }\n\n            var _iteratorNormalCompletion = true;\n            var _didIteratorError = false;\n            var _iteratorError = undefined;\n\n            try {\n                for (var _iterator = classNames[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {\n                    var className = _step.value;\n\n                    var classInfo = this._getStoredClassInfo(className);\n                    if (classInfo) {\n                        result[className] = classInfo;\n                    } else {\n                        classesToFetch.push(className);\n                    }\n                }\n\n                // if nothing to fetch, just return an immediately fulfilled Promise\n            } catch (err) {\n                _didIteratorError = true;\n                _iteratorError = err;\n            } finally {\n                try {\n                    if (!_iteratorNormalCompletion && _iterator.return) {\n                        _iterator.return();\n                    }\n                } finally {\n                    if (_didIteratorError) {\n                        throw _iteratorError;\n                    }\n                }\n            }\n\n            if (classesToFetch.length === 0) {\n                return new _bluebird2.default(function (resolve) {\n                    return resolve(result);\n                });\n            }\n\n            // fetch the capabilities and then merge that with the values already in the cache\n            return this._fetchCapabilities(classesToFetch).then(function (fetchedCapabilities) {\n                return Object.assign(result, fetchedCapabilities);\n            });\n        }\n\n        /**\n         * Fetch the capabilities for one or more class names.\n         *\n         * @param classNames\n         * @returns {Promise} with fulfilled {object} keyed by className, with an array of string capability names.\n         * @private\n         */\n\n    }, {\n        key: '_fetchCapabilities',\n        value: function _fetchCapabilities(classNames) {\n            var _this = this;\n\n            return this._capabilityApi.fetchCapabilities(classNames).then(function (data) {\n                return _this._storeCapabilities(data.map);\n            });\n        }\n\n        /**\n         * Store the values in the cache and return it.\n         *\n         * @param map\n         * @returns {object} keyed by className, with an array of string capability names.\n         * @private\n         */\n\n    }, {\n        key: '_storeCapabilities',\n        value: function _storeCapabilities(map) {\n            var _this2 = this;\n\n            var storedCapabilities = {};\n\n            Object.keys(map).forEach(function (className) {\n                var capabilities = map[className];\n                _this2._localStore[className] = storedCapabilities[className] = capabilities.classes.slice();\n                // Also store in the browser so we don't have to look\n                // up this info again (unless the storage namespace is\n                // cleared due to jenkins or plugin changes).\n                classesInfoNS.set(className, _this2._localStore[className]);\n            });\n\n            return storedCapabilities;\n        }\n    }, {\n        key: '_getStoredClassInfo',\n        value: function _getStoredClassInfo(className) {\n            if (!this._localStore[className]) {\n                // If we don't have a copy of the class info in the localStore,\n                // check the browser storage and copy it into the localStore.\n                // We still want to use the localStore because it holds deserialized\n                // copies of the class info, which means that a localStore lookup\n                // would be lower overhead and probably faster.\n                this._localStore[className] = classesInfoNS.get(className);\n            }\n            return this._localStore[className];\n        }\n    }]);\n\n    return CapabilityStore;\n}();","deps":{"../storage":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/storage.js","bluebird":"node_modules/bluebird/js/browser/bluebird.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/Capable.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/**\n * Created by cmeyers on 9/9/16.\n */\n\n/**\n * Determines whether the supplied object has at least one of the supplied capabilities.\n *\n * As capabilities are typically name-spaced, this method will match on long or short names, e.g.\n * given: _capabilities = ['a.b.Capability1']\n * passing either 'a.b.Capability1' or 'Capability1' will match\n *\n * @param {object} subject\n * @param {...string} capabilityNames\n * @returns {boolean}\n */\nvar capable = exports.capable = function capable(subject) {\n    for (var _len = arguments.length, capabilityNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n        capabilityNames[_key - 1] = arguments[_key];\n    }\n\n    if (subject && subject._capabilities) {\n        var _ref;\n\n        // in case an array was passed in, flatten it out\n        var flattenedCapabilities = (_ref = []).concat.apply(_ref, capabilityNames);\n\n        // find the intersection of subject's caps with the passed-in caps\n        var longNameMatches = flattenedCapabilities.filter(function (longName) {\n            return subject._capabilities.indexOf(longName) !== -1;\n        });\n        if (longNameMatches.length > 0) {\n            return true;\n        }\n\n        // build short form of subject's caps, then find intersection\n        var shortNames = subject._capabilities.map(function (longName) {\n            return longName.split('.').slice(-1).join('');\n        });\n\n        var shortNameMatches = flattenedCapabilities.filter(function (longName) {\n            return shortNames.indexOf(longName) !== -1;\n        });\n        if (shortNameMatches.length > 0) {\n            return true;\n        }\n    }\n\n    return false;\n};\n\n/**\n * Provides some convenience methods for host object of _class/_capabilities\n */\n\nvar Capable = exports.Capable = function () {\n    function Capable() {\n        _classCallCheck(this, Capable);\n    }\n\n    _createClass(Capable, [{\n        key: 'can',\n\n        /**\n         * Determines whether the host object has the supplied capability.\n         * As capabilities are typically name-spaced, this method will match on long or short names, e.g.\n         * if _capabilities = ['a.b.Capability1']\n         * passing either 'a.b.Capability1' or 'Capability1' will match\n         *\n         * @param {string} capabilityName\n         * @returns {boolean}\n         */\n        value: function can(capabilityName) {\n            return capable(this, capabilityName);\n        }\n    }]);\n\n    return Capable;\n}();\n\nexports.default = new Capable();","deps":{}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/index.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n  value: true\n});\nexports.capable = exports.capabilityAugmenter = exports.capabilityStore = undefined;\n\nvar _Capable = require('./Capable');\n\nObject.defineProperty(exports, 'capable', {\n  enumerable: true,\n  get: function get() {\n    return _Capable.capable;\n  }\n});\n\nvar _CapabilityApi = require('./CapabilityApi');\n\nvar _CapabilityStore = require('./CapabilityStore');\n\nvar _CapabilityAugmenter = require('./CapabilityAugmenter');\n\nvar api = new _CapabilityApi.CapabilityApi(); /**\n                                               * Created by cmeyers on 9/8/16.\n                                               */\n\nvar store = new _CapabilityStore.CapabilityStore(api);\nvar augmenter = new _CapabilityAugmenter.CapabilityAugmenter(store);\n\n// export as named singletons\nexports.capabilityStore = store;\nexports.capabilityAugmenter = augmenter;","deps":{"./CapabilityApi":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/CapabilityApi.js","./CapabilityAugmenter":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/CapabilityAugmenter.js","./CapabilityStore":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/CapabilityStore.js","./Capable":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/Capable.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/config.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.AppConfig = undefined;\n\nvar _scopes = require('./scopes');\n\nvar config = _scopes.blueocean.config || {}; /**\n                                              * This config object comes from blueocean-config.\n                                              */\n\nvar features = config.features || {};\nvar organization = _scopes.blueocean.organization || {};\n\n// any all features added by ?features=SOMETHING,SOMETHING_ELSE\nvar pfx = 'features=';\nvar pfxlen = pfx.length;\nvar condition = window && window.location && window.location.href && window.location.href.split instanceof Function && window.location.href.split('?').length > 0;\nvar query = condition ? window.location.href.split('?')[1] : undefined;\nif (query) {\n    query.split('&').forEach(function (p) {\n        return p.startsWith(pfx) && p.substring(pfxlen).split(',').forEach(function (f) {\n            features[f] = true;\n        });\n    });\n}\nvar AppConfig = exports.AppConfig = {\n    loadUrls: function loadUrls() {\n        try {\n            var headElement = document.getElementsByTagName('head')[0];\n\n            // Look up where the Blue Ocean app is hosted\n            config.blueoceanAppURL = headElement.getAttribute('data-appurl');\n\n            // load server skewTime\n            config.serverBrowserTimeSkewMillis = headElement.getAttribute('data-servertime') - Date.now();\n            if (typeof config.blueoceanAppURL !== 'string') {\n                config.blueoceanAppURL = '/';\n            }\n\n            config.jenkinsRootURL = headElement.getAttribute('data-rooturl');\n            config.resourceUrl = headElement.getAttribute('data-resurl');\n\n            config.isLoaded = true;\n        } catch (e) {\n            // headless escape\n            config.jenkinsRootURL = '/jenkins';\n            config.serverBrowserTimeSkewMillis = 0;\n        }\n    },\n    getConfig: function getConfig() {\n        return config;\n    },\n    getJenkinsConfig: function getJenkinsConfig() {\n        return config.jenkinsConfig || {};\n    },\n    getOrganizationName: function getOrganizationName() {\n        var encoded = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;\n\n        return encoded ? encodeURIComponent(organization.name) : organization.name;\n    },\n    getOrganizationDisplayName: function getOrganizationDisplayName() {\n        return organization.displayName;\n    },\n    getOrganizationGroup: function getOrganizationGroup() {\n        return organization.organizationGroup;\n    },\n    getSecurityConfig: function getSecurityConfig() {\n        return this.getJenkinsConfig().security || {};\n    },\n    getAnalyticsEnabled: function getAnalyticsEnabled() {\n        return this.getJenkinsConfig().analytics || false;\n    },\n    isJWTEnabled: function isJWTEnabled() {\n        return !!this.getSecurityConfig().enableJWT;\n    },\n    getJWTServiceHostUrl: function getJWTServiceHostUrl() {\n        return this.getSecurityConfig().jwtServiceHostUrl;\n    },\n    getLoginUrl: function getLoginUrl() {\n        return this.getSecurityConfig().loginUrl;\n    },\n    getPluginInfo: function getPluginInfo(pluginId) {\n        return _scopes.blueocean.jsExtensions.find(function (pluginInfo) {\n            return pluginInfo.hpiPluginId === pluginId;\n        });\n    },\n    isFeatureEnabled: function isFeatureEnabled(name, defaultValue) {\n        var value = features[name];\n        if (typeof value === 'boolean') {\n            return value;\n        }\n        if (typeof defaultValue === 'boolean') {\n            return defaultValue;\n        }\n        return false;\n    },\n    showOrg: function showOrg() {\n        return this.isFeatureEnabled('organizations.enabled', false);\n    },\n    getJenkinsRootURL: function getJenkinsRootURL() {\n        if (!config.isLoaded) {\n            this.loadUrls();\n        }\n        return typeof config.jenkinsRootURL === 'string' ? config.jenkinsRootURL : '/jenkins';\n    },\n    getResourceURL: function getResourceURL() {\n        if (!config.isLoaded) {\n            this.loadUrls();\n        }\n        return typeof config.resourceUrl === 'string' ? config.resourceUrl : '/jenkins/static';\n    },\n    getServerBrowserTimeSkewMillis: function getServerBrowserTimeSkewMillis() {\n        if (!config.isLoaded) {\n            this.loadUrls();\n        }\n        return typeof config.serverBrowserTimeSkewMillis === 'number' ? config.serverBrowserTimeSkewMillis : 0;\n    },\n    getRestRoot: function getRestRoot() {\n        return this.getJenkinsRootURL() + '/blue/rest';\n    },\n\n\n    /**\n     * Set a new \"jenkinsConfig\" object.\n     * Useful for testing in a headless environment.\n     * @param newConfig\n     * @private\n     */\n    _setJenkinsConfig: function _setJenkinsConfig(newConfig) {\n        config.jenkinsConfig = newConfig;\n    }\n};","deps":{"./scopes":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/scopes.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/fetch.js","source":"\"use strict\";\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Promise = require(\"bluebird\");\nrequire(\"isomorphic-fetch\");\nvar jwt_1 = require(\"./jwt\");\nvar utils_1 = require(\"./utils\");\nvar config_1 = require(\"./config\");\nvar dedupe_calls_1 = require(\"./utils/dedupe-calls\");\nvar urlconfig_1 = require(\"./urlconfig\");\nvar scopes_1 = require(\"./scopes\");\nvar LoadingIndicator_1 = require(\"./LoadingIndicator\");\nvar index_1 = require(\"./capability/index\");\nvar refreshToken = null;\nfunction isGetRequest(fetchOptions) {\n    return !fetchOptions || !fetchOptions.method || 'get'.localeCompare(fetchOptions.method) === 0;\n}\nvar FetchFunctions = /** @class */ (function () {\n    function FetchFunctions() {\n    }\n    /**\n     * Ensures the URL starts with jenkins path if not an absolute URL.\n     * @param url\n     * @returns {string}\n     */\n    FetchFunctions.prefixUrl = function (url) {\n        if (url.indexOf('http') === 0) {\n            return url;\n        }\n        if (urlconfig_1.UrlConfig.getJenkinsRootURL() !== '' && !url.startsWith(urlconfig_1.UrlConfig.getJenkinsRootURL())) {\n            return \"\" + urlconfig_1.UrlConfig.getJenkinsRootURL() + url;\n        }\n        return url;\n    };\n    FetchFunctions.checkRefreshHeader = function (response) {\n        var _refreshToken = response.headers.get('X-Blueocean-Refresher');\n        // No token in response, lets just ignore.\n        if (!_refreshToken) {\n            return response;\n        }\n        // First time we have seen a refresh token, early exit.\n        if (!refreshToken) {\n            refreshToken = _refreshToken;\n            return response;\n        }\n        // We need to refresh the page now!\n        if (refreshToken !== _refreshToken) {\n            utils_1.Utils.refreshPage();\n            throw new Error('refreshing apge');\n        }\n        return response;\n    };\n    /**\n     * This method checks for for 2XX http codes. Throws error it it is not.\n     * This should only be used if not using fetch or fetchJson.\n     */\n    FetchFunctions.checkStatus = function (response) {\n        if (response.status >= 300 || response.status < 200) {\n            var message = \"fetch failed: \" + response.status + \" for \" + response.url;\n            var error = new Error(message); //FIXME\n            error.response = response;\n            throw error;\n        }\n        return response;\n    };\n    FetchFunctions.stopLoadingIndicator = function (response) {\n        LoadingIndicator_1.loadingIndicator.hide();\n        return response;\n    };\n    /**\n     * Adds same-origin option to the fetch.\n     */\n    FetchFunctions.sameOriginFetchOption = function (options) {\n        if (options === void 0) { options = {}; }\n        var newOpts = utils_1.Utils.clone(options);\n        newOpts.credentials = newOpts.credentials || 'same-origin';\n        return newOpts;\n    };\n    /**\n     * Enhances the fetchOptions with the JWT bearer token. Will only be needed\n     * if not using fetch or fetchJson.\n     */\n    FetchFunctions.jwtFetchOption = function (token, options) {\n        if (options === void 0) { options = {}; }\n        var newOpts = utils_1.Utils.clone(options);\n        newOpts.headers = newOpts.headers || {};\n        newOpts.headers['Authorization'] = newOpts.headers['Authorization'] || \"Bearer \" + token;\n        return newOpts;\n    };\n    /**\n     * REturns the json body from the response. It is only needed if\n     * you are using FetchUtils.fetch\n     *\n     * Usage:\n     * FetchUtils.fetch(..).then(FetchUtils.parseJSON)\n     */\n    FetchFunctions.parseJSON = function (response) {\n        return (response\n            .json()\n            .catch(function (error) {\n            if (error.message.indexOf('Unexpected end of JSON input') !== -1) {\n                return {};\n            }\n            throw error;\n        }));\n    };\n    /* eslint-disable no-param-reassign */\n    /**\n     * Parses the response body for the error generated in checkStatus.\n     */\n    FetchFunctions.parseErrorJson = function (error) {\n        return error.response.json().then(function (body) {\n            error.responseBody = body;\n            throw error;\n        }, function () {\n            error.responseBody = null;\n            throw error;\n        });\n    };\n    /* eslint-enable no-param-reassign */\n    /**\n     * Error function helper to log errors to console.\n     *\n     * Usage;\n     * fetchJson(..).catch(FetchUtils.consoleError)\n     */\n    FetchFunctions.consoleError = function (error) {\n        console.error(error); // eslint-disable-line no-console\n    };\n    /**\n     * Error function helper to call a callback on a rejected promise.\n     * if callback is null, log to console). Use .catch() if you know it\n     * will not be null though.\n     *\n     * Usage;\n     * fetchJson(..).catch(FetchUtils.onError(error => //do something)\n     */\n    FetchFunctions.onError = function (errorFunc) {\n        return function (error) {\n            if (errorFunc) {\n                errorFunc(error);\n            }\n            else {\n                FetchFunctions.consoleError(error);\n            }\n        };\n    };\n    /**\n     * Raw fetch that returns the json body.\n     *\n     * This method is semi-private, under normal conditions it should not be\n     * used as it does not include the JWT bearer token\n     *\n     * @param {string} url - The URL to fetch from.\n     * @param {Object} [options]\n     * @param {function} [options.onSuccess] - Optional callback success function.\n     * @param {function} [options.onError] - Optional error callback.\n     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.\n     * @param {boolean} [options.disableDedupe] - Optional flag to disable dedupe for this request.\n     * @param {boolean} [options.disableLoadingIndicator] - Optional flag to disable loading indicator for this request.\n     * @returns JSON body\n     */\n    FetchFunctions.rawFetchJSON = function (url, _a) {\n        var _b = _a === void 0 ? {} : _a, onSuccess = _b.onSuccess, onError = _b.onError, fetchOptions = _b.fetchOptions, disableDedupe = _b.disableDedupe, disableLoadingIndicator = _b.disableLoadingIndicator, ignoreRefreshHeader = _b.ignoreRefreshHeader;\n        var request = function () {\n            var future = getPrefetchedDataFuture(url); // eslint-disable-line no-use-before-define\n            if (!disableLoadingIndicator) {\n                LoadingIndicator_1.loadingIndicator.show();\n            }\n            if (!future) {\n                future = fetch(url, FetchFunctions.sameOriginFetchOption(fetchOptions));\n                if (!ignoreRefreshHeader) {\n                    future = future.then(FetchFunctions.checkRefreshHeader);\n                }\n                future = future.then(FetchFunctions.checkStatus).then(FetchFunctions.parseJSON, FetchFunctions.parseErrorJson);\n                if (!disableLoadingIndicator) {\n                    future = future.then(FetchFunctions.stopLoadingIndicator, function (err) {\n                        FetchFunctions.stopLoadingIndicator(err);\n                        throw err;\n                    });\n                }\n            }\n            else if (!disableLoadingIndicator) {\n                LoadingIndicator_1.loadingIndicator.hide();\n            }\n            if (onSuccess) {\n                return future.then(onSuccess).catch(FetchFunctions.onError(onError));\n            }\n            return future;\n        };\n        if (disableDedupe || !isGetRequest(fetchOptions)) {\n            return request();\n        }\n        return dedupe_calls_1.dedupe(url, request);\n    };\n    /**\n     * Raw fetch.\n     *\n     * This method is semi-private, under normal conditions it should not be\n     * used as it does not include the JWT bearer token\n     *\n     * @param {string} url - The URL to fetch from.\n     * @param {Object} [options]\n     * @param {function} [options.onSuccess] - Optional callback success function.\n     * @param {function} [options.onError] - Optional error callback.\n     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.\n     * @param {boolean} [options.disableDedupe] - Optional flag to disable dedupe for this request.\n     * @param {boolean} [options.disableLoadingIndicator] - Optional flag to disable loading indicator for this request.\n     * @returns fetch response\n     */\n    FetchFunctions.rawFetch = function (url, _a) {\n        var _b = _a === void 0 ? {} : _a, onSuccess = _b.onSuccess, onError = _b.onError, fetchOptions = _b.fetchOptions, disableDedupe = _b.disableDedupe, disableLoadingIndicator = _b.disableLoadingIndicator, ignoreRefreshHeader = _b.ignoreRefreshHeader;\n        var request = function () {\n            var future = getPrefetchedDataFuture(url); // eslint-disable-line no-use-before-define\n            if (!future) {\n                if (!disableLoadingIndicator) {\n                    LoadingIndicator_1.loadingIndicator.show();\n                }\n                future = fetch(url, FetchFunctions.sameOriginFetchOption(fetchOptions));\n                if (!ignoreRefreshHeader) {\n                    future = future.then(FetchFunctions.checkRefreshHeader);\n                }\n                future = future.then(FetchFunctions.checkStatus);\n                if (!disableLoadingIndicator) {\n                    future = future.then(FetchFunctions.stopLoadingIndicator, function (err) {\n                        FetchFunctions.stopLoadingIndicator(err);\n                        throw err;\n                    });\n                }\n            }\n            if (onSuccess) {\n                return future.then(onSuccess).catch(FetchFunctions.onError(onError));\n            }\n            return future;\n        };\n        if (disableDedupe || !isGetRequest(fetchOptions)) {\n            return request();\n        }\n        return dedupe_calls_1.dedupe(url, request);\n    };\n    return FetchFunctions;\n}());\nexports.FetchFunctions = FetchFunctions;\nvar Fetch = /** @class */ (function () {\n    function Fetch() {\n    }\n    /**\n     * Fetch JSON data.\n     * <p>\n     * Utility function that can be mocked for testing.\n     *\n     * @param {string} url - The URL to fetch from.\n     * @param {Object} [options]\n     * @param {function} [options.onSuccess] - Optional callback success function.\n     * @param {function} [options.onError] - Optional error callback.\n     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.\n     * @returns JSON body.\n     */\n    Fetch.fetchJSON = function (url, _a) {\n        var _b = _a === void 0 ? {} : _a, onSuccess = _b.onSuccess, onError = _b.onError, fetchOptions = _b.fetchOptions, disableCapabilities = _b.disableCapabilities, disableLoadingIndicator = _b.disableLoadingIndicator, ignoreRefreshHeader = _b.ignoreRefreshHeader;\n        var fixedUrl = FetchFunctions.prefixUrl(url);\n        var future;\n        var crumbHeaderName = urlconfig_1.UrlConfig.getCrumbHeaderName();\n        if (crumbHeaderName && fetchOptions && fetchOptions.headers) {\n            fetchOptions.headers[crumbHeaderName] = urlconfig_1.UrlConfig.getCrumbToken();\n        }\n        if (!config_1.AppConfig.isJWTEnabled()) {\n            future = FetchFunctions.rawFetchJSON(fixedUrl, { onSuccess: onSuccess, onError: onError, fetchOptions: fetchOptions, disableLoadingIndicator: disableLoadingIndicator, ignoreRefreshHeader: ignoreRefreshHeader });\n        }\n        else {\n            future = jwt_1.JWT.getToken().then(function (token) {\n                return FetchFunctions.rawFetchJSON(fixedUrl, {\n                    onSuccess: onSuccess,\n                    onError: onError,\n                    fetchOptions: FetchFunctions.jwtFetchOption(token, fetchOptions),\n                });\n            });\n        }\n        if (!disableCapabilities) {\n            return future.then(function (data) { return index_1.capabilityAugmenter.augmentCapabilities(utils_1.Utils.clone(data)); });\n        }\n        return future;\n    };\n    /**\n     * Fetch data.\n     * <p>\n     * Utility function that can be mocked for testing.\n     *\n     * @param {string} url - The URL to fetch from.\n     * @param {Object} [options]\n     * @param {function} [options.onSuccess] - Optional callback success function.\n     * @param {function} [options.onError] - Optional error callback.\n     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.\n     * @returns fetch body.\n     */\n    Fetch.fetch = function (url, _a) {\n        var _b = _a === void 0 ? {} : _a, onSuccess = _b.onSuccess, onError = _b.onError, fetchOptions = _b.fetchOptions, disableLoadingIndicator = _b.disableLoadingIndicator, ignoreRefreshHeader = _b.ignoreRefreshHeader;\n        var fixedUrl = FetchFunctions.prefixUrl(url);\n        var crumbHeaderName = urlconfig_1.UrlConfig.getCrumbHeaderName();\n        if (crumbHeaderName && fetchOptions && fetchOptions.headers) {\n            fetchOptions.headers[crumbHeaderName] = urlconfig_1.UrlConfig.getCrumbToken();\n        }\n        if (!config_1.AppConfig.isJWTEnabled()) {\n            return FetchFunctions.rawFetch(fixedUrl, { onSuccess: onSuccess, onError: onError, fetchOptions: fetchOptions, disableLoadingIndicator: disableLoadingIndicator, ignoreRefreshHeader: ignoreRefreshHeader });\n        }\n        return jwt_1.JWT.getToken().then(function (token) {\n            return FetchFunctions.rawFetch(fixedUrl, {\n                onSuccess: onSuccess,\n                onError: onError,\n                fetchOptions: FetchFunctions.jwtFetchOption(token, fetchOptions),\n            });\n        });\n    };\n    return Fetch;\n}());\nexports.Fetch = Fetch;\nfunction trimRestUrl(url) {\n    var REST_PREFIX = 'blue/rest/';\n    var prefixOffset = url.indexOf(REST_PREFIX);\n    if (prefixOffset !== -1) {\n        return url.substring(prefixOffset);\n    }\n    return url;\n}\nfunction getPrefetchedDataFuture(url) {\n    var trimmedUrl = trimRestUrl(url);\n    for (var prop in scopes_1.prefetchdata) {\n        if (scopes_1.prefetchdata.hasOwnProperty(prop)) {\n            var preFetchEntry = scopes_1.prefetchdata[prop];\n            if (preFetchEntry.restUrl && preFetchEntry.data) {\n                // If the trimmed/normalized rest URL matches the url arg supplied\n                // to the function, construct a pre-resolved future object containing\n                // the prefetched data as the value.\n                if (trimRestUrl(preFetchEntry.restUrl) === trimmedUrl) {\n                    try {\n                        return Promise.resolve(JSON.parse(preFetchEntry.data));\n                    }\n                    finally {\n                        // Delete the preFetchEntry i.e. we only use these entries once. So, this\n                        // works only for the first request for the data at that URL. Subsequent\n                        // calls on that REST endpoint will result in a proper fetch. A local\n                        // store needs to be used (redux/mobx etc) if you want to avoid multiple calls\n                        // for the same data. This is not a caching layer/mechanism !!!\n                        delete scopes_1.prefetchdata[prop];\n                    }\n                }\n            }\n        }\n    }\n    return undefined;\n}","deps":{"./LoadingIndicator":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/LoadingIndicator.js","./capability/index":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/capability/index.js","./config":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/config.js","./jwt":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/jwt.js","./scopes":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/scopes.js","./urlconfig":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/urlconfig.js","./utils":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/utils.js","./utils/dedupe-calls":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/utils/dedupe-calls.js","bluebird":"node_modules/bluebird/js/browser/bluebird.js","isomorphic-fetch":"node_modules/isomorphic-fetch/fetch-npm-browserify.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/i18n/bundle-startup.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; /*\n                                                                                                                                                                                                                                                                               * The MIT License\n                                                                                                                                                                                                                                                                               *\n                                                                                                                                                                                                                                                                               * Copyright (c) 2017, CloudBees, Inc.\n                                                                                                                                                                                                                                                                               *\n                                                                                                                                                                                                                                                                               * Permission is hereby granted, free of charge, to any person obtaining a copy\n                                                                                                                                                                                                                                                                               * of this software and associated documentation files (the \"Software\"), to deal\n                                                                                                                                                                                                                                                                               * in the Software without restriction, including without limitation the rights\n                                                                                                                                                                                                                                                                               * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n                                                                                                                                                                                                                                                                               * copies of the Software, and to permit persons to whom the Software is\n                                                                                                                                                                                                                                                                               * furnished to do so, subject to the following conditions:\n                                                                                                                                                                                                                                                                               *\n                                                                                                                                                                                                                                                                               * The above copyright notice and this permission notice shall be included in\n                                                                                                                                                                                                                                                                               * all copies or substantial portions of the Software.\n                                                                                                                                                                                                                                                                               *\n                                                                                                                                                                                                                                                                               * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n                                                                                                                                                                                                                                                                               * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n                                                                                                                                                                                                                                                                               * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n                                                                                                                                                                                                                                                                               * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n                                                                                                                                                                                                                                                                               * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n                                                                                                                                                                                                                                                                               * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n                                                                                                                                                                                                                                                                               * THE SOFTWARE.\n                                                                                                                                                                                                                                                                               */\n\n/**\n * Client bundle startup script for loading i18n resources.\n * <p>\n * Ensures that i18n resources are loaded before the bundle starts to execute.\n */\n\nexports.execute = execute;\n\nvar _config = require('../config');\n\nvar _logging = require('../logging');\n\nvar _i18n = require('./i18n');\n\nvar logger = _logging.logging.logger('io.jenkins.blueocean.i18n.startup');\n\n/**\n * Load the i18n resources defined for the plugin (in the extensions).\n *\n * @param {function} done Callback function. Called once all resources.\n * @param {object} bundleConfig Bundle configuration parameters.\n */\nfunction execute(done, bundleConfig) {\n    if (bundleConfig.hpiPluginId) {\n        var pluginInfo = _config.AppConfig.getPluginInfo(bundleConfig.hpiPluginId);\n        if (pluginInfo) {\n            if (pluginInfo.i18nBundles && pluginInfo.i18nBundles.length > 0) {\n                logger.debug('Plugin ' + bundleConfig.hpiPluginId + ' defines i18n resource bundles that must be loaded:', pluginInfo.i18nBundles);\n                var loadedBundles = [];\n                var loadBundle = function loadBundle(namespace) {\n                    var hpiPluginId = bundleConfig.hpiPluginId;\n                    var i18nResource = namespace;\n\n                    // By default the i18n resource is loaded from the same plugin as the\n                    // js-extension bundle, but sometimes you need to load it from another plugin.\n                    // The namespace can be defined as an object defining an alternate hpiPluginId.\n                    if ((typeof namespace === 'undefined' ? 'undefined' : _typeof(namespace)) === 'object') {\n                        hpiPluginId = namespace.hpiPluginId;\n                        i18nResource = namespace.resource;\n                    }\n\n                    var translator = (0, _i18n.i18nTranslator)(hpiPluginId, i18nResource, function () {\n                        if (loadedBundles.indexOf(namespace) === -1) {\n                            logger.debug('Loading of i18n resource bundle \"' + bundleConfig.hpiPluginId + ':' + namespace + '\" done.');\n                            loadedBundles.push(namespace);\n                            if (loadedBundles.length === pluginInfo.i18nBundles.length) {\n                                // All bundles are loaded ... ok for the bundle to execute now (from an i18n pov).\n                                logger.log('All i18n \"' + bundleConfig.hpiPluginId + '\" resource bundles loaded.', pluginInfo.i18nBundles);\n                                done();\n                            }\n                        }\n                    });\n                    // Call the translator to trigger loading.\n                    // Any random key is fine ... just needs to trigger the loading.\n                    translator('xxxx');\n                };\n                pluginInfo.i18nBundles.forEach(function (bundleNamespace) {\n                    return loadBundle(bundleNamespace);\n                });\n            } else {\n                logger.debug('Plugin \"' + bundleConfig.hpiPluginId + '\" doesn\\'t define any i18n resource bundles.');\n                done();\n            }\n        } else {\n            logger.warn('Unexpected error finding plugin info for plugin ' + bundleConfig.hpiPluginId + '. There should be a preloaded jsExtensions entry.');\n            done();\n        }\n    } else {\n        done();\n    }\n}","deps":{"../config":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/config.js","../logging":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/logging.js","./i18n":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/i18n/i18n.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/i18n/i18n.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.defaultLngDetector = undefined;\nexports.i18nTranslator = i18nTranslator;\nexports.enableMocksForI18n = enableMocksForI18n;\nexports.disableMocksForI18n = disableMocksForI18n;\n\nvar _i18next = require('i18next');\n\nvar _i18next2 = _interopRequireDefault(_i18next);\n\nvar _i18nextBrowserLanguagedetector = require('i18next-browser-languagedetector');\n\nvar _i18nextBrowserLanguagedetector2 = _interopRequireDefault(_i18nextBrowserLanguagedetector);\n\nvar _jsExtensions = require('@jenkins-cd/js-modules').requireModule('jenkins-cd-js-extensions:jenkins-cd-js-extensions@any');\n\nvar _i18nextXhrBackend = require('i18next-xhr-backend');\n\nvar _i18nextXhrBackend2 = _interopRequireDefault(_i18nextXhrBackend);\n\nvar _urlconfig = require('../urlconfig');\n\nvar _logging = require('../logging');\n\nvar _fetch = require('../fetch');\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar logger = _logging.logging.logger('io.jenkins.blueocean.i18n');\n\n/**\n * Init language detector, we are going to use first queryString and then the navigator prefered language\n */\nvar defaultLngDetector = exports.defaultLngDetector = new _i18nextBrowserLanguagedetector2.default(null, {\n    // order and from where user language should be detected\n    order: ['querystring', 'htmlTag', 'navigator'],\n    // keys or params to lookup language from\n    lookupQuerystring: 'language',\n    // Don't use the default (document.documentElement) because that can\n    // trigger the browsers auto-translate, which is quite annoying.\n    htmlTag: window.document ? window.document.head : undefined\n});\nvar prefix = _urlconfig.UrlConfig.getJenkinsRootURL() || '';\nvar FALLBACK_LANG = '';\n\nfunction newPluginXHR(pluginName) {\n    var pluginVersion = _jsExtensions.store.getPluginVersion(pluginName);\n\n    if (!pluginVersion) {\n        // if we do not have a version we may have an alias to resolve a resourceBUndle\n        throw new Error('Unable to create an i18n instance for plugin \"' + pluginName + '\". This plugin is not currently installed, or is disabled.');\n    }\n\n    pluginVersion = encodeURIComponent(pluginVersion);\n\n    var loadPath = prefix + '/blue/rest/i18n/' + pluginName + '/' + pluginVersion + '/{ns}/{lng}';\n    return new _i18nextXhrBackend2.default(null, {\n        loadPath: loadPath,\n        allowMultiLoading: false,\n        ajax: function ajax(url, options, callback) {\n            if (logger.isDebugEnabled()) {\n                logger.debug('loading data for', url);\n            }\n            var fetchOptions = {\n                method: 'PUT',\n                headers: {\n                    'Content-Type': 'application/json'\n                }\n            };\n            _fetch.Fetch.fetchJSON(url, { disableCapabilities: true, disableLoadingIndicator: true, ignoreRefreshHeader: true, fetchOptions: fetchOptions }).then(function (data) {\n                callback(data, { status: 200 });\n            });\n        },\n        parse: function parse(response) {\n            if (logger.isDebugEnabled()) {\n                logger.debug('Received i18n resource bundle for plugin \"%s\".', pluginName, response.data);\n            }\n            return response.data;\n        }\n    });\n}\n\n/**\n * Create a instance of i18next and init it\n * in case we are in test mode and run unit test, we deliver a i18next instance that are not using any backend nor language detection\n * @param backend  {object} - the backend XHR invoker we want to use\n * @param lngDetector {object} - the component that detects which language we want to display\n * @param options {object} - general options for i18next\n * @see defaultOptions\n */\nvar i18nextInstance = function i18nextInstance(backend) {\n    var lngDetector = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : defaultLngDetector;\n    var options = arguments[2];\n\n    if (!backend) {\n        throw new Error('Invalid call to create a new i18next instance. No backend XHR invoker supplied.');\n    }\n    if (!options) {\n        throw new Error('Invalid call to create a new i18next instance. No i18next options supplied.');\n    }\n    return _i18next2.default.createInstance().use(backend).use(lngDetector).init(options);\n};\n\nvar translatorCache = {};\nvar useMockFallback = false;\n\nvar assertPluginNameDefined = function assertPluginNameDefined(pluginName) {\n    if (!pluginName) {\n        throw new Error('\"pluginName\" arg cannot be null/blank');\n    }\n};\n\nvar toDefaultNamespace = function toDefaultNamespace(pluginName) {\n    assertPluginNameDefined(pluginName);\n    // Replace all hyphen chars with a dot.\n    return 'jenkins.plugins.' + pluginName.replace(/-/g, '.') + '.Messages';\n};\n\n/**\n * Create an i18next instance for accessing i18n resource bundles\n * in the named plugin namespace.\n * @param pluginName The name of the plugin.\n * @param namespace The resource bundle namespace. Optional, defaulting to\n * the plugin's default resource bundle e.g. \"jenkins.plugins.blueocean.web.Messages\"\n * for the \"blueocean-web\" plugin and \"jenkins.plugins.blueocean.dashboard.Messages\"\n * for the \"blueocean-dashboard\" plugin.\n * @return An i18n instance.\n */\nvar pluginI18next = function pluginI18next(pluginName) {\n    var namespace = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : toDefaultNamespace(pluginName);\n\n    assertPluginNameDefined(pluginName);\n\n    var initOptions = {\n        ns: [namespace],\n        defaultNS: namespace,\n        keySeparator: false, // we do not have any nested keys in properties files\n        debug: false,\n        fallbackLng: FALLBACK_LANG,\n        load: 'currentOnly',\n        interpolation: {\n            prefix: '{',\n            suffix: '}',\n            escapeValue: false // not needed for react!!\n        }\n    };\n\n    return i18nextInstance(newPluginXHR(pluginName), defaultLngDetector, initOptions);\n};\n\nfunction buildCacheKey(pluginName) {\n    var namespace = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : toDefaultNamespace(pluginName);\n\n    return pluginName + ':' + namespace;\n}\n\n/**\n * Create an i18n Translator instance for accessing i18n resource bundles\n * in the named plugin namespace.\n * @param pluginName The name of the plugin.\n * @param namespace The resource bundle namespace. Optional, defaulting to\n * the plugin's default resource bundle e.g. \"jenkins.plugins.blueocean.web.Messages\"\n * for the \"blueocean-web\" plugin and \"jenkins.plugins.blueocean.dashboard.Messages\"\n * for the \"blueocean-dashboard\" plugin.\n * @return An i18n Translator instance.\n */\nfunction i18nTranslator(pluginName, namespace, onLoad) {\n    assertPluginNameDefined(pluginName);\n\n    var translatorCacheKey = buildCacheKey(pluginName, namespace);\n    var translator = translatorCache[translatorCacheKey];\n\n    if (translator) {\n        if (typeof onLoad === 'function') {\n            onLoad();\n        }\n        return translator;\n    }\n\n    // Lazily construct what we need instead of on creation\n    return function translate(key, params) {\n        if (useMockFallback) {\n            return params && params.defaultValue || key;\n        }\n\n        if (!translator) {\n            var I18n = pluginI18next(pluginName, namespace);\n            if (typeof onLoad === 'function') {\n                I18n.on('loaded', onLoad);\n            }\n\n            // Create and cache the translator instance.\n            var detectedLang = void 0;\n            try {\n                detectedLang = defaultLngDetector.detect();\n            } catch (e) {\n                detectedLang = FALLBACK_LANG;\n            }\n\n            if (logger.isLogEnabled()) {\n                logger.log('Translator instance created for \"%s\". Language detected as \"%s\".', translatorCacheKey, detectedLang);\n            }\n\n            var fixedT = I18n.getFixedT(detectedLang, namespace);\n            translator = function _translate(i18nKey, i18nParams) {\n                var normalizedKey = i18nKey.replace(/[\\W]/g, '.');\n                var passedParams = i18nParams;\n                if (normalizedKey !== i18nKey) {\n                    if (!passedParams) {\n                        passedParams = {};\n                    }\n                    if (!passedParams.defaultValue) {\n                        passedParams.defaultValue = i18nKey;\n                    }\n                    if (logger.isDebugEnabled()) {\n                        logger.debug('Normalized i18n key \"' + i18nKey + '\" to \"' + normalizedKey + '\".');\n                    }\n                }\n                return fixedT(normalizedKey, passedParams);\n            };\n            translatorCache[translatorCacheKey] = translator;\n        }\n\n        if (key) {\n            return translator(key, params);\n        }\n        return undefined;\n    };\n}\n\nfunction enableMocksForI18n() {\n    useMockFallback = true;\n}\n\nfunction disableMocksForI18n() {\n    useMockFallback = false;\n}","deps":{"../fetch":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/fetch.js","../logging":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/logging.js","../urlconfig":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/urlconfig.js","@jenkins-cd/js-modules":"node_modules/@jenkins-cd/js-modules/js/index.js","i18next":"node_modules/i18next/index.js","i18next-browser-languagedetector":"node_modules/i18next-browser-languagedetector/index.js","i18next-xhr-backend":"node_modules/i18next-xhr-backend/index.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/jwt.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.JWT = undefined;\n\nvar _bluebird = require('bluebird');\n\nvar _bluebird2 = _interopRequireDefault(_bluebird);\n\nvar _isomorphicFetch = require('isomorphic-fetch');\n\nvar _isomorphicFetch2 = _interopRequireDefault(_isomorphicFetch);\n\nvar _jsonwebtoken = require('jsonwebtoken');\n\nvar _jsonwebtoken2 = _interopRequireDefault(_jsonwebtoken);\n\nvar _fetch = require('./fetch');\n\nvar _pemJwk = require('pem-jwk');\n\nvar _config = require('./config');\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar storedToken = null;\nvar publicKeyStore = null;\nvar tokenFetchPromise = null;\n\nvar CLOCK_SKEW_SECONDS = 60;\nvar JWT = exports.JWT = {\n    /**\n     * Fetches the JWT token. This token is cached for a default of 25mins.\n     * If it is within 5mins or expiry it will fetch a new one.\n     */\n    fetchJWT: function fetchJWT() {\n        if (storedToken && storedToken.exp) {\n            var diff = storedToken.exp - Math.trunc(new Date().getTime() / 1000);\n\n            // refetch token if we are within 60s of it exp\n            if (diff < CLOCK_SKEW_SECONDS) {\n                tokenFetchPromise = null;\n            }\n        }\n\n        if (!tokenFetchPromise) {\n            tokenFetchPromise = (0, _isomorphicFetch2.default)(_config.AppConfig.getJWTServiceHostUrl() + '/jwt-auth/token', { credentials: 'include', mode: 'cors' }).then(this.checkStatus).then(function (response) {\n                var token = response.headers.get('X-BLUEOCEAN-JWT');\n                if (token) {\n                    return token;\n                }\n\n                throw new Error('Could not fetch jwt_token');\n            });\n        }\n\n        return tokenFetchPromise;\n    },\n\n\n    /**\n     * Verifies the token using the public key.\n     */\n    verifyToken: function verifyToken(token, certObject) {\n        return new _bluebird2.default(function (resolve, reject) {\n            return _jsonwebtoken2.default.verify(token, (0, _pemJwk.jwk2pem)(certObject), { algorithms: [certObject.alg], clockTolerance: CLOCK_SKEW_SECONDS }, function (err, payload) {\n                if (err) {\n                    reject(err);\n                } else {\n                    resolve(payload);\n                }\n            });\n        });\n    },\n\n\n    /**\n     * Fetches the public key that is used to verify tokens.\n     */\n    fetchJWTPublicKey: function fetchJWTPublicKey(token) {\n        var _this = this;\n\n        var decoded = _jsonwebtoken2.default.decode(token, { complete: true });\n        var url = _config.AppConfig.getJWTServiceHostUrl() + '/jwt-auth/jwks/' + decoded.header.kid + '/';\n        if (!publicKeyStore) {\n            publicKeyStore = (0, _isomorphicFetch2.default)(url, { credentials: 'same-origin' }).then(_fetch.FetchFunctions.checkStatus).then(_fetch.FetchFunctions.parseJSON).then(function (cert) {\n                return _this.verifyToken(token, cert).then(function (payload) {\n                    return {\n                        token: token,\n                        payload: payload\n                    };\n                });\n            });\n        }\n\n        return publicKeyStore;\n    },\n\n\n    /**\n     * Puts the token into global storage for later use.\n     */\n    storeToken: function storeToken(data) {\n        storedToken = data.payload;\n        return data;\n    },\n\n\n    /**\n     * Use this function if you want the payload from the token.\n     */\n    getTokenWithPayload: function getTokenWithPayload() {\n        var _this2 = this;\n\n        return this.fetchJWT().then(_fetch.FetchFunctions.checkStatus).then(function (token) {\n            return _this2.fetchJWTPublicKey(token);\n        }).then(function (data) {\n            return _this2.storeToken(data);\n        });\n    },\n\n\n    /**\n     * Gets the token from te server and verifies it.\n     */\n    getToken: function getToken() {\n        return this.getTokenWithPayload().then(function (token) {\n            return token.token;\n        });\n    }\n};","deps":{"./config":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/config.js","./fetch":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/fetch.js","bluebird":"node_modules/bluebird/js/browser/bluebird.js","isomorphic-fetch":"node_modules/isomorphic-fetch/fetch-npm-browserify.js","jsonwebtoken":"node_modules/jsonwebtoken/index.js","pem-jwk":"node_modules/pem-jwk/index.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/logging.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n  value: true\n});\nexports.logging = undefined;\n\nvar _logging = require('@jenkins-cd/logging');\n\nvar logging = _interopRequireWildcard(_logging);\n\nfunction _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }\n\nexports.logging = logging;","deps":{"@jenkins-cd/logging":"node_modules/@jenkins-cd/logging/index.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/scopes.js","source":"(function (global){\n'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n  value: true\n});\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; };\n\n/*\n * The MIT License\n *\n * Copyright (c) 2016, CloudBees, Inc.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a copy\n * of this software and associated documentation files (the \"Software\"), to deal\n * in the Software without restriction, including without limitation the rights\n * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the Software is\n * furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n * THE SOFTWARE.\n */\n\nvar root = exports.root = (typeof self === 'undefined' ? 'undefined' : _typeof(self)) === 'object' && self.self === self && self || (typeof global === 'undefined' ? 'undefined' : _typeof(global)) === 'object' && global.global === global && global || undefined;\n\n//\n// See blueocean-config/src/main/java/io/jenkins/blueocean/config/BlueOceanConfig.java\n// and blueocean-config/src/main/resources/io/jenkins/blueocean/config/BlueOceanConfig/header.jelly\n//\nvar blueocean = exports.blueocean = root.$blueocean || {};\n\nvar prefetchdata = exports.prefetchdata = blueocean.prefetchdata || {};\n\n\n}).call(this,typeof global !== \"undefined\" ? global : typeof self !== \"undefined\" ? self : typeof window !== \"undefined\" ? window : {})","deps":{}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/storage.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports._clearJenkinsNS = exports.installInfo = exports.jenkinsNS = undefined;\n\nvar _storage = require('@jenkins-cd/storage');\n\nvar storage = _interopRequireWildcard(_storage);\n\nvar _scopes = require('./scopes');\n\nvar _config = require('./config');\n\nfunction _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }\n\nvar jenkinsNS = exports.jenkinsNS = storage.jenkinsNamespace(); /*\n                                                                 * The MIT License\n                                                                 *\n                                                                 * Copyright (c) 2017, CloudBees, Inc.\n                                                                 *\n                                                                 * Permission is hereby granted, free of charge, to any person obtaining a copy\n                                                                 * of this software and associated documentation files (the \"Software\"), to deal\n                                                                 * in the Software without restriction, including without limitation the rights\n                                                                 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n                                                                 * copies of the Software, and to permit persons to whom the Software is\n                                                                 * furnished to do so, subject to the following conditions:\n                                                                 *\n                                                                 * The above copyright notice and this permission notice shall be included in\n                                                                 * all copies or substantial portions of the Software.\n                                                                 *\n                                                                 * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n                                                                 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n                                                                 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n                                                                 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n                                                                 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n                                                                 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n                                                                 * THE SOFTWARE.\n                                                                 */\n\n/**\n * Client-side local storage for Blue Ocean.\n * See https://github.com/jenkinsci/js-storage\n */\n\nvar installInfo = exports.installInfo = jenkinsNS.subspace('installInfo');\n\n/**\n * Check do we need to clear the jenkinsNS.\n * <p>\n * Simple process of checking if the version OR list of plugins\n * stored (from the last change) have changed based on what was\n * delivered with this page.\n * <p>\n * Internal use only. Exported for testing purposes only.\n * @param {string} installVersion The version of the Jenkins instance that's running now\n * i.e. that loaded this page.\n * @param {Array} installPluginList The list of active plugins installed in the Jenkins instance\n * that's running now i.e. that loaded this page.\n * @private\n */\nvar _clearJenkinsNS = exports._clearJenkinsNS = function _clearJenkinsNS(installVersion, installPluginList) {\n    // Info about the Jenkins that was running the last time we loaded this page.\n    var storedVersion = installInfo.get('version');\n    var storedPluginList = installInfo.get('plugins');\n\n    var doClear = function doClear(because) {\n        jenkinsNS.clear();\n        installInfo.set('version', installVersion);\n        installInfo.set('plugins', installPluginList);\n        installInfo.set('lastcleared', {\n            at: Date.now(),\n            because: because\n        });\n    };\n\n    try {\n        if (storedVersion && storedPluginList) {\n            // compare the Jenkins version\n            if (installVersion !== storedVersion) {\n                doClear('Jenkins versions did not match. installVersion: ' + installVersion + ', storedVersion: ' + storedVersion);\n            } else {\n                // compare the plugin lists\n                if (installPluginList.length !== storedPluginList.length) {\n                    // Different number of active plugins.\n                    // No need to check the names and versions.\n                    doClear('Different number of active plugins');\n                } else {\n                    // Same number of plugins. Lets check that they all\n                    // match up i.e. that we can find each plugin in each list and\n                    // that the versions match.\n                    try {\n                        installPluginList.forEach(function (installedPlugin) {\n                            var found = false;\n                            storedPluginList.forEach(function (storedPlugin) {\n                                if (storedPlugin.hpiPluginId === installedPlugin.hpiPluginId) {\n                                    // same plugin.\n                                    found = true;\n                                    // Check the versions.\n                                    if (storedPlugin.hpiPluginVer !== installedPlugin.hpiPluginVer) {\n                                        throw new Error('Different plugin versions for plugin ' + installedPlugin.hpiPluginId);\n                                    }\n                                }\n                            });\n                            if (!found) {\n                                throw new Error('New plugin installed ' + installedPlugin.hpiPluginId);\n                            }\n                        });\n                    } catch (e) {\n                        // One of the plugins has been updated or removed.\n                        // See Errors thrown inside above try/catch.\n                        doClear(e.message);\n                    }\n                }\n            }\n        } else {\n            // Theoretically no need to clear in this case,\n            // but lets do it anyway.\n            doClear('No Jenkins info stored. Clearing anyway, just in case.');\n        }\n    } catch (e) {\n        console.error('Unexpected error while checking/clearing Jenkins instance client-side storage. Clearing as a precaution.', e);\n        doClear('Unexpected error while checking/clearing Jenkins instance client-side storage: ' + e.message);\n    }\n};\n\n// Call the clear function automatically.\nvar installVersion = _config.AppConfig.getJenkinsConfig().version;\nvar installPluginList = _scopes.blueocean.jsExtensions;\nif (installVersion && installPluginList) {\n    _clearJenkinsNS(installVersion, installPluginList);\n} else {\n    console.warn('Unexpected state. Blue Ocean preload state not on page as expected. This is okay if running in a test.');\n}","deps":{"./config":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/config.js","./scopes":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/scopes.js","@jenkins-cd/storage":"node_modules/@jenkins-cd/storage/index.js"}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/urlconfig.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nvar jenkinsRootURL = '';\nvar blueOceanAppURL = '/';\nvar restBaseURL = '';\nvar crumbToken = '';\nvar crumbHeaderName = '';\n\nvar loaded = false;\n\nfunction loadConfig() {\n    try {\n        var headElement = document.getElementsByTagName('head')[0];\n\n        // typically '/jenkins/'\n        jenkinsRootURL = headElement.getAttribute('data-rooturl');\n        if (typeof jenkinsRootURL !== 'string') {\n            jenkinsRootURL = '/';\n        }\n\n        // typically '/jenkins/blue'\n        blueOceanAppURL = headElement.getAttribute('data-appurl');\n        if (typeof blueOceanAppURL !== 'string') {\n            blueOceanAppURL = '/';\n        }\n\n        // typically '/jenkins/blue/rest'\n        restBaseURL = (blueOceanAppURL + '/rest').replace(/\\/\\/+/g, '/'); // eliminate any duplicated slashes\n\n        // load crumb token used for POST requests\n        crumbToken = headElement.getAttribute('data-crumbtoken');\n        if (typeof crumbToken !== 'string') {\n            crumbToken = '';\n        }\n\n        // load crumb header name used for POST requests\n        crumbHeaderName = headElement.getAttribute('data-crumbtoken-field');\n        if (typeof crumbHeaderName !== 'string') {\n            crumbHeaderName = '';\n        }\n\n        loaded = true;\n    } catch (error) {\n        // eslint-disable-next-line no-console\n        console.warn('error reading attributes from document; urls will be empty', error);\n\n        loaded = false;\n    }\n}\n\nvar UrlConfig = exports.UrlConfig = {\n    getJenkinsRootURL: function getJenkinsRootURL() {\n        if (!loaded) {\n            loadConfig();\n        }\n        return jenkinsRootURL;\n    },\n    getBlueOceanAppURL: function getBlueOceanAppURL() {\n        if (!loaded) {\n            loadConfig();\n        }\n        return blueOceanAppURL;\n    },\n    getCrumbHeaderName: function getCrumbHeaderName() {\n        if (!loaded) {\n            loadConfig();\n        }\n        return crumbHeaderName;\n    },\n    getCrumbToken: function getCrumbToken() {\n        if (!loaded) {\n            loadConfig();\n        }\n        return crumbToken;\n    },\n    getRestBaseURL: function getRestBaseURL() {\n        if (!loaded) {\n            loadConfig();\n        }\n        return restBaseURL;\n    },\n\n    // for testing purposes: allow url's to be reloaded\n    enableReload: function enableReload() {\n        loaded = false;\n    }\n};","deps":{}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/utils.js","source":"(function (global){\n'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; };\n\nexports.stopProp = stopProp;\n\n\n/**\n * Trims duplicate forward slashes to a single slash and adds trailing slash if needed.\n * @param url\n * @returns {string}\n */\nfunction cleanSlashes(url) {\n    var baseUrl = '';\n    var urlParams = '';\n\n    if (url && url.indexOf('?') > -1) {\n        baseUrl = url.split('?').slice(0, 1).join('');\n        urlParams = url.split('?').slice(-1).join('');\n    } else {\n        baseUrl = url;\n    }\n\n    // replace any number of consecutive slashes with one slash\n    baseUrl = baseUrl.replace(/\\/\\/+/g, '/');\n\n    if (baseUrl.substr(-1) !== '/') {\n        baseUrl = baseUrl + '/';\n    }\n\n    return !urlParams ? baseUrl : baseUrl + '?' + urlParams;\n}\n\n/**\n * Generate a \"unique\" ID with an optional prefix\n * @param prefix\n * @returns {string}\n */\nfunction randomId() {\n    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';\n\n    var integer = Math.round(Math.random() * Number.MAX_SAFE_INTEGER);\n    return prefix + '-' + integer;\n}\n\n/**\n * Swallow an event, preventing it from reaching containing react components or default DOM behaviour\n * @param event\n */\nfunction stopProp(event) {\n    event.stopPropagation(); // Keeps event from containing elements' onClick handlers\n    event.preventDefault(); // Keeps event from triggering DOM builtins such as <a> elements\n}\n\nvar Utils = exports.Utils = {\n    stopProp: stopProp,\n    cleanSlashes: cleanSlashes,\n    randomId: randomId,\n    clone: function clone(obj) {\n        if (!obj) return obj;\n        return JSON.parse(JSON.stringify(obj));\n    },\n    windowOrGlobal: function windowOrGlobal() {\n        return (typeof self === 'undefined' ? 'undefined' : _typeof(self)) === 'object' && self.self === self && self || (typeof global === 'undefined' ? 'undefined' : _typeof(global)) === 'object' && global.global === global && global || this;\n    },\n    refreshPage: function refreshPage() {\n        if (this.windowOrGlobal().location.reload) {\n            this.windowOrGlobal().location.reload(true);\n        }\n    }\n};\n\n\n}).call(this,typeof global !== \"undefined\" ? global : typeof self !== \"undefined\" ? self : typeof window !== \"undefined\" ? window : {})","deps":{}},{"id":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/utils/dedupe-calls.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.DeDupeCallTracker = undefined;\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nexports.dedupe = dedupe;\n\nvar _bluebird = require('bluebird');\n\nvar _bluebird2 = _interopRequireDefault(_bluebird);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/**\n * DuplicateCallTracker maintains active calls against a particular key\n */\nvar DeDupeCallTracker = exports.DeDupeCallTracker = function () {\n    function DeDupeCallTracker() {\n        _classCallCheck(this, DeDupeCallTracker);\n\n        /**\n         * Onload callbacks cache. Used to ensure we don't\n         * issue multiple in-parallel requests for the same\n         * class metadata.\n         */\n        this.promises = {};\n    }\n\n    /**\n     * Generalization of duplicate request consolidation:\n     *\n     * @key: key to use to track the duplicate requests\n     * @promiseCreator: function that will return an initial promise, e.g. () => fetch(...)\n     * @return a Promise\n     */\n\n\n    _createClass(DeDupeCallTracker, [{\n        key: 'dedupe',\n        value: function dedupe(key, promiseCreator) {\n            var _this = this;\n\n            // get active or create\n            return this.promises[key] || (this.promises[key] = promiseCreator().then(function (data) {\n                delete _this.promises[key];\n                return data;\n            }).catch(function (err) {\n                delete _this.promises[key];\n                return _bluebird2.default.reject(err);\n            }));\n        }\n    }]);\n\n    return DeDupeCallTracker;\n}();\n\nvar deDupeCallTracker = new DeDupeCallTracker();\n\n/**\n * Generalization of duplicate request consolidation:\n *\n * @key: key to use to track the duplicate requests\n * @promiseCreator: function that will return an initial promise, e.g. () => fetch(...)\n * @return a Promise\n */\nfunction dedupe(key, promiseCreator) {\n    return deDupeCallTracker.dedupe(key, promiseCreator);\n}","deps":{"bluebird":"node_modules/bluebird/js/browser/bluebird.js"}},{"id":"node_modules/@jenkins-cd/design-language/dist/js/components/index.js","source":"module.exports = require('@jenkins-cd/js-modules').requireModule('jenkins-cd-design-language:jenkins-cd-design-language@any');","deps":{"@jenkins-cd/js-modules":"node_modules/@jenkins-cd/js-modules/js/index.js"}},{"id":"node_modules/@jenkins-cd/js-extensions/dist/init/extension.js","source":"'use strict';\n\nObject.defineProperty(exports, \"__esModule\", {\n    value: true\n});\nexports.execute = execute;\n\nvar _jsModules = require('@jenkins-cd/js-modules');\n\nvar modules = _interopRequireWildcard(_jsModules);\n\nfunction _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }\n\n/**\n * Executes i18n for non-core-js modules\n */\nfunction execute(done, config) {\n    var CoreJs = modules.requireModule('jenkins-cd-blueocean-core-js:jenkins-cd-blueocean-core-js@any');\n    if (CoreJs.i18nBundleStartup) {\n        CoreJs.i18nBundleStartup(done, config);\n    } else {\n        // For pre-1.4 compatibility\n        require('@jenkins-cd/blueocean-core-js/dist/js/i18n/bundle-startup').execute(done, config);\n    }\n}","deps":{"@jenkins-cd/blueocean-core-js/dist/js/i18n/bundle-startup":"node_modules/@jenkins-cd/blueocean-core-js/dist/js/i18n/bundle-startup.js","@jenkins-cd/js-modules":"node_modules/@jenkins-cd/js-modules/js/index.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/ModuleSpec.js","source":"var Version = require('./Version');\n\nfunction ModuleSpec(qName) {\n    var qNameTokens = qName.split(\":\");\n    \n    if (qNameTokens.length === 2) {\n        var namespace = qNameTokens[0].trim();\n        var nsTokens = namespace.split(\"/\");\n        var namespaceProvider = undefined;\n        if (nsTokens.length === 2) {\n            namespaceProvider = nsTokens[0].trim();\n            namespace = nsTokens[1].trim();\n            if (namespaceProvider !== 'plugin' && namespaceProvider !== 'core-assets') {\n                console.error('Unsupported module namespace provider \"' + namespaceProvider + '\". Setting to undefined.');\n                namespaceProvider = undefined;\n            }\n        }\n        \n        var npmName = parseNPMName(qNameTokens[1].trim());\n        \n        this.nsProvider = namespaceProvider;\n        this.namespace = namespace;\n        this.moduleName = npmName.name;\n        this.moduleVersion = npmName.version;\n    } else {\n        // The module/bundle is not in a namespace and doesn't\n        // need to be loaded i.e. it will load itself and export.\n        var npmName = parseNPMName(qNameTokens[0].trim());\n\n        this.moduleName = npmName.name;\n        this.moduleVersion = npmName.version;\n    }\n\n    // Attach version compatibility info\n    var versions = [];\n    \n    if (this.moduleVersion) {\n        var moduleVersionTokens = this.moduleVersion.split(/[,|]+/);\n\n        for (var i = 0; i < moduleVersionTokens.length; i++) {\n            var moduleVersionToken = moduleVersionTokens[i].trim();\n            var parsedVersion = new Version(moduleVersionToken);\n            versions.push(parsedVersion);\n        }\n    }\n    \n    this.moduleCompatVersions = versions;\n}\n\nModuleSpec.prototype.getLoadBundleVersion = function() {\n    if (this.moduleCompatVersions.length === 0) {\n        // If no versions were specified on the name, then we\n        // just return undefined.\n        return undefined;\n    }\n    // If a version is specified, we use the first \"specific\" version\n    // e.g. \"1.1.2\" is specific while \"1.1.x\" and \"any\" are not.\n    for (var i = 0; i < this.moduleCompatVersions.length; i++) {\n        var version = this.moduleCompatVersions[i];\n        if (version.isSpecific()) {\n            return version;\n        }\n    }\n    \n    // If there's no specific version then we return the first\n    // version in the list.\n    return this.moduleCompatVersions[0];\n};\n\nModuleSpec.prototype.getLoadBundleName = function() {\n    var version = this.getLoadBundleVersion();\n    if (version) {\n        return this.moduleName + '@' + version.asBaseVersionString();\n    } else {\n        return this.moduleName;\n    }\n};\n\nModuleSpec.prototype.importAs = function() {\n    if (this.moduleName.charAt(0) === '.') {\n        return this.moduleName;\n    }\n    \n    var version = this.getLoadBundleVersion();\n    var importName = normalizePackageName(this.moduleName);\n    var importNS = this.namespace;\n    \n    if (!importNS) {\n        importNS = importName;\n    }\n    \n    var importAs = importNS + ':' + importName;\n    if (this.nsProvider) {\n        importAs = this.nsProvider + '/' + importAs;\n    }\n    if (version) {\n        importAs += '@' + version.asBaseVersionString();\n    }\n    \n    return importAs;\n};\n\nModuleSpec.prototype.getLoadBundleFileNamePrefix = function() {\n    var version = this.getLoadBundleVersion();\n    var normalizedName = normalizePackageName(this.moduleName);\n    if (version) {\n        // If a version was specified then we only do the script load if a\n        // specific version was provided i.e. loading does not get triggered\n        // by imports that specify non-specific version numbers e.g. \"any\"\n        // or \"1.2.x\". A specific version number would be e.g. \"1.2.3\" i.e.\n        // fully qualified. When loading is not triggered, the import is depending\n        // on another import (with a specific version) or on a bundle do an\n        // export of an internal dependency i.e. on another bundle \"providing\"\n        // the module be exporting it.\n        if (version.isSpecific()) {\n            return normalizedName + '-' + version.asLoadVersionString();\n        } else {\n            return undefined;\n        }\n    } else {\n        return normalizedName;\n    }\n};\n\n/**\n * Normalize an NPM package name by removing all non alpha numerics and replacing\n * with hyphens.\n * @param packageName The NPM package name.\n * @returns The normalized NPM package name.\n */\nfunction normalizePackageName(packageName) {\n    packageName = packageName.replace(/[^\\w.]/g, \"-\"); // replace non alphanumerics.\n    if (packageName.charAt(0) === '-') {\n        packageName = packageName.substring(1);\n    }\n    return packageName;\n};\n\nfunction parseNPMName(resourceName) {\n    if (resourceName.length > 1) {\n        var npmName = {};\n        var orgSlashIndex = resourceName.indexOf('/');\n        \n        if (resourceName.charAt(0) === '@' && orgSlashIndex > 0) {\n            // It's an NPM org package. Strip off the org and package\n            // and add it to the name. We'll get the rest then and parse\n            // that.\n            npmName.name = resourceName.substring(0, orgSlashIndex + 1);\n            \n            // Remove the org part from the name and continue parsing.\n            resourceName = resourceName.substring(orgSlashIndex + 1);\n        } else {\n            // Initialise it so we can append to it below.\n            npmName.name = '';\n        }\n        \n        var versionIndex = resourceName.indexOf('@');\n        if (versionIndex > 0) {\n            npmName.name += resourceName.substring(0, versionIndex);\n            npmName.version = resourceName.substring(versionIndex + 1);\n        } else {\n            npmName.name += resourceName;\n        }\n        \n        return npmName;\n    } else {\n        return {\n            name: resourceName\n        }\n    }\n}\n\nmodule.exports = ModuleSpec;","deps":{"./Version":"node_modules/@jenkins-cd/js-modules/js/Version.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/ResourceLocationResolver.js","source":"function ResourceLocationResolver(canResolveFunc, resolverFunc, ordinal) {\n    this.canResolveFunc = canResolveFunc;\n    this.resolverFunc = resolverFunc;\n    // Use an ordinal for crude ordering\n    if (typeof ordinal === 'number') {\n        this.ordinal = ordinal;\n    } else {\n        this.ordinal = Number.MAX_VALUE;\n    }\n}\n\nResourceLocationResolver.prototype.canResolve = function(moduleSpec) {\n    return this.canResolveFunc(moduleSpec);\n};\n\nResourceLocationResolver.sort = function (resolvers) {\n    resolvers.sort(function(r1, r2) {\n        return r2.ordinal - r1.ordinal;\n    });\n};\n\nmodule.exports = ResourceLocationResolver;","deps":{}},{"id":"node_modules/@jenkins-cd/js-modules/js/Version.js","source":"function Version(version) {\n    this.raw = version;\n\n    // Remove leading non alphanum chars e.g. to\n    // convert \"^1.2.3\" to \"1.2.3\". If the version is something\n    // like \"any\" then the string will be trimmed to nothing and\n    // the next check catches it.\n    version = version.replace(/^(\\D)/, \"\");\n    \n    if (!version || version.length === 0) {\n        return;\n    }\n    \n    function normalizeToken(string) {\n        // remove anything that's not a digit, a dot or an x.\n        var normalized = string.replace(/[^\\d]/g, '');\n        if (normalized === '') {\n            return undefined;\n        }\n        return normalized;\n    }\n    \n    var versionTokens = version.split('.');\n    \n    this.prerelease = undefined;\n    \n    var patchAndPrerelease = '';\n    for (var i = 2; i < versionTokens.length; i++) {\n        if (patchAndPrerelease.length > 0) {\n            patchAndPrerelease += '.';\n        }\n        patchAndPrerelease += versionTokens[i];\n        \n        var separatorIdx = patchAndPrerelease.indexOf('-');\n        if (separatorIdx !== -1) {\n            this.patch = normalizeToken(patchAndPrerelease.substring(0, separatorIdx));\n            this.prerelease = patchAndPrerelease.substring(separatorIdx + 1);\n        } else {\n            this.patch = normalizeToken(patchAndPrerelease);\n        }\n    }\n    \n    if (versionTokens.length >= 2) {\n        this.minor = normalizeToken(versionTokens[1]);\n    }\n    if (versionTokens.length >= 1) {\n        this.major = normalizeToken(versionTokens[0]);\n    }    \n}\n\nVersion.prototype.isSpecific = function() {\n    return (this.major !== undefined && this.minor !== undefined && this.patch !== undefined);\n};\n\n/**\n * Get the \"base\" version string for this version number.\n * <p/>\n * This string should only ever include the major, minor and patch tokens\n * of the version i.e. should never include a prerelease tag.\n * @returns {string}\n */\nVersion.prototype.asBaseVersionString = function(separator) {\n    separator = (separator ? separator : '.');\n    \n    if (!this.major || this.major === 'x') {\n        if (this.raw === 'any') {\n            return this.raw;\n        } else {\n            return undefined;\n        }\n    } else if (!this.minor || this.minor === 'x') {\n        return this.major + separator + 'x';\n    } else if (!this.patch || this.patch === 'x') {\n        return this.major + separator + this.minor + separator + 'x';\n    } else {\n        return this.major + separator + this.minor + separator + this.patch;\n    }\n};\n\n/**\n * Get the load version string for this version number.\n * <p/>\n * This string should only ever include the major, minor and patch tokens\n * of the version i.e. should never include a prerelease tag. This function\n * just calls <code>asBaseVersionString</code>, supplying a hyphen as the\n * separator.\n * @returns {string}\n */\nVersion.prototype.asLoadVersionString = function() {\n    return this.asBaseVersionString('-');\n};\n\nmodule.exports = Version;","deps":{}},{"id":"node_modules/@jenkins-cd/js-modules/js/index.js","source":"var internal = require(\"./internal\");\nvar promise = require(\"./promise\");\nvar ModuleSpec = require('./ModuleSpec');\nvar onRegisterTimeout;\nvar whoami;\n\n/**\n * What's the top level module/bundle name.\n * @param moduleQName The module QName.\n * @returns The module QName, or undefined if unknown.\n */\nexports.whoami = function(moduleQName) {\n    if (moduleQName) {\n        whoami = moduleQName;\n        internal.whoami(whoami);\n    }\n    return whoami;\n};\n\n/**\n * Asynchronously import/require a set of modules.\n *\n * <p>\n * Responsible for triggering the async loading of modules if a given module is not already loaded.\n *\n * @param moduleQNames... A list of module \"qualified\" names, each containing the module name prefixed with the namespace\n * and separated by a colon i.e. \"<namespace>:<moduleName>\" e.g. \"jquery:jquery2\".\n *\n * @return A Promise, allowing async load of all modules. The promise is only fulfilled when all modules are loaded.\n */\nexports.importModule = function() {\n    if (arguments.length === 1) {\n        return internal.importModule(arguments[0], onRegisterTimeout);\n    }\n\n    var moduleQNames = [];\n    for (var i = 0; i < arguments.length; i++) {\n        var argument = arguments[i];\n        if (typeof argument === 'string') {\n            moduleQNames.push(argument);\n        }\n    }\n\n    if (moduleQNames.length == 0) {\n        throw new Error(\"No module names specified.\");\n    }\n\n    return promise.make(function (resolve, reject) {\n        var fulfillments = [];\n\n        function onFulfillment() {\n            if (fulfillments.length === moduleQNames.length) {\n                var modules = [];\n                for (var i = 0; i < fulfillments.length; i++) {\n                    if (fulfillments[i].value) {\n                        modules.push(fulfillments[i].value);\n                    } else {\n                        // don't have everything yet so can't fulfill all.\n                        return;\n                    }\n                }\n                // If we make it here, then we have fulfilled all individual promises, which \n                // means we can now fulfill the top level import promise.\n                resolve(modules);\n            }\n        }\n\n        // doRequire for each module\n        for (var i = 0; i < moduleQNames.length; i++) {\n            function doRequire(moduleQName) {\n                var promise = internal.importModule(moduleQName, onRegisterTimeout);\n                var fulfillment = {\n                    promise: promise,\n                    value: undefined\n                };\n                fulfillments.push(fulfillment);\n                promise\n                    .onFulfilled(function(value) {\n                        fulfillment.value = value;\n                        onFulfillment();\n                    })\n                    .onRejected(function(error) {\n                        reject(error);\n                    });\n            }\n            doRequire(moduleQNames[i]);\n        }\n    }).applyArgsOnFulfill();\n};\n\n/**\n * Synchronously \"require\" a module that it already loaded/registered.\n *\n * <p>\n * This function will throw an error if the module is not already loaded via an outer call to 'import'\n * (or 'import').\n *\n * @param moduleQName The module \"qualified\" name containing the module name prefixed with the namespace\n * separated by a colon i.e. \"<namespace>:<moduleName>\" e.g. \"jquery:jquery2\".\n *\n * @return The module.\n */\nexports.requireModule = function(moduleQName) {\n    var parsedModuleName = new ModuleSpec(moduleQName);\n    var module = internal.getModule(parsedModuleName);\n    if (!module) {\n        throw new Error(\"Unable to perform synchronous 'require' for module '\" + moduleQName + \"'. This module is not pre-loaded. \" +\n            \"The module needs to have been asynchronously pre-loaded via an outer call to 'import'.\");\n    }\n    return module.exports;\n};\n\n/**\n * Export a module.\n *\n * @param namespace The namespace in which the module resides, or \"undefined\" if the modules is in\n * the \"global\" module namespace e.g. a Jenkins core bundle.\n * @param moduleName The name of the module.\n * @param module The CommonJS style module, or \"undefined\" if we just want to notify other modules waiting on\n * the loading of this module.\n * @param onError On error callback;\n */\nexports.exportModule = function(namespace, moduleName, module, onError) {\n    try {\n        var moduleQName = (namespace ? namespace + ':' : '') + moduleName;\n        var moduleSpec = new ModuleSpec(moduleQName);\n        var moduleNamespaceObj = internal.getModuleNamespaceObj(moduleSpec);\n        var moduleLoadName = moduleSpec.getLoadBundleName();\n\n        if (moduleNamespaceObj[moduleLoadName]) {\n            if (namespace) {\n                console.debug(\"Jenkins plugin module '\" + namespace + \":\" + moduleName + \"' already registered.\");\n            } else {\n                console.debug(\"Jenkins global module '\" + moduleName + \"' already registered.\");\n            }\n            return;\n        }\n\n        if (!module) {\n            module = {\n                exports: {}\n            };\n        } else if (module.exports === undefined) {\n            module = {\n                exports: module\n            };\n        }\n        moduleNamespaceObj[moduleLoadName] = module;\n\n        // Notify all that the module has been registered. See internal.loadModule also.\n        internal.notifyModuleExported(moduleSpec, module.exports);\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Add a resource resolver.\n * @param {ResourceLocationResolver} resourceLocationResolver The resource resolver.\n */\nexports.addResourceLocationResolver = function(resourceLocationResolver) {\n    internal.addResourceLocationResolver(resourceLocationResolver);\n};\n\n/**\n * Get the ResourceLocationResolver function for the supplied ModuleSpec.\n * @param {ModuleSpec} moduleSpec The ModuleSpec.\n * @returns {function} The ResourceLocationResolver function for the supplied\n * ModuleSpec, or null if none specified.\n */\nexports.getResourceLocationResolver = function (moduleSpec) {\n    if (typeof moduleSpec === 'string') {\n        moduleSpec = new ModuleSpec(moduleSpec);\n    }\n    var resolver = internal.getResourceLocationResolverFunc(moduleSpec);\n    if (resolver) {\n        return function(resourcePath) {\n            return resolver(moduleSpec, resourcePath);\n        }\n    }\n    return undefined;\n};\n\n/**\n * Add a module's CSS to the browser page.\n *\n * <p>\n * The assumption is that the CSS can be accessed at e.g.\n * {@code <rootURL>/plugin/<namespace>/jsmodules/<moduleName>/style.css} i.e.\n * the pluginId acts as the namespace.\n *\n * @param namespace The namespace in which the module resides.\n * @param moduleName The name of the module.\n * @param onError On error callback;\n */\nexports.addModuleCSSToPage = function(namespace, moduleName, onError) {\n    try {\n        internal.addModuleCSSToPage(namespace, moduleName);\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Add a plugin CSS file to the browser page.\n *\n * @param pluginName The Jenkins plugin in which the module resides.\n * @param cssPath The CSS path.\n * @param onError On error callback;\n */\nexports.addPluginCSSToPage = function(pluginName, cssPath, onError) {\n    try {\n        internal.addPluginCSSToPage(pluginName, cssPath);\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Create a js-modules CSS id that can be used to refer to a link element.\n * @param cssPath The CSS path/url.\n * @param namespace Optional namespace.\n */\nexports.toCSSId = function (cssPath, namespace) {\n    return internal.toCSSId(cssPath, namespace);\n};\n\n/**\n * Add CSS file to the browser page.\n *\n * @param cssPath The CSS path.\n * @param onError On error callback;\n */\nexports.addCSSToPage = function(cssPath, onError) {\n    try {\n        if (cssPath.indexOf(internal.getAdjunctURL()) === 0) {\n            internal.addCSSToPage(undefined, cssPath);\n        } else if (cssPath.indexOf('http://') === 0 || cssPath.indexOf('https://') === 0) {\n            // the css path is already fully qualified\n            internal.addCSSToPage(undefined, cssPath);\n        } else {\n            internal.addCSSToPage(undefined, internal.getRootURL() + '/' + cssPath);\n        }\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Add a javascript &lt;script&gt; element to the document &lt;head&gt;.\n * <p/>\n * Options:\n * <ul>\n *     <li><strong>scriptId</strong>: The script Id to use for the element. If not specified, one will be generated from the scriptSrc.</li>\n *     <li><strong>async</strong>: Asynchronous loading of the script. Default is 'true'.</li>\n *     <li><strong>success</strong>: An optional onload success function for the script element.</li>\n *     <li><strong>error</strong>: An optional onload error function for the script element. This is called if the .js file exists but there's an error evaluating the script. It is NOT called if the .js file doesn't exist (ala 404).</li>\n *     <li><strong>removeElementOnLoad</strong>: Remove the script element after loading the script. Default is 'false'.</li>\n * </ul>\n *\n * @param scriptSrc The script src.\n * @param options Optional script load options object. See above.\n */\nexports.addScript = function(scriptSrc, options) {\n    internal.addScript(scriptSrc, options);\n};\n\n/**\n * Set the module registration timeout i.e. the length of time to wait for a module to load before failing.\n *\n * @param timeout Millisecond duration before onRegister times out. Defaults to 10000 (10s) if not specified.\n */\nexports.setRegisterTimeout = function(timeout) {\n    onRegisterTimeout = timeout;\n}\n\n/**\n * Set the Jenkins root/base URL.\n *\n * @param rootUrl The root/base URL.\n */\nexports.setRootURL = function(rootUrl) {\n    internal.setRootURL(rootUrl);\n};\n\nexports.getRootURL = internal.getRootURL;\nexports.getAdjunctURL = internal.getAdjunctURL;\n\n/**\n * Manually initialise the Jenkins Global.\n * <p>\n * This should only ever be called from a test environment.\n */\nexports.initJenkinsGlobal = function() {\n    internal.initJenkinsGlobal();\n};\n\ninternal.onJenkinsGlobalInit(function(jenkinsCIGlobal) {\n    // For backward compatibility, we need to make some js-modules\n    // functions globally available e.g. to allow legacy code wait for\n    // certain modules to be loaded, as with legacy adjuncts.\n    if (!jenkinsCIGlobal._internal) {\n        // Put the functions on an object called '_internal' as a way\n        // of hinting to people to not use it.\n        jenkinsCIGlobal._internal = {\n            importModule: exports.importModule,\n            addScript: internal.addScript\n        };\n    }\n});","deps":{"./ModuleSpec":"node_modules/@jenkins-cd/js-modules/js/ModuleSpec.js","./internal":"node_modules/@jenkins-cd/js-modules/js/internal.js","./promise":"node_modules/@jenkins-cd/js-modules/js/promise.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/internal.js","source":"var promise = require(\"./promise\");\nvar ModuleSpec = require('./ModuleSpec');\nvar ResourceLocationResolver = require('./ResourceLocationResolver');\n\nvar jenkinsCIGlobal;\nvar globalInitListeners = [];\nvar whoami;\n\nexports.whoami = function(moduleQName) {\n    if (moduleQName) {\n        whoami = new ModuleSpec(moduleQName);\n        whoami.nsProvider = getBundleNSProviderFromScriptElement(whoami.namespace, whoami.moduleName);\n    }\n    return whoami;\n};\n\nexports.onJenkinsGlobalInit = function(callback) {\n    globalInitListeners.push(callback);\n};\n\nexports.initJenkinsGlobal = function() {\n    jenkinsCIGlobal = {\n    };\n    if (globalInitListeners) {\n        for (var i = 0; i < globalInitListeners.length; i++) {\n            globalInitListeners[i](jenkinsCIGlobal);\n        }\n    }\n};\n\nexports.clearJenkinsGlobal = function() {    \n    jenkinsCIGlobal = undefined;\n    whoami = undefined;\n};\n\nexports.addResourceLocationResolver = function(resourceLocationResolver) {\n    var resolvers = getResourceLocationResolvers();\n    resolvers.push(resourceLocationResolver);\n    ResourceLocationResolver.sort(resolvers);\n};\n\nexports.getJenkins = function() {\n    if (jenkinsCIGlobal) {\n        return jenkinsCIGlobal;\n    }\n    if (window.jenkinsCIGlobal) {\n        jenkinsCIGlobal = window.jenkinsCIGlobal;\n    } else {\n        exports.initJenkinsGlobal();\n        jenkinsCIGlobal.rootURL = getRootURL();\n        window.jenkinsCIGlobal = jenkinsCIGlobal;\n    }   \n    return jenkinsCIGlobal;\n};\n\nexports.getModuleNamespaceObj = function(moduleSpec) {\n    if (moduleSpec.namespace) {\n        return exports.getNamespace(moduleSpec.namespace);\n    } else {\n        return exports.getGlobalModules();\n    }\n};\n\nexports.getNamespace = function(namespaceName) {\n    var namespaces = exports.getNamespaces();\n    var namespace = namespaces[namespaceName];\n    if (!namespace) {\n        namespace = {\n            globalNS: false            \n        };\n        namespaces[namespaceName] = namespace;\n    }\n    return namespace;\n};\n\nexports.importModule = function(moduleQName, onRegisterTimeout) {\n    return promise.make(function (resolve, reject) {\n        var moduleSpec = new ModuleSpec(moduleQName);\n        var module = exports.getModule(moduleSpec);\n\n        if (module) {\n            // module already loaded\n            resolve(module.exports);\n        } else {\n            if (onRegisterTimeout === 0) {\n                if (moduleSpec.namespace) {\n                    throw new Error('Module ' + moduleSpec.namespace + ':' + moduleSpec.moduleName + ' require failure. Async load mode disabled.');\n                } else {\n                    throw new Error('Global module ' + moduleSpec.moduleName + ' require failure. Async load mode disabled.');\n                }\n            }\n\n            // module not loaded. Load async, fulfilling promise once registered\n            exports.loadModule(moduleSpec, onRegisterTimeout)\n                .onFulfilled(function (moduleExports) {\n                    resolve(moduleExports);\n                })\n                .onRejected(function (error) {\n                    reject(error);\n                });\n        }\n    });    \n};\n\nexports.loadModule = function(moduleSpec, onRegisterTimeout) {\n    var module = exports.getModule(moduleSpec);\n    \n    if (module) {\n        // Module already loaded. This prob shouldn't happen.\n        console.log(\"Unexpected call to 'loadModule' for a module (\" + moduleSpec.moduleName + \") that's already loaded.\");\n        return promise.make(function (resolve) {\n            resolve(module.exports);\n        });\n    }\n\n    function waitForRegistration(loadingModule, onRegisterTimeout) {\n        return promise.make(function (resolve, reject) {\n            if (typeof onRegisterTimeout !== \"number\") {\n                onRegisterTimeout = 10000;\n            }\n            \n            var timeoutObj = setTimeout(function () {\n                // Timed out waiting on the module to load and register itself.\n                if (!loadingModule.loaded) {\n                    var moduleSpec = loadingModule.moduleSpec;\n                    var errorDetail;\n                    \n                    if (moduleSpec.namespace) {\n                        errorDetail = \"Timed out waiting on module '\" + moduleSpec.namespace + \":\" + moduleSpec.moduleName + \"' to load.\";\n                    } else {\n                        errorDetail = \"Timed out waiting on module '\" + moduleSpec.moduleName + \"' to load.\";\n                    }                    \n                    console.error('Module load failure: ' + errorDetail);\n\n                    // Call the reject function and tell it we timed out\n                    reject({\n                        reason: 'timeout',\n                        detail: errorDetail\n                    });\n                }\n            }, onRegisterTimeout);\n            \n            loadingModule.waitList.push({\n                resolve: resolve,\n                timeoutObj: timeoutObj\n            });                    \n        });\n    }\n\n    var loadVersion = moduleSpec.getLoadBundleVersion();\n    var doScriptLoad = true;\n    \n    if (loadVersion) {\n        // If a version was specified then we only do the script load if a\n        // specific version was provided i.e. loading does not get triggered\n        // by imports that specify non-specific version numbers e.g. \"any\"\n        // or \"1.2.x\". A specific version number would be e.g. \"1.2.3\" i.e.\n        // fully qualified. When loading is not triggered, the import is depending\n        // on another import (with a specific version) or on another bundle to do an\n        // export of an internal dependency i.e. on another bundle \"providing\"\n        // the module by exporting it.\n        doScriptLoad = loadVersion.isSpecific();\n    }\n\n    var loadingModule = getLoadingModule(moduleSpec);\n    if (!loadingModule.waitList) {\n        loadingModule.waitList = [];\n    }\n    loadingModule.moduleSpec = moduleSpec; \n    loadingModule.loaded = false;\n\n    try {\n        return waitForRegistration(loadingModule, onRegisterTimeout);\n    } finally {\n        if (doScriptLoad && !loadingModule.loadedBy) {\n            // Capture the name of the bundle that triggered importing/loading\n            // of the bundle.\n            loadingModule.loadedBy = whoami;\n\n            var loadModuleName = moduleSpec.getLoadBundleName();\n            var scriptId = exports.toModuleId(moduleSpec.namespace, loadModuleName) + ':js';\n            var scriptSrc = exports.toModuleSrc(moduleSpec, 'js');\n            var scriptEl = exports.addScript(scriptSrc, {\n                scriptId: scriptId,\n                scriptSrcBase: ''\n            });\n\n            if (scriptEl) {\n                // Set the module spec info on the <script> element. This allows us to resolve the\n                // nsProvider for that bundle after 'whoami' is called for it (as it loads). whoami\n                // is not called with the nsProvider info on it because a given bundle can\n                // potentially be loaded from multiple different ns providers, so we only resole the provider\n                // at load-time i.e. just after a bundle is loaded it calls 'whoami' for itself\n                // and then this module magically works out where it was loaded from (it's nsProvider)\n                // by locating the <script> element and using this information. For a module/bundle, knowing\n                // where it was loaded from is important because it dictates where that module/bundle\n                // should load it dependencies from. For example, the Bootstrap module/bundle depends on the\n                // jQuery bundle. So, if the bootstrap bundle is loaded from the 'core-assets' namespace provider,\n                // then that means the jQuery bundle should also be loaded from the 'core-assets'\n                // namespace provider.\n                // See getBundleNSProviderFromScriptElement.\n                scriptEl.setAttribute('data-jenkins-module-nsProvider', moduleSpec.nsProvider);\n                scriptEl.setAttribute('data-jenkins-module-namespace', moduleSpec.namespace);\n                scriptEl.setAttribute('data-jenkins-module-moduleName', loadModuleName);\n            } else {\n                loadingModule.loadedBy = undefined;\n            }\n        }\n    }\n};\n\nexports.addScript = function(scriptSrc, options) {\n    if (!scriptSrc) {\n        console.warn('Call to addScript with undefined \"scriptSrc\" arg.');\n        return undefined;\n    }    \n    \n    var normalizedOptions;\n    \n    // If there's no options object, create it.\n    if (typeof options === 'object') {\n        normalizedOptions = options;\n    } else {\n        normalizedOptions = {};\n    }\n    \n    // May want to transform/map some urls.\n    if (normalizedOptions.scriptSrcMap) {\n        if (typeof normalizedOptions.scriptSrcMap === 'function') {\n            scriptSrc = normalizedOptions.scriptSrcMap(scriptSrc);\n        } else if (Array.isArray(normalizedOptions.scriptSrcMap)) {\n            // it's an array of suffix mappings\n            for (var i = 0; i < normalizedOptions.scriptSrcMap.length; i++) {\n                var mapping = normalizedOptions.scriptSrcMap[i];\n                if (mapping.from && mapping.to) {\n                    if (endsWith(scriptSrc, mapping.from)) {\n                        normalizedOptions.originalScriptSrc = scriptSrc;\n                        scriptSrc = scriptSrc.replace(mapping.from, mapping.to);\n                        break;\n                    }\n                }\n            }\n        }\n    }\n    \n    normalizedOptions.scriptId = getScriptId(scriptSrc, options);\n    \n    // set some default options\n    if (normalizedOptions.async === undefined) {\n        normalizedOptions.async = true;\n    }\n    if (normalizedOptions.scriptSrcBase === undefined) {\n        normalizedOptions.scriptSrcBase = '@root';\n    }\n    \n    if (normalizedOptions.scriptSrcBase === '@root') {\n        normalizedOptions.scriptSrcBase = getRootURL() + '/';\n    } else if (normalizedOptions.scriptSrcBase === '@adjunct') {\n        normalizedOptions.scriptSrcBase = getAdjunctURL() + '/';\n    }\n\n    var document = window.document;\n    var head = exports.getHeadElement();\n    var script = document.getElementById(normalizedOptions.scriptId);\n\n    if (script) {\n        var replaceable = script.getAttribute('data-replaceable');\n        if (replaceable && replaceable === 'true') {\n            // This <script> element is replaceable. In this case, \n            // we remove the existing script element and add a new one of the\n            // same id and with the specified src attribute.\n            // Adding happens below.\n            script.parentNode.removeChild(script);\n        } else {\n            return undefined;\n        }\n    }\n\n    script = createElement('script');\n\n    // Parts of the following onload code were inspired by how the ACE editor does it,\n    // as well as from the follow SO post: http://stackoverflow.com/a/4845802/1166986\n    var onload = function (_, isAborted) {\n        script.setAttribute('data-onload-complete', true);\n        try {\n            if (isAborted) {\n                console.warn('Script load aborted: ' + scriptSrc);\n            } else if (!script.readyState || script.readyState === \"loaded\" || script.readyState === \"complete\") {\n                // If the options contains an onload function, call it.\n                if (typeof normalizedOptions.success === 'function') {\n                    normalizedOptions.success(script);\n                }\n                return;\n            }\n            if (typeof normalizedOptions.error === 'function') {\n                normalizedOptions.error(script, isAborted);\n            }\n        } finally {\n            if (normalizedOptions.removeElementOnLoad) {\n                head.removeChild(script);\n            }\n            // Handle memory leak in IE\n            script = script.onload = script.onreadystatechange = null;\n        }\n    };\n    script.onload = onload; \n    script.onreadystatechange = onload;\n\n    script.setAttribute('id', normalizedOptions.scriptId);\n    script.setAttribute('type', 'text/javascript');\n    script.setAttribute('src', normalizedOptions.scriptSrcBase + scriptSrc);\n    if (normalizedOptions.originalScriptSrc) {\n        script.setAttribute('data-referrer', normalizedOptions.originalScriptSrc);        \n    }\n    if (normalizedOptions.async) {\n        script.setAttribute('async', normalizedOptions.async);\n    }\n    \n    head.appendChild(script);\n    \n    return script;\n};\n\nexports.notifyModuleExported = function(moduleSpec, moduleExports) {\n    var loadingModule = getLoadingModule(moduleSpec);\n    \n    loadingModule.loaded = true;\n    if (loadingModule.waitList) {\n        for (var i = 0; i < loadingModule.waitList.length; i++) {\n            var waiter = loadingModule.waitList[i];\n            clearTimeout(waiter.timeoutObj);\n            waiter.resolve(moduleExports);\n        }\n    }    \n};\n\nexports.addModuleCSSToPage = function(namespace, moduleName) {\n    var moduleSpec = exports.getModuleSpec(namespace + ':' + moduleName);\n    var cssElId = exports.toModuleId(namespace, moduleName) + ':css';\n    var cssPath = exports.toModuleSrc(moduleSpec, 'css');\n    return exports.addCSSToPage(namespace, cssPath, cssElId);\n};\n\nexports.addPluginCSSToPage = function(namespace, cssPath, cssElId) {\n    var cssPath = exports.getPluginPath(namespace) + '/' + cssPath;\n    return exports.addCSSToPage(namespace, cssPath, cssElId);\n};\n\nexports.toCSSId = function (cssPath, namespace) {\n    return 'jenkins-js-module:' + (namespace || 'global' ) + ':css:' + cssPath;\n};\n\nexports.addCSSToPage = function(namespace, cssPath, cssElId) {\n    var document = window.document;\n    \n    if (cssElId === undefined) {\n        cssElId = exports.toCSSId(cssPath, namespace);\n    }\n    \n    var cssEl = document.getElementById(cssElId);\n    \n    if (cssEl) {\n        // already added to page\n        return;\n    }\n\n    var docHead = exports.getHeadElement();\n    cssEl = createElement('link');\n    cssEl.setAttribute('id', cssElId);\n    cssEl.setAttribute('type', 'text/css');\n    cssEl.setAttribute('rel', 'stylesheet');\n    cssEl.setAttribute('href', cssPath);\n    docHead.appendChild(cssEl);\n\n    return cssEl;\n};\n\nexports.getGlobalModules = function() {\n    var jenkinsCIGlobal = exports.getJenkins();\n    if (!jenkinsCIGlobal.globals) {\n        jenkinsCIGlobal.globals = {\n            globalNS: true\n        };\n    }\n    return jenkinsCIGlobal.globals;\n};\n\nexports.getNamespaces = function() {\n    var jenkinsCIGlobal = exports.getJenkins();\n\n    // The namespaces are stored in an object named \"plugins\". This is a legacy from the\n    // time when all modules lived in plugins. By right we'd like to rename this, but\n    // that would cause compatibility issues.\n\n    if (!jenkinsCIGlobal.plugins) {\n        jenkinsCIGlobal.plugins = {\n            __README__: 'This object holds namespaced JS modules/bundles, with the property names representing the module namespace. It\\'s name (\"plugins\") is a legacy thing. Changing it to a better name (e.g. \"namespaces\") would cause compatibility issues.'\n        };\n    }\n    return jenkinsCIGlobal.plugins;\n};\n\nexports.toModuleId = function(namespace, moduleName) {\n    return 'jenkins-js-module:' + (namespace ? namespace + ':' : '') + moduleName;\n};\n\nexports.toModuleSrc = function(moduleSpec, srcType) {\n    var nsProvider = moduleSpec.nsProvider;\n\n    // If a moduleSpec on a module/bundle import doesn't specify a namespace provider\n    // (i.e. is of the form \"a:b\" and not \"core-assets/a:b\"),\n    // then check \"this\" bundles module spec and see if it was imported from a specific\n    // namespace. If it was (e.g. 'core-assets'), then import from that namespace.\n    if (nsProvider === undefined) {\n        nsProvider = thisBundleNamespaceProvider();\n        if (nsProvider === undefined) {\n            nsProvider = 'adjuncts';\n        }\n        // Store the nsProvider back onto the moduleSpec.\n        moduleSpec.nsProvider = nsProvider;\n    }\n\n    var srcPath = undefined;\n    if (srcType === 'js') {\n        srcPath = moduleSpec.getLoadBundleFileNamePrefix() + '.js';\n    } else if (srcType === 'css') {\n        srcPath = moduleSpec.getLoadBundleFileNamePrefix() + '/style.css';\n    } else {\n        throw new Error('Unsupported srcType \"'+ srcType + '\".');\n    }\n\n    // Maybe there's a custom resource resolver for this resource.\n    var resourceLocationResolverFunc = getResourceLocationResolverFunc(moduleSpec);\n    if (resourceLocationResolverFunc) {\n        var resourcePath = resourceLocationResolverFunc(moduleSpec, srcPath);\n        if (resourcePath) {\n            return resourcePath;\n        }\n    }\n\n    // Default resource resolution ...\n    if (nsProvider === 'adjuncts') {\n        return exports.getAdjunctJSModulesPath(moduleSpec.namespace) + '/' + srcPath;\n    } else if (nsProvider === 'plugin') {\n        return exports.getPluginJSModulesPath(moduleSpec.namespace) + '/' + srcPath;\n    } else if (nsProvider === 'core-assets') {\n        return exports.getCoreAssetsJSModulesPath(moduleSpec.namespace) + '/' + srcPath;\n    } else {\n        throw new Error('Unsupported namespace provider: ' + nsProvider);\n    }\n};\n\nexports.getAdjunctJSModulesPath = function(namespace) {\n    if (namespace) {\n        return getAdjunctURL() + '/org/jenkins/ui/jsmodules/' + namespace;\n    } else {\n        return getAdjunctURL() + '/org/jenkins/ui/jsmodules';\n    }\n};\n\nexports.getPluginJSModulesPath = function(pluginId) {\n    return exports.getPluginPath(pluginId) + '/jsmodules';\n};\n\nexports.getCoreAssetsJSModulesPath = function(namespace) {\n    return getRootURL() + '/assets/' + namespace + '/jsmodules';\n};\n\nexports.getPluginPath = function(pluginId) {\n    return getRootURL() + '/plugin/' + pluginId;\n};\n\nexports.getHeadElement = function() {\n    var docHead = window.document.getElementsByTagName(\"head\");\n    if (!docHead || docHead.length == 0) {\n        throw new Error('No head element found in document.');\n    }\n    return docHead[0];\n};\n\nexports.setRootURL = function(url) {    \n    if (!jenkinsCIGlobal) {\n        exports.initJenkinsGlobal();\n    }\n    jenkinsCIGlobal.rootURL = url;\n};\n\nexports.getModule = function(moduleSpec) {\n    var namespace = exports.getModuleNamespaceObj(moduleSpec);\n    \n    if (!moduleSpec.moduleVersion) {\n        return namespace[moduleSpec.moduleName];\n    } else {\n        for (var i = 0; i < moduleSpec.moduleCompatVersions.length; i++) {\n            var moduleCompatVersion = moduleSpec.moduleCompatVersions[i];\n            var module = namespace[moduleSpec.moduleName + '@' + moduleCompatVersion.raw];\n            if (module) {\n                return module;\n            }\n        }\n    }\n    \n    return undefined;\n};\n\nexports.getModuleSpec = function(moduleQName) {\n    var moduleSpec = new ModuleSpec(moduleQName);\n    var moduleNamespaceObj = exports.getModuleNamespaceObj(moduleSpec);\n    if (moduleNamespaceObj) {\n        var loading = getLoadingModule(moduleSpec);\n        if (loading && loading.moduleSpec) {\n            return loading.moduleSpec;\n        }\n    }\n    return moduleSpec;\n};\n\nfunction getResourceLocationResolvers() {\n    var jenkinsCIGlobal = exports.getJenkins();\n    if (!jenkinsCIGlobal.resourceLocationResolvers) {\n        jenkinsCIGlobal.resourceLocationResolvers = [];\n    }\n    return jenkinsCIGlobal.resourceLocationResolvers;\n}\n\nfunction getResourceLocationResolverFunc(moduleSpec) {\n    var resolvers = getResourceLocationResolvers();\n\n    for (var i = 0; i < resolvers.length; i++) {\n        var resolver = resolvers[i];\n        if (resolver && resolver.canResolve(moduleSpec)) {\n            return resolver.resolverFunc;\n        }\n    }\n\n    // Failed to find a specific resolver for the supplied moduleSpec.\n    // In this case, lets try the resolver used to load the bundle\n    // that's currently loading this resource. Iow, resources should\n    // be loaded from the same location as the bundle that's triggering\n    // the loading of that resource. Obviously this is recursive up\n    // through the \"parents\".\n    var loadingModule = getLoadingModule(moduleSpec);\n    if (loadingModule.loadedBy) {\n        return getResourceLocationResolverFunc(loadingModule.loadedBy);\n    }\n\n    return undefined;\n}\nexports.getResourceLocationResolverFunc = getResourceLocationResolverFunc;\n\nfunction getScriptId(scriptSrc, config) {\n    if (typeof config === 'string') {\n        return config;\n    } else if (typeof config === 'object' && config.scriptId) {\n        return config.scriptId;\n    } else {\n        return 'jenkins-script:' + scriptSrc;\n    }    \n}\n\nexports.getRootURL = getRootURL;\nfunction getRootURL() {\n    if (jenkinsCIGlobal && jenkinsCIGlobal.rootURL) {\n        return jenkinsCIGlobal.rootURL;\n    }\n    \n    var docHead = exports.getHeadElement();\n    var rootURL = getAttribute(docHead, \"data-rooturl\");\n\n    if (rootURL === undefined || rootURL === null) {\n        // Backward compatibility - used to use a 'resurl' attribute.\n        rootURL = getAttribute(docHead, \"resurl\");\n        if (rootURL === undefined || rootURL === null) {\n            throw new Error(\"Attribute 'data-rooturl' not defined on the document <head> element.\");\n        }\n    }\n\n    if (jenkinsCIGlobal) {\n        jenkinsCIGlobal.rootURL = rootURL;\n    }\n    \n    return rootURL;\n}\n\nexports.getAdjunctURL = getAdjunctURL;\nfunction getAdjunctURL() {\n    if (jenkinsCIGlobal && jenkinsCIGlobal.adjunctURL) {\n        return jenkinsCIGlobal.adjunctURL;\n    }\n    \n    var docHead = exports.getHeadElement();\n    var adjunctURL = getAttribute(docHead, \"data-adjuncturl\");\n\n    if (adjunctURL === undefined || adjunctURL === null) {\n        // Backward compatibility - older Jenkins do not have the adjunct url on the\n        // <head> element. Lets try getting the resurl (older jenkins) and patching it \n        // to be an adjunct url.\n        adjunctURL = getAttribute(docHead, \"resurl\");\n        if (adjunctURL === undefined || adjunctURL === null) {\n            throw new Error(\"Attribute 'data-adjuncturl' not defined on the document <head> element.\");\n        }\n        // Replace the first occurrence of 'static/' with 'adjuncts/' \n        adjunctURL = adjunctURL.replace('static\\/', 'adjuncts\\/');\n    }\n\n    if (jenkinsCIGlobal) {\n        jenkinsCIGlobal.adjunctURL = adjunctURL;\n    }\n    \n    return adjunctURL;\n}\n\nfunction createElement(name) {\n    var document = window.document;\n    return document.createElement(name);\n}\n\nfunction getAttribute(element, attributeName) {\n    var value = element.getAttribute(attributeName.toLowerCase());\n    \n    if (value) {\n        return value;\n    } else {\n        // try without lowercasing\n        return element.getAttribute(attributeName);\n    }    \n}\n\nfunction getLoadingModule(moduleSpec) {\n    var moduleNamespaceObj = exports.getModuleNamespaceObj(moduleSpec);\n    var moduleName = moduleSpec.getLoadBundleName();\n\n    if (!moduleNamespaceObj.loadingModules) {\n        moduleNamespaceObj.loadingModules = {};\n    }\n    if (!moduleNamespaceObj.loadingModules[moduleName]) {\n        moduleNamespaceObj.loadingModules[moduleName] = {};\n    }\n    return moduleNamespaceObj.loadingModules[moduleName];\n}\n\nfunction endsWith(string, suffix) {\n    return (string.indexOf(suffix, string.length - suffix.length) !== -1);\n}\n\nfunction thisBundleNamespaceProvider() {\n    if (whoami !== undefined) {\n        return whoami.nsProvider;\n    }\n    return undefined;\n}\n\nfunction getBundleNSProviderFromScriptElement(namespace, moduleName) {\n    var docHead = exports.getHeadElement();\n    var scripts = docHead.getElementsByTagName(\"script\");\n\n    for (var i = 0; i < scripts.length; i++) {\n        var script = scripts[i];\n        var elNamespace = script.getAttribute('data-jenkins-module-namespace');\n        var elModuleName = script.getAttribute('data-jenkins-module-moduleName');\n\n        if (elNamespace === namespace && elModuleName === moduleName) {\n            return script.getAttribute('data-jenkins-module-nsProvider');\n        }\n    }\n\n    return undefined;\n}","deps":{"./ModuleSpec":"node_modules/@jenkins-cd/js-modules/js/ModuleSpec.js","./ResourceLocationResolver":"node_modules/@jenkins-cd/js-modules/js/ResourceLocationResolver.js","./promise":"node_modules/@jenkins-cd/js-modules/js/promise.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/promise.js","source":"exports.make = function(executor) {\n    var thePromise = new APromise();\n    executor.call(thePromise, function(result) {\n        thePromise.resolve(result);\n    }, function(reason) {\n        thePromise.reject(reason);\n    });\n    return thePromise;\n};\n\nfunction APromise() {\n    this.state = 'PENDING';\n    this.whenFulfilled = undefined;\n    this.whenRejected = undefined;\n    this.applyFulfillArgs = false;\n}\n\nAPromise.prototype.applyArgsOnFulfill = function() {\n    this.applyFulfillArgs = true;\n    return this;\n}\n\nAPromise.prototype.resolve = function (result) {\n    this.state = 'FULFILLED';\n    \n    var thePromise = this;\n    function doFulfill(whenFulfilled, result) {\n        if (thePromise.applyFulfillArgs) {\n            whenFulfilled.apply(whenFulfilled, result);\n        } else {\n            whenFulfilled(result);\n        }\n    }\n    \n    if (this.whenFulfilled) {\n        doFulfill(this.whenFulfilled, result);\n    }\n    // redefine \"onFulfilled\" to call immediately\n    this.onFulfilled = function (whenFulfilled) {\n        if (whenFulfilled) {\n            doFulfill(whenFulfilled, result);\n        }\n        return this;\n    }\n};\n\nAPromise.prototype.reject = function (reason) {\n    this.state = 'REJECTED';\n    if (this.whenRejected) {\n        this.whenRejected(reason);\n    }\n    // redefine \"onRejected\" to call immediately\n    this.onRejected = function(whenRejected) {\n        if (whenRejected) {\n            whenRejected(reason);\n        }\n        return this;\n    }\n};\n\nAPromise.prototype.onFulfilled = function(whenFulfilled) {\n    if (!whenFulfilled) {\n        throw new Error('Must provide an \"whenFulfilled\" callback.');\n    }\n    this.whenFulfilled = whenFulfilled;\n    return this;\n};\n\nAPromise.prototype.onRejected = function(whenRejected) {        \n    if (whenRejected) {\n        this.whenRejected = whenRejected;\n    }\n    return this;\n};","deps":{}},{"id":"node_modules/@jenkins-cd/logging/index.js","source":"var storage = require('@jenkins-cd/storage');\nvar jenkinsNS = storage.jenkinsNamespace();\nvar logging = jenkinsNS.subspace('logging');\nvar categories = logging.subspace('categories');\n\n//\n// Make sure the console log functions are supported in the environment.\n//\nif (!console.debug) {\n    console.debug = console.log;\n}\nif (!console.info) {\n    console.info = console.log;\n}\nif (!console.warn) {\n    console.warn = console.log;\n}\nif (!console.error) {\n    console.error = console.log;\n}\n\n// Output an info log with a hyperlink to the docs\nconsole.info('Browser configuration of @jenkins-cd/logging is explained at https://tfennelly.github.io/jenkins-js-logging/index.html#browser-config');\n\n/**\n * Log Level enum.\n * <p>\n * Defines simple logging levels i.e. {@link Level.DEBUG}, {@link Level.LOG}, {@link Level.INFO}, {@link Level.WARN}, {@link Level.ERROR}.\n * <p>\n * Do not construct this class; just use the above listed static property enums.\n * @constructor\n * @see <a href=\"./global.html#setLogLevel\">setLogLevel</a>.\n */\nfunction Level() {\n    throw new Error('Unexpected construction of the Level class. Please use the static property enums i.e. Level.DEBUG etc.');\n}\n/**\n * Debug log level (console.debug).\n */\nLevel.DEBUG = { id: 'DEBUG', precedence: 0 };\n/**\n * Log log level (console.log).\n */\nLevel.LOG = { id: 'LOG', precedence: 1 };\n/**\n * Info log level (console.info).\n */\nLevel.INFO = { id: 'INFO', precedence: 2 };\n/**\n * Warn log level (console.warn).\n */\nLevel.WARN = { id: 'WARN', precedence: 3 };\n/**\n * Error log level (console.error).\n */\nLevel.ERROR = { id: 'ERROR', precedence: 4 };\n\nexports.Level = Level;\n\nvar LEVEL_PARENTDOTCHECK_CONSTRAINTS = [Level.DEBUG.id, Level.LOG.id, Level.INFO.id, Level.WARN.id, Level.ERROR.id];\n\n/**\n * Get the categories {StorageNamespace}.\n * <p>\n * External entities should not directly store anything in this namespace.\n * @returns {StorageNamespace} See https://github.com/jenkinsci/js-storage.\n * @see <a href=\"./global.html#setLogLevel\">setLogLevel</a>.\n */\nexports.getCategoriesStorageNS = function() {\n    return categories;\n};\n\n/**\n * Set the log {Level} for a logging category.\n * @param {string} category The category name. Use dot separated naming convention to create a category hierarchy (ala Log4J).\n * @param {Level} level The logging level for the category.\n */\nexports.setLogLevel = function(category, level) {\n    if (level !== Level.ERROR && level !== Level.WARN && level !== Level.INFO && level !== Level.LOG && level !== Level.DEBUG) {\n        throw new Error('Unexpected arg type for \"level\". Expected one of the predefined Level enums.');\n    }\n    categories.set(category, level.id);\n};\n\n/**\n * Create a new Logger instance for the specified category.\n * @param {string} category The category name. Use dot separated naming convention to create a category hierarchy (ala Log4J).\n * @constructor\n * @example\n * const logging = require('@jenkins-cd/logging');\n * const logger = logging.logger('org.jenkinsci.sse');\n *\n * if (logger.isDebugEnabled()) {\n *     logger.debug('Log a message for x and y values: ', x , y);\n * }\n */\nfunction Logger(category) {\n    if (category === undefined) {\n        throw new Error('Cannot create logger. Log \"category\" name must be specified.');\n    }\n    this.category = category;\n\n    function stringToLogLevel(logLevelId) {\n        if (!logLevelId || logLevelId === '_') {\n            return undefined;\n        }\n        return Level[logLevelId];\n    }\n\n    // Look for an exact matching category. If not configured, set it to a blank value\n    // so as to make it discoverable in the browsers Storage Inspector.\n    var logLevelId = categories.get(category);\n    if (logLevelId === undefined) {\n        categories.set(category, '_');\n    }\n\n    this.logLevel = stringToLogLevel(logLevelId);\n    if (!this.logLevel) {\n        logLevelId = categories.get(category, {checkDotParent: LEVEL_PARENTDOTCHECK_CONSTRAINTS});\n        this.logLevel = stringToLogLevel(logLevelId);\n        if (!this.logLevel) {\n            // Default\n            this.logLevel = Level.ERROR;\n        }\n    }\n}\nLogger.prototype = {\n\n    /**\n     * Is the specific logging level enabled for this logger instance.\n     * @param {Level} level The logging level.\n     * @returns {boolean} True if the level is enabled, otherwiser false.\n     * @example\n     * if (logger.isEnabled(Level.DEBUG)) {\n     *     logger.debug('Log a message for x and y values: ', x , y);\n     * }\n     */\n    isEnabled: function(level) {\n        return level.precedence >= this.logLevel.precedence;\n    },\n\n    /**\n     * Is the {@link Level#DEBUG Level.DEBUG} logging level enabled for this logger instance.\n     * <p>\n     * Shorthand for <code>logger.isEnabled(Level.DEBUG)</code>.\n     * @returns {boolean} True if the level is enabled, otherwiser false.\n     * @example\n     * if (logger.isDebugEnabled()) {\n     *     logger.debug('Log a message for x and y values: ', x , y);\n     * }\n     */\n    isDebugEnabled: function () {\n        return this.isEnabled(Level.DEBUG);\n    },\n\n    /**\n     * Is the {@link Level#LOG Level.LOG} logging level enabled for this logger instance.\n     * <p>\n     * Shorthand for <code>logger.isEnabled(Level.LOG)</code>.\n     * @returns {boolean} True if the level is enabled, otherwiser false.\n     * @example\n     * if (logger.isLogEnabled()) {\n     *     logger.log('Log a message for x and y values: ', x , y);\n     * }\n     */\n    isLogEnabled: function () {\n        return this.isEnabled(Level.LOG);\n    },\n\n    /**\n     * Is the {@link Level#INFO Level.INFO} logging level enabled for this logger instance.\n     * <p>\n     * Shorthand for <code>logger.isEnabled(Level.INFO)</code>.\n     * @returns {boolean} True if the level is enabled, otherwiser false.\n     * @example\n     * if (logger.isInfoEnabled()) {\n     *     logger.info('Log a message for x and y values: ', x , y);\n     * }\n     */\n    isInfoEnabled: function () {\n        return this.isEnabled(Level.INFO);\n    },\n\n    /**\n     * Is the {@link Level#WARN Level.WARN} logging level enabled for this logger instance.\n     * <p>\n     * Shorthand for <code>logger.isEnabled(Level.WARN)</code>.\n     * @returns {boolean} True if the level is enabled, otherwiser false.\n     * @example\n     * if (logger.isWarnEnabled()) {\n     *     logger.warn('Log a message for x and y values: ', x , y);\n     * }\n     */\n    isWarnEnabled: function () {\n        return this.isEnabled(Level.WARN);\n    },\n\n    /**\n     * Log a debug message.\n     * @param {...*} message Message arguments.\n     */\n    debug: function (message) {\n        if (this.isEnabled(Level.DEBUG)) {\n            console.debug.apply(console, logArgs(Level.DEBUG, this.category, arguments));\n        }\n    },\n\n    /**\n     * Log an \"log\" level message.\n     * @param {...*} message Message arguments.\n     */\n    log: function (message) {\n        if (this.isEnabled(Level.LOG)) {\n            console.log.apply(console, logArgs(Level.LOG, this.category, arguments));\n        }\n    },\n\n    /**\n     * Log an info message.\n     * @param {...*} message Message arguments.\n     */\n    info: function (message) {\n        if (this.isEnabled(Level.INFO)) {\n            console.info.apply(console, logArgs(Level.INFO, this.category, arguments));\n        }\n    },\n\n    /**\n     * Log a warn message.\n     * @param {...*} message Message arguments.\n     */\n    warn: function (message) {\n        if (this.isEnabled(Level.WARN)) {\n            console.warn.apply(console, logArgs(Level.WARN, this.category, arguments));\n        }\n    },\n\n    /**\n     * Log an error message.\n     * @param {...*} message Message arguments.\n     */\n    error: function (message) {\n        // Error messages are always logged. No need to check.\n        console.error.apply(console, logArgs(Level.ERROR, this.category, arguments));\n    }\n};\n\nfunction logArgs(level, category, callArgs) {\n    if (!callArgs || callArgs.length === 0) {\n        return callArgs;\n    }\n\n    // Make an array copy of the callArgs - it's not\n    // a real array (it's \"array-like\").\n    var callArgsCopy = [];\n    for (var i = 0; i < callArgs.length; i++) {\n        callArgsCopy.push(callArgs[i]);\n    }\n\n    // Create the message prefix, concatenating the log info with\n    // the first string arg. This will allow formatted log strings\n    // to still work.\n    var prefix = '[' + level.id + ' - ' + category + '] ';\n    if (typeof callArgsCopy[0] === 'string') {\n        prefix += callArgsCopy.shift();\n    }\n\n    // Put them all back on the \"array-like\" args object\n    // and return it.\n    callArgs[0] = prefix;\n    for (var ii = 0; ii < callArgsCopy.length; ii++) {\n        callArgs[ii + 1] = callArgsCopy[ii];\n    }\n\n    return callArgs;\n}\n\n/**\n * Create a {Logger} instance for the specified category.\n * @param {string} category The category name. Use dot separated naming convention to create a category hierarchy (ala Log4J).\n * @returns {Logger} The {Logger} instance.\n */\nexports.logger = function(category) {\n    return new Logger(category);\n};","deps":{"@jenkins-cd/storage":"node_modules/@jenkins-cd/storage/index.js"}},{"id":"node_modules/@jenkins-cd/storage/StorageNamespace.js","source":"var storage = require('./storage');\n\n/**\n * Storage Namespace class.\n * <p>\n * This class allows us to \"unflatten\" and \"typen\" the client Storage (localStorage or sessionStorage) i.e. allows us to introduce\n * an artificial hierarchy within the Storage.\n * <p>\n * This works by prefixing the key names with a namespace, allowing the clearing of a set of values by namespace,\n * as well as storing values by the same name within different namespaces e.g. creating to StorageNamespace instances\n * named \"a/b\" and \"a/z\" and setting a value on key \"org.jenkins.magickey\" on both would work perfectly fine as they\n * would be stored in the underlying storage via keys \"a/b:org.jenkins.magickey\" and \"a/z:org.jenkins.magickey\".\n *\n * @param {string} name The name of the namespace. A forward slash separated value indicates sub-namespacing e.g. \"a/b\".\n * @param {Storage} storage The storage instance to use e.g. {@link window.localStorage} or {@link window.sessionStorage}.\n * @constructor\n * @example\n * // Store some info in a namespace.\n * const storage = require('@jenkins-cd/storage');\n * const jenkinsInstance = storage.localNamespace('jenkins-instance');\n * jenkinsInstance.set('currentVersion', versionString);\n * jenkinsInstance.set('currentPlugins', pluginsArray);\n *\n * @example\n * // After detecting that the Jenkins instance version has changed, or\n * // active plugins have changed, lets clear the \"jenkins-instance\"\n * // namespace.\n * const storage = require('@jenkins-cd/storage');\n * const jenkinsInstance = storage.localNamespace('jenkins-instance');\n * jenkinsInstance.clear(); // Clear all NVPs in that namespace only.\n */\nfunction StorageNamespace(name, storage) {\n    this.namespaceName = name;\n    this.storageInst = storage;\n}\nStorageNamespace.prototype = {\n    /**\n     * Set a value in the namespace.\n     * @param {string} name The name/key.\n     * @param {string|object|boolean|number} value The value.\n     */\n    set: function (name, value) {\n        return storage.set(this.namespaceName + ':' + name, value, this.storageInst);\n    },\n    /**\n     * Get a value from the namespace.\n     * <p>\n     * Options controlling the get can be configured by the optional \"options\"\n     * object argument. Available options:\n     * <ul>\n     *     <li>\"checkDotParent\": Flag (true/false) or an array of permitted values, indicating that if the name is (e.g.) \"a.b.c\" and no value is found for that name (or the found value is not permitted), then fall back and check \"a.b\" and then \"a\" etc.\n     * </ul>\n     *\n     * @param {string} name The name/key.\n     * @param {object} [options] Used to configure the secondary checks that\n     * should be made should there not be a value for the initially specified key.\n     * See examples below.\n     * @return {string|object|boolean|number|undefined} The value.\n     * @example\n     * // get a value from a namespace\n     * const storage = require('@jenkins-cd/storage');\n     * const jenkinsInstance = storage.localNamespace('jenkins-instance');\n     * const lastVersion = jenkinsInstance.get('currentVersion');\n     *\n     * if (lastVersion !== versionString) {\n     *     // Jenkins version has changed deom the last time we ran\n     *     // in this browser. Lets clear all old stored values.\n     *     jenkinsInstance.clear();\n     * }\n     *\n     * @example\n     * // get a value from a namespace, with fallback\n     * const storage = require('@jenkins-cd/storage');\n     * const jenkinsInstance = storage.localNamespace('jenkins-instance');\n     * const logCategories = jenkinsInstance.subspace('log-categories');\n     * const sseLogLevel = logCategories.get('org.jenkins.blueocean.sse', {checkDotParent: true});\n     *\n     * if (sseLogLevel) {\n     *     // A log level for 'org.jenkins.blueocean.sse', or one of it's \"dot parent\"\n     *     // ('org.jenkins.blueocean' etc) is set ... do something with with it.\n     *     // Of course this would be wrapped up in a higher level logging API e.g.\n     *     // in @jenkins-cd/diag.\n     * }\n     */\n    get: function (name, options) {\n        var value = storage.get(this.namespaceName + ':' + name, this.storageInst);\n\n        if (value) {\n            // Do not return the value if there's a options.checkDotParent config\n            // with value constraints on it.\n            if (options && options.checkDotParent && Array.isArray(options.checkDotParent)) {\n                // options.checkDotParent is defining an enum of permitted values.\n                if (options.checkDotParent.indexOf(value) !== -1) {\n                    return value;\n                }\n            } else {\n                return value;\n            }\n        }\n\n        if (options) {\n            if (options.checkDotParent) {\n                var nameDotTokens = name.split('\\.');\n                while (nameDotTokens.length > 0) {\n                    nameDotTokens.pop();\n                    var dotParentName = nameDotTokens.join('.');\n                    value = storage.get(this.namespaceName + ':' + dotParentName, this.storageInst);\n                    if (value) {\n                        if (Array.isArray(options.checkDotParent)) {\n                            // options.checkDotParent is defining an enum of permitted values.\n                            if (options.checkDotParent.indexOf(value) !== -1) {\n                                return value;\n                            }\n                        } else {\n                            return value;\n                        }\n                    }\n                }\n            }\n        }\n\n        return undefined;\n    },\n    /**\n     * Remove a value from the namespace.\n     * @param {string} name The name/key.\n     */\n    remove: function (name) {\n        return this.storageInst.removeItem(this.namespaceName + ':' + name);\n    },\n    /**\n     * Clear all stored values in this namespace.\n     * @param {boolean} [clearSubspaces] Also clear subspace values. Default <code>true</code>.\n     */\n    clear: function(clearSubspaces) {\n        this.iterate(function(key, value, namespace) {\n            return this.storageInst.removeItem(namespace + ':' + key);\n        }, clearSubspaces);\n    },\n    /**\n     * Get the count of stored values in this namespace.\n     * <p>\n     * Note that this is not a \"free\" operation. This function iterates the\n     * namespace values in order to count.\n     * @return {number} The count of stored values in this namespace.\n     * @param {boolean} [countSubspaces] Also count subspace values. Default <code>true</code>.\n     */\n    count: function(countSubspaces) {\n        var count = 0;\n        this.iterate(function() {\n            count++;\n        }, countSubspaces);\n        return count;\n    },\n    /**\n     * Iterate the key/value pairs in this namespace.\n     * <p>\n     * Note, values in subspaces will also be sent to the callback.\n     * @param {function} callback A callback that's called with the key (1st arg) value (2nd arg) pairs,\n     * as well as the namespace (3rd arg) that the value is in (which can be a subspace).\n     * <code>this</code> for the callback is set to \"this\" {StorageNamespace} instance.\n     * @param {boolean} [iterateSubspaces] Also iterate subspace values. Default <code>true</code>.\n     */\n    iterate: function (callback, iterateSubspaces) {\n        var subspacePrefix = this.namespaceName + '/';\n        var matchedEntries = [];\n\n        // default iterateSubspaces to true.\n        if (iterateSubspaces === undefined) {\n            iterateSubspaces = true;\n        }\n\n        // Iterate all keys in the Storage, looking for\n        // keys where they are an exact match for this namespace,\n        // or a subspace of this namespace (if iterateSubspaces true).\n        // Add ref objects to matchedEntries for each match.\n        for (var i = 0; i < this.storageInst.length; i++) {\n            var qName = this.storageInst.key(i);\n            var keyNameTokens = qName.split(':');\n            if (keyNameTokens.length > 1) {\n                var keyNamespace = keyNameTokens.shift();\n                var key = keyNameTokens.join(':');\n                if (keyNamespace === this.namespaceName) {\n                    // Exact namespace match\n                    matchedEntries.push({\n                        qName: qName,\n                        namespace: keyNamespace,\n                        key: key\n                    });\n                } else if (iterateSubspaces && keyNamespace.substring(0, subspacePrefix.length) === subspacePrefix) {\n                    // Subspace match\n                    matchedEntries.push({\n                        qName: qName,\n                        namespace: keyNamespace,\n                        key: key\n                    });\n                }\n            }\n        }\n\n        // Iterate the ref objects in matchedEntries, calling the\n        // callback for each object.\n        for (var ii = 0; ii < matchedEntries.length; ii++) {\n            var matchedEntry = matchedEntries[ii];\n            var nsValue = this.storageInst.getItem(matchedEntry.qName);\n            try {\n                callback.call(this, matchedEntry.key, nsValue, matchedEntry.namespace);\n            } catch (e) {\n                console.error('Error iterating storage namespace.', e);\n            }\n        }\n    },\n    /**\n     * Create a sub-namespace of this namespace.\n     * <p>\n     * Creating a sub-space \"y\" from a namespace \"x\" will result in a new namespace named \"x/y\" (see example below).\n     * @param {string} name The name of the sub-space.\n     * @returns {StorageNamespace} The storage namespace.\n     * @example\n     * const storage = require('@jenkins-cd/storage');\n     * const x = storage.localNamespace('x'); // \"x\"\n     * const y = x.subspace('y'); // \"x/y\"\n     */\n    subspace: function(name) {\n        return new StorageNamespace(this.namespaceName + '/' + name, this.storageInst);\n    }\n};\n\nmodule.exports = StorageNamespace;","deps":{"./storage":"node_modules/@jenkins-cd/storage/storage.js"}},{"id":"node_modules/@jenkins-cd/storage/index.js","source":"var storage = require('./storage');\nvar StorageNamespace = require('./StorageNamespace');\n\nvar JENKINS_NS_NAME = 'jenkins-instance';\n\n/**\n * Get a local namespace.\n * <p>\n * Returns a {@link StorageNamespace} instance that can be used to perform operations on values in the namespace.\n * <p>\n * Use {@link jenkinsNamespace} if you want the Storage namespace for the Jenkins instance.\n *\n * @param {string} name The namespace name.\n * @returns {StorageNamespace} The storage namespace.\n * @see {@link StorageNamespace#subspace} and {@link #jenkinsNamespace}.\n */\nexports.localNamespace = function(name) {\n    if (name === JENKINS_NS_NAME) {\n        throw new Error('Call to localNamespace() function using a reserved namespace name \"' + JENKINS_NS_NAME + '\". Please call jenkinsInstanceNamespace() instead.');\n    }\n    return new StorageNamespace(name, storage.local);\n};\n\n/**\n * Get the Jenkins Instance namespace.\n * <p>\n * Returns a {@link StorageNamespace} instance that can be used for the Jenkins instance. Note that it is up\n * to the bootstrapping application (e.g. the blueocean-web plugin) to clear the namespace\n * (see {@link StorageNamespace#clear}) when it detects that the backend Jenkins instance has changed in some\n * way i.e. a new Jenkins version or a change in plugin configuration.\n *\n * @returns {StorageNamespace} The storage namespace for the Jenkins instance.\n * @see {@link StorageNamespace#subspace}\n */\nexports.jenkinsNamespace = function() {\n    return new StorageNamespace(JENKINS_NS_NAME, storage.local);\n};","deps":{"./StorageNamespace":"node_modules/@jenkins-cd/storage/StorageNamespace.js","./storage":"node_modules/@jenkins-cd/storage/storage.js"}},{"id":"node_modules/@jenkins-cd/storage/storage.js","source":"(function (global){\n/**\n * Jenkins client-side storage.\n */\n\nif (global.window === undefined) {\n    global.window = {};\n}\nif (!global.window.localStorage) {\n    console.warn('No window.localStorage. Creating a mock in-memory localStorage, assuming this is running in a test environment.');\n    global.window.localStorage = require('localstorage-memory');\n}\n\nvar local = global.window.localStorage;\nexports.local = local;\n\nvar TYPE_OBJECT = '_$_object:';\nvar TYPE_NUMBER = '_$_number:';\nvar TYPE_BOOLEAN = '_$_boolean:';\n\n/**\n * Set a value in local storage.\n * @param {string} name The name/key of the value.\n * @param {string|object|boolean|number} value The value to be stored. Accepts a string, object, boolean or number.\n */\nexports.setLocal = function (name, value) {\n    exports.set(name, value, local);\n};\n\n/**\n * Get a value in local storage.\n * @param {string} name The name/key of the value.\n * @return {string|object|boolean|number|undefined} The stored value, or undefined if no value is stored against that name/key.\n * Returns a string, object, boolean or number, depending on the type of the value when it was\n * stored (set {@link #setLocal}).\n */\nexports.getLocal = function (name) {\n    return exports.get(name, local);\n};\n\n/**\n * Remove a value in local storage.\n * @param {string} name The name/key of the value.\n */\nexports.removeLocal = function (name) {\n    local.removeItem(name);\n};\n\nexports.set = function(name, value, storage) {\n    if (name === undefined || name === null) {\n        throw new Error('Unexpected call to store via undefined/null name.');\n    }\n    if (value === undefined || value === null) {\n        throw new Error('Unexpected call to store undefined/null value in storage. Name: ' + name);\n    }\n\n    var type = typeof value;\n    if (type === 'string') {\n        storage.setItem(name, value);\n    } else if (type === 'object') {\n        storage.setItem(name, TYPE_OBJECT + JSON.stringify(value));\n    } else if (type === 'number') {\n        storage.setItem(name, TYPE_NUMBER + value);\n    } else if (type === 'boolean') {\n        storage.setItem(name, TYPE_BOOLEAN + value);\n    } else {\n        throw new Error('Unexpected call to store type \"' + type + '\". Name: ' + name);\n    }\n};\n\nexports.get = function(name, storage) {\n    var value = storage.getItem(name);\n\n    if (typeof value !== 'string') {\n        return undefined;\n    }\n\n    if (value.substring(0, TYPE_OBJECT.length) === TYPE_OBJECT) {\n        return JSON.parse(value.substring(TYPE_OBJECT.length));\n    }\n    if (value.substring(0, TYPE_NUMBER.length) === TYPE_NUMBER) {\n        return Number(value.substring(TYPE_NUMBER.length));\n    }\n    if (value.substring(0, TYPE_BOOLEAN.length) === TYPE_BOOLEAN) {\n        return Boolean(value.substring(TYPE_BOOLEAN.length));\n    }\n\n    return value;\n};\n}).call(this,typeof global !== \"undefined\" ? global : typeof self !== \"undefined\" ? self : typeof window !== \"undefined\" ? window : {})","deps":{"localstorage-memory":"node_modules/localstorage-memory/lib/localstorage-memory.js"}},{"id":"node_modules/asap/browser-asap.js","source":"\"use strict\";\n\n// rawAsap provides everything we need except exception management.\nvar rawAsap = require(\"./raw\");\n// RawTasks are recycled to reduce GC churn.\nvar freeTasks = [];\n// We queue errors to ensure they are thrown in right order (FIFO).\n// Array-as-queue is good enough here, since we are just dealing with exceptions.\nvar pendingErrors = [];\nvar requestErrorThrow = rawAsap.makeRequestCallFromTimer(throwFirstError);\n\nfunction throwFirstError() {\n    if (pendingErrors.length) {\n        throw pendingErrors.shift();\n    }\n}\n\n/**\n * Calls a task as soon as possible after returning, in its own event, with priority\n * over other events like animation, reflow, and repaint. An error thrown from an\n * event will not interrupt, nor even substantially slow down the processing of\n * other events, but will be rather postponed to a lower priority event.\n * @param {{call}} task A callable object, typically a function that takes no\n * arguments.\n */\nmodule.exports = asap;\nfunction asap(task) {\n    var rawTask;\n    if (freeTasks.length) {\n        rawTask = freeTasks.pop();\n    } else {\n        rawTask = new RawTask();\n    }\n    rawTask.task = task;\n    rawAsap(rawTask);\n}\n\n// We wrap tasks with recyclable task objects.  A task object implements\n// `call`, just like a function.\nfunction RawTask() {\n    this.task = null;\n}\n\n// The sole purpose of wrapping the task is to catch the exception and recycle\n// the task object after its single use.\nRawTask.prototype.call = function () {\n    try {\n        this.task.call();\n    } catch (error) {\n        if (asap.onerror) {\n            // This hook exists purely for testing purposes.\n            // Its name will be periodically randomized to break any code that\n            // depends on its existence.\n            asap.onerror(error);\n        } else {\n            // In a web browser, exceptions are not fatal. However, to avoid\n            // slowing down the queue of pending tasks, we rethrow the error in a\n            // lower priority turn.\n            pendingErrors.push(error);\n            requestErrorThrow();\n        }\n    } finally {\n        this.task = null;\n        freeTasks[freeTasks.length] = this;\n    }\n};","deps":{"./raw":"node_modules/asap/browser-raw.js"}},{"id":"node_modules/asap/browser-raw.js","source":"(function (global){\n\"use strict\";\n\n// Use the fastest means possible to execute a task in its own turn, with\n// priority over other events including IO, animation, reflow, and redraw\n// events in browsers.\n//\n// An exception thrown by a task will permanently interrupt the processing of\n// subsequent tasks. The higher level `asap` function ensures that if an\n// exception is thrown by a task, that the task queue will continue flushing as\n// soon as possible, but if you use `rawAsap` directly, you are responsible to\n// either ensure that no exceptions are thrown from your task, or to manually\n// call `rawAsap.requestFlush` if an exception is thrown.\nmodule.exports = rawAsap;\nfunction rawAsap(task) {\n    if (!queue.length) {\n        requestFlush();\n        flushing = true;\n    }\n    // Equivalent to push, but avoids a function call.\n    queue[queue.length] = task;\n}\n\nvar queue = [];\n// Once a flush has been requested, no further calls to `requestFlush` are\n// necessary until the next `flush` completes.\nvar flushing = false;\n// `requestFlush` is an implementation-specific method that attempts to kick\n// off a `flush` event as quickly as possible. `flush` will attempt to exhaust\n// the event queue before yielding to the browser's own event loop.\nvar requestFlush;\n// The position of the next task to execute in the task queue. This is\n// preserved between calls to `flush` so that it can be resumed if\n// a task throws an exception.\nvar index = 0;\n// If a task schedules additional tasks recursively, the task queue can grow\n// unbounded. To prevent memory exhaustion, the task queue will periodically\n// truncate already-completed tasks.\nvar capacity = 1024;\n\n// The flush function processes all tasks that have been scheduled with\n// `rawAsap` unless and until one of those tasks throws an exception.\n// If a task throws an exception, `flush` ensures that its state will remain\n// consistent and will resume where it left off when called again.\n// However, `flush` does not make any arrangements to be called again if an\n// exception is thrown.\nfunction flush() {\n    while (index < queue.length) {\n        var currentIndex = index;\n        // Advance the index before calling the task. This ensures that we will\n        // begin flushing on the next task the task throws an error.\n        index = index + 1;\n        queue[currentIndex].call();\n        // Prevent leaking memory for long chains of recursive calls to `asap`.\n        // If we call `asap` within tasks scheduled by `asap`, the queue will\n        // grow, but to avoid an O(n) walk for every task we execute, we don't\n        // shift tasks off the queue after they have been executed.\n        // Instead, we periodically shift 1024 tasks off the queue.\n        if (index > capacity) {\n            // Manually shift all values starting at the index back to the\n            // beginning of the queue.\n            for (var scan = 0, newLength = queue.length - index; scan < newLength; scan++) {\n                queue[scan] = queue[scan + index];\n            }\n            queue.length -= index;\n            index = 0;\n        }\n    }\n    queue.length = 0;\n    index = 0;\n    flushing = false;\n}\n\n// `requestFlush` is implemented using a strategy based on data collected from\n// every available SauceLabs Selenium web driver worker at time of writing.\n// https://docs.google.com/spreadsheets/d/1mG-5UYGup5qxGdEMWkhP6BWCz053NUb2E1QoUTU16uA/edit#gid=783724593\n\n// Safari 6 and 6.1 for desktop, iPad, and iPhone are the only browsers that\n// have WebKitMutationObserver but not un-prefixed MutationObserver.\n// Must use `global` or `self` instead of `window` to work in both frames and web\n// workers. `global` is a provision of Browserify, Mr, Mrs, or Mop.\n\n/* globals self */\nvar scope = typeof global !== \"undefined\" ? global : self;\nvar BrowserMutationObserver = scope.MutationObserver || scope.WebKitMutationObserver;\n\n// MutationObservers are desirable because they have high priority and work\n// reliably everywhere they are implemented.\n// They are implemented in all modern browsers.\n//\n// - Android 4-4.3\n// - Chrome 26-34\n// - Firefox 14-29\n// - Internet Explorer 11\n// - iPad Safari 6-7.1\n// - iPhone Safari 7-7.1\n// - Safari 6-7\nif (typeof BrowserMutationObserver === \"function\") {\n    requestFlush = makeRequestCallFromMutationObserver(flush);\n\n// MessageChannels are desirable because they give direct access to the HTML\n// task queue, are implemented in Internet Explorer 10, Safari 5.0-1, and Opera\n// 11-12, and in web workers in many engines.\n// Although message channels yield to any queued rendering and IO tasks, they\n// would be better than imposing the 4ms delay of timers.\n// However, they do not work reliably in Internet Explorer or Safari.\n\n// Internet Explorer 10 is the only browser that has setImmediate but does\n// not have MutationObservers.\n// Although setImmediate yields to the browser's renderer, it would be\n// preferrable to falling back to setTimeout since it does not have\n// the minimum 4ms penalty.\n// Unfortunately there appears to be a bug in Internet Explorer 10 Mobile (and\n// Desktop to a lesser extent) that renders both setImmediate and\n// MessageChannel useless for the purposes of ASAP.\n// https://github.com/kriskowal/q/issues/396\n\n// Timers are implemented universally.\n// We fall back to timers in workers in most engines, and in foreground\n// contexts in the following browsers.\n// However, note that even this simple case requires nuances to operate in a\n// broad spectrum of browsers.\n//\n// - Firefox 3-13\n// - Internet Explorer 6-9\n// - iPad Safari 4.3\n// - Lynx 2.8.7\n} else {\n    requestFlush = makeRequestCallFromTimer(flush);\n}\n\n// `requestFlush` requests that the high priority event queue be flushed as\n// soon as possible.\n// This is useful to prevent an error thrown in a task from stalling the event\n// queue if the exception handled by Node.js’s\n// `process.on(\"uncaughtException\")` or by a domain.\nrawAsap.requestFlush = requestFlush;\n\n// To request a high priority event, we induce a mutation observer by toggling\n// the text of a text node between \"1\" and \"-1\".\nfunction makeRequestCallFromMutationObserver(callback) {\n    var toggle = 1;\n    var observer = new BrowserMutationObserver(callback);\n    var node = document.createTextNode(\"\");\n    observer.observe(node, {characterData: true});\n    return function requestCall() {\n        toggle = -toggle;\n        node.data = toggle;\n    };\n}\n\n// The message channel technique was discovered by Malte Ubl and was the\n// original foundation for this library.\n// http://www.nonblocking.io/2011/06/windownexttick.html\n\n// Safari 6.0.5 (at least) intermittently fails to create message ports on a\n// page's first load. Thankfully, this version of Safari supports\n// MutationObservers, so we don't need to fall back in that case.\n\n// function makeRequestCallFromMessageChannel(callback) {\n//     var channel = new MessageChannel();\n//     channel.port1.onmessage = callback;\n//     return function requestCall() {\n//         channel.port2.postMessage(0);\n//     };\n// }\n\n// For reasons explained above, we are also unable to use `setImmediate`\n// under any circumstances.\n// Even if we were, there is another bug in Internet Explorer 10.\n// It is not sufficient to assign `setImmediate` to `requestFlush` because\n// `setImmediate` must be called *by name* and therefore must be wrapped in a\n// closure.\n// Never forget.\n\n// function makeRequestCallFromSetImmediate(callback) {\n//     return function requestCall() {\n//         setImmediate(callback);\n//     };\n// }\n\n// Safari 6.0 has a problem where timers will get lost while the user is\n// scrolling. This problem does not impact ASAP because Safari 6.0 supports\n// mutation observers, so that implementation is used instead.\n// However, if we ever elect to use timers in Safari, the prevalent work-around\n// is to add a scroll event listener that calls for a flush.\n\n// `setTimeout` does not call the passed callback if the delay is less than\n// approximately 7 in web workers in Firefox 8 through 18, and sometimes not\n// even then.\n\nfunction makeRequestCallFromTimer(callback) {\n    return function requestCall() {\n        // We dispatch a timeout with a specified delay of 0 for engines that\n        // can reliably accommodate that request. This will usually be snapped\n        // to a 4 milisecond delay, but once we're flushing, there's no delay\n        // between events.\n        var timeoutHandle = setTimeout(handleTimer, 0);\n        // However, since this timer gets frequently dropped in Firefox\n        // workers, we enlist an interval handle that will try to fire\n        // an event 20 times per second until it succeeds.\n        var intervalHandle = setInterval(handleTimer, 50);\n\n        function handleTimer() {\n            // Whichever timer succeeds will cancel both timers and\n            // execute the callback.\n            clearTimeout(timeoutHandle);\n            clearInterval(intervalHandle);\n            callback();\n        }\n    };\n}\n\n// This is for `asap.js` only.\n// Its name will be periodically randomized to break any code that depends on\n// its existence.\nrawAsap.makeRequestCallFromTimer = makeRequestCallFromTimer;\n\n// ASAP was originally a nextTick shim included in Q. This was factored out\n// into this ASAP package. It was later adapted to RSVP which made further\n// amendments. These decisions, particularly to marginalize MessageChannel and\n// to capture the MutationObserver implementation in a closure, were integrated\n// back into ASAP proper.\n// https://github.com/tildeio/rsvp.js/blob/cddf7232546a9cf858524b75cde6f9edf72620a7/lib/rsvp/asap.js\n\n}).call(this,typeof global !== \"undefined\" ? global : typeof self !== \"undefined\" ? self : typeof window !== \"undefined\" ? window : {})","deps":{}},{"id":"node_modules/asn1.js/lib/asn1.js","source":"var asn1 = exports;\n\nasn1.bignum = require('bn.js');\n\nasn1.define = require('./asn1/api').define;\nasn1.base = require('./asn1/base');\nasn1.constants = require('./asn1/constants');\nasn1.decoders = require('./asn1/decoders');\nasn1.encoders = require('./asn1/encoders');","deps":{"./asn1/api":"node_modules/asn1.js/lib/asn1/api.js","./asn1/base":"node_modules/asn1.js/lib/asn1/base/index.js","./asn1/constants":"node_modules/asn1.js/lib/asn1/constants/index.js","./asn1/decoders":"node_modules/asn1.js/lib/asn1/decoders/index.js","./asn1/encoders":"node_modules/asn1.js/lib/asn1/encoders/index.js","bn.js":"node_modules/bn.js/lib/bn.js"}},{"id":"node_modules/asn1.js/lib/asn1/api.js","source":"var asn1 = require('../asn1');\nvar inherits = require('inherits');\nvar vm = require('vm');\n\nvar api = exports;\n\napi.define = function define(name, body) {\n  return new Entity(name, body);\n};\n\nfunction Entity(name, body) {\n  this.name = name;\n  this.body = body;\n\n  this.decoders = {};\n  this.encoders = {};\n};\n\nEntity.prototype._createNamed = function createNamed(base) {\n  var named = vm.runInThisContext('(function ' + this.name + '(entity) {\\n' +\n    '  this._initNamed(entity);\\n' +\n    '})');\n  inherits(named, base);\n  named.prototype._initNamed = function initnamed(entity) {\n    base.call(this, entity);\n  };\n\n  return new named(this);\n};\n\nEntity.prototype._getDecoder = function _getDecoder(enc) {\n  // Lazily create decoder\n  if (!this.decoders.hasOwnProperty(enc))\n    this.decoders[enc] = this._createNamed(asn1.decoders[enc]);\n  return this.decoders[enc];\n};\n\nEntity.prototype.decode = function decode(data, enc, options) {\n  return this._getDecoder(enc).decode(data, options);\n};\n\nEntity.prototype._getEncoder = function _getEncoder(enc) {\n  // Lazily create encoder\n  if (!this.encoders.hasOwnProperty(enc))\n    this.encoders[enc] = this._createNamed(asn1.encoders[enc]);\n  return this.encoders[enc];\n};\n\nEntity.prototype.encode = function encode(data, enc, /* internal */ reporter) {\n  return this._getEncoder(enc).encode(data, reporter);\n};","deps":{"../asn1":"node_modules/asn1.js/lib/asn1.js","inherits":"node_modules/inherits/inherits_browser.js","vm":"node_modules/vm-browserify/index.js"}},{"id":"node_modules/asn1.js/lib/asn1/base/buffer.js","source":"var inherits = require('inherits');\nvar Reporter = require('../base').Reporter;\nvar Buffer = require('buffer').Buffer;\n\nfunction DecoderBuffer(base, options) {\n  Reporter.call(this, options);\n  if (!Buffer.isBuffer(base)) {\n    this.error('Input not Buffer');\n    return;\n  }\n\n  this.base = base;\n  this.offset = 0;\n  this.length = base.length;\n}\ninherits(DecoderBuffer, Reporter);\nexports.DecoderBuffer = DecoderBuffer;\n\nDecoderBuffer.prototype.save = function save() {\n  return { offset: this.offset };\n};\n\nDecoderBuffer.prototype.restore = function restore(save) {\n  // Return skipped data\n  var res = new DecoderBuffer(this.base);\n  res.offset = save.offset;\n  res.length = this.offset;\n\n  this.offset = save.offset;\n\n  return res;\n};\n\nDecoderBuffer.prototype.isEmpty = function isEmpty() {\n  return this.offset === this.length;\n};\n\nDecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {\n  if (this.offset + 1 <= this.length)\n    return this.base.readUInt8(this.offset++, true);\n  else\n    return this.error(fail || 'DecoderBuffer overrun');\n}\n\nDecoderBuffer.prototype.skip = function skip(bytes, fail) {\n  if (!(this.offset + bytes <= this.length))\n    return this.error(fail || 'DecoderBuffer overrun');\n\n  var res = new DecoderBuffer(this.base);\n\n  // Share reporter state\n  res._reporterState = this._reporterState;\n\n  res.offset = this.offset;\n  res.length = this.offset + bytes;\n  this.offset += bytes;\n  return res;\n}\n\nDecoderBuffer.prototype.raw = function raw(save) {\n  return this.base.slice(save ? save.offset : this.offset, this.length);\n}\n\nfunction EncoderBuffer(value, reporter) {\n  if (Array.isArray(value)) {\n    this.length = 0;\n    this.value = value.map(function(item) {\n      if (!(item instanceof EncoderBuffer))\n        item = new EncoderBuffer(item, reporter);\n      this.length += item.length;\n      return item;\n    }, this);\n  } else if (typeof value === 'number') {\n    if (!(0 <= value && value <= 0xff))\n      return reporter.error('non-byte EncoderBuffer value');\n    this.value = value;\n    this.length = 1;\n  } else if (typeof value === 'string') {\n    this.value = value;\n    this.length = Buffer.byteLength(value);\n  } else if (Buffer.isBuffer(value)) {\n    this.value = value;\n    this.length = value.length;\n  } else {\n    return reporter.error('Unsupported type: ' + typeof value);\n  }\n}\nexports.EncoderBuffer = EncoderBuffer;\n\nEncoderBuffer.prototype.join = function join(out, offset) {\n  if (!out)\n    out = new Buffer(this.length);\n  if (!offset)\n    offset = 0;\n\n  if (this.length === 0)\n    return out;\n\n  if (Array.isArray(this.value)) {\n    this.value.forEach(function(item) {\n      item.join(out, offset);\n      offset += item.length;\n    });\n  } else {\n    if (typeof this.value === 'number')\n      out[offset] = this.value;\n    else if (typeof this.value === 'string')\n      out.write(this.value, offset);\n    else if (Buffer.isBuffer(this.value))\n      this.value.copy(out, offset);\n    offset += this.length;\n  }\n\n  return out;\n};","deps":{"../base":"node_modules/asn1.js/lib/asn1/base/index.js","buffer":"node_modules/buffer/index.js","inherits":"node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/asn1.js/lib/asn1/base/index.js","source":"var base = exports;\n\nbase.Reporter = require('./reporter').Reporter;\nbase.DecoderBuffer = require('./buffer').DecoderBuffer;\nbase.EncoderBuffer = require('./buffer').EncoderBuffer;\nbase.Node = require('./node');","deps":{"./buffer":"node_modules/asn1.js/lib/asn1/base/buffer.js","./node":"node_modules/asn1.js/lib/asn1/base/node.js","./reporter":"node_modules/asn1.js/lib/asn1/base/reporter.js"}},{"id":"node_modules/asn1.js/lib/asn1/base/node.js","source":"var Reporter = require('../base').Reporter;\nvar EncoderBuffer = require('../base').EncoderBuffer;\nvar assert = require('minimalistic-assert');\n\n// Supported tags\nvar tags = [\n  'seq', 'seqof', 'set', 'setof', 'octstr', 'bitstr', 'objid', 'bool',\n  'gentime', 'utctime', 'null_', 'enum', 'int', 'ia5str'\n];\n\n// Public methods list\nvar methods = [\n  'key', 'obj', 'use', 'optional', 'explicit', 'implicit', 'def', 'choice',\n  'any'\n].concat(tags);\n\n// Overrided methods list\nvar overrided = [\n  '_peekTag', '_decodeTag', '_use',\n  '_decodeStr', '_decodeObjid', '_decodeTime',\n  '_decodeNull', '_decodeInt', '_decodeBool', '_decodeList',\n\n  '_encodeComposite', '_encodeStr', '_encodeObjid', '_encodeTime',\n  '_encodeNull', '_encodeInt', '_encodeBool'\n];\n\nfunction Node(enc, parent) {\n  var state = {};\n  this._baseState = state;\n\n  state.enc = enc;\n\n  state.parent = parent || null;\n  state.children = null;\n\n  // State\n  state.tag = null;\n  state.args = null;\n  state.reverseArgs = null;\n  state.choice = null;\n  state.optional = false;\n  state.any = false;\n  state.obj = false;\n  state.use = null;\n  state.useDecoder = null;\n  state.key = null;\n  state['default'] = null;\n  state.explicit = null;\n  state.implicit = null;\n\n  // Should create new instance on each method\n  if (!state.parent) {\n    state.children = [];\n    this._wrap();\n  }\n}\nmodule.exports = Node;\n\nvar stateProps = [\n  'enc', 'parent', 'children', 'tag', 'args', 'reverseArgs', 'choice',\n  'optional', 'any', 'obj', 'use', 'alteredUse', 'key', 'default', 'explicit',\n  'implicit'\n];\n\nNode.prototype.clone = function clone() {\n  var state = this._baseState;\n  var cstate = {};\n  stateProps.forEach(function(prop) {\n    cstate[prop] = state[prop];\n  });\n  var res = new this.constructor(cstate.parent);\n  res._baseState = cstate;\n  return res;\n};\n\nNode.prototype._wrap = function wrap() {\n  var state = this._baseState;\n  methods.forEach(function(method) {\n    this[method] = function _wrappedMethod() {\n      var clone = new this.constructor(this);\n      state.children.push(clone);\n      return clone[method].apply(clone, arguments);\n    };\n  }, this);\n};\n\nNode.prototype._init = function init(body) {\n  var state = this._baseState;\n\n  assert(state.parent === null);\n  body.call(this);\n\n  // Filter children\n  state.children = state.children.filter(function(child) {\n    return child._baseState.parent === this;\n  }, this);\n  assert.equal(state.children.length, 1, 'Root node can have only one child');\n};\n\nNode.prototype._useArgs = function useArgs(args) {\n  var state = this._baseState;\n\n  // Filter children and args\n  var children = args.filter(function(arg) {\n    return arg instanceof this.constructor;\n  }, this);\n  args = args.filter(function(arg) {\n    return !(arg instanceof this.constructor);\n  }, this);\n\n  if (children.length !== 0) {\n    assert(state.children === null);\n    state.children = children;\n\n    // Replace parent to maintain backward link\n    children.forEach(function(child) {\n      child._baseState.parent = this;\n    }, this);\n  }\n  if (args.length !== 0) {\n    assert(state.args === null);\n    state.args = args;\n    state.reverseArgs = args.map(function(arg) {\n      if (typeof arg !== 'object' || arg.constructor !== Object)\n        return arg;\n\n      var res = {};\n      Object.keys(arg).forEach(function(key) {\n        if (key == (key | 0))\n          key |= 0;\n        var value = arg[key];\n        res[value] = key;\n      });\n      return res;\n    });\n  }\n};\n\n//\n// Overrided methods\n//\n\noverrided.forEach(function(method) {\n  Node.prototype[method] = function _overrided() {\n    var state = this._baseState;\n    throw new Error(method + ' not implemented for encoding: ' + state.enc);\n  };\n});\n\n//\n// Public methods\n//\n\ntags.forEach(function(tag) {\n  Node.prototype[tag] = function _tagMethod() {\n    var state = this._baseState;\n    var args = Array.prototype.slice.call(arguments);\n\n    assert(state.tag === null);\n    state.tag = tag;\n\n    this._useArgs(args);\n\n    return this;\n  };\n});\n\nNode.prototype.use = function use(item) {\n  var state = this._baseState;\n\n  assert(state.use === null);\n  state.use = item;\n\n  return this;\n};\n\nNode.prototype.optional = function optional() {\n  var state = this._baseState;\n\n  state.optional = true;\n\n  return this;\n};\n\nNode.prototype.def = function def(val) {\n  var state = this._baseState;\n\n  assert(state['default'] === null);\n  state['default'] = val;\n  state.optional = true;\n\n  return this;\n};\n\nNode.prototype.explicit = function explicit(num) {\n  var state = this._baseState;\n\n  assert(state.explicit === null && state.implicit === null);\n  state.explicit = num;\n\n  return this;\n};\n\nNode.prototype.implicit = function implicit(num) {\n  var state = this._baseState;\n\n  assert(state.explicit === null && state.implicit === null);\n  state.implicit = num;\n\n  return this;\n};\n\nNode.prototype.obj = function obj() {\n  var state = this._baseState;\n  var args = Array.prototype.slice.call(arguments);\n\n  state.obj = true;\n\n  if (args.length !== 0)\n    this._useArgs(args);\n\n  return this;\n};\n\nNode.prototype.key = function key(newKey) {\n  var state = this._baseState;\n\n  assert(state.key === null);\n  state.key = newKey;\n\n  return this;\n};\n\nNode.prototype.any = function any() {\n  var state = this._baseState;\n\n  state.any = true;\n\n  return this;\n};\n\nNode.prototype.choice = function choice(obj) {\n  var state = this._baseState;\n\n  assert(state.choice === null);\n  state.choice = obj;\n  this._useArgs(Object.keys(obj).map(function(key) {\n    return obj[key];\n  }));\n\n  return this;\n};\n\n//\n// Decoding\n//\n\nNode.prototype._decode = function decode(input) {\n  var state = this._baseState;\n\n  // Decode root node\n  if (state.parent === null)\n    return input.wrapResult(state.children[0]._decode(input));\n\n  var result = state['default'];\n  var present = true;\n\n  var prevKey;\n  if (state.key !== null)\n    prevKey = input.enterKey(state.key);\n\n  // Check if tag is there\n  if (state.optional) {\n    present = this._peekTag(\n      input,\n      state.explicit !== null ? state.explicit :\n          state.implicit !== null ? state.implicit :\n              state.tag || 0\n    );\n    if (input.isError(present))\n      return present;\n  }\n\n  // Push object on stack\n  var prevObj;\n  if (state.obj && present)\n    prevObj = input.enterObject();\n\n  if (present) {\n    // Unwrap explicit values\n    if (state.explicit !== null) {\n      var explicit = this._decodeTag(input, state.explicit);\n      if (input.isError(explicit))\n        return explicit;\n      input = explicit;\n    }\n\n    // Unwrap implicit and normal values\n    if (state.use === null && state.choice === null) {\n      if (state.any)\n        var save = input.save();\n      var body = this._decodeTag(\n        input,\n        state.implicit !== null ? state.implicit : state.tag,\n        state.any\n      );\n      if (input.isError(body))\n        return body;\n\n      if (state.any)\n        result = input.raw(save);\n      else\n        input = body;\n    }\n\n    // Select proper method for tag\n    if (state.any)\n      result = result;\n    else if (state.choice === null)\n      result = this._decodeGeneric(state.tag, input);\n    else\n      result = this._decodeChoice(input);\n\n    if (input.isError(result))\n      return result;\n\n    // Decode children\n    if (!state.any && state.choice === null && state.children !== null) {\n      var fail = state.children.some(function decodeChildren(child) {\n        // NOTE: We are ignoring errors here, to let parser continue with other\n        // parts of encoded data\n        child._decode(input);\n      });\n      if (fail)\n        return err;\n    }\n  }\n\n  // Pop object\n  if (state.obj && present)\n    result = input.leaveObject(prevObj);\n\n  // Set key\n  if (state.key !== null && (result !== null || present === true))\n    input.leaveKey(prevKey, state.key, result);\n\n  return result;\n};\n\nNode.prototype._decodeGeneric = function decodeGeneric(tag, input) {\n  var state = this._baseState;\n\n  if (tag === 'seq' || tag === 'set')\n    return null;\n  if (tag === 'seqof' || tag === 'setof')\n    return this._decodeList(input, tag, state.args[0]);\n  else if (tag === 'octstr' || tag === 'bitstr' || tag === 'ia5str')\n    return this._decodeStr(input, tag);\n  else if (tag === 'objid' && state.args)\n    return this._decodeObjid(input, state.args[0], state.args[1]);\n  else if (tag === 'objid')\n    return this._decodeObjid(input, null, null);\n  else if (tag === 'gentime' || tag === 'utctime')\n    return this._decodeTime(input, tag);\n  else if (tag === 'null_')\n    return this._decodeNull(input);\n  else if (tag === 'bool')\n    return this._decodeBool(input);\n  else if (tag === 'int' || tag === 'enum')\n    return this._decodeInt(input, state.args && state.args[0]);\n  else if (state.use !== null)\n    return this._getUse(state.use, input._reporterState.obj)._decode(input);\n  else\n    return input.error('unknown tag: ' + tag);\n\n  return null;\n};\n\nNode.prototype._getUse = function _getUse(entity, obj) {\n\n  var state = this._baseState;\n  // Create altered use decoder if implicit is set\n  state.useDecoder = this._use(entity, obj);\n  assert(state.useDecoder._baseState.parent === null);\n  state.useDecoder = state.useDecoder._baseState.children[0];\n  if (state.implicit !== state.useDecoder._baseState.implicit) {\n    state.useDecoder = state.useDecoder.clone();\n    state.useDecoder._baseState.implicit = state.implicit;\n  }\n  return state.useDecoder;\n};\n\nNode.prototype._decodeChoice = function decodeChoice(input) {\n  var state = this._baseState;\n  var result = null;\n  var match = false;\n\n  Object.keys(state.choice).some(function(key) {\n    var save = input.save();\n    var node = state.choice[key];\n    try {\n      var value = node._decode(input);\n      if (input.isError(value))\n        return false;\n\n      result = { type: key, value: value };\n      match = true;\n    } catch (e) {\n      input.restore(save);\n      return false;\n    }\n    return true;\n  }, this);\n\n  if (!match)\n    return input.error('Choice not matched');\n\n  return result;\n};\n\n//\n// Encoding\n//\n\nNode.prototype._createEncoderBuffer = function createEncoderBuffer(data) {\n  return new EncoderBuffer(data, this.reporter);\n};\n\nNode.prototype._encode = function encode(data, reporter, parent) {\n  var state = this._baseState;\n  if (state['default'] !== null && state['default'] === data)\n    return;\n\n  var result = this._encodeValue(data, reporter, parent);\n  if (result === undefined)\n    return;\n\n  if (this._skipDefault(result, reporter, parent))\n    return;\n\n  return result;\n};\n\nNode.prototype._encodeValue = function encode(data, reporter, parent) {\n  var state = this._baseState;\n\n  // Decode root node\n  if (state.parent === null)\n    return state.children[0]._encode(data, reporter || new Reporter());\n\n  var result = null;\n  var present = true;\n\n  // Set reporter to share it with a child class\n  this.reporter = reporter;\n\n  // Check if data is there\n  if (state.optional && data === undefined) {\n    if (state['default'] !== null)\n      data = state['default']\n    else\n      return;\n  }\n\n  // For error reporting\n  var prevKey;\n\n  // Encode children first\n  var content = null;\n  var primitive = false;\n  if (state.any) {\n    // Anything that was given is translated to buffer\n    result = this._createEncoderBuffer(data);\n  } else if (state.choice) {\n    result = this._encodeChoice(data, reporter);\n  } else if (state.children) {\n    content = state.children.map(function(child) {\n      if (child._baseState.tag === 'null_')\n        return child._encode(null, reporter, data);\n\n      if (child._baseState.key === null)\n        return reporter.error('Child should have a key');\n      var prevKey = reporter.enterKey(child._baseState.key);\n\n      if (typeof data !== 'object')\n        return reporter.error('Child expected, but input is not object');\n\n      var res = child._encode(data[child._baseState.key], reporter, data);\n      reporter.leaveKey(prevKey);\n\n      return res;\n    }, this).filter(function(child) {\n      return child;\n    });\n\n    content = this._createEncoderBuffer(content);\n  } else {\n    if (state.tag === 'seqof' || state.tag === 'setof') {\n      // TODO(indutny): this should be thrown on DSL level\n      if (!(state.args && state.args.length === 1))\n        return reporter.error('Too many args for : ' + state.tag);\n\n      if (!Array.isArray(data))\n        return reporter.error('seqof/setof, but data is not Array');\n\n      var child = this.clone();\n      child._baseState.implicit = null;\n      content = this._createEncoderBuffer(data.map(function(item) {\n        var state = this._baseState;\n\n        return this._getUse(state.args[0], data)._encode(item, reporter);\n      }, child));\n    } else if (state.use !== null) {\n      result = this._getUse(state.use, parent)._encode(data, reporter);\n    } else {\n      content = this._encodePrimitive(state.tag, data);\n      primitive = true;\n    }\n  }\n\n  // Encode data itself\n  var result;\n  if (!state.any && state.choice === null) {\n    var tag = state.implicit !== null ? state.implicit : state.tag;\n    var cls = state.implicit === null ? 'universal' : 'context';\n\n    if (tag === null) {\n      if (state.use === null)\n        reporter.error('Tag could be ommited only for .use()');\n    } else {\n      if (state.use === null)\n        result = this._encodeComposite(tag, primitive, cls, content);\n    }\n  }\n\n  // Wrap in explicit\n  if (state.explicit !== null)\n    result = this._encodeComposite(state.explicit, false, 'context', result);\n\n  return result;\n};\n\nNode.prototype._encodeChoice = function encodeChoice(data, reporter) {\n  var state = this._baseState;\n\n  var node = state.choice[data.type];\n  if (!node) {\n    assert(\n        false,\n        data.type + ' not found in ' +\n            JSON.stringify(Object.keys(state.choice)));\n  }\n  return node._encode(data.value, reporter);\n};\n\nNode.prototype._encodePrimitive = function encodePrimitive(tag, data) {\n  var state = this._baseState;\n\n  if (tag === 'octstr' || tag === 'bitstr' || tag === 'ia5str')\n    return this._encodeStr(data, tag);\n  else if (tag === 'objid' && state.args)\n    return this._encodeObjid(data, state.reverseArgs[0], state.args[1]);\n  else if (tag === 'objid')\n    return this._encodeObjid(data, null, null);\n  else if (tag === 'gentime' || tag === 'utctime')\n    return this._encodeTime(data, tag);\n  else if (tag === 'null_')\n    return this._encodeNull();\n  else if (tag === 'int' || tag === 'enum')\n    return this._encodeInt(data, state.args && state.reverseArgs[0]);\n  else if (tag === 'bool')\n    return this._encodeBool(data);\n  else\n    throw new Error('Unsupported tag: ' + tag);\n};","deps":{"../base":"node_modules/asn1.js/lib/asn1/base/index.js","minimalistic-assert":"node_modules/minimalistic-assert/index.js"}},{"id":"node_modules/asn1.js/lib/asn1/base/reporter.js","source":"var inherits = require('inherits');\n\nfunction Reporter(options) {\n  this._reporterState = {\n    obj: null,\n    path: [],\n    options: options || {},\n    errors: []\n  };\n}\nexports.Reporter = Reporter;\n\nReporter.prototype.isError = function isError(obj) {\n  return obj instanceof ReporterError;\n};\n\nReporter.prototype.enterKey = function enterKey(key) {\n  return this._reporterState.path.push(key);\n};\n\nReporter.prototype.leaveKey = function leaveKey(index, key, value) {\n  var state = this._reporterState;\n\n  state.path = state.path.slice(0, index - 1);\n  if (state.obj !== null)\n    state.obj[key] = value;\n};\n\nReporter.prototype.enterObject = function enterObject() {\n  var state = this._reporterState;\n\n  var prev = state.obj;\n  state.obj = {};\n  return prev;\n};\n\nReporter.prototype.leaveObject = function leaveObject(prev) {\n  var state = this._reporterState;\n\n  var now = state.obj;\n  state.obj = prev;\n  return now;\n};\n\nReporter.prototype.error = function error(msg) {\n  var err;\n  var state = this._reporterState;\n\n  var inherited = msg instanceof ReporterError;\n  if (inherited) {\n    err = msg;\n  } else {\n    err = new ReporterError(state.path.map(function(elem) {\n      return '[' + JSON.stringify(elem) + ']';\n    }).join(''), msg.message || msg, msg.stack);\n  }\n\n  if (!state.options.partial)\n    throw err;\n\n  if (!inherited)\n    state.errors.push(err);\n\n  return err;\n};\n\nReporter.prototype.wrapResult = function wrapResult(result) {\n  var state = this._reporterState;\n  if (!state.options.partial)\n    return result;\n\n  return {\n    result: this.isError(result) ? null : result,\n    errors: state.errors\n  };\n};\n\nfunction ReporterError(path, msg) {\n  this.path = path;\n  this.rethrow(msg);\n};\ninherits(ReporterError, Error);\n\nReporterError.prototype.rethrow = function rethrow(msg) {\n  this.message = msg + ' at: ' + (this.path || '(shallow)');\n  Error.captureStackTrace(this, ReporterError);\n\n  return this;\n};","deps":{"inherits":"node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/asn1.js/lib/asn1/constants/der.js","source":"var constants = require('../constants');\n\nexports.tagClass = {\n  0: 'universal',\n  1: 'application',\n  2: 'context',\n  3: 'private'\n};\nexports.tagClassByName = constants._reverse(exports.tagClass);\n\nexports.tag = {\n  0x00: 'end',\n  0x01: 'bool',\n  0x02: 'int',\n  0x03: 'bitstr',\n  0x04: 'octstr',\n  0x05: 'null_',\n  0x06: 'objid',\n  0x07: 'objDesc',\n  0x08: 'external',\n  0x09: 'real',\n  0x0a: 'enum',\n  0x0b: 'embed',\n  0x0c: 'utf8str',\n  0x0d: 'relativeOid',\n  0x10: 'seq',\n  0x11: 'set',\n  0x12: 'numstr',\n  0x13: 'printstr',\n  0x14: 't61str',\n  0x15: 'videostr',\n  0x16: 'ia5str',\n  0x17: 'utctime',\n  0x18: 'gentime',\n  0x19: 'graphstr',\n  0x1a: 'iso646str',\n  0x1b: 'genstr',\n  0x1c: 'unistr',\n  0x1d: 'charstr',\n  0x1e: 'bmpstr'\n};\nexports.tagByName = constants._reverse(exports.tag);","deps":{"../constants":"node_modules/asn1.js/lib/asn1/constants/index.js"}},{"id":"node_modules/asn1.js/lib/asn1/constants/index.js","source":"var constants = exports;\n\n// Helper\nconstants._reverse = function reverse(map) {\n  var res = {};\n\n  Object.keys(map).forEach(function(key) {\n    // Convert key to integer if it is stringified\n    if ((key | 0) == key)\n      key = key | 0;\n\n    var value = map[key];\n    res[value] = key;\n  });\n\n  return res;\n};\n\nconstants.der = require('./der');","deps":{"./der":"node_modules/asn1.js/lib/asn1/constants/der.js"}},{"id":"node_modules/asn1.js/lib/asn1/decoders/der.js","source":"var inherits = require('inherits');\n\nvar asn1 = require('../../asn1');\nvar base = asn1.base;\nvar bignum = asn1.bignum;\n\n// Import DER constants\nvar der = asn1.constants.der;\n\nfunction DERDecoder(entity) {\n  this.enc = 'der';\n  this.name = entity.name;\n  this.entity = entity;\n\n  // Construct base tree\n  this.tree = new DERNode();\n  this.tree._init(entity.body);\n};\nmodule.exports = DERDecoder;\n\nDERDecoder.prototype.decode = function decode(data, options) {\n  if (!(data instanceof base.DecoderBuffer))\n    data = new base.DecoderBuffer(data, options);\n\n  return this.tree._decode(data, options);\n};\n\n// Tree methods\n\nfunction DERNode(parent) {\n  base.Node.call(this, 'der', parent);\n}\ninherits(DERNode, base.Node);\n\nDERNode.prototype._peekTag = function peekTag(buffer, tag) {\n  if (buffer.isEmpty())\n    return false;\n\n  var state = buffer.save();\n  var decodedTag = derDecodeTag(buffer, 'Failed to peek tag: \"' + tag + '\"');\n  if (buffer.isError(decodedTag))\n    return decodedTag;\n\n  buffer.restore(state);\n\n  return decodedTag.tag === tag || decodedTag.tagStr === tag;\n};\n\nDERNode.prototype._decodeTag = function decodeTag(buffer, tag, any) {\n  var decodedTag = derDecodeTag(buffer,\n                                'Failed to decode tag of \"' + tag + '\"');\n  if (buffer.isError(decodedTag))\n    return decodedTag;\n\n  var len = derDecodeLen(buffer,\n                         decodedTag.primitive,\n                         'Failed to get length of \"' + tag + '\"');\n\n  // Failure\n  if (buffer.isError(len))\n    return len;\n\n  if (!any &&\n      decodedTag.tag !== tag &&\n      decodedTag.tagStr !== tag &&\n      decodedTag.tagStr + 'of' !== tag) {\n    return buffer.error('Failed to match tag: \"' + tag + '\"');\n  }\n\n  if (decodedTag.primitive || len !== null)\n    return buffer.skip(len, 'Failed to match body of: \"' + tag + '\"');\n\n  // Indefinite length... find END tag\n  var state = buffer.start();\n  var res = this._skipUntilEnd(\n      buffer,\n      'Failed to skip indefinite length body: \"' + this.tag + '\"');\n  if (buffer.isError(res))\n    return res;\n\n  return buffer.cut(state);\n};\n\nDERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer, fail) {\n  while (true) {\n    var tag = derDecodeTag(buffer, fail);\n    if (buffer.isError(tag))\n      return tag;\n    var len = derDecodeLen(buffer, tag.primitive, fail);\n    if (buffer.isError(len))\n      return len;\n\n    var res;\n    if (tag.primitive || len !== null)\n      res = buffer.skip(len)\n    else\n      res = this._skipUntilEnd(buffer, fail);\n\n    // Failure\n    if (buffer.isError(res))\n      return res;\n\n    if (tag.tagStr === 'end')\n      break;\n  }\n};\n\nDERNode.prototype._decodeList = function decodeList(buffer, tag, decoder) {\n  var result = [];\n  while (!buffer.isEmpty()) {\n    var possibleEnd = this._peekTag(buffer, 'end');\n    if (buffer.isError(possibleEnd))\n      return possibleEnd;\n\n    var res = decoder.decode(buffer, 'der');\n    if (buffer.isError(res) && possibleEnd)\n      break;\n    result.push(res);\n  }\n  return result;\n};\n\nDERNode.prototype._decodeStr = function decodeStr(buffer, tag) {\n  if (tag === 'octstr') {\n    return buffer.raw();\n  } else if (tag === 'bitstr') {\n    var unused = buffer.readUInt8();\n    if (buffer.isError(unused))\n      return unused;\n\n    return { unused: unused, data: buffer.raw() };\n  } else if (tag === 'ia5str') {\n    return buffer.raw().toString();\n  } else {\n    return this.error('Decoding of string type: ' + tag + ' unsupported');\n  }\n};\n\nDERNode.prototype._decodeObjid = function decodeObjid(buffer, values, relative) {\n  var identifiers = [];\n  var ident = 0;\n  while (!buffer.isEmpty()) {\n    var subident = buffer.readUInt8();\n    ident <<= 7;\n    ident |= subident & 0x7f;\n    if ((subident & 0x80) === 0) {\n      identifiers.push(ident);\n      ident = 0;\n    }\n  }\n  if (subident & 0x80)\n    identifiers.push(ident);\n\n  var first = (identifiers[0] / 40) | 0;\n  var second = identifiers[0] % 40;\n\n  if (relative)\n    result = identifiers;\n  else\n    result = [first, second].concat(identifiers.slice(1));\n\n  if (values)\n    result = values[result.join(' ')];\n\n  return result;\n};\n\nDERNode.prototype._decodeTime = function decodeTime(buffer, tag) {\n  var str = buffer.raw().toString();\n  if (tag === 'gentime') {\n    var year = str.slice(0, 4) | 0;\n    var mon = str.slice(4, 6) | 0;\n    var day = str.slice(6, 8) | 0;\n    var hour = str.slice(8, 10) | 0;\n    var min = str.slice(10, 12) | 0;\n    var sec = str.slice(12, 14) | 0;\n  } else if (tag === 'utctime') {\n    var year = str.slice(0, 2) | 0;\n    var mon = str.slice(2, 4) | 0;\n    var day = str.slice(4, 6) | 0;\n    var hour = str.slice(6, 8) | 0;\n    var min = str.slice(8, 10) | 0;\n    var sec = str.slice(10, 12) | 0;\n    if (year < 70)\n      year = 2000 + year;\n    else\n      year = 1900 + year;\n  } else {\n    return this.error('Decoding ' + tag + ' time is not supported yet');\n  }\n\n  return Date.UTC(year, mon - 1, day, hour, min, sec, 0);\n};\n\nDERNode.prototype._decodeNull = function decodeNull(buffer) {\n  return null;\n};\n\nDERNode.prototype._decodeBool = function decodeBool(buffer) {\n  var res = buffer.readUInt8();\n  if (buffer.isError(res))\n    return res;\n  else\n    return res !== 0;\n};\n\nDERNode.prototype._decodeInt = function decodeInt(buffer, values) {\n  var res = 0;\n\n  // Bigint, return as it is (assume big endian)\n  var raw = buffer.raw();\n  if (raw.length > 3)\n    return new bignum(raw);\n\n  while (!buffer.isEmpty()) {\n    res <<= 8;\n    var i = buffer.readUInt8();\n    if (buffer.isError(i))\n      return i;\n    res |= i;\n  }\n\n  if (values)\n    res = values[res] || res;\n\n  return res;\n};\n\nDERNode.prototype._use = function use(entity, obj) {\n  if (typeof entity === 'function')\n    entity = entity(obj);\n  return entity._getDecoder('der').tree;\n};\n\n// Utility methods\n\nfunction derDecodeTag(buf, fail) {\n  var tag = buf.readUInt8(fail);\n  if (buf.isError(tag))\n    return tag;\n\n  var cls = der.tagClass[tag >> 6];\n  var primitive = (tag & 0x20) === 0;\n\n  // Multi-octet tag - load\n  if ((tag & 0x1f) === 0x1f) {\n    var oct = tag;\n    tag = 0;\n    while ((oct & 0x80) === 0x80) {\n      oct = buf.readUInt8(fail);\n      if (buf.isError(oct))\n        return oct;\n\n      tag <<= 7;\n      tag |= oct & 0x7f;\n    }\n  } else {\n    tag &= 0x1f;\n  }\n  var tagStr = der.tag[tag];\n\n  return {\n    cls: cls,\n    primitive: primitive,\n    tag: tag,\n    tagStr: tagStr\n  };\n}\n\nfunction derDecodeLen(buf, primitive, fail) {\n  var len = buf.readUInt8(fail);\n  if (buf.isError(len))\n    return len;\n\n  // Indefinite form\n  if (!primitive && len === 0x80)\n    return null;\n\n  // Definite form\n  if ((len & 0x80) === 0) {\n    // Short form\n    return len;\n  }\n\n  // Long form\n  var num = len & 0x7f;\n  if (num >= 4)\n    return buf.error('length octect is too long');\n\n  len = 0;\n  for (var i = 0; i < num; i++) {\n    len <<= 8;\n    var j = buf.readUInt8(fail);\n    if (buf.isError(j))\n      return j;\n    len |= j;\n  }\n\n  return len;\n}","deps":{"../../asn1":"node_modules/asn1.js/lib/asn1.js","inherits":"node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/asn1.js/lib/asn1/decoders/index.js","source":"var decoders = exports;\n\ndecoders.der = require('./der');","deps":{"./der":"node_modules/asn1.js/lib/asn1/decoders/der.js"}},{"id":"node_modules/asn1.js/lib/asn1/encoders/der.js","source":"var inherits = require('inherits');\nvar Buffer = require('buffer').Buffer;\n\nvar asn1 = require('../../asn1');\nvar base = asn1.base;\nvar bignum = asn1.bignum;\n\n// Import DER constants\nvar der = asn1.constants.der;\n\nfunction DEREncoder(entity) {\n  this.enc = 'der';\n  this.name = entity.name;\n  this.entity = entity;\n\n  // Construct base tree\n  this.tree = new DERNode();\n  this.tree._init(entity.body);\n};\nmodule.exports = DEREncoder;\n\nDEREncoder.prototype.encode = function encode(data, reporter) {\n  return this.tree._encode(data, reporter).join();\n};\n\n// Tree methods\n\nfunction DERNode(parent) {\n  base.Node.call(this, 'der', parent);\n}\ninherits(DERNode, base.Node);\n\nDERNode.prototype._encodeComposite = function encodeComposite(tag,\n                                                              primitive,\n                                                              cls,\n                                                              content) {\n  var encodedTag = encodeTag(tag, primitive, cls, this.reporter);\n\n  // Short form\n  if (content.length < 0x80) {\n    var header = new Buffer(2);\n    header[0] = encodedTag;\n    header[1] = content.length;\n    return this._createEncoderBuffer([ header, content ]);\n  }\n\n  // Long form\n  // Count octets required to store length\n  var lenOctets = 1;\n  for (var i = content.length; i >= 0x100; i >>= 8)\n    lenOctets++;\n\n  var header = new Buffer(1 + 1 + lenOctets);\n  header[0] = encodedTag;\n  header[1] = 0x80 | lenOctets;\n\n  for (var i = 1 + lenOctets, j = content.length; j > 0; i--, j >>= 8)\n    header[i] = j & 0xff;\n\n  return this._createEncoderBuffer([ header, content ]);\n};\n\nDERNode.prototype._encodeStr = function encodeStr(str, tag) {\n  if (tag === 'octstr')\n    return this._createEncoderBuffer(str);\n  else if (tag === 'bitstr')\n    return this._createEncoderBuffer([ str.unused | 0, str.data ]);\n  else if (tag === 'ia5str')\n    return this._createEncoderBuffer(str);\n  return this.reporter.error('Encoding of string type: ' + tag +\n                             ' unsupported');\n};\n\nDERNode.prototype._encodeObjid = function encodeObjid(id, values, relative) {\n  if (typeof id === 'string') {\n    if (!values)\n      return this.reporter.error('string objid given, but no values map found');\n    if (!values.hasOwnProperty(id))\n      return this.reporter.error('objid not found in values map');\n    id = values[id].split(/\\s+/g);\n    for (var i = 0; i < id.length; i++)\n      id[i] |= 0;\n  } else if (Array.isArray(id)) {\n    id = id.slice();\n  }\n\n  if (!Array.isArray(id)) {\n    return this.reporter.error('objid() should be either array or string, ' +\n                               'got: ' + JSON.stringify(id));\n  }\n\n  if (!relative) {\n    if (id[1] >= 40)\n      return this.reporter.error('Second objid identifier OOB');\n    id.splice(0, 2, id[0] * 40 + id[1]);\n  }\n\n  // Count number of octets\n  var size = 0;\n  for (var i = 0; i < id.length; i++) {\n    var ident = id[i];\n    for (size++; ident >= 0x80; ident >>= 7)\n      size++;\n  }\n\n  var objid = new Buffer(size);\n  var offset = objid.length - 1;\n  for (var i = id.length - 1; i >= 0; i--) {\n    var ident = id[i];\n    objid[offset--] = ident & 0x7f;\n    while ((ident >>= 7) > 0)\n      objid[offset--] = 0x80 | (ident & 0x7f);\n  }\n\n  return this._createEncoderBuffer(objid);\n};\n\nfunction two(num) {\n  if (num <= 10)\n    return '0' + num;\n  else\n    return num;\n}\n\nDERNode.prototype._encodeTime = function encodeTime(time, tag) {\n  var str;\n  var date = new Date(time);\n\n  if (tag === 'gentime') {\n    str = [\n      date.getFullYear(),\n      two(date.getUTCMonth() + 1),\n      two(date.getUTCDate()),\n      two(date.getUTCHours()),\n      two(date.getUTCMinutes()),\n      two(date.getUTCSeconds()),\n      'Z'\n    ].join('');\n  } else if (tag === 'utctime') {\n    str = [\n      date.getFullYear() % 100,\n      two(date.getUTCMonth() + 1),\n      two(date.getUTCDate()),\n      two(date.getUTCHours()),\n      two(date.getUTCMinutes()),\n      two(date.getUTCSeconds()),\n      'Z'\n    ].join('');\n  } else {\n    this.reporter.error('Encoding ' + tag + ' time is not supported yet');\n  }\n\n  return this._encodeStr(str, 'octstr');\n};\n\nDERNode.prototype._encodeNull = function encodeNull() {\n  return this._createEncoderBuffer('');\n};\n\nDERNode.prototype._encodeInt = function encodeInt(num, values) {\n  if (typeof num === 'string') {\n    if (!values)\n      return this.reporter.error('String int or enum given, but no values map');\n    if (!values.hasOwnProperty(num)) {\n      return this.reporter.error('Values map doesn\\'t contain: ' +\n                                 JSON.stringify(num));\n    }\n    num = values[num];\n  }\n\n  // Bignum, assume big endian\n  if (bignum !== null && num instanceof bignum) {\n    var numArray = num.toArray();\n    if(num.sign === false && numArray[0] & 0x80) {\n      numArray.unshift(0);\n    }\n    num = new Buffer(numArray);\n  }\n\n  if (Buffer.isBuffer(num)) {\n    var size = num.length;\n    if (num.length === 0)\n      size++;\n\n    var out = new Buffer(size);\n    num.copy(out);\n    if (num.length === 0)\n      out[0] = 0\n    return this._createEncoderBuffer(out);\n  }\n\n  if (num < 0x80)\n    return this._createEncoderBuffer(num);\n\n  if (num < 0x100)\n    return this._createEncoderBuffer([0, num]);\n\n  var size = 1;\n  for (var i = num; i >= 0x100; i >>= 8)\n    size++;\n\n  var out = new Array(size);\n  for (var i = out.length - 1; i >= 0; i--) {\n    out[i] = num & 0xff;\n    num >>= 8;\n  }\n  if(out[0] & 0x80) {\n    out.unshift(0);\n  }\n\n  return this._createEncoderBuffer(new Buffer(out));\n};\n\nDERNode.prototype._encodeBool = function encodeBool(value) {\n  return this._createEncoderBuffer(value ? 0xff : 0);\n};\n\nDERNode.prototype._use = function use(entity, obj) {\n  if (typeof entity === 'function')\n    entity = entity(obj);\n  return entity._getEncoder('der').tree;\n};\n\nDERNode.prototype._skipDefault = function skipDefault(dataBuffer, reporter, parent) {\n  var state = this._baseState;\n  var i;\n  if (state['default'] === null)\n    return false;\n\n  var data = dataBuffer.join();\n  if (state.defaultBuffer === undefined)\n    state.defaultBuffer = this._encodeValue(state['default'], reporter, parent).join();\n\n  if (data.length !== state.defaultBuffer.length)\n    return false;\n\n  for (i=0; i < data.length; i++)\n    if (data[i] !== state.defaultBuffer[i])\n      return false;\n\n  return true;\n};\n\n// Utility methods\n\nfunction encodeTag(tag, primitive, cls, reporter) {\n  var res;\n\n  if (tag === 'seqof')\n    tag = 'seq';\n  else if (tag === 'setof')\n    tag = 'set';\n\n  if (der.tagByName.hasOwnProperty(tag))\n    res = der.tagByName[tag];\n  else if (typeof tag === 'number' && (tag | 0) === tag)\n    res = tag;\n  else\n    return reporter.error('Unknown tag: ' + tag);\n\n  if (res >= 0x1f)\n    return reporter.error('Multi-octet tag encoding unsupported');\n\n  if (!primitive)\n    res |= 0x20;\n\n  res |= (der.tagClassByName[cls || 'universal'] << 6);\n\n  return res;\n}","deps":{"../../asn1":"node_modules/asn1.js/lib/asn1.js","buffer":"node_modules/buffer/index.js","inherits":"node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/asn1.js/lib/asn1/encoders/index.js","source":"var encoders = exports;\n\nencoders.der = require('./der');","deps":{"./der":"node_modules/asn1.js/lib/asn1/encoders/der.js"}},{"id":"node_modules/base64-js/lib/b64.js","source":"var lookup = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';\n\n;(function (exports) {\n\t'use strict';\n\n  var Arr = (typeof Uint8Array !== 'undefined')\n    ? Uint8Array\n    : Array\n\n\tvar PLUS   = '+'.charCodeAt(0)\n\tvar SLASH  = '/'.charCodeAt(0)\n\tvar NUMBER = '0'.charCodeAt(0)\n\tvar LOWER  = 'a'.charCodeAt(0)\n\tvar UPPER  = 'A'.charCodeAt(0)\n\tvar PLUS_URL_SAFE = '-'.charCodeAt(0)\n\tvar SLASH_URL_SAFE = '_'.charCodeAt(0)\n\n\tfunction decode (elt) {\n\t\tvar code = elt.charCodeAt(0)\n\t\tif (code === PLUS ||\n\t\t    code === PLUS_URL_SAFE)\n\t\t\treturn 62 // '+'\n\t\tif (code === SLASH ||\n\t\t    code === SLASH_URL_SAFE)\n\t\t\treturn 63 // '/'\n\t\tif (code < NUMBER)\n\t\t\treturn -1 //no match\n\t\tif (code < NUMBER + 10)\n\t\t\treturn code - NUMBER + 26 + 26\n\t\tif (code < UPPER + 26)\n\t\t\treturn code - UPPER\n\t\tif (code < LOWER + 26)\n\t\t\treturn code - LOWER + 26\n\t}\n\n\tfunction b64ToByteArray (b64) {\n\t\tvar i, j, l, tmp, placeHolders, arr\n\n\t\tif (b64.length % 4 > 0) {\n\t\t\tthrow new Error('Invalid string. Length must be a multiple of 4')\n\t\t}\n\n\t\t// the number of equal signs (place holders)\n\t\t// if there are two placeholders, than the two characters before it\n\t\t// represent one byte\n\t\t// if there is only one, then the three characters before it represent 2 bytes\n\t\t// this is just a cheap hack to not do indexOf twice\n\t\tvar len = b64.length\n\t\tplaceHolders = '=' === b64.charAt(len - 2) ? 2 : '=' === b64.charAt(len - 1) ? 1 : 0\n\n\t\t// base64 is 4/3 + up to two characters of the original data\n\t\tarr = new Arr(b64.length * 3 / 4 - placeHolders)\n\n\t\t// if there are placeholders, only get up to the last complete 4 chars\n\t\tl = placeHolders > 0 ? b64.length - 4 : b64.length\n\n\t\tvar L = 0\n\n\t\tfunction push (v) {\n\t\t\tarr[L++] = v\n\t\t}\n\n\t\tfor (i = 0, j = 0; i < l; i += 4, j += 3) {\n\t\t\ttmp = (decode(b64.charAt(i)) << 18) | (decode(b64.charAt(i + 1)) << 12) | (decode(b64.charAt(i + 2)) << 6) | decode(b64.charAt(i + 3))\n\t\t\tpush((tmp & 0xFF0000) >> 16)\n\t\t\tpush((tmp & 0xFF00) >> 8)\n\t\t\tpush(tmp & 0xFF)\n\t\t}\n\n\t\tif (placeHolders === 2) {\n\t\t\ttmp = (decode(b64.charAt(i)) << 2) | (decode(b64.charAt(i + 1)) >> 4)\n\t\t\tpush(tmp & 0xFF)\n\t\t} else if (placeHolders === 1) {\n\t\t\ttmp = (decode(b64.charAt(i)) << 10) | (decode(b64.charAt(i + 1)) << 4) | (decode(b64.charAt(i + 2)) >> 2)\n\t\t\tpush((tmp >> 8) & 0xFF)\n\t\t\tpush(tmp & 0xFF)\n\t\t}\n\n\t\treturn arr\n\t}\n\n\tfunction uint8ToBase64 (uint8) {\n\t\tvar i,\n\t\t\textraBytes = uint8.length % 3, // if we have 1 byte left, pad 2 bytes\n\t\t\toutput = \"\",\n\t\t\ttemp, length\n\n\t\tfunction encode (num) {\n\t\t\treturn lookup.charAt(num)\n\t\t}\n\n\t\tfunction tripletToBase64 (num) {\n\t\t\treturn encode(num >> 18 & 0x3F) + encode(num >> 12 & 0x3F) + encode(num >> 6 & 0x3F) + encode(num & 0x3F)\n\t\t}\n\n\t\t// go through the array every three bytes, we'll deal with trailing stuff later\n\t\tfor (i = 0, length = uint8.length - extraBytes; i < length; i += 3) {\n\t\t\ttemp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])\n\t\t\toutput += tripletToBase64(temp)\n\t\t}\n\n\t\t// pad the end with zeros, but make sure to not forget the extra bytes\n\t\tswitch (extraBytes) {\n\t\t\tcase 1:\n\t\t\t\ttemp = uint8[uint8.length - 1]\n\t\t\t\toutput += encode(temp >> 2)\n\t\t\t\toutput += encode((temp << 4) & 0x3F)\n\t\t\t\toutput += '=='\n\t\t\t\tbreak\n\t\t\tcase 2:\n\t\t\t\ttemp = (uint8[uint8.length - 2] << 8) + (uint8[uint8.length - 1])\n\t\t\t\toutput += encode(temp >> 10)\n\t\t\t\toutput += encode((temp >> 4) & 0x3F)\n\t\t\t\toutput += encode((temp << 2) & 0x3F)\n\t\t\t\toutput += '='\n\t\t\t\tbreak\n\t\t}\n\n\t\treturn output\n\t}\n\n\texports.toByteArray = b64ToByteArray\n\texports.fromByteArray = uint8ToBase64\n}(typeof exports === 'undefined' ? (this.base64js = {}) : exports))","deps":{}},{"id":"node_modules/bluebird/js/browser/bluebird.js","source":"(function (process,global,setImmediate){\n/* @preserve\n * The MIT License (MIT)\n * \n * Copyright (c) 2013-2017 Petka Antonov\n * \n * Permission is hereby granted, free of charge, to any person obtaining a copy\n * of this software and associated documentation files (the \"Software\"), to deal\n * in the Software without restriction, including without limitation the rights\n * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the Software is\n * furnished to do so, subject to the following conditions:\n * \n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n * \n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n * THE SOFTWARE.\n * \n */\n/**\n * bluebird build version 3.5.0\n * Features enabled: core, race, call_get, generators, map, nodeify, promisify, props, reduce, settle, some, using, timers, filter, any, each\n*/\n!function(e){if(\"object\"==typeof exports&&\"undefined\"!=typeof module)module.exports=e();else if(\"function\"==typeof define&&define.amd)define([],e);else{var f;\"undefined\"!=typeof window?f=window:\"undefined\"!=typeof global?f=global:\"undefined\"!=typeof self&&(f=self),f.Promise=e()}}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof _dereq_==\"function\"&&_dereq_;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error(\"Cannot find module '\"+o+\"'\");throw f.code=\"MODULE_NOT_FOUND\",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof _dereq_==\"function\"&&_dereq_;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise) {\nvar SomePromiseArray = Promise._SomePromiseArray;\nfunction any(promises) {\n    var ret = new SomePromiseArray(promises);\n    var promise = ret.promise();\n    ret.setHowMany(1);\n    ret.setUnwrap();\n    ret.init();\n    return promise;\n}\n\nPromise.any = function (promises) {\n    return any(promises);\n};\n\nPromise.prototype.any = function () {\n    return any(this);\n};\n\n};\n\n},{}],2:[function(_dereq_,module,exports){\n\"use strict\";\nvar firstLineError;\ntry {throw new Error(); } catch (e) {firstLineError = e;}\nvar schedule = _dereq_(\"./schedule\");\nvar Queue = _dereq_(\"./queue\");\nvar util = _dereq_(\"./util\");\n\nfunction Async() {\n    this._customScheduler = false;\n    this._isTickUsed = false;\n    this._lateQueue = new Queue(16);\n    this._normalQueue = new Queue(16);\n    this._haveDrainedQueues = false;\n    this._trampolineEnabled = true;\n    var self = this;\n    this.drainQueues = function () {\n        self._drainQueues();\n    };\n    this._schedule = schedule;\n}\n\nAsync.prototype.setScheduler = function(fn) {\n    var prev = this._schedule;\n    this._schedule = fn;\n    this._customScheduler = true;\n    return prev;\n};\n\nAsync.prototype.hasCustomScheduler = function() {\n    return this._customScheduler;\n};\n\nAsync.prototype.enableTrampoline = function() {\n    this._trampolineEnabled = true;\n};\n\nAsync.prototype.disableTrampolineIfNecessary = function() {\n    if (util.hasDevTools) {\n        this._trampolineEnabled = false;\n    }\n};\n\nAsync.prototype.haveItemsQueued = function () {\n    return this._isTickUsed || this._haveDrainedQueues;\n};\n\n\nAsync.prototype.fatalError = function(e, isNode) {\n    if (isNode) {\n        process.stderr.write(\"Fatal \" + (e instanceof Error ? e.stack : e) +\n            \"\\n\");\n        process.exit(2);\n    } else {\n        this.throwLater(e);\n    }\n};\n\nAsync.prototype.throwLater = function(fn, arg) {\n    if (arguments.length === 1) {\n        arg = fn;\n        fn = function () { throw arg; };\n    }\n    if (typeof setTimeout !== \"undefined\") {\n        setTimeout(function() {\n            fn(arg);\n        }, 0);\n    } else try {\n        this._schedule(function() {\n            fn(arg);\n        });\n    } catch (e) {\n        throw new Error(\"No async scheduler available\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n};\n\nfunction AsyncInvokeLater(fn, receiver, arg) {\n    this._lateQueue.push(fn, receiver, arg);\n    this._queueTick();\n}\n\nfunction AsyncInvoke(fn, receiver, arg) {\n    this._normalQueue.push(fn, receiver, arg);\n    this._queueTick();\n}\n\nfunction AsyncSettlePromises(promise) {\n    this._normalQueue._pushOne(promise);\n    this._queueTick();\n}\n\nif (!util.hasDevTools) {\n    Async.prototype.invokeLater = AsyncInvokeLater;\n    Async.prototype.invoke = AsyncInvoke;\n    Async.prototype.settlePromises = AsyncSettlePromises;\n} else {\n    Async.prototype.invokeLater = function (fn, receiver, arg) {\n        if (this._trampolineEnabled) {\n            AsyncInvokeLater.call(this, fn, receiver, arg);\n        } else {\n            this._schedule(function() {\n                setTimeout(function() {\n                    fn.call(receiver, arg);\n                }, 100);\n            });\n        }\n    };\n\n    Async.prototype.invoke = function (fn, receiver, arg) {\n        if (this._trampolineEnabled) {\n            AsyncInvoke.call(this, fn, receiver, arg);\n        } else {\n            this._schedule(function() {\n                fn.call(receiver, arg);\n            });\n        }\n    };\n\n    Async.prototype.settlePromises = function(promise) {\n        if (this._trampolineEnabled) {\n            AsyncSettlePromises.call(this, promise);\n        } else {\n            this._schedule(function() {\n                promise._settlePromises();\n            });\n        }\n    };\n}\n\nAsync.prototype._drainQueue = function(queue) {\n    while (queue.length() > 0) {\n        var fn = queue.shift();\n        if (typeof fn !== \"function\") {\n            fn._settlePromises();\n            continue;\n        }\n        var receiver = queue.shift();\n        var arg = queue.shift();\n        fn.call(receiver, arg);\n    }\n};\n\nAsync.prototype._drainQueues = function () {\n    this._drainQueue(this._normalQueue);\n    this._reset();\n    this._haveDrainedQueues = true;\n    this._drainQueue(this._lateQueue);\n};\n\nAsync.prototype._queueTick = function () {\n    if (!this._isTickUsed) {\n        this._isTickUsed = true;\n        this._schedule(this.drainQueues);\n    }\n};\n\nAsync.prototype._reset = function () {\n    this._isTickUsed = false;\n};\n\nmodule.exports = Async;\nmodule.exports.firstLineError = firstLineError;\n\n},{\"./queue\":26,\"./schedule\":29,\"./util\":36}],3:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL, tryConvertToPromise, debug) {\nvar calledBind = false;\nvar rejectThis = function(_, e) {\n    this._reject(e);\n};\n\nvar targetRejected = function(e, context) {\n    context.promiseRejectionQueued = true;\n    context.bindingPromise._then(rejectThis, rejectThis, null, this, e);\n};\n\nvar bindingResolved = function(thisArg, context) {\n    if (((this._bitField & 50397184) === 0)) {\n        this._resolveCallback(context.target);\n    }\n};\n\nvar bindingRejected = function(e, context) {\n    if (!context.promiseRejectionQueued) this._reject(e);\n};\n\nPromise.prototype.bind = function (thisArg) {\n    if (!calledBind) {\n        calledBind = true;\n        Promise.prototype._propagateFrom = debug.propagateFromFunction();\n        Promise.prototype._boundValue = debug.boundValueFunction();\n    }\n    var maybePromise = tryConvertToPromise(thisArg);\n    var ret = new Promise(INTERNAL);\n    ret._propagateFrom(this, 1);\n    var target = this._target();\n    ret._setBoundTo(maybePromise);\n    if (maybePromise instanceof Promise) {\n        var context = {\n            promiseRejectionQueued: false,\n            promise: ret,\n            target: target,\n            bindingPromise: maybePromise\n        };\n        target._then(INTERNAL, targetRejected, undefined, ret, context);\n        maybePromise._then(\n            bindingResolved, bindingRejected, undefined, ret, context);\n        ret._setOnCancel(maybePromise);\n    } else {\n        ret._resolveCallback(target);\n    }\n    return ret;\n};\n\nPromise.prototype._setBoundTo = function (obj) {\n    if (obj !== undefined) {\n        this._bitField = this._bitField | 2097152;\n        this._boundTo = obj;\n    } else {\n        this._bitField = this._bitField & (~2097152);\n    }\n};\n\nPromise.prototype._isBound = function () {\n    return (this._bitField & 2097152) === 2097152;\n};\n\nPromise.bind = function (thisArg, value) {\n    return Promise.resolve(value).bind(thisArg);\n};\n};\n\n},{}],4:[function(_dereq_,module,exports){\n\"use strict\";\nvar old;\nif (typeof Promise !== \"undefined\") old = Promise;\nfunction noConflict() {\n    try { if (Promise === bluebird) Promise = old; }\n    catch (e) {}\n    return bluebird;\n}\nvar bluebird = _dereq_(\"./promise\")();\nbluebird.noConflict = noConflict;\nmodule.exports = bluebird;\n\n},{\"./promise\":22}],5:[function(_dereq_,module,exports){\n\"use strict\";\nvar cr = Object.create;\nif (cr) {\n    var callerCache = cr(null);\n    var getterCache = cr(null);\n    callerCache[\" size\"] = getterCache[\" size\"] = 0;\n}\n\nmodule.exports = function(Promise) {\nvar util = _dereq_(\"./util\");\nvar canEvaluate = util.canEvaluate;\nvar isIdentifier = util.isIdentifier;\n\nvar getMethodCaller;\nvar getGetter;\nif (!true) {\nvar makeMethodCaller = function (methodName) {\n    return new Function(\"ensureMethod\", \"                                    \\n\\\n        return function(obj) {                                               \\n\\\n            'use strict'                                                     \\n\\\n            var len = this.length;                                           \\n\\\n            ensureMethod(obj, 'methodName');                                 \\n\\\n            switch(len) {                                                    \\n\\\n                case 1: return obj.methodName(this[0]);                      \\n\\\n                case 2: return obj.methodName(this[0], this[1]);             \\n\\\n                case 3: return obj.methodName(this[0], this[1], this[2]);    \\n\\\n                case 0: return obj.methodName();                             \\n\\\n                default:                                                     \\n\\\n                    return obj.methodName.apply(obj, this);                  \\n\\\n            }                                                                \\n\\\n        };                                                                   \\n\\\n        \".replace(/methodName/g, methodName))(ensureMethod);\n};\n\nvar makeGetter = function (propertyName) {\n    return new Function(\"obj\", \"                                             \\n\\\n        'use strict';                                                        \\n\\\n        return obj.propertyName;                                             \\n\\\n        \".replace(\"propertyName\", propertyName));\n};\n\nvar getCompiled = function(name, compiler, cache) {\n    var ret = cache[name];\n    if (typeof ret !== \"function\") {\n        if (!isIdentifier(name)) {\n            return null;\n        }\n        ret = compiler(name);\n        cache[name] = ret;\n        cache[\" size\"]++;\n        if (cache[\" size\"] > 512) {\n            var keys = Object.keys(cache);\n            for (var i = 0; i < 256; ++i) delete cache[keys[i]];\n            cache[\" size\"] = keys.length - 256;\n        }\n    }\n    return ret;\n};\n\ngetMethodCaller = function(name) {\n    return getCompiled(name, makeMethodCaller, callerCache);\n};\n\ngetGetter = function(name) {\n    return getCompiled(name, makeGetter, getterCache);\n};\n}\n\nfunction ensureMethod(obj, methodName) {\n    var fn;\n    if (obj != null) fn = obj[methodName];\n    if (typeof fn !== \"function\") {\n        var message = \"Object \" + util.classString(obj) + \" has no method '\" +\n            util.toString(methodName) + \"'\";\n        throw new Promise.TypeError(message);\n    }\n    return fn;\n}\n\nfunction caller(obj) {\n    var methodName = this.pop();\n    var fn = ensureMethod(obj, methodName);\n    return fn.apply(obj, this);\n}\nPromise.prototype.call = function (methodName) {\n    var args = [].slice.call(arguments, 1);;\n    if (!true) {\n        if (canEvaluate) {\n            var maybeCaller = getMethodCaller(methodName);\n            if (maybeCaller !== null) {\n                return this._then(\n                    maybeCaller, undefined, undefined, args, undefined);\n            }\n        }\n    }\n    args.push(methodName);\n    return this._then(caller, undefined, undefined, args, undefined);\n};\n\nfunction namedGetter(obj) {\n    return obj[this];\n}\nfunction indexedGetter(obj) {\n    var index = +this;\n    if (index < 0) index = Math.max(0, index + obj.length);\n    return obj[index];\n}\nPromise.prototype.get = function (propertyName) {\n    var isIndex = (typeof propertyName === \"number\");\n    var getter;\n    if (!isIndex) {\n        if (canEvaluate) {\n            var maybeGetter = getGetter(propertyName);\n            getter = maybeGetter !== null ? maybeGetter : namedGetter;\n        } else {\n            getter = namedGetter;\n        }\n    } else {\n        getter = indexedGetter;\n    }\n    return this._then(getter, undefined, undefined, propertyName, undefined);\n};\n};\n\n},{\"./util\":36}],6:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, PromiseArray, apiRejection, debug) {\nvar util = _dereq_(\"./util\");\nvar tryCatch = util.tryCatch;\nvar errorObj = util.errorObj;\nvar async = Promise._async;\n\nPromise.prototype[\"break\"] = Promise.prototype.cancel = function() {\n    if (!debug.cancellation()) return this._warn(\"cancellation is disabled\");\n\n    var promise = this;\n    var child = promise;\n    while (promise._isCancellable()) {\n        if (!promise._cancelBy(child)) {\n            if (child._isFollowing()) {\n                child._followee().cancel();\n            } else {\n                child._cancelBranched();\n            }\n            break;\n        }\n\n        var parent = promise._cancellationParent;\n        if (parent == null || !parent._isCancellable()) {\n            if (promise._isFollowing()) {\n                promise._followee().cancel();\n            } else {\n                promise._cancelBranched();\n            }\n            break;\n        } else {\n            if (promise._isFollowing()) promise._followee().cancel();\n            promise._setWillBeCancelled();\n            child = promise;\n            promise = parent;\n        }\n    }\n};\n\nPromise.prototype._branchHasCancelled = function() {\n    this._branchesRemainingToCancel--;\n};\n\nPromise.prototype._enoughBranchesHaveCancelled = function() {\n    return this._branchesRemainingToCancel === undefined ||\n           this._branchesRemainingToCancel <= 0;\n};\n\nPromise.prototype._cancelBy = function(canceller) {\n    if (canceller === this) {\n        this._branchesRemainingToCancel = 0;\n        this._invokeOnCancel();\n        return true;\n    } else {\n        this._branchHasCancelled();\n        if (this._enoughBranchesHaveCancelled()) {\n            this._invokeOnCancel();\n            return true;\n        }\n    }\n    return false;\n};\n\nPromise.prototype._cancelBranched = function() {\n    if (this._enoughBranchesHaveCancelled()) {\n        this._cancel();\n    }\n};\n\nPromise.prototype._cancel = function() {\n    if (!this._isCancellable()) return;\n    this._setCancelled();\n    async.invoke(this._cancelPromises, this, undefined);\n};\n\nPromise.prototype._cancelPromises = function() {\n    if (this._length() > 0) this._settlePromises();\n};\n\nPromise.prototype._unsetOnCancel = function() {\n    this._onCancelField = undefined;\n};\n\nPromise.prototype._isCancellable = function() {\n    return this.isPending() && !this._isCancelled();\n};\n\nPromise.prototype.isCancellable = function() {\n    return this.isPending() && !this.isCancelled();\n};\n\nPromise.prototype._doInvokeOnCancel = function(onCancelCallback, internalOnly) {\n    if (util.isArray(onCancelCallback)) {\n        for (var i = 0; i < onCancelCallback.length; ++i) {\n            this._doInvokeOnCancel(onCancelCallback[i], internalOnly);\n        }\n    } else if (onCancelCallback !== undefined) {\n        if (typeof onCancelCallback === \"function\") {\n            if (!internalOnly) {\n                var e = tryCatch(onCancelCallback).call(this._boundValue());\n                if (e === errorObj) {\n                    this._attachExtraTrace(e.e);\n                    async.throwLater(e.e);\n                }\n            }\n        } else {\n            onCancelCallback._resultCancelled(this);\n        }\n    }\n};\n\nPromise.prototype._invokeOnCancel = function() {\n    var onCancelCallback = this._onCancel();\n    this._unsetOnCancel();\n    async.invoke(this._doInvokeOnCancel, this, onCancelCallback);\n};\n\nPromise.prototype._invokeInternalOnCancel = function() {\n    if (this._isCancellable()) {\n        this._doInvokeOnCancel(this._onCancel(), true);\n        this._unsetOnCancel();\n    }\n};\n\nPromise.prototype._resultCancelled = function() {\n    this.cancel();\n};\n\n};\n\n},{\"./util\":36}],7:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(NEXT_FILTER) {\nvar util = _dereq_(\"./util\");\nvar getKeys = _dereq_(\"./es5\").keys;\nvar tryCatch = util.tryCatch;\nvar errorObj = util.errorObj;\n\nfunction catchFilter(instances, cb, promise) {\n    return function(e) {\n        var boundTo = promise._boundValue();\n        predicateLoop: for (var i = 0; i < instances.length; ++i) {\n            var item = instances[i];\n\n            if (item === Error ||\n                (item != null && item.prototype instanceof Error)) {\n                if (e instanceof item) {\n                    return tryCatch(cb).call(boundTo, e);\n                }\n            } else if (typeof item === \"function\") {\n                var matchesPredicate = tryCatch(item).call(boundTo, e);\n                if (matchesPredicate === errorObj) {\n                    return matchesPredicate;\n                } else if (matchesPredicate) {\n                    return tryCatch(cb).call(boundTo, e);\n                }\n            } else if (util.isObject(e)) {\n                var keys = getKeys(item);\n                for (var j = 0; j < keys.length; ++j) {\n                    var key = keys[j];\n                    if (item[key] != e[key]) {\n                        continue predicateLoop;\n                    }\n                }\n                return tryCatch(cb).call(boundTo, e);\n            }\n        }\n        return NEXT_FILTER;\n    };\n}\n\nreturn catchFilter;\n};\n\n},{\"./es5\":13,\"./util\":36}],8:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise) {\nvar longStackTraces = false;\nvar contextStack = [];\n\nPromise.prototype._promiseCreated = function() {};\nPromise.prototype._pushContext = function() {};\nPromise.prototype._popContext = function() {return null;};\nPromise._peekContext = Promise.prototype._peekContext = function() {};\n\nfunction Context() {\n    this._trace = new Context.CapturedTrace(peekContext());\n}\nContext.prototype._pushContext = function () {\n    if (this._trace !== undefined) {\n        this._trace._promiseCreated = null;\n        contextStack.push(this._trace);\n    }\n};\n\nContext.prototype._popContext = function () {\n    if (this._trace !== undefined) {\n        var trace = contextStack.pop();\n        var ret = trace._promiseCreated;\n        trace._promiseCreated = null;\n        return ret;\n    }\n    return null;\n};\n\nfunction createContext() {\n    if (longStackTraces) return new Context();\n}\n\nfunction peekContext() {\n    var lastIndex = contextStack.length - 1;\n    if (lastIndex >= 0) {\n        return contextStack[lastIndex];\n    }\n    return undefined;\n}\nContext.CapturedTrace = null;\nContext.create = createContext;\nContext.deactivateLongStackTraces = function() {};\nContext.activateLongStackTraces = function() {\n    var Promise_pushContext = Promise.prototype._pushContext;\n    var Promise_popContext = Promise.prototype._popContext;\n    var Promise_PeekContext = Promise._peekContext;\n    var Promise_peekContext = Promise.prototype._peekContext;\n    var Promise_promiseCreated = Promise.prototype._promiseCreated;\n    Context.deactivateLongStackTraces = function() {\n        Promise.prototype._pushContext = Promise_pushContext;\n        Promise.prototype._popContext = Promise_popContext;\n        Promise._peekContext = Promise_PeekContext;\n        Promise.prototype._peekContext = Promise_peekContext;\n        Promise.prototype._promiseCreated = Promise_promiseCreated;\n        longStackTraces = false;\n    };\n    longStackTraces = true;\n    Promise.prototype._pushContext = Context.prototype._pushContext;\n    Promise.prototype._popContext = Context.prototype._popContext;\n    Promise._peekContext = Promise.prototype._peekContext = peekContext;\n    Promise.prototype._promiseCreated = function() {\n        var ctx = this._peekContext();\n        if (ctx && ctx._promiseCreated == null) ctx._promiseCreated = this;\n    };\n};\nreturn Context;\n};\n\n},{}],9:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, Context) {\nvar getDomain = Promise._getDomain;\nvar async = Promise._async;\nvar Warning = _dereq_(\"./errors\").Warning;\nvar util = _dereq_(\"./util\");\nvar canAttachTrace = util.canAttachTrace;\nvar unhandledRejectionHandled;\nvar possiblyUnhandledRejection;\nvar bluebirdFramePattern =\n    /[\\\\\\/]bluebird[\\\\\\/]js[\\\\\\/](release|debug|instrumented)/;\nvar nodeFramePattern = /\\((?:timers\\.js):\\d+:\\d+\\)/;\nvar parseLinePattern = /[\\/<\\(](.+?):(\\d+):(\\d+)\\)?\\s*$/;\nvar stackFramePattern = null;\nvar formatStack = null;\nvar indentStackFrames = false;\nvar printWarning;\nvar debugging = !!(util.env(\"BLUEBIRD_DEBUG\") != 0 &&\n                        (true ||\n                         util.env(\"BLUEBIRD_DEBUG\") ||\n                         util.env(\"NODE_ENV\") === \"development\"));\n\nvar warnings = !!(util.env(\"BLUEBIRD_WARNINGS\") != 0 &&\n    (debugging || util.env(\"BLUEBIRD_WARNINGS\")));\n\nvar longStackTraces = !!(util.env(\"BLUEBIRD_LONG_STACK_TRACES\") != 0 &&\n    (debugging || util.env(\"BLUEBIRD_LONG_STACK_TRACES\")));\n\nvar wForgottenReturn = util.env(\"BLUEBIRD_W_FORGOTTEN_RETURN\") != 0 &&\n    (warnings || !!util.env(\"BLUEBIRD_W_FORGOTTEN_RETURN\"));\n\nPromise.prototype.suppressUnhandledRejections = function() {\n    var target = this._target();\n    target._bitField = ((target._bitField & (~1048576)) |\n                      524288);\n};\n\nPromise.prototype._ensurePossibleRejectionHandled = function () {\n    if ((this._bitField & 524288) !== 0) return;\n    this._setRejectionIsUnhandled();\n    async.invokeLater(this._notifyUnhandledRejection, this, undefined);\n};\n\nPromise.prototype._notifyUnhandledRejectionIsHandled = function () {\n    fireRejectionEvent(\"rejectionHandled\",\n                                  unhandledRejectionHandled, undefined, this);\n};\n\nPromise.prototype._setReturnedNonUndefined = function() {\n    this._bitField = this._bitField | 268435456;\n};\n\nPromise.prototype._returnedNonUndefined = function() {\n    return (this._bitField & 268435456) !== 0;\n};\n\nPromise.prototype._notifyUnhandledRejection = function () {\n    if (this._isRejectionUnhandled()) {\n        var reason = this._settledValue();\n        this._setUnhandledRejectionIsNotified();\n        fireRejectionEvent(\"unhandledRejection\",\n                                      possiblyUnhandledRejection, reason, this);\n    }\n};\n\nPromise.prototype._setUnhandledRejectionIsNotified = function () {\n    this._bitField = this._bitField | 262144;\n};\n\nPromise.prototype._unsetUnhandledRejectionIsNotified = function () {\n    this._bitField = this._bitField & (~262144);\n};\n\nPromise.prototype._isUnhandledRejectionNotified = function () {\n    return (this._bitField & 262144) > 0;\n};\n\nPromise.prototype._setRejectionIsUnhandled = function () {\n    this._bitField = this._bitField | 1048576;\n};\n\nPromise.prototype._unsetRejectionIsUnhandled = function () {\n    this._bitField = this._bitField & (~1048576);\n    if (this._isUnhandledRejectionNotified()) {\n        this._unsetUnhandledRejectionIsNotified();\n        this._notifyUnhandledRejectionIsHandled();\n    }\n};\n\nPromise.prototype._isRejectionUnhandled = function () {\n    return (this._bitField & 1048576) > 0;\n};\n\nPromise.prototype._warn = function(message, shouldUseOwnTrace, promise) {\n    return warn(message, shouldUseOwnTrace, promise || this);\n};\n\nPromise.onPossiblyUnhandledRejection = function (fn) {\n    var domain = getDomain();\n    possiblyUnhandledRejection =\n        typeof fn === \"function\" ? (domain === null ?\n                                            fn : util.domainBind(domain, fn))\n                                 : undefined;\n};\n\nPromise.onUnhandledRejectionHandled = function (fn) {\n    var domain = getDomain();\n    unhandledRejectionHandled =\n        typeof fn === \"function\" ? (domain === null ?\n                                            fn : util.domainBind(domain, fn))\n                                 : undefined;\n};\n\nvar disableLongStackTraces = function() {};\nPromise.longStackTraces = function () {\n    if (async.haveItemsQueued() && !config.longStackTraces) {\n        throw new Error(\"cannot enable long stack traces after promises have been created\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    if (!config.longStackTraces && longStackTracesIsSupported()) {\n        var Promise_captureStackTrace = Promise.prototype._captureStackTrace;\n        var Promise_attachExtraTrace = Promise.prototype._attachExtraTrace;\n        config.longStackTraces = true;\n        disableLongStackTraces = function() {\n            if (async.haveItemsQueued() && !config.longStackTraces) {\n                throw new Error(\"cannot enable long stack traces after promises have been created\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n            }\n            Promise.prototype._captureStackTrace = Promise_captureStackTrace;\n            Promise.prototype._attachExtraTrace = Promise_attachExtraTrace;\n            Context.deactivateLongStackTraces();\n            async.enableTrampoline();\n            config.longStackTraces = false;\n        };\n        Promise.prototype._captureStackTrace = longStackTracesCaptureStackTrace;\n        Promise.prototype._attachExtraTrace = longStackTracesAttachExtraTrace;\n        Context.activateLongStackTraces();\n        async.disableTrampolineIfNecessary();\n    }\n};\n\nPromise.hasLongStackTraces = function () {\n    return config.longStackTraces && longStackTracesIsSupported();\n};\n\nvar fireDomEvent = (function() {\n    try {\n        if (typeof CustomEvent === \"function\") {\n            var event = new CustomEvent(\"CustomEvent\");\n            util.global.dispatchEvent(event);\n            return function(name, event) {\n                var domEvent = new CustomEvent(name.toLowerCase(), {\n                    detail: event,\n                    cancelable: true\n                });\n                return !util.global.dispatchEvent(domEvent);\n            };\n        } else if (typeof Event === \"function\") {\n            var event = new Event(\"CustomEvent\");\n            util.global.dispatchEvent(event);\n            return function(name, event) {\n                var domEvent = new Event(name.toLowerCase(), {\n                    cancelable: true\n                });\n                domEvent.detail = event;\n                return !util.global.dispatchEvent(domEvent);\n            };\n        } else {\n            var event = document.createEvent(\"CustomEvent\");\n            event.initCustomEvent(\"testingtheevent\", false, true, {});\n            util.global.dispatchEvent(event);\n            return function(name, event) {\n                var domEvent = document.createEvent(\"CustomEvent\");\n                domEvent.initCustomEvent(name.toLowerCase(), false, true,\n                    event);\n                return !util.global.dispatchEvent(domEvent);\n            };\n        }\n    } catch (e) {}\n    return function() {\n        return false;\n    };\n})();\n\nvar fireGlobalEvent = (function() {\n    if (util.isNode) {\n        return function() {\n            return process.emit.apply(process, arguments);\n        };\n    } else {\n        if (!util.global) {\n            return function() {\n                return false;\n            };\n        }\n        return function(name) {\n            var methodName = \"on\" + name.toLowerCase();\n            var method = util.global[methodName];\n            if (!method) return false;\n            method.apply(util.global, [].slice.call(arguments, 1));\n            return true;\n        };\n    }\n})();\n\nfunction generatePromiseLifecycleEventObject(name, promise) {\n    return {promise: promise};\n}\n\nvar eventToObjectGenerator = {\n    promiseCreated: generatePromiseLifecycleEventObject,\n    promiseFulfilled: generatePromiseLifecycleEventObject,\n    promiseRejected: generatePromiseLifecycleEventObject,\n    promiseResolved: generatePromiseLifecycleEventObject,\n    promiseCancelled: generatePromiseLifecycleEventObject,\n    promiseChained: function(name, promise, child) {\n        return {promise: promise, child: child};\n    },\n    warning: function(name, warning) {\n        return {warning: warning};\n    },\n    unhandledRejection: function (name, reason, promise) {\n        return {reason: reason, promise: promise};\n    },\n    rejectionHandled: generatePromiseLifecycleEventObject\n};\n\nvar activeFireEvent = function (name) {\n    var globalEventFired = false;\n    try {\n        globalEventFired = fireGlobalEvent.apply(null, arguments);\n    } catch (e) {\n        async.throwLater(e);\n        globalEventFired = true;\n    }\n\n    var domEventFired = false;\n    try {\n        domEventFired = fireDomEvent(name,\n                    eventToObjectGenerator[name].apply(null, arguments));\n    } catch (e) {\n        async.throwLater(e);\n        domEventFired = true;\n    }\n\n    return domEventFired || globalEventFired;\n};\n\nPromise.config = function(opts) {\n    opts = Object(opts);\n    if (\"longStackTraces\" in opts) {\n        if (opts.longStackTraces) {\n            Promise.longStackTraces();\n        } else if (!opts.longStackTraces && Promise.hasLongStackTraces()) {\n            disableLongStackTraces();\n        }\n    }\n    if (\"warnings\" in opts) {\n        var warningsOption = opts.warnings;\n        config.warnings = !!warningsOption;\n        wForgottenReturn = config.warnings;\n\n        if (util.isObject(warningsOption)) {\n            if (\"wForgottenReturn\" in warningsOption) {\n                wForgottenReturn = !!warningsOption.wForgottenReturn;\n            }\n        }\n    }\n    if (\"cancellation\" in opts && opts.cancellation && !config.cancellation) {\n        if (async.haveItemsQueued()) {\n            throw new Error(\n                \"cannot enable cancellation after promises are in use\");\n        }\n        Promise.prototype._clearCancellationData =\n            cancellationClearCancellationData;\n        Promise.prototype._propagateFrom = cancellationPropagateFrom;\n        Promise.prototype._onCancel = cancellationOnCancel;\n        Promise.prototype._setOnCancel = cancellationSetOnCancel;\n        Promise.prototype._attachCancellationCallback =\n            cancellationAttachCancellationCallback;\n        Promise.prototype._execute = cancellationExecute;\n        propagateFromFunction = cancellationPropagateFrom;\n        config.cancellation = true;\n    }\n    if (\"monitoring\" in opts) {\n        if (opts.monitoring && !config.monitoring) {\n            config.monitoring = true;\n            Promise.prototype._fireEvent = activeFireEvent;\n        } else if (!opts.monitoring && config.monitoring) {\n            config.monitoring = false;\n            Promise.prototype._fireEvent = defaultFireEvent;\n        }\n    }\n    return Promise;\n};\n\nfunction defaultFireEvent() { return false; }\n\nPromise.prototype._fireEvent = defaultFireEvent;\nPromise.prototype._execute = function(executor, resolve, reject) {\n    try {\n        executor(resolve, reject);\n    } catch (e) {\n        return e;\n    }\n};\nPromise.prototype._onCancel = function () {};\nPromise.prototype._setOnCancel = function (handler) { ; };\nPromise.prototype._attachCancellationCallback = function(onCancel) {\n    ;\n};\nPromise.prototype._captureStackTrace = function () {};\nPromise.prototype._attachExtraTrace = function () {};\nPromise.prototype._clearCancellationData = function() {};\nPromise.prototype._propagateFrom = function (parent, flags) {\n    ;\n    ;\n};\n\nfunction cancellationExecute(executor, resolve, reject) {\n    var promise = this;\n    try {\n        executor(resolve, reject, function(onCancel) {\n            if (typeof onCancel !== \"function\") {\n                throw new TypeError(\"onCancel must be a function, got: \" +\n                                    util.toString(onCancel));\n            }\n            promise._attachCancellationCallback(onCancel);\n        });\n    } catch (e) {\n        return e;\n    }\n}\n\nfunction cancellationAttachCancellationCallback(onCancel) {\n    if (!this._isCancellable()) return this;\n\n    var previousOnCancel = this._onCancel();\n    if (previousOnCancel !== undefined) {\n        if (util.isArray(previousOnCancel)) {\n            previousOnCancel.push(onCancel);\n        } else {\n            this._setOnCancel([previousOnCancel, onCancel]);\n        }\n    } else {\n        this._setOnCancel(onCancel);\n    }\n}\n\nfunction cancellationOnCancel() {\n    return this._onCancelField;\n}\n\nfunction cancellationSetOnCancel(onCancel) {\n    this._onCancelField = onCancel;\n}\n\nfunction cancellationClearCancellationData() {\n    this._cancellationParent = undefined;\n    this._onCancelField = undefined;\n}\n\nfunction cancellationPropagateFrom(parent, flags) {\n    if ((flags & 1) !== 0) {\n        this._cancellationParent = parent;\n        var branchesRemainingToCancel = parent._branchesRemainingToCancel;\n        if (branchesRemainingToCancel === undefined) {\n            branchesRemainingToCancel = 0;\n        }\n        parent._branchesRemainingToCancel = branchesRemainingToCancel + 1;\n    }\n    if ((flags & 2) !== 0 && parent._isBound()) {\n        this._setBoundTo(parent._boundTo);\n    }\n}\n\nfunction bindingPropagateFrom(parent, flags) {\n    if ((flags & 2) !== 0 && parent._isBound()) {\n        this._setBoundTo(parent._boundTo);\n    }\n}\nvar propagateFromFunction = bindingPropagateFrom;\n\nfunction boundValueFunction() {\n    var ret = this._boundTo;\n    if (ret !== undefined) {\n        if (ret instanceof Promise) {\n            if (ret.isFulfilled()) {\n                return ret.value();\n            } else {\n                return undefined;\n            }\n        }\n    }\n    return ret;\n}\n\nfunction longStackTracesCaptureStackTrace() {\n    this._trace = new CapturedTrace(this._peekContext());\n}\n\nfunction longStackTracesAttachExtraTrace(error, ignoreSelf) {\n    if (canAttachTrace(error)) {\n        var trace = this._trace;\n        if (trace !== undefined) {\n            if (ignoreSelf) trace = trace._parent;\n        }\n        if (trace !== undefined) {\n            trace.attachExtraTrace(error);\n        } else if (!error.__stackCleaned__) {\n            var parsed = parseStackAndMessage(error);\n            util.notEnumerableProp(error, \"stack\",\n                parsed.message + \"\\n\" + parsed.stack.join(\"\\n\"));\n            util.notEnumerableProp(error, \"__stackCleaned__\", true);\n        }\n    }\n}\n\nfunction checkForgottenReturns(returnValue, promiseCreated, name, promise,\n                               parent) {\n    if (returnValue === undefined && promiseCreated !== null &&\n        wForgottenReturn) {\n        if (parent !== undefined && parent._returnedNonUndefined()) return;\n        if ((promise._bitField & 65535) === 0) return;\n\n        if (name) name = name + \" \";\n        var handlerLine = \"\";\n        var creatorLine = \"\";\n        if (promiseCreated._trace) {\n            var traceLines = promiseCreated._trace.stack.split(\"\\n\");\n            var stack = cleanStack(traceLines);\n            for (var i = stack.length - 1; i >= 0; --i) {\n                var line = stack[i];\n                if (!nodeFramePattern.test(line)) {\n                    var lineMatches = line.match(parseLinePattern);\n                    if (lineMatches) {\n                        handlerLine  = \"at \" + lineMatches[1] +\n                            \":\" + lineMatches[2] + \":\" + lineMatches[3] + \" \";\n                    }\n                    break;\n                }\n            }\n\n            if (stack.length > 0) {\n                var firstUserLine = stack[0];\n                for (var i = 0; i < traceLines.length; ++i) {\n\n                    if (traceLines[i] === firstUserLine) {\n                        if (i > 0) {\n                            creatorLine = \"\\n\" + traceLines[i - 1];\n                        }\n                        break;\n                    }\n                }\n\n            }\n        }\n        var msg = \"a promise was created in a \" + name +\n            \"handler \" + handlerLine + \"but was not returned from it, \" +\n            \"see http://goo.gl/rRqMUw\" +\n            creatorLine;\n        promise._warn(msg, true, promiseCreated);\n    }\n}\n\nfunction deprecated(name, replacement) {\n    var message = name +\n        \" is deprecated and will be removed in a future version.\";\n    if (replacement) message += \" Use \" + replacement + \" instead.\";\n    return warn(message);\n}\n\nfunction warn(message, shouldUseOwnTrace, promise) {\n    if (!config.warnings) return;\n    var warning = new Warning(message);\n    var ctx;\n    if (shouldUseOwnTrace) {\n        promise._attachExtraTrace(warning);\n    } else if (config.longStackTraces && (ctx = Promise._peekContext())) {\n        ctx.attachExtraTrace(warning);\n    } else {\n        var parsed = parseStackAndMessage(warning);\n        warning.stack = parsed.message + \"\\n\" + parsed.stack.join(\"\\n\");\n    }\n\n    if (!activeFireEvent(\"warning\", warning)) {\n        formatAndLogError(warning, \"\", true);\n    }\n}\n\nfunction reconstructStack(message, stacks) {\n    for (var i = 0; i < stacks.length - 1; ++i) {\n        stacks[i].push(\"From previous event:\");\n        stacks[i] = stacks[i].join(\"\\n\");\n    }\n    if (i < stacks.length) {\n        stacks[i] = stacks[i].join(\"\\n\");\n    }\n    return message + \"\\n\" + stacks.join(\"\\n\");\n}\n\nfunction removeDuplicateOrEmptyJumps(stacks) {\n    for (var i = 0; i < stacks.length; ++i) {\n        if (stacks[i].length === 0 ||\n            ((i + 1 < stacks.length) && stacks[i][0] === stacks[i+1][0])) {\n            stacks.splice(i, 1);\n            i--;\n        }\n    }\n}\n\nfunction removeCommonRoots(stacks) {\n    var current = stacks[0];\n    for (var i = 1; i < stacks.length; ++i) {\n        var prev = stacks[i];\n        var currentLastIndex = current.length - 1;\n        var currentLastLine = current[currentLastIndex];\n        var commonRootMeetPoint = -1;\n\n        for (var j = prev.length - 1; j >= 0; --j) {\n            if (prev[j] === currentLastLine) {\n                commonRootMeetPoint = j;\n                break;\n            }\n        }\n\n        for (var j = commonRootMeetPoint; j >= 0; --j) {\n            var line = prev[j];\n            if (current[currentLastIndex] === line) {\n                current.pop();\n                currentLastIndex--;\n            } else {\n                break;\n            }\n        }\n        current = prev;\n    }\n}\n\nfunction cleanStack(stack) {\n    var ret = [];\n    for (var i = 0; i < stack.length; ++i) {\n        var line = stack[i];\n        var isTraceLine = \"    (No stack trace)\" === line ||\n            stackFramePattern.test(line);\n        var isInternalFrame = isTraceLine && shouldIgnore(line);\n        if (isTraceLine && !isInternalFrame) {\n            if (indentStackFrames && line.charAt(0) !== \" \") {\n                line = \"    \" + line;\n            }\n            ret.push(line);\n        }\n    }\n    return ret;\n}\n\nfunction stackFramesAsArray(error) {\n    var stack = error.stack.replace(/\\s+$/g, \"\").split(\"\\n\");\n    for (var i = 0; i < stack.length; ++i) {\n        var line = stack[i];\n        if (\"    (No stack trace)\" === line || stackFramePattern.test(line)) {\n            break;\n        }\n    }\n    if (i > 0 && error.name != \"SyntaxError\") {\n        stack = stack.slice(i);\n    }\n    return stack;\n}\n\nfunction parseStackAndMessage(error) {\n    var stack = error.stack;\n    var message = error.toString();\n    stack = typeof stack === \"string\" && stack.length > 0\n                ? stackFramesAsArray(error) : [\"    (No stack trace)\"];\n    return {\n        message: message,\n        stack: error.name == \"SyntaxError\" ? stack : cleanStack(stack)\n    };\n}\n\nfunction formatAndLogError(error, title, isSoft) {\n    if (typeof console !== \"undefined\") {\n        var message;\n        if (util.isObject(error)) {\n            var stack = error.stack;\n            message = title + formatStack(stack, error);\n        } else {\n            message = title + String(error);\n        }\n        if (typeof printWarning === \"function\") {\n            printWarning(message, isSoft);\n        } else if (typeof console.log === \"function\" ||\n            typeof console.log === \"object\") {\n            console.log(message);\n        }\n    }\n}\n\nfunction fireRejectionEvent(name, localHandler, reason, promise) {\n    var localEventFired = false;\n    try {\n        if (typeof localHandler === \"function\") {\n            localEventFired = true;\n            if (name === \"rejectionHandled\") {\n                localHandler(promise);\n            } else {\n                localHandler(reason, promise);\n            }\n        }\n    } catch (e) {\n        async.throwLater(e);\n    }\n\n    if (name === \"unhandledRejection\") {\n        if (!activeFireEvent(name, reason, promise) && !localEventFired) {\n            formatAndLogError(reason, \"Unhandled rejection \");\n        }\n    } else {\n        activeFireEvent(name, promise);\n    }\n}\n\nfunction formatNonError(obj) {\n    var str;\n    if (typeof obj === \"function\") {\n        str = \"[function \" +\n            (obj.name || \"anonymous\") +\n            \"]\";\n    } else {\n        str = obj && typeof obj.toString === \"function\"\n            ? obj.toString() : util.toString(obj);\n        var ruselessToString = /\\[object [a-zA-Z0-9$_]+\\]/;\n        if (ruselessToString.test(str)) {\n            try {\n                var newStr = JSON.stringify(obj);\n                str = newStr;\n            }\n            catch(e) {\n\n            }\n        }\n        if (str.length === 0) {\n            str = \"(empty array)\";\n        }\n    }\n    return (\"(<\" + snip(str) + \">, no stack trace)\");\n}\n\nfunction snip(str) {\n    var maxChars = 41;\n    if (str.length < maxChars) {\n        return str;\n    }\n    return str.substr(0, maxChars - 3) + \"...\";\n}\n\nfunction longStackTracesIsSupported() {\n    return typeof captureStackTrace === \"function\";\n}\n\nvar shouldIgnore = function() { return false; };\nvar parseLineInfoRegex = /[\\/<\\(]([^:\\/]+):(\\d+):(?:\\d+)\\)?\\s*$/;\nfunction parseLineInfo(line) {\n    var matches = line.match(parseLineInfoRegex);\n    if (matches) {\n        return {\n            fileName: matches[1],\n            line: parseInt(matches[2], 10)\n        };\n    }\n}\n\nfunction setBounds(firstLineError, lastLineError) {\n    if (!longStackTracesIsSupported()) return;\n    var firstStackLines = firstLineError.stack.split(\"\\n\");\n    var lastStackLines = lastLineError.stack.split(\"\\n\");\n    var firstIndex = -1;\n    var lastIndex = -1;\n    var firstFileName;\n    var lastFileName;\n    for (var i = 0; i < firstStackLines.length; ++i) {\n        var result = parseLineInfo(firstStackLines[i]);\n        if (result) {\n            firstFileName = result.fileName;\n            firstIndex = result.line;\n            break;\n        }\n    }\n    for (var i = 0; i < lastStackLines.length; ++i) {\n        var result = parseLineInfo(lastStackLines[i]);\n        if (result) {\n            lastFileName = result.fileName;\n            lastIndex = result.line;\n            break;\n        }\n    }\n    if (firstIndex < 0 || lastIndex < 0 || !firstFileName || !lastFileName ||\n        firstFileName !== lastFileName || firstIndex >= lastIndex) {\n        return;\n    }\n\n    shouldIgnore = function(line) {\n        if (bluebirdFramePattern.test(line)) return true;\n        var info = parseLineInfo(line);\n        if (info) {\n            if (info.fileName === firstFileName &&\n                (firstIndex <= info.line && info.line <= lastIndex)) {\n                return true;\n            }\n        }\n        return false;\n    };\n}\n\nfunction CapturedTrace(parent) {\n    this._parent = parent;\n    this._promisesCreated = 0;\n    var length = this._length = 1 + (parent === undefined ? 0 : parent._length);\n    captureStackTrace(this, CapturedTrace);\n    if (length > 32) this.uncycle();\n}\nutil.inherits(CapturedTrace, Error);\nContext.CapturedTrace = CapturedTrace;\n\nCapturedTrace.prototype.uncycle = function() {\n    var length = this._length;\n    if (length < 2) return;\n    var nodes = [];\n    var stackToIndex = {};\n\n    for (var i = 0, node = this; node !== undefined; ++i) {\n        nodes.push(node);\n        node = node._parent;\n    }\n    length = this._length = i;\n    for (var i = length - 1; i >= 0; --i) {\n        var stack = nodes[i].stack;\n        if (stackToIndex[stack] === undefined) {\n            stackToIndex[stack] = i;\n        }\n    }\n    for (var i = 0; i < length; ++i) {\n        var currentStack = nodes[i].stack;\n        var index = stackToIndex[currentStack];\n        if (index !== undefined && index !== i) {\n            if (index > 0) {\n                nodes[index - 1]._parent = undefined;\n                nodes[index - 1]._length = 1;\n            }\n            nodes[i]._parent = undefined;\n            nodes[i]._length = 1;\n            var cycleEdgeNode = i > 0 ? nodes[i - 1] : this;\n\n            if (index < length - 1) {\n                cycleEdgeNode._parent = nodes[index + 1];\n                cycleEdgeNode._parent.uncycle();\n                cycleEdgeNode._length =\n                    cycleEdgeNode._parent._length + 1;\n            } else {\n                cycleEdgeNode._parent = undefined;\n                cycleEdgeNode._length = 1;\n            }\n            var currentChildLength = cycleEdgeNode._length + 1;\n            for (var j = i - 2; j >= 0; --j) {\n                nodes[j]._length = currentChildLength;\n                currentChildLength++;\n            }\n            return;\n        }\n    }\n};\n\nCapturedTrace.prototype.attachExtraTrace = function(error) {\n    if (error.__stackCleaned__) return;\n    this.uncycle();\n    var parsed = parseStackAndMessage(error);\n    var message = parsed.message;\n    var stacks = [parsed.stack];\n\n    var trace = this;\n    while (trace !== undefined) {\n        stacks.push(cleanStack(trace.stack.split(\"\\n\")));\n        trace = trace._parent;\n    }\n    removeCommonRoots(stacks);\n    removeDuplicateOrEmptyJumps(stacks);\n    util.notEnumerableProp(error, \"stack\", reconstructStack(message, stacks));\n    util.notEnumerableProp(error, \"__stackCleaned__\", true);\n};\n\nvar captureStackTrace = (function stackDetection() {\n    var v8stackFramePattern = /^\\s*at\\s*/;\n    var v8stackFormatter = function(stack, error) {\n        if (typeof stack === \"string\") return stack;\n\n        if (error.name !== undefined &&\n            error.message !== undefined) {\n            return error.toString();\n        }\n        return formatNonError(error);\n    };\n\n    if (typeof Error.stackTraceLimit === \"number\" &&\n        typeof Error.captureStackTrace === \"function\") {\n        Error.stackTraceLimit += 6;\n        stackFramePattern = v8stackFramePattern;\n        formatStack = v8stackFormatter;\n        var captureStackTrace = Error.captureStackTrace;\n\n        shouldIgnore = function(line) {\n            return bluebirdFramePattern.test(line);\n        };\n        return function(receiver, ignoreUntil) {\n            Error.stackTraceLimit += 6;\n            captureStackTrace(receiver, ignoreUntil);\n            Error.stackTraceLimit -= 6;\n        };\n    }\n    var err = new Error();\n\n    if (typeof err.stack === \"string\" &&\n        err.stack.split(\"\\n\")[0].indexOf(\"stackDetection@\") >= 0) {\n        stackFramePattern = /@/;\n        formatStack = v8stackFormatter;\n        indentStackFrames = true;\n        return function captureStackTrace(o) {\n            o.stack = new Error().stack;\n        };\n    }\n\n    var hasStackAfterThrow;\n    try { throw new Error(); }\n    catch(e) {\n        hasStackAfterThrow = (\"stack\" in e);\n    }\n    if (!(\"stack\" in err) && hasStackAfterThrow &&\n        typeof Error.stackTraceLimit === \"number\") {\n        stackFramePattern = v8stackFramePattern;\n        formatStack = v8stackFormatter;\n        return function captureStackTrace(o) {\n            Error.stackTraceLimit += 6;\n            try { throw new Error(); }\n            catch(e) { o.stack = e.stack; }\n            Error.stackTraceLimit -= 6;\n        };\n    }\n\n    formatStack = function(stack, error) {\n        if (typeof stack === \"string\") return stack;\n\n        if ((typeof error === \"object\" ||\n            typeof error === \"function\") &&\n            error.name !== undefined &&\n            error.message !== undefined) {\n            return error.toString();\n        }\n        return formatNonError(error);\n    };\n\n    return null;\n\n})([]);\n\nif (typeof console !== \"undefined\" && typeof console.warn !== \"undefined\") {\n    printWarning = function (message) {\n        console.warn(message);\n    };\n    if (util.isNode && process.stderr.isTTY) {\n        printWarning = function(message, isSoft) {\n            var color = isSoft ? \"\\u001b[33m\" : \"\\u001b[31m\";\n            console.warn(color + message + \"\\u001b[0m\\n\");\n        };\n    } else if (!util.isNode && typeof (new Error().stack) === \"string\") {\n        printWarning = function(message, isSoft) {\n            console.warn(\"%c\" + message,\n                        isSoft ? \"color: darkorange\" : \"color: red\");\n        };\n    }\n}\n\nvar config = {\n    warnings: warnings,\n    longStackTraces: false,\n    cancellation: false,\n    monitoring: false\n};\n\nif (longStackTraces) Promise.longStackTraces();\n\nreturn {\n    longStackTraces: function() {\n        return config.longStackTraces;\n    },\n    warnings: function() {\n        return config.warnings;\n    },\n    cancellation: function() {\n        return config.cancellation;\n    },\n    monitoring: function() {\n        return config.monitoring;\n    },\n    propagateFromFunction: function() {\n        return propagateFromFunction;\n    },\n    boundValueFunction: function() {\n        return boundValueFunction;\n    },\n    checkForgottenReturns: checkForgottenReturns,\n    setBounds: setBounds,\n    warn: warn,\n    deprecated: deprecated,\n    CapturedTrace: CapturedTrace,\n    fireDomEvent: fireDomEvent,\n    fireGlobalEvent: fireGlobalEvent\n};\n};\n\n},{\"./errors\":12,\"./util\":36}],10:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise) {\nfunction returner() {\n    return this.value;\n}\nfunction thrower() {\n    throw this.reason;\n}\n\nPromise.prototype[\"return\"] =\nPromise.prototype.thenReturn = function (value) {\n    if (value instanceof Promise) value.suppressUnhandledRejections();\n    return this._then(\n        returner, undefined, undefined, {value: value}, undefined);\n};\n\nPromise.prototype[\"throw\"] =\nPromise.prototype.thenThrow = function (reason) {\n    return this._then(\n        thrower, undefined, undefined, {reason: reason}, undefined);\n};\n\nPromise.prototype.catchThrow = function (reason) {\n    if (arguments.length <= 1) {\n        return this._then(\n            undefined, thrower, undefined, {reason: reason}, undefined);\n    } else {\n        var _reason = arguments[1];\n        var handler = function() {throw _reason;};\n        return this.caught(reason, handler);\n    }\n};\n\nPromise.prototype.catchReturn = function (value) {\n    if (arguments.length <= 1) {\n        if (value instanceof Promise) value.suppressUnhandledRejections();\n        return this._then(\n            undefined, returner, undefined, {value: value}, undefined);\n    } else {\n        var _value = arguments[1];\n        if (_value instanceof Promise) _value.suppressUnhandledRejections();\n        var handler = function() {return _value;};\n        return this.caught(value, handler);\n    }\n};\n};\n\n},{}],11:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL) {\nvar PromiseReduce = Promise.reduce;\nvar PromiseAll = Promise.all;\n\nfunction promiseAllThis() {\n    return PromiseAll(this);\n}\n\nfunction PromiseMapSeries(promises, fn) {\n    return PromiseReduce(promises, fn, INTERNAL, INTERNAL);\n}\n\nPromise.prototype.each = function (fn) {\n    return PromiseReduce(this, fn, INTERNAL, 0)\n              ._then(promiseAllThis, undefined, undefined, this, undefined);\n};\n\nPromise.prototype.mapSeries = function (fn) {\n    return PromiseReduce(this, fn, INTERNAL, INTERNAL);\n};\n\nPromise.each = function (promises, fn) {\n    return PromiseReduce(promises, fn, INTERNAL, 0)\n              ._then(promiseAllThis, undefined, undefined, promises, undefined);\n};\n\nPromise.mapSeries = PromiseMapSeries;\n};\n\n\n},{}],12:[function(_dereq_,module,exports){\n\"use strict\";\nvar es5 = _dereq_(\"./es5\");\nvar Objectfreeze = es5.freeze;\nvar util = _dereq_(\"./util\");\nvar inherits = util.inherits;\nvar notEnumerableProp = util.notEnumerableProp;\n\nfunction subError(nameProperty, defaultMessage) {\n    function SubError(message) {\n        if (!(this instanceof SubError)) return new SubError(message);\n        notEnumerableProp(this, \"message\",\n            typeof message === \"string\" ? message : defaultMessage);\n        notEnumerableProp(this, \"name\", nameProperty);\n        if (Error.captureStackTrace) {\n            Error.captureStackTrace(this, this.constructor);\n        } else {\n            Error.call(this);\n        }\n    }\n    inherits(SubError, Error);\n    return SubError;\n}\n\nvar _TypeError, _RangeError;\nvar Warning = subError(\"Warning\", \"warning\");\nvar CancellationError = subError(\"CancellationError\", \"cancellation error\");\nvar TimeoutError = subError(\"TimeoutError\", \"timeout error\");\nvar AggregateError = subError(\"AggregateError\", \"aggregate error\");\ntry {\n    _TypeError = TypeError;\n    _RangeError = RangeError;\n} catch(e) {\n    _TypeError = subError(\"TypeError\", \"type error\");\n    _RangeError = subError(\"RangeError\", \"range error\");\n}\n\nvar methods = (\"join pop push shift unshift slice filter forEach some \" +\n    \"every map indexOf lastIndexOf reduce reduceRight sort reverse\").split(\" \");\n\nfor (var i = 0; i < methods.length; ++i) {\n    if (typeof Array.prototype[methods[i]] === \"function\") {\n        AggregateError.prototype[methods[i]] = Array.prototype[methods[i]];\n    }\n}\n\nes5.defineProperty(AggregateError.prototype, \"length\", {\n    value: 0,\n    configurable: false,\n    writable: true,\n    enumerable: true\n});\nAggregateError.prototype[\"isOperational\"] = true;\nvar level = 0;\nAggregateError.prototype.toString = function() {\n    var indent = Array(level * 4 + 1).join(\" \");\n    var ret = \"\\n\" + indent + \"AggregateError of:\" + \"\\n\";\n    level++;\n    indent = Array(level * 4 + 1).join(\" \");\n    for (var i = 0; i < this.length; ++i) {\n        var str = this[i] === this ? \"[Circular AggregateError]\" : this[i] + \"\";\n        var lines = str.split(\"\\n\");\n        for (var j = 0; j < lines.length; ++j) {\n            lines[j] = indent + lines[j];\n        }\n        str = lines.join(\"\\n\");\n        ret += str + \"\\n\";\n    }\n    level--;\n    return ret;\n};\n\nfunction OperationalError(message) {\n    if (!(this instanceof OperationalError))\n        return new OperationalError(message);\n    notEnumerableProp(this, \"name\", \"OperationalError\");\n    notEnumerableProp(this, \"message\", message);\n    this.cause = message;\n    this[\"isOperational\"] = true;\n\n    if (message instanceof Error) {\n        notEnumerableProp(this, \"message\", message.message);\n        notEnumerableProp(this, \"stack\", message.stack);\n    } else if (Error.captureStackTrace) {\n        Error.captureStackTrace(this, this.constructor);\n    }\n\n}\ninherits(OperationalError, Error);\n\nvar errorTypes = Error[\"__BluebirdErrorTypes__\"];\nif (!errorTypes) {\n    errorTypes = Objectfreeze({\n        CancellationError: CancellationError,\n        TimeoutError: TimeoutError,\n        OperationalError: OperationalError,\n        RejectionError: OperationalError,\n        AggregateError: AggregateError\n    });\n    es5.defineProperty(Error, \"__BluebirdErrorTypes__\", {\n        value: errorTypes,\n        writable: false,\n        enumerable: false,\n        configurable: false\n    });\n}\n\nmodule.exports = {\n    Error: Error,\n    TypeError: _TypeError,\n    RangeError: _RangeError,\n    CancellationError: errorTypes.CancellationError,\n    OperationalError: errorTypes.OperationalError,\n    TimeoutError: errorTypes.TimeoutError,\n    AggregateError: errorTypes.AggregateError,\n    Warning: Warning\n};\n\n},{\"./es5\":13,\"./util\":36}],13:[function(_dereq_,module,exports){\nvar isES5 = (function(){\n    \"use strict\";\n    return this === undefined;\n})();\n\nif (isES5) {\n    module.exports = {\n        freeze: Object.freeze,\n        defineProperty: Object.defineProperty,\n        getDescriptor: Object.getOwnPropertyDescriptor,\n        keys: Object.keys,\n        names: Object.getOwnPropertyNames,\n        getPrototypeOf: Object.getPrototypeOf,\n        isArray: Array.isArray,\n        isES5: isES5,\n        propertyIsWritable: function(obj, prop) {\n            var descriptor = Object.getOwnPropertyDescriptor(obj, prop);\n            return !!(!descriptor || descriptor.writable || descriptor.set);\n        }\n    };\n} else {\n    var has = {}.hasOwnProperty;\n    var str = {}.toString;\n    var proto = {}.constructor.prototype;\n\n    var ObjectKeys = function (o) {\n        var ret = [];\n        for (var key in o) {\n            if (has.call(o, key)) {\n                ret.push(key);\n            }\n        }\n        return ret;\n    };\n\n    var ObjectGetDescriptor = function(o, key) {\n        return {value: o[key]};\n    };\n\n    var ObjectDefineProperty = function (o, key, desc) {\n        o[key] = desc.value;\n        return o;\n    };\n\n    var ObjectFreeze = function (obj) {\n        return obj;\n    };\n\n    var ObjectGetPrototypeOf = function (obj) {\n        try {\n            return Object(obj).constructor.prototype;\n        }\n        catch (e) {\n            return proto;\n        }\n    };\n\n    var ArrayIsArray = function (obj) {\n        try {\n            return str.call(obj) === \"[object Array]\";\n        }\n        catch(e) {\n            return false;\n        }\n    };\n\n    module.exports = {\n        isArray: ArrayIsArray,\n        keys: ObjectKeys,\n        names: ObjectKeys,\n        defineProperty: ObjectDefineProperty,\n        getDescriptor: ObjectGetDescriptor,\n        freeze: ObjectFreeze,\n        getPrototypeOf: ObjectGetPrototypeOf,\n        isES5: isES5,\n        propertyIsWritable: function() {\n            return true;\n        }\n    };\n}\n\n},{}],14:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL) {\nvar PromiseMap = Promise.map;\n\nPromise.prototype.filter = function (fn, options) {\n    return PromiseMap(this, fn, options, INTERNAL);\n};\n\nPromise.filter = function (promises, fn, options) {\n    return PromiseMap(promises, fn, options, INTERNAL);\n};\n};\n\n},{}],15:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, tryConvertToPromise, NEXT_FILTER) {\nvar util = _dereq_(\"./util\");\nvar CancellationError = Promise.CancellationError;\nvar errorObj = util.errorObj;\nvar catchFilter = _dereq_(\"./catch_filter\")(NEXT_FILTER);\n\nfunction PassThroughHandlerContext(promise, type, handler) {\n    this.promise = promise;\n    this.type = type;\n    this.handler = handler;\n    this.called = false;\n    this.cancelPromise = null;\n}\n\nPassThroughHandlerContext.prototype.isFinallyHandler = function() {\n    return this.type === 0;\n};\n\nfunction FinallyHandlerCancelReaction(finallyHandler) {\n    this.finallyHandler = finallyHandler;\n}\n\nFinallyHandlerCancelReaction.prototype._resultCancelled = function() {\n    checkCancel(this.finallyHandler);\n};\n\nfunction checkCancel(ctx, reason) {\n    if (ctx.cancelPromise != null) {\n        if (arguments.length > 1) {\n            ctx.cancelPromise._reject(reason);\n        } else {\n            ctx.cancelPromise._cancel();\n        }\n        ctx.cancelPromise = null;\n        return true;\n    }\n    return false;\n}\n\nfunction succeed() {\n    return finallyHandler.call(this, this.promise._target()._settledValue());\n}\nfunction fail(reason) {\n    if (checkCancel(this, reason)) return;\n    errorObj.e = reason;\n    return errorObj;\n}\nfunction finallyHandler(reasonOrValue) {\n    var promise = this.promise;\n    var handler = this.handler;\n\n    if (!this.called) {\n        this.called = true;\n        var ret = this.isFinallyHandler()\n            ? handler.call(promise._boundValue())\n            : handler.call(promise._boundValue(), reasonOrValue);\n        if (ret === NEXT_FILTER) {\n            return ret;\n        } else if (ret !== undefined) {\n            promise._setReturnedNonUndefined();\n            var maybePromise = tryConvertToPromise(ret, promise);\n            if (maybePromise instanceof Promise) {\n                if (this.cancelPromise != null) {\n                    if (maybePromise._isCancelled()) {\n                        var reason =\n                            new CancellationError(\"late cancellation observer\");\n                        promise._attachExtraTrace(reason);\n                        errorObj.e = reason;\n                        return errorObj;\n                    } else if (maybePromise.isPending()) {\n                        maybePromise._attachCancellationCallback(\n                            new FinallyHandlerCancelReaction(this));\n                    }\n                }\n                return maybePromise._then(\n                    succeed, fail, undefined, this, undefined);\n            }\n        }\n    }\n\n    if (promise.isRejected()) {\n        checkCancel(this);\n        errorObj.e = reasonOrValue;\n        return errorObj;\n    } else {\n        checkCancel(this);\n        return reasonOrValue;\n    }\n}\n\nPromise.prototype._passThrough = function(handler, type, success, fail) {\n    if (typeof handler !== \"function\") return this.then();\n    return this._then(success,\n                      fail,\n                      undefined,\n                      new PassThroughHandlerContext(this, type, handler),\n                      undefined);\n};\n\nPromise.prototype.lastly =\nPromise.prototype[\"finally\"] = function (handler) {\n    return this._passThrough(handler,\n                             0,\n                             finallyHandler,\n                             finallyHandler);\n};\n\n\nPromise.prototype.tap = function (handler) {\n    return this._passThrough(handler, 1, finallyHandler);\n};\n\nPromise.prototype.tapCatch = function (handlerOrPredicate) {\n    var len = arguments.length;\n    if(len === 1) {\n        return this._passThrough(handlerOrPredicate,\n                                 1,\n                                 undefined,\n                                 finallyHandler);\n    } else {\n         var catchInstances = new Array(len - 1),\n            j = 0, i;\n        for (i = 0; i < len - 1; ++i) {\n            var item = arguments[i];\n            if (util.isObject(item)) {\n                catchInstances[j++] = item;\n            } else {\n                return Promise.reject(new TypeError(\n                    \"tapCatch statement predicate: \"\n                    + \"expecting an object but got \" + util.classString(item)\n                ));\n            }\n        }\n        catchInstances.length = j;\n        var handler = arguments[i];\n        return this._passThrough(catchFilter(catchInstances, handler, this),\n                                 1,\n                                 undefined,\n                                 finallyHandler);\n    }\n\n};\n\nreturn PassThroughHandlerContext;\n};\n\n},{\"./catch_filter\":7,\"./util\":36}],16:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise,\n                          apiRejection,\n                          INTERNAL,\n                          tryConvertToPromise,\n                          Proxyable,\n                          debug) {\nvar errors = _dereq_(\"./errors\");\nvar TypeError = errors.TypeError;\nvar util = _dereq_(\"./util\");\nvar errorObj = util.errorObj;\nvar tryCatch = util.tryCatch;\nvar yieldHandlers = [];\n\nfunction promiseFromYieldHandler(value, yieldHandlers, traceParent) {\n    for (var i = 0; i < yieldHandlers.length; ++i) {\n        traceParent._pushContext();\n        var result = tryCatch(yieldHandlers[i])(value);\n        traceParent._popContext();\n        if (result === errorObj) {\n            traceParent._pushContext();\n            var ret = Promise.reject(errorObj.e);\n            traceParent._popContext();\n            return ret;\n        }\n        var maybePromise = tryConvertToPromise(result, traceParent);\n        if (maybePromise instanceof Promise) return maybePromise;\n    }\n    return null;\n}\n\nfunction PromiseSpawn(generatorFunction, receiver, yieldHandler, stack) {\n    if (debug.cancellation()) {\n        var internal = new Promise(INTERNAL);\n        var _finallyPromise = this._finallyPromise = new Promise(INTERNAL);\n        this._promise = internal.lastly(function() {\n            return _finallyPromise;\n        });\n        internal._captureStackTrace();\n        internal._setOnCancel(this);\n    } else {\n        var promise = this._promise = new Promise(INTERNAL);\n        promise._captureStackTrace();\n    }\n    this._stack = stack;\n    this._generatorFunction = generatorFunction;\n    this._receiver = receiver;\n    this._generator = undefined;\n    this._yieldHandlers = typeof yieldHandler === \"function\"\n        ? [yieldHandler].concat(yieldHandlers)\n        : yieldHandlers;\n    this._yieldedPromise = null;\n    this._cancellationPhase = false;\n}\nutil.inherits(PromiseSpawn, Proxyable);\n\nPromiseSpawn.prototype._isResolved = function() {\n    return this._promise === null;\n};\n\nPromiseSpawn.prototype._cleanup = function() {\n    this._promise = this._generator = null;\n    if (debug.cancellation() && this._finallyPromise !== null) {\n        this._finallyPromise._fulfill();\n        this._finallyPromise = null;\n    }\n};\n\nPromiseSpawn.prototype._promiseCancelled = function() {\n    if (this._isResolved()) return;\n    var implementsReturn = typeof this._generator[\"return\"] !== \"undefined\";\n\n    var result;\n    if (!implementsReturn) {\n        var reason = new Promise.CancellationError(\n            \"generator .return() sentinel\");\n        Promise.coroutine.returnSentinel = reason;\n        this._promise._attachExtraTrace(reason);\n        this._promise._pushContext();\n        result = tryCatch(this._generator[\"throw\"]).call(this._generator,\n                                                         reason);\n        this._promise._popContext();\n    } else {\n        this._promise._pushContext();\n        result = tryCatch(this._generator[\"return\"]).call(this._generator,\n                                                          undefined);\n        this._promise._popContext();\n    }\n    this._cancellationPhase = true;\n    this._yieldedPromise = null;\n    this._continue(result);\n};\n\nPromiseSpawn.prototype._promiseFulfilled = function(value) {\n    this._yieldedPromise = null;\n    this._promise._pushContext();\n    var result = tryCatch(this._generator.next).call(this._generator, value);\n    this._promise._popContext();\n    this._continue(result);\n};\n\nPromiseSpawn.prototype._promiseRejected = function(reason) {\n    this._yieldedPromise = null;\n    this._promise._attachExtraTrace(reason);\n    this._promise._pushContext();\n    var result = tryCatch(this._generator[\"throw\"])\n        .call(this._generator, reason);\n    this._promise._popContext();\n    this._continue(result);\n};\n\nPromiseSpawn.prototype._resultCancelled = function() {\n    if (this._yieldedPromise instanceof Promise) {\n        var promise = this._yieldedPromise;\n        this._yieldedPromise = null;\n        promise.cancel();\n    }\n};\n\nPromiseSpawn.prototype.promise = function () {\n    return this._promise;\n};\n\nPromiseSpawn.prototype._run = function () {\n    this._generator = this._generatorFunction.call(this._receiver);\n    this._receiver =\n        this._generatorFunction = undefined;\n    this._promiseFulfilled(undefined);\n};\n\nPromiseSpawn.prototype._continue = function (result) {\n    var promise = this._promise;\n    if (result === errorObj) {\n        this._cleanup();\n        if (this._cancellationPhase) {\n            return promise.cancel();\n        } else {\n            return promise._rejectCallback(result.e, false);\n        }\n    }\n\n    var value = result.value;\n    if (result.done === true) {\n        this._cleanup();\n        if (this._cancellationPhase) {\n            return promise.cancel();\n        } else {\n            return promise._resolveCallback(value);\n        }\n    } else {\n        var maybePromise = tryConvertToPromise(value, this._promise);\n        if (!(maybePromise instanceof Promise)) {\n            maybePromise =\n                promiseFromYieldHandler(maybePromise,\n                                        this._yieldHandlers,\n                                        this._promise);\n            if (maybePromise === null) {\n                this._promiseRejected(\n                    new TypeError(\n                        \"A value %s was yielded that could not be treated as a promise\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\\u000a\".replace(\"%s\", String(value)) +\n                        \"From coroutine:\\u000a\" +\n                        this._stack.split(\"\\n\").slice(1, -7).join(\"\\n\")\n                    )\n                );\n                return;\n            }\n        }\n        maybePromise = maybePromise._target();\n        var bitField = maybePromise._bitField;\n        ;\n        if (((bitField & 50397184) === 0)) {\n            this._yieldedPromise = maybePromise;\n            maybePromise._proxy(this, null);\n        } else if (((bitField & 33554432) !== 0)) {\n            Promise._async.invoke(\n                this._promiseFulfilled, this, maybePromise._value()\n            );\n        } else if (((bitField & 16777216) !== 0)) {\n            Promise._async.invoke(\n                this._promiseRejected, this, maybePromise._reason()\n            );\n        } else {\n            this._promiseCancelled();\n        }\n    }\n};\n\nPromise.coroutine = function (generatorFunction, options) {\n    if (typeof generatorFunction !== \"function\") {\n        throw new TypeError(\"generatorFunction must be a function\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    var yieldHandler = Object(options).yieldHandler;\n    var PromiseSpawn$ = PromiseSpawn;\n    var stack = new Error().stack;\n    return function () {\n        var generator = generatorFunction.apply(this, arguments);\n        var spawn = new PromiseSpawn$(undefined, undefined, yieldHandler,\n                                      stack);\n        var ret = spawn.promise();\n        spawn._generator = generator;\n        spawn._promiseFulfilled(undefined);\n        return ret;\n    };\n};\n\nPromise.coroutine.addYieldHandler = function(fn) {\n    if (typeof fn !== \"function\") {\n        throw new TypeError(\"expecting a function but got \" + util.classString(fn));\n    }\n    yieldHandlers.push(fn);\n};\n\nPromise.spawn = function (generatorFunction) {\n    debug.deprecated(\"Promise.spawn()\", \"Promise.coroutine()\");\n    if (typeof generatorFunction !== \"function\") {\n        return apiRejection(\"generatorFunction must be a function\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    var spawn = new PromiseSpawn(generatorFunction, this);\n    var ret = spawn.promise();\n    spawn._run(Promise.spawn);\n    return ret;\n};\n};\n\n},{\"./errors\":12,\"./util\":36}],17:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports =\nfunction(Promise, PromiseArray, tryConvertToPromise, INTERNAL, async,\n         getDomain) {\nvar util = _dereq_(\"./util\");\nvar canEvaluate = util.canEvaluate;\nvar tryCatch = util.tryCatch;\nvar errorObj = util.errorObj;\nvar reject;\n\nif (!true) {\nif (canEvaluate) {\n    var thenCallback = function(i) {\n        return new Function(\"value\", \"holder\", \"                             \\n\\\n            'use strict';                                                    \\n\\\n            holder.pIndex = value;                                           \\n\\\n            holder.checkFulfillment(this);                                   \\n\\\n            \".replace(/Index/g, i));\n    };\n\n    var promiseSetter = function(i) {\n        return new Function(\"promise\", \"holder\", \"                           \\n\\\n            'use strict';                                                    \\n\\\n            holder.pIndex = promise;                                         \\n\\\n            \".replace(/Index/g, i));\n    };\n\n    var generateHolderClass = function(total) {\n        var props = new Array(total);\n        for (var i = 0; i < props.length; ++i) {\n            props[i] = \"this.p\" + (i+1);\n        }\n        var assignment = props.join(\" = \") + \" = null;\";\n        var cancellationCode= \"var promise;\\n\" + props.map(function(prop) {\n            return \"                                                         \\n\\\n                promise = \" + prop + \";                                      \\n\\\n                if (promise instanceof Promise) {                            \\n\\\n                    promise.cancel();                                        \\n\\\n                }                                                            \\n\\\n            \";\n        }).join(\"\\n\");\n        var passedArguments = props.join(\", \");\n        var name = \"Holder$\" + total;\n\n\n        var code = \"return function(tryCatch, errorObj, Promise, async) {    \\n\\\n            'use strict';                                                    \\n\\\n            function [TheName](fn) {                                         \\n\\\n                [TheProperties]                                              \\n\\\n                this.fn = fn;                                                \\n\\\n                this.asyncNeeded = true;                                     \\n\\\n                this.now = 0;                                                \\n\\\n            }                                                                \\n\\\n                                                                             \\n\\\n            [TheName].prototype._callFunction = function(promise) {          \\n\\\n                promise._pushContext();                                      \\n\\\n                var ret = tryCatch(this.fn)([ThePassedArguments]);           \\n\\\n                promise._popContext();                                       \\n\\\n                if (ret === errorObj) {                                      \\n\\\n                    promise._rejectCallback(ret.e, false);                   \\n\\\n                } else {                                                     \\n\\\n                    promise._resolveCallback(ret);                           \\n\\\n                }                                                            \\n\\\n            };                                                               \\n\\\n                                                                             \\n\\\n            [TheName].prototype.checkFulfillment = function(promise) {       \\n\\\n                var now = ++this.now;                                        \\n\\\n                if (now === [TheTotal]) {                                    \\n\\\n                    if (this.asyncNeeded) {                                  \\n\\\n                        async.invoke(this._callFunction, this, promise);     \\n\\\n                    } else {                                                 \\n\\\n                        this._callFunction(promise);                         \\n\\\n                    }                                                        \\n\\\n                                                                             \\n\\\n                }                                                            \\n\\\n            };                                                               \\n\\\n                                                                             \\n\\\n            [TheName].prototype._resultCancelled = function() {              \\n\\\n                [CancellationCode]                                           \\n\\\n            };                                                               \\n\\\n                                                                             \\n\\\n            return [TheName];                                                \\n\\\n        }(tryCatch, errorObj, Promise, async);                               \\n\\\n        \";\n\n        code = code.replace(/\\[TheName\\]/g, name)\n            .replace(/\\[TheTotal\\]/g, total)\n            .replace(/\\[ThePassedArguments\\]/g, passedArguments)\n            .replace(/\\[TheProperties\\]/g, assignment)\n            .replace(/\\[CancellationCode\\]/g, cancellationCode);\n\n        return new Function(\"tryCatch\", \"errorObj\", \"Promise\", \"async\", code)\n                           (tryCatch, errorObj, Promise, async);\n    };\n\n    var holderClasses = [];\n    var thenCallbacks = [];\n    var promiseSetters = [];\n\n    for (var i = 0; i < 8; ++i) {\n        holderClasses.push(generateHolderClass(i + 1));\n        thenCallbacks.push(thenCallback(i + 1));\n        promiseSetters.push(promiseSetter(i + 1));\n    }\n\n    reject = function (reason) {\n        this._reject(reason);\n    };\n}}\n\nPromise.join = function () {\n    var last = arguments.length - 1;\n    var fn;\n    if (last > 0 && typeof arguments[last] === \"function\") {\n        fn = arguments[last];\n        if (!true) {\n            if (last <= 8 && canEvaluate) {\n                var ret = new Promise(INTERNAL);\n                ret._captureStackTrace();\n                var HolderClass = holderClasses[last - 1];\n                var holder = new HolderClass(fn);\n                var callbacks = thenCallbacks;\n\n                for (var i = 0; i < last; ++i) {\n                    var maybePromise = tryConvertToPromise(arguments[i], ret);\n                    if (maybePromise instanceof Promise) {\n                        maybePromise = maybePromise._target();\n                        var bitField = maybePromise._bitField;\n                        ;\n                        if (((bitField & 50397184) === 0)) {\n                            maybePromise._then(callbacks[i], reject,\n                                               undefined, ret, holder);\n                            promiseSetters[i](maybePromise, holder);\n                            holder.asyncNeeded = false;\n                        } else if (((bitField & 33554432) !== 0)) {\n                            callbacks[i].call(ret,\n                                              maybePromise._value(), holder);\n                        } else if (((bitField & 16777216) !== 0)) {\n                            ret._reject(maybePromise._reason());\n                        } else {\n                            ret._cancel();\n                        }\n                    } else {\n                        callbacks[i].call(ret, maybePromise, holder);\n                    }\n                }\n\n                if (!ret._isFateSealed()) {\n                    if (holder.asyncNeeded) {\n                        var domain = getDomain();\n                        if (domain !== null) {\n                            holder.fn = util.domainBind(domain, holder.fn);\n                        }\n                    }\n                    ret._setAsyncGuaranteed();\n                    ret._setOnCancel(holder);\n                }\n                return ret;\n            }\n        }\n    }\n    var args = [].slice.call(arguments);;\n    if (fn) args.pop();\n    var ret = new PromiseArray(args).promise();\n    return fn !== undefined ? ret.spread(fn) : ret;\n};\n\n};\n\n},{\"./util\":36}],18:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise,\n                          PromiseArray,\n                          apiRejection,\n                          tryConvertToPromise,\n                          INTERNAL,\n                          debug) {\nvar getDomain = Promise._getDomain;\nvar util = _dereq_(\"./util\");\nvar tryCatch = util.tryCatch;\nvar errorObj = util.errorObj;\nvar async = Promise._async;\n\nfunction MappingPromiseArray(promises, fn, limit, _filter) {\n    this.constructor$(promises);\n    this._promise._captureStackTrace();\n    var domain = getDomain();\n    this._callback = domain === null ? fn : util.domainBind(domain, fn);\n    this._preservedValues = _filter === INTERNAL\n        ? new Array(this.length())\n        : null;\n    this._limit = limit;\n    this._inFlight = 0;\n    this._queue = [];\n    async.invoke(this._asyncInit, this, undefined);\n}\nutil.inherits(MappingPromiseArray, PromiseArray);\n\nMappingPromiseArray.prototype._asyncInit = function() {\n    this._init$(undefined, -2);\n};\n\nMappingPromiseArray.prototype._init = function () {};\n\nMappingPromiseArray.prototype._promiseFulfilled = function (value, index) {\n    var values = this._values;\n    var length = this.length();\n    var preservedValues = this._preservedValues;\n    var limit = this._limit;\n\n    if (index < 0) {\n        index = (index * -1) - 1;\n        values[index] = value;\n        if (limit >= 1) {\n            this._inFlight--;\n            this._drainQueue();\n            if (this._isResolved()) return true;\n        }\n    } else {\n        if (limit >= 1 && this._inFlight >= limit) {\n            values[index] = value;\n            this._queue.push(index);\n            return false;\n        }\n        if (preservedValues !== null) preservedValues[index] = value;\n\n        var promise = this._promise;\n        var callback = this._callback;\n        var receiver = promise._boundValue();\n        promise._pushContext();\n        var ret = tryCatch(callback).call(receiver, value, index, length);\n        var promiseCreated = promise._popContext();\n        debug.checkForgottenReturns(\n            ret,\n            promiseCreated,\n            preservedValues !== null ? \"Promise.filter\" : \"Promise.map\",\n            promise\n        );\n        if (ret === errorObj) {\n            this._reject(ret.e);\n            return true;\n        }\n\n        var maybePromise = tryConvertToPromise(ret, this._promise);\n        if (maybePromise instanceof Promise) {\n            maybePromise = maybePromise._target();\n            var bitField = maybePromise._bitField;\n            ;\n            if (((bitField & 50397184) === 0)) {\n                if (limit >= 1) this._inFlight++;\n                values[index] = maybePromise;\n                maybePromise._proxy(this, (index + 1) * -1);\n                return false;\n            } else if (((bitField & 33554432) !== 0)) {\n                ret = maybePromise._value();\n            } else if (((bitField & 16777216) !== 0)) {\n                this._reject(maybePromise._reason());\n                return true;\n            } else {\n                this._cancel();\n                return true;\n            }\n        }\n        values[index] = ret;\n    }\n    var totalResolved = ++this._totalResolved;\n    if (totalResolved >= length) {\n        if (preservedValues !== null) {\n            this._filter(values, preservedValues);\n        } else {\n            this._resolve(values);\n        }\n        return true;\n    }\n    return false;\n};\n\nMappingPromiseArray.prototype._drainQueue = function () {\n    var queue = this._queue;\n    var limit = this._limit;\n    var values = this._values;\n    while (queue.length > 0 && this._inFlight < limit) {\n        if (this._isResolved()) return;\n        var index = queue.pop();\n        this._promiseFulfilled(values[index], index);\n    }\n};\n\nMappingPromiseArray.prototype._filter = function (booleans, values) {\n    var len = values.length;\n    var ret = new Array(len);\n    var j = 0;\n    for (var i = 0; i < len; ++i) {\n        if (booleans[i]) ret[j++] = values[i];\n    }\n    ret.length = j;\n    this._resolve(ret);\n};\n\nMappingPromiseArray.prototype.preservedValues = function () {\n    return this._preservedValues;\n};\n\nfunction map(promises, fn, options, _filter) {\n    if (typeof fn !== \"function\") {\n        return apiRejection(\"expecting a function but got \" + util.classString(fn));\n    }\n\n    var limit = 0;\n    if (options !== undefined) {\n        if (typeof options === \"object\" && options !== null) {\n            if (typeof options.concurrency !== \"number\") {\n                return Promise.reject(\n                    new TypeError(\"'concurrency' must be a number but it is \" +\n                                    util.classString(options.concurrency)));\n            }\n            limit = options.concurrency;\n        } else {\n            return Promise.reject(new TypeError(\n                            \"options argument must be an object but it is \" +\n                             util.classString(options)));\n        }\n    }\n    limit = typeof limit === \"number\" &&\n        isFinite(limit) && limit >= 1 ? limit : 0;\n    return new MappingPromiseArray(promises, fn, limit, _filter).promise();\n}\n\nPromise.prototype.map = function (fn, options) {\n    return map(this, fn, options, null);\n};\n\nPromise.map = function (promises, fn, options, _filter) {\n    return map(promises, fn, options, _filter);\n};\n\n\n};\n\n},{\"./util\":36}],19:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports =\nfunction(Promise, INTERNAL, tryConvertToPromise, apiRejection, debug) {\nvar util = _dereq_(\"./util\");\nvar tryCatch = util.tryCatch;\n\nPromise.method = function (fn) {\n    if (typeof fn !== \"function\") {\n        throw new Promise.TypeError(\"expecting a function but got \" + util.classString(fn));\n    }\n    return function () {\n        var ret = new Promise(INTERNAL);\n        ret._captureStackTrace();\n        ret._pushContext();\n        var value = tryCatch(fn).apply(this, arguments);\n        var promiseCreated = ret._popContext();\n        debug.checkForgottenReturns(\n            value, promiseCreated, \"Promise.method\", ret);\n        ret._resolveFromSyncValue(value);\n        return ret;\n    };\n};\n\nPromise.attempt = Promise[\"try\"] = function (fn) {\n    if (typeof fn !== \"function\") {\n        return apiRejection(\"expecting a function but got \" + util.classString(fn));\n    }\n    var ret = new Promise(INTERNAL);\n    ret._captureStackTrace();\n    ret._pushContext();\n    var value;\n    if (arguments.length > 1) {\n        debug.deprecated(\"calling Promise.try with more than 1 argument\");\n        var arg = arguments[1];\n        var ctx = arguments[2];\n        value = util.isArray(arg) ? tryCatch(fn).apply(ctx, arg)\n                                  : tryCatch(fn).call(ctx, arg);\n    } else {\n        value = tryCatch(fn)();\n    }\n    var promiseCreated = ret._popContext();\n    debug.checkForgottenReturns(\n        value, promiseCreated, \"Promise.try\", ret);\n    ret._resolveFromSyncValue(value);\n    return ret;\n};\n\nPromise.prototype._resolveFromSyncValue = function (value) {\n    if (value === util.errorObj) {\n        this._rejectCallback(value.e, false);\n    } else {\n        this._resolveCallback(value, true);\n    }\n};\n};\n\n},{\"./util\":36}],20:[function(_dereq_,module,exports){\n\"use strict\";\nvar util = _dereq_(\"./util\");\nvar maybeWrapAsError = util.maybeWrapAsError;\nvar errors = _dereq_(\"./errors\");\nvar OperationalError = errors.OperationalError;\nvar es5 = _dereq_(\"./es5\");\n\nfunction isUntypedError(obj) {\n    return obj instanceof Error &&\n        es5.getPrototypeOf(obj) === Error.prototype;\n}\n\nvar rErrorKey = /^(?:name|message|stack|cause)$/;\nfunction wrapAsOperationalError(obj) {\n    var ret;\n    if (isUntypedError(obj)) {\n        ret = new OperationalError(obj);\n        ret.name = obj.name;\n        ret.message = obj.message;\n        ret.stack = obj.stack;\n        var keys = es5.keys(obj);\n        for (var i = 0; i < keys.length; ++i) {\n            var key = keys[i];\n            if (!rErrorKey.test(key)) {\n                ret[key] = obj[key];\n            }\n        }\n        return ret;\n    }\n    util.markAsOriginatingFromRejection(obj);\n    return obj;\n}\n\nfunction nodebackForPromise(promise, multiArgs) {\n    return function(err, value) {\n        if (promise === null) return;\n        if (err) {\n            var wrapped = wrapAsOperationalError(maybeWrapAsError(err));\n            promise._attachExtraTrace(wrapped);\n            promise._reject(wrapped);\n        } else if (!multiArgs) {\n            promise._fulfill(value);\n        } else {\n            var args = [].slice.call(arguments, 1);;\n            promise._fulfill(args);\n        }\n        promise = null;\n    };\n}\n\nmodule.exports = nodebackForPromise;\n\n},{\"./errors\":12,\"./es5\":13,\"./util\":36}],21:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise) {\nvar util = _dereq_(\"./util\");\nvar async = Promise._async;\nvar tryCatch = util.tryCatch;\nvar errorObj = util.errorObj;\n\nfunction spreadAdapter(val, nodeback) {\n    var promise = this;\n    if (!util.isArray(val)) return successAdapter.call(promise, val, nodeback);\n    var ret =\n        tryCatch(nodeback).apply(promise._boundValue(), [null].concat(val));\n    if (ret === errorObj) {\n        async.throwLater(ret.e);\n    }\n}\n\nfunction successAdapter(val, nodeback) {\n    var promise = this;\n    var receiver = promise._boundValue();\n    var ret = val === undefined\n        ? tryCatch(nodeback).call(receiver, null)\n        : tryCatch(nodeback).call(receiver, null, val);\n    if (ret === errorObj) {\n        async.throwLater(ret.e);\n    }\n}\nfunction errorAdapter(reason, nodeback) {\n    var promise = this;\n    if (!reason) {\n        var newReason = new Error(reason + \"\");\n        newReason.cause = reason;\n        reason = newReason;\n    }\n    var ret = tryCatch(nodeback).call(promise._boundValue(), reason);\n    if (ret === errorObj) {\n        async.throwLater(ret.e);\n    }\n}\n\nPromise.prototype.asCallback = Promise.prototype.nodeify = function (nodeback,\n                                                                     options) {\n    if (typeof nodeback == \"function\") {\n        var adapter = successAdapter;\n        if (options !== undefined && Object(options).spread) {\n            adapter = spreadAdapter;\n        }\n        this._then(\n            adapter,\n            errorAdapter,\n            undefined,\n            this,\n            nodeback\n        );\n    }\n    return this;\n};\n};\n\n},{\"./util\":36}],22:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function() {\nvar makeSelfResolutionError = function () {\n    return new TypeError(\"circular promise resolution chain\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n};\nvar reflectHandler = function() {\n    return new Promise.PromiseInspection(this._target());\n};\nvar apiRejection = function(msg) {\n    return Promise.reject(new TypeError(msg));\n};\nfunction Proxyable() {}\nvar UNDEFINED_BINDING = {};\nvar util = _dereq_(\"./util\");\n\nvar getDomain;\nif (util.isNode) {\n    getDomain = function() {\n        var ret = process.domain;\n        if (ret === undefined) ret = null;\n        return ret;\n    };\n} else {\n    getDomain = function() {\n        return null;\n    };\n}\nutil.notEnumerableProp(Promise, \"_getDomain\", getDomain);\n\nvar es5 = _dereq_(\"./es5\");\nvar Async = _dereq_(\"./async\");\nvar async = new Async();\nes5.defineProperty(Promise, \"_async\", {value: async});\nvar errors = _dereq_(\"./errors\");\nvar TypeError = Promise.TypeError = errors.TypeError;\nPromise.RangeError = errors.RangeError;\nvar CancellationError = Promise.CancellationError = errors.CancellationError;\nPromise.TimeoutError = errors.TimeoutError;\nPromise.OperationalError = errors.OperationalError;\nPromise.RejectionError = errors.OperationalError;\nPromise.AggregateError = errors.AggregateError;\nvar INTERNAL = function(){};\nvar APPLY = {};\nvar NEXT_FILTER = {};\nvar tryConvertToPromise = _dereq_(\"./thenables\")(Promise, INTERNAL);\nvar PromiseArray =\n    _dereq_(\"./promise_array\")(Promise, INTERNAL,\n                               tryConvertToPromise, apiRejection, Proxyable);\nvar Context = _dereq_(\"./context\")(Promise);\n /*jshint unused:false*/\nvar createContext = Context.create;\nvar debug = _dereq_(\"./debuggability\")(Promise, Context);\nvar CapturedTrace = debug.CapturedTrace;\nvar PassThroughHandlerContext =\n    _dereq_(\"./finally\")(Promise, tryConvertToPromise, NEXT_FILTER);\nvar catchFilter = _dereq_(\"./catch_filter\")(NEXT_FILTER);\nvar nodebackForPromise = _dereq_(\"./nodeback\");\nvar errorObj = util.errorObj;\nvar tryCatch = util.tryCatch;\nfunction check(self, executor) {\n    if (self == null || self.constructor !== Promise) {\n        throw new TypeError(\"the promise constructor cannot be invoked directly\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    if (typeof executor !== \"function\") {\n        throw new TypeError(\"expecting a function but got \" + util.classString(executor));\n    }\n\n}\n\nfunction Promise(executor) {\n    if (executor !== INTERNAL) {\n        check(this, executor);\n    }\n    this._bitField = 0;\n    this._fulfillmentHandler0 = undefined;\n    this._rejectionHandler0 = undefined;\n    this._promise0 = undefined;\n    this._receiver0 = undefined;\n    this._resolveFromExecutor(executor);\n    this._promiseCreated();\n    this._fireEvent(\"promiseCreated\", this);\n}\n\nPromise.prototype.toString = function () {\n    return \"[object Promise]\";\n};\n\nPromise.prototype.caught = Promise.prototype[\"catch\"] = function (fn) {\n    var len = arguments.length;\n    if (len > 1) {\n        var catchInstances = new Array(len - 1),\n            j = 0, i;\n        for (i = 0; i < len - 1; ++i) {\n            var item = arguments[i];\n            if (util.isObject(item)) {\n                catchInstances[j++] = item;\n            } else {\n                return apiRejection(\"Catch statement predicate: \" +\n                    \"expecting an object but got \" + util.classString(item));\n            }\n        }\n        catchInstances.length = j;\n        fn = arguments[i];\n        return this.then(undefined, catchFilter(catchInstances, fn, this));\n    }\n    return this.then(undefined, fn);\n};\n\nPromise.prototype.reflect = function () {\n    return this._then(reflectHandler,\n        reflectHandler, undefined, this, undefined);\n};\n\nPromise.prototype.then = function (didFulfill, didReject) {\n    if (debug.warnings() && arguments.length > 0 &&\n        typeof didFulfill !== \"function\" &&\n        typeof didReject !== \"function\") {\n        var msg = \".then() only accepts functions but was passed: \" +\n                util.classString(didFulfill);\n        if (arguments.length > 1) {\n            msg += \", \" + util.classString(didReject);\n        }\n        this._warn(msg);\n    }\n    return this._then(didFulfill, didReject, undefined, undefined, undefined);\n};\n\nPromise.prototype.done = function (didFulfill, didReject) {\n    var promise =\n        this._then(didFulfill, didReject, undefined, undefined, undefined);\n    promise._setIsFinal();\n};\n\nPromise.prototype.spread = function (fn) {\n    if (typeof fn !== \"function\") {\n        return apiRejection(\"expecting a function but got \" + util.classString(fn));\n    }\n    return this.all()._then(fn, undefined, undefined, APPLY, undefined);\n};\n\nPromise.prototype.toJSON = function () {\n    var ret = {\n        isFulfilled: false,\n        isRejected: false,\n        fulfillmentValue: undefined,\n        rejectionReason: undefined\n    };\n    if (this.isFulfilled()) {\n        ret.fulfillmentValue = this.value();\n        ret.isFulfilled = true;\n    } else if (this.isRejected()) {\n        ret.rejectionReason = this.reason();\n        ret.isRejected = true;\n    }\n    return ret;\n};\n\nPromise.prototype.all = function () {\n    if (arguments.length > 0) {\n        this._warn(\".all() was passed arguments but it does not take any\");\n    }\n    return new PromiseArray(this).promise();\n};\n\nPromise.prototype.error = function (fn) {\n    return this.caught(util.originatesFromRejection, fn);\n};\n\nPromise.getNewLibraryCopy = module.exports;\n\nPromise.is = function (val) {\n    return val instanceof Promise;\n};\n\nPromise.fromNode = Promise.fromCallback = function(fn) {\n    var ret = new Promise(INTERNAL);\n    ret._captureStackTrace();\n    var multiArgs = arguments.length > 1 ? !!Object(arguments[1]).multiArgs\n                                         : false;\n    var result = tryCatch(fn)(nodebackForPromise(ret, multiArgs));\n    if (result === errorObj) {\n        ret._rejectCallback(result.e, true);\n    }\n    if (!ret._isFateSealed()) ret._setAsyncGuaranteed();\n    return ret;\n};\n\nPromise.all = function (promises) {\n    return new PromiseArray(promises).promise();\n};\n\nPromise.cast = function (obj) {\n    var ret = tryConvertToPromise(obj);\n    if (!(ret instanceof Promise)) {\n        ret = new Promise(INTERNAL);\n        ret._captureStackTrace();\n        ret._setFulfilled();\n        ret._rejectionHandler0 = obj;\n    }\n    return ret;\n};\n\nPromise.resolve = Promise.fulfilled = Promise.cast;\n\nPromise.reject = Promise.rejected = function (reason) {\n    var ret = new Promise(INTERNAL);\n    ret._captureStackTrace();\n    ret._rejectCallback(reason, true);\n    return ret;\n};\n\nPromise.setScheduler = function(fn) {\n    if (typeof fn !== \"function\") {\n        throw new TypeError(\"expecting a function but got \" + util.classString(fn));\n    }\n    return async.setScheduler(fn);\n};\n\nPromise.prototype._then = function (\n    didFulfill,\n    didReject,\n    _,    receiver,\n    internalData\n) {\n    var haveInternalData = internalData !== undefined;\n    var promise = haveInternalData ? internalData : new Promise(INTERNAL);\n    var target = this._target();\n    var bitField = target._bitField;\n\n    if (!haveInternalData) {\n        promise._propagateFrom(this, 3);\n        promise._captureStackTrace();\n        if (receiver === undefined &&\n            ((this._bitField & 2097152) !== 0)) {\n            if (!((bitField & 50397184) === 0)) {\n                receiver = this._boundValue();\n            } else {\n                receiver = target === this ? undefined : this._boundTo;\n            }\n        }\n        this._fireEvent(\"promiseChained\", this, promise);\n    }\n\n    var domain = getDomain();\n    if (!((bitField & 50397184) === 0)) {\n        var handler, value, settler = target._settlePromiseCtx;\n        if (((bitField & 33554432) !== 0)) {\n            value = target._rejectionHandler0;\n            handler = didFulfill;\n        } else if (((bitField & 16777216) !== 0)) {\n            value = target._fulfillmentHandler0;\n            handler = didReject;\n            target._unsetRejectionIsUnhandled();\n        } else {\n            settler = target._settlePromiseLateCancellationObserver;\n            value = new CancellationError(\"late cancellation observer\");\n            target._attachExtraTrace(value);\n            handler = didReject;\n        }\n\n        async.invoke(settler, target, {\n            handler: domain === null ? handler\n                : (typeof handler === \"function\" &&\n                    util.domainBind(domain, handler)),\n            promise: promise,\n            receiver: receiver,\n            value: value\n        });\n    } else {\n        target._addCallbacks(didFulfill, didReject, promise, receiver, domain);\n    }\n\n    return promise;\n};\n\nPromise.prototype._length = function () {\n    return this._bitField & 65535;\n};\n\nPromise.prototype._isFateSealed = function () {\n    return (this._bitField & 117506048) !== 0;\n};\n\nPromise.prototype._isFollowing = function () {\n    return (this._bitField & 67108864) === 67108864;\n};\n\nPromise.prototype._setLength = function (len) {\n    this._bitField = (this._bitField & -65536) |\n        (len & 65535);\n};\n\nPromise.prototype._setFulfilled = function () {\n    this._bitField = this._bitField | 33554432;\n    this._fireEvent(\"promiseFulfilled\", this);\n};\n\nPromise.prototype._setRejected = function () {\n    this._bitField = this._bitField | 16777216;\n    this._fireEvent(\"promiseRejected\", this);\n};\n\nPromise.prototype._setFollowing = function () {\n    this._bitField = this._bitField | 67108864;\n    this._fireEvent(\"promiseResolved\", this);\n};\n\nPromise.prototype._setIsFinal = function () {\n    this._bitField = this._bitField | 4194304;\n};\n\nPromise.prototype._isFinal = function () {\n    return (this._bitField & 4194304) > 0;\n};\n\nPromise.prototype._unsetCancelled = function() {\n    this._bitField = this._bitField & (~65536);\n};\n\nPromise.prototype._setCancelled = function() {\n    this._bitField = this._bitField | 65536;\n    this._fireEvent(\"promiseCancelled\", this);\n};\n\nPromise.prototype._setWillBeCancelled = function() {\n    this._bitField = this._bitField | 8388608;\n};\n\nPromise.prototype._setAsyncGuaranteed = function() {\n    if (async.hasCustomScheduler()) return;\n    this._bitField = this._bitField | 134217728;\n};\n\nPromise.prototype._receiverAt = function (index) {\n    var ret = index === 0 ? this._receiver0 : this[\n            index * 4 - 4 + 3];\n    if (ret === UNDEFINED_BINDING) {\n        return undefined;\n    } else if (ret === undefined && this._isBound()) {\n        return this._boundValue();\n    }\n    return ret;\n};\n\nPromise.prototype._promiseAt = function (index) {\n    return this[\n            index * 4 - 4 + 2];\n};\n\nPromise.prototype._fulfillmentHandlerAt = function (index) {\n    return this[\n            index * 4 - 4 + 0];\n};\n\nPromise.prototype._rejectionHandlerAt = function (index) {\n    return this[\n            index * 4 - 4 + 1];\n};\n\nPromise.prototype._boundValue = function() {};\n\nPromise.prototype._migrateCallback0 = function (follower) {\n    var bitField = follower._bitField;\n    var fulfill = follower._fulfillmentHandler0;\n    var reject = follower._rejectionHandler0;\n    var promise = follower._promise0;\n    var receiver = follower._receiverAt(0);\n    if (receiver === undefined) receiver = UNDEFINED_BINDING;\n    this._addCallbacks(fulfill, reject, promise, receiver, null);\n};\n\nPromise.prototype._migrateCallbackAt = function (follower, index) {\n    var fulfill = follower._fulfillmentHandlerAt(index);\n    var reject = follower._rejectionHandlerAt(index);\n    var promise = follower._promiseAt(index);\n    var receiver = follower._receiverAt(index);\n    if (receiver === undefined) receiver = UNDEFINED_BINDING;\n    this._addCallbacks(fulfill, reject, promise, receiver, null);\n};\n\nPromise.prototype._addCallbacks = function (\n    fulfill,\n    reject,\n    promise,\n    receiver,\n    domain\n) {\n    var index = this._length();\n\n    if (index >= 65535 - 4) {\n        index = 0;\n        this._setLength(0);\n    }\n\n    if (index === 0) {\n        this._promise0 = promise;\n        this._receiver0 = receiver;\n        if (typeof fulfill === \"function\") {\n            this._fulfillmentHandler0 =\n                domain === null ? fulfill : util.domainBind(domain, fulfill);\n        }\n        if (typeof reject === \"function\") {\n            this._rejectionHandler0 =\n                domain === null ? reject : util.domainBind(domain, reject);\n        }\n    } else {\n        var base = index * 4 - 4;\n        this[base + 2] = promise;\n        this[base + 3] = receiver;\n        if (typeof fulfill === \"function\") {\n            this[base + 0] =\n                domain === null ? fulfill : util.domainBind(domain, fulfill);\n        }\n        if (typeof reject === \"function\") {\n            this[base + 1] =\n                domain === null ? reject : util.domainBind(domain, reject);\n        }\n    }\n    this._setLength(index + 1);\n    return index;\n};\n\nPromise.prototype._proxy = function (proxyable, arg) {\n    this._addCallbacks(undefined, undefined, arg, proxyable, null);\n};\n\nPromise.prototype._resolveCallback = function(value, shouldBind) {\n    if (((this._bitField & 117506048) !== 0)) return;\n    if (value === this)\n        return this._rejectCallback(makeSelfResolutionError(), false);\n    var maybePromise = tryConvertToPromise(value, this);\n    if (!(maybePromise instanceof Promise)) return this._fulfill(value);\n\n    if (shouldBind) this._propagateFrom(maybePromise, 2);\n\n    var promise = maybePromise._target();\n\n    if (promise === this) {\n        this._reject(makeSelfResolutionError());\n        return;\n    }\n\n    var bitField = promise._bitField;\n    if (((bitField & 50397184) === 0)) {\n        var len = this._length();\n        if (len > 0) promise._migrateCallback0(this);\n        for (var i = 1; i < len; ++i) {\n            promise._migrateCallbackAt(this, i);\n        }\n        this._setFollowing();\n        this._setLength(0);\n        this._setFollowee(promise);\n    } else if (((bitField & 33554432) !== 0)) {\n        this._fulfill(promise._value());\n    } else if (((bitField & 16777216) !== 0)) {\n        this._reject(promise._reason());\n    } else {\n        var reason = new CancellationError(\"late cancellation observer\");\n        promise._attachExtraTrace(reason);\n        this._reject(reason);\n    }\n};\n\nPromise.prototype._rejectCallback =\nfunction(reason, synchronous, ignoreNonErrorWarnings) {\n    var trace = util.ensureErrorObject(reason);\n    var hasStack = trace === reason;\n    if (!hasStack && !ignoreNonErrorWarnings && debug.warnings()) {\n        var message = \"a promise was rejected with a non-error: \" +\n            util.classString(reason);\n        this._warn(message, true);\n    }\n    this._attachExtraTrace(trace, synchronous ? hasStack : false);\n    this._reject(reason);\n};\n\nPromise.prototype._resolveFromExecutor = function (executor) {\n    if (executor === INTERNAL) return;\n    var promise = this;\n    this._captureStackTrace();\n    this._pushContext();\n    var synchronous = true;\n    var r = this._execute(executor, function(value) {\n        promise._resolveCallback(value);\n    }, function (reason) {\n        promise._rejectCallback(reason, synchronous);\n    });\n    synchronous = false;\n    this._popContext();\n\n    if (r !== undefined) {\n        promise._rejectCallback(r, true);\n    }\n};\n\nPromise.prototype._settlePromiseFromHandler = function (\n    handler, receiver, value, promise\n) {\n    var bitField = promise._bitField;\n    if (((bitField & 65536) !== 0)) return;\n    promise._pushContext();\n    var x;\n    if (receiver === APPLY) {\n        if (!value || typeof value.length !== \"number\") {\n            x = errorObj;\n            x.e = new TypeError(\"cannot .spread() a non-array: \" +\n                                    util.classString(value));\n        } else {\n            x = tryCatch(handler).apply(this._boundValue(), value);\n        }\n    } else {\n        x = tryCatch(handler).call(receiver, value);\n    }\n    var promiseCreated = promise._popContext();\n    bitField = promise._bitField;\n    if (((bitField & 65536) !== 0)) return;\n\n    if (x === NEXT_FILTER) {\n        promise._reject(value);\n    } else if (x === errorObj) {\n        promise._rejectCallback(x.e, false);\n    } else {\n        debug.checkForgottenReturns(x, promiseCreated, \"\",  promise, this);\n        promise._resolveCallback(x);\n    }\n};\n\nPromise.prototype._target = function() {\n    var ret = this;\n    while (ret._isFollowing()) ret = ret._followee();\n    return ret;\n};\n\nPromise.prototype._followee = function() {\n    return this._rejectionHandler0;\n};\n\nPromise.prototype._setFollowee = function(promise) {\n    this._rejectionHandler0 = promise;\n};\n\nPromise.prototype._settlePromise = function(promise, handler, receiver, value) {\n    var isPromise = promise instanceof Promise;\n    var bitField = this._bitField;\n    var asyncGuaranteed = ((bitField & 134217728) !== 0);\n    if (((bitField & 65536) !== 0)) {\n        if (isPromise) promise._invokeInternalOnCancel();\n\n        if (receiver instanceof PassThroughHandlerContext &&\n            receiver.isFinallyHandler()) {\n            receiver.cancelPromise = promise;\n            if (tryCatch(handler).call(receiver, value) === errorObj) {\n                promise._reject(errorObj.e);\n            }\n        } else if (handler === reflectHandler) {\n            promise._fulfill(reflectHandler.call(receiver));\n        } else if (receiver instanceof Proxyable) {\n            receiver._promiseCancelled(promise);\n        } else if (isPromise || promise instanceof PromiseArray) {\n            promise._cancel();\n        } else {\n            receiver.cancel();\n        }\n    } else if (typeof handler === \"function\") {\n        if (!isPromise) {\n            handler.call(receiver, value, promise);\n        } else {\n            if (asyncGuaranteed) promise._setAsyncGuaranteed();\n            this._settlePromiseFromHandler(handler, receiver, value, promise);\n        }\n    } else if (receiver instanceof Proxyable) {\n        if (!receiver._isResolved()) {\n            if (((bitField & 33554432) !== 0)) {\n                receiver._promiseFulfilled(value, promise);\n            } else {\n                receiver._promiseRejected(value, promise);\n            }\n        }\n    } else if (isPromise) {\n        if (asyncGuaranteed) promise._setAsyncGuaranteed();\n        if (((bitField & 33554432) !== 0)) {\n            promise._fulfill(value);\n        } else {\n            promise._reject(value);\n        }\n    }\n};\n\nPromise.prototype._settlePromiseLateCancellationObserver = function(ctx) {\n    var handler = ctx.handler;\n    var promise = ctx.promise;\n    var receiver = ctx.receiver;\n    var value = ctx.value;\n    if (typeof handler === \"function\") {\n        if (!(promise instanceof Promise)) {\n            handler.call(receiver, value, promise);\n        } else {\n            this._settlePromiseFromHandler(handler, receiver, value, promise);\n        }\n    } else if (promise instanceof Promise) {\n        promise._reject(value);\n    }\n};\n\nPromise.prototype._settlePromiseCtx = function(ctx) {\n    this._settlePromise(ctx.promise, ctx.handler, ctx.receiver, ctx.value);\n};\n\nPromise.prototype._settlePromise0 = function(handler, value, bitField) {\n    var promise = this._promise0;\n    var receiver = this._receiverAt(0);\n    this._promise0 = undefined;\n    this._receiver0 = undefined;\n    this._settlePromise(promise, handler, receiver, value);\n};\n\nPromise.prototype._clearCallbackDataAtIndex = function(index) {\n    var base = index * 4 - 4;\n    this[base + 2] =\n    this[base + 3] =\n    this[base + 0] =\n    this[base + 1] = undefined;\n};\n\nPromise.prototype._fulfill = function (value) {\n    var bitField = this._bitField;\n    if (((bitField & 117506048) >>> 16)) return;\n    if (value === this) {\n        var err = makeSelfResolutionError();\n        this._attachExtraTrace(err);\n        return this._reject(err);\n    }\n    this._setFulfilled();\n    this._rejectionHandler0 = value;\n\n    if ((bitField & 65535) > 0) {\n        if (((bitField & 134217728) !== 0)) {\n            this._settlePromises();\n        } else {\n            async.settlePromises(this);\n        }\n    }\n};\n\nPromise.prototype._reject = function (reason) {\n    var bitField = this._bitField;\n    if (((bitField & 117506048) >>> 16)) return;\n    this._setRejected();\n    this._fulfillmentHandler0 = reason;\n\n    if (this._isFinal()) {\n        return async.fatalError(reason, util.isNode);\n    }\n\n    if ((bitField & 65535) > 0) {\n        async.settlePromises(this);\n    } else {\n        this._ensurePossibleRejectionHandled();\n    }\n};\n\nPromise.prototype._fulfillPromises = function (len, value) {\n    for (var i = 1; i < len; i++) {\n        var handler = this._fulfillmentHandlerAt(i);\n        var promise = this._promiseAt(i);\n        var receiver = this._receiverAt(i);\n        this._clearCallbackDataAtIndex(i);\n        this._settlePromise(promise, handler, receiver, value);\n    }\n};\n\nPromise.prototype._rejectPromises = function (len, reason) {\n    for (var i = 1; i < len; i++) {\n        var handler = this._rejectionHandlerAt(i);\n        var promise = this._promiseAt(i);\n        var receiver = this._receiverAt(i);\n        this._clearCallbackDataAtIndex(i);\n        this._settlePromise(promise, handler, receiver, reason);\n    }\n};\n\nPromise.prototype._settlePromises = function () {\n    var bitField = this._bitField;\n    var len = (bitField & 65535);\n\n    if (len > 0) {\n        if (((bitField & 16842752) !== 0)) {\n            var reason = this._fulfillmentHandler0;\n            this._settlePromise0(this._rejectionHandler0, reason, bitField);\n            this._rejectPromises(len, reason);\n        } else {\n            var value = this._rejectionHandler0;\n            this._settlePromise0(this._fulfillmentHandler0, value, bitField);\n            this._fulfillPromises(len, value);\n        }\n        this._setLength(0);\n    }\n    this._clearCancellationData();\n};\n\nPromise.prototype._settledValue = function() {\n    var bitField = this._bitField;\n    if (((bitField & 33554432) !== 0)) {\n        return this._rejectionHandler0;\n    } else if (((bitField & 16777216) !== 0)) {\n        return this._fulfillmentHandler0;\n    }\n};\n\nfunction deferResolve(v) {this.promise._resolveCallback(v);}\nfunction deferReject(v) {this.promise._rejectCallback(v, false);}\n\nPromise.defer = Promise.pending = function() {\n    debug.deprecated(\"Promise.defer\", \"new Promise\");\n    var promise = new Promise(INTERNAL);\n    return {\n        promise: promise,\n        resolve: deferResolve,\n        reject: deferReject\n    };\n};\n\nutil.notEnumerableProp(Promise,\n                       \"_makeSelfResolutionError\",\n                       makeSelfResolutionError);\n\n_dereq_(\"./method\")(Promise, INTERNAL, tryConvertToPromise, apiRejection,\n    debug);\n_dereq_(\"./bind\")(Promise, INTERNAL, tryConvertToPromise, debug);\n_dereq_(\"./cancel\")(Promise, PromiseArray, apiRejection, debug);\n_dereq_(\"./direct_resolve\")(Promise);\n_dereq_(\"./synchronous_inspection\")(Promise);\n_dereq_(\"./join\")(\n    Promise, PromiseArray, tryConvertToPromise, INTERNAL, async, getDomain);\nPromise.Promise = Promise;\nPromise.version = \"3.5.0\";\n_dereq_('./map.js')(Promise, PromiseArray, apiRejection, tryConvertToPromise, INTERNAL, debug);\n_dereq_('./call_get.js')(Promise);\n_dereq_('./using.js')(Promise, apiRejection, tryConvertToPromise, createContext, INTERNAL, debug);\n_dereq_('./timers.js')(Promise, INTERNAL, debug);\n_dereq_('./generators.js')(Promise, apiRejection, INTERNAL, tryConvertToPromise, Proxyable, debug);\n_dereq_('./nodeify.js')(Promise);\n_dereq_('./promisify.js')(Promise, INTERNAL);\n_dereq_('./props.js')(Promise, PromiseArray, tryConvertToPromise, apiRejection);\n_dereq_('./race.js')(Promise, INTERNAL, tryConvertToPromise, apiRejection);\n_dereq_('./reduce.js')(Promise, PromiseArray, apiRejection, tryConvertToPromise, INTERNAL, debug);\n_dereq_('./settle.js')(Promise, PromiseArray, debug);\n_dereq_('./some.js')(Promise, PromiseArray, apiRejection);\n_dereq_('./filter.js')(Promise, INTERNAL);\n_dereq_('./each.js')(Promise, INTERNAL);\n_dereq_('./any.js')(Promise);\n                                                         \n    util.toFastProperties(Promise);                                          \n    util.toFastProperties(Promise.prototype);                                \n    function fillTypes(value) {                                              \n        var p = new Promise(INTERNAL);                                       \n        p._fulfillmentHandler0 = value;                                      \n        p._rejectionHandler0 = value;                                        \n        p._promise0 = value;                                                 \n        p._receiver0 = value;                                                \n    }                                                                        \n    // Complete slack tracking, opt out of field-type tracking and           \n    // stabilize map                                                         \n    fillTypes({a: 1});                                                       \n    fillTypes({b: 2});                                                       \n    fillTypes({c: 3});                                                       \n    fillTypes(1);                                                            \n    fillTypes(function(){});                                                 \n    fillTypes(undefined);                                                    \n    fillTypes(false);                                                        \n    fillTypes(new Promise(INTERNAL));                                        \n    debug.setBounds(Async.firstLineError, util.lastLineError);               \n    return Promise;                                                          \n\n};\n\n},{\"./any.js\":1,\"./async\":2,\"./bind\":3,\"./call_get.js\":5,\"./cancel\":6,\"./catch_filter\":7,\"./context\":8,\"./debuggability\":9,\"./direct_resolve\":10,\"./each.js\":11,\"./errors\":12,\"./es5\":13,\"./filter.js\":14,\"./finally\":15,\"./generators.js\":16,\"./join\":17,\"./map.js\":18,\"./method\":19,\"./nodeback\":20,\"./nodeify.js\":21,\"./promise_array\":23,\"./promisify.js\":24,\"./props.js\":25,\"./race.js\":27,\"./reduce.js\":28,\"./settle.js\":30,\"./some.js\":31,\"./synchronous_inspection\":32,\"./thenables\":33,\"./timers.js\":34,\"./using.js\":35,\"./util\":36}],23:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL, tryConvertToPromise,\n    apiRejection, Proxyable) {\nvar util = _dereq_(\"./util\");\nvar isArray = util.isArray;\n\nfunction toResolutionValue(val) {\n    switch(val) {\n    case -2: return [];\n    case -3: return {};\n    case -6: return new Map();\n    }\n}\n\nfunction PromiseArray(values) {\n    var promise = this._promise = new Promise(INTERNAL);\n    if (values instanceof Promise) {\n        promise._propagateFrom(values, 3);\n    }\n    promise._setOnCancel(this);\n    this._values = values;\n    this._length = 0;\n    this._totalResolved = 0;\n    this._init(undefined, -2);\n}\nutil.inherits(PromiseArray, Proxyable);\n\nPromiseArray.prototype.length = function () {\n    return this._length;\n};\n\nPromiseArray.prototype.promise = function () {\n    return this._promise;\n};\n\nPromiseArray.prototype._init = function init(_, resolveValueIfEmpty) {\n    var values = tryConvertToPromise(this._values, this._promise);\n    if (values instanceof Promise) {\n        values = values._target();\n        var bitField = values._bitField;\n        ;\n        this._values = values;\n\n        if (((bitField & 50397184) === 0)) {\n            this._promise._setAsyncGuaranteed();\n            return values._then(\n                init,\n                this._reject,\n                undefined,\n                this,\n                resolveValueIfEmpty\n           );\n        } else if (((bitField & 33554432) !== 0)) {\n            values = values._value();\n        } else if (((bitField & 16777216) !== 0)) {\n            return this._reject(values._reason());\n        } else {\n            return this._cancel();\n        }\n    }\n    values = util.asArray(values);\n    if (values === null) {\n        var err = apiRejection(\n            \"expecting an array or an iterable object but got \" + util.classString(values)).reason();\n        this._promise._rejectCallback(err, false);\n        return;\n    }\n\n    if (values.length === 0) {\n        if (resolveValueIfEmpty === -5) {\n            this._resolveEmptyArray();\n        }\n        else {\n            this._resolve(toResolutionValue(resolveValueIfEmpty));\n        }\n        return;\n    }\n    this._iterate(values);\n};\n\nPromiseArray.prototype._iterate = function(values) {\n    var len = this.getActualLength(values.length);\n    this._length = len;\n    this._values = this.shouldCopyValues() ? new Array(len) : this._values;\n    var result = this._promise;\n    var isResolved = false;\n    var bitField = null;\n    for (var i = 0; i < len; ++i) {\n        var maybePromise = tryConvertToPromise(values[i], result);\n\n        if (maybePromise instanceof Promise) {\n            maybePromise = maybePromise._target();\n            bitField = maybePromise._bitField;\n        } else {\n            bitField = null;\n        }\n\n        if (isResolved) {\n            if (bitField !== null) {\n                maybePromise.suppressUnhandledRejections();\n            }\n        } else if (bitField !== null) {\n            if (((bitField & 50397184) === 0)) {\n                maybePromise._proxy(this, i);\n                this._values[i] = maybePromise;\n            } else if (((bitField & 33554432) !== 0)) {\n                isResolved = this._promiseFulfilled(maybePromise._value(), i);\n            } else if (((bitField & 16777216) !== 0)) {\n                isResolved = this._promiseRejected(maybePromise._reason(), i);\n            } else {\n                isResolved = this._promiseCancelled(i);\n            }\n        } else {\n            isResolved = this._promiseFulfilled(maybePromise, i);\n        }\n    }\n    if (!isResolved) result._setAsyncGuaranteed();\n};\n\nPromiseArray.prototype._isResolved = function () {\n    return this._values === null;\n};\n\nPromiseArray.prototype._resolve = function (value) {\n    this._values = null;\n    this._promise._fulfill(value);\n};\n\nPromiseArray.prototype._cancel = function() {\n    if (this._isResolved() || !this._promise._isCancellable()) return;\n    this._values = null;\n    this._promise._cancel();\n};\n\nPromiseArray.prototype._reject = function (reason) {\n    this._values = null;\n    this._promise._rejectCallback(reason, false);\n};\n\nPromiseArray.prototype._promiseFulfilled = function (value, index) {\n    this._values[index] = value;\n    var totalResolved = ++this._totalResolved;\n    if (totalResolved >= this._length) {\n        this._resolve(this._values);\n        return true;\n    }\n    return false;\n};\n\nPromiseArray.prototype._promiseCancelled = function() {\n    this._cancel();\n    return true;\n};\n\nPromiseArray.prototype._promiseRejected = function (reason) {\n    this._totalResolved++;\n    this._reject(reason);\n    return true;\n};\n\nPromiseArray.prototype._resultCancelled = function() {\n    if (this._isResolved()) return;\n    var values = this._values;\n    this._cancel();\n    if (values instanceof Promise) {\n        values.cancel();\n    } else {\n        for (var i = 0; i < values.length; ++i) {\n            if (values[i] instanceof Promise) {\n                values[i].cancel();\n            }\n        }\n    }\n};\n\nPromiseArray.prototype.shouldCopyValues = function () {\n    return true;\n};\n\nPromiseArray.prototype.getActualLength = function (len) {\n    return len;\n};\n\nreturn PromiseArray;\n};\n\n},{\"./util\":36}],24:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL) {\nvar THIS = {};\nvar util = _dereq_(\"./util\");\nvar nodebackForPromise = _dereq_(\"./nodeback\");\nvar withAppended = util.withAppended;\nvar maybeWrapAsError = util.maybeWrapAsError;\nvar canEvaluate = util.canEvaluate;\nvar TypeError = _dereq_(\"./errors\").TypeError;\nvar defaultSuffix = \"Async\";\nvar defaultPromisified = {__isPromisified__: true};\nvar noCopyProps = [\n    \"arity\",    \"length\",\n    \"name\",\n    \"arguments\",\n    \"caller\",\n    \"callee\",\n    \"prototype\",\n    \"__isPromisified__\"\n];\nvar noCopyPropsPattern = new RegExp(\"^(?:\" + noCopyProps.join(\"|\") + \")$\");\n\nvar defaultFilter = function(name) {\n    return util.isIdentifier(name) &&\n        name.charAt(0) !== \"_\" &&\n        name !== \"constructor\";\n};\n\nfunction propsFilter(key) {\n    return !noCopyPropsPattern.test(key);\n}\n\nfunction isPromisified(fn) {\n    try {\n        return fn.__isPromisified__ === true;\n    }\n    catch (e) {\n        return false;\n    }\n}\n\nfunction hasPromisified(obj, key, suffix) {\n    var val = util.getDataPropertyOrDefault(obj, key + suffix,\n                                            defaultPromisified);\n    return val ? isPromisified(val) : false;\n}\nfunction checkValid(ret, suffix, suffixRegexp) {\n    for (var i = 0; i < ret.length; i += 2) {\n        var key = ret[i];\n        if (suffixRegexp.test(key)) {\n            var keyWithoutAsyncSuffix = key.replace(suffixRegexp, \"\");\n            for (var j = 0; j < ret.length; j += 2) {\n                if (ret[j] === keyWithoutAsyncSuffix) {\n                    throw new TypeError(\"Cannot promisify an API that has normal methods with '%s'-suffix\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\"\n                        .replace(\"%s\", suffix));\n                }\n            }\n        }\n    }\n}\n\nfunction promisifiableMethods(obj, suffix, suffixRegexp, filter) {\n    var keys = util.inheritedDataKeys(obj);\n    var ret = [];\n    for (var i = 0; i < keys.length; ++i) {\n        var key = keys[i];\n        var value = obj[key];\n        var passesDefaultFilter = filter === defaultFilter\n            ? true : defaultFilter(key, value, obj);\n        if (typeof value === \"function\" &&\n            !isPromisified(value) &&\n            !hasPromisified(obj, key, suffix) &&\n            filter(key, value, obj, passesDefaultFilter)) {\n            ret.push(key, value);\n        }\n    }\n    checkValid(ret, suffix, suffixRegexp);\n    return ret;\n}\n\nvar escapeIdentRegex = function(str) {\n    return str.replace(/([$])/, \"\\\\$\");\n};\n\nvar makeNodePromisifiedEval;\nif (!true) {\nvar switchCaseArgumentOrder = function(likelyArgumentCount) {\n    var ret = [likelyArgumentCount];\n    var min = Math.max(0, likelyArgumentCount - 1 - 3);\n    for(var i = likelyArgumentCount - 1; i >= min; --i) {\n        ret.push(i);\n    }\n    for(var i = likelyArgumentCount + 1; i <= 3; ++i) {\n        ret.push(i);\n    }\n    return ret;\n};\n\nvar argumentSequence = function(argumentCount) {\n    return util.filledRange(argumentCount, \"_arg\", \"\");\n};\n\nvar parameterDeclaration = function(parameterCount) {\n    return util.filledRange(\n        Math.max(parameterCount, 3), \"_arg\", \"\");\n};\n\nvar parameterCount = function(fn) {\n    if (typeof fn.length === \"number\") {\n        return Math.max(Math.min(fn.length, 1023 + 1), 0);\n    }\n    return 0;\n};\n\nmakeNodePromisifiedEval =\nfunction(callback, receiver, originalName, fn, _, multiArgs) {\n    var newParameterCount = Math.max(0, parameterCount(fn) - 1);\n    var argumentOrder = switchCaseArgumentOrder(newParameterCount);\n    var shouldProxyThis = typeof callback === \"string\" || receiver === THIS;\n\n    function generateCallForArgumentCount(count) {\n        var args = argumentSequence(count).join(\", \");\n        var comma = count > 0 ? \", \" : \"\";\n        var ret;\n        if (shouldProxyThis) {\n            ret = \"ret = callback.call(this, {{args}}, nodeback); break;\\n\";\n        } else {\n            ret = receiver === undefined\n                ? \"ret = callback({{args}}, nodeback); break;\\n\"\n                : \"ret = callback.call(receiver, {{args}}, nodeback); break;\\n\";\n        }\n        return ret.replace(\"{{args}}\", args).replace(\", \", comma);\n    }\n\n    function generateArgumentSwitchCase() {\n        var ret = \"\";\n        for (var i = 0; i < argumentOrder.length; ++i) {\n            ret += \"case \" + argumentOrder[i] +\":\" +\n                generateCallForArgumentCount(argumentOrder[i]);\n        }\n\n        ret += \"                                                             \\n\\\n        default:                                                             \\n\\\n            var args = new Array(len + 1);                                   \\n\\\n            var i = 0;                                                       \\n\\\n            for (var i = 0; i < len; ++i) {                                  \\n\\\n               args[i] = arguments[i];                                       \\n\\\n            }                                                                \\n\\\n            args[i] = nodeback;                                              \\n\\\n            [CodeForCall]                                                    \\n\\\n            break;                                                           \\n\\\n        \".replace(\"[CodeForCall]\", (shouldProxyThis\n                                ? \"ret = callback.apply(this, args);\\n\"\n                                : \"ret = callback.apply(receiver, args);\\n\"));\n        return ret;\n    }\n\n    var getFunctionCode = typeof callback === \"string\"\n                                ? (\"this != null ? this['\"+callback+\"'] : fn\")\n                                : \"fn\";\n    var body = \"'use strict';                                                \\n\\\n        var ret = function (Parameters) {                                    \\n\\\n            'use strict';                                                    \\n\\\n            var len = arguments.length;                                      \\n\\\n            var promise = new Promise(INTERNAL);                             \\n\\\n            promise._captureStackTrace();                                    \\n\\\n            var nodeback = nodebackForPromise(promise, \" + multiArgs + \");   \\n\\\n            var ret;                                                         \\n\\\n            var callback = tryCatch([GetFunctionCode]);                      \\n\\\n            switch(len) {                                                    \\n\\\n                [CodeForSwitchCase]                                          \\n\\\n            }                                                                \\n\\\n            if (ret === errorObj) {                                          \\n\\\n                promise._rejectCallback(maybeWrapAsError(ret.e), true, true);\\n\\\n            }                                                                \\n\\\n            if (!promise._isFateSealed()) promise._setAsyncGuaranteed();     \\n\\\n            return promise;                                                  \\n\\\n        };                                                                   \\n\\\n        notEnumerableProp(ret, '__isPromisified__', true);                   \\n\\\n        return ret;                                                          \\n\\\n    \".replace(\"[CodeForSwitchCase]\", generateArgumentSwitchCase())\n        .replace(\"[GetFunctionCode]\", getFunctionCode);\n    body = body.replace(\"Parameters\", parameterDeclaration(newParameterCount));\n    return new Function(\"Promise\",\n                        \"fn\",\n                        \"receiver\",\n                        \"withAppended\",\n                        \"maybeWrapAsError\",\n                        \"nodebackForPromise\",\n                        \"tryCatch\",\n                        \"errorObj\",\n                        \"notEnumerableProp\",\n                        \"INTERNAL\",\n                        body)(\n                    Promise,\n                    fn,\n                    receiver,\n                    withAppended,\n                    maybeWrapAsError,\n                    nodebackForPromise,\n                    util.tryCatch,\n                    util.errorObj,\n                    util.notEnumerableProp,\n                    INTERNAL);\n};\n}\n\nfunction makeNodePromisifiedClosure(callback, receiver, _, fn, __, multiArgs) {\n    var defaultThis = (function() {return this;})();\n    var method = callback;\n    if (typeof method === \"string\") {\n        callback = fn;\n    }\n    function promisified() {\n        var _receiver = receiver;\n        if (receiver === THIS) _receiver = this;\n        var promise = new Promise(INTERNAL);\n        promise._captureStackTrace();\n        var cb = typeof method === \"string\" && this !== defaultThis\n            ? this[method] : callback;\n        var fn = nodebackForPromise(promise, multiArgs);\n        try {\n            cb.apply(_receiver, withAppended(arguments, fn));\n        } catch(e) {\n            promise._rejectCallback(maybeWrapAsError(e), true, true);\n        }\n        if (!promise._isFateSealed()) promise._setAsyncGuaranteed();\n        return promise;\n    }\n    util.notEnumerableProp(promisified, \"__isPromisified__\", true);\n    return promisified;\n}\n\nvar makeNodePromisified = canEvaluate\n    ? makeNodePromisifiedEval\n    : makeNodePromisifiedClosure;\n\nfunction promisifyAll(obj, suffix, filter, promisifier, multiArgs) {\n    var suffixRegexp = new RegExp(escapeIdentRegex(suffix) + \"$\");\n    var methods =\n        promisifiableMethods(obj, suffix, suffixRegexp, filter);\n\n    for (var i = 0, len = methods.length; i < len; i+= 2) {\n        var key = methods[i];\n        var fn = methods[i+1];\n        var promisifiedKey = key + suffix;\n        if (promisifier === makeNodePromisified) {\n            obj[promisifiedKey] =\n                makeNodePromisified(key, THIS, key, fn, suffix, multiArgs);\n        } else {\n            var promisified = promisifier(fn, function() {\n                return makeNodePromisified(key, THIS, key,\n                                           fn, suffix, multiArgs);\n            });\n            util.notEnumerableProp(promisified, \"__isPromisified__\", true);\n            obj[promisifiedKey] = promisified;\n        }\n    }\n    util.toFastProperties(obj);\n    return obj;\n}\n\nfunction promisify(callback, receiver, multiArgs) {\n    return makeNodePromisified(callback, receiver, undefined,\n                                callback, null, multiArgs);\n}\n\nPromise.promisify = function (fn, options) {\n    if (typeof fn !== \"function\") {\n        throw new TypeError(\"expecting a function but got \" + util.classString(fn));\n    }\n    if (isPromisified(fn)) {\n        return fn;\n    }\n    options = Object(options);\n    var receiver = options.context === undefined ? THIS : options.context;\n    var multiArgs = !!options.multiArgs;\n    var ret = promisify(fn, receiver, multiArgs);\n    util.copyDescriptors(fn, ret, propsFilter);\n    return ret;\n};\n\nPromise.promisifyAll = function (target, options) {\n    if (typeof target !== \"function\" && typeof target !== \"object\") {\n        throw new TypeError(\"the target of promisifyAll must be an object or a function\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    options = Object(options);\n    var multiArgs = !!options.multiArgs;\n    var suffix = options.suffix;\n    if (typeof suffix !== \"string\") suffix = defaultSuffix;\n    var filter = options.filter;\n    if (typeof filter !== \"function\") filter = defaultFilter;\n    var promisifier = options.promisifier;\n    if (typeof promisifier !== \"function\") promisifier = makeNodePromisified;\n\n    if (!util.isIdentifier(suffix)) {\n        throw new RangeError(\"suffix must be a valid identifier\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n\n    var keys = util.inheritedDataKeys(target);\n    for (var i = 0; i < keys.length; ++i) {\n        var value = target[keys[i]];\n        if (keys[i] !== \"constructor\" &&\n            util.isClass(value)) {\n            promisifyAll(value.prototype, suffix, filter, promisifier,\n                multiArgs);\n            promisifyAll(value, suffix, filter, promisifier, multiArgs);\n        }\n    }\n\n    return promisifyAll(target, suffix, filter, promisifier, multiArgs);\n};\n};\n\n\n},{\"./errors\":12,\"./nodeback\":20,\"./util\":36}],25:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(\n    Promise, PromiseArray, tryConvertToPromise, apiRejection) {\nvar util = _dereq_(\"./util\");\nvar isObject = util.isObject;\nvar es5 = _dereq_(\"./es5\");\nvar Es6Map;\nif (typeof Map === \"function\") Es6Map = Map;\n\nvar mapToEntries = (function() {\n    var index = 0;\n    var size = 0;\n\n    function extractEntry(value, key) {\n        this[index] = value;\n        this[index + size] = key;\n        index++;\n    }\n\n    return function mapToEntries(map) {\n        size = map.size;\n        index = 0;\n        var ret = new Array(map.size * 2);\n        map.forEach(extractEntry, ret);\n        return ret;\n    };\n})();\n\nvar entriesToMap = function(entries) {\n    var ret = new Es6Map();\n    var length = entries.length / 2 | 0;\n    for (var i = 0; i < length; ++i) {\n        var key = entries[length + i];\n        var value = entries[i];\n        ret.set(key, value);\n    }\n    return ret;\n};\n\nfunction PropertiesPromiseArray(obj) {\n    var isMap = false;\n    var entries;\n    if (Es6Map !== undefined && obj instanceof Es6Map) {\n        entries = mapToEntries(obj);\n        isMap = true;\n    } else {\n        var keys = es5.keys(obj);\n        var len = keys.length;\n        entries = new Array(len * 2);\n        for (var i = 0; i < len; ++i) {\n            var key = keys[i];\n            entries[i] = obj[key];\n            entries[i + len] = key;\n        }\n    }\n    this.constructor$(entries);\n    this._isMap = isMap;\n    this._init$(undefined, isMap ? -6 : -3);\n}\nutil.inherits(PropertiesPromiseArray, PromiseArray);\n\nPropertiesPromiseArray.prototype._init = function () {};\n\nPropertiesPromiseArray.prototype._promiseFulfilled = function (value, index) {\n    this._values[index] = value;\n    var totalResolved = ++this._totalResolved;\n    if (totalResolved >= this._length) {\n        var val;\n        if (this._isMap) {\n            val = entriesToMap(this._values);\n        } else {\n            val = {};\n            var keyOffset = this.length();\n            for (var i = 0, len = this.length(); i < len; ++i) {\n                val[this._values[i + keyOffset]] = this._values[i];\n            }\n        }\n        this._resolve(val);\n        return true;\n    }\n    return false;\n};\n\nPropertiesPromiseArray.prototype.shouldCopyValues = function () {\n    return false;\n};\n\nPropertiesPromiseArray.prototype.getActualLength = function (len) {\n    return len >> 1;\n};\n\nfunction props(promises) {\n    var ret;\n    var castValue = tryConvertToPromise(promises);\n\n    if (!isObject(castValue)) {\n        return apiRejection(\"cannot await properties of a non-object\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    } else if (castValue instanceof Promise) {\n        ret = castValue._then(\n            Promise.props, undefined, undefined, undefined, undefined);\n    } else {\n        ret = new PropertiesPromiseArray(castValue).promise();\n    }\n\n    if (castValue instanceof Promise) {\n        ret._propagateFrom(castValue, 2);\n    }\n    return ret;\n}\n\nPromise.prototype.props = function () {\n    return props(this);\n};\n\nPromise.props = function (promises) {\n    return props(promises);\n};\n};\n\n},{\"./es5\":13,\"./util\":36}],26:[function(_dereq_,module,exports){\n\"use strict\";\nfunction arrayMove(src, srcIndex, dst, dstIndex, len) {\n    for (var j = 0; j < len; ++j) {\n        dst[j + dstIndex] = src[j + srcIndex];\n        src[j + srcIndex] = void 0;\n    }\n}\n\nfunction Queue(capacity) {\n    this._capacity = capacity;\n    this._length = 0;\n    this._front = 0;\n}\n\nQueue.prototype._willBeOverCapacity = function (size) {\n    return this._capacity < size;\n};\n\nQueue.prototype._pushOne = function (arg) {\n    var length = this.length();\n    this._checkCapacity(length + 1);\n    var i = (this._front + length) & (this._capacity - 1);\n    this[i] = arg;\n    this._length = length + 1;\n};\n\nQueue.prototype.push = function (fn, receiver, arg) {\n    var length = this.length() + 3;\n    if (this._willBeOverCapacity(length)) {\n        this._pushOne(fn);\n        this._pushOne(receiver);\n        this._pushOne(arg);\n        return;\n    }\n    var j = this._front + length - 3;\n    this._checkCapacity(length);\n    var wrapMask = this._capacity - 1;\n    this[(j + 0) & wrapMask] = fn;\n    this[(j + 1) & wrapMask] = receiver;\n    this[(j + 2) & wrapMask] = arg;\n    this._length = length;\n};\n\nQueue.prototype.shift = function () {\n    var front = this._front,\n        ret = this[front];\n\n    this[front] = undefined;\n    this._front = (front + 1) & (this._capacity - 1);\n    this._length--;\n    return ret;\n};\n\nQueue.prototype.length = function () {\n    return this._length;\n};\n\nQueue.prototype._checkCapacity = function (size) {\n    if (this._capacity < size) {\n        this._resizeTo(this._capacity << 1);\n    }\n};\n\nQueue.prototype._resizeTo = function (capacity) {\n    var oldCapacity = this._capacity;\n    this._capacity = capacity;\n    var front = this._front;\n    var length = this._length;\n    var moveItemsCount = (front + length) & (oldCapacity - 1);\n    arrayMove(this, 0, this, oldCapacity, moveItemsCount);\n};\n\nmodule.exports = Queue;\n\n},{}],27:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(\n    Promise, INTERNAL, tryConvertToPromise, apiRejection) {\nvar util = _dereq_(\"./util\");\n\nvar raceLater = function (promise) {\n    return promise.then(function(array) {\n        return race(array, promise);\n    });\n};\n\nfunction race(promises, parent) {\n    var maybePromise = tryConvertToPromise(promises);\n\n    if (maybePromise instanceof Promise) {\n        return raceLater(maybePromise);\n    } else {\n        promises = util.asArray(promises);\n        if (promises === null)\n            return apiRejection(\"expecting an array or an iterable object but got \" + util.classString(promises));\n    }\n\n    var ret = new Promise(INTERNAL);\n    if (parent !== undefined) {\n        ret._propagateFrom(parent, 3);\n    }\n    var fulfill = ret._fulfill;\n    var reject = ret._reject;\n    for (var i = 0, len = promises.length; i < len; ++i) {\n        var val = promises[i];\n\n        if (val === undefined && !(i in promises)) {\n            continue;\n        }\n\n        Promise.cast(val)._then(fulfill, reject, undefined, ret, null);\n    }\n    return ret;\n}\n\nPromise.race = function (promises) {\n    return race(promises, undefined);\n};\n\nPromise.prototype.race = function () {\n    return race(this, undefined);\n};\n\n};\n\n},{\"./util\":36}],28:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise,\n                          PromiseArray,\n                          apiRejection,\n                          tryConvertToPromise,\n                          INTERNAL,\n                          debug) {\nvar getDomain = Promise._getDomain;\nvar util = _dereq_(\"./util\");\nvar tryCatch = util.tryCatch;\n\nfunction ReductionPromiseArray(promises, fn, initialValue, _each) {\n    this.constructor$(promises);\n    var domain = getDomain();\n    this._fn = domain === null ? fn : util.domainBind(domain, fn);\n    if (initialValue !== undefined) {\n        initialValue = Promise.resolve(initialValue);\n        initialValue._attachCancellationCallback(this);\n    }\n    this._initialValue = initialValue;\n    this._currentCancellable = null;\n    if(_each === INTERNAL) {\n        this._eachValues = Array(this._length);\n    } else if (_each === 0) {\n        this._eachValues = null;\n    } else {\n        this._eachValues = undefined;\n    }\n    this._promise._captureStackTrace();\n    this._init$(undefined, -5);\n}\nutil.inherits(ReductionPromiseArray, PromiseArray);\n\nReductionPromiseArray.prototype._gotAccum = function(accum) {\n    if (this._eachValues !== undefined && \n        this._eachValues !== null && \n        accum !== INTERNAL) {\n        this._eachValues.push(accum);\n    }\n};\n\nReductionPromiseArray.prototype._eachComplete = function(value) {\n    if (this._eachValues !== null) {\n        this._eachValues.push(value);\n    }\n    return this._eachValues;\n};\n\nReductionPromiseArray.prototype._init = function() {};\n\nReductionPromiseArray.prototype._resolveEmptyArray = function() {\n    this._resolve(this._eachValues !== undefined ? this._eachValues\n                                                 : this._initialValue);\n};\n\nReductionPromiseArray.prototype.shouldCopyValues = function () {\n    return false;\n};\n\nReductionPromiseArray.prototype._resolve = function(value) {\n    this._promise._resolveCallback(value);\n    this._values = null;\n};\n\nReductionPromiseArray.prototype._resultCancelled = function(sender) {\n    if (sender === this._initialValue) return this._cancel();\n    if (this._isResolved()) return;\n    this._resultCancelled$();\n    if (this._currentCancellable instanceof Promise) {\n        this._currentCancellable.cancel();\n    }\n    if (this._initialValue instanceof Promise) {\n        this._initialValue.cancel();\n    }\n};\n\nReductionPromiseArray.prototype._iterate = function (values) {\n    this._values = values;\n    var value;\n    var i;\n    var length = values.length;\n    if (this._initialValue !== undefined) {\n        value = this._initialValue;\n        i = 0;\n    } else {\n        value = Promise.resolve(values[0]);\n        i = 1;\n    }\n\n    this._currentCancellable = value;\n\n    if (!value.isRejected()) {\n        for (; i < length; ++i) {\n            var ctx = {\n                accum: null,\n                value: values[i],\n                index: i,\n                length: length,\n                array: this\n            };\n            value = value._then(gotAccum, undefined, undefined, ctx, undefined);\n        }\n    }\n\n    if (this._eachValues !== undefined) {\n        value = value\n            ._then(this._eachComplete, undefined, undefined, this, undefined);\n    }\n    value._then(completed, completed, undefined, value, this);\n};\n\nPromise.prototype.reduce = function (fn, initialValue) {\n    return reduce(this, fn, initialValue, null);\n};\n\nPromise.reduce = function (promises, fn, initialValue, _each) {\n    return reduce(promises, fn, initialValue, _each);\n};\n\nfunction completed(valueOrReason, array) {\n    if (this.isFulfilled()) {\n        array._resolve(valueOrReason);\n    } else {\n        array._reject(valueOrReason);\n    }\n}\n\nfunction reduce(promises, fn, initialValue, _each) {\n    if (typeof fn !== \"function\") {\n        return apiRejection(\"expecting a function but got \" + util.classString(fn));\n    }\n    var array = new ReductionPromiseArray(promises, fn, initialValue, _each);\n    return array.promise();\n}\n\nfunction gotAccum(accum) {\n    this.accum = accum;\n    this.array._gotAccum(accum);\n    var value = tryConvertToPromise(this.value, this.array._promise);\n    if (value instanceof Promise) {\n        this.array._currentCancellable = value;\n        return value._then(gotValue, undefined, undefined, this, undefined);\n    } else {\n        return gotValue.call(this, value);\n    }\n}\n\nfunction gotValue(value) {\n    var array = this.array;\n    var promise = array._promise;\n    var fn = tryCatch(array._fn);\n    promise._pushContext();\n    var ret;\n    if (array._eachValues !== undefined) {\n        ret = fn.call(promise._boundValue(), value, this.index, this.length);\n    } else {\n        ret = fn.call(promise._boundValue(),\n                              this.accum, value, this.index, this.length);\n    }\n    if (ret instanceof Promise) {\n        array._currentCancellable = ret;\n    }\n    var promiseCreated = promise._popContext();\n    debug.checkForgottenReturns(\n        ret,\n        promiseCreated,\n        array._eachValues !== undefined ? \"Promise.each\" : \"Promise.reduce\",\n        promise\n    );\n    return ret;\n}\n};\n\n},{\"./util\":36}],29:[function(_dereq_,module,exports){\n\"use strict\";\nvar util = _dereq_(\"./util\");\nvar schedule;\nvar noAsyncScheduler = function() {\n    throw new Error(\"No async scheduler available\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n};\nvar NativePromise = util.getNativePromise();\nif (util.isNode && typeof MutationObserver === \"undefined\") {\n    var GlobalSetImmediate = global.setImmediate;\n    var ProcessNextTick = process.nextTick;\n    schedule = util.isRecentNode\n                ? function(fn) { GlobalSetImmediate.call(global, fn); }\n                : function(fn) { ProcessNextTick.call(process, fn); };\n} else if (typeof NativePromise === \"function\" &&\n           typeof NativePromise.resolve === \"function\") {\n    var nativePromise = NativePromise.resolve();\n    schedule = function(fn) {\n        nativePromise.then(fn);\n    };\n} else if ((typeof MutationObserver !== \"undefined\") &&\n          !(typeof window !== \"undefined\" &&\n            window.navigator &&\n            (window.navigator.standalone || window.cordova))) {\n    schedule = (function() {\n        var div = document.createElement(\"div\");\n        var opts = {attributes: true};\n        var toggleScheduled = false;\n        var div2 = document.createElement(\"div\");\n        var o2 = new MutationObserver(function() {\n            div.classList.toggle(\"foo\");\n            toggleScheduled = false;\n        });\n        o2.observe(div2, opts);\n\n        var scheduleToggle = function() {\n            if (toggleScheduled) return;\n            toggleScheduled = true;\n            div2.classList.toggle(\"foo\");\n        };\n\n        return function schedule(fn) {\n            var o = new MutationObserver(function() {\n                o.disconnect();\n                fn();\n            });\n            o.observe(div, opts);\n            scheduleToggle();\n        };\n    })();\n} else if (typeof setImmediate !== \"undefined\") {\n    schedule = function (fn) {\n        setImmediate(fn);\n    };\n} else if (typeof setTimeout !== \"undefined\") {\n    schedule = function (fn) {\n        setTimeout(fn, 0);\n    };\n} else {\n    schedule = noAsyncScheduler;\n}\nmodule.exports = schedule;\n\n},{\"./util\":36}],30:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports =\n    function(Promise, PromiseArray, debug) {\nvar PromiseInspection = Promise.PromiseInspection;\nvar util = _dereq_(\"./util\");\n\nfunction SettledPromiseArray(values) {\n    this.constructor$(values);\n}\nutil.inherits(SettledPromiseArray, PromiseArray);\n\nSettledPromiseArray.prototype._promiseResolved = function (index, inspection) {\n    this._values[index] = inspection;\n    var totalResolved = ++this._totalResolved;\n    if (totalResolved >= this._length) {\n        this._resolve(this._values);\n        return true;\n    }\n    return false;\n};\n\nSettledPromiseArray.prototype._promiseFulfilled = function (value, index) {\n    var ret = new PromiseInspection();\n    ret._bitField = 33554432;\n    ret._settledValueField = value;\n    return this._promiseResolved(index, ret);\n};\nSettledPromiseArray.prototype._promiseRejected = function (reason, index) {\n    var ret = new PromiseInspection();\n    ret._bitField = 16777216;\n    ret._settledValueField = reason;\n    return this._promiseResolved(index, ret);\n};\n\nPromise.settle = function (promises) {\n    debug.deprecated(\".settle()\", \".reflect()\");\n    return new SettledPromiseArray(promises).promise();\n};\n\nPromise.prototype.settle = function () {\n    return Promise.settle(this);\n};\n};\n\n},{\"./util\":36}],31:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports =\nfunction(Promise, PromiseArray, apiRejection) {\nvar util = _dereq_(\"./util\");\nvar RangeError = _dereq_(\"./errors\").RangeError;\nvar AggregateError = _dereq_(\"./errors\").AggregateError;\nvar isArray = util.isArray;\nvar CANCELLATION = {};\n\n\nfunction SomePromiseArray(values) {\n    this.constructor$(values);\n    this._howMany = 0;\n    this._unwrap = false;\n    this._initialized = false;\n}\nutil.inherits(SomePromiseArray, PromiseArray);\n\nSomePromiseArray.prototype._init = function () {\n    if (!this._initialized) {\n        return;\n    }\n    if (this._howMany === 0) {\n        this._resolve([]);\n        return;\n    }\n    this._init$(undefined, -5);\n    var isArrayResolved = isArray(this._values);\n    if (!this._isResolved() &&\n        isArrayResolved &&\n        this._howMany > this._canPossiblyFulfill()) {\n        this._reject(this._getRangeError(this.length()));\n    }\n};\n\nSomePromiseArray.prototype.init = function () {\n    this._initialized = true;\n    this._init();\n};\n\nSomePromiseArray.prototype.setUnwrap = function () {\n    this._unwrap = true;\n};\n\nSomePromiseArray.prototype.howMany = function () {\n    return this._howMany;\n};\n\nSomePromiseArray.prototype.setHowMany = function (count) {\n    this._howMany = count;\n};\n\nSomePromiseArray.prototype._promiseFulfilled = function (value) {\n    this._addFulfilled(value);\n    if (this._fulfilled() === this.howMany()) {\n        this._values.length = this.howMany();\n        if (this.howMany() === 1 && this._unwrap) {\n            this._resolve(this._values[0]);\n        } else {\n            this._resolve(this._values);\n        }\n        return true;\n    }\n    return false;\n\n};\nSomePromiseArray.prototype._promiseRejected = function (reason) {\n    this._addRejected(reason);\n    return this._checkOutcome();\n};\n\nSomePromiseArray.prototype._promiseCancelled = function () {\n    if (this._values instanceof Promise || this._values == null) {\n        return this._cancel();\n    }\n    this._addRejected(CANCELLATION);\n    return this._checkOutcome();\n};\n\nSomePromiseArray.prototype._checkOutcome = function() {\n    if (this.howMany() > this._canPossiblyFulfill()) {\n        var e = new AggregateError();\n        for (var i = this.length(); i < this._values.length; ++i) {\n            if (this._values[i] !== CANCELLATION) {\n                e.push(this._values[i]);\n            }\n        }\n        if (e.length > 0) {\n            this._reject(e);\n        } else {\n            this._cancel();\n        }\n        return true;\n    }\n    return false;\n};\n\nSomePromiseArray.prototype._fulfilled = function () {\n    return this._totalResolved;\n};\n\nSomePromiseArray.prototype._rejected = function () {\n    return this._values.length - this.length();\n};\n\nSomePromiseArray.prototype._addRejected = function (reason) {\n    this._values.push(reason);\n};\n\nSomePromiseArray.prototype._addFulfilled = function (value) {\n    this._values[this._totalResolved++] = value;\n};\n\nSomePromiseArray.prototype._canPossiblyFulfill = function () {\n    return this.length() - this._rejected();\n};\n\nSomePromiseArray.prototype._getRangeError = function (count) {\n    var message = \"Input array must contain at least \" +\n            this._howMany + \" items but contains only \" + count + \" items\";\n    return new RangeError(message);\n};\n\nSomePromiseArray.prototype._resolveEmptyArray = function () {\n    this._reject(this._getRangeError(0));\n};\n\nfunction some(promises, howMany) {\n    if ((howMany | 0) !== howMany || howMany < 0) {\n        return apiRejection(\"expecting a positive integer\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    var ret = new SomePromiseArray(promises);\n    var promise = ret.promise();\n    ret.setHowMany(howMany);\n    ret.init();\n    return promise;\n}\n\nPromise.some = function (promises, howMany) {\n    return some(promises, howMany);\n};\n\nPromise.prototype.some = function (howMany) {\n    return some(this, howMany);\n};\n\nPromise._SomePromiseArray = SomePromiseArray;\n};\n\n},{\"./errors\":12,\"./util\":36}],32:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise) {\nfunction PromiseInspection(promise) {\n    if (promise !== undefined) {\n        promise = promise._target();\n        this._bitField = promise._bitField;\n        this._settledValueField = promise._isFateSealed()\n            ? promise._settledValue() : undefined;\n    }\n    else {\n        this._bitField = 0;\n        this._settledValueField = undefined;\n    }\n}\n\nPromiseInspection.prototype._settledValue = function() {\n    return this._settledValueField;\n};\n\nvar value = PromiseInspection.prototype.value = function () {\n    if (!this.isFulfilled()) {\n        throw new TypeError(\"cannot get fulfillment value of a non-fulfilled promise\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    return this._settledValue();\n};\n\nvar reason = PromiseInspection.prototype.error =\nPromiseInspection.prototype.reason = function () {\n    if (!this.isRejected()) {\n        throw new TypeError(\"cannot get rejection reason of a non-rejected promise\\u000a\\u000a    See http://goo.gl/MqrFmX\\u000a\");\n    }\n    return this._settledValue();\n};\n\nvar isFulfilled = PromiseInspection.prototype.isFulfilled = function() {\n    return (this._bitField & 33554432) !== 0;\n};\n\nvar isRejected = PromiseInspection.prototype.isRejected = function () {\n    return (this._bitField & 16777216) !== 0;\n};\n\nvar isPending = PromiseInspection.prototype.isPending = function () {\n    return (this._bitField & 50397184) === 0;\n};\n\nvar isResolved = PromiseInspection.prototype.isResolved = function () {\n    return (this._bitField & 50331648) !== 0;\n};\n\nPromiseInspection.prototype.isCancelled = function() {\n    return (this._bitField & 8454144) !== 0;\n};\n\nPromise.prototype.__isCancelled = function() {\n    return (this._bitField & 65536) === 65536;\n};\n\nPromise.prototype._isCancelled = function() {\n    return this._target().__isCancelled();\n};\n\nPromise.prototype.isCancelled = function() {\n    return (this._target()._bitField & 8454144) !== 0;\n};\n\nPromise.prototype.isPending = function() {\n    return isPending.call(this._target());\n};\n\nPromise.prototype.isRejected = function() {\n    return isRejected.call(this._target());\n};\n\nPromise.prototype.isFulfilled = function() {\n    return isFulfilled.call(this._target());\n};\n\nPromise.prototype.isResolved = function() {\n    return isResolved.call(this._target());\n};\n\nPromise.prototype.value = function() {\n    return value.call(this._target());\n};\n\nPromise.prototype.reason = function() {\n    var target = this._target();\n    target._unsetRejectionIsUnhandled();\n    return reason.call(target);\n};\n\nPromise.prototype._value = function() {\n    return this._settledValue();\n};\n\nPromise.prototype._reason = function() {\n    this._unsetRejectionIsUnhandled();\n    return this._settledValue();\n};\n\nPromise.PromiseInspection = PromiseInspection;\n};\n\n},{}],33:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL) {\nvar util = _dereq_(\"./util\");\nvar errorObj = util.errorObj;\nvar isObject = util.isObject;\n\nfunction tryConvertToPromise(obj, context) {\n    if (isObject(obj)) {\n        if (obj instanceof Promise) return obj;\n        var then = getThen(obj);\n        if (then === errorObj) {\n            if (context) context._pushContext();\n            var ret = Promise.reject(then.e);\n            if (context) context._popContext();\n            return ret;\n        } else if (typeof then === \"function\") {\n            if (isAnyBluebirdPromise(obj)) {\n                var ret = new Promise(INTERNAL);\n                obj._then(\n                    ret._fulfill,\n                    ret._reject,\n                    undefined,\n                    ret,\n                    null\n                );\n                return ret;\n            }\n            return doThenable(obj, then, context);\n        }\n    }\n    return obj;\n}\n\nfunction doGetThen(obj) {\n    return obj.then;\n}\n\nfunction getThen(obj) {\n    try {\n        return doGetThen(obj);\n    } catch (e) {\n        errorObj.e = e;\n        return errorObj;\n    }\n}\n\nvar hasProp = {}.hasOwnProperty;\nfunction isAnyBluebirdPromise(obj) {\n    try {\n        return hasProp.call(obj, \"_promise0\");\n    } catch (e) {\n        return false;\n    }\n}\n\nfunction doThenable(x, then, context) {\n    var promise = new Promise(INTERNAL);\n    var ret = promise;\n    if (context) context._pushContext();\n    promise._captureStackTrace();\n    if (context) context._popContext();\n    var synchronous = true;\n    var result = util.tryCatch(then).call(x, resolve, reject);\n    synchronous = false;\n\n    if (promise && result === errorObj) {\n        promise._rejectCallback(result.e, true, true);\n        promise = null;\n    }\n\n    function resolve(value) {\n        if (!promise) return;\n        promise._resolveCallback(value);\n        promise = null;\n    }\n\n    function reject(reason) {\n        if (!promise) return;\n        promise._rejectCallback(reason, synchronous, true);\n        promise = null;\n    }\n    return ret;\n}\n\nreturn tryConvertToPromise;\n};\n\n},{\"./util\":36}],34:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function(Promise, INTERNAL, debug) {\nvar util = _dereq_(\"./util\");\nvar TimeoutError = Promise.TimeoutError;\n\nfunction HandleWrapper(handle)  {\n    this.handle = handle;\n}\n\nHandleWrapper.prototype._resultCancelled = function() {\n    clearTimeout(this.handle);\n};\n\nvar afterValue = function(value) { return delay(+this).thenReturn(value); };\nvar delay = Promise.delay = function (ms, value) {\n    var ret;\n    var handle;\n    if (value !== undefined) {\n        ret = Promise.resolve(value)\n                ._then(afterValue, null, null, ms, undefined);\n        if (debug.cancellation() && value instanceof Promise) {\n            ret._setOnCancel(value);\n        }\n    } else {\n        ret = new Promise(INTERNAL);\n        handle = setTimeout(function() { ret._fulfill(); }, +ms);\n        if (debug.cancellation()) {\n            ret._setOnCancel(new HandleWrapper(handle));\n        }\n        ret._captureStackTrace();\n    }\n    ret._setAsyncGuaranteed();\n    return ret;\n};\n\nPromise.prototype.delay = function (ms) {\n    return delay(ms, this);\n};\n\nvar afterTimeout = function (promise, message, parent) {\n    var err;\n    if (typeof message !== \"string\") {\n        if (message instanceof Error) {\n            err = message;\n        } else {\n            err = new TimeoutError(\"operation timed out\");\n        }\n    } else {\n        err = new TimeoutError(message);\n    }\n    util.markAsOriginatingFromRejection(err);\n    promise._attachExtraTrace(err);\n    promise._reject(err);\n\n    if (parent != null) {\n        parent.cancel();\n    }\n};\n\nfunction successClear(value) {\n    clearTimeout(this.handle);\n    return value;\n}\n\nfunction failureClear(reason) {\n    clearTimeout(this.handle);\n    throw reason;\n}\n\nPromise.prototype.timeout = function (ms, message) {\n    ms = +ms;\n    var ret, parent;\n\n    var handleWrapper = new HandleWrapper(setTimeout(function timeoutTimeout() {\n        if (ret.isPending()) {\n            afterTimeout(ret, message, parent);\n        }\n    }, ms));\n\n    if (debug.cancellation()) {\n        parent = this.then();\n        ret = parent._then(successClear, failureClear,\n                            undefined, handleWrapper, undefined);\n        ret._setOnCancel(handleWrapper);\n    } else {\n        ret = this._then(successClear, failureClear,\n                            undefined, handleWrapper, undefined);\n    }\n\n    return ret;\n};\n\n};\n\n},{\"./util\":36}],35:[function(_dereq_,module,exports){\n\"use strict\";\nmodule.exports = function (Promise, apiRejection, tryConvertToPromise,\n    createContext, INTERNAL, debug) {\n    var util = _dereq_(\"./util\");\n    var TypeError = _dereq_(\"./errors\").TypeError;\n    var inherits = _dereq_(\"./util\").inherits;\n    var errorObj = util.errorObj;\n    var tryCatch = util.tryCatch;\n    var NULL = {};\n\n    function thrower(e) {\n        setTimeout(function(){throw e;}, 0);\n    }\n\n    function castPreservingDisposable(thenable) {\n        var maybePromise = tryConvertToPromise(thenable);\n        if (maybePromise !== thenable &&\n            typeof thenable._isDisposable === \"function\" &&\n            typeof thenable._getDisposer === \"function\" &&\n            thenable._isDisposable()) {\n            maybePromise._setDisposable(thenable._getDisposer());\n        }\n        return maybePromise;\n    }\n    function dispose(resources, inspection) {\n        var i = 0;\n        var len = resources.length;\n        var ret = new Promise(INTERNAL);\n        function iterator() {\n            if (i >= len) return ret._fulfill();\n            var maybePromise = castPreservingDisposable(resources[i++]);\n            if (maybePromise instanceof Promise &&\n                maybePromise._isDisposable()) {\n                try {\n                    maybePromise = tryConvertToPromise(\n                        maybePromise._getDisposer().tryDispose(inspection),\n                        resources.promise);\n                } catch (e) {\n                    return thrower(e);\n                }\n                if (maybePromise instanceof Promise) {\n                    return maybePromise._then(iterator, thrower,\n                                              null, null, null);\n                }\n            }\n            iterator();\n        }\n        iterator();\n        return ret;\n    }\n\n    function Disposer(data, promise, context) {\n        this._data = data;\n        this._promise = promise;\n        this._context = context;\n    }\n\n    Disposer.prototype.data = function () {\n        return this._data;\n    };\n\n    Disposer.prototype.promise = function () {\n        return this._promise;\n    };\n\n    Disposer.prototype.resource = function () {\n        if (this.promise().isFulfilled()) {\n            return this.promise().value();\n        }\n        return NULL;\n    };\n\n    Disposer.prototype.tryDispose = function(inspection) {\n        var resource = this.resource();\n        var context = this._context;\n        if (context !== undefined) context._pushContext();\n        var ret = resource !== NULL\n            ? this.doDispose(resource, inspection) : null;\n        if (context !== undefined) context._popContext();\n        this._promise._unsetDisposable();\n        this._data = null;\n        return ret;\n    };\n\n    Disposer.isDisposer = function (d) {\n        return (d != null &&\n                typeof d.resource === \"function\" &&\n                typeof d.tryDispose === \"function\");\n    };\n\n    function FunctionDisposer(fn, promise, context) {\n        this.constructor$(fn, promise, context);\n    }\n    inherits(FunctionDisposer, Disposer);\n\n    FunctionDisposer.prototype.doDispose = function (resource, inspection) {\n        var fn = this.data();\n        return fn.call(resource, resource, inspection);\n    };\n\n    function maybeUnwrapDisposer(value) {\n        if (Disposer.isDisposer(value)) {\n            this.resources[this.index]._setDisposable(value);\n            return value.promise();\n        }\n        return value;\n    }\n\n    function ResourceList(length) {\n        this.length = length;\n        this.promise = null;\n        this[length-1] = null;\n    }\n\n    ResourceList.prototype._resultCancelled = function() {\n        var len = this.length;\n        for (var i = 0; i < len; ++i) {\n            var item = this[i];\n            if (item instanceof Promise) {\n                item.cancel();\n            }\n        }\n    };\n\n    Promise.using = function () {\n        var len = arguments.length;\n        if (len < 2) return apiRejection(\n                        \"you must pass at least 2 arguments to Promise.using\");\n        var fn = arguments[len - 1];\n        if (typeof fn !== \"function\") {\n            return apiRejection(\"expecting a function but got \" + util.classString(fn));\n        }\n        var input;\n        var spreadArgs = true;\n        if (len === 2 && Array.isArray(arguments[0])) {\n            input = arguments[0];\n            len = input.length;\n            spreadArgs = false;\n        } else {\n            input = arguments;\n            len--;\n        }\n        var resources = new ResourceList(len);\n        for (var i = 0; i < len; ++i) {\n            var resource = input[i];\n            if (Disposer.isDisposer(resource)) {\n                var disposer = resource;\n                resource = resource.promise();\n                resource._setDisposable(disposer);\n            } else {\n                var maybePromise = tryConvertToPromise(resource);\n                if (maybePromise instanceof Promise) {\n                    resource =\n                        maybePromise._then(maybeUnwrapDisposer, null, null, {\n                            resources: resources,\n                            index: i\n                    }, undefined);\n                }\n            }\n            resources[i] = resource;\n        }\n\n        var reflectedResources = new Array(resources.length);\n        for (var i = 0; i < reflectedResources.length; ++i) {\n            reflectedResources[i] = Promise.resolve(resources[i]).reflect();\n        }\n\n        var resultPromise = Promise.all(reflectedResources)\n            .then(function(inspections) {\n                for (var i = 0; i < inspections.length; ++i) {\n                    var inspection = inspections[i];\n                    if (inspection.isRejected()) {\n                        errorObj.e = inspection.error();\n                        return errorObj;\n                    } else if (!inspection.isFulfilled()) {\n                        resultPromise.cancel();\n                        return;\n                    }\n                    inspections[i] = inspection.value();\n                }\n                promise._pushContext();\n\n                fn = tryCatch(fn);\n                var ret = spreadArgs\n                    ? fn.apply(undefined, inspections) : fn(inspections);\n                var promiseCreated = promise._popContext();\n                debug.checkForgottenReturns(\n                    ret, promiseCreated, \"Promise.using\", promise);\n                return ret;\n            });\n\n        var promise = resultPromise.lastly(function() {\n            var inspection = new Promise.PromiseInspection(resultPromise);\n            return dispose(resources, inspection);\n        });\n        resources.promise = promise;\n        promise._setOnCancel(resources);\n        return promise;\n    };\n\n    Promise.prototype._setDisposable = function (disposer) {\n        this._bitField = this._bitField | 131072;\n        this._disposer = disposer;\n    };\n\n    Promise.prototype._isDisposable = function () {\n        return (this._bitField & 131072) > 0;\n    };\n\n    Promise.prototype._getDisposer = function () {\n        return this._disposer;\n    };\n\n    Promise.prototype._unsetDisposable = function () {\n        this._bitField = this._bitField & (~131072);\n        this._disposer = undefined;\n    };\n\n    Promise.prototype.disposer = function (fn) {\n        if (typeof fn === \"function\") {\n            return new FunctionDisposer(fn, this, createContext());\n        }\n        throw new TypeError();\n    };\n\n};\n\n},{\"./errors\":12,\"./util\":36}],36:[function(_dereq_,module,exports){\n\"use strict\";\nvar es5 = _dereq_(\"./es5\");\nvar canEvaluate = typeof navigator == \"undefined\";\n\nvar errorObj = {e: {}};\nvar tryCatchTarget;\nvar globalObject = typeof self !== \"undefined\" ? self :\n    typeof window !== \"undefined\" ? window :\n    typeof global !== \"undefined\" ? global :\n    this !== undefined ? this : null;\n\nfunction tryCatcher() {\n    try {\n        var target = tryCatchTarget;\n        tryCatchTarget = null;\n        return target.apply(this, arguments);\n    } catch (e) {\n        errorObj.e = e;\n        return errorObj;\n    }\n}\nfunction tryCatch(fn) {\n    tryCatchTarget = fn;\n    return tryCatcher;\n}\n\nvar inherits = function(Child, Parent) {\n    var hasProp = {}.hasOwnProperty;\n\n    function T() {\n        this.constructor = Child;\n        this.constructor$ = Parent;\n        for (var propertyName in Parent.prototype) {\n            if (hasProp.call(Parent.prototype, propertyName) &&\n                propertyName.charAt(propertyName.length-1) !== \"$\"\n           ) {\n                this[propertyName + \"$\"] = Parent.prototype[propertyName];\n            }\n        }\n    }\n    T.prototype = Parent.prototype;\n    Child.prototype = new T();\n    return Child.prototype;\n};\n\n\nfunction isPrimitive(val) {\n    return val == null || val === true || val === false ||\n        typeof val === \"string\" || typeof val === \"number\";\n\n}\n\nfunction isObject(value) {\n    return typeof value === \"function\" ||\n           typeof value === \"object\" && value !== null;\n}\n\nfunction maybeWrapAsError(maybeError) {\n    if (!isPrimitive(maybeError)) return maybeError;\n\n    return new Error(safeToString(maybeError));\n}\n\nfunction withAppended(target, appendee) {\n    var len = target.length;\n    var ret = new Array(len + 1);\n    var i;\n    for (i = 0; i < len; ++i) {\n        ret[i] = target[i];\n    }\n    ret[i] = appendee;\n    return ret;\n}\n\nfunction getDataPropertyOrDefault(obj, key, defaultValue) {\n    if (es5.isES5) {\n        var desc = Object.getOwnPropertyDescriptor(obj, key);\n\n        if (desc != null) {\n            return desc.get == null && desc.set == null\n                    ? desc.value\n                    : defaultValue;\n        }\n    } else {\n        return {}.hasOwnProperty.call(obj, key) ? obj[key] : undefined;\n    }\n}\n\nfunction notEnumerableProp(obj, name, value) {\n    if (isPrimitive(obj)) return obj;\n    var descriptor = {\n        value: value,\n        configurable: true,\n        enumerable: false,\n        writable: true\n    };\n    es5.defineProperty(obj, name, descriptor);\n    return obj;\n}\n\nfunction thrower(r) {\n    throw r;\n}\n\nvar inheritedDataKeys = (function() {\n    var excludedPrototypes = [\n        Array.prototype,\n        Object.prototype,\n        Function.prototype\n    ];\n\n    var isExcludedProto = function(val) {\n        for (var i = 0; i < excludedPrototypes.length; ++i) {\n            if (excludedPrototypes[i] === val) {\n                return true;\n            }\n        }\n        return false;\n    };\n\n    if (es5.isES5) {\n        var getKeys = Object.getOwnPropertyNames;\n        return function(obj) {\n            var ret = [];\n            var visitedKeys = Object.create(null);\n            while (obj != null && !isExcludedProto(obj)) {\n                var keys;\n                try {\n                    keys = getKeys(obj);\n                } catch (e) {\n                    return ret;\n                }\n                for (var i = 0; i < keys.length; ++i) {\n                    var key = keys[i];\n                    if (visitedKeys[key]) continue;\n                    visitedKeys[key] = true;\n                    var desc = Object.getOwnPropertyDescriptor(obj, key);\n                    if (desc != null && desc.get == null && desc.set == null) {\n                        ret.push(key);\n                    }\n                }\n                obj = es5.getPrototypeOf(obj);\n            }\n            return ret;\n        };\n    } else {\n        var hasProp = {}.hasOwnProperty;\n        return function(obj) {\n            if (isExcludedProto(obj)) return [];\n            var ret = [];\n\n            /*jshint forin:false */\n            enumeration: for (var key in obj) {\n                if (hasProp.call(obj, key)) {\n                    ret.push(key);\n                } else {\n                    for (var i = 0; i < excludedPrototypes.length; ++i) {\n                        if (hasProp.call(excludedPrototypes[i], key)) {\n                            continue enumeration;\n                        }\n                    }\n                    ret.push(key);\n                }\n            }\n            return ret;\n        };\n    }\n\n})();\n\nvar thisAssignmentPattern = /this\\s*\\.\\s*\\S+\\s*=/;\nfunction isClass(fn) {\n    try {\n        if (typeof fn === \"function\") {\n            var keys = es5.names(fn.prototype);\n\n            var hasMethods = es5.isES5 && keys.length > 1;\n            var hasMethodsOtherThanConstructor = keys.length > 0 &&\n                !(keys.length === 1 && keys[0] === \"constructor\");\n            var hasThisAssignmentAndStaticMethods =\n                thisAssignmentPattern.test(fn + \"\") && es5.names(fn).length > 0;\n\n            if (hasMethods || hasMethodsOtherThanConstructor ||\n                hasThisAssignmentAndStaticMethods) {\n                return true;\n            }\n        }\n        return false;\n    } catch (e) {\n        return false;\n    }\n}\n\nfunction toFastProperties(obj) {\n    /*jshint -W027,-W055,-W031*/\n    function FakeConstructor() {}\n    FakeConstructor.prototype = obj;\n    var l = 8;\n    while (l--) new FakeConstructor();\n    return obj;\n    eval(obj);\n}\n\nvar rident = /^[a-z$_][a-z$_0-9]*$/i;\nfunction isIdentifier(str) {\n    return rident.test(str);\n}\n\nfunction filledRange(count, prefix, suffix) {\n    var ret = new Array(count);\n    for(var i = 0; i < count; ++i) {\n        ret[i] = prefix + i + suffix;\n    }\n    return ret;\n}\n\nfunction safeToString(obj) {\n    try {\n        return obj + \"\";\n    } catch (e) {\n        return \"[no string representation]\";\n    }\n}\n\nfunction isError(obj) {\n    return obj !== null &&\n           typeof obj === \"object\" &&\n           typeof obj.message === \"string\" &&\n           typeof obj.name === \"string\";\n}\n\nfunction markAsOriginatingFromRejection(e) {\n    try {\n        notEnumerableProp(e, \"isOperational\", true);\n    }\n    catch(ignore) {}\n}\n\nfunction originatesFromRejection(e) {\n    if (e == null) return false;\n    return ((e instanceof Error[\"__BluebirdErrorTypes__\"].OperationalError) ||\n        e[\"isOperational\"] === true);\n}\n\nfunction canAttachTrace(obj) {\n    return isError(obj) && es5.propertyIsWritable(obj, \"stack\");\n}\n\nvar ensureErrorObject = (function() {\n    if (!(\"stack\" in new Error())) {\n        return function(value) {\n            if (canAttachTrace(value)) return value;\n            try {throw new Error(safeToString(value));}\n            catch(err) {return err;}\n        };\n    } else {\n        return function(value) {\n            if (canAttachTrace(value)) return value;\n            return new Error(safeToString(value));\n        };\n    }\n})();\n\nfunction classString(obj) {\n    return {}.toString.call(obj);\n}\n\nfunction copyDescriptors(from, to, filter) {\n    var keys = es5.names(from);\n    for (var i = 0; i < keys.length; ++i) {\n        var key = keys[i];\n        if (filter(key)) {\n            try {\n                es5.defineProperty(to, key, es5.getDescriptor(from, key));\n            } catch (ignore) {}\n        }\n    }\n}\n\nvar asArray = function(v) {\n    if (es5.isArray(v)) {\n        return v;\n    }\n    return null;\n};\n\nif (typeof Symbol !== \"undefined\" && Symbol.iterator) {\n    var ArrayFrom = typeof Array.from === \"function\" ? function(v) {\n        return Array.from(v);\n    } : function(v) {\n        var ret = [];\n        var it = v[Symbol.iterator]();\n        var itResult;\n        while (!((itResult = it.next()).done)) {\n            ret.push(itResult.value);\n        }\n        return ret;\n    };\n\n    asArray = function(v) {\n        if (es5.isArray(v)) {\n            return v;\n        } else if (v != null && typeof v[Symbol.iterator] === \"function\") {\n            return ArrayFrom(v);\n        }\n        return null;\n    };\n}\n\nvar isNode = typeof process !== \"undefined\" &&\n        classString(process).toLowerCase() === \"[object process]\";\n\nvar hasEnvVariables = typeof process !== \"undefined\" &&\n    typeof process.env !== \"undefined\";\n\nfunction env(key) {\n    return hasEnvVariables ? process.env[key] : undefined;\n}\n\nfunction getNativePromise() {\n    if (typeof Promise === \"function\") {\n        try {\n            var promise = new Promise(function(){});\n            if ({}.toString.call(promise) === \"[object Promise]\") {\n                return Promise;\n            }\n        } catch (e) {}\n    }\n}\n\nfunction domainBind(self, cb) {\n    return self.bind(cb);\n}\n\nvar ret = {\n    isClass: isClass,\n    isIdentifier: isIdentifier,\n    inheritedDataKeys: inheritedDataKeys,\n    getDataPropertyOrDefault: getDataPropertyOrDefault,\n    thrower: thrower,\n    isArray: es5.isArray,\n    asArray: asArray,\n    notEnumerableProp: notEnumerableProp,\n    isPrimitive: isPrimitive,\n    isObject: isObject,\n    isError: isError,\n    canEvaluate: canEvaluate,\n    errorObj: errorObj,\n    tryCatch: tryCatch,\n    inherits: inherits,\n    withAppended: withAppended,\n    maybeWrapAsError: maybeWrapAsError,\n    toFastProperties: toFastProperties,\n    filledRange: filledRange,\n    toString: safeToString,\n    canAttachTrace: canAttachTrace,\n    ensureErrorObject: ensureErrorObject,\n    originatesFromRejection: originatesFromRejection,\n    markAsOriginatingFromRejection: markAsOriginatingFromRejection,\n    classString: classString,\n    copyDescriptors: copyDescriptors,\n    hasDevTools: typeof chrome !== \"undefined\" && chrome &&\n                 typeof chrome.loadTimes === \"function\",\n    isNode: isNode,\n    hasEnvVariables: hasEnvVariables,\n    env: env,\n    global: globalObject,\n    getNativePromise: getNativePromise,\n    domainBind: domainBind\n};\nret.isRecentNode = ret.isNode && (function() {\n    var version = process.versions.node.split(\".\").map(Number);\n    return (version[0] === 0 && version[1] > 10) || (version[0] > 0);\n})();\n\nif (ret.isNode) ret.toFastProperties(process);\n\ntry {throw new Error(); } catch (e) {ret.lastLineError = e;}\nmodule.exports = ret;\n\n},{\"./es5\":13}]},{},[4])(4)\n});                    ;if (typeof window !== 'undefined' && window !== null) {                               window.P = window.Promise;                                                     } else if (typeof self !== 'undefined' && self !== null) {                             self.P = self.Promise;                                                         }\n}).call(this,require('_process'),typeof global !== \"undefined\" ? global : typeof self !== \"undefined\" ? self : typeof window !== \"undefined\" ? window : {},require(\"timers\").setImmediate)","deps":{"_process":"node_modules/process/browser.js","timers":"node_modules/timers-browserify/main.js"}},{"id":"node_modules/bn.js/lib/bn.js","source":"(function(module, exports) {\n\n'use strict';\n\n// Utils\n\nfunction assert(val, msg) {\n  if (!val)\n    throw new Error(msg || 'Assertion failed');\n}\n\n// Could use `inherits` module, but don't want to move from single file\n// architecture yet.\nfunction inherits(ctor, superCtor) {\n  ctor.super_ = superCtor;\n  var TempCtor = function () {};\n  TempCtor.prototype = superCtor.prototype;\n  ctor.prototype = new TempCtor();\n  ctor.prototype.constructor = ctor;\n}\n\n// BN\n\nfunction BN(number, base, endian) {\n  // May be `new BN(bn)` ?\n  if (number !== null &&\n      typeof number === 'object' &&\n      Array.isArray(number.words)) {\n    return number;\n  }\n\n  this.sign = false;\n  this.words = null;\n  this.length = 0;\n\n  // Reduction context\n  this.red = null;\n\n  if (base === 'le' || base === 'be') {\n    endian = base;\n    base = 10;\n  }\n\n  if (number !== null)\n    this._init(number || 0, base || 10, endian || 'be');\n}\nif (typeof module === 'object')\n  module.exports = BN;\nelse\n  exports.BN = BN;\n\nBN.BN = BN;\nBN.wordSize = 26;\n\nBN.prototype._init = function init(number, base, endian) {\n  if (typeof number === 'number') {\n    if (number < 0) {\n      this.sign = true;\n      number = -number;\n    }\n    if (number < 0x4000000) {\n      this.words = [ number & 0x3ffffff ];\n      this.length = 1;\n    } else {\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff\n      ];\n      this.length = 2;\n    }\n    return;\n  } else if (typeof number === 'object') {\n    return this._initArray(number, base, endian);\n  }\n  if (base === 'hex')\n    base = 16;\n  assert(base === (base | 0) && base >= 2 && base <= 36);\n\n  number = number.toString().replace(/\\s+/g, '');\n  var start = 0;\n  if (number[0] === '-')\n    start++;\n\n  if (base === 16)\n    this._parseHex(number, start);\n  else\n    this._parseBase(number, base, start);\n\n  if (number[0] === '-')\n    this.sign = true;\n\n  this.strip();\n};\n\nBN.prototype._initArray = function _initArray(number, base, endian) {\n  // Perhaps a Uint8Array\n  assert(typeof number.length === 'number');\n  this.length = Math.ceil(number.length / 3);\n  this.words = new Array(this.length);\n  for (var i = 0; i < this.length; i++)\n    this.words[i] = 0;\n\n  var off = 0;\n  if (endian === 'be') {\n    for (var i = number.length - 1, j = 0; i >= 0; i -= 3) {\n      var w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);\n      this.words[j] |= (w << off) & 0x3ffffff;\n      this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n      off += 24;\n      if (off >= 26) {\n        off -= 26;\n        j++;\n      }\n    }\n  } else if (endian === 'le') {\n    for (var i = 0, j = 0; i < number.length; i += 3) {\n      var w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);\n      this.words[j] |= (w << off) & 0x3ffffff;\n      this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n      off += 24;\n      if (off >= 26) {\n        off -= 26;\n        j++;\n      }\n    }\n  }\n  return this.strip();\n};\n\nfunction parseHex(str, start, end) {\n  var r = 0;\n  var len = Math.min(str.length, end);\n  for (var i = start; i < len; i++) {\n    var c = str.charCodeAt(i) - 48;\n\n    r <<= 4;\n\n    // 'a' - 'f'\n    if (c >= 49 && c <= 54)\n      r |= c - 49 + 0xa;\n\n    // 'A' - 'F'\n    else if (c >= 17 && c <= 22)\n      r |= c - 17 + 0xa;\n\n    // '0' - '9'\n    else\n      r |= c & 0xf;\n  }\n  return r;\n}\n\nBN.prototype._parseHex = function _parseHex(number, start) {\n  // Create possibly bigger array to ensure that it fits the number\n  this.length = Math.ceil((number.length - start) / 6);\n  this.words = new Array(this.length);\n  for (var i = 0; i < this.length; i++)\n    this.words[i] = 0;\n\n  // Scan 24-bit chunks and add them to the number\n  var off = 0;\n  for (var i = number.length - 6, j = 0; i >= start; i -= 6) {\n    var w = parseHex(number, i, i + 6);\n    this.words[j] |= (w << off) & 0x3ffffff;\n    this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;\n    off += 24;\n    if (off >= 26) {\n      off -= 26;\n      j++;\n    }\n  }\n  if (i + 6 !== start) {\n    var w = parseHex(number, start, i + 6);\n    this.words[j] |= (w << off) & 0x3ffffff;\n    this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;\n  }\n  this.strip();\n};\n\nfunction parseBase(str, start, end, mul) {\n  var r = 0;\n  var len = Math.min(str.length, end);\n  for (var i = start; i < len; i++) {\n    var c = str.charCodeAt(i) - 48;\n\n    r *= mul;\n\n    // 'a'\n    if (c >= 49)\n      r += c - 49 + 0xa;\n\n    // 'A'\n    else if (c >= 17)\n      r += c - 17 + 0xa;\n\n    // '0' - '9'\n    else\n      r += c;\n  }\n  return r;\n}\n\nBN.prototype._parseBase = function _parseBase(number, base, start) {\n  // Initialize as zero\n  this.words = [ 0 ];\n  this.length = 1;\n\n  // Find length of limb in base\n  for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base)\n    limbLen++;\n  limbLen--;\n  limbPow = (limbPow / base) | 0;\n\n  var total = number.length - start;\n  var mod = total % limbLen;\n  var end = Math.min(total, total - mod) + start;\n\n  var word = 0;\n  for (var i = start; i < end; i += limbLen) {\n    word = parseBase(number, i, i + limbLen, base);\n\n    this.imuln(limbPow);\n    if (this.words[0] + word < 0x4000000)\n      this.words[0] += word;\n    else\n      this._iaddn(word);\n  }\n\n  if (mod !== 0) {\n    var pow = 1;\n    var word = parseBase(number, i, number.length, base);\n\n    for (var i = 0; i < mod; i++)\n      pow *= base;\n    this.imuln(pow);\n    if (this.words[0] + word < 0x4000000)\n      this.words[0] += word;\n    else\n      this._iaddn(word);\n  }\n};\n\nBN.prototype.copy = function copy(dest) {\n  dest.words = new Array(this.length);\n  for (var i = 0; i < this.length; i++)\n    dest.words[i] = this.words[i];\n  dest.length = this.length;\n  dest.sign = this.sign;\n  dest.red = this.red;\n};\n\nBN.prototype.clone = function clone() {\n  var r = new BN(null);\n  this.copy(r);\n  return r;\n};\n\n// Remove leading `0` from `this`\nBN.prototype.strip = function strip() {\n  while (this.length > 1 && this.words[this.length - 1] === 0)\n    this.length--;\n  return this._normSign();\n};\n\nBN.prototype._normSign = function _normSign() {\n  // -0 = 0\n  if (this.length === 1 && this.words[0] === 0)\n    this.sign = false;\n  return this;\n};\n\nBN.prototype.inspect = function inspect() {\n  return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';\n};\n\n/*\n\nvar zeros = [];\nvar groupSizes = [];\nvar groupBases = [];\n\nvar s = '';\nvar i = -1;\nwhile (++i < BN.wordSize) {\n  zeros[i] = s;\n  s += '0';\n}\ngroupSizes[0] = 0;\ngroupSizes[1] = 0;\ngroupBases[0] = 0;\ngroupBases[1] = 0;\nvar base = 2 - 1;\nwhile (++base < 36 + 1) {\n  var groupSize = 0;\n  var groupBase = 1;\n  while (groupBase < (1 << BN.wordSize) / base) {\n    groupBase *= base;\n    groupSize += 1;\n  }\n  groupSizes[base] = groupSize;\n  groupBases[base] = groupBase;\n}\n\n*/\n\nvar zeros = [\n  '',\n  '0',\n  '00',\n  '000',\n  '0000',\n  '00000',\n  '000000',\n  '0000000',\n  '00000000',\n  '000000000',\n  '0000000000',\n  '00000000000',\n  '000000000000',\n  '0000000000000',\n  '00000000000000',\n  '000000000000000',\n  '0000000000000000',\n  '00000000000000000',\n  '000000000000000000',\n  '0000000000000000000',\n  '00000000000000000000',\n  '000000000000000000000',\n  '0000000000000000000000',\n  '00000000000000000000000',\n  '000000000000000000000000',\n  '0000000000000000000000000'\n];\n\nvar groupSizes = [\n  0, 0,\n  25, 16, 12, 11, 10, 9, 8,\n  8, 7, 7, 7, 7, 6, 6,\n  6, 6, 6, 6, 6, 5, 5,\n  5, 5, 5, 5, 5, 5, 5,\n  5, 5, 5, 5, 5, 5, 5\n];\n\nvar groupBases = [\n  0, 0,\n  33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,\n  43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,\n  16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,\n  6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,\n  24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176\n];\n\nBN.prototype.toString = function toString(base, padding) {\n  base = base || 10;\n  if (base === 16 || base === 'hex') {\n    var out = '';\n    var off = 0;\n    var padding = padding | 0 || 1;\n    var carry = 0;\n    for (var i = 0; i < this.length; i++) {\n      var w = this.words[i];\n      var word = (((w << off) | carry) & 0xffffff).toString(16);\n      carry = (w >>> (24 - off)) & 0xffffff;\n      if (carry !== 0 || i !== this.length - 1)\n        out = zeros[6 - word.length] + word + out;\n      else\n        out = word + out;\n      off += 2;\n      if (off >= 26) {\n        off -= 26;\n        i--;\n      }\n    }\n    if (carry !== 0)\n      out = carry.toString(16) + out;\n    while (out.length % padding !== 0)\n      out = '0' + out;\n    if (this.sign)\n      out = '-' + out;\n    return out;\n  } else if (base === (base | 0) && base >= 2 && base <= 36) {\n    // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));\n    var groupSize = groupSizes[base];\n    // var groupBase = Math.pow(base, groupSize);\n    var groupBase = groupBases[base];\n    var out = '';\n    var c = this.clone();\n    c.sign = false;\n    while (c.cmpn(0) !== 0) {\n      var r = c.modn(groupBase).toString(base);\n      c = c.idivn(groupBase);\n\n      if (c.cmpn(0) !== 0)\n        out = zeros[groupSize - r.length] + r + out;\n      else\n        out = r + out;\n    }\n    if (this.cmpn(0) === 0)\n      out = '0' + out;\n    if (this.sign)\n      out = '-' + out;\n    return out;\n  } else {\n    assert(false, 'Base should be between 2 and 36');\n  }\n};\n\nBN.prototype.toJSON = function toJSON() {\n  return this.toString(16);\n};\n\nBN.prototype.toArray = function toArray() {\n  this.strip();\n  var res = new Array(this.byteLength());\n  res[0] = 0;\n\n  var q = this.clone();\n  for (var i = 0; q.cmpn(0) !== 0; i++) {\n    var b = q.andln(0xff);\n    q.ishrn(8);\n\n    // Assume big-endian\n    res[res.length - i - 1] = b;\n  }\n\n  return res;\n};\n\n/*\nfunction genCountBits(bits) {\n  var arr = [];\n\n  for (var i = bits - 1; i >= 0; i--) {\n    var bit = '0x' + (1 << i).toString(16);\n    arr.push('w >= ' + bit + ' ? ' + (i + 1));\n  }\n\n  return new Function('w', 'return ' + arr.join(' :\\n') + ' :\\n0;');\n};\n\nBN.prototype._countBits = genCountBits(26);\n*/\n\n// Sadly chrome apps could not contain `new Function()` calls\nBN.prototype._countBits = function _countBits(w) {\n  return w >= 0x2000000 ? 26 :\n         w >= 0x1000000 ? 25 :\n         w >= 0x800000 ? 24 :\n         w >= 0x400000 ? 23 :\n         w >= 0x200000 ? 22 :\n         w >= 0x100000 ? 21 :\n         w >= 0x80000 ? 20 :\n         w >= 0x40000 ? 19 :\n         w >= 0x20000 ? 18 :\n         w >= 0x10000 ? 17 :\n         w >= 0x8000 ? 16 :\n         w >= 0x4000 ? 15 :\n         w >= 0x2000 ? 14 :\n         w >= 0x1000 ? 13 :\n         w >= 0x800 ? 12 :\n         w >= 0x400 ? 11 :\n         w >= 0x200 ? 10 :\n         w >= 0x100 ? 9 :\n         w >= 0x80 ? 8 :\n         w >= 0x40 ? 7 :\n         w >= 0x20 ? 6 :\n         w >= 0x10 ? 5 :\n         w >= 0x8 ? 4 :\n         w >= 0x4 ? 3 :\n         w >= 0x2 ? 2 :\n         w >= 0x1 ? 1 :\n         0;\n};\n\n// Return number of used bits in a BN\nBN.prototype.bitLength = function bitLength() {\n  var hi = 0;\n  var w = this.words[this.length - 1];\n  var hi = this._countBits(w);\n  return (this.length - 1) * 26 + hi;\n};\n\nBN.prototype.byteLength = function byteLength() {\n  return Math.ceil(this.bitLength() / 8);\n};\n\n// Return negative clone of `this`\nBN.prototype.neg = function neg() {\n  if (this.cmpn(0) === 0)\n    return this.clone();\n\n  var r = this.clone();\n  r.sign = !this.sign;\n  return r;\n};\n\n\n// Or `num` with `this` in-place\nBN.prototype.ior = function ior(num) {\n  this.sign = this.sign || num.sign;\n\n  while (this.length < num.length)\n    this.words[this.length++] = 0;\n\n  for (var i = 0; i < num.length; i++)\n    this.words[i] = this.words[i] | num.words[i];\n\n  return this.strip();\n};\n\n\n// Or `num` with `this`\nBN.prototype.or = function or(num) {\n  if (this.length > num.length)\n    return this.clone().ior(num);\n  else\n    return num.clone().ior(this);\n};\n\n\n// And `num` with `this` in-place\nBN.prototype.iand = function iand(num) {\n  this.sign = this.sign && num.sign;\n\n  // b = min-length(num, this)\n  var b;\n  if (this.length > num.length)\n    b = num;\n  else\n    b = this;\n\n  for (var i = 0; i < b.length; i++)\n    this.words[i] = this.words[i] & num.words[i];\n\n  this.length = b.length;\n\n  return this.strip();\n};\n\n\n// And `num` with `this`\nBN.prototype.and = function and(num) {\n  if (this.length > num.length)\n    return this.clone().iand(num);\n  else\n    return num.clone().iand(this);\n};\n\n\n// Xor `num` with `this` in-place\nBN.prototype.ixor = function ixor(num) {\n  this.sign = this.sign || num.sign;\n\n  // a.length > b.length\n  var a;\n  var b;\n  if (this.length > num.length) {\n    a = this;\n    b = num;\n  } else {\n    a = num;\n    b = this;\n  }\n\n  for (var i = 0; i < b.length; i++)\n    this.words[i] = a.words[i] ^ b.words[i];\n\n  if (this !== a)\n    for (; i < a.length; i++)\n      this.words[i] = a.words[i];\n\n  this.length = a.length;\n\n  return this.strip();\n};\n\n\n// Xor `num` with `this`\nBN.prototype.xor = function xor(num) {\n  if (this.length > num.length)\n    return this.clone().ixor(num);\n  else\n    return num.clone().ixor(this);\n};\n\n\n// Set `bit` of `this`\nBN.prototype.setn = function setn(bit, val) {\n  assert(typeof bit === 'number' && bit >= 0);\n\n  var off = (bit / 26) | 0;\n  var wbit = bit % 26;\n\n  while (this.length <= off)\n    this.words[this.length++] = 0;\n\n  if (val)\n    this.words[off] = this.words[off] | (1 << wbit);\n  else\n    this.words[off] = this.words[off] & ~(1 << wbit);\n\n  return this.strip();\n};\n\n\n// Add `num` to `this` in-place\nBN.prototype.iadd = function iadd(num) {\n  // negative + positive\n  if (this.sign && !num.sign) {\n    this.sign = false;\n    var r = this.isub(num);\n    this.sign = !this.sign;\n    return this._normSign();\n\n  // positive + negative\n  } else if (!this.sign && num.sign) {\n    num.sign = false;\n    var r = this.isub(num);\n    num.sign = true;\n    return r._normSign();\n  }\n\n  // a.length > b.length\n  var a;\n  var b;\n  if (this.length > num.length) {\n    a = this;\n    b = num;\n  } else {\n    a = num;\n    b = this;\n  }\n\n  var carry = 0;\n  for (var i = 0; i < b.length; i++) {\n    var r = a.words[i] + b.words[i] + carry;\n    this.words[i] = r & 0x3ffffff;\n    carry = r >>> 26;\n  }\n  for (; carry !== 0 && i < a.length; i++) {\n    var r = a.words[i] + carry;\n    this.words[i] = r & 0x3ffffff;\n    carry = r >>> 26;\n  }\n\n  this.length = a.length;\n  if (carry !== 0) {\n    this.words[this.length] = carry;\n    this.length++;\n  // Copy the rest of the words\n  } else if (a !== this) {\n    for (; i < a.length; i++)\n      this.words[i] = a.words[i];\n  }\n\n  return this;\n};\n\n// Add `num` to `this`\nBN.prototype.add = function add(num) {\n  if (num.sign && !this.sign) {\n    num.sign = false;\n    var res = this.sub(num);\n    num.sign = true;\n    return res;\n  } else if (!num.sign && this.sign) {\n    this.sign = false;\n    var res = num.sub(this);\n    this.sign = true;\n    return res;\n  }\n\n  if (this.length > num.length)\n    return this.clone().iadd(num);\n  else\n    return num.clone().iadd(this);\n};\n\n// Subtract `num` from `this` in-place\nBN.prototype.isub = function isub(num) {\n  // this - (-num) = this + num\n  if (num.sign) {\n    num.sign = false;\n    var r = this.iadd(num);\n    num.sign = true;\n    return r._normSign();\n\n  // -this - num = -(this + num)\n  } else if (this.sign) {\n    this.sign = false;\n    this.iadd(num);\n    this.sign = true;\n    return this._normSign();\n  }\n\n  // At this point both numbers are positive\n  var cmp = this.cmp(num);\n\n  // Optimization - zeroify\n  if (cmp === 0) {\n    this.sign = false;\n    this.length = 1;\n    this.words[0] = 0;\n    return this;\n  }\n\n  // a > b\n  var a;\n  var b;\n  if (cmp > 0) {\n    a = this;\n    b = num;\n  } else {\n    a = num;\n    b = this;\n  }\n\n  var carry = 0;\n  for (var i = 0; i < b.length; i++) {\n    var r = a.words[i] - b.words[i] + carry;\n    carry = r >> 26;\n    this.words[i] = r & 0x3ffffff;\n  }\n  for (; carry !== 0 && i < a.length; i++) {\n    var r = a.words[i] + carry;\n    carry = r >> 26;\n    this.words[i] = r & 0x3ffffff;\n  }\n\n  // Copy rest of the words\n  if (carry === 0 && i < a.length && a !== this)\n    for (; i < a.length; i++)\n      this.words[i] = a.words[i];\n  this.length = Math.max(this.length, i);\n\n  if (a !== this)\n    this.sign = true;\n\n  return this.strip();\n};\n\n// Subtract `num` from `this`\nBN.prototype.sub = function sub(num) {\n  return this.clone().isub(num);\n};\n\n/*\n// NOTE: This could be potentionally used to generate loop-less multiplications\nfunction _genCombMulTo(alen, blen) {\n  var len = alen + blen - 1;\n  var src = [\n    'var a = this.words, b = num.words, o = out.words, c = 0, w, ' +\n        'mask = 0x3ffffff, shift = 0x4000000;',\n    'out.length = ' + len + ';'\n  ];\n  for (var k = 0; k < len; k++) {\n    var minJ = Math.max(0, k - alen + 1);\n    var maxJ = Math.min(k, blen - 1);\n\n    for (var j = minJ; j <= maxJ; j++) {\n      var i = k - j;\n      var mul = 'a[' + i + '] * b[' + j + ']';\n\n      if (j === minJ) {\n        src.push('w = ' + mul + ' + c;');\n        src.push('c = (w / shift) | 0;');\n      } else {\n        src.push('w += ' + mul + ';');\n        src.push('c += (w / shift) | 0;');\n      }\n      src.push('w &= mask;');\n    }\n    src.push('o[' + k + '] = w;');\n  }\n  src.push('if (c !== 0) {',\n           '  o[' + k + '] = c;',\n           '  out.length++;',\n           '}',\n           'return out;');\n\n  return src.join('\\n');\n}\n*/\n\nBN.prototype._smallMulTo = function _smallMulTo(num, out) {\n  out.sign = num.sign !== this.sign;\n  out.length = this.length + num.length;\n\n  var carry = 0;\n  for (var k = 0; k < out.length - 1; k++) {\n    // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n    // note that ncarry could be >= 0x3ffffff\n    var ncarry = carry >>> 26;\n    var rword = carry & 0x3ffffff;\n    var maxJ = Math.min(k, num.length - 1);\n    for (var j = Math.max(0, k - this.length + 1); j <= maxJ; j++) {\n      var i = k - j;\n      var a = this.words[i] | 0;\n      var b = num.words[j] | 0;\n      var r = a * b;\n\n      var lo = r & 0x3ffffff;\n      ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;\n      lo = (lo + rword) | 0;\n      rword = lo & 0x3ffffff;\n      ncarry = (ncarry + (lo >>> 26)) | 0;\n    }\n    out.words[k] = rword;\n    carry = ncarry;\n  }\n  if (carry !== 0) {\n    out.words[k] = carry;\n  } else {\n    out.length--;\n  }\n\n  return out.strip();\n};\n\nBN.prototype._bigMulTo = function _bigMulTo(num, out) {\n  out.sign = num.sign !== this.sign;\n  out.length = this.length + num.length;\n\n  var carry = 0;\n  var hncarry = 0;\n  for (var k = 0; k < out.length - 1; k++) {\n    // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n    // note that ncarry could be >= 0x3ffffff\n    var ncarry = hncarry;\n    hncarry = 0;\n    var rword = carry & 0x3ffffff;\n    var maxJ = Math.min(k, num.length - 1);\n    for (var j = Math.max(0, k - this.length + 1); j <= maxJ; j++) {\n      var i = k - j;\n      var a = this.words[i] | 0;\n      var b = num.words[j] | 0;\n      var r = a * b;\n\n      var lo = r & 0x3ffffff;\n      ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;\n      lo = (lo + rword) | 0;\n      rword = lo & 0x3ffffff;\n      ncarry = (ncarry + (lo >>> 26)) | 0;\n\n      hncarry += ncarry >>> 26;\n      ncarry &= 0x3ffffff;\n    }\n    out.words[k] = rword;\n    carry = ncarry;\n    ncarry = hncarry;\n  }\n  if (carry !== 0) {\n    out.words[k] = carry;\n  } else {\n    out.length--;\n  }\n\n  return out.strip();\n};\n\nBN.prototype.mulTo = function mulTo(num, out) {\n  var res;\n  if (this.length + num.length < 63)\n    res = this._smallMulTo(num, out);\n  else\n    res = this._bigMulTo(num, out);\n  return res;\n};\n\n// Multiply `this` by `num`\nBN.prototype.mul = function mul(num) {\n  var out = new BN(null);\n  out.words = new Array(this.length + num.length);\n  return this.mulTo(num, out);\n};\n\n// In-place Multiplication\nBN.prototype.imul = function imul(num) {\n  if (this.cmpn(0) === 0 || num.cmpn(0) === 0) {\n    this.words[0] = 0;\n    this.length = 1;\n    return this;\n  }\n\n  var tlen = this.length;\n  var nlen = num.length;\n\n  this.sign = num.sign !== this.sign;\n  this.length = this.length + num.length;\n  this.words[this.length - 1] = 0;\n\n  for (var k = this.length - 2; k >= 0; k--) {\n    // Sum all words with the same `i + j = k` and accumulate `carry`,\n    // note that carry could be >= 0x3ffffff\n    var carry = 0;\n    var rword = 0;\n    var maxJ = Math.min(k, nlen - 1);\n    for (var j = Math.max(0, k - tlen + 1); j <= maxJ; j++) {\n      var i = k - j;\n      var a = this.words[i];\n      var b = num.words[j];\n      var r = a * b;\n\n      var lo = r & 0x3ffffff;\n      carry += (r / 0x4000000) | 0;\n      lo += rword;\n      rword = lo & 0x3ffffff;\n      carry += lo >>> 26;\n    }\n    this.words[k] = rword;\n    this.words[k + 1] += carry;\n    carry = 0;\n  }\n\n  // Propagate overflows\n  var carry = 0;\n  for (var i = 1; i < this.length; i++) {\n    var w = this.words[i] + carry;\n    this.words[i] = w & 0x3ffffff;\n    carry = w >>> 26;\n  }\n\n  return this.strip();\n};\n\nBN.prototype.imuln = function imuln(num) {\n  assert(typeof num === 'number');\n\n  // Carry\n  var carry = 0;\n  for (var i = 0; i < this.length; i++) {\n    var w = this.words[i] * num;\n    var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);\n    carry >>= 26;\n    carry += (w / 0x4000000) | 0;\n    // NOTE: lo is 27bit maximum\n    carry += lo >>> 26;\n    this.words[i] = lo & 0x3ffffff;\n  }\n\n  if (carry !== 0) {\n    this.words[i] = carry;\n    this.length++;\n  }\n\n  return this;\n};\n\n// `this` * `this`\nBN.prototype.sqr = function sqr() {\n  return this.mul(this);\n};\n\n// `this` * `this` in-place\nBN.prototype.isqr = function isqr() {\n  return this.mul(this);\n};\n\n// Shift-left in-place\nBN.prototype.ishln = function ishln(bits) {\n  assert(typeof bits === 'number' && bits >= 0);\n  var r = bits % 26;\n  var s = (bits - r) / 26;\n  var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);\n\n  if (r !== 0) {\n    var carry = 0;\n    for (var i = 0; i < this.length; i++) {\n      var newCarry = this.words[i] & carryMask;\n      var c = (this.words[i] - newCarry) << r;\n      this.words[i] = c | carry;\n      carry = newCarry >>> (26 - r);\n    }\n    if (carry) {\n      this.words[i] = carry;\n      this.length++;\n    }\n  }\n\n  if (s !== 0) {\n    for (var i = this.length - 1; i >= 0; i--)\n      this.words[i + s] = this.words[i];\n    for (var i = 0; i < s; i++)\n      this.words[i] = 0;\n    this.length += s;\n  }\n\n  return this.strip();\n};\n\n// Shift-right in-place\n// NOTE: `hint` is a lowest bit before trailing zeroes\n// NOTE: if `extended` is true - { lo: ..., hi: } object will be returned\nBN.prototype.ishrn = function ishrn(bits, hint, extended) {\n  assert(typeof bits === 'number' && bits >= 0);\n  if (hint)\n    hint = (hint - (hint % 26)) / 26;\n  else\n    hint = 0;\n\n  var r = bits % 26;\n  var s = Math.min((bits - r) / 26, this.length);\n  var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n  var maskedWords = extended;\n\n  hint -= s;\n  hint = Math.max(0, hint);\n\n  // Extended mode, copy masked part\n  if (maskedWords) {\n    for (var i = 0; i < s; i++)\n      maskedWords.words[i] = this.words[i];\n    maskedWords.length = s;\n  }\n\n  if (s === 0) {\n    // No-op, we should not move anything at all\n  } else if (this.length > s) {\n    this.length -= s;\n    for (var i = 0; i < this.length; i++)\n      this.words[i] = this.words[i + s];\n  } else {\n    this.words[0] = 0;\n    this.length = 1;\n  }\n\n  var carry = 0;\n  for (var i = this.length - 1; i >= 0 && (carry !== 0 || i >= hint); i--) {\n    var word = this.words[i];\n    this.words[i] = (carry << (26 - r)) | (word >>> r);\n    carry = word & mask;\n  }\n\n  // Push carried bits as a mask\n  if (maskedWords && carry !== 0)\n    maskedWords.words[maskedWords.length++] = carry;\n\n  if (this.length === 0) {\n    this.words[0] = 0;\n    this.length = 1;\n  }\n\n  this.strip();\n  if (extended)\n    return { hi: this, lo: maskedWords };\n\n  return this;\n};\n\n// Shift-left\nBN.prototype.shln = function shln(bits) {\n  return this.clone().ishln(bits);\n};\n\n// Shift-right\nBN.prototype.shrn = function shrn(bits) {\n  return this.clone().ishrn(bits);\n};\n\n// Test if n bit is set\nBN.prototype.testn = function testn(bit) {\n  assert(typeof bit === 'number' && bit >= 0);\n  var r = bit % 26;\n  var s = (bit - r) / 26;\n  var q = 1 << r;\n\n  // Fast case: bit is much higher than all existing words\n  if (this.length <= s) {\n    return false;\n  }\n\n  // Check bit and return\n  var w = this.words[s];\n\n  return !!(w & q);\n};\n\n// Return only lowers bits of number (in-place)\nBN.prototype.imaskn = function imaskn(bits) {\n  assert(typeof bits === 'number' && bits >= 0);\n  var r = bits % 26;\n  var s = (bits - r) / 26;\n\n  assert(!this.sign, 'imaskn works only with positive numbers');\n\n  if (r !== 0)\n    s++;\n  this.length = Math.min(s, this.length);\n\n  if (r !== 0) {\n    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n    this.words[this.length - 1] &= mask;\n  }\n\n  return this.strip();\n};\n\n// Return only lowers bits of number\nBN.prototype.maskn = function maskn(bits) {\n  return this.clone().imaskn(bits);\n};\n\n// Add plain number `num` to `this`\nBN.prototype.iaddn = function iaddn(num) {\n  assert(typeof num === 'number');\n  if (num < 0)\n    return this.isubn(-num);\n\n  // Possible sign change\n  if (this.sign) {\n    if (this.length === 1 && this.words[0] < num) {\n      this.words[0] = num - this.words[0];\n      this.sign = false;\n      return this;\n    }\n\n    this.sign = false;\n    this.isubn(num);\n    this.sign = true;\n    return this;\n  }\n\n  // Add without checks\n  return this._iaddn(num);\n};\n\nBN.prototype._iaddn = function _iaddn(num) {\n  this.words[0] += num;\n\n  // Carry\n  for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {\n    this.words[i] -= 0x4000000;\n    if (i === this.length - 1)\n      this.words[i + 1] = 1;\n    else\n      this.words[i + 1]++;\n  }\n  this.length = Math.max(this.length, i + 1);\n\n  return this;\n};\n\n// Subtract plain number `num` from `this`\nBN.prototype.isubn = function isubn(num) {\n  assert(typeof num === 'number');\n  if (num < 0)\n    return this.iaddn(-num);\n\n  if (this.sign) {\n    this.sign = false;\n    this.iaddn(num);\n    this.sign = true;\n    return this;\n  }\n\n  this.words[0] -= num;\n\n  // Carry\n  for (var i = 0; i < this.length && this.words[i] < 0; i++) {\n    this.words[i] += 0x4000000;\n    this.words[i + 1] -= 1;\n  }\n\n  return this.strip();\n};\n\nBN.prototype.addn = function addn(num) {\n  return this.clone().iaddn(num);\n};\n\nBN.prototype.subn = function subn(num) {\n  return this.clone().isubn(num);\n};\n\nBN.prototype.iabs = function iabs() {\n  this.sign = false;\n\n  return this;\n};\n\nBN.prototype.abs = function abs() {\n  return this.clone().iabs();\n};\n\nBN.prototype._ishlnsubmul = function _ishlnsubmul(num, mul, shift) {\n  // Bigger storage is needed\n  var len = num.length + shift;\n  var i;\n  if (this.words.length < len) {\n    var t = new Array(len);\n    for (var i = 0; i < this.length; i++)\n      t[i] = this.words[i];\n    this.words = t;\n  } else {\n    i = this.length;\n  }\n\n  // Zeroify rest\n  this.length = Math.max(this.length, len);\n  for (; i < this.length; i++)\n    this.words[i] = 0;\n\n  var carry = 0;\n  for (var i = 0; i < num.length; i++) {\n    var w = this.words[i + shift] + carry;\n    var right = num.words[i] * mul;\n    w -= right & 0x3ffffff;\n    carry = (w >> 26) - ((right / 0x4000000) | 0);\n    this.words[i + shift] = w & 0x3ffffff;\n  }\n  for (; i < this.length - shift; i++) {\n    var w = this.words[i + shift] + carry;\n    carry = w >> 26;\n    this.words[i + shift] = w & 0x3ffffff;\n  }\n\n  if (carry === 0)\n    return this.strip();\n\n  // Subtraction overflow\n  assert(carry === -1);\n  carry = 0;\n  for (var i = 0; i < this.length; i++) {\n    var w = -this.words[i] + carry;\n    carry = w >> 26;\n    this.words[i] = w & 0x3ffffff;\n  }\n  this.sign = true;\n\n  return this.strip();\n};\n\nBN.prototype._wordDiv = function _wordDiv(num, mode) {\n  var shift = this.length - num.length;\n\n  var a = this.clone();\n  var b = num;\n\n  // Normalize\n  var bhi = b.words[b.length - 1];\n  for (var shift = 0; bhi < 0x2000000; shift++)\n    bhi <<= 1;\n  if (shift !== 0) {\n    b = b.shln(shift);\n    a.ishln(shift);\n    bhi = b.words[b.length - 1];\n  }\n\n  // Initialize quotient\n  var m = a.length - b.length;\n  var q;\n\n  if (mode !== 'mod') {\n    q = new BN(null);\n    q.length = m + 1;\n    q.words = new Array(q.length);\n    for (var i = 0; i < q.length; i++)\n      q.words[i] = 0;\n  }\n\n  var diff = a.clone()._ishlnsubmul(b, 1, m);\n  if (!diff.sign) {\n    a = diff;\n    if (q)\n      q.words[m] = 1;\n  }\n\n  for (var j = m - 1; j >= 0; j--) {\n    var qj = a.words[b.length + j] * 0x4000000 + a.words[b.length + j - 1];\n\n    // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max\n    // (0x7ffffff)\n    qj = Math.min((qj / bhi) | 0, 0x3ffffff);\n\n    a._ishlnsubmul(b, qj, j);\n    while (a.sign) {\n      qj--;\n      a.sign = false;\n      a._ishlnsubmul(b, 1, j);\n      a.sign = !a.sign;\n    }\n    if (q)\n      q.words[j] = qj;\n  }\n  if (q)\n    q.strip();\n  a.strip();\n\n  // Denormalize\n  if (mode !== 'div' && shift !== 0)\n    a.ishrn(shift);\n  return { div: q ? q : null, mod: a };\n};\n\nBN.prototype.divmod = function divmod(num, mode) {\n  assert(num.cmpn(0) !== 0);\n\n  if (this.sign && !num.sign) {\n    var res = this.neg().divmod(num, mode);\n    var div;\n    var mod;\n    if (mode !== 'mod')\n      div = res.div.neg();\n    if (mode !== 'div')\n      mod = res.mod.cmpn(0) === 0 ? res.mod : num.sub(res.mod);\n    return {\n      div: div,\n      mod: mod\n    };\n  } else if (!this.sign && num.sign) {\n    var res = this.divmod(num.neg(), mode);\n    var div;\n    if (mode !== 'mod')\n      div = res.div.neg();\n    return { div: div, mod: res.mod };\n  } else if (this.sign && num.sign) {\n    return this.neg().divmod(num.neg(), mode);\n  }\n\n  // Both numbers are positive at this point\n\n  // Strip both numbers to approximate shift value\n  if (num.length > this.length || this.cmp(num) < 0)\n    return { div: new BN(0), mod: this };\n\n  // Very short reduction\n  if (num.length === 1) {\n    if (mode === 'div')\n      return { div: this.divn(num.words[0]), mod: null };\n    else if (mode === 'mod')\n      return { div: null, mod: new BN(this.modn(num.words[0])) };\n    return {\n      div: this.divn(num.words[0]),\n      mod: new BN(this.modn(num.words[0]))\n    };\n  }\n\n  return this._wordDiv(num, mode);\n};\n\n// Find `this` / `num`\nBN.prototype.div = function div(num) {\n  return this.divmod(num, 'div').div;\n};\n\n// Find `this` % `num`\nBN.prototype.mod = function mod(num) {\n  return this.divmod(num, 'mod').mod;\n};\n\n// Find Round(`this` / `num`)\nBN.prototype.divRound = function divRound(num) {\n  var dm = this.divmod(num);\n\n  // Fast case - exact division\n  if (dm.mod.cmpn(0) === 0)\n    return dm.div;\n\n  var mod = dm.div.sign ? dm.mod.isub(num) : dm.mod;\n\n  var half = num.shrn(1);\n  var r2 = num.andln(1);\n  var cmp = mod.cmp(half);\n\n  // Round down\n  if (cmp < 0 || r2 === 1 && cmp === 0)\n    return dm.div;\n\n  // Round up\n  return dm.div.sign ? dm.div.isubn(1) : dm.div.iaddn(1);\n};\n\nBN.prototype.modn = function modn(num) {\n  assert(num <= 0x3ffffff);\n  var p = (1 << 26) % num;\n\n  var acc = 0;\n  for (var i = this.length - 1; i >= 0; i--)\n    acc = (p * acc + this.words[i]) % num;\n\n  return acc;\n};\n\n// In-place division by number\nBN.prototype.idivn = function idivn(num) {\n  assert(num <= 0x3ffffff);\n\n  var carry = 0;\n  for (var i = this.length - 1; i >= 0; i--) {\n    var w = this.words[i] + carry * 0x4000000;\n    this.words[i] = (w / num) | 0;\n    carry = w % num;\n  }\n\n  return this.strip();\n};\n\nBN.prototype.divn = function divn(num) {\n  return this.clone().idivn(num);\n};\n\nBN.prototype._egcd = function _egcd(x1, p) {\n  assert(!p.sign);\n  assert(p.cmpn(0) !== 0);\n\n  var a = this;\n  var b = p.clone();\n\n  if (a.sign)\n    a = a.mod(p);\n  else\n    a = a.clone();\n\n  var x2 = new BN(0);\n  while (b.isEven())\n    b.ishrn(1);\n  var delta = b.clone();\n  while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {\n    while (a.isEven()) {\n      a.ishrn(1);\n      if (x1.isEven())\n        x1.ishrn(1);\n      else\n        x1.iadd(delta).ishrn(1);\n    }\n    while (b.isEven()) {\n      b.ishrn(1);\n      if (x2.isEven())\n        x2.ishrn(1);\n      else\n        x2.iadd(delta).ishrn(1);\n    }\n    if (a.cmp(b) >= 0) {\n      a.isub(b);\n      x1.isub(x2);\n    } else {\n      b.isub(a);\n      x2.isub(x1);\n    }\n  }\n  if (a.cmpn(1) === 0)\n    return x1;\n  else\n    return x2;\n};\n\nBN.prototype.gcd = function gcd(num) {\n  if (this.cmpn(0) === 0)\n    return num.clone();\n  if (num.cmpn(0) === 0)\n    return this.clone();\n\n  var a = this.clone();\n  var b = num.clone();\n  a.sign = false;\n  b.sign = false;\n\n  // Remove common factor of two\n  for (var shift = 0; a.isEven() && b.isEven(); shift++) {\n    a.ishrn(1);\n    b.ishrn(1);\n  }\n\n  while (a.isEven())\n    a.ishrn(1);\n\n  do {\n    while (b.isEven())\n      b.ishrn(1);\n\n    // Swap `a` and `b` to make `a` always bigger than `b`\n    if (a.cmp(b) < 0) {\n      var t = a;\n      a = b;\n      b = t;\n    }\n    a.isub(a.div(b).mul(b));\n  } while (a.cmpn(0) !== 0 && b.cmpn(0) !== 0);\n  if (a.cmpn(0) === 0)\n    return b.ishln(shift);\n  else\n    return a.ishln(shift);\n};\n\n// Invert number in the field F(num)\nBN.prototype.invm = function invm(num) {\n  return this._egcd(new BN(1), num).mod(num);\n};\n\nBN.prototype.isEven = function isEven() {\n  return (this.words[0] & 1) === 0;\n};\n\nBN.prototype.isOdd = function isOdd() {\n  return (this.words[0] & 1) === 1;\n};\n\n// And first word and num\nBN.prototype.andln = function andln(num) {\n  return this.words[0] & num;\n};\n\n// Increment at the bit position in-line\nBN.prototype.bincn = function bincn(bit) {\n  assert(typeof bit === 'number');\n  var r = bit % 26;\n  var s = (bit - r) / 26;\n  var q = 1 << r;\n\n  // Fast case: bit is much higher than all existing words\n  if (this.length <= s) {\n    for (var i = this.length; i < s + 1; i++)\n      this.words[i] = 0;\n    this.words[s] |= q;\n    this.length = s + 1;\n    return this;\n  }\n\n  // Add bit and propagate, if needed\n  var carry = q;\n  for (var i = s; carry !== 0 && i < this.length; i++) {\n    var w = this.words[i];\n    w += carry;\n    carry = w >>> 26;\n    w &= 0x3ffffff;\n    this.words[i] = w;\n  }\n  if (carry !== 0) {\n    this.words[i] = carry;\n    this.length++;\n  }\n  return this;\n};\n\nBN.prototype.cmpn = function cmpn(num) {\n  var sign = num < 0;\n  if (sign)\n    num = -num;\n\n  if (this.sign && !sign)\n    return -1;\n  else if (!this.sign && sign)\n    return 1;\n\n  num &= 0x3ffffff;\n  this.strip();\n\n  var res;\n  if (this.length > 1) {\n    res = 1;\n  } else {\n    var w = this.words[0];\n    res = w === num ? 0 : w < num ? -1 : 1;\n  }\n  if (this.sign)\n    res = -res;\n  return res;\n};\n\n// Compare two numbers and return:\n// 1 - if `this` > `num`\n// 0 - if `this` == `num`\n// -1 - if `this` < `num`\nBN.prototype.cmp = function cmp(num) {\n  if (this.sign && !num.sign)\n    return -1;\n  else if (!this.sign && num.sign)\n    return 1;\n\n  var res = this.ucmp(num);\n  if (this.sign)\n    return -res;\n  else\n    return res;\n};\n\n// Unsigned comparison\nBN.prototype.ucmp = function ucmp(num) {\n  // At this point both numbers have the same sign\n  if (this.length > num.length)\n    return 1;\n  else if (this.length < num.length)\n    return -1;\n\n  var res = 0;\n  for (var i = this.length - 1; i >= 0; i--) {\n    var a = this.words[i];\n    var b = num.words[i];\n\n    if (a === b)\n      continue;\n    if (a < b)\n      res = -1;\n    else if (a > b)\n      res = 1;\n    break;\n  }\n  return res;\n};\n\n//\n// A reduce context, could be using montgomery or something better, depending\n// on the `m` itself.\n//\nBN.red = function red(num) {\n  return new Red(num);\n};\n\nBN.prototype.toRed = function toRed(ctx) {\n  assert(!this.red, 'Already a number in reduction context');\n  assert(!this.sign, 'red works only with positives');\n  return ctx.convertTo(this)._forceRed(ctx);\n};\n\nBN.prototype.fromRed = function fromRed() {\n  assert(this.red, 'fromRed works only with numbers in reduction context');\n  return this.red.convertFrom(this);\n};\n\nBN.prototype._forceRed = function _forceRed(ctx) {\n  this.red = ctx;\n  return this;\n};\n\nBN.prototype.forceRed = function forceRed(ctx) {\n  assert(!this.red, 'Already a number in reduction context');\n  return this._forceRed(ctx);\n};\n\nBN.prototype.redAdd = function redAdd(num) {\n  assert(this.red, 'redAdd works only with red numbers');\n  return this.red.add(this, num);\n};\n\nBN.prototype.redIAdd = function redIAdd(num) {\n  assert(this.red, 'redIAdd works only with red numbers');\n  return this.red.iadd(this, num);\n};\n\nBN.prototype.redSub = function redSub(num) {\n  assert(this.red, 'redSub works only with red numbers');\n  return this.red.sub(this, num);\n};\n\nBN.prototype.redISub = function redISub(num) {\n  assert(this.red, 'redISub works only with red numbers');\n  return this.red.isub(this, num);\n};\n\nBN.prototype.redShl = function redShl(num) {\n  assert(this.red, 'redShl works only with red numbers');\n  return this.red.shl(this, num);\n};\n\nBN.prototype.redMul = function redMul(num) {\n  assert(this.red, 'redMul works only with red numbers');\n  this.red._verify2(this, num);\n  return this.red.mul(this, num);\n};\n\nBN.prototype.redIMul = function redIMul(num) {\n  assert(this.red, 'redMul works only with red numbers');\n  this.red._verify2(this, num);\n  return this.red.imul(this, num);\n};\n\nBN.prototype.redSqr = function redSqr() {\n  assert(this.red, 'redSqr works only with red numbers');\n  this.red._verify1(this);\n  return this.red.sqr(this);\n};\n\nBN.prototype.redISqr = function redISqr() {\n  assert(this.red, 'redISqr works only with red numbers');\n  this.red._verify1(this);\n  return this.red.isqr(this);\n};\n\n// Square root over p\nBN.prototype.redSqrt = function redSqrt() {\n  assert(this.red, 'redSqrt works only with red numbers');\n  this.red._verify1(this);\n  return this.red.sqrt(this);\n};\n\nBN.prototype.redInvm = function redInvm() {\n  assert(this.red, 'redInvm works only with red numbers');\n  this.red._verify1(this);\n  return this.red.invm(this);\n};\n\n// Return negative clone of `this` % `red modulo`\nBN.prototype.redNeg = function redNeg() {\n  assert(this.red, 'redNeg works only with red numbers');\n  this.red._verify1(this);\n  return this.red.neg(this);\n};\n\nBN.prototype.redPow = function redPow(num) {\n  assert(this.red && !num.red, 'redPow(normalNum)');\n  this.red._verify1(this);\n  return this.red.pow(this, num);\n};\n\n// Prime numbers with efficient reduction\nvar primes = {\n  k256: null,\n  p224: null,\n  p192: null,\n  p25519: null\n};\n\n// Pseudo-Mersenne prime\nfunction MPrime(name, p) {\n  // P = 2 ^ N - K\n  this.name = name;\n  this.p = new BN(p, 16);\n  this.n = this.p.bitLength();\n  this.k = new BN(1).ishln(this.n).isub(this.p);\n\n  this.tmp = this._tmp();\n}\n\nMPrime.prototype._tmp = function _tmp() {\n  var tmp = new BN(null);\n  tmp.words = new Array(Math.ceil(this.n / 13));\n  return tmp;\n};\n\nMPrime.prototype.ireduce = function ireduce(num) {\n  // Assumes that `num` is less than `P^2`\n  // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)\n  var r = num;\n  var rlen;\n\n  do {\n    var pair = r.ishrn(this.n, 0, this.tmp);\n    r = this.imulK(pair.hi);\n    r = r.iadd(pair.lo);\n    rlen = r.bitLength();\n  } while (rlen > this.n);\n\n  var cmp = rlen < this.n ? -1 : r.cmp(this.p);\n  if (cmp === 0) {\n    r.words[0] = 0;\n    r.length = 1;\n  } else if (cmp > 0) {\n    r.isub(this.p);\n  } else {\n    r.strip();\n  }\n\n  return r;\n};\n\nMPrime.prototype.imulK = function imulK(num) {\n  return num.imul(this.k);\n};\n\nfunction K256() {\n  MPrime.call(\n    this,\n    'k256',\n    'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');\n}\ninherits(K256, MPrime);\n\nK256.prototype.imulK = function imulK(num) {\n  // K = 0x1000003d1 = [ 0x40, 0x3d1 ]\n  num.words[num.length] = 0;\n  num.words[num.length + 1] = 0;\n  num.length += 2;\n\n  // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390\n  var hi;\n  var lo = 0;\n  for (var i = 0; i < num.length; i++) {\n    var w = num.words[i];\n    hi = w * 0x40;\n    lo += w * 0x3d1;\n    hi += (lo / 0x4000000) | 0;\n    lo &= 0x3ffffff;\n\n    num.words[i] = lo;\n\n    lo = hi;\n  }\n\n  // Fast length reduction\n  if (num.words[num.length - 1] === 0) {\n    num.length--;\n    if (num.words[num.length - 1] === 0)\n      num.length--;\n  }\n  return num;\n};\n\nfunction P224() {\n  MPrime.call(\n    this,\n    'p224',\n    'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');\n}\ninherits(P224, MPrime);\n\nfunction P192() {\n  MPrime.call(\n    this,\n    'p192',\n    'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');\n}\ninherits(P192, MPrime);\n\nfunction P25519() {\n  // 2 ^ 255 - 19\n  MPrime.call(\n    this,\n    '25519',\n    '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');\n}\ninherits(P25519, MPrime);\n\nP25519.prototype.imulK = function imulK(num) {\n  // K = 0x13\n  var carry = 0;\n  for (var i = 0; i < num.length; i++) {\n    var hi = num.words[i] * 0x13 + carry;\n    var lo = hi & 0x3ffffff;\n    hi >>>= 26;\n\n    num.words[i] = lo;\n    carry = hi;\n  }\n  if (carry !== 0)\n    num.words[num.length++] = carry;\n  return num;\n};\n\n// Exported mostly for testing purposes, use plain name instead\nBN._prime = function prime(name) {\n  // Cached version of prime\n  if (primes[name])\n    return primes[name];\n\n  var prime;\n  if (name === 'k256')\n    prime = new K256();\n  else if (name === 'p224')\n    prime = new P224();\n  else if (name === 'p192')\n    prime = new P192();\n  else if (name === 'p25519')\n    prime = new P25519();\n  else\n    throw new Error('Unknown prime ' + name);\n  primes[name] = prime;\n\n  return prime;\n};\n\n//\n// Base reduction engine\n//\nfunction Red(m) {\n  if (typeof m === 'string') {\n    var prime = BN._prime(m);\n    this.m = prime.p;\n    this.prime = prime;\n  } else {\n    this.m = m;\n    this.prime = null;\n  }\n}\n\nRed.prototype._verify1 = function _verify1(a) {\n  assert(!a.sign, 'red works only with positives');\n  assert(a.red, 'red works only with red numbers');\n};\n\nRed.prototype._verify2 = function _verify2(a, b) {\n  assert(!a.sign && !b.sign, 'red works only with positives');\n  assert(a.red && a.red === b.red,\n         'red works only with red numbers');\n};\n\nRed.prototype.imod = function imod(a) {\n  if (this.prime)\n    return this.prime.ireduce(a)._forceRed(this);\n  return a.mod(this.m)._forceRed(this);\n};\n\nRed.prototype.neg = function neg(a) {\n  var r = a.clone();\n  r.sign = !r.sign;\n  return r.iadd(this.m)._forceRed(this);\n};\n\nRed.prototype.add = function add(a, b) {\n  this._verify2(a, b);\n\n  var res = a.add(b);\n  if (res.cmp(this.m) >= 0)\n    res.isub(this.m);\n  return res._forceRed(this);\n};\n\nRed.prototype.iadd = function iadd(a, b) {\n  this._verify2(a, b);\n\n  var res = a.iadd(b);\n  if (res.cmp(this.m) >= 0)\n    res.isub(this.m);\n  return res;\n};\n\nRed.prototype.sub = function sub(a, b) {\n  this._verify2(a, b);\n\n  var res = a.sub(b);\n  if (res.cmpn(0) < 0)\n    res.iadd(this.m);\n  return res._forceRed(this);\n};\n\nRed.prototype.isub = function isub(a, b) {\n  this._verify2(a, b);\n\n  var res = a.isub(b);\n  if (res.cmpn(0) < 0)\n    res.iadd(this.m);\n  return res;\n};\n\nRed.prototype.shl = function shl(a, num) {\n  this._verify1(a);\n  return this.imod(a.shln(num));\n};\n\nRed.prototype.imul = function imul(a, b) {\n  this._verify2(a, b);\n  return this.imod(a.imul(b));\n};\n\nRed.prototype.mul = function mul(a, b) {\n  this._verify2(a, b);\n  return this.imod(a.mul(b));\n};\n\nRed.prototype.isqr = function isqr(a) {\n  return this.imul(a, a);\n};\n\nRed.prototype.sqr = function sqr(a) {\n  return this.mul(a, a);\n};\n\nRed.prototype.sqrt = function sqrt(a) {\n  if (a.cmpn(0) === 0)\n    return a.clone();\n\n  var mod3 = this.m.andln(3);\n  assert(mod3 % 2 === 1);\n\n  // Fast case\n  if (mod3 === 3) {\n    var pow = this.m.add(new BN(1)).ishrn(2);\n    var r = this.pow(a, pow);\n    return r;\n  }\n\n  // Tonelli-Shanks algorithm (Totally unoptimized and slow)\n  //\n  // Find Q and S, that Q * 2 ^ S = (P - 1)\n  var q = this.m.subn(1);\n  var s = 0;\n  while (q.cmpn(0) !== 0 && q.andln(1) === 0) {\n    s++;\n    q.ishrn(1);\n  }\n  assert(q.cmpn(0) !== 0);\n\n  var one = new BN(1).toRed(this);\n  var nOne = one.redNeg();\n\n  // Find quadratic non-residue\n  // NOTE: Max is such because of generalized Riemann hypothesis.\n  var lpow = this.m.subn(1).ishrn(1);\n  var z = this.m.bitLength();\n  z = new BN(2 * z * z).toRed(this);\n  while (this.pow(z, lpow).cmp(nOne) !== 0)\n    z.redIAdd(nOne);\n\n  var c = this.pow(z, q);\n  var r = this.pow(a, q.addn(1).ishrn(1));\n  var t = this.pow(a, q);\n  var m = s;\n  while (t.cmp(one) !== 0) {\n    var tmp = t;\n    for (var i = 0; tmp.cmp(one) !== 0; i++)\n      tmp = tmp.redSqr();\n    assert(i < m);\n    var b = this.pow(c, new BN(1).ishln(m - i - 1));\n\n    r = r.redMul(b);\n    c = b.redSqr();\n    t = t.redMul(c);\n    m = i;\n  }\n\n  return r;\n};\n\nRed.prototype.invm = function invm(a) {\n  var inv = a._egcd(new BN(1), this.m);\n  if (inv.sign) {\n    inv.sign = false;\n    return this.imod(inv).redNeg();\n  } else {\n    return this.imod(inv);\n  }\n};\n\nRed.prototype.pow = function pow(a, num) {\n  var w = [];\n  var q = num.clone();\n  while (q.cmpn(0) !== 0) {\n    w.push(q.andln(1));\n    q.ishrn(1);\n  }\n\n  // Skip leading zeroes\n  var res = a;\n  for (var i = 0; i < w.length; i++, res = this.sqr(res))\n    if (w[i] !== 0)\n      break;\n\n  if (++i < w.length) {\n    for (var q = this.sqr(res); i < w.length; i++, q = this.sqr(q)) {\n      if (w[i] === 0)\n        continue;\n      res = this.mul(res, q);\n    }\n  }\n\n  return res;\n};\n\nRed.prototype.convertTo = function convertTo(num) {\n  return num.clone();\n};\n\nRed.prototype.convertFrom = function convertFrom(num) {\n  var res = num.clone();\n  res.red = null;\n  return res;\n};\n\n//\n// Montgomery method engine\n//\n\nBN.mont = function mont(num) {\n  return new Mont(num);\n};\n\nfunction Mont(m) {\n  Red.call(this, m);\n\n  this.shift = this.m.bitLength();\n  if (this.shift % 26 !== 0)\n    this.shift += 26 - (this.shift % 26);\n  this.r = new BN(1).ishln(this.shift);\n  this.r2 = this.imod(this.r.sqr());\n  this.rinv = this.r.invm(this.m);\n\n  this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);\n  this.minv.sign = true;\n  this.minv = this.minv.mod(this.r);\n}\ninherits(Mont, Red);\n\nMont.prototype.convertTo = function convertTo(num) {\n  return this.imod(num.shln(this.shift));\n};\n\nMont.prototype.convertFrom = function convertFrom(num) {\n  var r = this.imod(num.mul(this.rinv));\n  r.red = null;\n  return r;\n};\n\nMont.prototype.imul = function imul(a, b) {\n  if (a.cmpn(0) === 0 || b.cmpn(0) === 0) {\n    a.words[0] = 0;\n    a.length = 1;\n    return a;\n  }\n\n  var t = a.imul(b);\n  var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n  var u = t.isub(c).ishrn(this.shift);\n  var res = u;\n  if (u.cmp(this.m) >= 0)\n    res = u.isub(this.m);\n  else if (u.cmpn(0) < 0)\n    res = u.iadd(this.m);\n\n  return res._forceRed(this);\n};\n\nMont.prototype.mul = function mul(a, b) {\n  if (a.cmpn(0) === 0 || b.cmpn(0) === 0)\n    return new BN(0)._forceRed(this);\n\n  var t = a.mul(b);\n  var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n  var u = t.isub(c).ishrn(this.shift);\n  var res = u;\n  if (u.cmp(this.m) >= 0)\n    res = u.isub(this.m);\n  else if (u.cmpn(0) < 0)\n    res = u.iadd(this.m);\n\n  return res._forceRed(this);\n};\n\nMont.prototype.invm = function invm(a) {\n  // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R\n  var res = this.imod(a.invm(this.m).mul(this.r2));\n  return res._forceRed(this);\n};\n\n})(typeof module === 'undefined' || module, this);","deps":{}},{"id":"node_modules/brorand/index.js","source":"var r;\n\nmodule.exports = function rand(len) {\n  if (!r)\n    r = new Rand(null);\n\n  return r.generate(len);\n};\n\nfunction Rand(rand) {\n  this.rand = rand;\n}\nmodule.exports.Rand = Rand;\n\nRand.prototype.generate = function generate(len) {\n  return this._rand(len);\n};\n\n// Emulate crypto API using randy\nRand.prototype._rand = function _rand(n) {\n  if (this.rand.getBytes)\n    return this.rand.getBytes(n);\n\n  var res = new Uint8Array(n);\n  for (var i = 0; i < res.length; i++)\n    res[i] = this.rand.getByte();\n  return res;\n};\n\nif (typeof self === 'object') {\n  if (self.crypto && self.crypto.getRandomValues) {\n    // Modern browsers\n    Rand.prototype._rand = function _rand(n) {\n      var arr = new Uint8Array(n);\n      self.crypto.getRandomValues(arr);\n      return arr;\n    };\n  } else if (self.msCrypto && self.msCrypto.getRandomValues) {\n    // IE\n    Rand.prototype._rand = function _rand(n) {\n      var arr = new Uint8Array(n);\n      self.msCrypto.getRandomValues(arr);\n      return arr;\n    };\n\n  // Safari's WebWorkers do not have `crypto`\n  } else if (typeof window === 'object') {\n    // Old junk\n    Rand.prototype._rand = function() {\n      throw new Error('Not implemented yet');\n    };\n  }\n} else {\n  // Node.js or Web worker with no crypto support\n  try {\n    var crypto = require('crypto');\n    if (typeof crypto.randomBytes !== 'function')\n      throw new Error('Not supported');\n\n    Rand.prototype._rand = function _rand(n) {\n      return crypto.randomBytes(n);\n    };\n  } catch (e) {\n  }\n}","deps":{"crypto":"node_modules/browser-resolve/empty.js"}},{"id":"node_modules/browser-resolve/empty.js","source":"","deps":{}},{"id":"node_modules/browserify-aes/aes.js","source":"var Buffer = require('safe-buffer').Buffer\n\nfunction asUInt32Array (buf) {\n  if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf)\n\n  var len = (buf.length / 4) | 0\n  var out = new Array(len)\n\n  for (var i = 0; i < len; i++) {\n    out[i] = buf.readUInt32BE(i * 4)\n  }\n\n  return out\n}\n\nfunction scrubVec (v) {\n  for (var i = 0; i < v.length; v++) {\n    v[i] = 0\n  }\n}\n\nfunction cryptBlock (M, keySchedule, SUB_MIX, SBOX, nRounds) {\n  var SUB_MIX0 = SUB_MIX[0]\n  var SUB_MIX1 = SUB_MIX[1]\n  var SUB_MIX2 = SUB_MIX[2]\n  var SUB_MIX3 = SUB_MIX[3]\n\n  var s0 = M[0] ^ keySchedule[0]\n  var s1 = M[1] ^ keySchedule[1]\n  var s2 = M[2] ^ keySchedule[2]\n  var s3 = M[3] ^ keySchedule[3]\n  var t0, t1, t2, t3\n  var ksRow = 4\n\n  for (var round = 1; round < nRounds; round++) {\n    t0 = SUB_MIX0[s0 >>> 24] ^ SUB_MIX1[(s1 >>> 16) & 0xff] ^ SUB_MIX2[(s2 >>> 8) & 0xff] ^ SUB_MIX3[s3 & 0xff] ^ keySchedule[ksRow++]\n    t1 = SUB_MIX0[s1 >>> 24] ^ SUB_MIX1[(s2 >>> 16) & 0xff] ^ SUB_MIX2[(s3 >>> 8) & 0xff] ^ SUB_MIX3[s0 & 0xff] ^ keySchedule[ksRow++]\n    t2 = SUB_MIX0[s2 >>> 24] ^ SUB_MIX1[(s3 >>> 16) & 0xff] ^ SUB_MIX2[(s0 >>> 8) & 0xff] ^ SUB_MIX3[s1 & 0xff] ^ keySchedule[ksRow++]\n    t3 = SUB_MIX0[s3 >>> 24] ^ SUB_MIX1[(s0 >>> 16) & 0xff] ^ SUB_MIX2[(s1 >>> 8) & 0xff] ^ SUB_MIX3[s2 & 0xff] ^ keySchedule[ksRow++]\n    s0 = t0\n    s1 = t1\n    s2 = t2\n    s3 = t3\n  }\n\n  t0 = ((SBOX[s0 >>> 24] << 24) | (SBOX[(s1 >>> 16) & 0xff] << 16) | (SBOX[(s2 >>> 8) & 0xff] << 8) | SBOX[s3 & 0xff]) ^ keySchedule[ksRow++]\n  t1 = ((SBOX[s1 >>> 24] << 24) | (SBOX[(s2 >>> 16) & 0xff] << 16) | (SBOX[(s3 >>> 8) & 0xff] << 8) | SBOX[s0 & 0xff]) ^ keySchedule[ksRow++]\n  t2 = ((SBOX[s2 >>> 24] << 24) | (SBOX[(s3 >>> 16) & 0xff] << 16) | (SBOX[(s0 >>> 8) & 0xff] << 8) | SBOX[s1 & 0xff]) ^ keySchedule[ksRow++]\n  t3 = ((SBOX[s3 >>> 24] << 24) | (SBOX[(s0 >>> 16) & 0xff] << 16) | (SBOX[(s1 >>> 8) & 0xff] << 8) | SBOX[s2 & 0xff]) ^ keySchedule[ksRow++]\n  t0 = t0 >>> 0\n  t1 = t1 >>> 0\n  t2 = t2 >>> 0\n  t3 = t3 >>> 0\n\n  return [t0, t1, t2, t3]\n}\n\n// AES constants\nvar RCON = [0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36]\nvar G = (function () {\n  // Compute double table\n  var d = new Array(256)\n  for (var j = 0; j < 256; j++) {\n    if (j < 128) {\n      d[j] = j << 1\n    } else {\n      d[j] = (j << 1) ^ 0x11b\n    }\n  }\n\n  var SBOX = []\n  var INV_SBOX = []\n  var SUB_MIX = [[], [], [], []]\n  var INV_SUB_MIX = [[], [], [], []]\n\n  // Walk GF(2^8)\n  var x = 0\n  var xi = 0\n  for (var i = 0; i < 256; ++i) {\n    // Compute sbox\n    var sx = xi ^ (xi << 1) ^ (xi << 2) ^ (xi << 3) ^ (xi << 4)\n    sx = (sx >>> 8) ^ (sx & 0xff) ^ 0x63\n    SBOX[x] = sx\n    INV_SBOX[sx] = x\n\n    // Compute multiplication\n    var x2 = d[x]\n    var x4 = d[x2]\n    var x8 = d[x4]\n\n    // Compute sub bytes, mix columns tables\n    var t = (d[sx] * 0x101) ^ (sx * 0x1010100)\n    SUB_MIX[0][x] = (t << 24) | (t >>> 8)\n    SUB_MIX[1][x] = (t << 16) | (t >>> 16)\n    SUB_MIX[2][x] = (t << 8) | (t >>> 24)\n    SUB_MIX[3][x] = t\n\n    // Compute inv sub bytes, inv mix columns tables\n    t = (x8 * 0x1010101) ^ (x4 * 0x10001) ^ (x2 * 0x101) ^ (x * 0x1010100)\n    INV_SUB_MIX[0][sx] = (t << 24) | (t >>> 8)\n    INV_SUB_MIX[1][sx] = (t << 16) | (t >>> 16)\n    INV_SUB_MIX[2][sx] = (t << 8) | (t >>> 24)\n    INV_SUB_MIX[3][sx] = t\n\n    if (x === 0) {\n      x = xi = 1\n    } else {\n      x = x2 ^ d[d[d[x8 ^ x2]]]\n      xi ^= d[d[xi]]\n    }\n  }\n\n  return {\n    SBOX: SBOX,\n    INV_SBOX: INV_SBOX,\n    SUB_MIX: SUB_MIX,\n    INV_SUB_MIX: INV_SUB_MIX\n  }\n})()\n\nfunction AES (key) {\n  this._key = asUInt32Array(key)\n  this._reset()\n}\n\nAES.blockSize = 4 * 4\nAES.keySize = 256 / 8\nAES.prototype.blockSize = AES.blockSize\nAES.prototype.keySize = AES.keySize\nAES.prototype._reset = function () {\n  var keyWords = this._key\n  var keySize = keyWords.length\n  var nRounds = keySize + 6\n  var ksRows = (nRounds + 1) * 4\n\n  var keySchedule = []\n  for (var k = 0; k < keySize; k++) {\n    keySchedule[k] = keyWords[k]\n  }\n\n  for (k = keySize; k < ksRows; k++) {\n    var t = keySchedule[k - 1]\n\n    if (k % keySize === 0) {\n      t = (t << 8) | (t >>> 24)\n      t =\n        (G.SBOX[t >>> 24] << 24) |\n        (G.SBOX[(t >>> 16) & 0xff] << 16) |\n        (G.SBOX[(t >>> 8) & 0xff] << 8) |\n        (G.SBOX[t & 0xff])\n\n      t ^= RCON[(k / keySize) | 0] << 24\n    } else if (keySize > 6 && k % keySize === 4) {\n      t =\n        (G.SBOX[t >>> 24] << 24) |\n        (G.SBOX[(t >>> 16) & 0xff] << 16) |\n        (G.SBOX[(t >>> 8) & 0xff] << 8) |\n        (G.SBOX[t & 0xff])\n    }\n\n    keySchedule[k] = keySchedule[k - keySize] ^ t\n  }\n\n  var invKeySchedule = []\n  for (var ik = 0; ik < ksRows; ik++) {\n    var ksR = ksRows - ik\n    var tt = keySchedule[ksR - (ik % 4 ? 0 : 4)]\n\n    if (ik < 4 || ksR <= 4) {\n      invKeySchedule[ik] = tt\n    } else {\n      invKeySchedule[ik] =\n        G.INV_SUB_MIX[0][G.SBOX[tt >>> 24]] ^\n        G.INV_SUB_MIX[1][G.SBOX[(tt >>> 16) & 0xff]] ^\n        G.INV_SUB_MIX[2][G.SBOX[(tt >>> 8) & 0xff]] ^\n        G.INV_SUB_MIX[3][G.SBOX[tt & 0xff]]\n    }\n  }\n\n  this._nRounds = nRounds\n  this._keySchedule = keySchedule\n  this._invKeySchedule = invKeySchedule\n}\n\nAES.prototype.encryptBlockRaw = function (M) {\n  M = asUInt32Array(M)\n  return cryptBlock(M, this._keySchedule, G.SUB_MIX, G.SBOX, this._nRounds)\n}\n\nAES.prototype.encryptBlock = function (M) {\n  var out = this.encryptBlockRaw(M)\n  var buf = Buffer.allocUnsafe(16)\n  buf.writeUInt32BE(out[0], 0)\n  buf.writeUInt32BE(out[1], 4)\n  buf.writeUInt32BE(out[2], 8)\n  buf.writeUInt32BE(out[3], 12)\n  return buf\n}\n\nAES.prototype.decryptBlock = function (M) {\n  M = asUInt32Array(M)\n\n  // swap\n  var m1 = M[1]\n  M[1] = M[3]\n  M[3] = m1\n\n  var out = cryptBlock(M, this._invKeySchedule, G.INV_SUB_MIX, G.INV_SBOX, this._nRounds)\n  var buf = Buffer.allocUnsafe(16)\n  buf.writeUInt32BE(out[0], 0)\n  buf.writeUInt32BE(out[3], 4)\n  buf.writeUInt32BE(out[2], 8)\n  buf.writeUInt32BE(out[1], 12)\n  return buf\n}\n\nAES.prototype.scrub = function () {\n  scrubVec(this._keySchedule)\n  scrubVec(this._invKeySchedule)\n  scrubVec(this._key)\n}\n\nmodule.exports.AES = AES","deps":{"safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/authCipher.js","source":"var aes = require('./aes')\nvar Buffer = require('safe-buffer').Buffer\nvar Transform = require('cipher-base')\nvar inherits = require('inherits')\nvar GHASH = require('./ghash')\nvar xor = require('buffer-xor')\nvar incr32 = require('./incr32')\n\nfunction xorTest (a, b) {\n  var out = 0\n  if (a.length !== b.length) out++\n\n  var len = Math.min(a.length, b.length)\n  for (var i = 0; i < len; ++i) {\n    out += (a[i] ^ b[i])\n  }\n\n  return out\n}\n\nfunction calcIv (self, iv, ck) {\n  if (iv.length === 12) {\n    self._finID = Buffer.concat([iv, Buffer.from([0, 0, 0, 1])])\n    return Buffer.concat([iv, Buffer.from([0, 0, 0, 2])])\n  }\n  var ghash = new GHASH(ck)\n  var len = iv.length\n  var toPad = len % 16\n  ghash.update(iv)\n  if (toPad) {\n    toPad = 16 - toPad\n    ghash.update(Buffer.alloc(toPad, 0))\n  }\n  ghash.update(Buffer.alloc(8, 0))\n  var ivBits = len * 8\n  var tail = Buffer.alloc(8)\n  tail.writeUIntBE(ivBits, 0, 8)\n  ghash.update(tail)\n  self._finID = ghash.state\n  var out = Buffer.from(self._finID)\n  incr32(out)\n  return out\n}\nfunction StreamCipher (mode, key, iv, decrypt) {\n  Transform.call(this)\n\n  var h = Buffer.alloc(4, 0)\n\n  this._cipher = new aes.AES(key)\n  var ck = this._cipher.encryptBlock(h)\n  this._ghash = new GHASH(ck)\n  iv = calcIv(this, iv, ck)\n\n  this._prev = Buffer.from(iv)\n  this._cache = Buffer.allocUnsafe(0)\n  this._secCache = Buffer.allocUnsafe(0)\n  this._decrypt = decrypt\n  this._alen = 0\n  this._len = 0\n  this._mode = mode\n\n  this._authTag = null\n  this._called = false\n}\n\ninherits(StreamCipher, Transform)\n\nStreamCipher.prototype._update = function (chunk) {\n  if (!this._called && this._alen) {\n    var rump = 16 - (this._alen % 16)\n    if (rump < 16) {\n      rump = Buffer.alloc(rump, 0)\n      this._ghash.update(rump)\n    }\n  }\n\n  this._called = true\n  var out = this._mode.encrypt(this, chunk)\n  if (this._decrypt) {\n    this._ghash.update(chunk)\n  } else {\n    this._ghash.update(out)\n  }\n  this._len += chunk.length\n  return out\n}\n\nStreamCipher.prototype._final = function () {\n  if (this._decrypt && !this._authTag) throw new Error('Unsupported state or unable to authenticate data')\n\n  var tag = xor(this._ghash.final(this._alen * 8, this._len * 8), this._cipher.encryptBlock(this._finID))\n  if (this._decrypt && xorTest(tag, this._authTag)) throw new Error('Unsupported state or unable to authenticate data')\n\n  this._authTag = tag\n  this._cipher.scrub()\n}\n\nStreamCipher.prototype.getAuthTag = function getAuthTag () {\n  if (this._decrypt || !Buffer.isBuffer(this._authTag)) throw new Error('Attempting to get auth tag in unsupported state')\n\n  return this._authTag\n}\n\nStreamCipher.prototype.setAuthTag = function setAuthTag (tag) {\n  if (!this._decrypt) throw new Error('Attempting to set auth tag in unsupported state')\n\n  this._authTag = tag\n}\n\nStreamCipher.prototype.setAAD = function setAAD (buf) {\n  if (this._called) throw new Error('Attempting to set AAD in unsupported state')\n\n  this._ghash.update(buf)\n  this._alen += buf.length\n}\n\nmodule.exports = StreamCipher","deps":{"./aes":"node_modules/browserify-aes/aes.js","./ghash":"node_modules/browserify-aes/ghash.js","./incr32":"node_modules/browserify-aes/incr32.js","buffer-xor":"node_modules/buffer-xor/index.js","cipher-base":"node_modules/cipher-base/index.js","inherits":"node_modules/inherits/inherits_browser.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/browser.js","source":"var ciphers = require('./encrypter')\nvar deciphers = require('./decrypter')\nvar modes = require('./modes/list.json')\n\nfunction getCiphers () {\n  return Object.keys(modes)\n}\n\nexports.createCipher = exports.Cipher = ciphers.createCipher\nexports.createCipheriv = exports.Cipheriv = ciphers.createCipheriv\nexports.createDecipher = exports.Decipher = deciphers.createDecipher\nexports.createDecipheriv = exports.Decipheriv = deciphers.createDecipheriv\nexports.listCiphers = exports.getCiphers = getCiphers","deps":{"./decrypter":"node_modules/browserify-aes/decrypter.js","./encrypter":"node_modules/browserify-aes/encrypter.js","./modes/list.json":"node_modules/browserify-aes/modes/list.json"}},{"id":"node_modules/browserify-aes/decrypter.js","source":"var AuthCipher = require('./authCipher')\nvar Buffer = require('safe-buffer').Buffer\nvar MODES = require('./modes')\nvar StreamCipher = require('./streamCipher')\nvar Transform = require('cipher-base')\nvar aes = require('./aes')\nvar ebtk = require('evp_bytestokey')\nvar inherits = require('inherits')\n\nfunction Decipher (mode, key, iv) {\n  Transform.call(this)\n\n  this._cache = new Splitter()\n  this._last = void 0\n  this._cipher = new aes.AES(key)\n  this._prev = Buffer.from(iv)\n  this._mode = mode\n  this._autopadding = true\n}\n\ninherits(Decipher, Transform)\n\nDecipher.prototype._update = function (data) {\n  this._cache.add(data)\n  var chunk\n  var thing\n  var out = []\n  while ((chunk = this._cache.get(this._autopadding))) {\n    thing = this._mode.decrypt(this, chunk)\n    out.push(thing)\n  }\n  return Buffer.concat(out)\n}\n\nDecipher.prototype._final = function () {\n  var chunk = this._cache.flush()\n  if (this._autopadding) {\n    return unpad(this._mode.decrypt(this, chunk))\n  } else if (chunk) {\n    throw new Error('data not multiple of block length')\n  }\n}\n\nDecipher.prototype.setAutoPadding = function (setTo) {\n  this._autopadding = !!setTo\n  return this\n}\n\nfunction Splitter () {\n  this.cache = Buffer.allocUnsafe(0)\n}\n\nSplitter.prototype.add = function (data) {\n  this.cache = Buffer.concat([this.cache, data])\n}\n\nSplitter.prototype.get = function (autoPadding) {\n  var out\n  if (autoPadding) {\n    if (this.cache.length > 16) {\n      out = this.cache.slice(0, 16)\n      this.cache = this.cache.slice(16)\n      return out\n    }\n  } else {\n    if (this.cache.length >= 16) {\n      out = this.cache.slice(0, 16)\n      this.cache = this.cache.slice(16)\n      return out\n    }\n  }\n\n  return null\n}\n\nSplitter.prototype.flush = function () {\n  if (this.cache.length) return this.cache\n}\n\nfunction unpad (last) {\n  var padded = last[15]\n  if (padded < 1 || padded > 16) {\n    throw new Error('unable to decrypt data')\n  }\n  var i = -1\n  while (++i < padded) {\n    if (last[(i + (16 - padded))] !== padded) {\n      throw new Error('unable to decrypt data')\n    }\n  }\n  if (padded === 16) return\n\n  return last.slice(0, 16 - padded)\n}\n\nfunction createDecipheriv (suite, password, iv) {\n  var config = MODES[suite.toLowerCase()]\n  if (!config) throw new TypeError('invalid suite type')\n\n  if (typeof iv === 'string') iv = Buffer.from(iv)\n  if (config.mode !== 'GCM' && iv.length !== config.iv) throw new TypeError('invalid iv length ' + iv.length)\n\n  if (typeof password === 'string') password = Buffer.from(password)\n  if (password.length !== config.key / 8) throw new TypeError('invalid key length ' + password.length)\n\n  if (config.type === 'stream') {\n    return new StreamCipher(config.module, password, iv, true)\n  } else if (config.type === 'auth') {\n    return new AuthCipher(config.module, password, iv, true)\n  }\n\n  return new Decipher(config.module, password, iv)\n}\n\nfunction createDecipher (suite, password) {\n  var config = MODES[suite.toLowerCase()]\n  if (!config) throw new TypeError('invalid suite type')\n\n  var keys = ebtk(password, false, config.key, config.iv)\n  return createDecipheriv(suite, keys.key, keys.iv)\n}\n\nexports.createDecipher = createDecipher\nexports.createDecipheriv = createDecipheriv","deps":{"./aes":"node_modules/browserify-aes/aes.js","./authCipher":"node_modules/browserify-aes/authCipher.js","./modes":"node_modules/browserify-aes/modes/index.js","./streamCipher":"node_modules/browserify-aes/streamCipher.js","cipher-base":"node_modules/cipher-base/index.js","evp_bytestokey":"node_modules/evp_bytestokey/index.js","inherits":"node_modules/inherits/inherits_browser.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/encrypter.js","source":"var MODES = require('./modes')\nvar AuthCipher = require('./authCipher')\nvar Buffer = require('safe-buffer').Buffer\nvar StreamCipher = require('./streamCipher')\nvar Transform = require('cipher-base')\nvar aes = require('./aes')\nvar ebtk = require('evp_bytestokey')\nvar inherits = require('inherits')\n\nfunction Cipher (mode, key, iv) {\n  Transform.call(this)\n\n  this._cache = new Splitter()\n  this._cipher = new aes.AES(key)\n  this._prev = Buffer.from(iv)\n  this._mode = mode\n  this._autopadding = true\n}\n\ninherits(Cipher, Transform)\n\nCipher.prototype._update = function (data) {\n  this._cache.add(data)\n  var chunk\n  var thing\n  var out = []\n\n  while ((chunk = this._cache.get())) {\n    thing = this._mode.encrypt(this, chunk)\n    out.push(thing)\n  }\n\n  return Buffer.concat(out)\n}\n\nvar PADDING = Buffer.alloc(16, 0x10)\n\nCipher.prototype._final = function () {\n  var chunk = this._cache.flush()\n  if (this._autopadding) {\n    chunk = this._mode.encrypt(this, chunk)\n    this._cipher.scrub()\n    return chunk\n  }\n\n  if (!chunk.equals(PADDING)) {\n    this._cipher.scrub()\n    throw new Error('data not multiple of block length')\n  }\n}\n\nCipher.prototype.setAutoPadding = function (setTo) {\n  this._autopadding = !!setTo\n  return this\n}\n\nfunction Splitter () {\n  this.cache = Buffer.allocUnsafe(0)\n}\n\nSplitter.prototype.add = function (data) {\n  this.cache = Buffer.concat([this.cache, data])\n}\n\nSplitter.prototype.get = function () {\n  if (this.cache.length > 15) {\n    var out = this.cache.slice(0, 16)\n    this.cache = this.cache.slice(16)\n    return out\n  }\n  return null\n}\n\nSplitter.prototype.flush = function () {\n  var len = 16 - this.cache.length\n  var padBuff = Buffer.allocUnsafe(len)\n\n  var i = -1\n  while (++i < len) {\n    padBuff.writeUInt8(len, i)\n  }\n\n  return Buffer.concat([this.cache, padBuff])\n}\n\nfunction createCipheriv (suite, password, iv) {\n  var config = MODES[suite.toLowerCase()]\n  if (!config) throw new TypeError('invalid suite type')\n\n  if (typeof password === 'string') password = Buffer.from(password)\n  if (password.length !== config.key / 8) throw new TypeError('invalid key length ' + password.length)\n\n  if (typeof iv === 'string') iv = Buffer.from(iv)\n  if (config.mode !== 'GCM' && iv.length !== config.iv) throw new TypeError('invalid iv length ' + iv.length)\n\n  if (config.type === 'stream') {\n    return new StreamCipher(config.module, password, iv)\n  } else if (config.type === 'auth') {\n    return new AuthCipher(config.module, password, iv)\n  }\n\n  return new Cipher(config.module, password, iv)\n}\n\nfunction createCipher (suite, password) {\n  var config = MODES[suite.toLowerCase()]\n  if (!config) throw new TypeError('invalid suite type')\n\n  var keys = ebtk(password, false, config.key, config.iv)\n  return createCipheriv(suite, keys.key, keys.iv)\n}\n\nexports.createCipheriv = createCipheriv\nexports.createCipher = createCipher","deps":{"./aes":"node_modules/browserify-aes/aes.js","./authCipher":"node_modules/browserify-aes/authCipher.js","./modes":"node_modules/browserify-aes/modes/index.js","./streamCipher":"node_modules/browserify-aes/streamCipher.js","cipher-base":"node_modules/cipher-base/index.js","evp_bytestokey":"node_modules/evp_bytestokey/index.js","inherits":"node_modules/inherits/inherits_browser.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/ghash.js","source":"var Buffer = require('safe-buffer').Buffer\nvar ZEROES = Buffer.alloc(16, 0)\n\nfunction toArray (buf) {\n  return [\n    buf.readUInt32BE(0),\n    buf.readUInt32BE(4),\n    buf.readUInt32BE(8),\n    buf.readUInt32BE(12)\n  ]\n}\n\nfunction fromArray (out) {\n  var buf = Buffer.allocUnsafe(16)\n  buf.writeUInt32BE(out[0] >>> 0, 0)\n  buf.writeUInt32BE(out[1] >>> 0, 4)\n  buf.writeUInt32BE(out[2] >>> 0, 8)\n  buf.writeUInt32BE(out[3] >>> 0, 12)\n  return buf\n}\n\nfunction GHASH (key) {\n  this.h = key\n  this.state = Buffer.alloc(16, 0)\n  this.cache = Buffer.allocUnsafe(0)\n}\n\n// from http://bitwiseshiftleft.github.io/sjcl/doc/symbols/src/core_gcm.js.html\n// by Juho Vähä-Herttua\nGHASH.prototype.ghash = function (block) {\n  var i = -1\n  while (++i < block.length) {\n    this.state[i] ^= block[i]\n  }\n  this._multiply()\n}\n\nGHASH.prototype._multiply = function () {\n  var Vi = toArray(this.h)\n  var Zi = [0, 0, 0, 0]\n  var j, xi, lsbVi\n  var i = -1\n  while (++i < 128) {\n    xi = (this.state[~~(i / 8)] & (1 << (7 - (i % 8)))) !== 0\n    if (xi) {\n      // Z_i+1 = Z_i ^ V_i\n      Zi[0] ^= Vi[0]\n      Zi[1] ^= Vi[1]\n      Zi[2] ^= Vi[2]\n      Zi[3] ^= Vi[3]\n    }\n\n    // Store the value of LSB(V_i)\n    lsbVi = (Vi[3] & 1) !== 0\n\n    // V_i+1 = V_i >> 1\n    for (j = 3; j > 0; j--) {\n      Vi[j] = (Vi[j] >>> 1) | ((Vi[j - 1] & 1) << 31)\n    }\n    Vi[0] = Vi[0] >>> 1\n\n    // If LSB(V_i) is 1, V_i+1 = (V_i >> 1) ^ R\n    if (lsbVi) {\n      Vi[0] = Vi[0] ^ (0xe1 << 24)\n    }\n  }\n  this.state = fromArray(Zi)\n}\n\nGHASH.prototype.update = function (buf) {\n  this.cache = Buffer.concat([this.cache, buf])\n  var chunk\n  while (this.cache.length >= 16) {\n    chunk = this.cache.slice(0, 16)\n    this.cache = this.cache.slice(16)\n    this.ghash(chunk)\n  }\n}\n\nGHASH.prototype.final = function (abl, bl) {\n  if (this.cache.length) {\n    this.ghash(Buffer.concat([this.cache, ZEROES], 16))\n  }\n\n  this.ghash(fromArray([0, abl, 0, bl]))\n  return this.state\n}\n\nmodule.exports = GHASH","deps":{"safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/incr32.js","source":"function incr32 (iv) {\n  var len = iv.length\n  var item\n  while (len--) {\n    item = iv.readUInt8(len)\n    if (item === 255) {\n      iv.writeUInt8(0, len)\n    } else {\n      item++\n      iv.writeUInt8(item, len)\n      break\n    }\n  }\n}\nmodule.exports = incr32","deps":{}},{"id":"node_modules/browserify-aes/modes/cbc.js","source":"var xor = require('buffer-xor')\n\nexports.encrypt = function (self, block) {\n  var data = xor(block, self._prev)\n\n  self._prev = self._cipher.encryptBlock(data)\n  return self._prev\n}\n\nexports.decrypt = function (self, block) {\n  var pad = self._prev\n\n  self._prev = block\n  var out = self._cipher.decryptBlock(block)\n\n  return xor(out, pad)\n}","deps":{"buffer-xor":"node_modules/buffer-xor/index.js"}},{"id":"node_modules/browserify-aes/modes/cfb.js","source":"var Buffer = require('safe-buffer').Buffer\nvar xor = require('buffer-xor')\n\nfunction encryptStart (self, data, decrypt) {\n  var len = data.length\n  var out = xor(data, self._cache)\n  self._cache = self._cache.slice(len)\n  self._prev = Buffer.concat([self._prev, decrypt ? data : out])\n  return out\n}\n\nexports.encrypt = function (self, data, decrypt) {\n  var out = Buffer.allocUnsafe(0)\n  var len\n\n  while (data.length) {\n    if (self._cache.length === 0) {\n      self._cache = self._cipher.encryptBlock(self._prev)\n      self._prev = Buffer.allocUnsafe(0)\n    }\n\n    if (self._cache.length <= data.length) {\n      len = self._cache.length\n      out = Buffer.concat([out, encryptStart(self, data.slice(0, len), decrypt)])\n      data = data.slice(len)\n    } else {\n      out = Buffer.concat([out, encryptStart(self, data, decrypt)])\n      break\n    }\n  }\n\n  return out\n}","deps":{"buffer-xor":"node_modules/buffer-xor/index.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/modes/cfb1.js","source":"var Buffer = require('safe-buffer').Buffer\n\nfunction encryptByte (self, byteParam, decrypt) {\n  var pad\n  var i = -1\n  var len = 8\n  var out = 0\n  var bit, value\n  while (++i < len) {\n    pad = self._cipher.encryptBlock(self._prev)\n    bit = (byteParam & (1 << (7 - i))) ? 0x80 : 0\n    value = pad[0] ^ bit\n    out += ((value & 0x80) >> (i % 8))\n    self._prev = shiftIn(self._prev, decrypt ? bit : value)\n  }\n  return out\n}\n\nfunction shiftIn (buffer, value) {\n  var len = buffer.length\n  var i = -1\n  var out = Buffer.allocUnsafe(buffer.length)\n  buffer = Buffer.concat([buffer, Buffer.from([value])])\n\n  while (++i < len) {\n    out[i] = buffer[i] << 1 | buffer[i + 1] >> (7)\n  }\n\n  return out\n}\n\nexports.encrypt = function (self, chunk, decrypt) {\n  var len = chunk.length\n  var out = Buffer.allocUnsafe(len)\n  var i = -1\n\n  while (++i < len) {\n    out[i] = encryptByte(self, chunk[i], decrypt)\n  }\n\n  return out\n}","deps":{"safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/modes/cfb8.js","source":"var Buffer = require('safe-buffer').Buffer\n\nfunction encryptByte (self, byteParam, decrypt) {\n  var pad = self._cipher.encryptBlock(self._prev)\n  var out = pad[0] ^ byteParam\n\n  self._prev = Buffer.concat([\n    self._prev.slice(1),\n    Buffer.from([decrypt ? byteParam : out])\n  ])\n\n  return out\n}\n\nexports.encrypt = function (self, chunk, decrypt) {\n  var len = chunk.length\n  var out = Buffer.allocUnsafe(len)\n  var i = -1\n\n  while (++i < len) {\n    out[i] = encryptByte(self, chunk[i], decrypt)\n  }\n\n  return out\n}","deps":{"safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/modes/ctr.js","source":"var xor = require('buffer-xor')\nvar Buffer = require('safe-buffer').Buffer\nvar incr32 = require('../incr32')\n\nfunction getBlock (self) {\n  var out = self._cipher.encryptBlockRaw(self._prev)\n  incr32(self._prev)\n  return out\n}\n\nvar blockSize = 16\nexports.encrypt = function (self, chunk) {\n  var chunkNum = Math.ceil(chunk.length / blockSize)\n  var start = self._cache.length\n  self._cache = Buffer.concat([\n    self._cache,\n    Buffer.allocUnsafe(chunkNum * blockSize)\n  ])\n  for (var i = 0; i < chunkNum; i++) {\n    var out = getBlock(self)\n    var offset = start + i * blockSize\n    self._cache.writeUInt32BE(out[0], offset + 0)\n    self._cache.writeUInt32BE(out[1], offset + 4)\n    self._cache.writeUInt32BE(out[2], offset + 8)\n    self._cache.writeUInt32BE(out[3], offset + 12)\n  }\n  var pad = self._cache.slice(0, chunk.length)\n  self._cache = self._cache.slice(chunk.length)\n  return xor(chunk, pad)\n}","deps":{"../incr32":"node_modules/browserify-aes/incr32.js","buffer-xor":"node_modules/buffer-xor/index.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-aes/modes/ecb.js","source":"exports.encrypt = function (self, block) {\n  return self._cipher.encryptBlock(block)\n}\n\nexports.decrypt = function (self, block) {\n  return self._cipher.decryptBlock(block)\n}","deps":{}},{"id":"node_modules/browserify-aes/modes/index.js","source":"var modeModules = {\n  ECB: require('./ecb'),\n  CBC: require('./cbc'),\n  CFB: require('./cfb'),\n  CFB8: require('./cfb8'),\n  CFB1: require('./cfb1'),\n  OFB: require('./ofb'),\n  CTR: require('./ctr'),\n  GCM: require('./ctr')\n}\n\nvar modes = require('./list.json')\n\nfor (var key in modes) {\n  modes[key].module = modeModules[modes[key].mode]\n}\n\nmodule.exports = modes","deps":{"./cbc":"node_modules/browserify-aes/modes/cbc.js","./cfb":"node_modules/browserify-aes/modes/cfb.js","./cfb1":"node_modules/browserify-aes/modes/cfb1.js","./cfb8":"node_modules/browserify-aes/modes/cfb8.js","./ctr":"node_modules/browserify-aes/modes/ctr.js","./ecb":"node_modules/browserify-aes/modes/ecb.js","./list.json":"node_modules/browserify-aes/modes/list.json","./ofb":"node_modules/browserify-aes/modes/ofb.js"}},{"id":"node_modules/browserify-aes/modes/list.json","source":"module.exports={\n  \"aes-128-ecb\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 0,\n    \"mode\": \"ECB\",\n    \"type\": \"block\"\n  },\n  \"aes-192-ecb\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 0,\n    \"mode\": \"ECB\",\n    \"type\": \"block\"\n  },\n  \"aes-256-ecb\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 0,\n    \"mode\": \"ECB\",\n    \"type\": \"block\"\n  },\n  \"aes-128-cbc\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"CBC\",\n    \"type\": \"block\"\n  },\n  \"aes-192-cbc\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"CBC\",\n    \"type\": \"block\"\n  },\n  \"aes-256-cbc\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"CBC\",\n    \"type\": \"block\"\n  },\n  \"aes128\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"CBC\",\n    \"type\": \"block\"\n  },\n  \"aes192\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"CBC\",\n    \"type\": \"block\"\n  },\n  \"aes256\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"CBC\",\n    \"type\": \"block\"\n  },\n  \"aes-128-cfb\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"CFB\",\n    \"type\": \"stream\"\n  },\n  \"aes-192-cfb\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"CFB\",\n    \"type\": \"stream\"\n  },\n  \"aes-256-cfb\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"CFB\",\n    \"type\": \"stream\"\n  },\n  \"aes-128-cfb8\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"CFB8\",\n    \"type\": \"stream\"\n  },\n  \"aes-192-cfb8\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"CFB8\",\n    \"type\": \"stream\"\n  },\n  \"aes-256-cfb8\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"CFB8\",\n    \"type\": \"stream\"\n  },\n  \"aes-128-cfb1\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"CFB1\",\n    \"type\": \"stream\"\n  },\n  \"aes-192-cfb1\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"CFB1\",\n    \"type\": \"stream\"\n  },\n  \"aes-256-cfb1\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"CFB1\",\n    \"type\": \"stream\"\n  },\n  \"aes-128-ofb\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"OFB\",\n    \"type\": \"stream\"\n  },\n  \"aes-192-ofb\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"OFB\",\n    \"type\": \"stream\"\n  },\n  \"aes-256-ofb\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"OFB\",\n    \"type\": \"stream\"\n  },\n  \"aes-128-ctr\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 16,\n    \"mode\": \"CTR\",\n    \"type\": \"stream\"\n  },\n  \"aes-192-ctr\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 16,\n    \"mode\": \"CTR\",\n    \"type\": \"stream\"\n  },\n  \"aes-256-ctr\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 16,\n    \"mode\": \"CTR\",\n    \"type\": \"stream\"\n  },\n  \"aes-128-gcm\": {\n    \"cipher\": \"AES\",\n    \"key\": 128,\n    \"iv\": 12,\n    \"mode\": \"GCM\",\n    \"type\": \"auth\"\n  },\n  \"aes-192-gcm\": {\n    \"cipher\": \"AES\",\n    \"key\": 192,\n    \"iv\": 12,\n    \"mode\": \"GCM\",\n    \"type\": \"auth\"\n  },\n  \"aes-256-gcm\": {\n    \"cipher\": \"AES\",\n    \"key\": 256,\n    \"iv\": 12,\n    \"mode\": \"GCM\",\n    \"type\": \"auth\"\n  }\n}","deps":{}},{"id":"node_modules/browserify-aes/modes/ofb.js","source":"(function (Buffer){\nvar xor = require('buffer-xor')\n\nfunction getBlock (self) {\n  self._prev = self._cipher.encryptBlock(self._prev)\n  return self._prev\n}\n\nexports.encrypt = function (self, chunk) {\n  while (self._cache.length < chunk.length) {\n    self._cache = Buffer.concat([self._cache, getBlock(self)])\n  }\n\n  var pad = self._cache.slice(0, chunk.length)\n  self._cache = self._cache.slice(chunk.length)\n  return xor(chunk, pad)\n}\n\n}).call(this,require(\"buffer\").Buffer)","deps":{"buffer":"node_modules/buffer/index.js","buffer-xor":"node_modules/buffer-xor/index.js"}},{"id":"node_modules/browserify-aes/streamCipher.js","source":"var aes = require('./aes')\nvar Buffer = require('safe-buffer').Buffer\nvar Transform = require('cipher-base')\nvar inherits = require('inherits')\n\nfunction StreamCipher (mode, key, iv, decrypt) {\n  Transform.call(this)\n\n  this._cipher = new aes.AES(key)\n  this._prev = Buffer.from(iv)\n  this._cache = Buffer.allocUnsafe(0)\n  this._secCache = Buffer.allocUnsafe(0)\n  this._decrypt = decrypt\n  this._mode = mode\n}\n\ninherits(StreamCipher, Transform)\n\nStreamCipher.prototype._update = function (chunk) {\n  return this._mode.encrypt(this, chunk, this._decrypt)\n}\n\nStreamCipher.prototype._final = function () {\n  this._cipher.scrub()\n}\n\nmodule.exports = StreamCipher","deps":{"./aes":"node_modules/browserify-aes/aes.js","cipher-base":"node_modules/cipher-base/index.js","inherits":"node_modules/inherits/inherits_browser.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-cipher/browser.js","source":"var DES = require('browserify-des')\nvar aes = require('browserify-aes/browser')\nvar aesModes = require('browserify-aes/modes')\nvar desModes = require('browserify-des/modes')\nvar ebtk = require('evp_bytestokey')\n\nfunction createCipher (suite, password) {\n  suite = suite.toLowerCase()\n\n  var keyLen, ivLen\n  if (aesModes[suite]) {\n    keyLen = aesModes[suite].key\n    ivLen = aesModes[suite].iv\n  } else if (desModes[suite]) {\n    keyLen = desModes[suite].key * 8\n    ivLen = desModes[suite].iv\n  } else {\n    throw new TypeError('invalid suite type')\n  }\n\n  var keys = ebtk(password, false, keyLen, ivLen)\n  return createCipheriv(suite, keys.key, keys.iv)\n}\n\nfunction createDecipher (suite, password) {\n  suite = suite.toLowerCase()\n\n  var keyLen, ivLen\n  if (aesModes[suite]) {\n    keyLen = aesModes[suite].key\n    ivLen = aesModes[suite].iv\n  } else if (desModes[suite]) {\n    keyLen = desModes[suite].key * 8\n    ivLen = desModes[suite].iv\n  } else {\n    throw new TypeError('invalid suite type')\n  }\n\n  var keys = ebtk(password, false, keyLen, ivLen)\n  return createDecipheriv(suite, keys.key, keys.iv)\n}\n\nfunction createCipheriv (suite, key, iv) {\n  suite = suite.toLowerCase()\n  if (aesModes[suite]) return aes.createCipheriv(suite, key, iv)\n  if (desModes[suite]) return new DES({ key: key, iv: iv, mode: suite })\n\n  throw new TypeError('invalid suite type')\n}\n\nfunction createDecipheriv (suite, key, iv) {\n  suite = suite.toLowerCase()\n  if (aesModes[suite]) return aes.createDecipheriv(suite, key, iv)\n  if (desModes[suite]) return new DES({ key: key, iv: iv, mode: suite, decrypt: true })\n\n  throw new TypeError('invalid suite type')\n}\n\nfunction getCiphers () {\n  return Object.keys(desModes).concat(aes.getCiphers())\n}\n\nexports.createCipher = exports.Cipher = createCipher\nexports.createCipheriv = exports.Cipheriv = createCipheriv\nexports.createDecipher = exports.Decipher = createDecipher\nexports.createDecipheriv = exports.Decipheriv = createDecipheriv\nexports.listCiphers = exports.getCiphers = getCiphers","deps":{"browserify-aes/browser":"node_modules/browserify-aes/browser.js","browserify-aes/modes":"node_modules/browserify-aes/modes/index.js","browserify-des":"node_modules/browserify-des/index.js","browserify-des/modes":"node_modules/browserify-des/modes.js","evp_bytestokey":"node_modules/evp_bytestokey/index.js"}},{"id":"node_modules/browserify-des/index.js","source":"var CipherBase = require('cipher-base')\nvar des = require('des.js')\nvar inherits = require('inherits')\nvar Buffer = require('safe-buffer').Buffer\n\nvar modes = {\n  'des-ede3-cbc': des.CBC.instantiate(des.EDE),\n  'des-ede3': des.EDE,\n  'des-ede-cbc': des.CBC.instantiate(des.EDE),\n  'des-ede': des.EDE,\n  'des-cbc': des.CBC.instantiate(des.DES),\n  'des-ecb': des.DES\n}\nmodes.des = modes['des-cbc']\nmodes.des3 = modes['des-ede3-cbc']\nmodule.exports = DES\ninherits(DES, CipherBase)\nfunction DES (opts) {\n  CipherBase.call(this)\n  var modeName = opts.mode.toLowerCase()\n  var mode = modes[modeName]\n  var type\n  if (opts.decrypt) {\n    type = 'decrypt'\n  } else {\n    type = 'encrypt'\n  }\n  var key = opts.key\n  if (!Buffer.isBuffer(key)) {\n    key = Buffer.from(key)\n  }\n  if (modeName === 'des-ede' || modeName === 'des-ede-cbc') {\n    key = Buffer.concat([key, key.slice(0, 8)])\n  }\n  var iv = opts.iv\n  if (!Buffer.isBuffer(iv)) {\n    iv = Buffer.from(iv)\n  }\n  this._des = mode.create({\n    key: key,\n    iv: iv,\n    type: type\n  })\n}\nDES.prototype._update = function (data) {\n  return Buffer.from(this._des.update(data))\n}\nDES.prototype._final = function () {\n  return Buffer.from(this._des.final())\n}","deps":{"cipher-base":"node_modules/cipher-base/index.js","des.js":"node_modules/des.js/lib/des.js","inherits":"node_modules/inherits/inherits_browser.js","safe-buffer":"node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-des/modes.js","source":"exports['des-ecb'] = {\n  key: 8,\n  iv: 0\n}\nexports['des-cbc'] = exports.des = {\n  key: 8,\n  iv: 8\n}\nexports['des-ede3-cbc'] = exports.des3 = {\n  key: 24,\n  iv: 8\n}\nexports['des-ede3'] = {\n  key: 24,\n  iv: 0\n}\nexports['des-ede-cbc'] = {\n  key: 16,\n  iv: 8\n}\nexports['des-ede'] = {\n  key: 16,\n  iv: 0\n}","deps":{}},{"id":"node_modules/browserify-rsa/index.js","source":"(function (Buffer){\nvar bn = require('bn.js');\nvar randomBytes = require('randombytes');\nmodule.exports = crt;\nfunction blind(priv) {\n  var r = getr(priv);\n  var blinder = r.toRed(bn.mont(priv.modulus))\n  .redPow(new bn(priv.publicExponent)).fromRed();\n  return {\n    blinder: blinder,\n    unblinder:r.invm(priv.modulus)\n  };\n}\nfunction crt(msg, priv) {\n  var blinds = blind(priv);\n  var len = priv.modulus.byteLength();\n  var mod = bn.mont(priv.modulus);\n  var blinded = new bn(msg).mul(blinds.blinder).umod(priv.modulus);\n  var c1 = blinded.toRed(bn.mont(priv.prime1));\n  var c2 = blinded.toRed(bn.mont(priv.prime2));\n  var qinv = priv.coefficient;\n  var p = priv.prime1;\n  var q = priv.prime2;\n  var m1 = c1.redPow(priv.exponent1);\n  var m2 = c2.redPow(priv.exponent2);\n  m1 = m1.fromRed();\n  m2 = m2.fromRed();\n  var h = m1.isub(m2).imul(qinv).umod(p);\n  h.imul(q);\n  m2.iadd(h);\n  return new Buffer(m2.imul(blinds.unblinder).umod(priv.modulus).toArray(false, len));\n}\ncrt.getr = getr;\nfunction getr(priv) {\n  var len = priv.modulus.byteLength();\n  var r = new bn(randomBytes(len));\n  while (r.cmp(priv.modulus) >=  0 || !r.umod(priv.prime1) || !r.umod(priv.prime2)) {\n    r = new bn(randomBytes(len));\n  }\n  return r;\n}\n\n}).call(this,require(\"buffer\").Buffer)","deps":{"bn.js":"node_modules/browserify-rsa/node_modules/bn.js/lib/bn.js","buffer":"node_modules/buffer/index.js","randombytes":"node_modules/randombytes/browser.js"}},{"id":"node_modules/browserify-rsa/node_modules/bn.js/lib/bn.js","source":"(function (module, exports) {\n  'use strict';\n\n  // Utils\n  function assert (val, msg) {\n    if (!val) throw new Error(msg || 'Assertion failed');\n  }\n\n  // Could use `inherits` module, but don't want to move from single file\n  // architecture yet.\n  function inherits (ctor, superCtor) {\n    ctor.super_ = superCtor;\n    var TempCtor = function () {};\n    TempCtor.prototype = superCtor.prototype;\n    ctor.prototype = new TempCtor();\n    ctor.prototype.constructor = ctor;\n  }\n\n  // BN\n\n  function BN (number, base, endian) {\n    if (BN.isBN(number)) {\n      return number;\n    }\n\n    this.negative = 0;\n    this.words = null;\n    this.length = 0;\n\n    // Reduction context\n    this.red = null;\n\n    if (number !== null) {\n      if (base === 'le' || base === 'be') {\n        endian = base;\n        base = 10;\n      }\n\n      this._init(number || 0, base || 10, endian || 'be');\n    }\n  }\n  if (typeof module === 'object') {\n    module.exports = BN;\n  } else {\n    exports.BN = BN;\n  }\n\n  BN.BN = BN;\n  BN.wordSize = 26;\n\n  var Buffer;\n  try {\n    Buffer = require('buffer').Buffer;\n  } catch (e) {\n  }\n\n  BN.isBN = function isBN (num) {\n    if (num instanceof BN) {\n      return true;\n    }\n\n    return num !== null && typeof num === 'object' &&\n      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);\n  };\n\n  BN.max = function max (left, right) {\n    if (left.cmp(right) > 0) return left;\n    return right;\n  };\n\n  BN.min = function min (left, right) {\n    if (left.cmp(right) < 0) return left;\n    return right;\n  };\n\n  BN.prototype._init = function init (number, base, endian) {\n    if (typeof number === 'number') {\n      return this._initNumber(number, base, endian);\n    }\n\n    if (typeof number === 'object') {\n      return this._initArray(number, base, endian);\n    }\n\n    if (base === 'hex') {\n      base = 16;\n    }\n    assert(base === (base | 0) && base >= 2 && base <= 36);\n\n    number = number.toString().replace(/\\s+/g, '');\n    var start = 0;\n    if (number[0] === '-') {\n      start++;\n    }\n\n    if (base === 16) {\n      this._parseHex(number, start);\n    } else {\n      this._parseBase(number, base, start);\n    }\n\n    if (number[0] === '-') {\n      this.negative = 1;\n    }\n\n    this.strip();\n\n    if (endian !== 'le') return;\n\n    this._initArray(this.toArray(), base, endian);\n  };\n\n  BN.prototype._initNumber = function _initNumber (number, base, endian) {\n    if (number < 0) {\n      this.negative = 1;\n      number = -number;\n    }\n    if (number < 0x4000000) {\n      this.words = [ number & 0x3ffffff ];\n      this.length = 1;\n    } else if (number < 0x10000000000000) {\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff\n      ];\n      this.length = 2;\n    } else {\n      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff,\n        1\n      ];\n      this.length = 3;\n    }\n\n    if (endian !== 'le') return;\n\n    // Reverse the bytes\n    this._initArray(this.toArray(), base, endian);\n  };\n\n  BN.prototype._initArray = function _initArray (number, base, endian) {\n    // Perhaps a Uint8Array\n    assert(typeof number.length === 'number');\n    if (number.length <= 0) {\n      this.words = [ 0 ];\n      this.length = 1;\n      return this;\n    }\n\n    this.length = Math.ceil(number.length / 3);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    var j, w;\n    var off = 0;\n    if (endian === 'be') {\n      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {\n        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    } else if (endian === 'le') {\n      for (i = 0, j = 0; i < number.length; i += 3) {\n        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    }\n    return this.strip();\n  };\n\n  function parseHex (str, start, end) {\n    var r = 0;\n    var len = Math.min(str.length, end);\n    for (var i = start; i < len; i++) {\n      var c = str.charCodeAt(i) - 48;\n\n      r <<= 4;\n\n      // 'a' - 'f'\n      if (c >= 49 && c <= 54) {\n        r |= c - 49 + 0xa;\n\n      // 'A' - 'F'\n      } else if (c >= 17 && c <= 22) {\n        r |= c - 17 + 0xa;\n\n      // '0' - '9'\n      } else {\n        r |= c & 0xf;\n      }\n    }\n    return r;\n  }\n\n  BN.prototype._parseHex = function _parseHex (number, start) {\n    // Create possibly bigger array to ensure that it fits the number\n    this.length = Math.ceil((number.length - start) / 6);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    var j, w;\n    // Scan 24-bit chunks and add them to the number\n    var off = 0;\n    for (i = number.length - 6, j = 0; i >= start; i -= 6) {\n      w = parseHex(number, i, i + 6);\n      this.words[j] |= (w << off) & 0x3ffffff;\n      // NOTE: `0x3fffff` is intentional here, 26bits max shift + 24bit hex limb\n      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;\n      off += 24;\n      if (off >= 26) {\n        off -= 26;\n        j++;\n      }\n    }\n    if (i + 6 !== start) {\n      w = parseHex(number, start, i + 6);\n      this.words[j] |= (w << off) & 0x3ffffff;\n      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;\n    }\n    this.strip();\n  };\n\n  function parseBase (str, start, end, mul) {\n    var r = 0;\n    var len = Math.min(str.length, end);\n    for (var i = start; i < len; i++) {\n      var c = str.charCodeAt(i) - 48;\n\n      r *= mul;\n\n      // 'a'\n      if (c >= 49) {\n        r += c - 49 + 0xa;\n\n      // 'A'\n      } else if (c >= 17) {\n        r += c - 17 + 0xa;\n\n      // '0' - '9'\n      } else {\n        r += c;\n      }\n    }\n    return r;\n  }\n\n  BN.prototype._parseBase = function _parseBase (number, base, start) {\n    // Initialize as zero\n    this.words = [ 0 ];\n    this.length = 1;\n\n    // Find length of limb in base\n    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {\n      limbLen++;\n    }\n    limbLen--;\n    limbPow = (limbPow / base) | 0;\n\n    var total = number.length - start;\n    var mod = total % limbLen;\n    var end = Math.min(total, total - mod) + start;\n\n    var word = 0;\n    for (var i = start; i < end; i += limbLen) {\n      word = parseBase(number, i, i + limbLen, base);\n\n      this.imuln(limbPow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n\n    if (mod !== 0) {\n      var pow = 1;\n      word = parseBase(number, i, number.length, base);\n\n      for (i = 0; i < mod; i++) {\n        pow *= base;\n      }\n\n      this.imuln(pow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n  };\n\n  BN.prototype.copy = function copy (dest) {\n    dest.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      dest.words[i] = this.words[i];\n    }\n    dest.length = this.length;\n    dest.negative = this.negative;\n    dest.red = this.red;\n  };\n\n  BN.prototype.clone = function clone () {\n    var r = new BN(null);\n    this.copy(r);\n    return r;\n  };\n\n  BN.prototype._expand = function _expand (size) {\n    while (this.length < size) {\n      this.words[this.length++] = 0;\n    }\n    return this;\n  };\n\n  // Remove leading `0` from `this`\n  BN.prototype.strip = function strip () {\n    while (this.length > 1 && this.words[this.length - 1] === 0) {\n      this.length--;\n    }\n    return this._normSign();\n  };\n\n  BN.prototype._normSign = function _normSign () {\n    // -0 = 0\n    if (this.length === 1 && this.words[0] === 0) {\n      this.negative = 0;\n    }\n    return this;\n  };\n\n  BN.prototype.inspect = function inspect () {\n    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';\n  };\n\n  /*\n\n  var zeros = [];\n  var groupSizes = [];\n  var groupBases = [];\n\n  var s = '';\n  var i = -1;\n  while (++i < BN.wordSize) {\n    zeros[i] = s;\n    s += '0';\n  }\n  groupSizes[0] = 0;\n  groupSizes[1] = 0;\n  groupBases[0] = 0;\n  groupBases[1] = 0;\n  var base = 2 - 1;\n  while (++base < 36 + 1) {\n    var groupSize = 0;\n    var groupBase = 1;\n    while (groupBase < (1 << BN.wordSize) / base) {\n      groupBase *= base;\n      groupSize += 1;\n    }\n    groupSizes[base] = groupSize;\n    groupBases[base] = groupBase;\n  }\n\n  */\n\n  var zeros = [\n    '',\n    '0',\n    '00',\n    '000',\n    '0000',\n    '00000',\n    '000000',\n    '0000000',\n    '00000000',\n    '000000000',\n    '0000000000',\n    '00000000000',\n    '000000000000',\n    '0000000000000',\n    '00000000000000',\n    '000000000000000',\n    '0000000000000000',\n    '00000000000000000',\n    '000000000000000000',\n    '0000000000000000000',\n    '00000000000000000000',\n    '000000000000000000000',\n    '0000000000000000000000',\n    '00000000000000000000000',\n    '000000000000000000000000',\n    '0000000000000000000000000'\n  ];\n\n  var groupSizes = [\n    0, 0,\n    25, 16, 12, 11, 10, 9, 8,\n    8, 7, 7, 7, 7, 6, 6,\n    6, 6, 6, 6, 6, 5, 5,\n    5, 5, 5, 5, 5, 5, 5,\n    5, 5, 5, 5, 5, 5, 5\n  ];\n\n  var groupBases = [\n    0, 0,\n    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,\n    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,\n    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,\n    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,\n    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176\n  ];\n\n  BN.prototype.toString = function toString (base, padding) {\n    base = base || 10;\n    padding = padding | 0 || 1;\n\n    var out;\n    if (base === 16 || base === 'hex') {\n      out = '';\n      var off = 0;\n      var carry = 0;\n      for (var i = 0; i < this.length; i++) {\n        var w = this.words[i];\n        var word = (((w << off) | carry) & 0xffffff).toString(16);\n        carry = (w >>> (24 - off)) & 0xffffff;\n        if (carry !== 0 || i !== this.length - 1) {\n          out = zeros[6 - word.length] + word + out;\n        } else {\n          out = word + out;\n        }\n        off += 2;\n        if (off >= 26) {\n          off -= 26;\n          i--;\n        }\n      }\n      if (carry !== 0) {\n        out = carry.toString(16) + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    if (base === (base | 0) && base >= 2 && base <= 36) {\n      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));\n      var groupSize = groupSizes[base];\n      // var groupBase = Math.pow(base, groupSize);\n      var groupBase = groupBases[base];\n      out = '';\n      var c = this.clone();\n      c.negative = 0;\n      while (!c.isZero()) {\n        var r = c.modn(groupBase).toString(base);\n        c = c.idivn(groupBase);\n\n        if (!c.isZero()) {\n          out = zeros[groupSize - r.length] + r + out;\n        } else {\n          out = r + out;\n        }\n      }\n      if (this.isZero()) {\n        out = '0' + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    assert(false, 'Base should be between 2 and 36');\n  };\n\n  BN.prototype.toNumber = function toNumber () {\n    var ret = this.words[0];\n    if (this.length === 2) {\n      ret += this.words[1] * 0x4000000;\n    } else if (this.length === 3 && this.words[2] === 0x01) {\n      // NOTE: at this stage it is known that the top bit is set\n      ret += 0x10000000000000 + (this.words[1] * 0x4000000);\n    } else if (this.length > 2) {\n      assert(false, 'Number can only safely store up to 53 bits');\n    }\n    return (this.negative !== 0) ? -ret : ret;\n  };\n\n  BN.prototype.toJSON = function toJSON () {\n    return this.toString(16);\n  };\n\n  BN.prototype.toBuffer = function toBuffer (endian, length) {\n    assert(typeof Buffer !== 'undefined');\n    return this.toArrayLike(Buffer, endian, length);\n  };\n\n  BN.prototype.toArray = function toArray (endian, length) {\n    return this.toArrayLike(Array, endian, length);\n  };\n\n  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {\n    var byteLength = this.byteLength();\n    var reqLength = length || Math.max(1, byteLength);\n    assert(byteLength <= reqLength, 'byte array longer than desired length');\n    assert(reqLength > 0, 'Requested array length <= 0');\n\n    this.strip();\n    var littleEndian = endian === 'le';\n    var res = new ArrayType(reqLength);\n\n    var b, i;\n    var q = this.clone();\n    if (!littleEndian) {\n      // Assume big-endian\n      for (i = 0; i < reqLength - byteLength; i++) {\n        res[i] = 0;\n      }\n\n      for (i = 0; !q.isZero(); i++) {\n        b = q.andln(0xff);\n        q.iushrn(8);\n\n        res[reqLength - i - 1] = b;\n      }\n    } else {\n      for (i = 0; !q.isZero(); i++) {\n        b = q.andln(0xff);\n        q.iushrn(8);\n\n        res[i] = b;\n      }\n\n      for (; i < reqLength; i++) {\n        res[i] = 0;\n      }\n    }\n\n    return res;\n  };\n\n  if (Math.clz32) {\n    BN.prototype._countBits = function _countBits (w) {\n      return 32 - Math.clz32(w);\n    };\n  } else {\n    BN.prototype._countBits = function _countBits (w) {\n      var t = w;\n      var r = 0;\n      if (t >= 0x1000) {\n        r += 13;\n        t >>>= 13;\n      }\n      if (t >= 0x40) {\n        r += 7;\n        t >>>= 7;\n      }\n      if (t >= 0x8) {\n        r += 4;\n        t >>>= 4;\n      }\n      if (t >= 0x02) {\n        r += 2;\n        t >>>= 2;\n      }\n      return r + t;\n    };\n  }\n\n  BN.prototype._zeroBits = function _zeroBits (w) {\n    // Short-cut\n    if (w === 0) return 26;\n\n    var t = w;\n    var r = 0;\n    if ((t & 0x1fff) === 0) {\n      r += 13;\n      t >>>= 13;\n    }\n    if ((t & 0x7f) === 0) {\n      r += 7;\n      t >>>= 7;\n    }\n    if ((t & 0xf) === 0) {\n      r += 4;\n      t >>>= 4;\n    }\n    if ((t & 0x3) === 0) {\n      r += 2;\n      t >>>= 2;\n    }\n    if ((t & 0x1) === 0) {\n      r++;\n    }\n    return r;\n  };\n\n  // Return number of used bits in a BN\n  BN.prototype.bitLength = function bitLength () {\n    var w = this.words[this.length - 1];\n    var hi = this._countBits(w);\n    return (this.length - 1) * 26 + hi;\n  };\n\n  function toBitArray (num) {\n    var w = new Array(num.bitLength());\n\n    for (var bit = 0; bit < w.length; bit++) {\n      var off = (bit / 26) | 0;\n      var wbit = bit % 26;\n\n      w[bit] = (num.words[off] & (1 << wbit)) >>> wbit;\n    }\n\n    return w;\n  }\n\n  // Number of trailing zero bits\n  BN.prototype.zeroBits = function zeroBits () {\n    if (this.isZero()) return 0;\n\n    var r = 0;\n    for (var i = 0; i < this.length; i++) {\n      var b = this._zeroBits(this.words[i]);\n      r += b;\n      if (b !== 26) break;\n    }\n    return r;\n  };\n\n  BN.prototype.byteLength = function byteLength () {\n    return Math.ceil(this.bitLength() / 8);\n  };\n\n  BN.prototype.toTwos = function toTwos (width) {\n    if (this.negative !== 0) {\n      return this.abs().inotn(width).iaddn(1);\n    }\n    return this.clone();\n  };\n\n  BN.prototype.fromTwos = function fromTwos (width) {\n    if (this.testn(width - 1)) {\n      return this.notn(width).iaddn(1).ineg();\n    }\n    return this.clone();\n  };\n\n  BN.prototype.isNeg = function isNeg () {\n    return this.negative !== 0;\n  };\n\n  // Return negative clone of `this`\n  BN.prototype.neg = function neg () {\n    return this.clone().ineg();\n  };\n\n  BN.prototype.ineg = function ineg () {\n    if (!this.isZero()) {\n      this.negative ^= 1;\n    }\n\n    return this;\n  };\n\n  // Or `num` with `this` in-place\n  BN.prototype.iuor = function iuor (num) {\n    while (this.length < num.length) {\n      this.words[this.length++] = 0;\n    }\n\n    for (var i = 0; i < num.length; i++) {\n      this.words[i] = this.words[i] | num.words[i];\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ior = function ior (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuor(num);\n  };\n\n  // Or `num` with `this`\n  BN.prototype.or = function or (num) {\n    if (this.length > num.length) return this.clone().ior(num);\n    return num.clone().ior(this);\n  };\n\n  BN.prototype.uor = function uor (num) {\n    if (this.length > num.length) return this.clone().iuor(num);\n    return num.clone().iuor(this);\n  };\n\n  // And `num` with `this` in-place\n  BN.prototype.iuand = function iuand (num) {\n    // b = min-length(num, this)\n    var b;\n    if (this.length > num.length) {\n      b = num;\n    } else {\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = this.words[i] & num.words[i];\n    }\n\n    this.length = b.length;\n\n    return this.strip();\n  };\n\n  BN.prototype.iand = function iand (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuand(num);\n  };\n\n  // And `num` with `this`\n  BN.prototype.and = function and (num) {\n    if (this.length > num.length) return this.clone().iand(num);\n    return num.clone().iand(this);\n  };\n\n  BN.prototype.uand = function uand (num) {\n    if (this.length > num.length) return this.clone().iuand(num);\n    return num.clone().iuand(this);\n  };\n\n  // Xor `num` with `this` in-place\n  BN.prototype.iuxor = function iuxor (num) {\n    // a.length > b.length\n    var a;\n    var b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = a.words[i] ^ b.words[i];\n    }\n\n    if (this !== a) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = a.length;\n\n    return this.strip();\n  };\n\n  BN.prototype.ixor = function ixor (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuxor(num);\n  };\n\n  // Xor `num` with `this`\n  BN.prototype.xor = function xor (num) {\n    if (this.length > num.length) return this.clone().ixor(num);\n    return num.clone().ixor(this);\n  };\n\n  BN.prototype.uxor = function uxor (num) {\n    if (this.length > num.length) return this.clone().iuxor(num);\n    return num.clone().iuxor(this);\n  };\n\n  // Not ``this`` with ``width`` bitwidth\n  BN.prototype.inotn = function inotn (width) {\n    assert(typeof width === 'number' && width >= 0);\n\n    var bytesNeeded = Math.ceil(width / 26) | 0;\n    var bitsLeft = width % 26;\n\n    // Extend the buffer with leading zeroes\n    this._expand(bytesNeeded);\n\n    if (bitsLeft > 0) {\n      bytesNeeded--;\n    }\n\n    // Handle complete words\n    for (var i = 0; i < bytesNeeded; i++) {\n      this.words[i] = ~this.words[i] & 0x3ffffff;\n    }\n\n    // Handle the residue\n    if (bitsLeft > 0) {\n      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));\n    }\n\n    // And remove leading zeroes\n    return this.strip();\n  };\n\n  BN.prototype.notn = function notn (width) {\n    return this.clone().inotn(width);\n  };\n\n  // Set `bit` of `this`\n  BN.prototype.setn = function setn (bit, val) {\n    assert(typeof bit === 'number' && bit >= 0);\n\n    var off = (bit / 26) | 0;\n    var wbit = bit % 26;\n\n    this._expand(off + 1);\n\n    if (val) {\n      this.words[off] = this.words[off] | (1 << wbit);\n    } else {\n      this.words[off] = this.words[off] & ~(1 << wbit);\n    }\n\n    return this.strip();\n  };\n\n  // Add `num` to `this` in-place\n  BN.prototype.iadd = function iadd (num) {\n    var r;\n\n    // negative + positive\n    if (this.negative !== 0 && num.negative === 0) {\n      this.negative = 0;\n      r = this.isub(num);\n      this.negative ^= 1;\n      return this._normSign();\n\n    // positive + negative\n    } else if (this.negative === 0 && num.negative !== 0) {\n      num.negative = 0;\n      r = this.isub(num);\n      num.negative = 1;\n      return r._normSign();\n    }\n\n    // a.length > b.length\n    var a, b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n\n    this.length = a.length;\n    if (carry !== 0) {\n      this.words[this.length] = carry;\n      this.length++;\n    // Copy the rest of the words\n    } else if (a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    return this;\n  };\n\n  // Add `num` to `this`\n  BN.prototype.add = function add (num) {\n    var res;\n    if (num.negative !== 0 && this.negative === 0) {\n      num.negative = 0;\n      res = this.sub(num);\n      num.negative ^= 1;\n      return res;\n    } else if (num.negative === 0 && this.negative !== 0) {\n      this.negative = 0;\n      res = num.sub(this);\n      this.negative = 1;\n      return res;\n    }\n\n    if (this.length > num.length) return this.clone().iadd(num);\n\n    return num.clone().iadd(this);\n  };\n\n  // Subtract `num` from `this` in-place\n  BN.prototype.isub = function isub (num) {\n    // this - (-num) = this + num\n    if (num.negative !== 0) {\n      num.negative = 0;\n      var r = this.iadd(num);\n      num.negative = 1;\n      return r._normSign();\n\n    // -this - num = -(this + num)\n    } else if (this.negative !== 0) {\n      this.negative = 0;\n      this.iadd(num);\n      this.negative = 1;\n      return this._normSign();\n    }\n\n    // At this point both numbers are positive\n    var cmp = this.cmp(num);\n\n    // Optimization - zeroify\n    if (cmp === 0) {\n      this.negative = 0;\n      this.length = 1;\n      this.words[0] = 0;\n      return this;\n    }\n\n    // a > b\n    var a, b;\n    if (cmp > 0) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n\n    // Copy rest of the words\n    if (carry === 0 && i < a.length && a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = Math.max(this.length, i);\n\n    if (a !== this) {\n      this.negative = 1;\n    }\n\n    return this.strip();\n  };\n\n  // Subtract `num` from `this`\n  BN.prototype.sub = function sub (num) {\n    return this.clone().isub(num);\n  };\n\n  function smallMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    var len = (self.length + num.length) | 0;\n    out.length = len;\n    len = (len - 1) | 0;\n\n    // Peel one iteration (compiler can't do it, because of code complexity)\n    var a = self.words[0] | 0;\n    var b = num.words[0] | 0;\n    var r = a * b;\n\n    var lo = r & 0x3ffffff;\n    var carry = (r / 0x4000000) | 0;\n    out.words[0] = lo;\n\n    for (var k = 1; k < len; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = carry >>> 26;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = (k - j) | 0;\n        a = self.words[i] | 0;\n        b = num.words[j] | 0;\n        r = a * b + rword;\n        ncarry += (r / 0x4000000) | 0;\n        rword = r & 0x3ffffff;\n      }\n      out.words[k] = rword | 0;\n      carry = ncarry | 0;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry | 0;\n    } else {\n      out.length--;\n    }\n\n    return out.strip();\n  }\n\n  // TODO(indutny): it may be reasonable to omit it for users who don't need\n  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit\n  // multiplication (like elliptic secp256k1).\n  var comb10MulTo = function comb10MulTo (self, num, out) {\n    var a = self.words;\n    var b = num.words;\n    var o = out.words;\n    var c = 0;\n    var lo;\n    var mid;\n    var hi;\n    var a0 = a[0] | 0;\n    var al0 = a0 & 0x1fff;\n    var ah0 = a0 >>> 13;\n    var a1 = a[1] | 0;\n    var al1 = a1 & 0x1fff;\n    var ah1 = a1 >>> 13;\n    var a2 = a[2] | 0;\n    var al2 = a2 & 0x1fff;\n    var ah2 = a2 >>> 13;\n    var a3 = a[3] | 0;\n    var al3 = a3 & 0x1fff;\n    var ah3 = a3 >>> 13;\n    var a4 = a[4] | 0;\n    var al4 = a4 & 0x1fff;\n    var ah4 = a4 >>> 13;\n    var a5 = a[5] | 0;\n    var al5 = a5 & 0x1fff;\n    var ah5 = a5 >>> 13;\n    var a6 = a[6] | 0;\n    var al6 = a6 & 0x1fff;\n    var ah6 = a6 >>> 13;\n    var a7 = a[7] | 0;\n    var al7 = a7 & 0x1fff;\n    var ah7 = a7 >>> 13;\n    var a8 = a[8] | 0;\n    var al8 = a8 & 0x1fff;\n    var ah8 = a8 >>> 13;\n    var a9 = a[9] | 0;\n    var al9 = a9 & 0x1fff;\n    var ah9 = a9 >>> 13;\n    var b0 = b[0] | 0;\n    var bl0 = b0 & 0x1fff;\n    var bh0 = b0 >>> 13;\n    var b1 = b[1] | 0;\n    var bl1 = b1 & 0x1fff;\n    var bh1 = b1 >>> 13;\n    var b2 = b[2] | 0;\n    var bl2 = b2 & 0x1fff;\n    var bh2 = b2 >>> 13;\n    var b3 = b[3] | 0;\n    var bl3 = b3 & 0x1fff;\n    var bh3 = b3 >>> 13;\n    var b4 = b[4] | 0;\n    var bl4 = b4 & 0x1fff;\n    var bh4 = b4 >>> 13;\n    var b5 = b[5] | 0;\n    var bl5 = b5 & 0x1fff;\n    var bh5 = b5 >>> 13;\n    var b6 = b[6] | 0;\n    var bl6 = b6 & 0x1fff;\n    var bh6 = b6 >>> 13;\n    var b7 = b[7] | 0;\n    var bl7 = b7 & 0x1fff;\n    var bh7 = b7 >>> 13;\n    var b8 = b[8] | 0;\n    var bl8 = b8 & 0x1fff;\n    var bh8 = b8 >>> 13;\n    var b9 = b[9] | 0;\n    var bl9 = b9 & 0x1fff;\n    var bh9 = b9 >>> 13;\n\n    out.negative = self.negative ^ num.negative;\n    out.length = 19;\n    /* k = 0 */\n    lo = Math.imul(al0, bl0);\n    mid = Math.imul(al0, bh0);\n    mid = (mid + Math.imul(ah0, bl0)) | 0;\n    hi = Math.imul(ah0, bh0);\n    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;\n    w0 &= 0x3ffffff;\n    /* k = 1 */\n    lo = Math.imul(al1, bl0);\n    mid = Math.imul(al1, bh0);\n    mid = (mid + Math.imul(ah1, bl0)) | 0;\n    hi = Math.imul(ah1, bh0);\n    lo = (lo + Math.imul(al0, bl1)) | 0;\n    mid = (mid + Math.imul(al0, bh1)) | 0;\n    mid = (mid + Math.imul(ah0, bl1)) | 0;\n    hi = (hi + Math.imul(ah0, bh1)) | 0;\n    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;\n    w1 &= 0x3ffffff;\n    /* k = 2 */\n    lo = Math.imul(al2, bl0);\n    mid = Math.imul(al2, bh0);\n    mid = (mid + Math.imul(ah2, bl0)) | 0;\n    hi = Math.imul(ah2, bh0);\n    lo = (lo + Math.imul(al1, bl1)) | 0;\n    mid = (mid + Math.imul(al1, bh1)) | 0;\n    mid = (mid + Math.imul(ah1, bl1)) | 0;\n    hi = (hi + Math.imul(ah1, bh1)) | 0;\n    lo = (lo + Math.imul(al0, bl2)) | 0;\n    mid = (mid + Math.imul(al0, bh2)) | 0;\n    mid = (mid + Math.imul(ah0, bl2)) | 0;\n    hi = (hi + Math.imul(ah0, bh2)) | 0;\n    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;\n    w2 &= 0x3ffffff;\n    /* k = 3 */\n    lo = Math.imul(al3, bl0);\n    mid = Math.imul(al3, bh0);\n    mid = (mid + Math.imul(ah3, bl0)) | 0;\n    hi = Math.imul(ah3, bh0);\n    lo = (lo + Math.imul(al2, bl1)) | 0;\n    mid = (mid + Math.imul(al2, bh1)) | 0;\n    mid = (mid + Math.imul(ah2, bl1)) | 0;\n    hi = (hi + Math.imul(ah2, bh1)) | 0;\n    lo = (lo + Math.imul(al1, bl2)) | 0;\n    mid = (mid + Math.imul(al1, bh2)) | 0;\n    mid = (mid + Math.imul(ah1, bl2)) | 0;\n    hi = (hi + Math.imul(ah1, bh2)) | 0;\n    lo = (lo + Math.imul(al0, bl3)) | 0;\n    mid = (mid + Math.imul(al0, bh3)) | 0;\n    mid = (mid + Math.imul(ah0, bl3)) | 0;\n    hi = (hi + Math.imul(ah0, bh3)) | 0;\n    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;\n    w3 &= 0x3ffffff;\n    /* k = 4 */\n    lo = Math.imul(al4, bl0);\n    mid = Math.imul(al4, bh0);\n    mid = (mid + Math.imul(ah4, bl0)) | 0;\n    hi = Math.imul(ah4, bh0);\n    lo = (lo + Math.imul(al3, bl1)) | 0;\n    mid = (mid + Math.imul(al3, bh1)) | 0;\n    mid = (mid + Math.imul(ah3, bl1)) | 0;\n    hi = (hi + Math.imul(ah3, bh1)) | 0;\n    lo = (lo + Math.imul(al2, bl2)) | 0;\n    mid = (mid + Math.imul(al2, bh2)) | 0;\n    mid = (mid + Math.imul(ah2, bl2)) | 0;\n    hi = (hi + Math.imul(ah2, bh2)) | 0;\n    lo = (lo + Math.imul(al1, bl3)) | 0;\n    mid = (mid + Math.imul(al1, bh3)) | 0;\n    mid = (mid + Math.imul(ah1, bl3)) | 0;\n    hi = (hi + Math.imul(ah1, bh3)) | 0;\n    lo = (lo + Math.imul(al0, bl4)) | 0;\n    mid = (mid + Math.imul(al0, bh4)) | 0;\n    mid = (mid + Math.imul(ah0, bl4)) | 0;\n    hi = (hi + Math.imul(ah0, bh4)) | 0;\n    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;\n    w4 &= 0x3ffffff;\n    /* k = 5 */\n    lo = Math.imul(al5, bl0);\n    mid = Math.imul(al5, bh0);\n    mid = (mid + Math.imul(ah5, bl0)) | 0;\n    hi = Math.imul(ah5, bh0);\n    lo = (lo + Math.imul(al4, bl1)) | 0;\n    mid = (mid + Math.imul(al4, bh1)) | 0;\n    mid = (mid + Math.imul(ah4, bl1)) | 0;\n    hi = (hi + Math.imul(ah4, bh1)) | 0;\n    lo = (lo + Math.imul(al3, bl2)) | 0;\n    mid = (mid + Math.imul(al3, bh2)) | 0;\n    mid = (mid + Math.imul(ah3, bl2)) | 0;\n    hi = (hi + Math.imul(ah3, bh2)) | 0;\n    lo = (lo + Math.imul(al2, bl3)) | 0;\n    mid = (mid + Math.imul(al2, bh3)) | 0;\n    mid = (mid + Math.imul(ah2, bl3)) | 0;\n    hi = (hi + Math.imul(ah2, bh3)) | 0;\n    lo = (lo + Math.imul(al1, bl4)) | 0;\n    mid = (mid + Math.imul(al1, bh4)) | 0;\n    mid = (mid + Math.imul(ah1, bl4)) | 0;\n    hi = (hi + Math.imul(ah1, bh4)) | 0;\n    lo = (lo + Math.imul(al0, bl5)) | 0;\n    mid = (mid + Math.imul(al0, bh5)) | 0;\n    mid = (mid + Math.imul(ah0, bl5)) | 0;\n    hi = (hi + Math.imul(ah0, bh5)) | 0;\n    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;\n    w5 &= 0x3ffffff;\n    /* k = 6 */\n    lo = Math.imul(al6, bl0);\n    mid = Math.imul(al6, bh0);\n    mid = (mid + Math.imul(ah6, bl0)) | 0;\n    hi = Math.imul(ah6, bh0);\n    lo = (lo + Math.imul(al5, bl1)) | 0;\n    mid = (mid + Math.imul(al5, bh1)) | 0;\n    mid = (mid + Math.imul(ah5, bl1)) | 0;\n    hi = (hi + Math.imul(ah5, bh1)) | 0;\n    lo = (lo + Math.imul(al4, bl2)) | 0;\n    mid = (mid + Math.imul(al4, bh2)) | 0;\n    mid = (mid + Math.imul(ah4, bl2)) | 0;\n    hi = (hi + Math.imul(ah4, bh2)) | 0;\n    lo = (lo + Math.imul(al3, bl3)) | 0;\n    mid = (mid + Math.imul(al3, bh3)) | 0;\n    mid = (mid + Math.imul(ah3, bl3)) | 0;\n    hi = (hi + Math.imul(ah3, bh3)) | 0;\n    lo = (lo + Math.imul(al2, bl4)) | 0;\n    mid = (mid + Math.imul(al2, bh4)) | 0;\n    mid = (mid + Math.imul(ah2, bl4)) | 0;\n    hi = (hi + Math.imul(ah2, bh4)) | 0;\n    lo = (lo + Math.imul(al1, bl5)) | 0;\n    mid = (mid + Math.imul(al1, bh5)) | 0;\n    mid = (mid + Math.imul(ah1, bl5)) | 0;\n    hi = (hi + Math.imul(ah1, bh5)) | 0;\n    lo = (lo + Math.imul(al0, bl6)) | 0;\n    mid = (mid + Math.imul(al0, bh6)) | 0;\n    mid = (mid + Math.imul(ah0, bl6)) | 0;\n    hi = (hi + Math.imul(ah0, bh6)) | 0;\n    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;\n    w6 &= 0x3ffffff;\n    /* k = 7 */\n    lo = Math.imul(al7, bl0);\n    mid = Math.imul(al7, bh0);\n    mid = (mid + Math.imul(ah7, bl0)) | 0;\n    hi = Math.imul(ah7, bh0);\n    lo = (lo + Math.imul(al6, bl1)) | 0;\n    mid = (mid + Math.imul(al6, bh1)) | 0;\n    mid = (mid + Math.imul(ah6, bl1)) | 0;\n    hi = (hi + Math.imul(ah6, bh1)) | 0;\n    lo = (lo + Math.imul(al5, bl2)) | 0;\n    mid = (mid + Math.imul(al5, bh2)) | 0;\n    mid = (mid + Math.imul(ah5, bl2)) | 0;\n    hi = (hi + Math.imul(ah5, bh2)) | 0;\n    lo = (lo + Math.imul(al4, bl3)) | 0;\n    mid = (mid + Math.imul(al4, bh3)) | 0;\n    mid = (mid + Math.imul(ah4, bl3)) | 0;\n    hi = (hi + Math.imul(ah4, bh3)) | 0;\n    lo = (lo + Math.imul(al3, bl4)) | 0;\n    mid = (mid + Math.imul(al3, bh4)) | 0;\n    mid = (mid + Math.imul(ah3, bl4)) | 0;\n    hi = (hi + Math.imul(ah3, bh4)) | 0;\n    lo = (lo + Math.imul(al2, bl5)) | 0;\n    mid = (mid + Math.imul(al2, bh5)) | 0;\n    mid = (mid + Math.imul(ah2, bl5)) | 0;\n    hi = (hi + Math.imul(ah2, bh5)) | 0;\n    lo = (lo + Math.imul(al1, bl6)) | 0;\n    mid = (mid + Math.imul(al1, bh6)) | 0;\n    mid = (mid + Math.imul(ah1, bl6)) | 0;\n    hi = (hi + Math.imul(ah1, bh6)) | 0;\n    lo = (lo + Math.imul(al0, bl7)) | 0;\n    mid = (mid + Math.imul(al0, bh7)) | 0;\n    mid = (mid + Math.imul(ah0, bl7)) | 0;\n    hi = (hi + Math.imul(ah0, bh7)) | 0;\n    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;\n    w7 &= 0x3ffffff;\n    /* k = 8 */\n    lo = Math.imul(al8, bl0);\n    mid = Math.imul(al8, bh0);\n    mid = (mid + Math.imul(ah8, bl0)) | 0;\n    hi = Math.imul(ah8, bh0);\n    lo = (lo + Math.imul(al7, bl1)) | 0;\n    mid = (mid + Math.imul(al7, bh1)) | 0;\n    mid = (mid + Math.imul(ah7, bl1)) | 0;\n    hi = (hi + Math.imul(ah7, bh1)) | 0;\n    lo = (lo + Math.imul(al6, bl2)) | 0;\n    mid = (mid + Math.imul(al6, bh2)) | 0;\n    mid = (mid + Math.imul(ah6, bl2)) | 0;\n    hi = (hi + Math.imul(ah6, bh2)) | 0;\n    lo = (lo + Math.imul(al5, bl3)) | 0;\n    mid = (mid + Math.imul(al5, bh3)) | 0;\n    mid = (mid + Math.imul(ah5, bl3)) | 0;\n    hi = (hi + Math.imul(ah5, bh3)) | 0;\n    lo = (lo + Math.imul(al4, bl4)) | 0;\n    mid = (mid + Math.imul(al4, bh4)) | 0;\n    mid = (mid + Math.imul(ah4, bl4)) | 0;\n    hi = (hi + Math.imul(ah4, bh4)) | 0;\n    lo = (lo + Math.imul(al3, bl5)) | 0;\n    mid = (mid + Math.imul(al3, bh5)) | 0;\n    mid = (mid + Math.imul(ah3, bl5)) | 0;\n    hi = (hi + Math.imul(ah3, bh5)) | 0;\n    lo = (lo + Math.imul(al2, bl6)) | 0;\n    mid = (mid + Math.imul(al2, bh6)) | 0;\n    mid = (mid + Math.imul(ah2, bl6)) | 0;\n    hi = (hi + Math.imul(ah2, bh6)) | 0;\n    lo = (lo + Math.imul(al1, bl7)) | 0;\n    mid = (mid + Math.imul(al1, bh7)) | 0;\n    mid = (mid + Math.imul(ah1, bl7)) | 0;\n    hi = (hi + Math.imul(ah1, bh7)) | 0;\n    lo = (lo + Math.imul(al0, bl8)) | 0;\n    mid = (mid + Math.imul(al0, bh8)) | 0;\n    mid = (mid + Math.imul(ah0, bl8)) | 0;\n    hi = (hi + Math.imul(ah0, bh8)) | 0;\n    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;\n    w8 &= 0x3ffffff;\n    /* k = 9 */\n    lo = Math.imul(al9, bl0);\n    mid = Math.imul(al9, bh0);\n    mid = (mid + Math.imul(ah9, bl0)) | 0;\n    hi = Math.imul(ah9, bh0);\n    lo = (lo + Math.imul(al8, bl1)) | 0;\n    mid = (mid + Math.imul(al8, bh1)) | 0;\n    mid = (mid + Math.imul(ah8, bl1)) | 0;\n    hi = (hi + Math.imul(ah8, bh1)) | 0;\n    lo = (lo + Math.imul(al7, bl2)) | 0;\n    mid = (mid + Math.imul(al7, bh2)) | 0;\n    mid = (mid + Math.imul(ah7, bl2)) | 0;\n    hi = (hi + Math.imul(ah7, bh2)) | 0;\n    lo = (lo + Math.imul(al6, bl3)) | 0;\n    mid = (mid + Math.imul(al6, bh3)) | 0;\n    mid = (mid + Math.imul(ah6, bl3)) | 0;\n    hi = (hi + Math.imul(ah6, bh3)) | 0;\n    lo = (lo + Math.imul(al5, bl4)) | 0;\n    mid = (mid + Math.imul(al5, bh4)) | 0;\n    mid = (mid + Math.imul(ah5, bl4)) | 0;\n    hi = (hi + Math.imul(ah5, bh4)) | 0;\n    lo = (lo + Math.imul(al4, bl5)) | 0;\n    mid = (mid + Math.imul(al4, bh5)) | 0;\n    mid = (mid + Math.imul(ah4, bl5)) | 0;\n    hi = (hi + Math.imul(ah4, bh5)) | 0;\n    lo = (lo + Math.imul(al3, bl6)) | 0;\n    mid = (mid + Math.imul(al3, bh6)) | 0;\n    mid = (mid + Math.imul(ah3, bl6)) | 0;\n    hi = (hi + Math.imul(ah3, bh6)) | 0;\n    lo = (lo + Math.imul(al2, bl7)) | 0;\n    mid = (mid + Math.imul(al2, bh7)) | 0;\n    mid = (mid + Math.imul(ah2, bl7)) | 0;\n    hi = (hi + Math.imul(ah2, bh7)) | 0;\n    lo = (lo + Math.imul(al1, bl8)) | 0;\n    mid = (mid + Math.imul(al1, bh8)) | 0;\n    mid = (mid + Math.imul(ah1, bl8)) | 0;\n    hi = (hi + Math.imul(ah1, bh8)) | 0;\n    lo = (lo + Math.imul(al0, bl9)) | 0;\n    mid = (mid + Math.imul(al0, bh9)) | 0;\n    mid = (mid + Math.imul(ah0, bl9)) | 0;\n    hi = (hi + Math.imul(ah0, bh9)) | 0;\n    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;\n    w9 &= 0x3ffffff;\n    /* k = 10 */\n    lo = Math.imul(al9, bl1);\n    mid = Math.imul(al9, bh1);\n    mid = (mid + Math.imul(ah9, bl1)) | 0;\n    hi = Math.imul(ah9, bh1);\n    lo = (lo + Math.imul(al8, bl2)) | 0;\n    mid = (mid + Math.imul(al8, bh2)) | 0;\n    mid = (mid + Math.imul(ah8, bl2)) | 0;\n    hi = (hi + Math.imul(ah8, bh2)) | 0;\n    lo = (lo + Math.imul(al7, bl3)) | 0;\n    mid = (mid + Math.imul(al7, bh3)) | 0;\n    mid = (mid + Math.imul(ah7, bl3)) | 0;\n    hi = (hi + Math.imul(ah7, bh3)) | 0;\n    lo = (lo + Math.imul(al6, bl4)) | 0;\n    mid = (mid + Math.imul(al6, bh4)) | 0;\n    mid = (mid + Math.imul(ah6, bl4)) | 0;\n    hi = (hi + Math.imul(ah6, bh4)) | 0;\n    lo = (lo + Math.imul(al5, bl5)) | 0;\n    mid = (mid + Math.imul(al5, bh5)) | 0;\n    mid = (mid + Math.imul(ah5, bl5)) | 0;\n    hi = (hi + Math.imul(ah5, bh5)) | 0;\n    lo = (lo + Math.imul(al4, bl6)) | 0;\n    mid = (mid + Math.imul(al4, bh6)) | 0;\n    mid = (mid + Math.imul(ah4, bl6)) | 0;\n    hi = (hi + Math.imul(ah4, bh6)) | 0;\n    lo = (lo + Math.imul(al3, bl7)) | 0;\n    mid = (mid + Math.imul(al3, bh7)) | 0;\n    mid = (mid + Math.imul(ah3, bl7)) | 0;\n    hi = (hi + Math.imul(ah3, bh7)) | 0;\n    lo = (lo + Math.imul(al2, bl8)) | 0;\n    mid = (mid + Math.imul(al2, bh8)) | 0;\n    mid = (mid + Math.imul(ah2, bl8)) | 0;\n    hi = (hi + Math.imul(ah2, bh8)) | 0;\n    lo = (lo + Math.imul(al1, bl9)) | 0;\n    mid = (mid + Math.imul(al1, bh9)) | 0;\n    mid = (mid + Math.imul(ah1, bl9)) | 0;\n    hi = (hi + Math.imul(ah1, bh9)) | 0;\n    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;\n    w10 &= 0x3ffffff;\n    /* k = 11 */\n    lo = Math.imul(al9, bl2);\n    mid = Math.imul(al9, bh2);\n    mid = (mid + Math.imul(ah9, bl2)) | 0;\n    hi = Math.imul(ah9, bh2);\n    lo = (lo + Math.imul(al8, bl3)) | 0;\n    mid = (mid + Math.imul(al8, bh3)) | 0;\n    mid = (mid + Math.imul(ah8, bl3)) | 0;\n    hi = (hi + Math.imul(ah8, bh3)) | 0;\n    lo = (lo + Math.imul(al7, bl4)) | 0;\n    mid = (mid + Math.imul(al7, bh4)) | 0;\n    mid = (mid + Math.imul(ah7, bl4)) | 0;\n    hi = (hi + Math.imul(ah7, bh4)) | 0;\n    lo = (lo + Math.imul(al6, bl5)) | 0;\n    mid = (mid + Math.imul(al6, bh5)) | 0;\n    mid = (mid + Math.imul(ah6, bl5)) | 0;\n    hi = (hi + Math.imul(ah6, bh5)) | 0;\n    lo = (lo + Math.imul(al5, bl6)) | 0;\n    mid = (mid + Math.imul(al5, bh6)) | 0;\n    mid = (mid + Math.imul(ah5, bl6)) | 0;\n    hi = (hi + Math.imul(ah5, bh6)) | 0;\n    lo = (lo + Math.imul(al4, bl7)) | 0;\n    mid = (mid + Math.imul(al4, bh7)) | 0;\n    mid = (mid + Math.imul(ah4, bl7)) | 0;\n    hi = (hi + Math.imul(ah4, bh7)) | 0;\n    lo = (lo + Math.imul(al3, bl8)) | 0;\n    mid = (mid + Math.imul(al3, bh8)) | 0;\n    mid = (mid + Math.imul(ah3, bl8)) | 0;\n    hi = (hi + Math.imul(ah3, bh8)) | 0;\n    lo = (lo + Math.imul(al2, bl9)) | 0;\n    mid = (mid + Math.imul(al2, bh9)) | 0;\n    mid = (mid + Math.imul(ah2, bl9)) | 0;\n    hi = (hi + Math.imul(ah2, bh9)) | 0;\n    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;\n    w11 &= 0x3ffffff;\n    /* k = 12 */\n    lo = Math.imul(al9, bl3);\n    mid = Math.imul(al9, bh3);\n    mid = (mid + Math.imul(ah9, bl3)) | 0;\n    hi = Math.imul(ah9, bh3);\n    lo = (lo + Math.imul(al8, bl4)) | 0;\n    mid = (mid + Math.imul(al8, bh4)) | 0;\n    mid = (mid + Math.imul(ah8, bl4)) | 0;\n    hi = (hi + Math.imul(ah8, bh4)) | 0;\n    lo = (lo + Math.imul(al7, bl5)) | 0;\n    mid = (mid + Math.imul(al7, bh5)) | 0;\n    mid = (mid + Math.imul(ah7, bl5)) | 0;\n    hi = (hi + Math.imul(ah7, bh5)) | 0;\n    lo = (lo + Math.imul(al6, bl6)) | 0;\n    mid = (mid + Math.imul(al6, bh6)) | 0;\n    mid = (mid + Math.imul(ah6, bl6)) | 0;\n    hi = (hi + Math.imul(ah6, bh6)) | 0;\n    lo = (lo + Math.imul(al5, bl7)) | 0;\n    mid = (mid + Math.imul(al5, bh7)) | 0;\n    mid = (mid + Math.imul(ah5, bl7)) | 0;\n    hi = (hi + Math.imul(ah5, bh7)) | 0;\n    lo = (lo + Math.imul(al4, bl8)) | 0;\n    mid = (mid + Math.imul(al4, bh8)) | 0;\n    mid = (mid + Math.imul(ah4, bl8)) | 0;\n    hi = (hi + Math.imul(ah4, bh8)) | 0;\n    lo = (lo + Math.imul(al3, bl9)) | 0;\n    mid = (mid + Math.imul(al3, bh9)) | 0;\n    mid = (mid + Math.imul(ah3, bl9)) | 0;\n    hi = (hi + Math.imul(ah3, bh9)) | 0;\n    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;\n    w12 &= 0x3ffffff;\n    /* k = 13 */\n    lo = Math.imul(al9, bl4);\n    mid = Math.imul(al9, bh4);\n    mid = (mid + Math.imul(ah9, bl4)) | 0;\n    hi = Math.imul(ah9, bh4);\n    lo = (lo + Math.imul(al8, bl5)) | 0;\n    mid = (mid + Math.imul(al8, bh5)) | 0;\n    mid = (mid + Math.imul(ah8, bl5)) | 0;\n    hi = (hi + Math.imul(ah8, bh5)) | 0;\n    lo = (lo + Math.imul(al7, bl6)) | 0;\n    mid = (mid + Math.imul(al7, bh6)) | 0;\n    mid = (mid + Math.imul(ah7, bl6)) | 0;\n    hi = (hi + Math.imul(ah7, bh6)) | 0;\n    lo = (lo + Math.imul(al6, bl7)) | 0;\n    mid = (mid + Math.imul(al6, bh7)) | 0;\n    mid = (mid + Math.imul(ah6, bl7)) | 0;\n    hi = (hi + Math.imul(ah6, bh7)) | 0;\n    lo = (lo + Math.imul(al5, bl8)) | 0;\n    mid = (mid + Math.imul(al5, bh8)) | 0;\n    mid = (mid + Math.imul(ah5, bl8)) | 0;\n    hi = (hi + Math.imul(ah5, bh8)) | 0;\n    lo = (lo + Math.imul(al4, bl9)) | 0;\n    mid = (mid + Math.imul(al4, bh9)) | 0;\n    mid = (mid + Math.imul(ah4, bl9)) | 0;\n    hi = (hi + Math.imul(ah4, bh9)) | 0;\n    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;\n    w13 &= 0x3ffffff;\n    /* k = 14 */\n    lo = Math.imul(al9, bl5);\n    mid = Math.imul(al9, bh5);\n    mid = (mid + Math.imul(ah9, bl5)) | 0;\n    hi = Math.imul(ah9, bh5);\n    lo = (lo + Math.imul(al8, bl6)) | 0;\n    mid = (mid + Math.imul(al8, bh6)) | 0;\n    mid = (mid + Math.imul(ah8, bl6)) | 0;\n    hi = (hi + Math.imul(ah8, bh6)) | 0;\n    lo = (lo + Math.imul(al7, bl7)) | 0;\n    mid = (mid + Math.imul(al7, bh7)) | 0;\n    mid = (mid + Math.imul(ah7, bl7)) | 0;\n    hi = (hi + Math.imul(ah7, bh7)) | 0;\n    lo = (lo + Math.imul(al6, bl8)) | 0;\n    mid = (mid + Math.imul(al6, bh8)) | 0;\n    mid = (mid + Math.imul(ah6, bl8)) | 0;\n    hi = (hi + Math.imul(ah6, bh8)) | 0;\n    lo = (lo + Math.imul(al5, bl9)) | 0;\n    mid = (mid + Math.imul(al5, bh9)) | 0;\n    mid = (mid + Math.imul(ah5, bl9)) | 0;\n    hi = (hi + Math.imul(ah5, bh9)) | 0;\n    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;\n    w14 &= 0x3ffffff;\n    /* k = 15 */\n    lo = Math.imul(al9, bl6);\n    mid = Math.imul(al9, bh6);\n    mid = (mid + Math.imul(ah9, bl6)) | 0;\n    hi = Math.imul(ah9, bh6);\n    lo = (lo + Math.imul(al8, bl7)) | 0;\n    mid = (mid + Math.imul(al8, bh7)) | 0;\n    mid = (mid + Math.imul(ah8, bl7)) | 0;\n    hi = (hi + Math.imul(ah8, bh7)) | 0;\n    lo = (lo + Math.imul(al7, bl8)) | 0;\n    mid = (mid + Math.imul(al7, bh8)) | 0;\n    mid = (mid + Math.imul(ah7, bl8)) | 0;\n    hi = (hi + Math.imul(ah7, bh8)) | 0;\n    lo = (lo + Math.imul(al6, bl9)) | 0;\n    mid = (mid + Math.imul(al6, bh9)) | 0;\n    mid = (mid + Math.imul(ah6, bl9)) | 0;\n    hi = (hi + Math.imul(ah6, bh9)) | 0;\n    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;\n    w15 &= 0x3ffffff;\n    /* k = 16 */\n    lo = Math.imul(al9, bl7);\n    mid = Math.imul(al9, bh7);\n    mid = (mid + Math.imul(ah9, bl7)) | 0;\n    hi = Math.imul(ah9, bh7);\n    lo = (lo + Math.imul(al8, bl8)) | 0;\n    mid = (mid + Math.imul(al8, bh8)) | 0;\n    mid = (mid + Math.imul(ah8, bl8)) | 0;\n    hi = (hi + Math.imul(ah8, bh8)) | 0;\n    lo = (lo + Math.imul(al7, bl9)) | 0;\n    mid = (mid + Math.imul(al7, bh9)) | 0;\n    mid = (mid + Math.imul(ah7, bl9)) | 0;\n    hi = (hi + Math.imul(ah7, bh9)) | 0;\n    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;\n    w16 &= 0x3ffffff;\n    /* k = 17 */\n    lo = Math.imul(al9, bl8);\n    mid = Math.imul(al9, bh8);\n    mid = (mid + Math.imul(ah9, bl8)) | 0;\n    hi = Math.imul(ah9, bh8);\n    lo = (lo + Math.imul(al8, bl9)) | 0;\n    mid = (mid + Math.imul(al8, bh9)) | 0;\n    mid = (mid + Math.imul(ah8, bl9)) | 0;\n    hi = (hi + Math.imul(ah8, bh9)) | 0;\n    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;\n    w17 &= 0x3ffffff;\n    /* k = 18 */\n    lo = Math.imul(al9, bl9);\n    mid = Math.imul(al9, bh9);\n    mid = (mid + Math.imul(ah9, bl9)) | 0;\n    hi = Math.imul(ah9, bh9);\n    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;\n    w18 &= 0x3ffffff;\n    o[0] = w0;\n    o[1] = w1;\n    o[2] = w2;\n    o[3] = w3;\n    o[4] = w4;\n    o[5] = w5;\n    o[6] = w6;\n    o[7] = w7;\n    o[8] = w8;\n    o[9] = w9;\n    o[10] = w10;\n    o[11] = w11;\n    o[12] = w12;\n    o[13] = w13;\n    o[14] = w14;\n    o[15] = w15;\n    o[16] = w16;\n    o[17] = w17;\n    o[18] = w18;\n    if (c !== 0) {\n      o[19] = c;\n      out.length++;\n    }\n    return out;\n  };\n\n  // Polyfill comb\n  if (!Math.imul) {\n    comb10MulTo = smallMulTo;\n  }\n\n  function bigMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    out.length = self.length + num.length;\n\n    var carry = 0;\n    var hncarry = 0;\n    for (var k = 0; k < out.length - 1; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = hncarry;\n      hncarry = 0;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = k - j;\n        var a = self.words[i] | 0;\n        var b = num.words[j] | 0;\n        var r = a * b;\n\n        var lo = r & 0x3ffffff;\n        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;\n        lo = (lo + rword) | 0;\n        rword = lo & 0x3ffffff;\n        ncarry = (ncarry + (lo >>> 26)) | 0;\n\n        hncarry += ncarry >>> 26;\n        ncarry &= 0x3ffffff;\n      }\n      out.words[k] = rword;\n      carry = ncarry;\n      ncarry = hncarry;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry;\n    } else {\n      out.length--;\n    }\n\n    return out.strip();\n  }\n\n  function jumboMulTo (self, num, out) {\n    var fftm = new FFTM();\n    return fftm.mulp(self, num, out);\n  }\n\n  BN.prototype.mulTo = function mulTo (num, out) {\n    var res;\n    var len = this.length + num.length;\n    if (this.length === 10 && num.length === 10) {\n      res = comb10MulTo(this, num, out);\n    } else if (len < 63) {\n      res = smallMulTo(this, num, out);\n    } else if (len < 1024) {\n      res = bigMulTo(this, num, out);\n    } else {\n      res = jumboMulTo(this, num, out);\n    }\n\n    return res;\n  };\n\n  // Cooley-Tukey algorithm for FFT\n  // slightly revisited to rely on looping instead of recursion\n\n  function FFTM (x, y) {\n    this.x = x;\n    this.y = y;\n  }\n\n  FFTM.prototype.makeRBT = function makeRBT (N) {\n    var t = new Array(N);\n    var l = BN.prototype._countBits(N) - 1;\n    for (var i = 0; i < N; i++) {\n      t[i] = this.revBin(i, l, N);\n    }\n\n    return t;\n  };\n\n  // Returns binary-reversed representation of `x`\n  FFTM.prototype.revBin = function revBin (x, l, N) {\n    if (x === 0 || x === N - 1) return x;\n\n    var rb = 0;\n    for (var i = 0; i < l; i++) {\n      rb |= (x & 1) << (l - i - 1);\n      x >>= 1;\n    }\n\n    return rb;\n  };\n\n  // Performs \"tweedling\" phase, therefore 'emulating'\n  // behaviour of the recursive algorithm\n  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {\n    for (var i = 0; i < N; i++) {\n      rtws[i] = rws[rbt[i]];\n      itws[i] = iws[rbt[i]];\n    }\n  };\n\n  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {\n    this.permute(rbt, rws, iws, rtws, itws, N);\n\n    for (var s = 1; s < N; s <<= 1) {\n      var l = s << 1;\n\n      var rtwdf = Math.cos(2 * Math.PI / l);\n      var itwdf = Math.sin(2 * Math.PI / l);\n\n      for (var p = 0; p < N; p += l) {\n        var rtwdf_ = rtwdf;\n        var itwdf_ = itwdf;\n\n        for (var j = 0; j < s; j++) {\n          var re = rtws[p + j];\n          var ie = itws[p + j];\n\n          var ro = rtws[p + j + s];\n          var io = itws[p + j + s];\n\n          var rx = rtwdf_ * ro - itwdf_ * io;\n\n          io = rtwdf_ * io + itwdf_ * ro;\n          ro = rx;\n\n          rtws[p + j] = re + ro;\n          itws[p + j] = ie + io;\n\n          rtws[p + j + s] = re - ro;\n          itws[p + j + s] = ie - io;\n\n          /* jshint maxdepth : false */\n          if (j !== l) {\n            rx = rtwdf * rtwdf_ - itwdf * itwdf_;\n\n            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;\n            rtwdf_ = rx;\n          }\n        }\n      }\n    }\n  };\n\n  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {\n    var N = Math.max(m, n) | 1;\n    var odd = N & 1;\n    var i = 0;\n    for (N = N / 2 | 0; N; N = N >>> 1) {\n      i++;\n    }\n\n    return 1 << i + 1 + odd;\n  };\n\n  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {\n    if (N <= 1) return;\n\n    for (var i = 0; i < N / 2; i++) {\n      var t = rws[i];\n\n      rws[i] = rws[N - i - 1];\n      rws[N - i - 1] = t;\n\n      t = iws[i];\n\n      iws[i] = -iws[N - i - 1];\n      iws[N - i - 1] = -t;\n    }\n  };\n\n  FFTM.prototype.normalize13b = function normalize13b (ws, N) {\n    var carry = 0;\n    for (var i = 0; i < N / 2; i++) {\n      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +\n        Math.round(ws[2 * i] / N) +\n        carry;\n\n      ws[i] = w & 0x3ffffff;\n\n      if (w < 0x4000000) {\n        carry = 0;\n      } else {\n        carry = w / 0x4000000 | 0;\n      }\n    }\n\n    return ws;\n  };\n\n  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {\n    var carry = 0;\n    for (var i = 0; i < len; i++) {\n      carry = carry + (ws[i] | 0);\n\n      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;\n      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;\n    }\n\n    // Pad with zeroes\n    for (i = 2 * len; i < N; ++i) {\n      rws[i] = 0;\n    }\n\n    assert(carry === 0);\n    assert((carry & ~0x1fff) === 0);\n  };\n\n  FFTM.prototype.stub = function stub (N) {\n    var ph = new Array(N);\n    for (var i = 0; i < N; i++) {\n      ph[i] = 0;\n    }\n\n    return ph;\n  };\n\n  FFTM.prototype.mulp = function mulp (x, y, out) {\n    var N = 2 * this.guessLen13b(x.length, y.length);\n\n    var rbt = this.makeRBT(N);\n\n    var _ = this.stub(N);\n\n    var rws = new Array(N);\n    var rwst = new Array(N);\n    var iwst = new Array(N);\n\n    var nrws = new Array(N);\n    var nrwst = new Array(N);\n    var niwst = new Array(N);\n\n    var rmws = out.words;\n    rmws.length = N;\n\n    this.convert13b(x.words, x.length, rws, N);\n    this.convert13b(y.words, y.length, nrws, N);\n\n    this.transform(rws, _, rwst, iwst, N, rbt);\n    this.transform(nrws, _, nrwst, niwst, N, rbt);\n\n    for (var i = 0; i < N; i++) {\n      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];\n      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];\n      rwst[i] = rx;\n    }\n\n    this.conjugate(rwst, iwst, N);\n    this.transform(rwst, iwst, rmws, _, N, rbt);\n    this.conjugate(rmws, _, N);\n    this.normalize13b(rmws, N);\n\n    out.negative = x.negative ^ y.negative;\n    out.length = x.length + y.length;\n    return out.strip();\n  };\n\n  // Multiply `this` by `num`\n  BN.prototype.mul = function mul (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return this.mulTo(num, out);\n  };\n\n  // Multiply employing FFT\n  BN.prototype.mulf = function mulf (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return jumboMulTo(this, num, out);\n  };\n\n  // In-place Multiplication\n  BN.prototype.imul = function imul (num) {\n    return this.clone().mulTo(num, this);\n  };\n\n  BN.prototype.imuln = function imuln (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n\n    // Carry\n    var carry = 0;\n    for (var i = 0; i < this.length; i++) {\n      var w = (this.words[i] | 0) * num;\n      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);\n      carry >>= 26;\n      carry += (w / 0x4000000) | 0;\n      // NOTE: lo is 27bit maximum\n      carry += lo >>> 26;\n      this.words[i] = lo & 0x3ffffff;\n    }\n\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n\n    return this;\n  };\n\n  BN.prototype.muln = function muln (num) {\n    return this.clone().imuln(num);\n  };\n\n  // `this` * `this`\n  BN.prototype.sqr = function sqr () {\n    return this.mul(this);\n  };\n\n  // `this` * `this` in-place\n  BN.prototype.isqr = function isqr () {\n    return this.imul(this.clone());\n  };\n\n  // Math.pow(`this`, `num`)\n  BN.prototype.pow = function pow (num) {\n    var w = toBitArray(num);\n    if (w.length === 0) return new BN(1);\n\n    // Skip leading zeroes\n    var res = this;\n    for (var i = 0; i < w.length; i++, res = res.sqr()) {\n      if (w[i] !== 0) break;\n    }\n\n    if (++i < w.length) {\n      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {\n        if (w[i] === 0) continue;\n\n        res = res.mul(q);\n      }\n    }\n\n    return res;\n  };\n\n  // Shift-left in-place\n  BN.prototype.iushln = function iushln (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);\n    var i;\n\n    if (r !== 0) {\n      var carry = 0;\n\n      for (i = 0; i < this.length; i++) {\n        var newCarry = this.words[i] & carryMask;\n        var c = ((this.words[i] | 0) - newCarry) << r;\n        this.words[i] = c | carry;\n        carry = newCarry >>> (26 - r);\n      }\n\n      if (carry) {\n        this.words[i] = carry;\n        this.length++;\n      }\n    }\n\n    if (s !== 0) {\n      for (i = this.length - 1; i >= 0; i--) {\n        this.words[i + s] = this.words[i];\n      }\n\n      for (i = 0; i < s; i++) {\n        this.words[i] = 0;\n      }\n\n      this.length += s;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ishln = function ishln (bits) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushln(bits);\n  };\n\n  // Shift-right in-place\n  // NOTE: `hint` is a lowest bit before trailing zeroes\n  // NOTE: if `extended` is present - it will be filled with destroyed bits\n  BN.prototype.iushrn = function iushrn (bits, hint, extended) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var h;\n    if (hint) {\n      h = (hint - (hint % 26)) / 26;\n    } else {\n      h = 0;\n    }\n\n    var r = bits % 26;\n    var s = Math.min((bits - r) / 26, this.length);\n    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n    var maskedWords = extended;\n\n    h -= s;\n    h = Math.max(0, h);\n\n    // Extended mode, copy masked part\n    if (maskedWords) {\n      for (var i = 0; i < s; i++) {\n        maskedWords.words[i] = this.words[i];\n      }\n      maskedWords.length = s;\n    }\n\n    if (s === 0) {\n      // No-op, we should not move anything at all\n    } else if (this.length > s) {\n      this.length -= s;\n      for (i = 0; i < this.length; i++) {\n        this.words[i] = this.words[i + s];\n      }\n    } else {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    var carry = 0;\n    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {\n      var word = this.words[i] | 0;\n      this.words[i] = (carry << (26 - r)) | (word >>> r);\n      carry = word & mask;\n    }\n\n    // Push carried bits as a mask\n    if (maskedWords && carry !== 0) {\n      maskedWords.words[maskedWords.length++] = carry;\n    }\n\n    if (this.length === 0) {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ishrn = function ishrn (bits, hint, extended) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushrn(bits, hint, extended);\n  };\n\n  // Shift-left\n  BN.prototype.shln = function shln (bits) {\n    return this.clone().ishln(bits);\n  };\n\n  BN.prototype.ushln = function ushln (bits) {\n    return this.clone().iushln(bits);\n  };\n\n  // Shift-right\n  BN.prototype.shrn = function shrn (bits) {\n    return this.clone().ishrn(bits);\n  };\n\n  BN.prototype.ushrn = function ushrn (bits) {\n    return this.clone().iushrn(bits);\n  };\n\n  // Test if n bit is set\n  BN.prototype.testn = function testn (bit) {\n    assert(typeof bit === 'number' && bit >= 0);\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) return false;\n\n    // Check bit and return\n    var w = this.words[s];\n\n    return !!(w & q);\n  };\n\n  // Return only lowers bits of number (in-place)\n  BN.prototype.imaskn = function imaskn (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n\n    assert(this.negative === 0, 'imaskn works only with positive numbers');\n\n    if (this.length <= s) {\n      return this;\n    }\n\n    if (r !== 0) {\n      s++;\n    }\n    this.length = Math.min(s, this.length);\n\n    if (r !== 0) {\n      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n      this.words[this.length - 1] &= mask;\n    }\n\n    return this.strip();\n  };\n\n  // Return only lowers bits of number\n  BN.prototype.maskn = function maskn (bits) {\n    return this.clone().imaskn(bits);\n  };\n\n  // Add plain number `num` to `this`\n  BN.prototype.iaddn = function iaddn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.isubn(-num);\n\n    // Possible sign change\n    if (this.negative !== 0) {\n      if (this.length === 1 && (this.words[0] | 0) < num) {\n        this.words[0] = num - (this.words[0] | 0);\n        this.negative = 0;\n        return this;\n      }\n\n      this.negative = 0;\n      this.isubn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    // Add without checks\n    return this._iaddn(num);\n  };\n\n  BN.prototype._iaddn = function _iaddn (num) {\n    this.words[0] += num;\n\n    // Carry\n    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {\n      this.words[i] -= 0x4000000;\n      if (i === this.length - 1) {\n        this.words[i + 1] = 1;\n      } else {\n        this.words[i + 1]++;\n      }\n    }\n    this.length = Math.max(this.length, i + 1);\n\n    return this;\n  };\n\n  // Subtract plain number `num` from `this`\n  BN.prototype.isubn = function isubn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.iaddn(-num);\n\n    if (this.negative !== 0) {\n      this.negative = 0;\n      this.iaddn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    this.words[0] -= num;\n\n    if (this.length === 1 && this.words[0] < 0) {\n      this.words[0] = -this.words[0];\n      this.negative = 1;\n    } else {\n      // Carry\n      for (var i = 0; i < this.length && this.words[i] < 0; i++) {\n        this.words[i] += 0x4000000;\n        this.words[i + 1] -= 1;\n      }\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.addn = function addn (num) {\n    return this.clone().iaddn(num);\n  };\n\n  BN.prototype.subn = function subn (num) {\n    return this.clone().isubn(num);\n  };\n\n  BN.prototype.iabs = function iabs () {\n    this.negative = 0;\n\n    return this;\n  };\n\n  BN.prototype.abs = function abs () {\n    return this.clone().iabs();\n  };\n\n  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {\n    var len = num.length + shift;\n    var i;\n\n    this._expand(len);\n\n    var w;\n    var carry = 0;\n    for (i = 0; i < num.length; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      var right = (num.words[i] | 0) * mul;\n      w -= right & 0x3ffffff;\n      carry = (w >> 26) - ((right / 0x4000000) | 0);\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n    for (; i < this.length - shift; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      carry = w >> 26;\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n\n    if (carry === 0) return this.strip();\n\n    // Subtraction overflow\n    assert(carry === -1);\n    carry = 0;\n    for (i = 0; i < this.length; i++) {\n      w = -(this.words[i] | 0) + carry;\n      carry = w >> 26;\n      this.words[i] = w & 0x3ffffff;\n    }\n    this.negative = 1;\n\n    return this.strip();\n  };\n\n  BN.prototype._wordDiv = function _wordDiv (num, mode) {\n    var shift = this.length - num.length;\n\n    var a = this.clone();\n    var b = num;\n\n    // Normalize\n    var bhi = b.words[b.length - 1] | 0;\n    var bhiBits = this._countBits(bhi);\n    shift = 26 - bhiBits;\n    if (shift !== 0) {\n      b = b.ushln(shift);\n      a.iushln(shift);\n      bhi = b.words[b.length - 1] | 0;\n    }\n\n    // Initialize quotient\n    var m = a.length - b.length;\n    var q;\n\n    if (mode !== 'mod') {\n      q = new BN(null);\n      q.length = m + 1;\n      q.words = new Array(q.length);\n      for (var i = 0; i < q.length; i++) {\n        q.words[i] = 0;\n      }\n    }\n\n    var diff = a.clone()._ishlnsubmul(b, 1, m);\n    if (diff.negative === 0) {\n      a = diff;\n      if (q) {\n        q.words[m] = 1;\n      }\n    }\n\n    for (var j = m - 1; j >= 0; j--) {\n      var qj = (a.words[b.length + j] | 0) * 0x4000000 +\n        (a.words[b.length + j - 1] | 0);\n\n      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max\n      // (0x7ffffff)\n      qj = Math.min((qj / bhi) | 0, 0x3ffffff);\n\n      a._ishlnsubmul(b, qj, j);\n      while (a.negative !== 0) {\n        qj--;\n        a.negative = 0;\n        a._ishlnsubmul(b, 1, j);\n        if (!a.isZero()) {\n          a.negative ^= 1;\n        }\n      }\n      if (q) {\n        q.words[j] = qj;\n      }\n    }\n    if (q) {\n      q.strip();\n    }\n    a.strip();\n\n    // Denormalize\n    if (mode !== 'div' && shift !== 0) {\n      a.iushrn(shift);\n    }\n\n    return {\n      div: q || null,\n      mod: a\n    };\n  };\n\n  // NOTE: 1) `mode` can be set to `mod` to request mod only,\n  //       to `div` to request div only, or be absent to\n  //       request both div & mod\n  //       2) `positive` is true if unsigned mod is requested\n  BN.prototype.divmod = function divmod (num, mode, positive) {\n    assert(!num.isZero());\n\n    if (this.isZero()) {\n      return {\n        div: new BN(0),\n        mod: new BN(0)\n      };\n    }\n\n    var div, mod, res;\n    if (this.negative !== 0 && num.negative === 0) {\n      res = this.neg().divmod(num, mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.iadd(num);\n        }\n      }\n\n      return {\n        div: div,\n        mod: mod\n      };\n    }\n\n    if (this.negative === 0 && num.negative !== 0) {\n      res = this.divmod(num.neg(), mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      return {\n        div: div,\n        mod: res.mod\n      };\n    }\n\n    if ((this.negative & num.negative) !== 0) {\n      res = this.neg().divmod(num.neg(), mode);\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.isub(num);\n        }\n      }\n\n      return {\n        div: res.div,\n        mod: mod\n      };\n    }\n\n    // Both numbers are positive at this point\n\n    // Strip both numbers to approximate shift value\n    if (num.length > this.length || this.cmp(num) < 0) {\n      return {\n        div: new BN(0),\n        mod: this\n      };\n    }\n\n    // Very short reduction\n    if (num.length === 1) {\n      if (mode === 'div') {\n        return {\n          div: this.divn(num.words[0]),\n          mod: null\n        };\n      }\n\n      if (mode === 'mod') {\n        return {\n          div: null,\n          mod: new BN(this.modn(num.words[0]))\n        };\n      }\n\n      return {\n        div: this.divn(num.words[0]),\n        mod: new BN(this.modn(num.words[0]))\n      };\n    }\n\n    return this._wordDiv(num, mode);\n  };\n\n  // Find `this` / `num`\n  BN.prototype.div = function div (num) {\n    return this.divmod(num, 'div', false).div;\n  };\n\n  // Find `this` % `num`\n  BN.prototype.mod = function mod (num) {\n    return this.divmod(num, 'mod', false).mod;\n  };\n\n  BN.prototype.umod = function umod (num) {\n    return this.divmod(num, 'mod', true).mod;\n  };\n\n  // Find Round(`this` / `num`)\n  BN.prototype.divRound = function divRound (num) {\n    var dm = this.divmod(num);\n\n    // Fast case - exact division\n    if (dm.mod.isZero()) return dm.div;\n\n    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;\n\n    var half = num.ushrn(1);\n    var r2 = num.andln(1);\n    var cmp = mod.cmp(half);\n\n    // Round down\n    if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;\n\n    // Round up\n    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);\n  };\n\n  BN.prototype.modn = function modn (num) {\n    assert(num <= 0x3ffffff);\n    var p = (1 << 26) % num;\n\n    var acc = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      acc = (p * acc + (this.words[i] | 0)) % num;\n    }\n\n    return acc;\n  };\n\n  // In-place division by number\n  BN.prototype.idivn = function idivn (num) {\n    assert(num <= 0x3ffffff);\n\n    var carry = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var w = (this.words[i] | 0) + carry * 0x4000000;\n      this.words[i] = (w / num) | 0;\n      carry = w % num;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.divn = function divn (num) {\n    return this.clone().idivn(num);\n  };\n\n  BN.prototype.egcd = function egcd (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var x = this;\n    var y = p.clone();\n\n    if (x.negative !== 0) {\n      x = x.umod(p);\n    } else {\n      x = x.clone();\n    }\n\n    // A * x + B * y = x\n    var A = new BN(1);\n    var B = new BN(0);\n\n    // C * x + D * y = y\n    var C = new BN(0);\n    var D = new BN(1);\n\n    var g = 0;\n\n    while (x.isEven() && y.isEven()) {\n      x.iushrn(1);\n      y.iushrn(1);\n      ++g;\n    }\n\n    var yp = y.clone();\n    var xp = x.clone();\n\n    while (!x.isZero()) {\n      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        x.iushrn(i);\n        while (i-- > 0) {\n          if (A.isOdd() || B.isOdd()) {\n            A.iadd(yp);\n            B.isub(xp);\n          }\n\n          A.iushrn(1);\n          B.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        y.iushrn(j);\n        while (j-- > 0) {\n          if (C.isOdd() || D.isOdd()) {\n            C.iadd(yp);\n            D.isub(xp);\n          }\n\n          C.iushrn(1);\n          D.iushrn(1);\n        }\n      }\n\n      if (x.cmp(y) >= 0) {\n        x.isub(y);\n        A.isub(C);\n        B.isub(D);\n      } else {\n        y.isub(x);\n        C.isub(A);\n        D.isub(B);\n      }\n    }\n\n    return {\n      a: C,\n      b: D,\n      gcd: y.iushln(g)\n    };\n  };\n\n  // This is reduced incarnation of the binary EEA\n  // above, designated to invert members of the\n  // _prime_ fields F(p) at a maximal speed\n  BN.prototype._invmp = function _invmp (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var a = this;\n    var b = p.clone();\n\n    if (a.negative !== 0) {\n      a = a.umod(p);\n    } else {\n      a = a.clone();\n    }\n\n    var x1 = new BN(1);\n    var x2 = new BN(0);\n\n    var delta = b.clone();\n\n    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {\n      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        a.iushrn(i);\n        while (i-- > 0) {\n          if (x1.isOdd()) {\n            x1.iadd(delta);\n          }\n\n          x1.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        b.iushrn(j);\n        while (j-- > 0) {\n          if (x2.isOdd()) {\n            x2.iadd(delta);\n          }\n\n          x2.iushrn(1);\n        }\n      }\n\n      if (a.cmp(b) >= 0) {\n        a.isub(b);\n        x1.isub(x2);\n      } else {\n        b.isub(a);\n        x2.isub(x1);\n      }\n    }\n\n    var res;\n    if (a.cmpn(1) === 0) {\n      res = x1;\n    } else {\n      res = x2;\n    }\n\n    if (res.cmpn(0) < 0) {\n      res.iadd(p);\n    }\n\n    return res;\n  };\n\n  BN.prototype.gcd = function gcd (num) {\n    if (this.isZero()) return num.abs();\n    if (num.isZero()) return this.abs();\n\n    var a = this.clone();\n    var b = num.clone();\n    a.negative = 0;\n    b.negative = 0;\n\n    // Remove common factor of two\n    for (var shift = 0; a.isEven() && b.isEven(); shift++) {\n      a.iushrn(1);\n      b.iushrn(1);\n    }\n\n    do {\n      while (a.isEven()) {\n        a.iushrn(1);\n      }\n      while (b.isEven()) {\n        b.iushrn(1);\n      }\n\n      var r = a.cmp(b);\n      if (r < 0) {\n        // Swap `a` and `b` to make `a` always bigger than `b`\n        var t = a;\n        a = b;\n        b = t;\n      } else if (r === 0 || b.cmpn(1) === 0) {\n        break;\n      }\n\n      a.isub(b);\n    } while (true);\n\n    return b.iushln(shift);\n  };\n\n  // Invert number in the field F(num)\n  BN.prototype.invm = function invm (num) {\n    return this.egcd(num).a.umod(num);\n  };\n\n  BN.prototype.isEven = function isEven () {\n    return (this.words[0] & 1) === 0;\n  };\n\n  BN.prototype.isOdd = function isOdd () {\n    return (this.words[0] & 1) === 1;\n  };\n\n  // And first word and num\n  BN.prototype.andln = function andln (num) {\n    return this.words[0] & num;\n  };\n\n  // Increment at the bit position in-line\n  BN.prototype.bincn = function bincn (bit) {\n    assert(typeof bit === 'number');\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) {\n      this._expand(s + 1);\n      this.words[s] |= q;\n      return this;\n    }\n\n    // Add bit and propagate, if needed\n    var carry = q;\n    for (var i = s; carry !== 0 && i < this.length; i++) {\n      var w = this.words[i] | 0;\n      w += carry;\n      carry = w >>> 26;\n      w &= 0x3ffffff;\n      this.words[i] = w;\n    }\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n    return this;\n  };\n\n  BN.prototype.isZero = function isZero () {\n    return this.length === 1 && this.words[0] === 0;\n  };\n\n  BN.prototype.cmpn = function cmpn (num) {\n    var negative = num < 0;\n\n    if (this.negative !== 0 && !negative) return -1;\n    if (this.negative === 0 && negative) return 1;\n\n    this.strip();\n\n    var res;\n    if (this.length > 1) {\n      res = 1;\n    } else {\n      if (negative) {\n        num = -num;\n      }\n\n      assert(num <= 0x3ffffff, 'Number is too big');\n\n      var w = this.words[0] | 0;\n      res = w === num ? 0 : w < num ? -1 : 1;\n    }\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Compare two numbers and return:\n  // 1 - if `this` > `num`\n  // 0 - if `this` == `num`\n  // -1 - if `this` < `num`\n  BN.prototype.cmp = function cmp (num) {\n    if (this.negative !== 0 && num.negative === 0) return -1;\n    if (this.negative === 0 && num.negative !== 0) return 1;\n\n    var res = this.ucmp(num);\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Unsigned comparison\n  BN.prototype.ucmp = function ucmp (num) {\n    // At this point both numbers have the same sign\n    if (this.length > num.length) return 1;\n    if (this.length < num.length) return -1;\n\n    var res = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var a = this.words[i] | 0;\n      var b = num.words[i] | 0;\n\n      if (a === b) continue;\n      if (a < b) {\n        res = -1;\n      } else if (a > b) {\n        res = 1;\n      }\n      break;\n    }\n    return res;\n  };\n\n  BN.prototype.gtn = function gtn (num) {\n    return this.cmpn(num) === 1;\n  };\n\n  BN.prototype.gt = function gt (num) {\n    return this.cmp(num) === 1;\n  };\n\n  BN.prototype.gten = function gten (num) {\n    return this.cmpn(num) >= 0;\n  };\n\n  BN.prototype.gte = function gte (num) {\n    return this.cmp(num) >= 0;\n  };\n\n  BN.prototype.ltn = function ltn (num) {\n    return this.cmpn(num) === -1;\n  };\n\n  BN.prototype.lt = function lt (num) {\n    return this.cmp(num) === -1;\n  };\n\n  BN.prototype.lten = function lten (num) {\n    return this.cmpn(num) <= 0;\n  };\n\n  BN.prototype.lte = function lte (num) {\n    return this.cmp(num) <= 0;\n  };\n\n  BN.prototype.eqn = function eqn (num) {\n    return this.cmpn(num) === 0;\n  };\n\n  BN.prototype.eq = function eq (num) {\n    return this.cmp(num) === 0;\n  };\n\n  //\n  // A reduce context, could be using montgomery or something better, depending\n  // on the `m` itself.\n  //\n  BN.red = function red (num) {\n    return new Red(num);\n  };\n\n  BN.prototype.toRed = function toRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    assert(this.negative === 0, 'red works only with positives');\n    return ctx.convertTo(this)._forceRed(ctx);\n  };\n\n  BN.prototype.fromRed = function fromRed () {\n    assert(this.red, 'fromRed works only with numbers in reduction context');\n    return this.red.convertFrom(this);\n  };\n\n  BN.prototype._forceRed = function _forceRed (ctx) {\n    this.red = ctx;\n    return this;\n  };\n\n  BN.prototype.forceRed = function forceRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    return this._forceRed(ctx);\n  };\n\n  BN.prototype.redAdd = function redAdd (num) {\n    assert(this.red, 'redAdd works only with red numbers');\n    return this.red.add(this, num);\n  };\n\n  BN.prototype.redIAdd = function redIAdd (num) {\n    assert(this.red, 'redIAdd works only with red numbers');\n    return this.red.iadd(this, num);\n  };\n\n  BN.prototype.redSub = function redSub (num) {\n    assert(this.red, 'redSub works only with red numbers');\n    return this.red.sub(this, num);\n  };\n\n  BN.prototype.redISub = function redISub (num) {\n    assert(this.red, 'redISub works only with red numbers');\n    return this.red.isub(this, num);\n  };\n\n  BN.prototype.redShl = function redShl (num) {\n    assert(this.red, 'redShl works only with red numbers');\n    return this.red.shl(this, num);\n  };\n\n  BN.prototype.redMul = function redMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.mul(this, num);\n  };\n\n  BN.prototype.redIMul = function redIMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.imul(this, num);\n  };\n\n  BN.prototype.redSqr = function redSqr () {\n    assert(this.red, 'redSqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqr(this);\n  };\n\n  BN.prototype.redISqr = function redISqr () {\n    assert(this.red, 'redISqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.isqr(this);\n  };\n\n  // Square root over p\n  BN.prototype.redSqrt = function redSqrt () {\n    assert(this.red, 'redSqrt works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqrt(this);\n  };\n\n  BN.prototype.redInvm = function redInvm () {\n    assert(this.red, 'redInvm works only with red numbers');\n    this.red._verify1(this);\n    return this.red.invm(this);\n  };\n\n  // Return negative clone of `this` % `red modulo`\n  BN.prototype.redNeg = function redNeg () {\n    assert(this.red, 'redNeg works only with red numbers');\n    this.red._verify1(this);\n    return this.red.neg(this);\n  };\n\n  BN.prototype.redPow = function redPow (num) {\n    assert(this.red && !num.red, 'redPow(normalNum)');\n    this.red._verify1(this);\n    return this.red.pow(this, num);\n  };\n\n  // Prime numbers with efficient reduction\n  var primes = {\n    k256: null,\n    p224: null,\n    p192: null,\n    p25519: null\n  };\n\n  // Pseudo-Mersenne prime\n  function MPrime (name, p) {\n    // P = 2 ^ N - K\n    this.name = name;\n    this.p = new BN(p, 16);\n    this.n = this.p.bitLength();\n    this.k = new BN(1).iushln(this.n).isub(this.p);\n\n    this.tmp = this._tmp();\n  }\n\n  MPrime.prototype._tmp = function _tmp () {\n    var tmp = new BN(null);\n    tmp.words = new Array(Math.ceil(this.n / 13));\n    return tmp;\n  };\n\n  MPrime.prototype.ireduce = function ireduce (num) {\n    // Assumes that `num` is less than `P^2`\n    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)\n    var r = num;\n    var rlen;\n\n    do {\n      this.split(r, this.tmp);\n      r = this.imulK(r);\n      r = r.iadd(this.tmp);\n      rlen = r.bitLength();\n    } while (rlen > this.n);\n\n    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);\n    if (cmp === 0) {\n      r.words[0] = 0;\n      r.length = 1;\n    } else if (cmp > 0) {\n      r.isub(this.p);\n    } else {\n      r.strip();\n    }\n\n    return r;\n  };\n\n  MPrime.prototype.split = function split (input, out) {\n    input.iushrn(this.n, 0, out);\n  };\n\n  MPrime.prototype.imulK = function imulK (num) {\n    return num.imul(this.k);\n  };\n\n  function K256 () {\n    MPrime.call(\n      this,\n      'k256',\n      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');\n  }\n  inherits(K256, MPrime);\n\n  K256.prototype.split = function split (input, output) {\n    // 256 = 9 * 26 + 22\n    var mask = 0x3fffff;\n\n    var outLen = Math.min(input.length, 9);\n    for (var i = 0; i < outLen; i++) {\n      output.words[i] = input.words[i];\n    }\n    output.length = outLen;\n\n    if (input.length <= 9) {\n      input.words[0] = 0;\n      input.length = 1;\n      return;\n    }\n\n    // Shift by 9 limbs\n    var prev = input.words[9];\n    output.words[output.length++] = prev & mask;\n\n    for (i = 10; i < input.length; i++) {\n      var next = input.words[i] | 0;\n      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);\n      prev = next;\n    }\n    prev >>>= 22;\n    input.words[i - 10] = prev;\n    if (prev === 0 && input.length > 10) {\n      input.length -= 10;\n    } else {\n      input.length -= 9;\n    }\n  };\n\n  K256.prototype.imulK = function imulK (num) {\n    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]\n    num.words[num.length] = 0;\n    num.words[num.length + 1] = 0;\n    num.length += 2;\n\n    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390\n    var lo = 0;\n    for (var i = 0; i < num.length; i++) {\n      var w = num.words[i] | 0;\n      lo += w * 0x3d1;\n      num.words[i] = lo & 0x3ffffff;\n      lo = w * 0x40 + ((lo / 0x4000000) | 0);\n    }\n\n    // Fast length reduction\n    if (num.words[num.length - 1] === 0) {\n      num.length--;\n      if (num.words[num.length - 1] === 0) {\n        num.length--;\n      }\n    }\n    return num;\n  };\n\n  function P224 () {\n    MPrime.call(\n      this,\n      'p224',\n      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');\n  }\n  inherits(P224, MPrime);\n\n  function P192 () {\n    MPrime.call(\n      this,\n      'p192',\n      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');\n  }\n  inherits(P192, MPrime);\n\n  function P25519 () {\n    // 2 ^ 255 - 19\n    MPrime.call(\n      this,\n      '25519',\n      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');\n  }\n  inherits(P25519, MPrime);\n\n  P25519.prototype.imulK = function imulK (num) {\n    // K = 0x13\n    var carry = 0;\n    for (var i = 0; i < num.length; i++) {\n      var hi = (num.words[i] | 0) * 0x13 + carry;\n      var lo = hi & 0x3ffffff;\n      hi >>>= 26;\n\n      num.words[i] = lo;\n      carry = hi;\n    }\n    if (carry !== 0) {\n      num.words[num.length++] = carry;\n    }\n    return num;\n  };\n\n  // Exported mostly for testing purposes, use plain name instead\n  BN._prime = function prime (name) {\n    // Cached version of prime\n    if (primes[name]) return primes[name];\n\n    var prime;\n    if (name === 'k256') {\n      prime = new K256();\n    } else if (name === 'p224') {\n      prime = new P224();\n    } else if (name === 'p192') {\n      prime = new P192();\n    } else if (name === 'p25519') {\n      prime = new P25519();\n    } else {\n      throw new Error('Unknown prime ' + name);\n    }\n    primes[name] = prime;\n\n    return prime;\n  };\n\n  //\n  // Base reduction engine\n  //\n  function Red (m) {\n    if (typeof m === 'string') {\n      var prime = BN._prime(m);\n      this.m = prime.p;\n      this.prime = prime;\n    } else {\n      assert(m.gtn(1), 'modulus must be greater than 1');\n      this.m = m;\n      this.prime = null;\n    }\n  }\n\n  Red.prototype._verify1 = function _verify1 (a) {\n    assert(a.negative === 0, 'red works only with positives');\n    assert(a.red, 'red works only with red numbers');\n  };\n\n  Red.prototype._verify2 = function _verify2 (a, b) {\n    assert((a.negative | b.negative) === 0, 'red works only with positives');\n    assert(a.red && a.red === b.red,\n      'red works only with red numbers');\n  };\n\n  Red.prototype.imod = function imod (a) {\n    if (this.prime) return this.prime.ireduce(a)._forceRed(this);\n    return a.umod(this.m)._forceRed(this);\n  };\n\n  Red.prototype.neg = function neg (a) {\n    if (a.isZero()) {\n      return a.clone();\n    }\n\n    return this.m.sub(a)._forceRed(this);\n  };\n\n  Red.prototype.add = function add (a, b) {\n    this._verify2(a, b);\n\n    var res = a.add(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.iadd = function iadd (a, b) {\n    this._verify2(a, b);\n\n    var res = a.iadd(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.sub = function sub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.sub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.isub = function isub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.isub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.shl = function shl (a, num) {\n    this._verify1(a);\n    return this.imod(a.ushln(num));\n  };\n\n  Red.prototype.imul = function imul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.imul(b));\n  };\n\n  Red.prototype.mul = function mul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.mul(b));\n  };\n\n  Red.prototype.isqr = function isqr (a) {\n    return this.imul(a, a.clone());\n  };\n\n  Red.prototype.sqr = function sqr (a) {\n    return this.mul(a, a);\n  };\n\n  Red.prototype.sqrt = function sqrt (a) {\n    if (a.isZero()) return a.clone();\n\n    var mod3 = this.m.andln(3);\n    assert(mod3 % 2 === 1);\n\n    // Fast case\n    if (mod3 === 3) {\n      var pow = this.m.add(new BN(1)).iushrn(2);\n      return this.pow(a, pow);\n    }\n\n    // Tonelli-Shanks algorithm (Totally unoptimized and slow)\n    //\n    // Find Q and S, that Q * 2 ^ S = (P - 1)\n    var q = this.m.subn(1);\n    var s = 0;\n    while (!q.isZero() && q.andln(1) === 0) {\n      s++;\n      q.iushrn(1);\n    }\n    assert(!q.isZero());\n\n    var one = new BN(1).toRed(this);\n    var nOne = one.redNeg();\n\n    // Find quadratic non-residue\n    // NOTE: Max is such because of generalized Riemann hypothesis.\n    var lpow = this.m.subn(1).iushrn(1);\n    var z = this.m.bitLength();\n    z = new BN(2 * z * z).toRed(this);\n\n    while (this.pow(z, lpow).cmp(nOne) !== 0) {\n      z.redIAdd(nOne);\n    }\n\n    var c = this.pow(z, q);\n    var r = this.pow(a, q.addn(1).iushrn(1));\n    var t = this.pow(a, q);\n    var m = s;\n    while (t.cmp(one) !== 0) {\n      var tmp = t;\n      for (var i = 0; tmp.cmp(one) !== 0; i++) {\n        tmp = tmp.redSqr();\n      }\n      assert(i < m);\n      var b = this.pow(c, new BN(1).iushln(m - i - 1));\n\n      r = r.redMul(b);\n      c = b.redSqr();\n      t = t.redMul(c);\n      m = i;\n    }\n\n    return r;\n  };\n\n  Red.prototype.invm = function invm (a) {\n    var inv = a._invmp(this.m);\n    if (inv.negative !== 0) {\n      inv.negative = 0;\n      return this.imod(inv).redNeg();\n    } else {\n      return this.imod(inv);\n    }\n  };\n\n  Red.prototype.pow = function pow (a, num) {\n    if (num.isZero()) return new BN(1).toRed(this);\n    if (num.cmpn(1) === 0) return a.clone();\n\n    var windowSize = 4;\n    var wnd = new Array(1 << windowSize);\n    wnd[0] = new BN(1).toRed(this);\n    wnd[1] = a;\n    for (var i = 2; i < wnd.length; i++) {\n      wnd[i] = this.mul(wnd[i - 1], a);\n    }\n\n    var res = wnd[0];\n    var current = 0;\n    var currentLen = 0;\n    var start = num.bitLength() % 26;\n    if (start === 0) {\n      start = 26;\n    }\n\n    for (i = num.length - 1; i >= 0; i--) {\n      var word = num.words[i];\n      for (var j = start - 1; j >= 0; j--) {\n        var bit = (word >> j) & 1;\n        if (res !== wnd[0]) {\n          res = this.sqr(res);\n        }\n\n        if (bit === 0 && current === 0) {\n          currentLen = 0;\n          continue;\n        }\n\n        current <<= 1;\n        current |= bit;\n        currentLen++;\n        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;\n\n        res = this.mul(res, wnd[current]);\n        currentLen = 0;\n        current = 0;\n      }\n      start = 26;\n    }\n\n    return res;\n  };\n\n  Red.prototype.convertTo = function convertTo (num) {\n    var r = num.umod(this.m);\n\n    return r === num ? r.clone() : r;\n  };\n\n  Red.prototype.convertFrom = function convertFrom (num) {\n    var res = num.clone();\n    res.red = null;\n    return res;\n  };\n\n  //\n  // Montgomery method engine\n  //\n\n  BN.mont = function mont (num) {\n    return new Mont(num);\n  };\n\n  function Mont (m) {\n    Red.call(this, m);\n\n    this.shift = this.m.bitLength();\n    if (this.shift % 26 !== 0) {\n      this.shift += 26 - (this.shift % 26);\n    }\n\n    this.r = new BN(1).iushln(this.shift);\n    this.r2 = this.imod(this.r.sqr());\n    this.rinv = this.r._invmp(this.m);\n\n    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);\n    this.minv = this.minv.umod(this.r);\n    this.minv = this.r.sub(this.minv);\n  }\n  inherits(Mont, Red);\n\n  Mont.prototype.convertTo = function convertTo (num) {\n    return this.imod(num.ushln(this.shift));\n  };\n\n  Mont.prototype.convertFrom = function convertFrom (num) {\n    var r = this.imod(num.mul(this.rinv));\n    r.red = null;\n    return r;\n  };\n\n  Mont.prototype.imul = function imul (a, b) {\n    if (a.isZero() || b.isZero()) {\n      a.words[0] = 0;\n      a.length = 1;\n      return a;\n    }\n\n    var t = a.imul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.mul = function mul (a, b) {\n    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);\n\n    var t = a.mul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.invm = function invm (a) {\n    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R\n    var res = this.imod(a._invmp(this.m).mul(this.r2));\n    return res._forceRed(this);\n  };\n})(typeof module === 'undefined' || module, this);","deps":{"buffer":"node_modules/browser-resolve/empty.js"}},{"id":"node_modules/browserify-sign/algos.js","source":"'use strict';\n\nmodule.exports = require('./browser/algorithms.json');","deps":{"./browser/algorithms.json":"node_modules/browserify-sign/browser/algorithms.json"}},{"id":"node_modules/browserify-sign/browser/algorithms.json","source":"module.exports={\n  \"sha224WithRSAEncryption\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"sha224\",\n    \"id\": \"302d300d06096086480165030402040500041c\"\n  },\n  \"RSA-SHA224\": {\n    \"sign\": \"ecdsa/rsa\",\n    \"hash\": \"sha224\",\n    \"id\": \"302d300d06096086480165030402040500041c\"\n  },\n  \"sha256WithRSAEncryption\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"sha256\",\n    \"id\": \"3031300d060960864801650304020105000420\"\n  },\n  \"RSA-SHA256\": {\n    \"sign\": \"ecdsa/rsa\",\n    \"hash\": \"sha256\",\n    \"id\": \"3031300d060960864801650304020105000420\"\n  },\n  \"sha384WithRSAEncryption\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"sha384\",\n    \"id\": \"3041300d060960864801650304020205000430\"\n  },\n  \"RSA-SHA384\": {\n    \"sign\": \"ecdsa/rsa\",\n    \"hash\": \"sha384\",\n    \"id\": \"3041300d060960864801650304020205000430\"\n  },\n  \"sha512WithRSAEncryption\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"sha512\",\n    \"id\": \"3051300d060960864801650304020305000440\"\n  },\n  \"RSA-SHA512\": {\n    \"sign\": \"ecdsa/rsa\",\n    \"hash\": \"sha512\",\n    \"id\": \"3051300d060960864801650304020305000440\"\n  },\n  \"RSA-SHA1\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"sha1\",\n    \"id\": \"3021300906052b0e03021a05000414\"\n  },\n  \"ecdsa-with-SHA1\": {\n    \"sign\": \"ecdsa\",\n    \"hash\": \"sha1\",\n    \"id\": \"\"\n  },\n  \"sha256\": {\n    \"sign\": \"ecdsa\",\n    \"hash\": \"sha256\",\n    \"id\": \"\"\n  },\n  \"sha224\": {\n    \"sign\": \"ecdsa\",\n    \"hash\": \"sha224\",\n    \"id\": \"\"\n  },\n  \"sha384\": {\n    \"sign\": \"ecdsa\",\n    \"hash\": \"sha384\",\n    \"id\": \"\"\n  },\n  \"sha512\": {\n    \"sign\": \"ecdsa\",\n    \"hash\": \"sha512\",\n    \"id\": \"\"\n  },\n  \"DSA-SHA\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha1\",\n    \"id\": \"\"\n  },\n  \"DSA-SHA1\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha1\",\n    \"id\": \"\"\n  },\n  \"DSA\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha1\",\n    \"id\": \"\"\n  },\n  \"DSA-WITH-SHA224\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha224\",\n    \"id\": \"\"\n  },\n  \"DSA-SHA224\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha224\",\n    \"id\": \"\"\n  },\n  \"DSA-WITH-SHA256\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha256\",\n    \"id\": \"\"\n  },\n  \"DSA-SHA256\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha256\",\n    \"id\": \"\"\n  },\n  \"DSA-WITH-SHA384\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha384\",\n    \"id\": \"\"\n  },\n  \"DSA-SHA384\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha384\",\n    \"id\": \"\"\n  },\n  \"DSA-WITH-SHA512\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha512\",\n    \"id\": \"\"\n  },\n  \"DSA-SHA512\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"sha512\",\n    \"id\": \"\"\n  },\n  \"DSA-RIPEMD160\": {\n    \"sign\": \"dsa\",\n    \"hash\": \"rmd160\",\n    \"id\": \"\"\n  },\n  \"ripemd160WithRSA\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"rmd160\",\n    \"id\": \"3021300906052b2403020105000414\"\n  },\n  \"RSA-RIPEMD160\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"rmd160\",\n    \"id\": \"3021300906052b2403020105000414\"\n  },\n  \"md5WithRSAEncryption\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"md5\",\n    \"id\": \"3020300c06082a864886f70d020505000410\"\n  },\n  \"RSA-MD5\": {\n    \"sign\": \"rsa\",\n    \"hash\": \"md5\",\n    \"id\": \"3020300c06082a864886f70d020505000410\"\n  }\n}","deps":{}},{"id":"node_modules/browserify-sign/browser/curves.json","source":"module.exports={\n  \"1.3.132.0.10\": \"secp256k1\",\n  \"1.3.132.0.33\": \"p224\",\n  \"1.2.840.10045.3.1.1\": \"p192\",\n  \"1.2.840.10045.3.1.7\": \"p256\",\n  \"1.3.132.0.34\": \"p384\",\n  \"1.3.132.0.35\": \"p521\"\n}","deps":{}},{"id":"node_modules/browserify-sign/browser/index.js","source":"'use strict';\n\nvar Buffer = require('safe-buffer').Buffer;\nvar createHash = require('create-hash');\nvar stream = require('readable-stream');\nvar inherits = require('inherits');\nvar sign = require('./sign');\nvar verify = require('./verify');\n\nvar algorithms = require('./algorithms.json');\nObject.keys(algorithms).forEach(function (key) {\n  algorithms[key].id = Buffer.from(algorithms[key].id, 'hex');\n  algorithms[key.toLowerCase()] = algorithms[key];\n});\n\nfunction Sign(algorithm) {\n  stream.Writable.call(this);\n\n  var data = algorithms[algorithm];\n  if (!data) { throw new Error('Unknown message digest'); }\n\n  this._hashType = data.hash;\n  this._hash = createHash(data.hash);\n  this._tag = data.id;\n  this._signType = data.sign;\n}\ninherits(Sign, stream.Writable);\n\nSign.prototype._write = function _write(data, _, done) {\n  this._hash.update(data);\n  done();\n};\n\nSign.prototype.update = function update(data, enc) {\n  this._hash.update(typeof data === 'string' ? Buffer.from(data, enc) : data);\n\n  return this;\n};\n\nSign.prototype.sign = function signMethod(key, enc) {\n  this.end();\n  var hash = this._hash.digest();\n  var sig = sign(hash, key, this._hashType, this._signType, this._tag);\n\n  return enc ? sig.toString(enc) : sig;\n};\n\nfunction Verify(algorithm) {\n  stream.Writable.call(this);\n\n  var data = algorithms[algorithm];\n  if (!data) { throw new Error('Unknown message digest'); }\n\n  this._hash = createHash(data.hash);\n  this._tag = data.id;\n  this._signType = data.sign;\n}\ninherits(Verify, stream.Writable);\n\nVerify.prototype._write = function _write(data, _, done) {\n  this._hash.update(data);\n  done();\n};\n\nVerify.prototype.update = function update(data, enc) {\n  this._hash.update(typeof data === 'string' ? Buffer.from(data, enc) : data);\n\n  return this;\n};\n\nVerify.prototype.verify = function verifyMethod(key, sig, enc) {\n  var sigBuffer = typeof sig === 'string' ? Buffer.from(sig, enc) : sig;\n\n  this.end();\n  var hash = this._hash.digest();\n  return verify(sigBuffer, hash, key, this._signType, this._tag);\n};\n\nfunction createSign(algorithm) {\n  return new Sign(algorithm);\n}\n\nfunction createVerify(algorithm) {\n  return new Verify(algorithm);\n}\n\nmodule.exports = {\n  Sign: createSign,\n  Verify: createVerify,\n  createSign: createSign,\n  createVerify: createVerify\n};","deps":{"./algorithms.json":"node_modules/browserify-sign/browser/algorithms.json","./sign":"node_modules/browserify-sign/browser/sign.js","./verify":"node_modules/browserify-sign/browser/verify.js","create-hash":"node_modules/create-hash/browser.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","readable-stream":"node_modules/browserify-sign/node_modules/readable-stream/readable-browser.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-sign/browser/sign.js","source":"'use strict';\n\n// much of this based on https://github.com/indutny/self-signed/blob/gh-pages/lib/rsa.js\nvar Buffer = require('safe-buffer').Buffer;\nvar createHmac = require('create-hmac');\nvar crt = require('browserify-rsa');\nvar EC = require('elliptic').ec;\nvar BN = require('bn.js');\nvar parseKeys = require('parse-asn1');\nvar curves = require('./curves.json');\n\nvar RSA_PKCS1_PADDING = 1;\n\nfunction sign(hash, key, hashType, signType, tag) {\n  var priv = parseKeys(key);\n  if (priv.curve) {\n    // rsa keys can be interpreted as ecdsa ones in openssl\n    if (signType !== 'ecdsa' && signType !== 'ecdsa/rsa') { throw new Error('wrong private key type'); }\n    return ecSign(hash, priv);\n  } else if (priv.type === 'dsa') {\n    if (signType !== 'dsa') { throw new Error('wrong private key type'); }\n    return dsaSign(hash, priv, hashType);\n  }\n  if (signType !== 'rsa' && signType !== 'ecdsa/rsa') { throw new Error('wrong private key type'); }\n  if (key.padding !== undefined && key.padding !== RSA_PKCS1_PADDING) { throw new Error('illegal or unsupported padding mode'); }\n\n  hash = Buffer.concat([tag, hash]);\n  var len = priv.modulus.byteLength();\n  var pad = [0, 1];\n  while (hash.length + pad.length + 1 < len) { pad.push(0xff); }\n  pad.push(0x00);\n  var i = -1;\n  while (++i < hash.length) { pad.push(hash[i]); }\n\n  var out = crt(pad, priv);\n  return out;\n}\n\nfunction ecSign(hash, priv) {\n  var curveId = curves[priv.curve.join('.')];\n  if (!curveId) { throw new Error('unknown curve ' + priv.curve.join('.')); }\n\n  var curve = new EC(curveId);\n  var key = curve.keyFromPrivate(priv.privateKey);\n  var out = key.sign(hash);\n\n  return Buffer.from(out.toDER());\n}\n\nfunction dsaSign(hash, priv, algo) {\n  var x = priv.params.priv_key;\n  var p = priv.params.p;\n  var q = priv.params.q;\n  var g = priv.params.g;\n  var r = new BN(0);\n  var k;\n  var H = bits2int(hash, q).mod(q);\n  var s = false;\n  var kv = getKey(x, q, hash, algo);\n  while (s === false) {\n    k = makeKey(q, kv, algo);\n    r = makeR(g, k, p, q);\n    s = k.invm(q).imul(H.add(x.mul(r))).mod(q);\n    if (s.cmpn(0) === 0) {\n      s = false;\n      r = new BN(0);\n    }\n  }\n  return toDER(r, s);\n}\n\nfunction toDER(r, s) {\n  r = r.toArray();\n  s = s.toArray();\n\n  // Pad values\n  if (r[0] & 0x80) { r = [0].concat(r); }\n  if (s[0] & 0x80) { s = [0].concat(s); }\n\n  var total = r.length + s.length + 4;\n  var res = [\n    0x30, total, 0x02, r.length\n  ];\n  res = res.concat(r, [0x02, s.length], s);\n  return Buffer.from(res);\n}\n\nfunction getKey(x, q, hash, algo) {\n  x = Buffer.from(x.toArray());\n  if (x.length < q.byteLength()) {\n    var zeros = Buffer.alloc(q.byteLength() - x.length);\n    x = Buffer.concat([zeros, x]);\n  }\n  var hlen = hash.length;\n  var hbits = bits2octets(hash, q);\n  var v = Buffer.alloc(hlen);\n  v.fill(1);\n  var k = Buffer.alloc(hlen);\n  k = createHmac(algo, k).update(v).update(Buffer.from([0])).update(x).update(hbits).digest();\n  v = createHmac(algo, k).update(v).digest();\n  k = createHmac(algo, k).update(v).update(Buffer.from([1])).update(x).update(hbits).digest();\n  v = createHmac(algo, k).update(v).digest();\n  return { k: k, v: v };\n}\n\nfunction bits2int(obits, q) {\n  var bits = new BN(obits);\n  var shift = (obits.length << 3) - q.bitLength();\n  if (shift > 0) { bits.ishrn(shift); }\n  return bits;\n}\n\nfunction bits2octets(bits, q) {\n  bits = bits2int(bits, q);\n  bits = bits.mod(q);\n  var out = Buffer.from(bits.toArray());\n  if (out.length < q.byteLength()) {\n    var zeros = Buffer.alloc(q.byteLength() - out.length);\n    out = Buffer.concat([zeros, out]);\n  }\n  return out;\n}\n\nfunction makeKey(q, kv, algo) {\n  var t;\n  var k;\n\n  do {\n    t = Buffer.alloc(0);\n\n    while (t.length * 8 < q.bitLength()) {\n      kv.v = createHmac(algo, kv.k).update(kv.v).digest();\n      t = Buffer.concat([t, kv.v]);\n    }\n\n    k = bits2int(t, q);\n    kv.k = createHmac(algo, kv.k).update(kv.v).update(Buffer.from([0])).digest();\n    kv.v = createHmac(algo, kv.k).update(kv.v).digest();\n  } while (k.cmp(q) !== -1);\n\n  return k;\n}\n\nfunction makeR(g, k, p, q) {\n  return g.toRed(BN.mont(p)).redPow(k).fromRed().mod(q);\n}\n\nmodule.exports = sign;\nmodule.exports.getKey = getKey;\nmodule.exports.makeKey = makeKey;","deps":{"./curves.json":"node_modules/browserify-sign/browser/curves.json","bn.js":"node_modules/browserify-sign/node_modules/bn.js/lib/bn.js","browserify-rsa":"node_modules/browserify-sign/node_modules/browserify-rsa/index.js","create-hmac":"node_modules/browserify-sign/node_modules/create-hmac/browser.js","elliptic":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic.js","parse-asn1":"node_modules/browserify-sign/node_modules/parse-asn1/index.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-sign/browser/verify.js","source":"'use strict';\n\n// much of this based on https://github.com/indutny/self-signed/blob/gh-pages/lib/rsa.js\nvar Buffer = require('safe-buffer').Buffer;\nvar BN = require('bn.js');\nvar EC = require('elliptic').ec;\nvar parseKeys = require('parse-asn1');\nvar curves = require('./curves.json');\n\nfunction verify(sig, hash, key, signType, tag) {\n  var pub = parseKeys(key);\n  if (pub.type === 'ec') {\n    // rsa keys can be interpreted as ecdsa ones in openssl\n    if (signType !== 'ecdsa' && signType !== 'ecdsa/rsa') { throw new Error('wrong public key type'); }\n    return ecVerify(sig, hash, pub);\n  } else if (pub.type === 'dsa') {\n    if (signType !== 'dsa') { throw new Error('wrong public key type'); }\n    return dsaVerify(sig, hash, pub);\n  }\n  if (signType !== 'rsa' && signType !== 'ecdsa/rsa') { throw new Error('wrong public key type'); }\n\n  hash = Buffer.concat([tag, hash]);\n  var len = pub.modulus.byteLength();\n  var pad = [1];\n  var padNum = 0;\n  while (hash.length + pad.length + 2 < len) {\n    pad.push(0xff);\n    padNum += 1;\n  }\n  pad.push(0x00);\n  var i = -1;\n  while (++i < hash.length) {\n    pad.push(hash[i]);\n  }\n  pad = Buffer.from(pad);\n  var red = BN.mont(pub.modulus);\n  sig = new BN(sig).toRed(red);\n\n  sig = sig.redPow(new BN(pub.publicExponent));\n  sig = Buffer.from(sig.fromRed().toArray());\n  var out = padNum < 8 ? 1 : 0;\n  len = Math.min(sig.length, pad.length);\n  if (sig.length !== pad.length) { out = 1; }\n\n  i = -1;\n  while (++i < len) { out |= sig[i] ^ pad[i]; }\n  return out === 0;\n}\n\nfunction ecVerify(sig, hash, pub) {\n  var curveId = curves[pub.data.algorithm.curve.join('.')];\n  if (!curveId) { throw new Error('unknown curve ' + pub.data.algorithm.curve.join('.')); }\n\n  var curve = new EC(curveId);\n  var pubkey = pub.data.subjectPrivateKey.data;\n\n  return curve.verify(hash, sig, pubkey);\n}\n\nfunction dsaVerify(sig, hash, pub) {\n  var p = pub.data.p;\n  var q = pub.data.q;\n  var g = pub.data.g;\n  var y = pub.data.pub_key;\n  var unpacked = parseKeys.signature.decode(sig, 'der');\n  var s = unpacked.s;\n  var r = unpacked.r;\n  checkValue(s, q);\n  checkValue(r, q);\n  var montp = BN.mont(p);\n  var w = s.invm(q);\n  var v = g.toRed(montp)\n    .redPow(new BN(hash).mul(w).mod(q))\n    .fromRed()\n    .mul(y.toRed(montp).redPow(r.mul(w).mod(q)).fromRed())\n    .mod(p)\n    .mod(q);\n  return v.cmp(r) === 0;\n}\n\nfunction checkValue(b, q) {\n  if (b.cmpn(0) <= 0) { throw new Error('invalid sig'); }\n  if (b.cmp(q) >= 0) { throw new Error('invalid sig'); }\n}\n\nmodule.exports = verify;","deps":{"./curves.json":"node_modules/browserify-sign/browser/curves.json","bn.js":"node_modules/browserify-sign/node_modules/bn.js/lib/bn.js","elliptic":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic.js","parse-asn1":"node_modules/browserify-sign/node_modules/parse-asn1/index.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1.js","source":"'use strict';\n\nconst asn1 = exports;\n\nasn1.bignum = require('bn.js');\n\nasn1.define = require('./asn1/api').define;\nasn1.base = require('./asn1/base');\nasn1.constants = require('./asn1/constants');\nasn1.decoders = require('./asn1/decoders');\nasn1.encoders = require('./asn1/encoders');","deps":{"./asn1/api":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/api.js","./asn1/base":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/index.js","./asn1/constants":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/constants/index.js","./asn1/decoders":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/index.js","./asn1/encoders":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/index.js","bn.js":"node_modules/browserify-sign/node_modules/asn1.js/node_modules/bn.js/lib/bn.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/api.js","source":"'use strict';\n\nconst encoders = require('./encoders');\nconst decoders = require('./decoders');\nconst inherits = require('inherits');\n\nconst api = exports;\n\napi.define = function define(name, body) {\n  return new Entity(name, body);\n};\n\nfunction Entity(name, body) {\n  this.name = name;\n  this.body = body;\n\n  this.decoders = {};\n  this.encoders = {};\n}\n\nEntity.prototype._createNamed = function createNamed(Base) {\n  const name = this.name;\n\n  function Generated(entity) {\n    this._initNamed(entity, name);\n  }\n  inherits(Generated, Base);\n  Generated.prototype._initNamed = function _initNamed(entity, name) {\n    Base.call(this, entity, name);\n  };\n\n  return new Generated(this);\n};\n\nEntity.prototype._getDecoder = function _getDecoder(enc) {\n  enc = enc || 'der';\n  // Lazily create decoder\n  if (!this.decoders.hasOwnProperty(enc))\n    this.decoders[enc] = this._createNamed(decoders[enc]);\n  return this.decoders[enc];\n};\n\nEntity.prototype.decode = function decode(data, enc, options) {\n  return this._getDecoder(enc).decode(data, options);\n};\n\nEntity.prototype._getEncoder = function _getEncoder(enc) {\n  enc = enc || 'der';\n  // Lazily create encoder\n  if (!this.encoders.hasOwnProperty(enc))\n    this.encoders[enc] = this._createNamed(encoders[enc]);\n  return this.encoders[enc];\n};\n\nEntity.prototype.encode = function encode(data, enc, /* internal */ reporter) {\n  return this._getEncoder(enc).encode(data, reporter);\n};","deps":{"./decoders":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/index.js","./encoders":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/index.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/buffer.js","source":"'use strict';\n\nconst inherits = require('inherits');\nconst Reporter = require('../base/reporter').Reporter;\nconst Buffer = require('safer-buffer').Buffer;\n\nfunction DecoderBuffer(base, options) {\n  Reporter.call(this, options);\n  if (!Buffer.isBuffer(base)) {\n    this.error('Input not Buffer');\n    return;\n  }\n\n  this.base = base;\n  this.offset = 0;\n  this.length = base.length;\n}\ninherits(DecoderBuffer, Reporter);\nexports.DecoderBuffer = DecoderBuffer;\n\nDecoderBuffer.isDecoderBuffer = function isDecoderBuffer(data) {\n  if (data instanceof DecoderBuffer) {\n    return true;\n  }\n\n  // Or accept compatible API\n  const isCompatible = typeof data === 'object' &&\n    Buffer.isBuffer(data.base) &&\n    data.constructor.name === 'DecoderBuffer' &&\n    typeof data.offset === 'number' &&\n    typeof data.length === 'number' &&\n    typeof data.save === 'function' &&\n    typeof data.restore === 'function' &&\n    typeof data.isEmpty === 'function' &&\n    typeof data.readUInt8 === 'function' &&\n    typeof data.skip === 'function' &&\n    typeof data.raw === 'function';\n\n  return isCompatible;\n};\n\nDecoderBuffer.prototype.save = function save() {\n  return { offset: this.offset, reporter: Reporter.prototype.save.call(this) };\n};\n\nDecoderBuffer.prototype.restore = function restore(save) {\n  // Return skipped data\n  const res = new DecoderBuffer(this.base);\n  res.offset = save.offset;\n  res.length = this.offset;\n\n  this.offset = save.offset;\n  Reporter.prototype.restore.call(this, save.reporter);\n\n  return res;\n};\n\nDecoderBuffer.prototype.isEmpty = function isEmpty() {\n  return this.offset === this.length;\n};\n\nDecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {\n  if (this.offset + 1 <= this.length)\n    return this.base.readUInt8(this.offset++, true);\n  else\n    return this.error(fail || 'DecoderBuffer overrun');\n};\n\nDecoderBuffer.prototype.skip = function skip(bytes, fail) {\n  if (!(this.offset + bytes <= this.length))\n    return this.error(fail || 'DecoderBuffer overrun');\n\n  const res = new DecoderBuffer(this.base);\n\n  // Share reporter state\n  res._reporterState = this._reporterState;\n\n  res.offset = this.offset;\n  res.length = this.offset + bytes;\n  this.offset += bytes;\n  return res;\n};\n\nDecoderBuffer.prototype.raw = function raw(save) {\n  return this.base.slice(save ? save.offset : this.offset, this.length);\n};\n\nfunction EncoderBuffer(value, reporter) {\n  if (Array.isArray(value)) {\n    this.length = 0;\n    this.value = value.map(function(item) {\n      if (!EncoderBuffer.isEncoderBuffer(item))\n        item = new EncoderBuffer(item, reporter);\n      this.length += item.length;\n      return item;\n    }, this);\n  } else if (typeof value === 'number') {\n    if (!(0 <= value && value <= 0xff))\n      return reporter.error('non-byte EncoderBuffer value');\n    this.value = value;\n    this.length = 1;\n  } else if (typeof value === 'string') {\n    this.value = value;\n    this.length = Buffer.byteLength(value);\n  } else if (Buffer.isBuffer(value)) {\n    this.value = value;\n    this.length = value.length;\n  } else {\n    return reporter.error('Unsupported type: ' + typeof value);\n  }\n}\nexports.EncoderBuffer = EncoderBuffer;\n\nEncoderBuffer.isEncoderBuffer = function isEncoderBuffer(data) {\n  if (data instanceof EncoderBuffer) {\n    return true;\n  }\n\n  // Or accept compatible API\n  const isCompatible = typeof data === 'object' &&\n    data.constructor.name === 'EncoderBuffer' &&\n    typeof data.length === 'number' &&\n    typeof data.join === 'function';\n\n  return isCompatible;\n};\n\nEncoderBuffer.prototype.join = function join(out, offset) {\n  if (!out)\n    out = Buffer.alloc(this.length);\n  if (!offset)\n    offset = 0;\n\n  if (this.length === 0)\n    return out;\n\n  if (Array.isArray(this.value)) {\n    this.value.forEach(function(item) {\n      item.join(out, offset);\n      offset += item.length;\n    });\n  } else {\n    if (typeof this.value === 'number')\n      out[offset] = this.value;\n    else if (typeof this.value === 'string')\n      out.write(this.value, offset);\n    else if (Buffer.isBuffer(this.value))\n      this.value.copy(out, offset);\n    offset += this.length;\n  }\n\n  return out;\n};","deps":{"../base/reporter":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/reporter.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","safer-buffer":"node_modules/safer-buffer/safer.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/index.js","source":"'use strict';\n\nconst base = exports;\n\nbase.Reporter = require('./reporter').Reporter;\nbase.DecoderBuffer = require('./buffer').DecoderBuffer;\nbase.EncoderBuffer = require('./buffer').EncoderBuffer;\nbase.Node = require('./node');","deps":{"./buffer":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/buffer.js","./node":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/node.js","./reporter":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/reporter.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/node.js","source":"'use strict';\n\nconst Reporter = require('../base/reporter').Reporter;\nconst EncoderBuffer = require('../base/buffer').EncoderBuffer;\nconst DecoderBuffer = require('../base/buffer').DecoderBuffer;\nconst assert = require('minimalistic-assert');\n\n// Supported tags\nconst tags = [\n  'seq', 'seqof', 'set', 'setof', 'objid', 'bool',\n  'gentime', 'utctime', 'null_', 'enum', 'int', 'objDesc',\n  'bitstr', 'bmpstr', 'charstr', 'genstr', 'graphstr', 'ia5str', 'iso646str',\n  'numstr', 'octstr', 'printstr', 't61str', 'unistr', 'utf8str', 'videostr'\n];\n\n// Public methods list\nconst methods = [\n  'key', 'obj', 'use', 'optional', 'explicit', 'implicit', 'def', 'choice',\n  'any', 'contains'\n].concat(tags);\n\n// Overrided methods list\nconst overrided = [\n  '_peekTag', '_decodeTag', '_use',\n  '_decodeStr', '_decodeObjid', '_decodeTime',\n  '_decodeNull', '_decodeInt', '_decodeBool', '_decodeList',\n\n  '_encodeComposite', '_encodeStr', '_encodeObjid', '_encodeTime',\n  '_encodeNull', '_encodeInt', '_encodeBool'\n];\n\nfunction Node(enc, parent, name) {\n  const state = {};\n  this._baseState = state;\n\n  state.name = name;\n  state.enc = enc;\n\n  state.parent = parent || null;\n  state.children = null;\n\n  // State\n  state.tag = null;\n  state.args = null;\n  state.reverseArgs = null;\n  state.choice = null;\n  state.optional = false;\n  state.any = false;\n  state.obj = false;\n  state.use = null;\n  state.useDecoder = null;\n  state.key = null;\n  state['default'] = null;\n  state.explicit = null;\n  state.implicit = null;\n  state.contains = null;\n\n  // Should create new instance on each method\n  if (!state.parent) {\n    state.children = [];\n    this._wrap();\n  }\n}\nmodule.exports = Node;\n\nconst stateProps = [\n  'enc', 'parent', 'children', 'tag', 'args', 'reverseArgs', 'choice',\n  'optional', 'any', 'obj', 'use', 'alteredUse', 'key', 'default', 'explicit',\n  'implicit', 'contains'\n];\n\nNode.prototype.clone = function clone() {\n  const state = this._baseState;\n  const cstate = {};\n  stateProps.forEach(function(prop) {\n    cstate[prop] = state[prop];\n  });\n  const res = new this.constructor(cstate.parent);\n  res._baseState = cstate;\n  return res;\n};\n\nNode.prototype._wrap = function wrap() {\n  const state = this._baseState;\n  methods.forEach(function(method) {\n    this[method] = function _wrappedMethod() {\n      const clone = new this.constructor(this);\n      state.children.push(clone);\n      return clone[method].apply(clone, arguments);\n    };\n  }, this);\n};\n\nNode.prototype._init = function init(body) {\n  const state = this._baseState;\n\n  assert(state.parent === null);\n  body.call(this);\n\n  // Filter children\n  state.children = state.children.filter(function(child) {\n    return child._baseState.parent === this;\n  }, this);\n  assert.equal(state.children.length, 1, 'Root node can have only one child');\n};\n\nNode.prototype._useArgs = function useArgs(args) {\n  const state = this._baseState;\n\n  // Filter children and args\n  const children = args.filter(function(arg) {\n    return arg instanceof this.constructor;\n  }, this);\n  args = args.filter(function(arg) {\n    return !(arg instanceof this.constructor);\n  }, this);\n\n  if (children.length !== 0) {\n    assert(state.children === null);\n    state.children = children;\n\n    // Replace parent to maintain backward link\n    children.forEach(function(child) {\n      child._baseState.parent = this;\n    }, this);\n  }\n  if (args.length !== 0) {\n    assert(state.args === null);\n    state.args = args;\n    state.reverseArgs = args.map(function(arg) {\n      if (typeof arg !== 'object' || arg.constructor !== Object)\n        return arg;\n\n      const res = {};\n      Object.keys(arg).forEach(function(key) {\n        if (key == (key | 0))\n          key |= 0;\n        const value = arg[key];\n        res[value] = key;\n      });\n      return res;\n    });\n  }\n};\n\n//\n// Overrided methods\n//\n\noverrided.forEach(function(method) {\n  Node.prototype[method] = function _overrided() {\n    const state = this._baseState;\n    throw new Error(method + ' not implemented for encoding: ' + state.enc);\n  };\n});\n\n//\n// Public methods\n//\n\ntags.forEach(function(tag) {\n  Node.prototype[tag] = function _tagMethod() {\n    const state = this._baseState;\n    const args = Array.prototype.slice.call(arguments);\n\n    assert(state.tag === null);\n    state.tag = tag;\n\n    this._useArgs(args);\n\n    return this;\n  };\n});\n\nNode.prototype.use = function use(item) {\n  assert(item);\n  const state = this._baseState;\n\n  assert(state.use === null);\n  state.use = item;\n\n  return this;\n};\n\nNode.prototype.optional = function optional() {\n  const state = this._baseState;\n\n  state.optional = true;\n\n  return this;\n};\n\nNode.prototype.def = function def(val) {\n  const state = this._baseState;\n\n  assert(state['default'] === null);\n  state['default'] = val;\n  state.optional = true;\n\n  return this;\n};\n\nNode.prototype.explicit = function explicit(num) {\n  const state = this._baseState;\n\n  assert(state.explicit === null && state.implicit === null);\n  state.explicit = num;\n\n  return this;\n};\n\nNode.prototype.implicit = function implicit(num) {\n  const state = this._baseState;\n\n  assert(state.explicit === null && state.implicit === null);\n  state.implicit = num;\n\n  return this;\n};\n\nNode.prototype.obj = function obj() {\n  const state = this._baseState;\n  const args = Array.prototype.slice.call(arguments);\n\n  state.obj = true;\n\n  if (args.length !== 0)\n    this._useArgs(args);\n\n  return this;\n};\n\nNode.prototype.key = function key(newKey) {\n  const state = this._baseState;\n\n  assert(state.key === null);\n  state.key = newKey;\n\n  return this;\n};\n\nNode.prototype.any = function any() {\n  const state = this._baseState;\n\n  state.any = true;\n\n  return this;\n};\n\nNode.prototype.choice = function choice(obj) {\n  const state = this._baseState;\n\n  assert(state.choice === null);\n  state.choice = obj;\n  this._useArgs(Object.keys(obj).map(function(key) {\n    return obj[key];\n  }));\n\n  return this;\n};\n\nNode.prototype.contains = function contains(item) {\n  const state = this._baseState;\n\n  assert(state.use === null);\n  state.contains = item;\n\n  return this;\n};\n\n//\n// Decoding\n//\n\nNode.prototype._decode = function decode(input, options) {\n  const state = this._baseState;\n\n  // Decode root node\n  if (state.parent === null)\n    return input.wrapResult(state.children[0]._decode(input, options));\n\n  let result = state['default'];\n  let present = true;\n\n  let prevKey = null;\n  if (state.key !== null)\n    prevKey = input.enterKey(state.key);\n\n  // Check if tag is there\n  if (state.optional) {\n    let tag = null;\n    if (state.explicit !== null)\n      tag = state.explicit;\n    else if (state.implicit !== null)\n      tag = state.implicit;\n    else if (state.tag !== null)\n      tag = state.tag;\n\n    if (tag === null && !state.any) {\n      // Trial and Error\n      const save = input.save();\n      try {\n        if (state.choice === null)\n          this._decodeGeneric(state.tag, input, options);\n        else\n          this._decodeChoice(input, options);\n        present = true;\n      } catch (e) {\n        present = false;\n      }\n      input.restore(save);\n    } else {\n      present = this._peekTag(input, tag, state.any);\n\n      if (input.isError(present))\n        return present;\n    }\n  }\n\n  // Push object on stack\n  let prevObj;\n  if (state.obj && present)\n    prevObj = input.enterObject();\n\n  if (present) {\n    // Unwrap explicit values\n    if (state.explicit !== null) {\n      const explicit = this._decodeTag(input, state.explicit);\n      if (input.isError(explicit))\n        return explicit;\n      input = explicit;\n    }\n\n    const start = input.offset;\n\n    // Unwrap implicit and normal values\n    if (state.use === null && state.choice === null) {\n      let save;\n      if (state.any)\n        save = input.save();\n      const body = this._decodeTag(\n        input,\n        state.implicit !== null ? state.implicit : state.tag,\n        state.any\n      );\n      if (input.isError(body))\n        return body;\n\n      if (state.any)\n        result = input.raw(save);\n      else\n        input = body;\n    }\n\n    if (options && options.track && state.tag !== null)\n      options.track(input.path(), start, input.length, 'tagged');\n\n    if (options && options.track && state.tag !== null)\n      options.track(input.path(), input.offset, input.length, 'content');\n\n    // Select proper method for tag\n    if (state.any) {\n      // no-op\n    } else if (state.choice === null) {\n      result = this._decodeGeneric(state.tag, input, options);\n    } else {\n      result = this._decodeChoice(input, options);\n    }\n\n    if (input.isError(result))\n      return result;\n\n    // Decode children\n    if (!state.any && state.choice === null && state.children !== null) {\n      state.children.forEach(function decodeChildren(child) {\n        // NOTE: We are ignoring errors here, to let parser continue with other\n        // parts of encoded data\n        child._decode(input, options);\n      });\n    }\n\n    // Decode contained/encoded by schema, only in bit or octet strings\n    if (state.contains && (state.tag === 'octstr' || state.tag === 'bitstr')) {\n      const data = new DecoderBuffer(result);\n      result = this._getUse(state.contains, input._reporterState.obj)\n        ._decode(data, options);\n    }\n  }\n\n  // Pop object\n  if (state.obj && present)\n    result = input.leaveObject(prevObj);\n\n  // Set key\n  if (state.key !== null && (result !== null || present === true))\n    input.leaveKey(prevKey, state.key, result);\n  else if (prevKey !== null)\n    input.exitKey(prevKey);\n\n  return result;\n};\n\nNode.prototype._decodeGeneric = function decodeGeneric(tag, input, options) {\n  const state = this._baseState;\n\n  if (tag === 'seq' || tag === 'set')\n    return null;\n  if (tag === 'seqof' || tag === 'setof')\n    return this._decodeList(input, tag, state.args[0], options);\n  else if (/str$/.test(tag))\n    return this._decodeStr(input, tag, options);\n  else if (tag === 'objid' && state.args)\n    return this._decodeObjid(input, state.args[0], state.args[1], options);\n  else if (tag === 'objid')\n    return this._decodeObjid(input, null, null, options);\n  else if (tag === 'gentime' || tag === 'utctime')\n    return this._decodeTime(input, tag, options);\n  else if (tag === 'null_')\n    return this._decodeNull(input, options);\n  else if (tag === 'bool')\n    return this._decodeBool(input, options);\n  else if (tag === 'objDesc')\n    return this._decodeStr(input, tag, options);\n  else if (tag === 'int' || tag === 'enum')\n    return this._decodeInt(input, state.args && state.args[0], options);\n\n  if (state.use !== null) {\n    return this._getUse(state.use, input._reporterState.obj)\n      ._decode(input, options);\n  } else {\n    return input.error('unknown tag: ' + tag);\n  }\n};\n\nNode.prototype._getUse = function _getUse(entity, obj) {\n\n  const state = this._baseState;\n  // Create altered use decoder if implicit is set\n  state.useDecoder = this._use(entity, obj);\n  assert(state.useDecoder._baseState.parent === null);\n  state.useDecoder = state.useDecoder._baseState.children[0];\n  if (state.implicit !== state.useDecoder._baseState.implicit) {\n    state.useDecoder = state.useDecoder.clone();\n    state.useDecoder._baseState.implicit = state.implicit;\n  }\n  return state.useDecoder;\n};\n\nNode.prototype._decodeChoice = function decodeChoice(input, options) {\n  const state = this._baseState;\n  let result = null;\n  let match = false;\n\n  Object.keys(state.choice).some(function(key) {\n    const save = input.save();\n    const node = state.choice[key];\n    try {\n      const value = node._decode(input, options);\n      if (input.isError(value))\n        return false;\n\n      result = { type: key, value: value };\n      match = true;\n    } catch (e) {\n      input.restore(save);\n      return false;\n    }\n    return true;\n  }, this);\n\n  if (!match)\n    return input.error('Choice not matched');\n\n  return result;\n};\n\n//\n// Encoding\n//\n\nNode.prototype._createEncoderBuffer = function createEncoderBuffer(data) {\n  return new EncoderBuffer(data, this.reporter);\n};\n\nNode.prototype._encode = function encode(data, reporter, parent) {\n  const state = this._baseState;\n  if (state['default'] !== null && state['default'] === data)\n    return;\n\n  const result = this._encodeValue(data, reporter, parent);\n  if (result === undefined)\n    return;\n\n  if (this._skipDefault(result, reporter, parent))\n    return;\n\n  return result;\n};\n\nNode.prototype._encodeValue = function encode(data, reporter, parent) {\n  const state = this._baseState;\n\n  // Decode root node\n  if (state.parent === null)\n    return state.children[0]._encode(data, reporter || new Reporter());\n\n  let result = null;\n\n  // Set reporter to share it with a child class\n  this.reporter = reporter;\n\n  // Check if data is there\n  if (state.optional && data === undefined) {\n    if (state['default'] !== null)\n      data = state['default'];\n    else\n      return;\n  }\n\n  // Encode children first\n  let content = null;\n  let primitive = false;\n  if (state.any) {\n    // Anything that was given is translated to buffer\n    result = this._createEncoderBuffer(data);\n  } else if (state.choice) {\n    result = this._encodeChoice(data, reporter);\n  } else if (state.contains) {\n    content = this._getUse(state.contains, parent)._encode(data, reporter);\n    primitive = true;\n  } else if (state.children) {\n    content = state.children.map(function(child) {\n      if (child._baseState.tag === 'null_')\n        return child._encode(null, reporter, data);\n\n      if (child._baseState.key === null)\n        return reporter.error('Child should have a key');\n      const prevKey = reporter.enterKey(child._baseState.key);\n\n      if (typeof data !== 'object')\n        return reporter.error('Child expected, but input is not object');\n\n      const res = child._encode(data[child._baseState.key], reporter, data);\n      reporter.leaveKey(prevKey);\n\n      return res;\n    }, this).filter(function(child) {\n      return child;\n    });\n    content = this._createEncoderBuffer(content);\n  } else {\n    if (state.tag === 'seqof' || state.tag === 'setof') {\n      // TODO(indutny): this should be thrown on DSL level\n      if (!(state.args && state.args.length === 1))\n        return reporter.error('Too many args for : ' + state.tag);\n\n      if (!Array.isArray(data))\n        return reporter.error('seqof/setof, but data is not Array');\n\n      const child = this.clone();\n      child._baseState.implicit = null;\n      content = this._createEncoderBuffer(data.map(function(item) {\n        const state = this._baseState;\n\n        return this._getUse(state.args[0], data)._encode(item, reporter);\n      }, child));\n    } else if (state.use !== null) {\n      result = this._getUse(state.use, parent)._encode(data, reporter);\n    } else {\n      content = this._encodePrimitive(state.tag, data);\n      primitive = true;\n    }\n  }\n\n  // Encode data itself\n  if (!state.any && state.choice === null) {\n    const tag = state.implicit !== null ? state.implicit : state.tag;\n    const cls = state.implicit === null ? 'universal' : 'context';\n\n    if (tag === null) {\n      if (state.use === null)\n        reporter.error('Tag could be omitted only for .use()');\n    } else {\n      if (state.use === null)\n        result = this._encodeComposite(tag, primitive, cls, content);\n    }\n  }\n\n  // Wrap in explicit\n  if (state.explicit !== null)\n    result = this._encodeComposite(state.explicit, false, 'context', result);\n\n  return result;\n};\n\nNode.prototype._encodeChoice = function encodeChoice(data, reporter) {\n  const state = this._baseState;\n\n  const node = state.choice[data.type];\n  if (!node) {\n    assert(\n      false,\n      data.type + ' not found in ' +\n            JSON.stringify(Object.keys(state.choice)));\n  }\n  return node._encode(data.value, reporter);\n};\n\nNode.prototype._encodePrimitive = function encodePrimitive(tag, data) {\n  const state = this._baseState;\n\n  if (/str$/.test(tag))\n    return this._encodeStr(data, tag);\n  else if (tag === 'objid' && state.args)\n    return this._encodeObjid(data, state.reverseArgs[0], state.args[1]);\n  else if (tag === 'objid')\n    return this._encodeObjid(data, null, null);\n  else if (tag === 'gentime' || tag === 'utctime')\n    return this._encodeTime(data, tag);\n  else if (tag === 'null_')\n    return this._encodeNull();\n  else if (tag === 'int' || tag === 'enum')\n    return this._encodeInt(data, state.args && state.reverseArgs[0]);\n  else if (tag === 'bool')\n    return this._encodeBool(data);\n  else if (tag === 'objDesc')\n    return this._encodeStr(data, tag);\n  else\n    throw new Error('Unsupported tag: ' + tag);\n};\n\nNode.prototype._isNumstr = function isNumstr(str) {\n  return /^[0-9 ]*$/.test(str);\n};\n\nNode.prototype._isPrintstr = function isPrintstr(str) {\n  return /^[A-Za-z0-9 '()+,-./:=?]*$/.test(str);\n};","deps":{"../base/buffer":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/buffer.js","../base/reporter":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/reporter.js","minimalistic-assert":"node_modules/minimalistic-assert/index.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/reporter.js","source":"'use strict';\n\nconst inherits = require('inherits');\n\nfunction Reporter(options) {\n  this._reporterState = {\n    obj: null,\n    path: [],\n    options: options || {},\n    errors: []\n  };\n}\nexports.Reporter = Reporter;\n\nReporter.prototype.isError = function isError(obj) {\n  return obj instanceof ReporterError;\n};\n\nReporter.prototype.save = function save() {\n  const state = this._reporterState;\n\n  return { obj: state.obj, pathLen: state.path.length };\n};\n\nReporter.prototype.restore = function restore(data) {\n  const state = this._reporterState;\n\n  state.obj = data.obj;\n  state.path = state.path.slice(0, data.pathLen);\n};\n\nReporter.prototype.enterKey = function enterKey(key) {\n  return this._reporterState.path.push(key);\n};\n\nReporter.prototype.exitKey = function exitKey(index) {\n  const state = this._reporterState;\n\n  state.path = state.path.slice(0, index - 1);\n};\n\nReporter.prototype.leaveKey = function leaveKey(index, key, value) {\n  const state = this._reporterState;\n\n  this.exitKey(index);\n  if (state.obj !== null)\n    state.obj[key] = value;\n};\n\nReporter.prototype.path = function path() {\n  return this._reporterState.path.join('/');\n};\n\nReporter.prototype.enterObject = function enterObject() {\n  const state = this._reporterState;\n\n  const prev = state.obj;\n  state.obj = {};\n  return prev;\n};\n\nReporter.prototype.leaveObject = function leaveObject(prev) {\n  const state = this._reporterState;\n\n  const now = state.obj;\n  state.obj = prev;\n  return now;\n};\n\nReporter.prototype.error = function error(msg) {\n  let err;\n  const state = this._reporterState;\n\n  const inherited = msg instanceof ReporterError;\n  if (inherited) {\n    err = msg;\n  } else {\n    err = new ReporterError(state.path.map(function(elem) {\n      return '[' + JSON.stringify(elem) + ']';\n    }).join(''), msg.message || msg, msg.stack);\n  }\n\n  if (!state.options.partial)\n    throw err;\n\n  if (!inherited)\n    state.errors.push(err);\n\n  return err;\n};\n\nReporter.prototype.wrapResult = function wrapResult(result) {\n  const state = this._reporterState;\n  if (!state.options.partial)\n    return result;\n\n  return {\n    result: this.isError(result) ? null : result,\n    errors: state.errors\n  };\n};\n\nfunction ReporterError(path, msg) {\n  this.path = path;\n  this.rethrow(msg);\n}\ninherits(ReporterError, Error);\n\nReporterError.prototype.rethrow = function rethrow(msg) {\n  this.message = msg + ' at: ' + (this.path || '(shallow)');\n  if (Error.captureStackTrace)\n    Error.captureStackTrace(this, ReporterError);\n\n  if (!this.stack) {\n    try {\n      // IE only adds stack when thrown\n      throw new Error(this.message);\n    } catch (e) {\n      this.stack = e.stack;\n    }\n  }\n  return this;\n};","deps":{"inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/constants/der.js","source":"'use strict';\n\n// Helper\nfunction reverse(map) {\n  const res = {};\n\n  Object.keys(map).forEach(function(key) {\n    // Convert key to integer if it is stringified\n    if ((key | 0) == key)\n      key = key | 0;\n\n    const value = map[key];\n    res[value] = key;\n  });\n\n  return res;\n}\n\nexports.tagClass = {\n  0: 'universal',\n  1: 'application',\n  2: 'context',\n  3: 'private'\n};\nexports.tagClassByName = reverse(exports.tagClass);\n\nexports.tag = {\n  0x00: 'end',\n  0x01: 'bool',\n  0x02: 'int',\n  0x03: 'bitstr',\n  0x04: 'octstr',\n  0x05: 'null_',\n  0x06: 'objid',\n  0x07: 'objDesc',\n  0x08: 'external',\n  0x09: 'real',\n  0x0a: 'enum',\n  0x0b: 'embed',\n  0x0c: 'utf8str',\n  0x0d: 'relativeOid',\n  0x10: 'seq',\n  0x11: 'set',\n  0x12: 'numstr',\n  0x13: 'printstr',\n  0x14: 't61str',\n  0x15: 'videostr',\n  0x16: 'ia5str',\n  0x17: 'utctime',\n  0x18: 'gentime',\n  0x19: 'graphstr',\n  0x1a: 'iso646str',\n  0x1b: 'genstr',\n  0x1c: 'unistr',\n  0x1d: 'charstr',\n  0x1e: 'bmpstr'\n};\nexports.tagByName = reverse(exports.tag);","deps":{}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/constants/index.js","source":"'use strict';\n\nconst constants = exports;\n\n// Helper\nconstants._reverse = function reverse(map) {\n  const res = {};\n\n  Object.keys(map).forEach(function(key) {\n    // Convert key to integer if it is stringified\n    if ((key | 0) == key)\n      key = key | 0;\n\n    const value = map[key];\n    res[value] = key;\n  });\n\n  return res;\n};\n\nconstants.der = require('./der');","deps":{"./der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/constants/der.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/der.js","source":"'use strict';\n\nconst inherits = require('inherits');\n\nconst bignum = require('bn.js');\nconst DecoderBuffer = require('../base/buffer').DecoderBuffer;\nconst Node = require('../base/node');\n\n// Import DER constants\nconst der = require('../constants/der');\n\nfunction DERDecoder(entity) {\n  this.enc = 'der';\n  this.name = entity.name;\n  this.entity = entity;\n\n  // Construct base tree\n  this.tree = new DERNode();\n  this.tree._init(entity.body);\n}\nmodule.exports = DERDecoder;\n\nDERDecoder.prototype.decode = function decode(data, options) {\n  if (!DecoderBuffer.isDecoderBuffer(data)) {\n    data = new DecoderBuffer(data, options);\n  }\n\n  return this.tree._decode(data, options);\n};\n\n// Tree methods\n\nfunction DERNode(parent) {\n  Node.call(this, 'der', parent);\n}\ninherits(DERNode, Node);\n\nDERNode.prototype._peekTag = function peekTag(buffer, tag, any) {\n  if (buffer.isEmpty())\n    return false;\n\n  const state = buffer.save();\n  const decodedTag = derDecodeTag(buffer, 'Failed to peek tag: \"' + tag + '\"');\n  if (buffer.isError(decodedTag))\n    return decodedTag;\n\n  buffer.restore(state);\n\n  return decodedTag.tag === tag || decodedTag.tagStr === tag ||\n    (decodedTag.tagStr + 'of') === tag || any;\n};\n\nDERNode.prototype._decodeTag = function decodeTag(buffer, tag, any) {\n  const decodedTag = derDecodeTag(buffer,\n    'Failed to decode tag of \"' + tag + '\"');\n  if (buffer.isError(decodedTag))\n    return decodedTag;\n\n  let len = derDecodeLen(buffer,\n    decodedTag.primitive,\n    'Failed to get length of \"' + tag + '\"');\n\n  // Failure\n  if (buffer.isError(len))\n    return len;\n\n  if (!any &&\n      decodedTag.tag !== tag &&\n      decodedTag.tagStr !== tag &&\n      decodedTag.tagStr + 'of' !== tag) {\n    return buffer.error('Failed to match tag: \"' + tag + '\"');\n  }\n\n  if (decodedTag.primitive || len !== null)\n    return buffer.skip(len, 'Failed to match body of: \"' + tag + '\"');\n\n  // Indefinite length... find END tag\n  const state = buffer.save();\n  const res = this._skipUntilEnd(\n    buffer,\n    'Failed to skip indefinite length body: \"' + this.tag + '\"');\n  if (buffer.isError(res))\n    return res;\n\n  len = buffer.offset - state.offset;\n  buffer.restore(state);\n  return buffer.skip(len, 'Failed to match body of: \"' + tag + '\"');\n};\n\nDERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer, fail) {\n  for (;;) {\n    const tag = derDecodeTag(buffer, fail);\n    if (buffer.isError(tag))\n      return tag;\n    const len = derDecodeLen(buffer, tag.primitive, fail);\n    if (buffer.isError(len))\n      return len;\n\n    let res;\n    if (tag.primitive || len !== null)\n      res = buffer.skip(len);\n    else\n      res = this._skipUntilEnd(buffer, fail);\n\n    // Failure\n    if (buffer.isError(res))\n      return res;\n\n    if (tag.tagStr === 'end')\n      break;\n  }\n};\n\nDERNode.prototype._decodeList = function decodeList(buffer, tag, decoder,\n  options) {\n  const result = [];\n  while (!buffer.isEmpty()) {\n    const possibleEnd = this._peekTag(buffer, 'end');\n    if (buffer.isError(possibleEnd))\n      return possibleEnd;\n\n    const res = decoder.decode(buffer, 'der', options);\n    if (buffer.isError(res) && possibleEnd)\n      break;\n    result.push(res);\n  }\n  return result;\n};\n\nDERNode.prototype._decodeStr = function decodeStr(buffer, tag) {\n  if (tag === 'bitstr') {\n    const unused = buffer.readUInt8();\n    if (buffer.isError(unused))\n      return unused;\n    return { unused: unused, data: buffer.raw() };\n  } else if (tag === 'bmpstr') {\n    const raw = buffer.raw();\n    if (raw.length % 2 === 1)\n      return buffer.error('Decoding of string type: bmpstr length mismatch');\n\n    let str = '';\n    for (let i = 0; i < raw.length / 2; i++) {\n      str += String.fromCharCode(raw.readUInt16BE(i * 2));\n    }\n    return str;\n  } else if (tag === 'numstr') {\n    const numstr = buffer.raw().toString('ascii');\n    if (!this._isNumstr(numstr)) {\n      return buffer.error('Decoding of string type: ' +\n                          'numstr unsupported characters');\n    }\n    return numstr;\n  } else if (tag === 'octstr') {\n    return buffer.raw();\n  } else if (tag === 'objDesc') {\n    return buffer.raw();\n  } else if (tag === 'printstr') {\n    const printstr = buffer.raw().toString('ascii');\n    if (!this._isPrintstr(printstr)) {\n      return buffer.error('Decoding of string type: ' +\n                          'printstr unsupported characters');\n    }\n    return printstr;\n  } else if (/str$/.test(tag)) {\n    return buffer.raw().toString();\n  } else {\n    return buffer.error('Decoding of string type: ' + tag + ' unsupported');\n  }\n};\n\nDERNode.prototype._decodeObjid = function decodeObjid(buffer, values, relative) {\n  let result;\n  const identifiers = [];\n  let ident = 0;\n  let subident = 0;\n  while (!buffer.isEmpty()) {\n    subident = buffer.readUInt8();\n    ident <<= 7;\n    ident |= subident & 0x7f;\n    if ((subident & 0x80) === 0) {\n      identifiers.push(ident);\n      ident = 0;\n    }\n  }\n  if (subident & 0x80)\n    identifiers.push(ident);\n\n  const first = (identifiers[0] / 40) | 0;\n  const second = identifiers[0] % 40;\n\n  if (relative)\n    result = identifiers;\n  else\n    result = [first, second].concat(identifiers.slice(1));\n\n  if (values) {\n    let tmp = values[result.join(' ')];\n    if (tmp === undefined)\n      tmp = values[result.join('.')];\n    if (tmp !== undefined)\n      result = tmp;\n  }\n\n  return result;\n};\n\nDERNode.prototype._decodeTime = function decodeTime(buffer, tag) {\n  const str = buffer.raw().toString();\n\n  let year;\n  let mon;\n  let day;\n  let hour;\n  let min;\n  let sec;\n  if (tag === 'gentime') {\n    year = str.slice(0, 4) | 0;\n    mon = str.slice(4, 6) | 0;\n    day = str.slice(6, 8) | 0;\n    hour = str.slice(8, 10) | 0;\n    min = str.slice(10, 12) | 0;\n    sec = str.slice(12, 14) | 0;\n  } else if (tag === 'utctime') {\n    year = str.slice(0, 2) | 0;\n    mon = str.slice(2, 4) | 0;\n    day = str.slice(4, 6) | 0;\n    hour = str.slice(6, 8) | 0;\n    min = str.slice(8, 10) | 0;\n    sec = str.slice(10, 12) | 0;\n    if (year < 70)\n      year = 2000 + year;\n    else\n      year = 1900 + year;\n  } else {\n    return buffer.error('Decoding ' + tag + ' time is not supported yet');\n  }\n\n  return Date.UTC(year, mon - 1, day, hour, min, sec, 0);\n};\n\nDERNode.prototype._decodeNull = function decodeNull() {\n  return null;\n};\n\nDERNode.prototype._decodeBool = function decodeBool(buffer) {\n  const res = buffer.readUInt8();\n  if (buffer.isError(res))\n    return res;\n  else\n    return res !== 0;\n};\n\nDERNode.prototype._decodeInt = function decodeInt(buffer, values) {\n  // Bigint, return as it is (assume big endian)\n  const raw = buffer.raw();\n  let res = new bignum(raw);\n\n  if (values)\n    res = values[res.toString(10)] || res;\n\n  return res;\n};\n\nDERNode.prototype._use = function use(entity, obj) {\n  if (typeof entity === 'function')\n    entity = entity(obj);\n  return entity._getDecoder('der').tree;\n};\n\n// Utility methods\n\nfunction derDecodeTag(buf, fail) {\n  let tag = buf.readUInt8(fail);\n  if (buf.isError(tag))\n    return tag;\n\n  const cls = der.tagClass[tag >> 6];\n  const primitive = (tag & 0x20) === 0;\n\n  // Multi-octet tag - load\n  if ((tag & 0x1f) === 0x1f) {\n    let oct = tag;\n    tag = 0;\n    while ((oct & 0x80) === 0x80) {\n      oct = buf.readUInt8(fail);\n      if (buf.isError(oct))\n        return oct;\n\n      tag <<= 7;\n      tag |= oct & 0x7f;\n    }\n  } else {\n    tag &= 0x1f;\n  }\n  const tagStr = der.tag[tag];\n\n  return {\n    cls: cls,\n    primitive: primitive,\n    tag: tag,\n    tagStr: tagStr\n  };\n}\n\nfunction derDecodeLen(buf, primitive, fail) {\n  let len = buf.readUInt8(fail);\n  if (buf.isError(len))\n    return len;\n\n  // Indefinite form\n  if (!primitive && len === 0x80)\n    return null;\n\n  // Definite form\n  if ((len & 0x80) === 0) {\n    // Short form\n    return len;\n  }\n\n  // Long form\n  const num = len & 0x7f;\n  if (num > 4)\n    return buf.error('length octect is too long');\n\n  len = 0;\n  for (let i = 0; i < num; i++) {\n    len <<= 8;\n    const j = buf.readUInt8(fail);\n    if (buf.isError(j))\n      return j;\n    len |= j;\n  }\n\n  return len;\n}","deps":{"../base/buffer":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/buffer.js","../base/node":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/node.js","../constants/der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/constants/der.js","bn.js":"node_modules/browserify-sign/node_modules/asn1.js/node_modules/bn.js/lib/bn.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/index.js","source":"'use strict';\n\nconst decoders = exports;\n\ndecoders.der = require('./der');\ndecoders.pem = require('./pem');","deps":{"./der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/der.js","./pem":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/pem.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/pem.js","source":"'use strict';\n\nconst inherits = require('inherits');\nconst Buffer = require('safer-buffer').Buffer;\n\nconst DERDecoder = require('./der');\n\nfunction PEMDecoder(entity) {\n  DERDecoder.call(this, entity);\n  this.enc = 'pem';\n}\ninherits(PEMDecoder, DERDecoder);\nmodule.exports = PEMDecoder;\n\nPEMDecoder.prototype.decode = function decode(data, options) {\n  const lines = data.toString().split(/[\\r\\n]+/g);\n\n  const label = options.label.toUpperCase();\n\n  const re = /^-----(BEGIN|END) ([^-]+)-----$/;\n  let start = -1;\n  let end = -1;\n  for (let i = 0; i < lines.length; i++) {\n    const match = lines[i].match(re);\n    if (match === null)\n      continue;\n\n    if (match[2] !== label)\n      continue;\n\n    if (start === -1) {\n      if (match[1] !== 'BEGIN')\n        break;\n      start = i;\n    } else {\n      if (match[1] !== 'END')\n        break;\n      end = i;\n      break;\n    }\n  }\n  if (start === -1 || end === -1)\n    throw new Error('PEM section not found for: ' + label);\n\n  const base64 = lines.slice(start + 1, end).join('');\n  // Remove excessive symbols\n  base64.replace(/[^a-z0-9+/=]+/gi, '');\n\n  const input = Buffer.from(base64, 'base64');\n  return DERDecoder.prototype.decode.call(this, input, options);\n};","deps":{"./der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/decoders/der.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","safer-buffer":"node_modules/safer-buffer/safer.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/der.js","source":"'use strict';\n\nconst inherits = require('inherits');\nconst Buffer = require('safer-buffer').Buffer;\nconst Node = require('../base/node');\n\n// Import DER constants\nconst der = require('../constants/der');\n\nfunction DEREncoder(entity) {\n  this.enc = 'der';\n  this.name = entity.name;\n  this.entity = entity;\n\n  // Construct base tree\n  this.tree = new DERNode();\n  this.tree._init(entity.body);\n}\nmodule.exports = DEREncoder;\n\nDEREncoder.prototype.encode = function encode(data, reporter) {\n  return this.tree._encode(data, reporter).join();\n};\n\n// Tree methods\n\nfunction DERNode(parent) {\n  Node.call(this, 'der', parent);\n}\ninherits(DERNode, Node);\n\nDERNode.prototype._encodeComposite = function encodeComposite(tag,\n  primitive,\n  cls,\n  content) {\n  const encodedTag = encodeTag(tag, primitive, cls, this.reporter);\n\n  // Short form\n  if (content.length < 0x80) {\n    const header = Buffer.alloc(2);\n    header[0] = encodedTag;\n    header[1] = content.length;\n    return this._createEncoderBuffer([ header, content ]);\n  }\n\n  // Long form\n  // Count octets required to store length\n  let lenOctets = 1;\n  for (let i = content.length; i >= 0x100; i >>= 8)\n    lenOctets++;\n\n  const header = Buffer.alloc(1 + 1 + lenOctets);\n  header[0] = encodedTag;\n  header[1] = 0x80 | lenOctets;\n\n  for (let i = 1 + lenOctets, j = content.length; j > 0; i--, j >>= 8)\n    header[i] = j & 0xff;\n\n  return this._createEncoderBuffer([ header, content ]);\n};\n\nDERNode.prototype._encodeStr = function encodeStr(str, tag) {\n  if (tag === 'bitstr') {\n    return this._createEncoderBuffer([ str.unused | 0, str.data ]);\n  } else if (tag === 'bmpstr') {\n    const buf = Buffer.alloc(str.length * 2);\n    for (let i = 0; i < str.length; i++) {\n      buf.writeUInt16BE(str.charCodeAt(i), i * 2);\n    }\n    return this._createEncoderBuffer(buf);\n  } else if (tag === 'numstr') {\n    if (!this._isNumstr(str)) {\n      return this.reporter.error('Encoding of string type: numstr supports ' +\n                                 'only digits and space');\n    }\n    return this._createEncoderBuffer(str);\n  } else if (tag === 'printstr') {\n    if (!this._isPrintstr(str)) {\n      return this.reporter.error('Encoding of string type: printstr supports ' +\n                                 'only latin upper and lower case letters, ' +\n                                 'digits, space, apostrophe, left and rigth ' +\n                                 'parenthesis, plus sign, comma, hyphen, ' +\n                                 'dot, slash, colon, equal sign, ' +\n                                 'question mark');\n    }\n    return this._createEncoderBuffer(str);\n  } else if (/str$/.test(tag)) {\n    return this._createEncoderBuffer(str);\n  } else if (tag === 'objDesc') {\n    return this._createEncoderBuffer(str);\n  } else {\n    return this.reporter.error('Encoding of string type: ' + tag +\n                               ' unsupported');\n  }\n};\n\nDERNode.prototype._encodeObjid = function encodeObjid(id, values, relative) {\n  if (typeof id === 'string') {\n    if (!values)\n      return this.reporter.error('string objid given, but no values map found');\n    if (!values.hasOwnProperty(id))\n      return this.reporter.error('objid not found in values map');\n    id = values[id].split(/[\\s.]+/g);\n    for (let i = 0; i < id.length; i++)\n      id[i] |= 0;\n  } else if (Array.isArray(id)) {\n    id = id.slice();\n    for (let i = 0; i < id.length; i++)\n      id[i] |= 0;\n  }\n\n  if (!Array.isArray(id)) {\n    return this.reporter.error('objid() should be either array or string, ' +\n                               'got: ' + JSON.stringify(id));\n  }\n\n  if (!relative) {\n    if (id[1] >= 40)\n      return this.reporter.error('Second objid identifier OOB');\n    id.splice(0, 2, id[0] * 40 + id[1]);\n  }\n\n  // Count number of octets\n  let size = 0;\n  for (let i = 0; i < id.length; i++) {\n    let ident = id[i];\n    for (size++; ident >= 0x80; ident >>= 7)\n      size++;\n  }\n\n  const objid = Buffer.alloc(size);\n  let offset = objid.length - 1;\n  for (let i = id.length - 1; i >= 0; i--) {\n    let ident = id[i];\n    objid[offset--] = ident & 0x7f;\n    while ((ident >>= 7) > 0)\n      objid[offset--] = 0x80 | (ident & 0x7f);\n  }\n\n  return this._createEncoderBuffer(objid);\n};\n\nfunction two(num) {\n  if (num < 10)\n    return '0' + num;\n  else\n    return num;\n}\n\nDERNode.prototype._encodeTime = function encodeTime(time, tag) {\n  let str;\n  const date = new Date(time);\n\n  if (tag === 'gentime') {\n    str = [\n      two(date.getUTCFullYear()),\n      two(date.getUTCMonth() + 1),\n      two(date.getUTCDate()),\n      two(date.getUTCHours()),\n      two(date.getUTCMinutes()),\n      two(date.getUTCSeconds()),\n      'Z'\n    ].join('');\n  } else if (tag === 'utctime') {\n    str = [\n      two(date.getUTCFullYear() % 100),\n      two(date.getUTCMonth() + 1),\n      two(date.getUTCDate()),\n      two(date.getUTCHours()),\n      two(date.getUTCMinutes()),\n      two(date.getUTCSeconds()),\n      'Z'\n    ].join('');\n  } else {\n    this.reporter.error('Encoding ' + tag + ' time is not supported yet');\n  }\n\n  return this._encodeStr(str, 'octstr');\n};\n\nDERNode.prototype._encodeNull = function encodeNull() {\n  return this._createEncoderBuffer('');\n};\n\nDERNode.prototype._encodeInt = function encodeInt(num, values) {\n  if (typeof num === 'string') {\n    if (!values)\n      return this.reporter.error('String int or enum given, but no values map');\n    if (!values.hasOwnProperty(num)) {\n      return this.reporter.error('Values map doesn\\'t contain: ' +\n                                 JSON.stringify(num));\n    }\n    num = values[num];\n  }\n\n  // Bignum, assume big endian\n  if (typeof num !== 'number' && !Buffer.isBuffer(num)) {\n    const numArray = num.toArray();\n    if (!num.sign && numArray[0] & 0x80) {\n      numArray.unshift(0);\n    }\n    num = Buffer.from(numArray);\n  }\n\n  if (Buffer.isBuffer(num)) {\n    let size = num.length;\n    if (num.length === 0)\n      size++;\n\n    const out = Buffer.alloc(size);\n    num.copy(out);\n    if (num.length === 0)\n      out[0] = 0;\n    return this._createEncoderBuffer(out);\n  }\n\n  if (num < 0x80)\n    return this._createEncoderBuffer(num);\n\n  if (num < 0x100)\n    return this._createEncoderBuffer([0, num]);\n\n  let size = 1;\n  for (let i = num; i >= 0x100; i >>= 8)\n    size++;\n\n  const out = new Array(size);\n  for (let i = out.length - 1; i >= 0; i--) {\n    out[i] = num & 0xff;\n    num >>= 8;\n  }\n  if(out[0] & 0x80) {\n    out.unshift(0);\n  }\n\n  return this._createEncoderBuffer(Buffer.from(out));\n};\n\nDERNode.prototype._encodeBool = function encodeBool(value) {\n  return this._createEncoderBuffer(value ? 0xff : 0);\n};\n\nDERNode.prototype._use = function use(entity, obj) {\n  if (typeof entity === 'function')\n    entity = entity(obj);\n  return entity._getEncoder('der').tree;\n};\n\nDERNode.prototype._skipDefault = function skipDefault(dataBuffer, reporter, parent) {\n  const state = this._baseState;\n  let i;\n  if (state['default'] === null)\n    return false;\n\n  const data = dataBuffer.join();\n  if (state.defaultBuffer === undefined)\n    state.defaultBuffer = this._encodeValue(state['default'], reporter, parent).join();\n\n  if (data.length !== state.defaultBuffer.length)\n    return false;\n\n  for (i=0; i < data.length; i++)\n    if (data[i] !== state.defaultBuffer[i])\n      return false;\n\n  return true;\n};\n\n// Utility methods\n\nfunction encodeTag(tag, primitive, cls, reporter) {\n  let res;\n\n  if (tag === 'seqof')\n    tag = 'seq';\n  else if (tag === 'setof')\n    tag = 'set';\n\n  if (der.tagByName.hasOwnProperty(tag))\n    res = der.tagByName[tag];\n  else if (typeof tag === 'number' && (tag | 0) === tag)\n    res = tag;\n  else\n    return reporter.error('Unknown tag: ' + tag);\n\n  if (res >= 0x1f)\n    return reporter.error('Multi-octet tag encoding unsupported');\n\n  if (!primitive)\n    res |= 0x20;\n\n  res |= (der.tagClassByName[cls || 'universal'] << 6);\n\n  return res;\n}","deps":{"../base/node":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/base/node.js","../constants/der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/constants/der.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","safer-buffer":"node_modules/safer-buffer/safer.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/index.js","source":"'use strict';\n\nconst encoders = exports;\n\nencoders.der = require('./der');\nencoders.pem = require('./pem');","deps":{"./der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/der.js","./pem":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/pem.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/pem.js","source":"'use strict';\n\nconst inherits = require('inherits');\n\nconst DEREncoder = require('./der');\n\nfunction PEMEncoder(entity) {\n  DEREncoder.call(this, entity);\n  this.enc = 'pem';\n}\ninherits(PEMEncoder, DEREncoder);\nmodule.exports = PEMEncoder;\n\nPEMEncoder.prototype.encode = function encode(data, options) {\n  const buf = DEREncoder.prototype.encode.call(this, data);\n\n  const p = buf.toString('base64');\n  const out = [ '-----BEGIN ' + options.label + '-----' ];\n  for (let i = 0; i < p.length; i += 64)\n    out.push(p.slice(i, i + 64));\n  out.push('-----END ' + options.label + '-----');\n  return out.join('\\n');\n};","deps":{"./der":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1/encoders/der.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/asn1.js/node_modules/bn.js/lib/bn.js","source":"(function (module, exports) {\n  'use strict';\n\n  // Utils\n  function assert (val, msg) {\n    if (!val) throw new Error(msg || 'Assertion failed');\n  }\n\n  // Could use `inherits` module, but don't want to move from single file\n  // architecture yet.\n  function inherits (ctor, superCtor) {\n    ctor.super_ = superCtor;\n    var TempCtor = function () {};\n    TempCtor.prototype = superCtor.prototype;\n    ctor.prototype = new TempCtor();\n    ctor.prototype.constructor = ctor;\n  }\n\n  // BN\n\n  function BN (number, base, endian) {\n    if (BN.isBN(number)) {\n      return number;\n    }\n\n    this.negative = 0;\n    this.words = null;\n    this.length = 0;\n\n    // Reduction context\n    this.red = null;\n\n    if (number !== null) {\n      if (base === 'le' || base === 'be') {\n        endian = base;\n        base = 10;\n      }\n\n      this._init(number || 0, base || 10, endian || 'be');\n    }\n  }\n  if (typeof module === 'object') {\n    module.exports = BN;\n  } else {\n    exports.BN = BN;\n  }\n\n  BN.BN = BN;\n  BN.wordSize = 26;\n\n  var Buffer;\n  try {\n    if (typeof window !== 'undefined' && typeof window.Buffer !== 'undefined') {\n      Buffer = window.Buffer;\n    } else {\n      Buffer = require('buffer').Buffer;\n    }\n  } catch (e) {\n  }\n\n  BN.isBN = function isBN (num) {\n    if (num instanceof BN) {\n      return true;\n    }\n\n    return num !== null && typeof num === 'object' &&\n      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);\n  };\n\n  BN.max = function max (left, right) {\n    if (left.cmp(right) > 0) return left;\n    return right;\n  };\n\n  BN.min = function min (left, right) {\n    if (left.cmp(right) < 0) return left;\n    return right;\n  };\n\n  BN.prototype._init = function init (number, base, endian) {\n    if (typeof number === 'number') {\n      return this._initNumber(number, base, endian);\n    }\n\n    if (typeof number === 'object') {\n      return this._initArray(number, base, endian);\n    }\n\n    if (base === 'hex') {\n      base = 16;\n    }\n    assert(base === (base | 0) && base >= 2 && base <= 36);\n\n    number = number.toString().replace(/\\s+/g, '');\n    var start = 0;\n    if (number[0] === '-') {\n      start++;\n      this.negative = 1;\n    }\n\n    if (start < number.length) {\n      if (base === 16) {\n        this._parseHex(number, start, endian);\n      } else {\n        this._parseBase(number, base, start);\n        if (endian === 'le') {\n          this._initArray(this.toArray(), base, endian);\n        }\n      }\n    }\n  };\n\n  BN.prototype._initNumber = function _initNumber (number, base, endian) {\n    if (number < 0) {\n      this.negative = 1;\n      number = -number;\n    }\n    if (number < 0x4000000) {\n      this.words = [ number & 0x3ffffff ];\n      this.length = 1;\n    } else if (number < 0x10000000000000) {\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff\n      ];\n      this.length = 2;\n    } else {\n      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff,\n        1\n      ];\n      this.length = 3;\n    }\n\n    if (endian !== 'le') return;\n\n    // Reverse the bytes\n    this._initArray(this.toArray(), base, endian);\n  };\n\n  BN.prototype._initArray = function _initArray (number, base, endian) {\n    // Perhaps a Uint8Array\n    assert(typeof number.length === 'number');\n    if (number.length <= 0) {\n      this.words = [ 0 ];\n      this.length = 1;\n      return this;\n    }\n\n    this.length = Math.ceil(number.length / 3);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    var j, w;\n    var off = 0;\n    if (endian === 'be') {\n      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {\n        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    } else if (endian === 'le') {\n      for (i = 0, j = 0; i < number.length; i += 3) {\n        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    }\n    return this.strip();\n  };\n\n  function parseHex4Bits (string, index) {\n    var c = string.charCodeAt(index);\n    // 'A' - 'F'\n    if (c >= 65 && c <= 70) {\n      return c - 55;\n    // 'a' - 'f'\n    } else if (c >= 97 && c <= 102) {\n      return c - 87;\n    // '0' - '9'\n    } else {\n      return (c - 48) & 0xf;\n    }\n  }\n\n  function parseHexByte (string, lowerBound, index) {\n    var r = parseHex4Bits(string, index);\n    if (index - 1 >= lowerBound) {\n      r |= parseHex4Bits(string, index - 1) << 4;\n    }\n    return r;\n  }\n\n  BN.prototype._parseHex = function _parseHex (number, start, endian) {\n    // Create possibly bigger array to ensure that it fits the number\n    this.length = Math.ceil((number.length - start) / 6);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    // 24-bits chunks\n    var off = 0;\n    var j = 0;\n\n    var w;\n    if (endian === 'be') {\n      for (i = number.length - 1; i >= start; i -= 2) {\n        w = parseHexByte(number, start, i) << off;\n        this.words[j] |= w & 0x3ffffff;\n        if (off >= 18) {\n          off -= 18;\n          j += 1;\n          this.words[j] |= w >>> 26;\n        } else {\n          off += 8;\n        }\n      }\n    } else {\n      var parseLength = number.length - start;\n      for (i = parseLength % 2 === 0 ? start + 1 : start; i < number.length; i += 2) {\n        w = parseHexByte(number, start, i) << off;\n        this.words[j] |= w & 0x3ffffff;\n        if (off >= 18) {\n          off -= 18;\n          j += 1;\n          this.words[j] |= w >>> 26;\n        } else {\n          off += 8;\n        }\n      }\n    }\n\n    this.strip();\n  };\n\n  function parseBase (str, start, end, mul) {\n    var r = 0;\n    var len = Math.min(str.length, end);\n    for (var i = start; i < len; i++) {\n      var c = str.charCodeAt(i) - 48;\n\n      r *= mul;\n\n      // 'a'\n      if (c >= 49) {\n        r += c - 49 + 0xa;\n\n      // 'A'\n      } else if (c >= 17) {\n        r += c - 17 + 0xa;\n\n      // '0' - '9'\n      } else {\n        r += c;\n      }\n    }\n    return r;\n  }\n\n  BN.prototype._parseBase = function _parseBase (number, base, start) {\n    // Initialize as zero\n    this.words = [ 0 ];\n    this.length = 1;\n\n    // Find length of limb in base\n    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {\n      limbLen++;\n    }\n    limbLen--;\n    limbPow = (limbPow / base) | 0;\n\n    var total = number.length - start;\n    var mod = total % limbLen;\n    var end = Math.min(total, total - mod) + start;\n\n    var word = 0;\n    for (var i = start; i < end; i += limbLen) {\n      word = parseBase(number, i, i + limbLen, base);\n\n      this.imuln(limbPow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n\n    if (mod !== 0) {\n      var pow = 1;\n      word = parseBase(number, i, number.length, base);\n\n      for (i = 0; i < mod; i++) {\n        pow *= base;\n      }\n\n      this.imuln(pow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n\n    this.strip();\n  };\n\n  BN.prototype.copy = function copy (dest) {\n    dest.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      dest.words[i] = this.words[i];\n    }\n    dest.length = this.length;\n    dest.negative = this.negative;\n    dest.red = this.red;\n  };\n\n  BN.prototype.clone = function clone () {\n    var r = new BN(null);\n    this.copy(r);\n    return r;\n  };\n\n  BN.prototype._expand = function _expand (size) {\n    while (this.length < size) {\n      this.words[this.length++] = 0;\n    }\n    return this;\n  };\n\n  // Remove leading `0` from `this`\n  BN.prototype.strip = function strip () {\n    while (this.length > 1 && this.words[this.length - 1] === 0) {\n      this.length--;\n    }\n    return this._normSign();\n  };\n\n  BN.prototype._normSign = function _normSign () {\n    // -0 = 0\n    if (this.length === 1 && this.words[0] === 0) {\n      this.negative = 0;\n    }\n    return this;\n  };\n\n  BN.prototype.inspect = function inspect () {\n    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';\n  };\n\n  /*\n\n  var zeros = [];\n  var groupSizes = [];\n  var groupBases = [];\n\n  var s = '';\n  var i = -1;\n  while (++i < BN.wordSize) {\n    zeros[i] = s;\n    s += '0';\n  }\n  groupSizes[0] = 0;\n  groupSizes[1] = 0;\n  groupBases[0] = 0;\n  groupBases[1] = 0;\n  var base = 2 - 1;\n  while (++base < 36 + 1) {\n    var groupSize = 0;\n    var groupBase = 1;\n    while (groupBase < (1 << BN.wordSize) / base) {\n      groupBase *= base;\n      groupSize += 1;\n    }\n    groupSizes[base] = groupSize;\n    groupBases[base] = groupBase;\n  }\n\n  */\n\n  var zeros = [\n    '',\n    '0',\n    '00',\n    '000',\n    '0000',\n    '00000',\n    '000000',\n    '0000000',\n    '00000000',\n    '000000000',\n    '0000000000',\n    '00000000000',\n    '000000000000',\n    '0000000000000',\n    '00000000000000',\n    '000000000000000',\n    '0000000000000000',\n    '00000000000000000',\n    '000000000000000000',\n    '0000000000000000000',\n    '00000000000000000000',\n    '000000000000000000000',\n    '0000000000000000000000',\n    '00000000000000000000000',\n    '000000000000000000000000',\n    '0000000000000000000000000'\n  ];\n\n  var groupSizes = [\n    0, 0,\n    25, 16, 12, 11, 10, 9, 8,\n    8, 7, 7, 7, 7, 6, 6,\n    6, 6, 6, 6, 6, 5, 5,\n    5, 5, 5, 5, 5, 5, 5,\n    5, 5, 5, 5, 5, 5, 5\n  ];\n\n  var groupBases = [\n    0, 0,\n    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,\n    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,\n    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,\n    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,\n    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176\n  ];\n\n  BN.prototype.toString = function toString (base, padding) {\n    base = base || 10;\n    padding = padding | 0 || 1;\n\n    var out;\n    if (base === 16 || base === 'hex') {\n      out = '';\n      var off = 0;\n      var carry = 0;\n      for (var i = 0; i < this.length; i++) {\n        var w = this.words[i];\n        var word = (((w << off) | carry) & 0xffffff).toString(16);\n        carry = (w >>> (24 - off)) & 0xffffff;\n        if (carry !== 0 || i !== this.length - 1) {\n          out = zeros[6 - word.length] + word + out;\n        } else {\n          out = word + out;\n        }\n        off += 2;\n        if (off >= 26) {\n          off -= 26;\n          i--;\n        }\n      }\n      if (carry !== 0) {\n        out = carry.toString(16) + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    if (base === (base | 0) && base >= 2 && base <= 36) {\n      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));\n      var groupSize = groupSizes[base];\n      // var groupBase = Math.pow(base, groupSize);\n      var groupBase = groupBases[base];\n      out = '';\n      var c = this.clone();\n      c.negative = 0;\n      while (!c.isZero()) {\n        var r = c.modn(groupBase).toString(base);\n        c = c.idivn(groupBase);\n\n        if (!c.isZero()) {\n          out = zeros[groupSize - r.length] + r + out;\n        } else {\n          out = r + out;\n        }\n      }\n      if (this.isZero()) {\n        out = '0' + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    assert(false, 'Base should be between 2 and 36');\n  };\n\n  BN.prototype.toNumber = function toNumber () {\n    var ret = this.words[0];\n    if (this.length === 2) {\n      ret += this.words[1] * 0x4000000;\n    } else if (this.length === 3 && this.words[2] === 0x01) {\n      // NOTE: at this stage it is known that the top bit is set\n      ret += 0x10000000000000 + (this.words[1] * 0x4000000);\n    } else if (this.length > 2) {\n      assert(false, 'Number can only safely store up to 53 bits');\n    }\n    return (this.negative !== 0) ? -ret : ret;\n  };\n\n  BN.prototype.toJSON = function toJSON () {\n    return this.toString(16);\n  };\n\n  BN.prototype.toBuffer = function toBuffer (endian, length) {\n    assert(typeof Buffer !== 'undefined');\n    return this.toArrayLike(Buffer, endian, length);\n  };\n\n  BN.prototype.toArray = function toArray (endian, length) {\n    return this.toArrayLike(Array, endian, length);\n  };\n\n  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {\n    var byteLength = this.byteLength();\n    var reqLength = length || Math.max(1, byteLength);\n    assert(byteLength <= reqLength, 'byte array longer than desired length');\n    assert(reqLength > 0, 'Requested array length <= 0');\n\n    this.strip();\n    var littleEndian = endian === 'le';\n    var res = new ArrayType(reqLength);\n\n    var b, i;\n    var q = this.clone();\n    if (!littleEndian) {\n      // Assume big-endian\n      for (i = 0; i < reqLength - byteLength; i++) {\n        res[i] = 0;\n      }\n\n      for (i = 0; !q.isZero(); i++) {\n        b = q.andln(0xff);\n        q.iushrn(8);\n\n        res[reqLength - i - 1] = b;\n      }\n    } else {\n      for (i = 0; !q.isZero(); i++) {\n        b = q.andln(0xff);\n        q.iushrn(8);\n\n        res[i] = b;\n      }\n\n      for (; i < reqLength; i++) {\n        res[i] = 0;\n      }\n    }\n\n    return res;\n  };\n\n  if (Math.clz32) {\n    BN.prototype._countBits = function _countBits (w) {\n      return 32 - Math.clz32(w);\n    };\n  } else {\n    BN.prototype._countBits = function _countBits (w) {\n      var t = w;\n      var r = 0;\n      if (t >= 0x1000) {\n        r += 13;\n        t >>>= 13;\n      }\n      if (t >= 0x40) {\n        r += 7;\n        t >>>= 7;\n      }\n      if (t >= 0x8) {\n        r += 4;\n        t >>>= 4;\n      }\n      if (t >= 0x02) {\n        r += 2;\n        t >>>= 2;\n      }\n      return r + t;\n    };\n  }\n\n  BN.prototype._zeroBits = function _zeroBits (w) {\n    // Short-cut\n    if (w === 0) return 26;\n\n    var t = w;\n    var r = 0;\n    if ((t & 0x1fff) === 0) {\n      r += 13;\n      t >>>= 13;\n    }\n    if ((t & 0x7f) === 0) {\n      r += 7;\n      t >>>= 7;\n    }\n    if ((t & 0xf) === 0) {\n      r += 4;\n      t >>>= 4;\n    }\n    if ((t & 0x3) === 0) {\n      r += 2;\n      t >>>= 2;\n    }\n    if ((t & 0x1) === 0) {\n      r++;\n    }\n    return r;\n  };\n\n  // Return number of used bits in a BN\n  BN.prototype.bitLength = function bitLength () {\n    var w = this.words[this.length - 1];\n    var hi = this._countBits(w);\n    return (this.length - 1) * 26 + hi;\n  };\n\n  function toBitArray (num) {\n    var w = new Array(num.bitLength());\n\n    for (var bit = 0; bit < w.length; bit++) {\n      var off = (bit / 26) | 0;\n      var wbit = bit % 26;\n\n      w[bit] = (num.words[off] & (1 << wbit)) >>> wbit;\n    }\n\n    return w;\n  }\n\n  // Number of trailing zero bits\n  BN.prototype.zeroBits = function zeroBits () {\n    if (this.isZero()) return 0;\n\n    var r = 0;\n    for (var i = 0; i < this.length; i++) {\n      var b = this._zeroBits(this.words[i]);\n      r += b;\n      if (b !== 26) break;\n    }\n    return r;\n  };\n\n  BN.prototype.byteLength = function byteLength () {\n    return Math.ceil(this.bitLength() / 8);\n  };\n\n  BN.prototype.toTwos = function toTwos (width) {\n    if (this.negative !== 0) {\n      return this.abs().inotn(width).iaddn(1);\n    }\n    return this.clone();\n  };\n\n  BN.prototype.fromTwos = function fromTwos (width) {\n    if (this.testn(width - 1)) {\n      return this.notn(width).iaddn(1).ineg();\n    }\n    return this.clone();\n  };\n\n  BN.prototype.isNeg = function isNeg () {\n    return this.negative !== 0;\n  };\n\n  // Return negative clone of `this`\n  BN.prototype.neg = function neg () {\n    return this.clone().ineg();\n  };\n\n  BN.prototype.ineg = function ineg () {\n    if (!this.isZero()) {\n      this.negative ^= 1;\n    }\n\n    return this;\n  };\n\n  // Or `num` with `this` in-place\n  BN.prototype.iuor = function iuor (num) {\n    while (this.length < num.length) {\n      this.words[this.length++] = 0;\n    }\n\n    for (var i = 0; i < num.length; i++) {\n      this.words[i] = this.words[i] | num.words[i];\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ior = function ior (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuor(num);\n  };\n\n  // Or `num` with `this`\n  BN.prototype.or = function or (num) {\n    if (this.length > num.length) return this.clone().ior(num);\n    return num.clone().ior(this);\n  };\n\n  BN.prototype.uor = function uor (num) {\n    if (this.length > num.length) return this.clone().iuor(num);\n    return num.clone().iuor(this);\n  };\n\n  // And `num` with `this` in-place\n  BN.prototype.iuand = function iuand (num) {\n    // b = min-length(num, this)\n    var b;\n    if (this.length > num.length) {\n      b = num;\n    } else {\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = this.words[i] & num.words[i];\n    }\n\n    this.length = b.length;\n\n    return this.strip();\n  };\n\n  BN.prototype.iand = function iand (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuand(num);\n  };\n\n  // And `num` with `this`\n  BN.prototype.and = function and (num) {\n    if (this.length > num.length) return this.clone().iand(num);\n    return num.clone().iand(this);\n  };\n\n  BN.prototype.uand = function uand (num) {\n    if (this.length > num.length) return this.clone().iuand(num);\n    return num.clone().iuand(this);\n  };\n\n  // Xor `num` with `this` in-place\n  BN.prototype.iuxor = function iuxor (num) {\n    // a.length > b.length\n    var a;\n    var b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = a.words[i] ^ b.words[i];\n    }\n\n    if (this !== a) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = a.length;\n\n    return this.strip();\n  };\n\n  BN.prototype.ixor = function ixor (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuxor(num);\n  };\n\n  // Xor `num` with `this`\n  BN.prototype.xor = function xor (num) {\n    if (this.length > num.length) return this.clone().ixor(num);\n    return num.clone().ixor(this);\n  };\n\n  BN.prototype.uxor = function uxor (num) {\n    if (this.length > num.length) return this.clone().iuxor(num);\n    return num.clone().iuxor(this);\n  };\n\n  // Not ``this`` with ``width`` bitwidth\n  BN.prototype.inotn = function inotn (width) {\n    assert(typeof width === 'number' && width >= 0);\n\n    var bytesNeeded = Math.ceil(width / 26) | 0;\n    var bitsLeft = width % 26;\n\n    // Extend the buffer with leading zeroes\n    this._expand(bytesNeeded);\n\n    if (bitsLeft > 0) {\n      bytesNeeded--;\n    }\n\n    // Handle complete words\n    for (var i = 0; i < bytesNeeded; i++) {\n      this.words[i] = ~this.words[i] & 0x3ffffff;\n    }\n\n    // Handle the residue\n    if (bitsLeft > 0) {\n      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));\n    }\n\n    // And remove leading zeroes\n    return this.strip();\n  };\n\n  BN.prototype.notn = function notn (width) {\n    return this.clone().inotn(width);\n  };\n\n  // Set `bit` of `this`\n  BN.prototype.setn = function setn (bit, val) {\n    assert(typeof bit === 'number' && bit >= 0);\n\n    var off = (bit / 26) | 0;\n    var wbit = bit % 26;\n\n    this._expand(off + 1);\n\n    if (val) {\n      this.words[off] = this.words[off] | (1 << wbit);\n    } else {\n      this.words[off] = this.words[off] & ~(1 << wbit);\n    }\n\n    return this.strip();\n  };\n\n  // Add `num` to `this` in-place\n  BN.prototype.iadd = function iadd (num) {\n    var r;\n\n    // negative + positive\n    if (this.negative !== 0 && num.negative === 0) {\n      this.negative = 0;\n      r = this.isub(num);\n      this.negative ^= 1;\n      return this._normSign();\n\n    // positive + negative\n    } else if (this.negative === 0 && num.negative !== 0) {\n      num.negative = 0;\n      r = this.isub(num);\n      num.negative = 1;\n      return r._normSign();\n    }\n\n    // a.length > b.length\n    var a, b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n\n    this.length = a.length;\n    if (carry !== 0) {\n      this.words[this.length] = carry;\n      this.length++;\n    // Copy the rest of the words\n    } else if (a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    return this;\n  };\n\n  // Add `num` to `this`\n  BN.prototype.add = function add (num) {\n    var res;\n    if (num.negative !== 0 && this.negative === 0) {\n      num.negative = 0;\n      res = this.sub(num);\n      num.negative ^= 1;\n      return res;\n    } else if (num.negative === 0 && this.negative !== 0) {\n      this.negative = 0;\n      res = num.sub(this);\n      this.negative = 1;\n      return res;\n    }\n\n    if (this.length > num.length) return this.clone().iadd(num);\n\n    return num.clone().iadd(this);\n  };\n\n  // Subtract `num` from `this` in-place\n  BN.prototype.isub = function isub (num) {\n    // this - (-num) = this + num\n    if (num.negative !== 0) {\n      num.negative = 0;\n      var r = this.iadd(num);\n      num.negative = 1;\n      return r._normSign();\n\n    // -this - num = -(this + num)\n    } else if (this.negative !== 0) {\n      this.negative = 0;\n      this.iadd(num);\n      this.negative = 1;\n      return this._normSign();\n    }\n\n    // At this point both numbers are positive\n    var cmp = this.cmp(num);\n\n    // Optimization - zeroify\n    if (cmp === 0) {\n      this.negative = 0;\n      this.length = 1;\n      this.words[0] = 0;\n      return this;\n    }\n\n    // a > b\n    var a, b;\n    if (cmp > 0) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n\n    // Copy rest of the words\n    if (carry === 0 && i < a.length && a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = Math.max(this.length, i);\n\n    if (a !== this) {\n      this.negative = 1;\n    }\n\n    return this.strip();\n  };\n\n  // Subtract `num` from `this`\n  BN.prototype.sub = function sub (num) {\n    return this.clone().isub(num);\n  };\n\n  function smallMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    var len = (self.length + num.length) | 0;\n    out.length = len;\n    len = (len - 1) | 0;\n\n    // Peel one iteration (compiler can't do it, because of code complexity)\n    var a = self.words[0] | 0;\n    var b = num.words[0] | 0;\n    var r = a * b;\n\n    var lo = r & 0x3ffffff;\n    var carry = (r / 0x4000000) | 0;\n    out.words[0] = lo;\n\n    for (var k = 1; k < len; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = carry >>> 26;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = (k - j) | 0;\n        a = self.words[i] | 0;\n        b = num.words[j] | 0;\n        r = a * b + rword;\n        ncarry += (r / 0x4000000) | 0;\n        rword = r & 0x3ffffff;\n      }\n      out.words[k] = rword | 0;\n      carry = ncarry | 0;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry | 0;\n    } else {\n      out.length--;\n    }\n\n    return out.strip();\n  }\n\n  // TODO(indutny): it may be reasonable to omit it for users who don't need\n  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit\n  // multiplication (like elliptic secp256k1).\n  var comb10MulTo = function comb10MulTo (self, num, out) {\n    var a = self.words;\n    var b = num.words;\n    var o = out.words;\n    var c = 0;\n    var lo;\n    var mid;\n    var hi;\n    var a0 = a[0] | 0;\n    var al0 = a0 & 0x1fff;\n    var ah0 = a0 >>> 13;\n    var a1 = a[1] | 0;\n    var al1 = a1 & 0x1fff;\n    var ah1 = a1 >>> 13;\n    var a2 = a[2] | 0;\n    var al2 = a2 & 0x1fff;\n    var ah2 = a2 >>> 13;\n    var a3 = a[3] | 0;\n    var al3 = a3 & 0x1fff;\n    var ah3 = a3 >>> 13;\n    var a4 = a[4] | 0;\n    var al4 = a4 & 0x1fff;\n    var ah4 = a4 >>> 13;\n    var a5 = a[5] | 0;\n    var al5 = a5 & 0x1fff;\n    var ah5 = a5 >>> 13;\n    var a6 = a[6] | 0;\n    var al6 = a6 & 0x1fff;\n    var ah6 = a6 >>> 13;\n    var a7 = a[7] | 0;\n    var al7 = a7 & 0x1fff;\n    var ah7 = a7 >>> 13;\n    var a8 = a[8] | 0;\n    var al8 = a8 & 0x1fff;\n    var ah8 = a8 >>> 13;\n    var a9 = a[9] | 0;\n    var al9 = a9 & 0x1fff;\n    var ah9 = a9 >>> 13;\n    var b0 = b[0] | 0;\n    var bl0 = b0 & 0x1fff;\n    var bh0 = b0 >>> 13;\n    var b1 = b[1] | 0;\n    var bl1 = b1 & 0x1fff;\n    var bh1 = b1 >>> 13;\n    var b2 = b[2] | 0;\n    var bl2 = b2 & 0x1fff;\n    var bh2 = b2 >>> 13;\n    var b3 = b[3] | 0;\n    var bl3 = b3 & 0x1fff;\n    var bh3 = b3 >>> 13;\n    var b4 = b[4] | 0;\n    var bl4 = b4 & 0x1fff;\n    var bh4 = b4 >>> 13;\n    var b5 = b[5] | 0;\n    var bl5 = b5 & 0x1fff;\n    var bh5 = b5 >>> 13;\n    var b6 = b[6] | 0;\n    var bl6 = b6 & 0x1fff;\n    var bh6 = b6 >>> 13;\n    var b7 = b[7] | 0;\n    var bl7 = b7 & 0x1fff;\n    var bh7 = b7 >>> 13;\n    var b8 = b[8] | 0;\n    var bl8 = b8 & 0x1fff;\n    var bh8 = b8 >>> 13;\n    var b9 = b[9] | 0;\n    var bl9 = b9 & 0x1fff;\n    var bh9 = b9 >>> 13;\n\n    out.negative = self.negative ^ num.negative;\n    out.length = 19;\n    /* k = 0 */\n    lo = Math.imul(al0, bl0);\n    mid = Math.imul(al0, bh0);\n    mid = (mid + Math.imul(ah0, bl0)) | 0;\n    hi = Math.imul(ah0, bh0);\n    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;\n    w0 &= 0x3ffffff;\n    /* k = 1 */\n    lo = Math.imul(al1, bl0);\n    mid = Math.imul(al1, bh0);\n    mid = (mid + Math.imul(ah1, bl0)) | 0;\n    hi = Math.imul(ah1, bh0);\n    lo = (lo + Math.imul(al0, bl1)) | 0;\n    mid = (mid + Math.imul(al0, bh1)) | 0;\n    mid = (mid + Math.imul(ah0, bl1)) | 0;\n    hi = (hi + Math.imul(ah0, bh1)) | 0;\n    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;\n    w1 &= 0x3ffffff;\n    /* k = 2 */\n    lo = Math.imul(al2, bl0);\n    mid = Math.imul(al2, bh0);\n    mid = (mid + Math.imul(ah2, bl0)) | 0;\n    hi = Math.imul(ah2, bh0);\n    lo = (lo + Math.imul(al1, bl1)) | 0;\n    mid = (mid + Math.imul(al1, bh1)) | 0;\n    mid = (mid + Math.imul(ah1, bl1)) | 0;\n    hi = (hi + Math.imul(ah1, bh1)) | 0;\n    lo = (lo + Math.imul(al0, bl2)) | 0;\n    mid = (mid + Math.imul(al0, bh2)) | 0;\n    mid = (mid + Math.imul(ah0, bl2)) | 0;\n    hi = (hi + Math.imul(ah0, bh2)) | 0;\n    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;\n    w2 &= 0x3ffffff;\n    /* k = 3 */\n    lo = Math.imul(al3, bl0);\n    mid = Math.imul(al3, bh0);\n    mid = (mid + Math.imul(ah3, bl0)) | 0;\n    hi = Math.imul(ah3, bh0);\n    lo = (lo + Math.imul(al2, bl1)) | 0;\n    mid = (mid + Math.imul(al2, bh1)) | 0;\n    mid = (mid + Math.imul(ah2, bl1)) | 0;\n    hi = (hi + Math.imul(ah2, bh1)) | 0;\n    lo = (lo + Math.imul(al1, bl2)) | 0;\n    mid = (mid + Math.imul(al1, bh2)) | 0;\n    mid = (mid + Math.imul(ah1, bl2)) | 0;\n    hi = (hi + Math.imul(ah1, bh2)) | 0;\n    lo = (lo + Math.imul(al0, bl3)) | 0;\n    mid = (mid + Math.imul(al0, bh3)) | 0;\n    mid = (mid + Math.imul(ah0, bl3)) | 0;\n    hi = (hi + Math.imul(ah0, bh3)) | 0;\n    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;\n    w3 &= 0x3ffffff;\n    /* k = 4 */\n    lo = Math.imul(al4, bl0);\n    mid = Math.imul(al4, bh0);\n    mid = (mid + Math.imul(ah4, bl0)) | 0;\n    hi = Math.imul(ah4, bh0);\n    lo = (lo + Math.imul(al3, bl1)) | 0;\n    mid = (mid + Math.imul(al3, bh1)) | 0;\n    mid = (mid + Math.imul(ah3, bl1)) | 0;\n    hi = (hi + Math.imul(ah3, bh1)) | 0;\n    lo = (lo + Math.imul(al2, bl2)) | 0;\n    mid = (mid + Math.imul(al2, bh2)) | 0;\n    mid = (mid + Math.imul(ah2, bl2)) | 0;\n    hi = (hi + Math.imul(ah2, bh2)) | 0;\n    lo = (lo + Math.imul(al1, bl3)) | 0;\n    mid = (mid + Math.imul(al1, bh3)) | 0;\n    mid = (mid + Math.imul(ah1, bl3)) | 0;\n    hi = (hi + Math.imul(ah1, bh3)) | 0;\n    lo = (lo + Math.imul(al0, bl4)) | 0;\n    mid = (mid + Math.imul(al0, bh4)) | 0;\n    mid = (mid + Math.imul(ah0, bl4)) | 0;\n    hi = (hi + Math.imul(ah0, bh4)) | 0;\n    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;\n    w4 &= 0x3ffffff;\n    /* k = 5 */\n    lo = Math.imul(al5, bl0);\n    mid = Math.imul(al5, bh0);\n    mid = (mid + Math.imul(ah5, bl0)) | 0;\n    hi = Math.imul(ah5, bh0);\n    lo = (lo + Math.imul(al4, bl1)) | 0;\n    mid = (mid + Math.imul(al4, bh1)) | 0;\n    mid = (mid + Math.imul(ah4, bl1)) | 0;\n    hi = (hi + Math.imul(ah4, bh1)) | 0;\n    lo = (lo + Math.imul(al3, bl2)) | 0;\n    mid = (mid + Math.imul(al3, bh2)) | 0;\n    mid = (mid + Math.imul(ah3, bl2)) | 0;\n    hi = (hi + Math.imul(ah3, bh2)) | 0;\n    lo = (lo + Math.imul(al2, bl3)) | 0;\n    mid = (mid + Math.imul(al2, bh3)) | 0;\n    mid = (mid + Math.imul(ah2, bl3)) | 0;\n    hi = (hi + Math.imul(ah2, bh3)) | 0;\n    lo = (lo + Math.imul(al1, bl4)) | 0;\n    mid = (mid + Math.imul(al1, bh4)) | 0;\n    mid = (mid + Math.imul(ah1, bl4)) | 0;\n    hi = (hi + Math.imul(ah1, bh4)) | 0;\n    lo = (lo + Math.imul(al0, bl5)) | 0;\n    mid = (mid + Math.imul(al0, bh5)) | 0;\n    mid = (mid + Math.imul(ah0, bl5)) | 0;\n    hi = (hi + Math.imul(ah0, bh5)) | 0;\n    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;\n    w5 &= 0x3ffffff;\n    /* k = 6 */\n    lo = Math.imul(al6, bl0);\n    mid = Math.imul(al6, bh0);\n    mid = (mid + Math.imul(ah6, bl0)) | 0;\n    hi = Math.imul(ah6, bh0);\n    lo = (lo + Math.imul(al5, bl1)) | 0;\n    mid = (mid + Math.imul(al5, bh1)) | 0;\n    mid = (mid + Math.imul(ah5, bl1)) | 0;\n    hi = (hi + Math.imul(ah5, bh1)) | 0;\n    lo = (lo + Math.imul(al4, bl2)) | 0;\n    mid = (mid + Math.imul(al4, bh2)) | 0;\n    mid = (mid + Math.imul(ah4, bl2)) | 0;\n    hi = (hi + Math.imul(ah4, bh2)) | 0;\n    lo = (lo + Math.imul(al3, bl3)) | 0;\n    mid = (mid + Math.imul(al3, bh3)) | 0;\n    mid = (mid + Math.imul(ah3, bl3)) | 0;\n    hi = (hi + Math.imul(ah3, bh3)) | 0;\n    lo = (lo + Math.imul(al2, bl4)) | 0;\n    mid = (mid + Math.imul(al2, bh4)) | 0;\n    mid = (mid + Math.imul(ah2, bl4)) | 0;\n    hi = (hi + Math.imul(ah2, bh4)) | 0;\n    lo = (lo + Math.imul(al1, bl5)) | 0;\n    mid = (mid + Math.imul(al1, bh5)) | 0;\n    mid = (mid + Math.imul(ah1, bl5)) | 0;\n    hi = (hi + Math.imul(ah1, bh5)) | 0;\n    lo = (lo + Math.imul(al0, bl6)) | 0;\n    mid = (mid + Math.imul(al0, bh6)) | 0;\n    mid = (mid + Math.imul(ah0, bl6)) | 0;\n    hi = (hi + Math.imul(ah0, bh6)) | 0;\n    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;\n    w6 &= 0x3ffffff;\n    /* k = 7 */\n    lo = Math.imul(al7, bl0);\n    mid = Math.imul(al7, bh0);\n    mid = (mid + Math.imul(ah7, bl0)) | 0;\n    hi = Math.imul(ah7, bh0);\n    lo = (lo + Math.imul(al6, bl1)) | 0;\n    mid = (mid + Math.imul(al6, bh1)) | 0;\n    mid = (mid + Math.imul(ah6, bl1)) | 0;\n    hi = (hi + Math.imul(ah6, bh1)) | 0;\n    lo = (lo + Math.imul(al5, bl2)) | 0;\n    mid = (mid + Math.imul(al5, bh2)) | 0;\n    mid = (mid + Math.imul(ah5, bl2)) | 0;\n    hi = (hi + Math.imul(ah5, bh2)) | 0;\n    lo = (lo + Math.imul(al4, bl3)) | 0;\n    mid = (mid + Math.imul(al4, bh3)) | 0;\n    mid = (mid + Math.imul(ah4, bl3)) | 0;\n    hi = (hi + Math.imul(ah4, bh3)) | 0;\n    lo = (lo + Math.imul(al3, bl4)) | 0;\n    mid = (mid + Math.imul(al3, bh4)) | 0;\n    mid = (mid + Math.imul(ah3, bl4)) | 0;\n    hi = (hi + Math.imul(ah3, bh4)) | 0;\n    lo = (lo + Math.imul(al2, bl5)) | 0;\n    mid = (mid + Math.imul(al2, bh5)) | 0;\n    mid = (mid + Math.imul(ah2, bl5)) | 0;\n    hi = (hi + Math.imul(ah2, bh5)) | 0;\n    lo = (lo + Math.imul(al1, bl6)) | 0;\n    mid = (mid + Math.imul(al1, bh6)) | 0;\n    mid = (mid + Math.imul(ah1, bl6)) | 0;\n    hi = (hi + Math.imul(ah1, bh6)) | 0;\n    lo = (lo + Math.imul(al0, bl7)) | 0;\n    mid = (mid + Math.imul(al0, bh7)) | 0;\n    mid = (mid + Math.imul(ah0, bl7)) | 0;\n    hi = (hi + Math.imul(ah0, bh7)) | 0;\n    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;\n    w7 &= 0x3ffffff;\n    /* k = 8 */\n    lo = Math.imul(al8, bl0);\n    mid = Math.imul(al8, bh0);\n    mid = (mid + Math.imul(ah8, bl0)) | 0;\n    hi = Math.imul(ah8, bh0);\n    lo = (lo + Math.imul(al7, bl1)) | 0;\n    mid = (mid + Math.imul(al7, bh1)) | 0;\n    mid = (mid + Math.imul(ah7, bl1)) | 0;\n    hi = (hi + Math.imul(ah7, bh1)) | 0;\n    lo = (lo + Math.imul(al6, bl2)) | 0;\n    mid = (mid + Math.imul(al6, bh2)) | 0;\n    mid = (mid + Math.imul(ah6, bl2)) | 0;\n    hi = (hi + Math.imul(ah6, bh2)) | 0;\n    lo = (lo + Math.imul(al5, bl3)) | 0;\n    mid = (mid + Math.imul(al5, bh3)) | 0;\n    mid = (mid + Math.imul(ah5, bl3)) | 0;\n    hi = (hi + Math.imul(ah5, bh3)) | 0;\n    lo = (lo + Math.imul(al4, bl4)) | 0;\n    mid = (mid + Math.imul(al4, bh4)) | 0;\n    mid = (mid + Math.imul(ah4, bl4)) | 0;\n    hi = (hi + Math.imul(ah4, bh4)) | 0;\n    lo = (lo + Math.imul(al3, bl5)) | 0;\n    mid = (mid + Math.imul(al3, bh5)) | 0;\n    mid = (mid + Math.imul(ah3, bl5)) | 0;\n    hi = (hi + Math.imul(ah3, bh5)) | 0;\n    lo = (lo + Math.imul(al2, bl6)) | 0;\n    mid = (mid + Math.imul(al2, bh6)) | 0;\n    mid = (mid + Math.imul(ah2, bl6)) | 0;\n    hi = (hi + Math.imul(ah2, bh6)) | 0;\n    lo = (lo + Math.imul(al1, bl7)) | 0;\n    mid = (mid + Math.imul(al1, bh7)) | 0;\n    mid = (mid + Math.imul(ah1, bl7)) | 0;\n    hi = (hi + Math.imul(ah1, bh7)) | 0;\n    lo = (lo + Math.imul(al0, bl8)) | 0;\n    mid = (mid + Math.imul(al0, bh8)) | 0;\n    mid = (mid + Math.imul(ah0, bl8)) | 0;\n    hi = (hi + Math.imul(ah0, bh8)) | 0;\n    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;\n    w8 &= 0x3ffffff;\n    /* k = 9 */\n    lo = Math.imul(al9, bl0);\n    mid = Math.imul(al9, bh0);\n    mid = (mid + Math.imul(ah9, bl0)) | 0;\n    hi = Math.imul(ah9, bh0);\n    lo = (lo + Math.imul(al8, bl1)) | 0;\n    mid = (mid + Math.imul(al8, bh1)) | 0;\n    mid = (mid + Math.imul(ah8, bl1)) | 0;\n    hi = (hi + Math.imul(ah8, bh1)) | 0;\n    lo = (lo + Math.imul(al7, bl2)) | 0;\n    mid = (mid + Math.imul(al7, bh2)) | 0;\n    mid = (mid + Math.imul(ah7, bl2)) | 0;\n    hi = (hi + Math.imul(ah7, bh2)) | 0;\n    lo = (lo + Math.imul(al6, bl3)) | 0;\n    mid = (mid + Math.imul(al6, bh3)) | 0;\n    mid = (mid + Math.imul(ah6, bl3)) | 0;\n    hi = (hi + Math.imul(ah6, bh3)) | 0;\n    lo = (lo + Math.imul(al5, bl4)) | 0;\n    mid = (mid + Math.imul(al5, bh4)) | 0;\n    mid = (mid + Math.imul(ah5, bl4)) | 0;\n    hi = (hi + Math.imul(ah5, bh4)) | 0;\n    lo = (lo + Math.imul(al4, bl5)) | 0;\n    mid = (mid + Math.imul(al4, bh5)) | 0;\n    mid = (mid + Math.imul(ah4, bl5)) | 0;\n    hi = (hi + Math.imul(ah4, bh5)) | 0;\n    lo = (lo + Math.imul(al3, bl6)) | 0;\n    mid = (mid + Math.imul(al3, bh6)) | 0;\n    mid = (mid + Math.imul(ah3, bl6)) | 0;\n    hi = (hi + Math.imul(ah3, bh6)) | 0;\n    lo = (lo + Math.imul(al2, bl7)) | 0;\n    mid = (mid + Math.imul(al2, bh7)) | 0;\n    mid = (mid + Math.imul(ah2, bl7)) | 0;\n    hi = (hi + Math.imul(ah2, bh7)) | 0;\n    lo = (lo + Math.imul(al1, bl8)) | 0;\n    mid = (mid + Math.imul(al1, bh8)) | 0;\n    mid = (mid + Math.imul(ah1, bl8)) | 0;\n    hi = (hi + Math.imul(ah1, bh8)) | 0;\n    lo = (lo + Math.imul(al0, bl9)) | 0;\n    mid = (mid + Math.imul(al0, bh9)) | 0;\n    mid = (mid + Math.imul(ah0, bl9)) | 0;\n    hi = (hi + Math.imul(ah0, bh9)) | 0;\n    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;\n    w9 &= 0x3ffffff;\n    /* k = 10 */\n    lo = Math.imul(al9, bl1);\n    mid = Math.imul(al9, bh1);\n    mid = (mid + Math.imul(ah9, bl1)) | 0;\n    hi = Math.imul(ah9, bh1);\n    lo = (lo + Math.imul(al8, bl2)) | 0;\n    mid = (mid + Math.imul(al8, bh2)) | 0;\n    mid = (mid + Math.imul(ah8, bl2)) | 0;\n    hi = (hi + Math.imul(ah8, bh2)) | 0;\n    lo = (lo + Math.imul(al7, bl3)) | 0;\n    mid = (mid + Math.imul(al7, bh3)) | 0;\n    mid = (mid + Math.imul(ah7, bl3)) | 0;\n    hi = (hi + Math.imul(ah7, bh3)) | 0;\n    lo = (lo + Math.imul(al6, bl4)) | 0;\n    mid = (mid + Math.imul(al6, bh4)) | 0;\n    mid = (mid + Math.imul(ah6, bl4)) | 0;\n    hi = (hi + Math.imul(ah6, bh4)) | 0;\n    lo = (lo + Math.imul(al5, bl5)) | 0;\n    mid = (mid + Math.imul(al5, bh5)) | 0;\n    mid = (mid + Math.imul(ah5, bl5)) | 0;\n    hi = (hi + Math.imul(ah5, bh5)) | 0;\n    lo = (lo + Math.imul(al4, bl6)) | 0;\n    mid = (mid + Math.imul(al4, bh6)) | 0;\n    mid = (mid + Math.imul(ah4, bl6)) | 0;\n    hi = (hi + Math.imul(ah4, bh6)) | 0;\n    lo = (lo + Math.imul(al3, bl7)) | 0;\n    mid = (mid + Math.imul(al3, bh7)) | 0;\n    mid = (mid + Math.imul(ah3, bl7)) | 0;\n    hi = (hi + Math.imul(ah3, bh7)) | 0;\n    lo = (lo + Math.imul(al2, bl8)) | 0;\n    mid = (mid + Math.imul(al2, bh8)) | 0;\n    mid = (mid + Math.imul(ah2, bl8)) | 0;\n    hi = (hi + Math.imul(ah2, bh8)) | 0;\n    lo = (lo + Math.imul(al1, bl9)) | 0;\n    mid = (mid + Math.imul(al1, bh9)) | 0;\n    mid = (mid + Math.imul(ah1, bl9)) | 0;\n    hi = (hi + Math.imul(ah1, bh9)) | 0;\n    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;\n    w10 &= 0x3ffffff;\n    /* k = 11 */\n    lo = Math.imul(al9, bl2);\n    mid = Math.imul(al9, bh2);\n    mid = (mid + Math.imul(ah9, bl2)) | 0;\n    hi = Math.imul(ah9, bh2);\n    lo = (lo + Math.imul(al8, bl3)) | 0;\n    mid = (mid + Math.imul(al8, bh3)) | 0;\n    mid = (mid + Math.imul(ah8, bl3)) | 0;\n    hi = (hi + Math.imul(ah8, bh3)) | 0;\n    lo = (lo + Math.imul(al7, bl4)) | 0;\n    mid = (mid + Math.imul(al7, bh4)) | 0;\n    mid = (mid + Math.imul(ah7, bl4)) | 0;\n    hi = (hi + Math.imul(ah7, bh4)) | 0;\n    lo = (lo + Math.imul(al6, bl5)) | 0;\n    mid = (mid + Math.imul(al6, bh5)) | 0;\n    mid = (mid + Math.imul(ah6, bl5)) | 0;\n    hi = (hi + Math.imul(ah6, bh5)) | 0;\n    lo = (lo + Math.imul(al5, bl6)) | 0;\n    mid = (mid + Math.imul(al5, bh6)) | 0;\n    mid = (mid + Math.imul(ah5, bl6)) | 0;\n    hi = (hi + Math.imul(ah5, bh6)) | 0;\n    lo = (lo + Math.imul(al4, bl7)) | 0;\n    mid = (mid + Math.imul(al4, bh7)) | 0;\n    mid = (mid + Math.imul(ah4, bl7)) | 0;\n    hi = (hi + Math.imul(ah4, bh7)) | 0;\n    lo = (lo + Math.imul(al3, bl8)) | 0;\n    mid = (mid + Math.imul(al3, bh8)) | 0;\n    mid = (mid + Math.imul(ah3, bl8)) | 0;\n    hi = (hi + Math.imul(ah3, bh8)) | 0;\n    lo = (lo + Math.imul(al2, bl9)) | 0;\n    mid = (mid + Math.imul(al2, bh9)) | 0;\n    mid = (mid + Math.imul(ah2, bl9)) | 0;\n    hi = (hi + Math.imul(ah2, bh9)) | 0;\n    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;\n    w11 &= 0x3ffffff;\n    /* k = 12 */\n    lo = Math.imul(al9, bl3);\n    mid = Math.imul(al9, bh3);\n    mid = (mid + Math.imul(ah9, bl3)) | 0;\n    hi = Math.imul(ah9, bh3);\n    lo = (lo + Math.imul(al8, bl4)) | 0;\n    mid = (mid + Math.imul(al8, bh4)) | 0;\n    mid = (mid + Math.imul(ah8, bl4)) | 0;\n    hi = (hi + Math.imul(ah8, bh4)) | 0;\n    lo = (lo + Math.imul(al7, bl5)) | 0;\n    mid = (mid + Math.imul(al7, bh5)) | 0;\n    mid = (mid + Math.imul(ah7, bl5)) | 0;\n    hi = (hi + Math.imul(ah7, bh5)) | 0;\n    lo = (lo + Math.imul(al6, bl6)) | 0;\n    mid = (mid + Math.imul(al6, bh6)) | 0;\n    mid = (mid + Math.imul(ah6, bl6)) | 0;\n    hi = (hi + Math.imul(ah6, bh6)) | 0;\n    lo = (lo + Math.imul(al5, bl7)) | 0;\n    mid = (mid + Math.imul(al5, bh7)) | 0;\n    mid = (mid + Math.imul(ah5, bl7)) | 0;\n    hi = (hi + Math.imul(ah5, bh7)) | 0;\n    lo = (lo + Math.imul(al4, bl8)) | 0;\n    mid = (mid + Math.imul(al4, bh8)) | 0;\n    mid = (mid + Math.imul(ah4, bl8)) | 0;\n    hi = (hi + Math.imul(ah4, bh8)) | 0;\n    lo = (lo + Math.imul(al3, bl9)) | 0;\n    mid = (mid + Math.imul(al3, bh9)) | 0;\n    mid = (mid + Math.imul(ah3, bl9)) | 0;\n    hi = (hi + Math.imul(ah3, bh9)) | 0;\n    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;\n    w12 &= 0x3ffffff;\n    /* k = 13 */\n    lo = Math.imul(al9, bl4);\n    mid = Math.imul(al9, bh4);\n    mid = (mid + Math.imul(ah9, bl4)) | 0;\n    hi = Math.imul(ah9, bh4);\n    lo = (lo + Math.imul(al8, bl5)) | 0;\n    mid = (mid + Math.imul(al8, bh5)) | 0;\n    mid = (mid + Math.imul(ah8, bl5)) | 0;\n    hi = (hi + Math.imul(ah8, bh5)) | 0;\n    lo = (lo + Math.imul(al7, bl6)) | 0;\n    mid = (mid + Math.imul(al7, bh6)) | 0;\n    mid = (mid + Math.imul(ah7, bl6)) | 0;\n    hi = (hi + Math.imul(ah7, bh6)) | 0;\n    lo = (lo + Math.imul(al6, bl7)) | 0;\n    mid = (mid + Math.imul(al6, bh7)) | 0;\n    mid = (mid + Math.imul(ah6, bl7)) | 0;\n    hi = (hi + Math.imul(ah6, bh7)) | 0;\n    lo = (lo + Math.imul(al5, bl8)) | 0;\n    mid = (mid + Math.imul(al5, bh8)) | 0;\n    mid = (mid + Math.imul(ah5, bl8)) | 0;\n    hi = (hi + Math.imul(ah5, bh8)) | 0;\n    lo = (lo + Math.imul(al4, bl9)) | 0;\n    mid = (mid + Math.imul(al4, bh9)) | 0;\n    mid = (mid + Math.imul(ah4, bl9)) | 0;\n    hi = (hi + Math.imul(ah4, bh9)) | 0;\n    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;\n    w13 &= 0x3ffffff;\n    /* k = 14 */\n    lo = Math.imul(al9, bl5);\n    mid = Math.imul(al9, bh5);\n    mid = (mid + Math.imul(ah9, bl5)) | 0;\n    hi = Math.imul(ah9, bh5);\n    lo = (lo + Math.imul(al8, bl6)) | 0;\n    mid = (mid + Math.imul(al8, bh6)) | 0;\n    mid = (mid + Math.imul(ah8, bl6)) | 0;\n    hi = (hi + Math.imul(ah8, bh6)) | 0;\n    lo = (lo + Math.imul(al7, bl7)) | 0;\n    mid = (mid + Math.imul(al7, bh7)) | 0;\n    mid = (mid + Math.imul(ah7, bl7)) | 0;\n    hi = (hi + Math.imul(ah7, bh7)) | 0;\n    lo = (lo + Math.imul(al6, bl8)) | 0;\n    mid = (mid + Math.imul(al6, bh8)) | 0;\n    mid = (mid + Math.imul(ah6, bl8)) | 0;\n    hi = (hi + Math.imul(ah6, bh8)) | 0;\n    lo = (lo + Math.imul(al5, bl9)) | 0;\n    mid = (mid + Math.imul(al5, bh9)) | 0;\n    mid = (mid + Math.imul(ah5, bl9)) | 0;\n    hi = (hi + Math.imul(ah5, bh9)) | 0;\n    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;\n    w14 &= 0x3ffffff;\n    /* k = 15 */\n    lo = Math.imul(al9, bl6);\n    mid = Math.imul(al9, bh6);\n    mid = (mid + Math.imul(ah9, bl6)) | 0;\n    hi = Math.imul(ah9, bh6);\n    lo = (lo + Math.imul(al8, bl7)) | 0;\n    mid = (mid + Math.imul(al8, bh7)) | 0;\n    mid = (mid + Math.imul(ah8, bl7)) | 0;\n    hi = (hi + Math.imul(ah8, bh7)) | 0;\n    lo = (lo + Math.imul(al7, bl8)) | 0;\n    mid = (mid + Math.imul(al7, bh8)) | 0;\n    mid = (mid + Math.imul(ah7, bl8)) | 0;\n    hi = (hi + Math.imul(ah7, bh8)) | 0;\n    lo = (lo + Math.imul(al6, bl9)) | 0;\n    mid = (mid + Math.imul(al6, bh9)) | 0;\n    mid = (mid + Math.imul(ah6, bl9)) | 0;\n    hi = (hi + Math.imul(ah6, bh9)) | 0;\n    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;\n    w15 &= 0x3ffffff;\n    /* k = 16 */\n    lo = Math.imul(al9, bl7);\n    mid = Math.imul(al9, bh7);\n    mid = (mid + Math.imul(ah9, bl7)) | 0;\n    hi = Math.imul(ah9, bh7);\n    lo = (lo + Math.imul(al8, bl8)) | 0;\n    mid = (mid + Math.imul(al8, bh8)) | 0;\n    mid = (mid + Math.imul(ah8, bl8)) | 0;\n    hi = (hi + Math.imul(ah8, bh8)) | 0;\n    lo = (lo + Math.imul(al7, bl9)) | 0;\n    mid = (mid + Math.imul(al7, bh9)) | 0;\n    mid = (mid + Math.imul(ah7, bl9)) | 0;\n    hi = (hi + Math.imul(ah7, bh9)) | 0;\n    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;\n    w16 &= 0x3ffffff;\n    /* k = 17 */\n    lo = Math.imul(al9, bl8);\n    mid = Math.imul(al9, bh8);\n    mid = (mid + Math.imul(ah9, bl8)) | 0;\n    hi = Math.imul(ah9, bh8);\n    lo = (lo + Math.imul(al8, bl9)) | 0;\n    mid = (mid + Math.imul(al8, bh9)) | 0;\n    mid = (mid + Math.imul(ah8, bl9)) | 0;\n    hi = (hi + Math.imul(ah8, bh9)) | 0;\n    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;\n    w17 &= 0x3ffffff;\n    /* k = 18 */\n    lo = Math.imul(al9, bl9);\n    mid = Math.imul(al9, bh9);\n    mid = (mid + Math.imul(ah9, bl9)) | 0;\n    hi = Math.imul(ah9, bh9);\n    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;\n    w18 &= 0x3ffffff;\n    o[0] = w0;\n    o[1] = w1;\n    o[2] = w2;\n    o[3] = w3;\n    o[4] = w4;\n    o[5] = w5;\n    o[6] = w6;\n    o[7] = w7;\n    o[8] = w8;\n    o[9] = w9;\n    o[10] = w10;\n    o[11] = w11;\n    o[12] = w12;\n    o[13] = w13;\n    o[14] = w14;\n    o[15] = w15;\n    o[16] = w16;\n    o[17] = w17;\n    o[18] = w18;\n    if (c !== 0) {\n      o[19] = c;\n      out.length++;\n    }\n    return out;\n  };\n\n  // Polyfill comb\n  if (!Math.imul) {\n    comb10MulTo = smallMulTo;\n  }\n\n  function bigMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    out.length = self.length + num.length;\n\n    var carry = 0;\n    var hncarry = 0;\n    for (var k = 0; k < out.length - 1; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = hncarry;\n      hncarry = 0;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = k - j;\n        var a = self.words[i] | 0;\n        var b = num.words[j] | 0;\n        var r = a * b;\n\n        var lo = r & 0x3ffffff;\n        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;\n        lo = (lo + rword) | 0;\n        rword = lo & 0x3ffffff;\n        ncarry = (ncarry + (lo >>> 26)) | 0;\n\n        hncarry += ncarry >>> 26;\n        ncarry &= 0x3ffffff;\n      }\n      out.words[k] = rword;\n      carry = ncarry;\n      ncarry = hncarry;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry;\n    } else {\n      out.length--;\n    }\n\n    return out.strip();\n  }\n\n  function jumboMulTo (self, num, out) {\n    var fftm = new FFTM();\n    return fftm.mulp(self, num, out);\n  }\n\n  BN.prototype.mulTo = function mulTo (num, out) {\n    var res;\n    var len = this.length + num.length;\n    if (this.length === 10 && num.length === 10) {\n      res = comb10MulTo(this, num, out);\n    } else if (len < 63) {\n      res = smallMulTo(this, num, out);\n    } else if (len < 1024) {\n      res = bigMulTo(this, num, out);\n    } else {\n      res = jumboMulTo(this, num, out);\n    }\n\n    return res;\n  };\n\n  // Cooley-Tukey algorithm for FFT\n  // slightly revisited to rely on looping instead of recursion\n\n  function FFTM (x, y) {\n    this.x = x;\n    this.y = y;\n  }\n\n  FFTM.prototype.makeRBT = function makeRBT (N) {\n    var t = new Array(N);\n    var l = BN.prototype._countBits(N) - 1;\n    for (var i = 0; i < N; i++) {\n      t[i] = this.revBin(i, l, N);\n    }\n\n    return t;\n  };\n\n  // Returns binary-reversed representation of `x`\n  FFTM.prototype.revBin = function revBin (x, l, N) {\n    if (x === 0 || x === N - 1) return x;\n\n    var rb = 0;\n    for (var i = 0; i < l; i++) {\n      rb |= (x & 1) << (l - i - 1);\n      x >>= 1;\n    }\n\n    return rb;\n  };\n\n  // Performs \"tweedling\" phase, therefore 'emulating'\n  // behaviour of the recursive algorithm\n  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {\n    for (var i = 0; i < N; i++) {\n      rtws[i] = rws[rbt[i]];\n      itws[i] = iws[rbt[i]];\n    }\n  };\n\n  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {\n    this.permute(rbt, rws, iws, rtws, itws, N);\n\n    for (var s = 1; s < N; s <<= 1) {\n      var l = s << 1;\n\n      var rtwdf = Math.cos(2 * Math.PI / l);\n      var itwdf = Math.sin(2 * Math.PI / l);\n\n      for (var p = 0; p < N; p += l) {\n        var rtwdf_ = rtwdf;\n        var itwdf_ = itwdf;\n\n        for (var j = 0; j < s; j++) {\n          var re = rtws[p + j];\n          var ie = itws[p + j];\n\n          var ro = rtws[p + j + s];\n          var io = itws[p + j + s];\n\n          var rx = rtwdf_ * ro - itwdf_ * io;\n\n          io = rtwdf_ * io + itwdf_ * ro;\n          ro = rx;\n\n          rtws[p + j] = re + ro;\n          itws[p + j] = ie + io;\n\n          rtws[p + j + s] = re - ro;\n          itws[p + j + s] = ie - io;\n\n          /* jshint maxdepth : false */\n          if (j !== l) {\n            rx = rtwdf * rtwdf_ - itwdf * itwdf_;\n\n            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;\n            rtwdf_ = rx;\n          }\n        }\n      }\n    }\n  };\n\n  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {\n    var N = Math.max(m, n) | 1;\n    var odd = N & 1;\n    var i = 0;\n    for (N = N / 2 | 0; N; N = N >>> 1) {\n      i++;\n    }\n\n    return 1 << i + 1 + odd;\n  };\n\n  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {\n    if (N <= 1) return;\n\n    for (var i = 0; i < N / 2; i++) {\n      var t = rws[i];\n\n      rws[i] = rws[N - i - 1];\n      rws[N - i - 1] = t;\n\n      t = iws[i];\n\n      iws[i] = -iws[N - i - 1];\n      iws[N - i - 1] = -t;\n    }\n  };\n\n  FFTM.prototype.normalize13b = function normalize13b (ws, N) {\n    var carry = 0;\n    for (var i = 0; i < N / 2; i++) {\n      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +\n        Math.round(ws[2 * i] / N) +\n        carry;\n\n      ws[i] = w & 0x3ffffff;\n\n      if (w < 0x4000000) {\n        carry = 0;\n      } else {\n        carry = w / 0x4000000 | 0;\n      }\n    }\n\n    return ws;\n  };\n\n  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {\n    var carry = 0;\n    for (var i = 0; i < len; i++) {\n      carry = carry + (ws[i] | 0);\n\n      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;\n      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;\n    }\n\n    // Pad with zeroes\n    for (i = 2 * len; i < N; ++i) {\n      rws[i] = 0;\n    }\n\n    assert(carry === 0);\n    assert((carry & ~0x1fff) === 0);\n  };\n\n  FFTM.prototype.stub = function stub (N) {\n    var ph = new Array(N);\n    for (var i = 0; i < N; i++) {\n      ph[i] = 0;\n    }\n\n    return ph;\n  };\n\n  FFTM.prototype.mulp = function mulp (x, y, out) {\n    var N = 2 * this.guessLen13b(x.length, y.length);\n\n    var rbt = this.makeRBT(N);\n\n    var _ = this.stub(N);\n\n    var rws = new Array(N);\n    var rwst = new Array(N);\n    var iwst = new Array(N);\n\n    var nrws = new Array(N);\n    var nrwst = new Array(N);\n    var niwst = new Array(N);\n\n    var rmws = out.words;\n    rmws.length = N;\n\n    this.convert13b(x.words, x.length, rws, N);\n    this.convert13b(y.words, y.length, nrws, N);\n\n    this.transform(rws, _, rwst, iwst, N, rbt);\n    this.transform(nrws, _, nrwst, niwst, N, rbt);\n\n    for (var i = 0; i < N; i++) {\n      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];\n      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];\n      rwst[i] = rx;\n    }\n\n    this.conjugate(rwst, iwst, N);\n    this.transform(rwst, iwst, rmws, _, N, rbt);\n    this.conjugate(rmws, _, N);\n    this.normalize13b(rmws, N);\n\n    out.negative = x.negative ^ y.negative;\n    out.length = x.length + y.length;\n    return out.strip();\n  };\n\n  // Multiply `this` by `num`\n  BN.prototype.mul = function mul (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return this.mulTo(num, out);\n  };\n\n  // Multiply employing FFT\n  BN.prototype.mulf = function mulf (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return jumboMulTo(this, num, out);\n  };\n\n  // In-place Multiplication\n  BN.prototype.imul = function imul (num) {\n    return this.clone().mulTo(num, this);\n  };\n\n  BN.prototype.imuln = function imuln (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n\n    // Carry\n    var carry = 0;\n    for (var i = 0; i < this.length; i++) {\n      var w = (this.words[i] | 0) * num;\n      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);\n      carry >>= 26;\n      carry += (w / 0x4000000) | 0;\n      // NOTE: lo is 27bit maximum\n      carry += lo >>> 26;\n      this.words[i] = lo & 0x3ffffff;\n    }\n\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n\n    return this;\n  };\n\n  BN.prototype.muln = function muln (num) {\n    return this.clone().imuln(num);\n  };\n\n  // `this` * `this`\n  BN.prototype.sqr = function sqr () {\n    return this.mul(this);\n  };\n\n  // `this` * `this` in-place\n  BN.prototype.isqr = function isqr () {\n    return this.imul(this.clone());\n  };\n\n  // Math.pow(`this`, `num`)\n  BN.prototype.pow = function pow (num) {\n    var w = toBitArray(num);\n    if (w.length === 0) return new BN(1);\n\n    // Skip leading zeroes\n    var res = this;\n    for (var i = 0; i < w.length; i++, res = res.sqr()) {\n      if (w[i] !== 0) break;\n    }\n\n    if (++i < w.length) {\n      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {\n        if (w[i] === 0) continue;\n\n        res = res.mul(q);\n      }\n    }\n\n    return res;\n  };\n\n  // Shift-left in-place\n  BN.prototype.iushln = function iushln (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);\n    var i;\n\n    if (r !== 0) {\n      var carry = 0;\n\n      for (i = 0; i < this.length; i++) {\n        var newCarry = this.words[i] & carryMask;\n        var c = ((this.words[i] | 0) - newCarry) << r;\n        this.words[i] = c | carry;\n        carry = newCarry >>> (26 - r);\n      }\n\n      if (carry) {\n        this.words[i] = carry;\n        this.length++;\n      }\n    }\n\n    if (s !== 0) {\n      for (i = this.length - 1; i >= 0; i--) {\n        this.words[i + s] = this.words[i];\n      }\n\n      for (i = 0; i < s; i++) {\n        this.words[i] = 0;\n      }\n\n      this.length += s;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ishln = function ishln (bits) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushln(bits);\n  };\n\n  // Shift-right in-place\n  // NOTE: `hint` is a lowest bit before trailing zeroes\n  // NOTE: if `extended` is present - it will be filled with destroyed bits\n  BN.prototype.iushrn = function iushrn (bits, hint, extended) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var h;\n    if (hint) {\n      h = (hint - (hint % 26)) / 26;\n    } else {\n      h = 0;\n    }\n\n    var r = bits % 26;\n    var s = Math.min((bits - r) / 26, this.length);\n    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n    var maskedWords = extended;\n\n    h -= s;\n    h = Math.max(0, h);\n\n    // Extended mode, copy masked part\n    if (maskedWords) {\n      for (var i = 0; i < s; i++) {\n        maskedWords.words[i] = this.words[i];\n      }\n      maskedWords.length = s;\n    }\n\n    if (s === 0) {\n      // No-op, we should not move anything at all\n    } else if (this.length > s) {\n      this.length -= s;\n      for (i = 0; i < this.length; i++) {\n        this.words[i] = this.words[i + s];\n      }\n    } else {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    var carry = 0;\n    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {\n      var word = this.words[i] | 0;\n      this.words[i] = (carry << (26 - r)) | (word >>> r);\n      carry = word & mask;\n    }\n\n    // Push carried bits as a mask\n    if (maskedWords && carry !== 0) {\n      maskedWords.words[maskedWords.length++] = carry;\n    }\n\n    if (this.length === 0) {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ishrn = function ishrn (bits, hint, extended) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushrn(bits, hint, extended);\n  };\n\n  // Shift-left\n  BN.prototype.shln = function shln (bits) {\n    return this.clone().ishln(bits);\n  };\n\n  BN.prototype.ushln = function ushln (bits) {\n    return this.clone().iushln(bits);\n  };\n\n  // Shift-right\n  BN.prototype.shrn = function shrn (bits) {\n    return this.clone().ishrn(bits);\n  };\n\n  BN.prototype.ushrn = function ushrn (bits) {\n    return this.clone().iushrn(bits);\n  };\n\n  // Test if n bit is set\n  BN.prototype.testn = function testn (bit) {\n    assert(typeof bit === 'number' && bit >= 0);\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) return false;\n\n    // Check bit and return\n    var w = this.words[s];\n\n    return !!(w & q);\n  };\n\n  // Return only lowers bits of number (in-place)\n  BN.prototype.imaskn = function imaskn (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n\n    assert(this.negative === 0, 'imaskn works only with positive numbers');\n\n    if (this.length <= s) {\n      return this;\n    }\n\n    if (r !== 0) {\n      s++;\n    }\n    this.length = Math.min(s, this.length);\n\n    if (r !== 0) {\n      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n      this.words[this.length - 1] &= mask;\n    }\n\n    return this.strip();\n  };\n\n  // Return only lowers bits of number\n  BN.prototype.maskn = function maskn (bits) {\n    return this.clone().imaskn(bits);\n  };\n\n  // Add plain number `num` to `this`\n  BN.prototype.iaddn = function iaddn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.isubn(-num);\n\n    // Possible sign change\n    if (this.negative !== 0) {\n      if (this.length === 1 && (this.words[0] | 0) < num) {\n        this.words[0] = num - (this.words[0] | 0);\n        this.negative = 0;\n        return this;\n      }\n\n      this.negative = 0;\n      this.isubn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    // Add without checks\n    return this._iaddn(num);\n  };\n\n  BN.prototype._iaddn = function _iaddn (num) {\n    this.words[0] += num;\n\n    // Carry\n    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {\n      this.words[i] -= 0x4000000;\n      if (i === this.length - 1) {\n        this.words[i + 1] = 1;\n      } else {\n        this.words[i + 1]++;\n      }\n    }\n    this.length = Math.max(this.length, i + 1);\n\n    return this;\n  };\n\n  // Subtract plain number `num` from `this`\n  BN.prototype.isubn = function isubn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.iaddn(-num);\n\n    if (this.negative !== 0) {\n      this.negative = 0;\n      this.iaddn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    this.words[0] -= num;\n\n    if (this.length === 1 && this.words[0] < 0) {\n      this.words[0] = -this.words[0];\n      this.negative = 1;\n    } else {\n      // Carry\n      for (var i = 0; i < this.length && this.words[i] < 0; i++) {\n        this.words[i] += 0x4000000;\n        this.words[i + 1] -= 1;\n      }\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.addn = function addn (num) {\n    return this.clone().iaddn(num);\n  };\n\n  BN.prototype.subn = function subn (num) {\n    return this.clone().isubn(num);\n  };\n\n  BN.prototype.iabs = function iabs () {\n    this.negative = 0;\n\n    return this;\n  };\n\n  BN.prototype.abs = function abs () {\n    return this.clone().iabs();\n  };\n\n  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {\n    var len = num.length + shift;\n    var i;\n\n    this._expand(len);\n\n    var w;\n    var carry = 0;\n    for (i = 0; i < num.length; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      var right = (num.words[i] | 0) * mul;\n      w -= right & 0x3ffffff;\n      carry = (w >> 26) - ((right / 0x4000000) | 0);\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n    for (; i < this.length - shift; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      carry = w >> 26;\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n\n    if (carry === 0) return this.strip();\n\n    // Subtraction overflow\n    assert(carry === -1);\n    carry = 0;\n    for (i = 0; i < this.length; i++) {\n      w = -(this.words[i] | 0) + carry;\n      carry = w >> 26;\n      this.words[i] = w & 0x3ffffff;\n    }\n    this.negative = 1;\n\n    return this.strip();\n  };\n\n  BN.prototype._wordDiv = function _wordDiv (num, mode) {\n    var shift = this.length - num.length;\n\n    var a = this.clone();\n    var b = num;\n\n    // Normalize\n    var bhi = b.words[b.length - 1] | 0;\n    var bhiBits = this._countBits(bhi);\n    shift = 26 - bhiBits;\n    if (shift !== 0) {\n      b = b.ushln(shift);\n      a.iushln(shift);\n      bhi = b.words[b.length - 1] | 0;\n    }\n\n    // Initialize quotient\n    var m = a.length - b.length;\n    var q;\n\n    if (mode !== 'mod') {\n      q = new BN(null);\n      q.length = m + 1;\n      q.words = new Array(q.length);\n      for (var i = 0; i < q.length; i++) {\n        q.words[i] = 0;\n      }\n    }\n\n    var diff = a.clone()._ishlnsubmul(b, 1, m);\n    if (diff.negative === 0) {\n      a = diff;\n      if (q) {\n        q.words[m] = 1;\n      }\n    }\n\n    for (var j = m - 1; j >= 0; j--) {\n      var qj = (a.words[b.length + j] | 0) * 0x4000000 +\n        (a.words[b.length + j - 1] | 0);\n\n      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max\n      // (0x7ffffff)\n      qj = Math.min((qj / bhi) | 0, 0x3ffffff);\n\n      a._ishlnsubmul(b, qj, j);\n      while (a.negative !== 0) {\n        qj--;\n        a.negative = 0;\n        a._ishlnsubmul(b, 1, j);\n        if (!a.isZero()) {\n          a.negative ^= 1;\n        }\n      }\n      if (q) {\n        q.words[j] = qj;\n      }\n    }\n    if (q) {\n      q.strip();\n    }\n    a.strip();\n\n    // Denormalize\n    if (mode !== 'div' && shift !== 0) {\n      a.iushrn(shift);\n    }\n\n    return {\n      div: q || null,\n      mod: a\n    };\n  };\n\n  // NOTE: 1) `mode` can be set to `mod` to request mod only,\n  //       to `div` to request div only, or be absent to\n  //       request both div & mod\n  //       2) `positive` is true if unsigned mod is requested\n  BN.prototype.divmod = function divmod (num, mode, positive) {\n    assert(!num.isZero());\n\n    if (this.isZero()) {\n      return {\n        div: new BN(0),\n        mod: new BN(0)\n      };\n    }\n\n    var div, mod, res;\n    if (this.negative !== 0 && num.negative === 0) {\n      res = this.neg().divmod(num, mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.iadd(num);\n        }\n      }\n\n      return {\n        div: div,\n        mod: mod\n      };\n    }\n\n    if (this.negative === 0 && num.negative !== 0) {\n      res = this.divmod(num.neg(), mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      return {\n        div: div,\n        mod: res.mod\n      };\n    }\n\n    if ((this.negative & num.negative) !== 0) {\n      res = this.neg().divmod(num.neg(), mode);\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.isub(num);\n        }\n      }\n\n      return {\n        div: res.div,\n        mod: mod\n      };\n    }\n\n    // Both numbers are positive at this point\n\n    // Strip both numbers to approximate shift value\n    if (num.length > this.length || this.cmp(num) < 0) {\n      return {\n        div: new BN(0),\n        mod: this\n      };\n    }\n\n    // Very short reduction\n    if (num.length === 1) {\n      if (mode === 'div') {\n        return {\n          div: this.divn(num.words[0]),\n          mod: null\n        };\n      }\n\n      if (mode === 'mod') {\n        return {\n          div: null,\n          mod: new BN(this.modn(num.words[0]))\n        };\n      }\n\n      return {\n        div: this.divn(num.words[0]),\n        mod: new BN(this.modn(num.words[0]))\n      };\n    }\n\n    return this._wordDiv(num, mode);\n  };\n\n  // Find `this` / `num`\n  BN.prototype.div = function div (num) {\n    return this.divmod(num, 'div', false).div;\n  };\n\n  // Find `this` % `num`\n  BN.prototype.mod = function mod (num) {\n    return this.divmod(num, 'mod', false).mod;\n  };\n\n  BN.prototype.umod = function umod (num) {\n    return this.divmod(num, 'mod', true).mod;\n  };\n\n  // Find Round(`this` / `num`)\n  BN.prototype.divRound = function divRound (num) {\n    var dm = this.divmod(num);\n\n    // Fast case - exact division\n    if (dm.mod.isZero()) return dm.div;\n\n    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;\n\n    var half = num.ushrn(1);\n    var r2 = num.andln(1);\n    var cmp = mod.cmp(half);\n\n    // Round down\n    if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;\n\n    // Round up\n    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);\n  };\n\n  BN.prototype.modn = function modn (num) {\n    assert(num <= 0x3ffffff);\n    var p = (1 << 26) % num;\n\n    var acc = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      acc = (p * acc + (this.words[i] | 0)) % num;\n    }\n\n    return acc;\n  };\n\n  // In-place division by number\n  BN.prototype.idivn = function idivn (num) {\n    assert(num <= 0x3ffffff);\n\n    var carry = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var w = (this.words[i] | 0) + carry * 0x4000000;\n      this.words[i] = (w / num) | 0;\n      carry = w % num;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.divn = function divn (num) {\n    return this.clone().idivn(num);\n  };\n\n  BN.prototype.egcd = function egcd (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var x = this;\n    var y = p.clone();\n\n    if (x.negative !== 0) {\n      x = x.umod(p);\n    } else {\n      x = x.clone();\n    }\n\n    // A * x + B * y = x\n    var A = new BN(1);\n    var B = new BN(0);\n\n    // C * x + D * y = y\n    var C = new BN(0);\n    var D = new BN(1);\n\n    var g = 0;\n\n    while (x.isEven() && y.isEven()) {\n      x.iushrn(1);\n      y.iushrn(1);\n      ++g;\n    }\n\n    var yp = y.clone();\n    var xp = x.clone();\n\n    while (!x.isZero()) {\n      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        x.iushrn(i);\n        while (i-- > 0) {\n          if (A.isOdd() || B.isOdd()) {\n            A.iadd(yp);\n            B.isub(xp);\n          }\n\n          A.iushrn(1);\n          B.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        y.iushrn(j);\n        while (j-- > 0) {\n          if (C.isOdd() || D.isOdd()) {\n            C.iadd(yp);\n            D.isub(xp);\n          }\n\n          C.iushrn(1);\n          D.iushrn(1);\n        }\n      }\n\n      if (x.cmp(y) >= 0) {\n        x.isub(y);\n        A.isub(C);\n        B.isub(D);\n      } else {\n        y.isub(x);\n        C.isub(A);\n        D.isub(B);\n      }\n    }\n\n    return {\n      a: C,\n      b: D,\n      gcd: y.iushln(g)\n    };\n  };\n\n  // This is reduced incarnation of the binary EEA\n  // above, designated to invert members of the\n  // _prime_ fields F(p) at a maximal speed\n  BN.prototype._invmp = function _invmp (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var a = this;\n    var b = p.clone();\n\n    if (a.negative !== 0) {\n      a = a.umod(p);\n    } else {\n      a = a.clone();\n    }\n\n    var x1 = new BN(1);\n    var x2 = new BN(0);\n\n    var delta = b.clone();\n\n    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {\n      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        a.iushrn(i);\n        while (i-- > 0) {\n          if (x1.isOdd()) {\n            x1.iadd(delta);\n          }\n\n          x1.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        b.iushrn(j);\n        while (j-- > 0) {\n          if (x2.isOdd()) {\n            x2.iadd(delta);\n          }\n\n          x2.iushrn(1);\n        }\n      }\n\n      if (a.cmp(b) >= 0) {\n        a.isub(b);\n        x1.isub(x2);\n      } else {\n        b.isub(a);\n        x2.isub(x1);\n      }\n    }\n\n    var res;\n    if (a.cmpn(1) === 0) {\n      res = x1;\n    } else {\n      res = x2;\n    }\n\n    if (res.cmpn(0) < 0) {\n      res.iadd(p);\n    }\n\n    return res;\n  };\n\n  BN.prototype.gcd = function gcd (num) {\n    if (this.isZero()) return num.abs();\n    if (num.isZero()) return this.abs();\n\n    var a = this.clone();\n    var b = num.clone();\n    a.negative = 0;\n    b.negative = 0;\n\n    // Remove common factor of two\n    for (var shift = 0; a.isEven() && b.isEven(); shift++) {\n      a.iushrn(1);\n      b.iushrn(1);\n    }\n\n    do {\n      while (a.isEven()) {\n        a.iushrn(1);\n      }\n      while (b.isEven()) {\n        b.iushrn(1);\n      }\n\n      var r = a.cmp(b);\n      if (r < 0) {\n        // Swap `a` and `b` to make `a` always bigger than `b`\n        var t = a;\n        a = b;\n        b = t;\n      } else if (r === 0 || b.cmpn(1) === 0) {\n        break;\n      }\n\n      a.isub(b);\n    } while (true);\n\n    return b.iushln(shift);\n  };\n\n  // Invert number in the field F(num)\n  BN.prototype.invm = function invm (num) {\n    return this.egcd(num).a.umod(num);\n  };\n\n  BN.prototype.isEven = function isEven () {\n    return (this.words[0] & 1) === 0;\n  };\n\n  BN.prototype.isOdd = function isOdd () {\n    return (this.words[0] & 1) === 1;\n  };\n\n  // And first word and num\n  BN.prototype.andln = function andln (num) {\n    return this.words[0] & num;\n  };\n\n  // Increment at the bit position in-line\n  BN.prototype.bincn = function bincn (bit) {\n    assert(typeof bit === 'number');\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) {\n      this._expand(s + 1);\n      this.words[s] |= q;\n      return this;\n    }\n\n    // Add bit and propagate, if needed\n    var carry = q;\n    for (var i = s; carry !== 0 && i < this.length; i++) {\n      var w = this.words[i] | 0;\n      w += carry;\n      carry = w >>> 26;\n      w &= 0x3ffffff;\n      this.words[i] = w;\n    }\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n    return this;\n  };\n\n  BN.prototype.isZero = function isZero () {\n    return this.length === 1 && this.words[0] === 0;\n  };\n\n  BN.prototype.cmpn = function cmpn (num) {\n    var negative = num < 0;\n\n    if (this.negative !== 0 && !negative) return -1;\n    if (this.negative === 0 && negative) return 1;\n\n    this.strip();\n\n    var res;\n    if (this.length > 1) {\n      res = 1;\n    } else {\n      if (negative) {\n        num = -num;\n      }\n\n      assert(num <= 0x3ffffff, 'Number is too big');\n\n      var w = this.words[0] | 0;\n      res = w === num ? 0 : w < num ? -1 : 1;\n    }\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Compare two numbers and return:\n  // 1 - if `this` > `num`\n  // 0 - if `this` == `num`\n  // -1 - if `this` < `num`\n  BN.prototype.cmp = function cmp (num) {\n    if (this.negative !== 0 && num.negative === 0) return -1;\n    if (this.negative === 0 && num.negative !== 0) return 1;\n\n    var res = this.ucmp(num);\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Unsigned comparison\n  BN.prototype.ucmp = function ucmp (num) {\n    // At this point both numbers have the same sign\n    if (this.length > num.length) return 1;\n    if (this.length < num.length) return -1;\n\n    var res = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var a = this.words[i] | 0;\n      var b = num.words[i] | 0;\n\n      if (a === b) continue;\n      if (a < b) {\n        res = -1;\n      } else if (a > b) {\n        res = 1;\n      }\n      break;\n    }\n    return res;\n  };\n\n  BN.prototype.gtn = function gtn (num) {\n    return this.cmpn(num) === 1;\n  };\n\n  BN.prototype.gt = function gt (num) {\n    return this.cmp(num) === 1;\n  };\n\n  BN.prototype.gten = function gten (num) {\n    return this.cmpn(num) >= 0;\n  };\n\n  BN.prototype.gte = function gte (num) {\n    return this.cmp(num) >= 0;\n  };\n\n  BN.prototype.ltn = function ltn (num) {\n    return this.cmpn(num) === -1;\n  };\n\n  BN.prototype.lt = function lt (num) {\n    return this.cmp(num) === -1;\n  };\n\n  BN.prototype.lten = function lten (num) {\n    return this.cmpn(num) <= 0;\n  };\n\n  BN.prototype.lte = function lte (num) {\n    return this.cmp(num) <= 0;\n  };\n\n  BN.prototype.eqn = function eqn (num) {\n    return this.cmpn(num) === 0;\n  };\n\n  BN.prototype.eq = function eq (num) {\n    return this.cmp(num) === 0;\n  };\n\n  //\n  // A reduce context, could be using montgomery or something better, depending\n  // on the `m` itself.\n  //\n  BN.red = function red (num) {\n    return new Red(num);\n  };\n\n  BN.prototype.toRed = function toRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    assert(this.negative === 0, 'red works only with positives');\n    return ctx.convertTo(this)._forceRed(ctx);\n  };\n\n  BN.prototype.fromRed = function fromRed () {\n    assert(this.red, 'fromRed works only with numbers in reduction context');\n    return this.red.convertFrom(this);\n  };\n\n  BN.prototype._forceRed = function _forceRed (ctx) {\n    this.red = ctx;\n    return this;\n  };\n\n  BN.prototype.forceRed = function forceRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    return this._forceRed(ctx);\n  };\n\n  BN.prototype.redAdd = function redAdd (num) {\n    assert(this.red, 'redAdd works only with red numbers');\n    return this.red.add(this, num);\n  };\n\n  BN.prototype.redIAdd = function redIAdd (num) {\n    assert(this.red, 'redIAdd works only with red numbers');\n    return this.red.iadd(this, num);\n  };\n\n  BN.prototype.redSub = function redSub (num) {\n    assert(this.red, 'redSub works only with red numbers');\n    return this.red.sub(this, num);\n  };\n\n  BN.prototype.redISub = function redISub (num) {\n    assert(this.red, 'redISub works only with red numbers');\n    return this.red.isub(this, num);\n  };\n\n  BN.prototype.redShl = function redShl (num) {\n    assert(this.red, 'redShl works only with red numbers');\n    return this.red.shl(this, num);\n  };\n\n  BN.prototype.redMul = function redMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.mul(this, num);\n  };\n\n  BN.prototype.redIMul = function redIMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.imul(this, num);\n  };\n\n  BN.prototype.redSqr = function redSqr () {\n    assert(this.red, 'redSqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqr(this);\n  };\n\n  BN.prototype.redISqr = function redISqr () {\n    assert(this.red, 'redISqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.isqr(this);\n  };\n\n  // Square root over p\n  BN.prototype.redSqrt = function redSqrt () {\n    assert(this.red, 'redSqrt works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqrt(this);\n  };\n\n  BN.prototype.redInvm = function redInvm () {\n    assert(this.red, 'redInvm works only with red numbers');\n    this.red._verify1(this);\n    return this.red.invm(this);\n  };\n\n  // Return negative clone of `this` % `red modulo`\n  BN.prototype.redNeg = function redNeg () {\n    assert(this.red, 'redNeg works only with red numbers');\n    this.red._verify1(this);\n    return this.red.neg(this);\n  };\n\n  BN.prototype.redPow = function redPow (num) {\n    assert(this.red && !num.red, 'redPow(normalNum)');\n    this.red._verify1(this);\n    return this.red.pow(this, num);\n  };\n\n  // Prime numbers with efficient reduction\n  var primes = {\n    k256: null,\n    p224: null,\n    p192: null,\n    p25519: null\n  };\n\n  // Pseudo-Mersenne prime\n  function MPrime (name, p) {\n    // P = 2 ^ N - K\n    this.name = name;\n    this.p = new BN(p, 16);\n    this.n = this.p.bitLength();\n    this.k = new BN(1).iushln(this.n).isub(this.p);\n\n    this.tmp = this._tmp();\n  }\n\n  MPrime.prototype._tmp = function _tmp () {\n    var tmp = new BN(null);\n    tmp.words = new Array(Math.ceil(this.n / 13));\n    return tmp;\n  };\n\n  MPrime.prototype.ireduce = function ireduce (num) {\n    // Assumes that `num` is less than `P^2`\n    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)\n    var r = num;\n    var rlen;\n\n    do {\n      this.split(r, this.tmp);\n      r = this.imulK(r);\n      r = r.iadd(this.tmp);\n      rlen = r.bitLength();\n    } while (rlen > this.n);\n\n    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);\n    if (cmp === 0) {\n      r.words[0] = 0;\n      r.length = 1;\n    } else if (cmp > 0) {\n      r.isub(this.p);\n    } else {\n      if (r.strip !== undefined) {\n        // r is BN v4 instance\n        r.strip();\n      } else {\n        // r is BN v5 instance\n        r._strip();\n      }\n    }\n\n    return r;\n  };\n\n  MPrime.prototype.split = function split (input, out) {\n    input.iushrn(this.n, 0, out);\n  };\n\n  MPrime.prototype.imulK = function imulK (num) {\n    return num.imul(this.k);\n  };\n\n  function K256 () {\n    MPrime.call(\n      this,\n      'k256',\n      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');\n  }\n  inherits(K256, MPrime);\n\n  K256.prototype.split = function split (input, output) {\n    // 256 = 9 * 26 + 22\n    var mask = 0x3fffff;\n\n    var outLen = Math.min(input.length, 9);\n    for (var i = 0; i < outLen; i++) {\n      output.words[i] = input.words[i];\n    }\n    output.length = outLen;\n\n    if (input.length <= 9) {\n      input.words[0] = 0;\n      input.length = 1;\n      return;\n    }\n\n    // Shift by 9 limbs\n    var prev = input.words[9];\n    output.words[output.length++] = prev & mask;\n\n    for (i = 10; i < input.length; i++) {\n      var next = input.words[i] | 0;\n      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);\n      prev = next;\n    }\n    prev >>>= 22;\n    input.words[i - 10] = prev;\n    if (prev === 0 && input.length > 10) {\n      input.length -= 10;\n    } else {\n      input.length -= 9;\n    }\n  };\n\n  K256.prototype.imulK = function imulK (num) {\n    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]\n    num.words[num.length] = 0;\n    num.words[num.length + 1] = 0;\n    num.length += 2;\n\n    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390\n    var lo = 0;\n    for (var i = 0; i < num.length; i++) {\n      var w = num.words[i] | 0;\n      lo += w * 0x3d1;\n      num.words[i] = lo & 0x3ffffff;\n      lo = w * 0x40 + ((lo / 0x4000000) | 0);\n    }\n\n    // Fast length reduction\n    if (num.words[num.length - 1] === 0) {\n      num.length--;\n      if (num.words[num.length - 1] === 0) {\n        num.length--;\n      }\n    }\n    return num;\n  };\n\n  function P224 () {\n    MPrime.call(\n      this,\n      'p224',\n      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');\n  }\n  inherits(P224, MPrime);\n\n  function P192 () {\n    MPrime.call(\n      this,\n      'p192',\n      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');\n  }\n  inherits(P192, MPrime);\n\n  function P25519 () {\n    // 2 ^ 255 - 19\n    MPrime.call(\n      this,\n      '25519',\n      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');\n  }\n  inherits(P25519, MPrime);\n\n  P25519.prototype.imulK = function imulK (num) {\n    // K = 0x13\n    var carry = 0;\n    for (var i = 0; i < num.length; i++) {\n      var hi = (num.words[i] | 0) * 0x13 + carry;\n      var lo = hi & 0x3ffffff;\n      hi >>>= 26;\n\n      num.words[i] = lo;\n      carry = hi;\n    }\n    if (carry !== 0) {\n      num.words[num.length++] = carry;\n    }\n    return num;\n  };\n\n  // Exported mostly for testing purposes, use plain name instead\n  BN._prime = function prime (name) {\n    // Cached version of prime\n    if (primes[name]) return primes[name];\n\n    var prime;\n    if (name === 'k256') {\n      prime = new K256();\n    } else if (name === 'p224') {\n      prime = new P224();\n    } else if (name === 'p192') {\n      prime = new P192();\n    } else if (name === 'p25519') {\n      prime = new P25519();\n    } else {\n      throw new Error('Unknown prime ' + name);\n    }\n    primes[name] = prime;\n\n    return prime;\n  };\n\n  //\n  // Base reduction engine\n  //\n  function Red (m) {\n    if (typeof m === 'string') {\n      var prime = BN._prime(m);\n      this.m = prime.p;\n      this.prime = prime;\n    } else {\n      assert(m.gtn(1), 'modulus must be greater than 1');\n      this.m = m;\n      this.prime = null;\n    }\n  }\n\n  Red.prototype._verify1 = function _verify1 (a) {\n    assert(a.negative === 0, 'red works only with positives');\n    assert(a.red, 'red works only with red numbers');\n  };\n\n  Red.prototype._verify2 = function _verify2 (a, b) {\n    assert((a.negative | b.negative) === 0, 'red works only with positives');\n    assert(a.red && a.red === b.red,\n      'red works only with red numbers');\n  };\n\n  Red.prototype.imod = function imod (a) {\n    if (this.prime) return this.prime.ireduce(a)._forceRed(this);\n    return a.umod(this.m)._forceRed(this);\n  };\n\n  Red.prototype.neg = function neg (a) {\n    if (a.isZero()) {\n      return a.clone();\n    }\n\n    return this.m.sub(a)._forceRed(this);\n  };\n\n  Red.prototype.add = function add (a, b) {\n    this._verify2(a, b);\n\n    var res = a.add(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.iadd = function iadd (a, b) {\n    this._verify2(a, b);\n\n    var res = a.iadd(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.sub = function sub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.sub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.isub = function isub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.isub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.shl = function shl (a, num) {\n    this._verify1(a);\n    return this.imod(a.ushln(num));\n  };\n\n  Red.prototype.imul = function imul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.imul(b));\n  };\n\n  Red.prototype.mul = function mul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.mul(b));\n  };\n\n  Red.prototype.isqr = function isqr (a) {\n    return this.imul(a, a.clone());\n  };\n\n  Red.prototype.sqr = function sqr (a) {\n    return this.mul(a, a);\n  };\n\n  Red.prototype.sqrt = function sqrt (a) {\n    if (a.isZero()) return a.clone();\n\n    var mod3 = this.m.andln(3);\n    assert(mod3 % 2 === 1);\n\n    // Fast case\n    if (mod3 === 3) {\n      var pow = this.m.add(new BN(1)).iushrn(2);\n      return this.pow(a, pow);\n    }\n\n    // Tonelli-Shanks algorithm (Totally unoptimized and slow)\n    //\n    // Find Q and S, that Q * 2 ^ S = (P - 1)\n    var q = this.m.subn(1);\n    var s = 0;\n    while (!q.isZero() && q.andln(1) === 0) {\n      s++;\n      q.iushrn(1);\n    }\n    assert(!q.isZero());\n\n    var one = new BN(1).toRed(this);\n    var nOne = one.redNeg();\n\n    // Find quadratic non-residue\n    // NOTE: Max is such because of generalized Riemann hypothesis.\n    var lpow = this.m.subn(1).iushrn(1);\n    var z = this.m.bitLength();\n    z = new BN(2 * z * z).toRed(this);\n\n    while (this.pow(z, lpow).cmp(nOne) !== 0) {\n      z.redIAdd(nOne);\n    }\n\n    var c = this.pow(z, q);\n    var r = this.pow(a, q.addn(1).iushrn(1));\n    var t = this.pow(a, q);\n    var m = s;\n    while (t.cmp(one) !== 0) {\n      var tmp = t;\n      for (var i = 0; tmp.cmp(one) !== 0; i++) {\n        tmp = tmp.redSqr();\n      }\n      assert(i < m);\n      var b = this.pow(c, new BN(1).iushln(m - i - 1));\n\n      r = r.redMul(b);\n      c = b.redSqr();\n      t = t.redMul(c);\n      m = i;\n    }\n\n    return r;\n  };\n\n  Red.prototype.invm = function invm (a) {\n    var inv = a._invmp(this.m);\n    if (inv.negative !== 0) {\n      inv.negative = 0;\n      return this.imod(inv).redNeg();\n    } else {\n      return this.imod(inv);\n    }\n  };\n\n  Red.prototype.pow = function pow (a, num) {\n    if (num.isZero()) return new BN(1).toRed(this);\n    if (num.cmpn(1) === 0) return a.clone();\n\n    var windowSize = 4;\n    var wnd = new Array(1 << windowSize);\n    wnd[0] = new BN(1).toRed(this);\n    wnd[1] = a;\n    for (var i = 2; i < wnd.length; i++) {\n      wnd[i] = this.mul(wnd[i - 1], a);\n    }\n\n    var res = wnd[0];\n    var current = 0;\n    var currentLen = 0;\n    var start = num.bitLength() % 26;\n    if (start === 0) {\n      start = 26;\n    }\n\n    for (i = num.length - 1; i >= 0; i--) {\n      var word = num.words[i];\n      for (var j = start - 1; j >= 0; j--) {\n        var bit = (word >> j) & 1;\n        if (res !== wnd[0]) {\n          res = this.sqr(res);\n        }\n\n        if (bit === 0 && current === 0) {\n          currentLen = 0;\n          continue;\n        }\n\n        current <<= 1;\n        current |= bit;\n        currentLen++;\n        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;\n\n        res = this.mul(res, wnd[current]);\n        currentLen = 0;\n        current = 0;\n      }\n      start = 26;\n    }\n\n    return res;\n  };\n\n  Red.prototype.convertTo = function convertTo (num) {\n    var r = num.umod(this.m);\n\n    return r === num ? r.clone() : r;\n  };\n\n  Red.prototype.convertFrom = function convertFrom (num) {\n    var res = num.clone();\n    res.red = null;\n    return res;\n  };\n\n  //\n  // Montgomery method engine\n  //\n\n  BN.mont = function mont (num) {\n    return new Mont(num);\n  };\n\n  function Mont (m) {\n    Red.call(this, m);\n\n    this.shift = this.m.bitLength();\n    if (this.shift % 26 !== 0) {\n      this.shift += 26 - (this.shift % 26);\n    }\n\n    this.r = new BN(1).iushln(this.shift);\n    this.r2 = this.imod(this.r.sqr());\n    this.rinv = this.r._invmp(this.m);\n\n    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);\n    this.minv = this.minv.umod(this.r);\n    this.minv = this.r.sub(this.minv);\n  }\n  inherits(Mont, Red);\n\n  Mont.prototype.convertTo = function convertTo (num) {\n    return this.imod(num.ushln(this.shift));\n  };\n\n  Mont.prototype.convertFrom = function convertFrom (num) {\n    var r = this.imod(num.mul(this.rinv));\n    r.red = null;\n    return r;\n  };\n\n  Mont.prototype.imul = function imul (a, b) {\n    if (a.isZero() || b.isZero()) {\n      a.words[0] = 0;\n      a.length = 1;\n      return a;\n    }\n\n    var t = a.imul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.mul = function mul (a, b) {\n    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);\n\n    var t = a.mul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.invm = function invm (a) {\n    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R\n    var res = this.imod(a._invmp(this.m).mul(this.r2));\n    return res._forceRed(this);\n  };\n})(typeof module === 'undefined' || module, this);","deps":{"buffer":"node_modules/browser-resolve/empty.js"}},{"id":"node_modules/browserify-sign/node_modules/bn.js/lib/bn.js","source":"(function (module, exports) {\n  'use strict';\n\n  // Utils\n  function assert (val, msg) {\n    if (!val) throw new Error(msg || 'Assertion failed');\n  }\n\n  // Could use `inherits` module, but don't want to move from single file\n  // architecture yet.\n  function inherits (ctor, superCtor) {\n    ctor.super_ = superCtor;\n    var TempCtor = function () {};\n    TempCtor.prototype = superCtor.prototype;\n    ctor.prototype = new TempCtor();\n    ctor.prototype.constructor = ctor;\n  }\n\n  // BN\n\n  function BN (number, base, endian) {\n    if (BN.isBN(number)) {\n      return number;\n    }\n\n    this.negative = 0;\n    this.words = null;\n    this.length = 0;\n\n    // Reduction context\n    this.red = null;\n\n    if (number !== null) {\n      if (base === 'le' || base === 'be') {\n        endian = base;\n        base = 10;\n      }\n\n      this._init(number || 0, base || 10, endian || 'be');\n    }\n  }\n  if (typeof module === 'object') {\n    module.exports = BN;\n  } else {\n    exports.BN = BN;\n  }\n\n  BN.BN = BN;\n  BN.wordSize = 26;\n\n  var Buffer;\n  try {\n    if (typeof window !== 'undefined' && typeof window.Buffer !== 'undefined') {\n      Buffer = window.Buffer;\n    } else {\n      Buffer = require('buffer').Buffer;\n    }\n  } catch (e) {\n  }\n\n  BN.isBN = function isBN (num) {\n    if (num instanceof BN) {\n      return true;\n    }\n\n    return num !== null && typeof num === 'object' &&\n      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);\n  };\n\n  BN.max = function max (left, right) {\n    if (left.cmp(right) > 0) return left;\n    return right;\n  };\n\n  BN.min = function min (left, right) {\n    if (left.cmp(right) < 0) return left;\n    return right;\n  };\n\n  BN.prototype._init = function init (number, base, endian) {\n    if (typeof number === 'number') {\n      return this._initNumber(number, base, endian);\n    }\n\n    if (typeof number === 'object') {\n      return this._initArray(number, base, endian);\n    }\n\n    if (base === 'hex') {\n      base = 16;\n    }\n    assert(base === (base | 0) && base >= 2 && base <= 36);\n\n    number = number.toString().replace(/\\s+/g, '');\n    var start = 0;\n    if (number[0] === '-') {\n      start++;\n      this.negative = 1;\n    }\n\n    if (start < number.length) {\n      if (base === 16) {\n        this._parseHex(number, start, endian);\n      } else {\n        this._parseBase(number, base, start);\n        if (endian === 'le') {\n          this._initArray(this.toArray(), base, endian);\n        }\n      }\n    }\n  };\n\n  BN.prototype._initNumber = function _initNumber (number, base, endian) {\n    if (number < 0) {\n      this.negative = 1;\n      number = -number;\n    }\n    if (number < 0x4000000) {\n      this.words = [number & 0x3ffffff];\n      this.length = 1;\n    } else if (number < 0x10000000000000) {\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff\n      ];\n      this.length = 2;\n    } else {\n      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff,\n        1\n      ];\n      this.length = 3;\n    }\n\n    if (endian !== 'le') return;\n\n    // Reverse the bytes\n    this._initArray(this.toArray(), base, endian);\n  };\n\n  BN.prototype._initArray = function _initArray (number, base, endian) {\n    // Perhaps a Uint8Array\n    assert(typeof number.length === 'number');\n    if (number.length <= 0) {\n      this.words = [0];\n      this.length = 1;\n      return this;\n    }\n\n    this.length = Math.ceil(number.length / 3);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    var j, w;\n    var off = 0;\n    if (endian === 'be') {\n      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {\n        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    } else if (endian === 'le') {\n      for (i = 0, j = 0; i < number.length; i += 3) {\n        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    }\n    return this._strip();\n  };\n\n  function parseHex4Bits (string, index) {\n    var c = string.charCodeAt(index);\n    // '0' - '9'\n    if (c >= 48 && c <= 57) {\n      return c - 48;\n    // 'A' - 'F'\n    } else if (c >= 65 && c <= 70) {\n      return c - 55;\n    // 'a' - 'f'\n    } else if (c >= 97 && c <= 102) {\n      return c - 87;\n    } else {\n      assert(false, 'Invalid character in ' + string);\n    }\n  }\n\n  function parseHexByte (string, lowerBound, index) {\n    var r = parseHex4Bits(string, index);\n    if (index - 1 >= lowerBound) {\n      r |= parseHex4Bits(string, index - 1) << 4;\n    }\n    return r;\n  }\n\n  BN.prototype._parseHex = function _parseHex (number, start, endian) {\n    // Create possibly bigger array to ensure that it fits the number\n    this.length = Math.ceil((number.length - start) / 6);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    // 24-bits chunks\n    var off = 0;\n    var j = 0;\n\n    var w;\n    if (endian === 'be') {\n      for (i = number.length - 1; i >= start; i -= 2) {\n        w = parseHexByte(number, start, i) << off;\n        this.words[j] |= w & 0x3ffffff;\n        if (off >= 18) {\n          off -= 18;\n          j += 1;\n          this.words[j] |= w >>> 26;\n        } else {\n          off += 8;\n        }\n      }\n    } else {\n      var parseLength = number.length - start;\n      for (i = parseLength % 2 === 0 ? start + 1 : start; i < number.length; i += 2) {\n        w = parseHexByte(number, start, i) << off;\n        this.words[j] |= w & 0x3ffffff;\n        if (off >= 18) {\n          off -= 18;\n          j += 1;\n          this.words[j] |= w >>> 26;\n        } else {\n          off += 8;\n        }\n      }\n    }\n\n    this._strip();\n  };\n\n  function parseBase (str, start, end, mul) {\n    var r = 0;\n    var b = 0;\n    var len = Math.min(str.length, end);\n    for (var i = start; i < len; i++) {\n      var c = str.charCodeAt(i) - 48;\n\n      r *= mul;\n\n      // 'a'\n      if (c >= 49) {\n        b = c - 49 + 0xa;\n\n      // 'A'\n      } else if (c >= 17) {\n        b = c - 17 + 0xa;\n\n      // '0' - '9'\n      } else {\n        b = c;\n      }\n      assert(c >= 0 && b < mul, 'Invalid character');\n      r += b;\n    }\n    return r;\n  }\n\n  BN.prototype._parseBase = function _parseBase (number, base, start) {\n    // Initialize as zero\n    this.words = [0];\n    this.length = 1;\n\n    // Find length of limb in base\n    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {\n      limbLen++;\n    }\n    limbLen--;\n    limbPow = (limbPow / base) | 0;\n\n    var total = number.length - start;\n    var mod = total % limbLen;\n    var end = Math.min(total, total - mod) + start;\n\n    var word = 0;\n    for (var i = start; i < end; i += limbLen) {\n      word = parseBase(number, i, i + limbLen, base);\n\n      this.imuln(limbPow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n\n    if (mod !== 0) {\n      var pow = 1;\n      word = parseBase(number, i, number.length, base);\n\n      for (i = 0; i < mod; i++) {\n        pow *= base;\n      }\n\n      this.imuln(pow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n\n    this._strip();\n  };\n\n  BN.prototype.copy = function copy (dest) {\n    dest.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      dest.words[i] = this.words[i];\n    }\n    dest.length = this.length;\n    dest.negative = this.negative;\n    dest.red = this.red;\n  };\n\n  function move (dest, src) {\n    dest.words = src.words;\n    dest.length = src.length;\n    dest.negative = src.negative;\n    dest.red = src.red;\n  }\n\n  BN.prototype._move = function _move (dest) {\n    move(dest, this);\n  };\n\n  BN.prototype.clone = function clone () {\n    var r = new BN(null);\n    this.copy(r);\n    return r;\n  };\n\n  BN.prototype._expand = function _expand (size) {\n    while (this.length < size) {\n      this.words[this.length++] = 0;\n    }\n    return this;\n  };\n\n  // Remove leading `0` from `this`\n  BN.prototype._strip = function strip () {\n    while (this.length > 1 && this.words[this.length - 1] === 0) {\n      this.length--;\n    }\n    return this._normSign();\n  };\n\n  BN.prototype._normSign = function _normSign () {\n    // -0 = 0\n    if (this.length === 1 && this.words[0] === 0) {\n      this.negative = 0;\n    }\n    return this;\n  };\n\n  // Check Symbol.for because not everywhere where Symbol defined\n  // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol#Browser_compatibility\n  if (typeof Symbol !== 'undefined' && typeof Symbol.for === 'function') {\n    try {\n      BN.prototype[Symbol.for('nodejs.util.inspect.custom')] = inspect;\n    } catch (e) {\n      BN.prototype.inspect = inspect;\n    }\n  } else {\n    BN.prototype.inspect = inspect;\n  }\n\n  function inspect () {\n    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';\n  }\n\n  /*\n\n  var zeros = [];\n  var groupSizes = [];\n  var groupBases = [];\n\n  var s = '';\n  var i = -1;\n  while (++i < BN.wordSize) {\n    zeros[i] = s;\n    s += '0';\n  }\n  groupSizes[0] = 0;\n  groupSizes[1] = 0;\n  groupBases[0] = 0;\n  groupBases[1] = 0;\n  var base = 2 - 1;\n  while (++base < 36 + 1) {\n    var groupSize = 0;\n    var groupBase = 1;\n    while (groupBase < (1 << BN.wordSize) / base) {\n      groupBase *= base;\n      groupSize += 1;\n    }\n    groupSizes[base] = groupSize;\n    groupBases[base] = groupBase;\n  }\n\n  */\n\n  var zeros = [\n    '',\n    '0',\n    '00',\n    '000',\n    '0000',\n    '00000',\n    '000000',\n    '0000000',\n    '00000000',\n    '000000000',\n    '0000000000',\n    '00000000000',\n    '000000000000',\n    '0000000000000',\n    '00000000000000',\n    '000000000000000',\n    '0000000000000000',\n    '00000000000000000',\n    '000000000000000000',\n    '0000000000000000000',\n    '00000000000000000000',\n    '000000000000000000000',\n    '0000000000000000000000',\n    '00000000000000000000000',\n    '000000000000000000000000',\n    '0000000000000000000000000'\n  ];\n\n  var groupSizes = [\n    0, 0,\n    25, 16, 12, 11, 10, 9, 8,\n    8, 7, 7, 7, 7, 6, 6,\n    6, 6, 6, 6, 6, 5, 5,\n    5, 5, 5, 5, 5, 5, 5,\n    5, 5, 5, 5, 5, 5, 5\n  ];\n\n  var groupBases = [\n    0, 0,\n    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,\n    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,\n    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,\n    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,\n    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176\n  ];\n\n  BN.prototype.toString = function toString (base, padding) {\n    base = base || 10;\n    padding = padding | 0 || 1;\n\n    var out;\n    if (base === 16 || base === 'hex') {\n      out = '';\n      var off = 0;\n      var carry = 0;\n      for (var i = 0; i < this.length; i++) {\n        var w = this.words[i];\n        var word = (((w << off) | carry) & 0xffffff).toString(16);\n        carry = (w >>> (24 - off)) & 0xffffff;\n        off += 2;\n        if (off >= 26) {\n          off -= 26;\n          i--;\n        }\n        if (carry !== 0 || i !== this.length - 1) {\n          out = zeros[6 - word.length] + word + out;\n        } else {\n          out = word + out;\n        }\n      }\n      if (carry !== 0) {\n        out = carry.toString(16) + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    if (base === (base | 0) && base >= 2 && base <= 36) {\n      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));\n      var groupSize = groupSizes[base];\n      // var groupBase = Math.pow(base, groupSize);\n      var groupBase = groupBases[base];\n      out = '';\n      var c = this.clone();\n      c.negative = 0;\n      while (!c.isZero()) {\n        var r = c.modrn(groupBase).toString(base);\n        c = c.idivn(groupBase);\n\n        if (!c.isZero()) {\n          out = zeros[groupSize - r.length] + r + out;\n        } else {\n          out = r + out;\n        }\n      }\n      if (this.isZero()) {\n        out = '0' + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    assert(false, 'Base should be between 2 and 36');\n  };\n\n  BN.prototype.toNumber = function toNumber () {\n    var ret = this.words[0];\n    if (this.length === 2) {\n      ret += this.words[1] * 0x4000000;\n    } else if (this.length === 3 && this.words[2] === 0x01) {\n      // NOTE: at this stage it is known that the top bit is set\n      ret += 0x10000000000000 + (this.words[1] * 0x4000000);\n    } else if (this.length > 2) {\n      assert(false, 'Number can only safely store up to 53 bits');\n    }\n    return (this.negative !== 0) ? -ret : ret;\n  };\n\n  BN.prototype.toJSON = function toJSON () {\n    return this.toString(16, 2);\n  };\n\n  if (Buffer) {\n    BN.prototype.toBuffer = function toBuffer (endian, length) {\n      return this.toArrayLike(Buffer, endian, length);\n    };\n  }\n\n  BN.prototype.toArray = function toArray (endian, length) {\n    return this.toArrayLike(Array, endian, length);\n  };\n\n  var allocate = function allocate (ArrayType, size) {\n    if (ArrayType.allocUnsafe) {\n      return ArrayType.allocUnsafe(size);\n    }\n    return new ArrayType(size);\n  };\n\n  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {\n    this._strip();\n\n    var byteLength = this.byteLength();\n    var reqLength = length || Math.max(1, byteLength);\n    assert(byteLength <= reqLength, 'byte array longer than desired length');\n    assert(reqLength > 0, 'Requested array length <= 0');\n\n    var res = allocate(ArrayType, reqLength);\n    var postfix = endian === 'le' ? 'LE' : 'BE';\n    this['_toArrayLike' + postfix](res, byteLength);\n    return res;\n  };\n\n  BN.prototype._toArrayLikeLE = function _toArrayLikeLE (res, byteLength) {\n    var position = 0;\n    var carry = 0;\n\n    for (var i = 0, shift = 0; i < this.length; i++) {\n      var word = (this.words[i] << shift) | carry;\n\n      res[position++] = word & 0xff;\n      if (position < res.length) {\n        res[position++] = (word >> 8) & 0xff;\n      }\n      if (position < res.length) {\n        res[position++] = (word >> 16) & 0xff;\n      }\n\n      if (shift === 6) {\n        if (position < res.length) {\n          res[position++] = (word >> 24) & 0xff;\n        }\n        carry = 0;\n        shift = 0;\n      } else {\n        carry = word >>> 24;\n        shift += 2;\n      }\n    }\n\n    if (position < res.length) {\n      res[position++] = carry;\n\n      while (position < res.length) {\n        res[position++] = 0;\n      }\n    }\n  };\n\n  BN.prototype._toArrayLikeBE = function _toArrayLikeBE (res, byteLength) {\n    var position = res.length - 1;\n    var carry = 0;\n\n    for (var i = 0, shift = 0; i < this.length; i++) {\n      var word = (this.words[i] << shift) | carry;\n\n      res[position--] = word & 0xff;\n      if (position >= 0) {\n        res[position--] = (word >> 8) & 0xff;\n      }\n      if (position >= 0) {\n        res[position--] = (word >> 16) & 0xff;\n      }\n\n      if (shift === 6) {\n        if (position >= 0) {\n          res[position--] = (word >> 24) & 0xff;\n        }\n        carry = 0;\n        shift = 0;\n      } else {\n        carry = word >>> 24;\n        shift += 2;\n      }\n    }\n\n    if (position >= 0) {\n      res[position--] = carry;\n\n      while (position >= 0) {\n        res[position--] = 0;\n      }\n    }\n  };\n\n  if (Math.clz32) {\n    BN.prototype._countBits = function _countBits (w) {\n      return 32 - Math.clz32(w);\n    };\n  } else {\n    BN.prototype._countBits = function _countBits (w) {\n      var t = w;\n      var r = 0;\n      if (t >= 0x1000) {\n        r += 13;\n        t >>>= 13;\n      }\n      if (t >= 0x40) {\n        r += 7;\n        t >>>= 7;\n      }\n      if (t >= 0x8) {\n        r += 4;\n        t >>>= 4;\n      }\n      if (t >= 0x02) {\n        r += 2;\n        t >>>= 2;\n      }\n      return r + t;\n    };\n  }\n\n  BN.prototype._zeroBits = function _zeroBits (w) {\n    // Short-cut\n    if (w === 0) return 26;\n\n    var t = w;\n    var r = 0;\n    if ((t & 0x1fff) === 0) {\n      r += 13;\n      t >>>= 13;\n    }\n    if ((t & 0x7f) === 0) {\n      r += 7;\n      t >>>= 7;\n    }\n    if ((t & 0xf) === 0) {\n      r += 4;\n      t >>>= 4;\n    }\n    if ((t & 0x3) === 0) {\n      r += 2;\n      t >>>= 2;\n    }\n    if ((t & 0x1) === 0) {\n      r++;\n    }\n    return r;\n  };\n\n  // Return number of used bits in a BN\n  BN.prototype.bitLength = function bitLength () {\n    var w = this.words[this.length - 1];\n    var hi = this._countBits(w);\n    return (this.length - 1) * 26 + hi;\n  };\n\n  function toBitArray (num) {\n    var w = new Array(num.bitLength());\n\n    for (var bit = 0; bit < w.length; bit++) {\n      var off = (bit / 26) | 0;\n      var wbit = bit % 26;\n\n      w[bit] = (num.words[off] >>> wbit) & 0x01;\n    }\n\n    return w;\n  }\n\n  // Number of trailing zero bits\n  BN.prototype.zeroBits = function zeroBits () {\n    if (this.isZero()) return 0;\n\n    var r = 0;\n    for (var i = 0; i < this.length; i++) {\n      var b = this._zeroBits(this.words[i]);\n      r += b;\n      if (b !== 26) break;\n    }\n    return r;\n  };\n\n  BN.prototype.byteLength = function byteLength () {\n    return Math.ceil(this.bitLength() / 8);\n  };\n\n  BN.prototype.toTwos = function toTwos (width) {\n    if (this.negative !== 0) {\n      return this.abs().inotn(width).iaddn(1);\n    }\n    return this.clone();\n  };\n\n  BN.prototype.fromTwos = function fromTwos (width) {\n    if (this.testn(width - 1)) {\n      return this.notn(width).iaddn(1).ineg();\n    }\n    return this.clone();\n  };\n\n  BN.prototype.isNeg = function isNeg () {\n    return this.negative !== 0;\n  };\n\n  // Return negative clone of `this`\n  BN.prototype.neg = function neg () {\n    return this.clone().ineg();\n  };\n\n  BN.prototype.ineg = function ineg () {\n    if (!this.isZero()) {\n      this.negative ^= 1;\n    }\n\n    return this;\n  };\n\n  // Or `num` with `this` in-place\n  BN.prototype.iuor = function iuor (num) {\n    while (this.length < num.length) {\n      this.words[this.length++] = 0;\n    }\n\n    for (var i = 0; i < num.length; i++) {\n      this.words[i] = this.words[i] | num.words[i];\n    }\n\n    return this._strip();\n  };\n\n  BN.prototype.ior = function ior (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuor(num);\n  };\n\n  // Or `num` with `this`\n  BN.prototype.or = function or (num) {\n    if (this.length > num.length) return this.clone().ior(num);\n    return num.clone().ior(this);\n  };\n\n  BN.prototype.uor = function uor (num) {\n    if (this.length > num.length) return this.clone().iuor(num);\n    return num.clone().iuor(this);\n  };\n\n  // And `num` with `this` in-place\n  BN.prototype.iuand = function iuand (num) {\n    // b = min-length(num, this)\n    var b;\n    if (this.length > num.length) {\n      b = num;\n    } else {\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = this.words[i] & num.words[i];\n    }\n\n    this.length = b.length;\n\n    return this._strip();\n  };\n\n  BN.prototype.iand = function iand (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuand(num);\n  };\n\n  // And `num` with `this`\n  BN.prototype.and = function and (num) {\n    if (this.length > num.length) return this.clone().iand(num);\n    return num.clone().iand(this);\n  };\n\n  BN.prototype.uand = function uand (num) {\n    if (this.length > num.length) return this.clone().iuand(num);\n    return num.clone().iuand(this);\n  };\n\n  // Xor `num` with `this` in-place\n  BN.prototype.iuxor = function iuxor (num) {\n    // a.length > b.length\n    var a;\n    var b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = a.words[i] ^ b.words[i];\n    }\n\n    if (this !== a) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = a.length;\n\n    return this._strip();\n  };\n\n  BN.prototype.ixor = function ixor (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuxor(num);\n  };\n\n  // Xor `num` with `this`\n  BN.prototype.xor = function xor (num) {\n    if (this.length > num.length) return this.clone().ixor(num);\n    return num.clone().ixor(this);\n  };\n\n  BN.prototype.uxor = function uxor (num) {\n    if (this.length > num.length) return this.clone().iuxor(num);\n    return num.clone().iuxor(this);\n  };\n\n  // Not ``this`` with ``width`` bitwidth\n  BN.prototype.inotn = function inotn (width) {\n    assert(typeof width === 'number' && width >= 0);\n\n    var bytesNeeded = Math.ceil(width / 26) | 0;\n    var bitsLeft = width % 26;\n\n    // Extend the buffer with leading zeroes\n    this._expand(bytesNeeded);\n\n    if (bitsLeft > 0) {\n      bytesNeeded--;\n    }\n\n    // Handle complete words\n    for (var i = 0; i < bytesNeeded; i++) {\n      this.words[i] = ~this.words[i] & 0x3ffffff;\n    }\n\n    // Handle the residue\n    if (bitsLeft > 0) {\n      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));\n    }\n\n    // And remove leading zeroes\n    return this._strip();\n  };\n\n  BN.prototype.notn = function notn (width) {\n    return this.clone().inotn(width);\n  };\n\n  // Set `bit` of `this`\n  BN.prototype.setn = function setn (bit, val) {\n    assert(typeof bit === 'number' && bit >= 0);\n\n    var off = (bit / 26) | 0;\n    var wbit = bit % 26;\n\n    this._expand(off + 1);\n\n    if (val) {\n      this.words[off] = this.words[off] | (1 << wbit);\n    } else {\n      this.words[off] = this.words[off] & ~(1 << wbit);\n    }\n\n    return this._strip();\n  };\n\n  // Add `num` to `this` in-place\n  BN.prototype.iadd = function iadd (num) {\n    var r;\n\n    // negative + positive\n    if (this.negative !== 0 && num.negative === 0) {\n      this.negative = 0;\n      r = this.isub(num);\n      this.negative ^= 1;\n      return this._normSign();\n\n    // positive + negative\n    } else if (this.negative === 0 && num.negative !== 0) {\n      num.negative = 0;\n      r = this.isub(num);\n      num.negative = 1;\n      return r._normSign();\n    }\n\n    // a.length > b.length\n    var a, b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n\n    this.length = a.length;\n    if (carry !== 0) {\n      this.words[this.length] = carry;\n      this.length++;\n    // Copy the rest of the words\n    } else if (a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    return this;\n  };\n\n  // Add `num` to `this`\n  BN.prototype.add = function add (num) {\n    var res;\n    if (num.negative !== 0 && this.negative === 0) {\n      num.negative = 0;\n      res = this.sub(num);\n      num.negative ^= 1;\n      return res;\n    } else if (num.negative === 0 && this.negative !== 0) {\n      this.negative = 0;\n      res = num.sub(this);\n      this.negative = 1;\n      return res;\n    }\n\n    if (this.length > num.length) return this.clone().iadd(num);\n\n    return num.clone().iadd(this);\n  };\n\n  // Subtract `num` from `this` in-place\n  BN.prototype.isub = function isub (num) {\n    // this - (-num) = this + num\n    if (num.negative !== 0) {\n      num.negative = 0;\n      var r = this.iadd(num);\n      num.negative = 1;\n      return r._normSign();\n\n    // -this - num = -(this + num)\n    } else if (this.negative !== 0) {\n      this.negative = 0;\n      this.iadd(num);\n      this.negative = 1;\n      return this._normSign();\n    }\n\n    // At this point both numbers are positive\n    var cmp = this.cmp(num);\n\n    // Optimization - zeroify\n    if (cmp === 0) {\n      this.negative = 0;\n      this.length = 1;\n      this.words[0] = 0;\n      return this;\n    }\n\n    // a > b\n    var a, b;\n    if (cmp > 0) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n\n    // Copy rest of the words\n    if (carry === 0 && i < a.length && a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = Math.max(this.length, i);\n\n    if (a !== this) {\n      this.negative = 1;\n    }\n\n    return this._strip();\n  };\n\n  // Subtract `num` from `this`\n  BN.prototype.sub = function sub (num) {\n    return this.clone().isub(num);\n  };\n\n  function smallMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    var len = (self.length + num.length) | 0;\n    out.length = len;\n    len = (len - 1) | 0;\n\n    // Peel one iteration (compiler can't do it, because of code complexity)\n    var a = self.words[0] | 0;\n    var b = num.words[0] | 0;\n    var r = a * b;\n\n    var lo = r & 0x3ffffff;\n    var carry = (r / 0x4000000) | 0;\n    out.words[0] = lo;\n\n    for (var k = 1; k < len; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = carry >>> 26;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = (k - j) | 0;\n        a = self.words[i] | 0;\n        b = num.words[j] | 0;\n        r = a * b + rword;\n        ncarry += (r / 0x4000000) | 0;\n        rword = r & 0x3ffffff;\n      }\n      out.words[k] = rword | 0;\n      carry = ncarry | 0;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry | 0;\n    } else {\n      out.length--;\n    }\n\n    return out._strip();\n  }\n\n  // TODO(indutny): it may be reasonable to omit it for users who don't need\n  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit\n  // multiplication (like elliptic secp256k1).\n  var comb10MulTo = function comb10MulTo (self, num, out) {\n    var a = self.words;\n    var b = num.words;\n    var o = out.words;\n    var c = 0;\n    var lo;\n    var mid;\n    var hi;\n    var a0 = a[0] | 0;\n    var al0 = a0 & 0x1fff;\n    var ah0 = a0 >>> 13;\n    var a1 = a[1] | 0;\n    var al1 = a1 & 0x1fff;\n    var ah1 = a1 >>> 13;\n    var a2 = a[2] | 0;\n    var al2 = a2 & 0x1fff;\n    var ah2 = a2 >>> 13;\n    var a3 = a[3] | 0;\n    var al3 = a3 & 0x1fff;\n    var ah3 = a3 >>> 13;\n    var a4 = a[4] | 0;\n    var al4 = a4 & 0x1fff;\n    var ah4 = a4 >>> 13;\n    var a5 = a[5] | 0;\n    var al5 = a5 & 0x1fff;\n    var ah5 = a5 >>> 13;\n    var a6 = a[6] | 0;\n    var al6 = a6 & 0x1fff;\n    var ah6 = a6 >>> 13;\n    var a7 = a[7] | 0;\n    var al7 = a7 & 0x1fff;\n    var ah7 = a7 >>> 13;\n    var a8 = a[8] | 0;\n    var al8 = a8 & 0x1fff;\n    var ah8 = a8 >>> 13;\n    var a9 = a[9] | 0;\n    var al9 = a9 & 0x1fff;\n    var ah9 = a9 >>> 13;\n    var b0 = b[0] | 0;\n    var bl0 = b0 & 0x1fff;\n    var bh0 = b0 >>> 13;\n    var b1 = b[1] | 0;\n    var bl1 = b1 & 0x1fff;\n    var bh1 = b1 >>> 13;\n    var b2 = b[2] | 0;\n    var bl2 = b2 & 0x1fff;\n    var bh2 = b2 >>> 13;\n    var b3 = b[3] | 0;\n    var bl3 = b3 & 0x1fff;\n    var bh3 = b3 >>> 13;\n    var b4 = b[4] | 0;\n    var bl4 = b4 & 0x1fff;\n    var bh4 = b4 >>> 13;\n    var b5 = b[5] | 0;\n    var bl5 = b5 & 0x1fff;\n    var bh5 = b5 >>> 13;\n    var b6 = b[6] | 0;\n    var bl6 = b6 & 0x1fff;\n    var bh6 = b6 >>> 13;\n    var b7 = b[7] | 0;\n    var bl7 = b7 & 0x1fff;\n    var bh7 = b7 >>> 13;\n    var b8 = b[8] | 0;\n    var bl8 = b8 & 0x1fff;\n    var bh8 = b8 >>> 13;\n    var b9 = b[9] | 0;\n    var bl9 = b9 & 0x1fff;\n    var bh9 = b9 >>> 13;\n\n    out.negative = self.negative ^ num.negative;\n    out.length = 19;\n    /* k = 0 */\n    lo = Math.imul(al0, bl0);\n    mid = Math.imul(al0, bh0);\n    mid = (mid + Math.imul(ah0, bl0)) | 0;\n    hi = Math.imul(ah0, bh0);\n    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;\n    w0 &= 0x3ffffff;\n    /* k = 1 */\n    lo = Math.imul(al1, bl0);\n    mid = Math.imul(al1, bh0);\n    mid = (mid + Math.imul(ah1, bl0)) | 0;\n    hi = Math.imul(ah1, bh0);\n    lo = (lo + Math.imul(al0, bl1)) | 0;\n    mid = (mid + Math.imul(al0, bh1)) | 0;\n    mid = (mid + Math.imul(ah0, bl1)) | 0;\n    hi = (hi + Math.imul(ah0, bh1)) | 0;\n    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;\n    w1 &= 0x3ffffff;\n    /* k = 2 */\n    lo = Math.imul(al2, bl0);\n    mid = Math.imul(al2, bh0);\n    mid = (mid + Math.imul(ah2, bl0)) | 0;\n    hi = Math.imul(ah2, bh0);\n    lo = (lo + Math.imul(al1, bl1)) | 0;\n    mid = (mid + Math.imul(al1, bh1)) | 0;\n    mid = (mid + Math.imul(ah1, bl1)) | 0;\n    hi = (hi + Math.imul(ah1, bh1)) | 0;\n    lo = (lo + Math.imul(al0, bl2)) | 0;\n    mid = (mid + Math.imul(al0, bh2)) | 0;\n    mid = (mid + Math.imul(ah0, bl2)) | 0;\n    hi = (hi + Math.imul(ah0, bh2)) | 0;\n    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;\n    w2 &= 0x3ffffff;\n    /* k = 3 */\n    lo = Math.imul(al3, bl0);\n    mid = Math.imul(al3, bh0);\n    mid = (mid + Math.imul(ah3, bl0)) | 0;\n    hi = Math.imul(ah3, bh0);\n    lo = (lo + Math.imul(al2, bl1)) | 0;\n    mid = (mid + Math.imul(al2, bh1)) | 0;\n    mid = (mid + Math.imul(ah2, bl1)) | 0;\n    hi = (hi + Math.imul(ah2, bh1)) | 0;\n    lo = (lo + Math.imul(al1, bl2)) | 0;\n    mid = (mid + Math.imul(al1, bh2)) | 0;\n    mid = (mid + Math.imul(ah1, bl2)) | 0;\n    hi = (hi + Math.imul(ah1, bh2)) | 0;\n    lo = (lo + Math.imul(al0, bl3)) | 0;\n    mid = (mid + Math.imul(al0, bh3)) | 0;\n    mid = (mid + Math.imul(ah0, bl3)) | 0;\n    hi = (hi + Math.imul(ah0, bh3)) | 0;\n    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;\n    w3 &= 0x3ffffff;\n    /* k = 4 */\n    lo = Math.imul(al4, bl0);\n    mid = Math.imul(al4, bh0);\n    mid = (mid + Math.imul(ah4, bl0)) | 0;\n    hi = Math.imul(ah4, bh0);\n    lo = (lo + Math.imul(al3, bl1)) | 0;\n    mid = (mid + Math.imul(al3, bh1)) | 0;\n    mid = (mid + Math.imul(ah3, bl1)) | 0;\n    hi = (hi + Math.imul(ah3, bh1)) | 0;\n    lo = (lo + Math.imul(al2, bl2)) | 0;\n    mid = (mid + Math.imul(al2, bh2)) | 0;\n    mid = (mid + Math.imul(ah2, bl2)) | 0;\n    hi = (hi + Math.imul(ah2, bh2)) | 0;\n    lo = (lo + Math.imul(al1, bl3)) | 0;\n    mid = (mid + Math.imul(al1, bh3)) | 0;\n    mid = (mid + Math.imul(ah1, bl3)) | 0;\n    hi = (hi + Math.imul(ah1, bh3)) | 0;\n    lo = (lo + Math.imul(al0, bl4)) | 0;\n    mid = (mid + Math.imul(al0, bh4)) | 0;\n    mid = (mid + Math.imul(ah0, bl4)) | 0;\n    hi = (hi + Math.imul(ah0, bh4)) | 0;\n    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;\n    w4 &= 0x3ffffff;\n    /* k = 5 */\n    lo = Math.imul(al5, bl0);\n    mid = Math.imul(al5, bh0);\n    mid = (mid + Math.imul(ah5, bl0)) | 0;\n    hi = Math.imul(ah5, bh0);\n    lo = (lo + Math.imul(al4, bl1)) | 0;\n    mid = (mid + Math.imul(al4, bh1)) | 0;\n    mid = (mid + Math.imul(ah4, bl1)) | 0;\n    hi = (hi + Math.imul(ah4, bh1)) | 0;\n    lo = (lo + Math.imul(al3, bl2)) | 0;\n    mid = (mid + Math.imul(al3, bh2)) | 0;\n    mid = (mid + Math.imul(ah3, bl2)) | 0;\n    hi = (hi + Math.imul(ah3, bh2)) | 0;\n    lo = (lo + Math.imul(al2, bl3)) | 0;\n    mid = (mid + Math.imul(al2, bh3)) | 0;\n    mid = (mid + Math.imul(ah2, bl3)) | 0;\n    hi = (hi + Math.imul(ah2, bh3)) | 0;\n    lo = (lo + Math.imul(al1, bl4)) | 0;\n    mid = (mid + Math.imul(al1, bh4)) | 0;\n    mid = (mid + Math.imul(ah1, bl4)) | 0;\n    hi = (hi + Math.imul(ah1, bh4)) | 0;\n    lo = (lo + Math.imul(al0, bl5)) | 0;\n    mid = (mid + Math.imul(al0, bh5)) | 0;\n    mid = (mid + Math.imul(ah0, bl5)) | 0;\n    hi = (hi + Math.imul(ah0, bh5)) | 0;\n    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;\n    w5 &= 0x3ffffff;\n    /* k = 6 */\n    lo = Math.imul(al6, bl0);\n    mid = Math.imul(al6, bh0);\n    mid = (mid + Math.imul(ah6, bl0)) | 0;\n    hi = Math.imul(ah6, bh0);\n    lo = (lo + Math.imul(al5, bl1)) | 0;\n    mid = (mid + Math.imul(al5, bh1)) | 0;\n    mid = (mid + Math.imul(ah5, bl1)) | 0;\n    hi = (hi + Math.imul(ah5, bh1)) | 0;\n    lo = (lo + Math.imul(al4, bl2)) | 0;\n    mid = (mid + Math.imul(al4, bh2)) | 0;\n    mid = (mid + Math.imul(ah4, bl2)) | 0;\n    hi = (hi + Math.imul(ah4, bh2)) | 0;\n    lo = (lo + Math.imul(al3, bl3)) | 0;\n    mid = (mid + Math.imul(al3, bh3)) | 0;\n    mid = (mid + Math.imul(ah3, bl3)) | 0;\n    hi = (hi + Math.imul(ah3, bh3)) | 0;\n    lo = (lo + Math.imul(al2, bl4)) | 0;\n    mid = (mid + Math.imul(al2, bh4)) | 0;\n    mid = (mid + Math.imul(ah2, bl4)) | 0;\n    hi = (hi + Math.imul(ah2, bh4)) | 0;\n    lo = (lo + Math.imul(al1, bl5)) | 0;\n    mid = (mid + Math.imul(al1, bh5)) | 0;\n    mid = (mid + Math.imul(ah1, bl5)) | 0;\n    hi = (hi + Math.imul(ah1, bh5)) | 0;\n    lo = (lo + Math.imul(al0, bl6)) | 0;\n    mid = (mid + Math.imul(al0, bh6)) | 0;\n    mid = (mid + Math.imul(ah0, bl6)) | 0;\n    hi = (hi + Math.imul(ah0, bh6)) | 0;\n    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;\n    w6 &= 0x3ffffff;\n    /* k = 7 */\n    lo = Math.imul(al7, bl0);\n    mid = Math.imul(al7, bh0);\n    mid = (mid + Math.imul(ah7, bl0)) | 0;\n    hi = Math.imul(ah7, bh0);\n    lo = (lo + Math.imul(al6, bl1)) | 0;\n    mid = (mid + Math.imul(al6, bh1)) | 0;\n    mid = (mid + Math.imul(ah6, bl1)) | 0;\n    hi = (hi + Math.imul(ah6, bh1)) | 0;\n    lo = (lo + Math.imul(al5, bl2)) | 0;\n    mid = (mid + Math.imul(al5, bh2)) | 0;\n    mid = (mid + Math.imul(ah5, bl2)) | 0;\n    hi = (hi + Math.imul(ah5, bh2)) | 0;\n    lo = (lo + Math.imul(al4, bl3)) | 0;\n    mid = (mid + Math.imul(al4, bh3)) | 0;\n    mid = (mid + Math.imul(ah4, bl3)) | 0;\n    hi = (hi + Math.imul(ah4, bh3)) | 0;\n    lo = (lo + Math.imul(al3, bl4)) | 0;\n    mid = (mid + Math.imul(al3, bh4)) | 0;\n    mid = (mid + Math.imul(ah3, bl4)) | 0;\n    hi = (hi + Math.imul(ah3, bh4)) | 0;\n    lo = (lo + Math.imul(al2, bl5)) | 0;\n    mid = (mid + Math.imul(al2, bh5)) | 0;\n    mid = (mid + Math.imul(ah2, bl5)) | 0;\n    hi = (hi + Math.imul(ah2, bh5)) | 0;\n    lo = (lo + Math.imul(al1, bl6)) | 0;\n    mid = (mid + Math.imul(al1, bh6)) | 0;\n    mid = (mid + Math.imul(ah1, bl6)) | 0;\n    hi = (hi + Math.imul(ah1, bh6)) | 0;\n    lo = (lo + Math.imul(al0, bl7)) | 0;\n    mid = (mid + Math.imul(al0, bh7)) | 0;\n    mid = (mid + Math.imul(ah0, bl7)) | 0;\n    hi = (hi + Math.imul(ah0, bh7)) | 0;\n    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;\n    w7 &= 0x3ffffff;\n    /* k = 8 */\n    lo = Math.imul(al8, bl0);\n    mid = Math.imul(al8, bh0);\n    mid = (mid + Math.imul(ah8, bl0)) | 0;\n    hi = Math.imul(ah8, bh0);\n    lo = (lo + Math.imul(al7, bl1)) | 0;\n    mid = (mid + Math.imul(al7, bh1)) | 0;\n    mid = (mid + Math.imul(ah7, bl1)) | 0;\n    hi = (hi + Math.imul(ah7, bh1)) | 0;\n    lo = (lo + Math.imul(al6, bl2)) | 0;\n    mid = (mid + Math.imul(al6, bh2)) | 0;\n    mid = (mid + Math.imul(ah6, bl2)) | 0;\n    hi = (hi + Math.imul(ah6, bh2)) | 0;\n    lo = (lo + Math.imul(al5, bl3)) | 0;\n    mid = (mid + Math.imul(al5, bh3)) | 0;\n    mid = (mid + Math.imul(ah5, bl3)) | 0;\n    hi = (hi + Math.imul(ah5, bh3)) | 0;\n    lo = (lo + Math.imul(al4, bl4)) | 0;\n    mid = (mid + Math.imul(al4, bh4)) | 0;\n    mid = (mid + Math.imul(ah4, bl4)) | 0;\n    hi = (hi + Math.imul(ah4, bh4)) | 0;\n    lo = (lo + Math.imul(al3, bl5)) | 0;\n    mid = (mid + Math.imul(al3, bh5)) | 0;\n    mid = (mid + Math.imul(ah3, bl5)) | 0;\n    hi = (hi + Math.imul(ah3, bh5)) | 0;\n    lo = (lo + Math.imul(al2, bl6)) | 0;\n    mid = (mid + Math.imul(al2, bh6)) | 0;\n    mid = (mid + Math.imul(ah2, bl6)) | 0;\n    hi = (hi + Math.imul(ah2, bh6)) | 0;\n    lo = (lo + Math.imul(al1, bl7)) | 0;\n    mid = (mid + Math.imul(al1, bh7)) | 0;\n    mid = (mid + Math.imul(ah1, bl7)) | 0;\n    hi = (hi + Math.imul(ah1, bh7)) | 0;\n    lo = (lo + Math.imul(al0, bl8)) | 0;\n    mid = (mid + Math.imul(al0, bh8)) | 0;\n    mid = (mid + Math.imul(ah0, bl8)) | 0;\n    hi = (hi + Math.imul(ah0, bh8)) | 0;\n    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;\n    w8 &= 0x3ffffff;\n    /* k = 9 */\n    lo = Math.imul(al9, bl0);\n    mid = Math.imul(al9, bh0);\n    mid = (mid + Math.imul(ah9, bl0)) | 0;\n    hi = Math.imul(ah9, bh0);\n    lo = (lo + Math.imul(al8, bl1)) | 0;\n    mid = (mid + Math.imul(al8, bh1)) | 0;\n    mid = (mid + Math.imul(ah8, bl1)) | 0;\n    hi = (hi + Math.imul(ah8, bh1)) | 0;\n    lo = (lo + Math.imul(al7, bl2)) | 0;\n    mid = (mid + Math.imul(al7, bh2)) | 0;\n    mid = (mid + Math.imul(ah7, bl2)) | 0;\n    hi = (hi + Math.imul(ah7, bh2)) | 0;\n    lo = (lo + Math.imul(al6, bl3)) | 0;\n    mid = (mid + Math.imul(al6, bh3)) | 0;\n    mid = (mid + Math.imul(ah6, bl3)) | 0;\n    hi = (hi + Math.imul(ah6, bh3)) | 0;\n    lo = (lo + Math.imul(al5, bl4)) | 0;\n    mid = (mid + Math.imul(al5, bh4)) | 0;\n    mid = (mid + Math.imul(ah5, bl4)) | 0;\n    hi = (hi + Math.imul(ah5, bh4)) | 0;\n    lo = (lo + Math.imul(al4, bl5)) | 0;\n    mid = (mid + Math.imul(al4, bh5)) | 0;\n    mid = (mid + Math.imul(ah4, bl5)) | 0;\n    hi = (hi + Math.imul(ah4, bh5)) | 0;\n    lo = (lo + Math.imul(al3, bl6)) | 0;\n    mid = (mid + Math.imul(al3, bh6)) | 0;\n    mid = (mid + Math.imul(ah3, bl6)) | 0;\n    hi = (hi + Math.imul(ah3, bh6)) | 0;\n    lo = (lo + Math.imul(al2, bl7)) | 0;\n    mid = (mid + Math.imul(al2, bh7)) | 0;\n    mid = (mid + Math.imul(ah2, bl7)) | 0;\n    hi = (hi + Math.imul(ah2, bh7)) | 0;\n    lo = (lo + Math.imul(al1, bl8)) | 0;\n    mid = (mid + Math.imul(al1, bh8)) | 0;\n    mid = (mid + Math.imul(ah1, bl8)) | 0;\n    hi = (hi + Math.imul(ah1, bh8)) | 0;\n    lo = (lo + Math.imul(al0, bl9)) | 0;\n    mid = (mid + Math.imul(al0, bh9)) | 0;\n    mid = (mid + Math.imul(ah0, bl9)) | 0;\n    hi = (hi + Math.imul(ah0, bh9)) | 0;\n    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;\n    w9 &= 0x3ffffff;\n    /* k = 10 */\n    lo = Math.imul(al9, bl1);\n    mid = Math.imul(al9, bh1);\n    mid = (mid + Math.imul(ah9, bl1)) | 0;\n    hi = Math.imul(ah9, bh1);\n    lo = (lo + Math.imul(al8, bl2)) | 0;\n    mid = (mid + Math.imul(al8, bh2)) | 0;\n    mid = (mid + Math.imul(ah8, bl2)) | 0;\n    hi = (hi + Math.imul(ah8, bh2)) | 0;\n    lo = (lo + Math.imul(al7, bl3)) | 0;\n    mid = (mid + Math.imul(al7, bh3)) | 0;\n    mid = (mid + Math.imul(ah7, bl3)) | 0;\n    hi = (hi + Math.imul(ah7, bh3)) | 0;\n    lo = (lo + Math.imul(al6, bl4)) | 0;\n    mid = (mid + Math.imul(al6, bh4)) | 0;\n    mid = (mid + Math.imul(ah6, bl4)) | 0;\n    hi = (hi + Math.imul(ah6, bh4)) | 0;\n    lo = (lo + Math.imul(al5, bl5)) | 0;\n    mid = (mid + Math.imul(al5, bh5)) | 0;\n    mid = (mid + Math.imul(ah5, bl5)) | 0;\n    hi = (hi + Math.imul(ah5, bh5)) | 0;\n    lo = (lo + Math.imul(al4, bl6)) | 0;\n    mid = (mid + Math.imul(al4, bh6)) | 0;\n    mid = (mid + Math.imul(ah4, bl6)) | 0;\n    hi = (hi + Math.imul(ah4, bh6)) | 0;\n    lo = (lo + Math.imul(al3, bl7)) | 0;\n    mid = (mid + Math.imul(al3, bh7)) | 0;\n    mid = (mid + Math.imul(ah3, bl7)) | 0;\n    hi = (hi + Math.imul(ah3, bh7)) | 0;\n    lo = (lo + Math.imul(al2, bl8)) | 0;\n    mid = (mid + Math.imul(al2, bh8)) | 0;\n    mid = (mid + Math.imul(ah2, bl8)) | 0;\n    hi = (hi + Math.imul(ah2, bh8)) | 0;\n    lo = (lo + Math.imul(al1, bl9)) | 0;\n    mid = (mid + Math.imul(al1, bh9)) | 0;\n    mid = (mid + Math.imul(ah1, bl9)) | 0;\n    hi = (hi + Math.imul(ah1, bh9)) | 0;\n    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;\n    w10 &= 0x3ffffff;\n    /* k = 11 */\n    lo = Math.imul(al9, bl2);\n    mid = Math.imul(al9, bh2);\n    mid = (mid + Math.imul(ah9, bl2)) | 0;\n    hi = Math.imul(ah9, bh2);\n    lo = (lo + Math.imul(al8, bl3)) | 0;\n    mid = (mid + Math.imul(al8, bh3)) | 0;\n    mid = (mid + Math.imul(ah8, bl3)) | 0;\n    hi = (hi + Math.imul(ah8, bh3)) | 0;\n    lo = (lo + Math.imul(al7, bl4)) | 0;\n    mid = (mid + Math.imul(al7, bh4)) | 0;\n    mid = (mid + Math.imul(ah7, bl4)) | 0;\n    hi = (hi + Math.imul(ah7, bh4)) | 0;\n    lo = (lo + Math.imul(al6, bl5)) | 0;\n    mid = (mid + Math.imul(al6, bh5)) | 0;\n    mid = (mid + Math.imul(ah6, bl5)) | 0;\n    hi = (hi + Math.imul(ah6, bh5)) | 0;\n    lo = (lo + Math.imul(al5, bl6)) | 0;\n    mid = (mid + Math.imul(al5, bh6)) | 0;\n    mid = (mid + Math.imul(ah5, bl6)) | 0;\n    hi = (hi + Math.imul(ah5, bh6)) | 0;\n    lo = (lo + Math.imul(al4, bl7)) | 0;\n    mid = (mid + Math.imul(al4, bh7)) | 0;\n    mid = (mid + Math.imul(ah4, bl7)) | 0;\n    hi = (hi + Math.imul(ah4, bh7)) | 0;\n    lo = (lo + Math.imul(al3, bl8)) | 0;\n    mid = (mid + Math.imul(al3, bh8)) | 0;\n    mid = (mid + Math.imul(ah3, bl8)) | 0;\n    hi = (hi + Math.imul(ah3, bh8)) | 0;\n    lo = (lo + Math.imul(al2, bl9)) | 0;\n    mid = (mid + Math.imul(al2, bh9)) | 0;\n    mid = (mid + Math.imul(ah2, bl9)) | 0;\n    hi = (hi + Math.imul(ah2, bh9)) | 0;\n    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;\n    w11 &= 0x3ffffff;\n    /* k = 12 */\n    lo = Math.imul(al9, bl3);\n    mid = Math.imul(al9, bh3);\n    mid = (mid + Math.imul(ah9, bl3)) | 0;\n    hi = Math.imul(ah9, bh3);\n    lo = (lo + Math.imul(al8, bl4)) | 0;\n    mid = (mid + Math.imul(al8, bh4)) | 0;\n    mid = (mid + Math.imul(ah8, bl4)) | 0;\n    hi = (hi + Math.imul(ah8, bh4)) | 0;\n    lo = (lo + Math.imul(al7, bl5)) | 0;\n    mid = (mid + Math.imul(al7, bh5)) | 0;\n    mid = (mid + Math.imul(ah7, bl5)) | 0;\n    hi = (hi + Math.imul(ah7, bh5)) | 0;\n    lo = (lo + Math.imul(al6, bl6)) | 0;\n    mid = (mid + Math.imul(al6, bh6)) | 0;\n    mid = (mid + Math.imul(ah6, bl6)) | 0;\n    hi = (hi + Math.imul(ah6, bh6)) | 0;\n    lo = (lo + Math.imul(al5, bl7)) | 0;\n    mid = (mid + Math.imul(al5, bh7)) | 0;\n    mid = (mid + Math.imul(ah5, bl7)) | 0;\n    hi = (hi + Math.imul(ah5, bh7)) | 0;\n    lo = (lo + Math.imul(al4, bl8)) | 0;\n    mid = (mid + Math.imul(al4, bh8)) | 0;\n    mid = (mid + Math.imul(ah4, bl8)) | 0;\n    hi = (hi + Math.imul(ah4, bh8)) | 0;\n    lo = (lo + Math.imul(al3, bl9)) | 0;\n    mid = (mid + Math.imul(al3, bh9)) | 0;\n    mid = (mid + Math.imul(ah3, bl9)) | 0;\n    hi = (hi + Math.imul(ah3, bh9)) | 0;\n    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;\n    w12 &= 0x3ffffff;\n    /* k = 13 */\n    lo = Math.imul(al9, bl4);\n    mid = Math.imul(al9, bh4);\n    mid = (mid + Math.imul(ah9, bl4)) | 0;\n    hi = Math.imul(ah9, bh4);\n    lo = (lo + Math.imul(al8, bl5)) | 0;\n    mid = (mid + Math.imul(al8, bh5)) | 0;\n    mid = (mid + Math.imul(ah8, bl5)) | 0;\n    hi = (hi + Math.imul(ah8, bh5)) | 0;\n    lo = (lo + Math.imul(al7, bl6)) | 0;\n    mid = (mid + Math.imul(al7, bh6)) | 0;\n    mid = (mid + Math.imul(ah7, bl6)) | 0;\n    hi = (hi + Math.imul(ah7, bh6)) | 0;\n    lo = (lo + Math.imul(al6, bl7)) | 0;\n    mid = (mid + Math.imul(al6, bh7)) | 0;\n    mid = (mid + Math.imul(ah6, bl7)) | 0;\n    hi = (hi + Math.imul(ah6, bh7)) | 0;\n    lo = (lo + Math.imul(al5, bl8)) | 0;\n    mid = (mid + Math.imul(al5, bh8)) | 0;\n    mid = (mid + Math.imul(ah5, bl8)) | 0;\n    hi = (hi + Math.imul(ah5, bh8)) | 0;\n    lo = (lo + Math.imul(al4, bl9)) | 0;\n    mid = (mid + Math.imul(al4, bh9)) | 0;\n    mid = (mid + Math.imul(ah4, bl9)) | 0;\n    hi = (hi + Math.imul(ah4, bh9)) | 0;\n    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;\n    w13 &= 0x3ffffff;\n    /* k = 14 */\n    lo = Math.imul(al9, bl5);\n    mid = Math.imul(al9, bh5);\n    mid = (mid + Math.imul(ah9, bl5)) | 0;\n    hi = Math.imul(ah9, bh5);\n    lo = (lo + Math.imul(al8, bl6)) | 0;\n    mid = (mid + Math.imul(al8, bh6)) | 0;\n    mid = (mid + Math.imul(ah8, bl6)) | 0;\n    hi = (hi + Math.imul(ah8, bh6)) | 0;\n    lo = (lo + Math.imul(al7, bl7)) | 0;\n    mid = (mid + Math.imul(al7, bh7)) | 0;\n    mid = (mid + Math.imul(ah7, bl7)) | 0;\n    hi = (hi + Math.imul(ah7, bh7)) | 0;\n    lo = (lo + Math.imul(al6, bl8)) | 0;\n    mid = (mid + Math.imul(al6, bh8)) | 0;\n    mid = (mid + Math.imul(ah6, bl8)) | 0;\n    hi = (hi + Math.imul(ah6, bh8)) | 0;\n    lo = (lo + Math.imul(al5, bl9)) | 0;\n    mid = (mid + Math.imul(al5, bh9)) | 0;\n    mid = (mid + Math.imul(ah5, bl9)) | 0;\n    hi = (hi + Math.imul(ah5, bh9)) | 0;\n    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;\n    w14 &= 0x3ffffff;\n    /* k = 15 */\n    lo = Math.imul(al9, bl6);\n    mid = Math.imul(al9, bh6);\n    mid = (mid + Math.imul(ah9, bl6)) | 0;\n    hi = Math.imul(ah9, bh6);\n    lo = (lo + Math.imul(al8, bl7)) | 0;\n    mid = (mid + Math.imul(al8, bh7)) | 0;\n    mid = (mid + Math.imul(ah8, bl7)) | 0;\n    hi = (hi + Math.imul(ah8, bh7)) | 0;\n    lo = (lo + Math.imul(al7, bl8)) | 0;\n    mid = (mid + Math.imul(al7, bh8)) | 0;\n    mid = (mid + Math.imul(ah7, bl8)) | 0;\n    hi = (hi + Math.imul(ah7, bh8)) | 0;\n    lo = (lo + Math.imul(al6, bl9)) | 0;\n    mid = (mid + Math.imul(al6, bh9)) | 0;\n    mid = (mid + Math.imul(ah6, bl9)) | 0;\n    hi = (hi + Math.imul(ah6, bh9)) | 0;\n    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;\n    w15 &= 0x3ffffff;\n    /* k = 16 */\n    lo = Math.imul(al9, bl7);\n    mid = Math.imul(al9, bh7);\n    mid = (mid + Math.imul(ah9, bl7)) | 0;\n    hi = Math.imul(ah9, bh7);\n    lo = (lo + Math.imul(al8, bl8)) | 0;\n    mid = (mid + Math.imul(al8, bh8)) | 0;\n    mid = (mid + Math.imul(ah8, bl8)) | 0;\n    hi = (hi + Math.imul(ah8, bh8)) | 0;\n    lo = (lo + Math.imul(al7, bl9)) | 0;\n    mid = (mid + Math.imul(al7, bh9)) | 0;\n    mid = (mid + Math.imul(ah7, bl9)) | 0;\n    hi = (hi + Math.imul(ah7, bh9)) | 0;\n    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;\n    w16 &= 0x3ffffff;\n    /* k = 17 */\n    lo = Math.imul(al9, bl8);\n    mid = Math.imul(al9, bh8);\n    mid = (mid + Math.imul(ah9, bl8)) | 0;\n    hi = Math.imul(ah9, bh8);\n    lo = (lo + Math.imul(al8, bl9)) | 0;\n    mid = (mid + Math.imul(al8, bh9)) | 0;\n    mid = (mid + Math.imul(ah8, bl9)) | 0;\n    hi = (hi + Math.imul(ah8, bh9)) | 0;\n    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;\n    w17 &= 0x3ffffff;\n    /* k = 18 */\n    lo = Math.imul(al9, bl9);\n    mid = Math.imul(al9, bh9);\n    mid = (mid + Math.imul(ah9, bl9)) | 0;\n    hi = Math.imul(ah9, bh9);\n    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;\n    w18 &= 0x3ffffff;\n    o[0] = w0;\n    o[1] = w1;\n    o[2] = w2;\n    o[3] = w3;\n    o[4] = w4;\n    o[5] = w5;\n    o[6] = w6;\n    o[7] = w7;\n    o[8] = w8;\n    o[9] = w9;\n    o[10] = w10;\n    o[11] = w11;\n    o[12] = w12;\n    o[13] = w13;\n    o[14] = w14;\n    o[15] = w15;\n    o[16] = w16;\n    o[17] = w17;\n    o[18] = w18;\n    if (c !== 0) {\n      o[19] = c;\n      out.length++;\n    }\n    return out;\n  };\n\n  // Polyfill comb\n  if (!Math.imul) {\n    comb10MulTo = smallMulTo;\n  }\n\n  function bigMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    out.length = self.length + num.length;\n\n    var carry = 0;\n    var hncarry = 0;\n    for (var k = 0; k < out.length - 1; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = hncarry;\n      hncarry = 0;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = k - j;\n        var a = self.words[i] | 0;\n        var b = num.words[j] | 0;\n        var r = a * b;\n\n        var lo = r & 0x3ffffff;\n        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;\n        lo = (lo + rword) | 0;\n        rword = lo & 0x3ffffff;\n        ncarry = (ncarry + (lo >>> 26)) | 0;\n\n        hncarry += ncarry >>> 26;\n        ncarry &= 0x3ffffff;\n      }\n      out.words[k] = rword;\n      carry = ncarry;\n      ncarry = hncarry;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry;\n    } else {\n      out.length--;\n    }\n\n    return out._strip();\n  }\n\n  function jumboMulTo (self, num, out) {\n    // Temporary disable, see https://github.com/indutny/bn.js/issues/211\n    // var fftm = new FFTM();\n    // return fftm.mulp(self, num, out);\n    return bigMulTo(self, num, out);\n  }\n\n  BN.prototype.mulTo = function mulTo (num, out) {\n    var res;\n    var len = this.length + num.length;\n    if (this.length === 10 && num.length === 10) {\n      res = comb10MulTo(this, num, out);\n    } else if (len < 63) {\n      res = smallMulTo(this, num, out);\n    } else if (len < 1024) {\n      res = bigMulTo(this, num, out);\n    } else {\n      res = jumboMulTo(this, num, out);\n    }\n\n    return res;\n  };\n\n  // Cooley-Tukey algorithm for FFT\n  // slightly revisited to rely on looping instead of recursion\n\n  function FFTM (x, y) {\n    this.x = x;\n    this.y = y;\n  }\n\n  FFTM.prototype.makeRBT = function makeRBT (N) {\n    var t = new Array(N);\n    var l = BN.prototype._countBits(N) - 1;\n    for (var i = 0; i < N; i++) {\n      t[i] = this.revBin(i, l, N);\n    }\n\n    return t;\n  };\n\n  // Returns binary-reversed representation of `x`\n  FFTM.prototype.revBin = function revBin (x, l, N) {\n    if (x === 0 || x === N - 1) return x;\n\n    var rb = 0;\n    for (var i = 0; i < l; i++) {\n      rb |= (x & 1) << (l - i - 1);\n      x >>= 1;\n    }\n\n    return rb;\n  };\n\n  // Performs \"tweedling\" phase, therefore 'emulating'\n  // behaviour of the recursive algorithm\n  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {\n    for (var i = 0; i < N; i++) {\n      rtws[i] = rws[rbt[i]];\n      itws[i] = iws[rbt[i]];\n    }\n  };\n\n  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {\n    this.permute(rbt, rws, iws, rtws, itws, N);\n\n    for (var s = 1; s < N; s <<= 1) {\n      var l = s << 1;\n\n      var rtwdf = Math.cos(2 * Math.PI / l);\n      var itwdf = Math.sin(2 * Math.PI / l);\n\n      for (var p = 0; p < N; p += l) {\n        var rtwdf_ = rtwdf;\n        var itwdf_ = itwdf;\n\n        for (var j = 0; j < s; j++) {\n          var re = rtws[p + j];\n          var ie = itws[p + j];\n\n          var ro = rtws[p + j + s];\n          var io = itws[p + j + s];\n\n          var rx = rtwdf_ * ro - itwdf_ * io;\n\n          io = rtwdf_ * io + itwdf_ * ro;\n          ro = rx;\n\n          rtws[p + j] = re + ro;\n          itws[p + j] = ie + io;\n\n          rtws[p + j + s] = re - ro;\n          itws[p + j + s] = ie - io;\n\n          /* jshint maxdepth : false */\n          if (j !== l) {\n            rx = rtwdf * rtwdf_ - itwdf * itwdf_;\n\n            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;\n            rtwdf_ = rx;\n          }\n        }\n      }\n    }\n  };\n\n  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {\n    var N = Math.max(m, n) | 1;\n    var odd = N & 1;\n    var i = 0;\n    for (N = N / 2 | 0; N; N = N >>> 1) {\n      i++;\n    }\n\n    return 1 << i + 1 + odd;\n  };\n\n  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {\n    if (N <= 1) return;\n\n    for (var i = 0; i < N / 2; i++) {\n      var t = rws[i];\n\n      rws[i] = rws[N - i - 1];\n      rws[N - i - 1] = t;\n\n      t = iws[i];\n\n      iws[i] = -iws[N - i - 1];\n      iws[N - i - 1] = -t;\n    }\n  };\n\n  FFTM.prototype.normalize13b = function normalize13b (ws, N) {\n    var carry = 0;\n    for (var i = 0; i < N / 2; i++) {\n      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +\n        Math.round(ws[2 * i] / N) +\n        carry;\n\n      ws[i] = w & 0x3ffffff;\n\n      if (w < 0x4000000) {\n        carry = 0;\n      } else {\n        carry = w / 0x4000000 | 0;\n      }\n    }\n\n    return ws;\n  };\n\n  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {\n    var carry = 0;\n    for (var i = 0; i < len; i++) {\n      carry = carry + (ws[i] | 0);\n\n      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;\n      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;\n    }\n\n    // Pad with zeroes\n    for (i = 2 * len; i < N; ++i) {\n      rws[i] = 0;\n    }\n\n    assert(carry === 0);\n    assert((carry & ~0x1fff) === 0);\n  };\n\n  FFTM.prototype.stub = function stub (N) {\n    var ph = new Array(N);\n    for (var i = 0; i < N; i++) {\n      ph[i] = 0;\n    }\n\n    return ph;\n  };\n\n  FFTM.prototype.mulp = function mulp (x, y, out) {\n    var N = 2 * this.guessLen13b(x.length, y.length);\n\n    var rbt = this.makeRBT(N);\n\n    var _ = this.stub(N);\n\n    var rws = new Array(N);\n    var rwst = new Array(N);\n    var iwst = new Array(N);\n\n    var nrws = new Array(N);\n    var nrwst = new Array(N);\n    var niwst = new Array(N);\n\n    var rmws = out.words;\n    rmws.length = N;\n\n    this.convert13b(x.words, x.length, rws, N);\n    this.convert13b(y.words, y.length, nrws, N);\n\n    this.transform(rws, _, rwst, iwst, N, rbt);\n    this.transform(nrws, _, nrwst, niwst, N, rbt);\n\n    for (var i = 0; i < N; i++) {\n      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];\n      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];\n      rwst[i] = rx;\n    }\n\n    this.conjugate(rwst, iwst, N);\n    this.transform(rwst, iwst, rmws, _, N, rbt);\n    this.conjugate(rmws, _, N);\n    this.normalize13b(rmws, N);\n\n    out.negative = x.negative ^ y.negative;\n    out.length = x.length + y.length;\n    return out._strip();\n  };\n\n  // Multiply `this` by `num`\n  BN.prototype.mul = function mul (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return this.mulTo(num, out);\n  };\n\n  // Multiply employing FFT\n  BN.prototype.mulf = function mulf (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return jumboMulTo(this, num, out);\n  };\n\n  // In-place Multiplication\n  BN.prototype.imul = function imul (num) {\n    return this.clone().mulTo(num, this);\n  };\n\n  BN.prototype.imuln = function imuln (num) {\n    var isNegNum = num < 0;\n    if (isNegNum) num = -num;\n\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n\n    // Carry\n    var carry = 0;\n    for (var i = 0; i < this.length; i++) {\n      var w = (this.words[i] | 0) * num;\n      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);\n      carry >>= 26;\n      carry += (w / 0x4000000) | 0;\n      // NOTE: lo is 27bit maximum\n      carry += lo >>> 26;\n      this.words[i] = lo & 0x3ffffff;\n    }\n\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n\n    return isNegNum ? this.ineg() : this;\n  };\n\n  BN.prototype.muln = function muln (num) {\n    return this.clone().imuln(num);\n  };\n\n  // `this` * `this`\n  BN.prototype.sqr = function sqr () {\n    return this.mul(this);\n  };\n\n  // `this` * `this` in-place\n  BN.prototype.isqr = function isqr () {\n    return this.imul(this.clone());\n  };\n\n  // Math.pow(`this`, `num`)\n  BN.prototype.pow = function pow (num) {\n    var w = toBitArray(num);\n    if (w.length === 0) return new BN(1);\n\n    // Skip leading zeroes\n    var res = this;\n    for (var i = 0; i < w.length; i++, res = res.sqr()) {\n      if (w[i] !== 0) break;\n    }\n\n    if (++i < w.length) {\n      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {\n        if (w[i] === 0) continue;\n\n        res = res.mul(q);\n      }\n    }\n\n    return res;\n  };\n\n  // Shift-left in-place\n  BN.prototype.iushln = function iushln (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);\n    var i;\n\n    if (r !== 0) {\n      var carry = 0;\n\n      for (i = 0; i < this.length; i++) {\n        var newCarry = this.words[i] & carryMask;\n        var c = ((this.words[i] | 0) - newCarry) << r;\n        this.words[i] = c | carry;\n        carry = newCarry >>> (26 - r);\n      }\n\n      if (carry) {\n        this.words[i] = carry;\n        this.length++;\n      }\n    }\n\n    if (s !== 0) {\n      for (i = this.length - 1; i >= 0; i--) {\n        this.words[i + s] = this.words[i];\n      }\n\n      for (i = 0; i < s; i++) {\n        this.words[i] = 0;\n      }\n\n      this.length += s;\n    }\n\n    return this._strip();\n  };\n\n  BN.prototype.ishln = function ishln (bits) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushln(bits);\n  };\n\n  // Shift-right in-place\n  // NOTE: `hint` is a lowest bit before trailing zeroes\n  // NOTE: if `extended` is present - it will be filled with destroyed bits\n  BN.prototype.iushrn = function iushrn (bits, hint, extended) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var h;\n    if (hint) {\n      h = (hint - (hint % 26)) / 26;\n    } else {\n      h = 0;\n    }\n\n    var r = bits % 26;\n    var s = Math.min((bits - r) / 26, this.length);\n    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n    var maskedWords = extended;\n\n    h -= s;\n    h = Math.max(0, h);\n\n    // Extended mode, copy masked part\n    if (maskedWords) {\n      for (var i = 0; i < s; i++) {\n        maskedWords.words[i] = this.words[i];\n      }\n      maskedWords.length = s;\n    }\n\n    if (s === 0) {\n      // No-op, we should not move anything at all\n    } else if (this.length > s) {\n      this.length -= s;\n      for (i = 0; i < this.length; i++) {\n        this.words[i] = this.words[i + s];\n      }\n    } else {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    var carry = 0;\n    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {\n      var word = this.words[i] | 0;\n      this.words[i] = (carry << (26 - r)) | (word >>> r);\n      carry = word & mask;\n    }\n\n    // Push carried bits as a mask\n    if (maskedWords && carry !== 0) {\n      maskedWords.words[maskedWords.length++] = carry;\n    }\n\n    if (this.length === 0) {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    return this._strip();\n  };\n\n  BN.prototype.ishrn = function ishrn (bits, hint, extended) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushrn(bits, hint, extended);\n  };\n\n  // Shift-left\n  BN.prototype.shln = function shln (bits) {\n    return this.clone().ishln(bits);\n  };\n\n  BN.prototype.ushln = function ushln (bits) {\n    return this.clone().iushln(bits);\n  };\n\n  // Shift-right\n  BN.prototype.shrn = function shrn (bits) {\n    return this.clone().ishrn(bits);\n  };\n\n  BN.prototype.ushrn = function ushrn (bits) {\n    return this.clone().iushrn(bits);\n  };\n\n  // Test if n bit is set\n  BN.prototype.testn = function testn (bit) {\n    assert(typeof bit === 'number' && bit >= 0);\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) return false;\n\n    // Check bit and return\n    var w = this.words[s];\n\n    return !!(w & q);\n  };\n\n  // Return only lowers bits of number (in-place)\n  BN.prototype.imaskn = function imaskn (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n\n    assert(this.negative === 0, 'imaskn works only with positive numbers');\n\n    if (this.length <= s) {\n      return this;\n    }\n\n    if (r !== 0) {\n      s++;\n    }\n    this.length = Math.min(s, this.length);\n\n    if (r !== 0) {\n      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n      this.words[this.length - 1] &= mask;\n    }\n\n    return this._strip();\n  };\n\n  // Return only lowers bits of number\n  BN.prototype.maskn = function maskn (bits) {\n    return this.clone().imaskn(bits);\n  };\n\n  // Add plain number `num` to `this`\n  BN.prototype.iaddn = function iaddn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.isubn(-num);\n\n    // Possible sign change\n    if (this.negative !== 0) {\n      if (this.length === 1 && (this.words[0] | 0) <= num) {\n        this.words[0] = num - (this.words[0] | 0);\n        this.negative = 0;\n        return this;\n      }\n\n      this.negative = 0;\n      this.isubn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    // Add without checks\n    return this._iaddn(num);\n  };\n\n  BN.prototype._iaddn = function _iaddn (num) {\n    this.words[0] += num;\n\n    // Carry\n    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {\n      this.words[i] -= 0x4000000;\n      if (i === this.length - 1) {\n        this.words[i + 1] = 1;\n      } else {\n        this.words[i + 1]++;\n      }\n    }\n    this.length = Math.max(this.length, i + 1);\n\n    return this;\n  };\n\n  // Subtract plain number `num` from `this`\n  BN.prototype.isubn = function isubn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.iaddn(-num);\n\n    if (this.negative !== 0) {\n      this.negative = 0;\n      this.iaddn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    this.words[0] -= num;\n\n    if (this.length === 1 && this.words[0] < 0) {\n      this.words[0] = -this.words[0];\n      this.negative = 1;\n    } else {\n      // Carry\n      for (var i = 0; i < this.length && this.words[i] < 0; i++) {\n        this.words[i] += 0x4000000;\n        this.words[i + 1] -= 1;\n      }\n    }\n\n    return this._strip();\n  };\n\n  BN.prototype.addn = function addn (num) {\n    return this.clone().iaddn(num);\n  };\n\n  BN.prototype.subn = function subn (num) {\n    return this.clone().isubn(num);\n  };\n\n  BN.prototype.iabs = function iabs () {\n    this.negative = 0;\n\n    return this;\n  };\n\n  BN.prototype.abs = function abs () {\n    return this.clone().iabs();\n  };\n\n  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {\n    var len = num.length + shift;\n    var i;\n\n    this._expand(len);\n\n    var w;\n    var carry = 0;\n    for (i = 0; i < num.length; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      var right = (num.words[i] | 0) * mul;\n      w -= right & 0x3ffffff;\n      carry = (w >> 26) - ((right / 0x4000000) | 0);\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n    for (; i < this.length - shift; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      carry = w >> 26;\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n\n    if (carry === 0) return this._strip();\n\n    // Subtraction overflow\n    assert(carry === -1);\n    carry = 0;\n    for (i = 0; i < this.length; i++) {\n      w = -(this.words[i] | 0) + carry;\n      carry = w >> 26;\n      this.words[i] = w & 0x3ffffff;\n    }\n    this.negative = 1;\n\n    return this._strip();\n  };\n\n  BN.prototype._wordDiv = function _wordDiv (num, mode) {\n    var shift = this.length - num.length;\n\n    var a = this.clone();\n    var b = num;\n\n    // Normalize\n    var bhi = b.words[b.length - 1] | 0;\n    var bhiBits = this._countBits(bhi);\n    shift = 26 - bhiBits;\n    if (shift !== 0) {\n      b = b.ushln(shift);\n      a.iushln(shift);\n      bhi = b.words[b.length - 1] | 0;\n    }\n\n    // Initialize quotient\n    var m = a.length - b.length;\n    var q;\n\n    if (mode !== 'mod') {\n      q = new BN(null);\n      q.length = m + 1;\n      q.words = new Array(q.length);\n      for (var i = 0; i < q.length; i++) {\n        q.words[i] = 0;\n      }\n    }\n\n    var diff = a.clone()._ishlnsubmul(b, 1, m);\n    if (diff.negative === 0) {\n      a = diff;\n      if (q) {\n        q.words[m] = 1;\n      }\n    }\n\n    for (var j = m - 1; j >= 0; j--) {\n      var qj = (a.words[b.length + j] | 0) * 0x4000000 +\n        (a.words[b.length + j - 1] | 0);\n\n      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max\n      // (0x7ffffff)\n      qj = Math.min((qj / bhi) | 0, 0x3ffffff);\n\n      a._ishlnsubmul(b, qj, j);\n      while (a.negative !== 0) {\n        qj--;\n        a.negative = 0;\n        a._ishlnsubmul(b, 1, j);\n        if (!a.isZero()) {\n          a.negative ^= 1;\n        }\n      }\n      if (q) {\n        q.words[j] = qj;\n      }\n    }\n    if (q) {\n      q._strip();\n    }\n    a._strip();\n\n    // Denormalize\n    if (mode !== 'div' && shift !== 0) {\n      a.iushrn(shift);\n    }\n\n    return {\n      div: q || null,\n      mod: a\n    };\n  };\n\n  // NOTE: 1) `mode` can be set to `mod` to request mod only,\n  //       to `div` to request div only, or be absent to\n  //       request both div & mod\n  //       2) `positive` is true if unsigned mod is requested\n  BN.prototype.divmod = function divmod (num, mode, positive) {\n    assert(!num.isZero());\n\n    if (this.isZero()) {\n      return {\n        div: new BN(0),\n        mod: new BN(0)\n      };\n    }\n\n    var div, mod, res;\n    if (this.negative !== 0 && num.negative === 0) {\n      res = this.neg().divmod(num, mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.iadd(num);\n        }\n      }\n\n      return {\n        div: div,\n        mod: mod\n      };\n    }\n\n    if (this.negative === 0 && num.negative !== 0) {\n      res = this.divmod(num.neg(), mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      return {\n        div: div,\n        mod: res.mod\n      };\n    }\n\n    if ((this.negative & num.negative) !== 0) {\n      res = this.neg().divmod(num.neg(), mode);\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.isub(num);\n        }\n      }\n\n      return {\n        div: res.div,\n        mod: mod\n      };\n    }\n\n    // Both numbers are positive at this point\n\n    // Strip both numbers to approximate shift value\n    if (num.length > this.length || this.cmp(num) < 0) {\n      return {\n        div: new BN(0),\n        mod: this\n      };\n    }\n\n    // Very short reduction\n    if (num.length === 1) {\n      if (mode === 'div') {\n        return {\n          div: this.divn(num.words[0]),\n          mod: null\n        };\n      }\n\n      if (mode === 'mod') {\n        return {\n          div: null,\n          mod: new BN(this.modrn(num.words[0]))\n        };\n      }\n\n      return {\n        div: this.divn(num.words[0]),\n        mod: new BN(this.modrn(num.words[0]))\n      };\n    }\n\n    return this._wordDiv(num, mode);\n  };\n\n  // Find `this` / `num`\n  BN.prototype.div = function div (num) {\n    return this.divmod(num, 'div', false).div;\n  };\n\n  // Find `this` % `num`\n  BN.prototype.mod = function mod (num) {\n    return this.divmod(num, 'mod', false).mod;\n  };\n\n  BN.prototype.umod = function umod (num) {\n    return this.divmod(num, 'mod', true).mod;\n  };\n\n  // Find Round(`this` / `num`)\n  BN.prototype.divRound = function divRound (num) {\n    var dm = this.divmod(num);\n\n    // Fast case - exact division\n    if (dm.mod.isZero()) return dm.div;\n\n    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;\n\n    var half = num.ushrn(1);\n    var r2 = num.andln(1);\n    var cmp = mod.cmp(half);\n\n    // Round down\n    if (cmp < 0 || (r2 === 1 && cmp === 0)) return dm.div;\n\n    // Round up\n    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);\n  };\n\n  BN.prototype.modrn = function modrn (num) {\n    var isNegNum = num < 0;\n    if (isNegNum) num = -num;\n\n    assert(num <= 0x3ffffff);\n    var p = (1 << 26) % num;\n\n    var acc = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      acc = (p * acc + (this.words[i] | 0)) % num;\n    }\n\n    return isNegNum ? -acc : acc;\n  };\n\n  // WARNING: DEPRECATED\n  BN.prototype.modn = function modn (num) {\n    return this.modrn(num);\n  };\n\n  // In-place division by number\n  BN.prototype.idivn = function idivn (num) {\n    var isNegNum = num < 0;\n    if (isNegNum) num = -num;\n\n    assert(num <= 0x3ffffff);\n\n    var carry = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var w = (this.words[i] | 0) + carry * 0x4000000;\n      this.words[i] = (w / num) | 0;\n      carry = w % num;\n    }\n\n    this._strip();\n    return isNegNum ? this.ineg() : this;\n  };\n\n  BN.prototype.divn = function divn (num) {\n    return this.clone().idivn(num);\n  };\n\n  BN.prototype.egcd = function egcd (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var x = this;\n    var y = p.clone();\n\n    if (x.negative !== 0) {\n      x = x.umod(p);\n    } else {\n      x = x.clone();\n    }\n\n    // A * x + B * y = x\n    var A = new BN(1);\n    var B = new BN(0);\n\n    // C * x + D * y = y\n    var C = new BN(0);\n    var D = new BN(1);\n\n    var g = 0;\n\n    while (x.isEven() && y.isEven()) {\n      x.iushrn(1);\n      y.iushrn(1);\n      ++g;\n    }\n\n    var yp = y.clone();\n    var xp = x.clone();\n\n    while (!x.isZero()) {\n      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        x.iushrn(i);\n        while (i-- > 0) {\n          if (A.isOdd() || B.isOdd()) {\n            A.iadd(yp);\n            B.isub(xp);\n          }\n\n          A.iushrn(1);\n          B.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        y.iushrn(j);\n        while (j-- > 0) {\n          if (C.isOdd() || D.isOdd()) {\n            C.iadd(yp);\n            D.isub(xp);\n          }\n\n          C.iushrn(1);\n          D.iushrn(1);\n        }\n      }\n\n      if (x.cmp(y) >= 0) {\n        x.isub(y);\n        A.isub(C);\n        B.isub(D);\n      } else {\n        y.isub(x);\n        C.isub(A);\n        D.isub(B);\n      }\n    }\n\n    return {\n      a: C,\n      b: D,\n      gcd: y.iushln(g)\n    };\n  };\n\n  // This is reduced incarnation of the binary EEA\n  // above, designated to invert members of the\n  // _prime_ fields F(p) at a maximal speed\n  BN.prototype._invmp = function _invmp (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var a = this;\n    var b = p.clone();\n\n    if (a.negative !== 0) {\n      a = a.umod(p);\n    } else {\n      a = a.clone();\n    }\n\n    var x1 = new BN(1);\n    var x2 = new BN(0);\n\n    var delta = b.clone();\n\n    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {\n      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        a.iushrn(i);\n        while (i-- > 0) {\n          if (x1.isOdd()) {\n            x1.iadd(delta);\n          }\n\n          x1.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        b.iushrn(j);\n        while (j-- > 0) {\n          if (x2.isOdd()) {\n            x2.iadd(delta);\n          }\n\n          x2.iushrn(1);\n        }\n      }\n\n      if (a.cmp(b) >= 0) {\n        a.isub(b);\n        x1.isub(x2);\n      } else {\n        b.isub(a);\n        x2.isub(x1);\n      }\n    }\n\n    var res;\n    if (a.cmpn(1) === 0) {\n      res = x1;\n    } else {\n      res = x2;\n    }\n\n    if (res.cmpn(0) < 0) {\n      res.iadd(p);\n    }\n\n    return res;\n  };\n\n  BN.prototype.gcd = function gcd (num) {\n    if (this.isZero()) return num.abs();\n    if (num.isZero()) return this.abs();\n\n    var a = this.clone();\n    var b = num.clone();\n    a.negative = 0;\n    b.negative = 0;\n\n    // Remove common factor of two\n    for (var shift = 0; a.isEven() && b.isEven(); shift++) {\n      a.iushrn(1);\n      b.iushrn(1);\n    }\n\n    do {\n      while (a.isEven()) {\n        a.iushrn(1);\n      }\n      while (b.isEven()) {\n        b.iushrn(1);\n      }\n\n      var r = a.cmp(b);\n      if (r < 0) {\n        // Swap `a` and `b` to make `a` always bigger than `b`\n        var t = a;\n        a = b;\n        b = t;\n      } else if (r === 0 || b.cmpn(1) === 0) {\n        break;\n      }\n\n      a.isub(b);\n    } while (true);\n\n    return b.iushln(shift);\n  };\n\n  // Invert number in the field F(num)\n  BN.prototype.invm = function invm (num) {\n    return this.egcd(num).a.umod(num);\n  };\n\n  BN.prototype.isEven = function isEven () {\n    return (this.words[0] & 1) === 0;\n  };\n\n  BN.prototype.isOdd = function isOdd () {\n    return (this.words[0] & 1) === 1;\n  };\n\n  // And first word and num\n  BN.prototype.andln = function andln (num) {\n    return this.words[0] & num;\n  };\n\n  // Increment at the bit position in-line\n  BN.prototype.bincn = function bincn (bit) {\n    assert(typeof bit === 'number');\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) {\n      this._expand(s + 1);\n      this.words[s] |= q;\n      return this;\n    }\n\n    // Add bit and propagate, if needed\n    var carry = q;\n    for (var i = s; carry !== 0 && i < this.length; i++) {\n      var w = this.words[i] | 0;\n      w += carry;\n      carry = w >>> 26;\n      w &= 0x3ffffff;\n      this.words[i] = w;\n    }\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n    return this;\n  };\n\n  BN.prototype.isZero = function isZero () {\n    return this.length === 1 && this.words[0] === 0;\n  };\n\n  BN.prototype.cmpn = function cmpn (num) {\n    var negative = num < 0;\n\n    if (this.negative !== 0 && !negative) return -1;\n    if (this.negative === 0 && negative) return 1;\n\n    this._strip();\n\n    var res;\n    if (this.length > 1) {\n      res = 1;\n    } else {\n      if (negative) {\n        num = -num;\n      }\n\n      assert(num <= 0x3ffffff, 'Number is too big');\n\n      var w = this.words[0] | 0;\n      res = w === num ? 0 : w < num ? -1 : 1;\n    }\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Compare two numbers and return:\n  // 1 - if `this` > `num`\n  // 0 - if `this` == `num`\n  // -1 - if `this` < `num`\n  BN.prototype.cmp = function cmp (num) {\n    if (this.negative !== 0 && num.negative === 0) return -1;\n    if (this.negative === 0 && num.negative !== 0) return 1;\n\n    var res = this.ucmp(num);\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Unsigned comparison\n  BN.prototype.ucmp = function ucmp (num) {\n    // At this point both numbers have the same sign\n    if (this.length > num.length) return 1;\n    if (this.length < num.length) return -1;\n\n    var res = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var a = this.words[i] | 0;\n      var b = num.words[i] | 0;\n\n      if (a === b) continue;\n      if (a < b) {\n        res = -1;\n      } else if (a > b) {\n        res = 1;\n      }\n      break;\n    }\n    return res;\n  };\n\n  BN.prototype.gtn = function gtn (num) {\n    return this.cmpn(num) === 1;\n  };\n\n  BN.prototype.gt = function gt (num) {\n    return this.cmp(num) === 1;\n  };\n\n  BN.prototype.gten = function gten (num) {\n    return this.cmpn(num) >= 0;\n  };\n\n  BN.prototype.gte = function gte (num) {\n    return this.cmp(num) >= 0;\n  };\n\n  BN.prototype.ltn = function ltn (num) {\n    return this.cmpn(num) === -1;\n  };\n\n  BN.prototype.lt = function lt (num) {\n    return this.cmp(num) === -1;\n  };\n\n  BN.prototype.lten = function lten (num) {\n    return this.cmpn(num) <= 0;\n  };\n\n  BN.prototype.lte = function lte (num) {\n    return this.cmp(num) <= 0;\n  };\n\n  BN.prototype.eqn = function eqn (num) {\n    return this.cmpn(num) === 0;\n  };\n\n  BN.prototype.eq = function eq (num) {\n    return this.cmp(num) === 0;\n  };\n\n  //\n  // A reduce context, could be using montgomery or something better, depending\n  // on the `m` itself.\n  //\n  BN.red = function red (num) {\n    return new Red(num);\n  };\n\n  BN.prototype.toRed = function toRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    assert(this.negative === 0, 'red works only with positives');\n    return ctx.convertTo(this)._forceRed(ctx);\n  };\n\n  BN.prototype.fromRed = function fromRed () {\n    assert(this.red, 'fromRed works only with numbers in reduction context');\n    return this.red.convertFrom(this);\n  };\n\n  BN.prototype._forceRed = function _forceRed (ctx) {\n    this.red = ctx;\n    return this;\n  };\n\n  BN.prototype.forceRed = function forceRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    return this._forceRed(ctx);\n  };\n\n  BN.prototype.redAdd = function redAdd (num) {\n    assert(this.red, 'redAdd works only with red numbers');\n    return this.red.add(this, num);\n  };\n\n  BN.prototype.redIAdd = function redIAdd (num) {\n    assert(this.red, 'redIAdd works only with red numbers');\n    return this.red.iadd(this, num);\n  };\n\n  BN.prototype.redSub = function redSub (num) {\n    assert(this.red, 'redSub works only with red numbers');\n    return this.red.sub(this, num);\n  };\n\n  BN.prototype.redISub = function redISub (num) {\n    assert(this.red, 'redISub works only with red numbers');\n    return this.red.isub(this, num);\n  };\n\n  BN.prototype.redShl = function redShl (num) {\n    assert(this.red, 'redShl works only with red numbers');\n    return this.red.shl(this, num);\n  };\n\n  BN.prototype.redMul = function redMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.mul(this, num);\n  };\n\n  BN.prototype.redIMul = function redIMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.imul(this, num);\n  };\n\n  BN.prototype.redSqr = function redSqr () {\n    assert(this.red, 'redSqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqr(this);\n  };\n\n  BN.prototype.redISqr = function redISqr () {\n    assert(this.red, 'redISqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.isqr(this);\n  };\n\n  // Square root over p\n  BN.prototype.redSqrt = function redSqrt () {\n    assert(this.red, 'redSqrt works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqrt(this);\n  };\n\n  BN.prototype.redInvm = function redInvm () {\n    assert(this.red, 'redInvm works only with red numbers');\n    this.red._verify1(this);\n    return this.red.invm(this);\n  };\n\n  // Return negative clone of `this` % `red modulo`\n  BN.prototype.redNeg = function redNeg () {\n    assert(this.red, 'redNeg works only with red numbers');\n    this.red._verify1(this);\n    return this.red.neg(this);\n  };\n\n  BN.prototype.redPow = function redPow (num) {\n    assert(this.red && !num.red, 'redPow(normalNum)');\n    this.red._verify1(this);\n    return this.red.pow(this, num);\n  };\n\n  // Prime numbers with efficient reduction\n  var primes = {\n    k256: null,\n    p224: null,\n    p192: null,\n    p25519: null\n  };\n\n  // Pseudo-Mersenne prime\n  function MPrime (name, p) {\n    // P = 2 ^ N - K\n    this.name = name;\n    this.p = new BN(p, 16);\n    this.n = this.p.bitLength();\n    this.k = new BN(1).iushln(this.n).isub(this.p);\n\n    this.tmp = this._tmp();\n  }\n\n  MPrime.prototype._tmp = function _tmp () {\n    var tmp = new BN(null);\n    tmp.words = new Array(Math.ceil(this.n / 13));\n    return tmp;\n  };\n\n  MPrime.prototype.ireduce = function ireduce (num) {\n    // Assumes that `num` is less than `P^2`\n    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)\n    var r = num;\n    var rlen;\n\n    do {\n      this.split(r, this.tmp);\n      r = this.imulK(r);\n      r = r.iadd(this.tmp);\n      rlen = r.bitLength();\n    } while (rlen > this.n);\n\n    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);\n    if (cmp === 0) {\n      r.words[0] = 0;\n      r.length = 1;\n    } else if (cmp > 0) {\n      r.isub(this.p);\n    } else {\n      if (r.strip !== undefined) {\n        // r is a BN v4 instance\n        r.strip();\n      } else {\n        // r is a BN v5 instance\n        r._strip();\n      }\n    }\n\n    return r;\n  };\n\n  MPrime.prototype.split = function split (input, out) {\n    input.iushrn(this.n, 0, out);\n  };\n\n  MPrime.prototype.imulK = function imulK (num) {\n    return num.imul(this.k);\n  };\n\n  function K256 () {\n    MPrime.call(\n      this,\n      'k256',\n      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');\n  }\n  inherits(K256, MPrime);\n\n  K256.prototype.split = function split (input, output) {\n    // 256 = 9 * 26 + 22\n    var mask = 0x3fffff;\n\n    var outLen = Math.min(input.length, 9);\n    for (var i = 0; i < outLen; i++) {\n      output.words[i] = input.words[i];\n    }\n    output.length = outLen;\n\n    if (input.length <= 9) {\n      input.words[0] = 0;\n      input.length = 1;\n      return;\n    }\n\n    // Shift by 9 limbs\n    var prev = input.words[9];\n    output.words[output.length++] = prev & mask;\n\n    for (i = 10; i < input.length; i++) {\n      var next = input.words[i] | 0;\n      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);\n      prev = next;\n    }\n    prev >>>= 22;\n    input.words[i - 10] = prev;\n    if (prev === 0 && input.length > 10) {\n      input.length -= 10;\n    } else {\n      input.length -= 9;\n    }\n  };\n\n  K256.prototype.imulK = function imulK (num) {\n    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]\n    num.words[num.length] = 0;\n    num.words[num.length + 1] = 0;\n    num.length += 2;\n\n    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390\n    var lo = 0;\n    for (var i = 0; i < num.length; i++) {\n      var w = num.words[i] | 0;\n      lo += w * 0x3d1;\n      num.words[i] = lo & 0x3ffffff;\n      lo = w * 0x40 + ((lo / 0x4000000) | 0);\n    }\n\n    // Fast length reduction\n    if (num.words[num.length - 1] === 0) {\n      num.length--;\n      if (num.words[num.length - 1] === 0) {\n        num.length--;\n      }\n    }\n    return num;\n  };\n\n  function P224 () {\n    MPrime.call(\n      this,\n      'p224',\n      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');\n  }\n  inherits(P224, MPrime);\n\n  function P192 () {\n    MPrime.call(\n      this,\n      'p192',\n      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');\n  }\n  inherits(P192, MPrime);\n\n  function P25519 () {\n    // 2 ^ 255 - 19\n    MPrime.call(\n      this,\n      '25519',\n      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');\n  }\n  inherits(P25519, MPrime);\n\n  P25519.prototype.imulK = function imulK (num) {\n    // K = 0x13\n    var carry = 0;\n    for (var i = 0; i < num.length; i++) {\n      var hi = (num.words[i] | 0) * 0x13 + carry;\n      var lo = hi & 0x3ffffff;\n      hi >>>= 26;\n\n      num.words[i] = lo;\n      carry = hi;\n    }\n    if (carry !== 0) {\n      num.words[num.length++] = carry;\n    }\n    return num;\n  };\n\n  // Exported mostly for testing purposes, use plain name instead\n  BN._prime = function prime (name) {\n    // Cached version of prime\n    if (primes[name]) return primes[name];\n\n    var prime;\n    if (name === 'k256') {\n      prime = new K256();\n    } else if (name === 'p224') {\n      prime = new P224();\n    } else if (name === 'p192') {\n      prime = new P192();\n    } else if (name === 'p25519') {\n      prime = new P25519();\n    } else {\n      throw new Error('Unknown prime ' + name);\n    }\n    primes[name] = prime;\n\n    return prime;\n  };\n\n  //\n  // Base reduction engine\n  //\n  function Red (m) {\n    if (typeof m === 'string') {\n      var prime = BN._prime(m);\n      this.m = prime.p;\n      this.prime = prime;\n    } else {\n      assert(m.gtn(1), 'modulus must be greater than 1');\n      this.m = m;\n      this.prime = null;\n    }\n  }\n\n  Red.prototype._verify1 = function _verify1 (a) {\n    assert(a.negative === 0, 'red works only with positives');\n    assert(a.red, 'red works only with red numbers');\n  };\n\n  Red.prototype._verify2 = function _verify2 (a, b) {\n    assert((a.negative | b.negative) === 0, 'red works only with positives');\n    assert(a.red && a.red === b.red,\n      'red works only with red numbers');\n  };\n\n  Red.prototype.imod = function imod (a) {\n    if (this.prime) return this.prime.ireduce(a)._forceRed(this);\n\n    move(a, a.umod(this.m)._forceRed(this));\n    return a;\n  };\n\n  Red.prototype.neg = function neg (a) {\n    if (a.isZero()) {\n      return a.clone();\n    }\n\n    return this.m.sub(a)._forceRed(this);\n  };\n\n  Red.prototype.add = function add (a, b) {\n    this._verify2(a, b);\n\n    var res = a.add(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.iadd = function iadd (a, b) {\n    this._verify2(a, b);\n\n    var res = a.iadd(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.sub = function sub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.sub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.isub = function isub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.isub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.shl = function shl (a, num) {\n    this._verify1(a);\n    return this.imod(a.ushln(num));\n  };\n\n  Red.prototype.imul = function imul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.imul(b));\n  };\n\n  Red.prototype.mul = function mul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.mul(b));\n  };\n\n  Red.prototype.isqr = function isqr (a) {\n    return this.imul(a, a.clone());\n  };\n\n  Red.prototype.sqr = function sqr (a) {\n    return this.mul(a, a);\n  };\n\n  Red.prototype.sqrt = function sqrt (a) {\n    if (a.isZero()) return a.clone();\n\n    var mod3 = this.m.andln(3);\n    assert(mod3 % 2 === 1);\n\n    // Fast case\n    if (mod3 === 3) {\n      var pow = this.m.add(new BN(1)).iushrn(2);\n      return this.pow(a, pow);\n    }\n\n    // Tonelli-Shanks algorithm (Totally unoptimized and slow)\n    //\n    // Find Q and S, that Q * 2 ^ S = (P - 1)\n    var q = this.m.subn(1);\n    var s = 0;\n    while (!q.isZero() && q.andln(1) === 0) {\n      s++;\n      q.iushrn(1);\n    }\n    assert(!q.isZero());\n\n    var one = new BN(1).toRed(this);\n    var nOne = one.redNeg();\n\n    // Find quadratic non-residue\n    // NOTE: Max is such because of generalized Riemann hypothesis.\n    var lpow = this.m.subn(1).iushrn(1);\n    var z = this.m.bitLength();\n    z = new BN(2 * z * z).toRed(this);\n\n    while (this.pow(z, lpow).cmp(nOne) !== 0) {\n      z.redIAdd(nOne);\n    }\n\n    var c = this.pow(z, q);\n    var r = this.pow(a, q.addn(1).iushrn(1));\n    var t = this.pow(a, q);\n    var m = s;\n    while (t.cmp(one) !== 0) {\n      var tmp = t;\n      for (var i = 0; tmp.cmp(one) !== 0; i++) {\n        tmp = tmp.redSqr();\n      }\n      assert(i < m);\n      var b = this.pow(c, new BN(1).iushln(m - i - 1));\n\n      r = r.redMul(b);\n      c = b.redSqr();\n      t = t.redMul(c);\n      m = i;\n    }\n\n    return r;\n  };\n\n  Red.prototype.invm = function invm (a) {\n    var inv = a._invmp(this.m);\n    if (inv.negative !== 0) {\n      inv.negative = 0;\n      return this.imod(inv).redNeg();\n    } else {\n      return this.imod(inv);\n    }\n  };\n\n  Red.prototype.pow = function pow (a, num) {\n    if (num.isZero()) return new BN(1).toRed(this);\n    if (num.cmpn(1) === 0) return a.clone();\n\n    var windowSize = 4;\n    var wnd = new Array(1 << windowSize);\n    wnd[0] = new BN(1).toRed(this);\n    wnd[1] = a;\n    for (var i = 2; i < wnd.length; i++) {\n      wnd[i] = this.mul(wnd[i - 1], a);\n    }\n\n    var res = wnd[0];\n    var current = 0;\n    var currentLen = 0;\n    var start = num.bitLength() % 26;\n    if (start === 0) {\n      start = 26;\n    }\n\n    for (i = num.length - 1; i >= 0; i--) {\n      var word = num.words[i];\n      for (var j = start - 1; j >= 0; j--) {\n        var bit = (word >> j) & 1;\n        if (res !== wnd[0]) {\n          res = this.sqr(res);\n        }\n\n        if (bit === 0 && current === 0) {\n          currentLen = 0;\n          continue;\n        }\n\n        current <<= 1;\n        current |= bit;\n        currentLen++;\n        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;\n\n        res = this.mul(res, wnd[current]);\n        currentLen = 0;\n        current = 0;\n      }\n      start = 26;\n    }\n\n    return res;\n  };\n\n  Red.prototype.convertTo = function convertTo (num) {\n    var r = num.umod(this.m);\n\n    return r === num ? r.clone() : r;\n  };\n\n  Red.prototype.convertFrom = function convertFrom (num) {\n    var res = num.clone();\n    res.red = null;\n    return res;\n  };\n\n  //\n  // Montgomery method engine\n  //\n\n  BN.mont = function mont (num) {\n    return new Mont(num);\n  };\n\n  function Mont (m) {\n    Red.call(this, m);\n\n    this.shift = this.m.bitLength();\n    if (this.shift % 26 !== 0) {\n      this.shift += 26 - (this.shift % 26);\n    }\n\n    this.r = new BN(1).iushln(this.shift);\n    this.r2 = this.imod(this.r.sqr());\n    this.rinv = this.r._invmp(this.m);\n\n    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);\n    this.minv = this.minv.umod(this.r);\n    this.minv = this.r.sub(this.minv);\n  }\n  inherits(Mont, Red);\n\n  Mont.prototype.convertTo = function convertTo (num) {\n    return this.imod(num.ushln(this.shift));\n  };\n\n  Mont.prototype.convertFrom = function convertFrom (num) {\n    var r = this.imod(num.mul(this.rinv));\n    r.red = null;\n    return r;\n  };\n\n  Mont.prototype.imul = function imul (a, b) {\n    if (a.isZero() || b.isZero()) {\n      a.words[0] = 0;\n      a.length = 1;\n      return a;\n    }\n\n    var t = a.imul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.mul = function mul (a, b) {\n    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);\n\n    var t = a.mul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.invm = function invm (a) {\n    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R\n    var res = this.imod(a._invmp(this.m).mul(this.r2));\n    return res._forceRed(this);\n  };\n})(typeof module === 'undefined' || module, this);","deps":{"buffer":"node_modules/browser-resolve/empty.js"}},{"id":"node_modules/browserify-sign/node_modules/browserify-rsa/index.js","source":"(function (Buffer){\nvar BN = require('bn.js')\nvar randomBytes = require('randombytes')\n\nfunction blind (priv) {\n  var r = getr(priv)\n  var blinder = r.toRed(BN.mont(priv.modulus)).redPow(new BN(priv.publicExponent)).fromRed()\n  return { blinder: blinder, unblinder: r.invm(priv.modulus) }\n}\n\nfunction getr (priv) {\n  var len = priv.modulus.byteLength()\n  var r\n  do {\n    r = new BN(randomBytes(len))\n  } while (r.cmp(priv.modulus) >= 0 || !r.umod(priv.prime1) || !r.umod(priv.prime2))\n  return r\n}\n\nfunction crt (msg, priv) {\n  var blinds = blind(priv)\n  var len = priv.modulus.byteLength()\n  var blinded = new BN(msg).mul(blinds.blinder).umod(priv.modulus)\n  var c1 = blinded.toRed(BN.mont(priv.prime1))\n  var c2 = blinded.toRed(BN.mont(priv.prime2))\n  var qinv = priv.coefficient\n  var p = priv.prime1\n  var q = priv.prime2\n  var m1 = c1.redPow(priv.exponent1).fromRed()\n  var m2 = c2.redPow(priv.exponent2).fromRed()\n  var h = m1.isub(m2).imul(qinv).umod(p).imul(q)\n  return m2.iadd(h).imul(blinds.unblinder).umod(priv.modulus).toArrayLike(Buffer, 'be', len)\n}\ncrt.getr = getr\n\nmodule.exports = crt\n\n}).call(this,require(\"buffer\").Buffer)","deps":{"bn.js":"node_modules/browserify-sign/node_modules/bn.js/lib/bn.js","buffer":"node_modules/buffer/index.js","randombytes":"node_modules/randombytes/browser.js"}},{"id":"node_modules/browserify-sign/node_modules/create-hmac/browser.js","source":"'use strict'\nvar inherits = require('inherits')\nvar Legacy = require('./legacy')\nvar Base = require('cipher-base')\nvar Buffer = require('safe-buffer').Buffer\nvar md5 = require('create-hash/md5')\nvar RIPEMD160 = require('ripemd160')\n\nvar sha = require('sha.js')\n\nvar ZEROS = Buffer.alloc(128)\n\nfunction Hmac (alg, key) {\n  Base.call(this, 'digest')\n  if (typeof key === 'string') {\n    key = Buffer.from(key)\n  }\n\n  var blocksize = (alg === 'sha512' || alg === 'sha384') ? 128 : 64\n\n  this._alg = alg\n  this._key = key\n  if (key.length > blocksize) {\n    var hash = alg === 'rmd160' ? new RIPEMD160() : sha(alg)\n    key = hash.update(key).digest()\n  } else if (key.length < blocksize) {\n    key = Buffer.concat([key, ZEROS], blocksize)\n  }\n\n  var ipad = this._ipad = Buffer.allocUnsafe(blocksize)\n  var opad = this._opad = Buffer.allocUnsafe(blocksize)\n\n  for (var i = 0; i < blocksize; i++) {\n    ipad[i] = key[i] ^ 0x36\n    opad[i] = key[i] ^ 0x5C\n  }\n  this._hash = alg === 'rmd160' ? new RIPEMD160() : sha(alg)\n  this._hash.update(ipad)\n}\n\ninherits(Hmac, Base)\n\nHmac.prototype._update = function (data) {\n  this._hash.update(data)\n}\n\nHmac.prototype._final = function () {\n  var h = this._hash.digest()\n  var hash = this._alg === 'rmd160' ? new RIPEMD160() : sha(this._alg)\n  return hash.update(this._opad).update(h).digest()\n}\n\nmodule.exports = function createHmac (alg, key) {\n  alg = alg.toLowerCase()\n  if (alg === 'rmd160' || alg === 'ripemd160') {\n    return new Hmac('rmd160', key)\n  }\n  if (alg === 'md5') {\n    return new Legacy(md5, key)\n  }\n  return new Hmac(alg, key)\n}","deps":{"./legacy":"node_modules/browserify-sign/node_modules/create-hmac/legacy.js","cipher-base":"node_modules/cipher-base/index.js","create-hash/md5":"node_modules/create-hash/md5.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","ripemd160":"node_modules/ripemd160/index.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js","sha.js":"node_modules/sha.js/index.js"}},{"id":"node_modules/browserify-sign/node_modules/create-hmac/legacy.js","source":"'use strict'\nvar inherits = require('inherits')\nvar Buffer = require('safe-buffer').Buffer\n\nvar Base = require('cipher-base')\n\nvar ZEROS = Buffer.alloc(128)\nvar blocksize = 64\n\nfunction Hmac (alg, key) {\n  Base.call(this, 'digest')\n  if (typeof key === 'string') {\n    key = Buffer.from(key)\n  }\n\n  this._alg = alg\n  this._key = key\n\n  if (key.length > blocksize) {\n    key = alg(key)\n  } else if (key.length < blocksize) {\n    key = Buffer.concat([key, ZEROS], blocksize)\n  }\n\n  var ipad = this._ipad = Buffer.allocUnsafe(blocksize)\n  var opad = this._opad = Buffer.allocUnsafe(blocksize)\n\n  for (var i = 0; i < blocksize; i++) {\n    ipad[i] = key[i] ^ 0x36\n    opad[i] = key[i] ^ 0x5C\n  }\n\n  this._hash = [ipad]\n}\n\ninherits(Hmac, Base)\n\nHmac.prototype._update = function (data) {\n  this._hash.push(data)\n}\n\nHmac.prototype._final = function () {\n  var h = this._alg(Buffer.concat(this._hash))\n  return this._alg(Buffer.concat([this._opad, h]))\n}\nmodule.exports = Hmac","deps":{"cipher-base":"node_modules/cipher-base/index.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic.js","source":"'use strict';\n\nvar elliptic = exports;\n\nelliptic.version = require('../package.json').version;\nelliptic.utils = require('./elliptic/utils');\nelliptic.rand = require('brorand');\nelliptic.curve = require('./elliptic/curve');\nelliptic.curves = require('./elliptic/curves');\n\n// Protocols\nelliptic.ec = require('./elliptic/ec');\nelliptic.eddsa = require('./elliptic/eddsa');","deps":{"../package.json":"node_modules/browserify-sign/node_modules/elliptic/package.json","./elliptic/curve":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/index.js","./elliptic/curves":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curves.js","./elliptic/ec":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/ec/index.js","./elliptic/eddsa":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/eddsa/index.js","./elliptic/utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","brorand":"node_modules/brorand/index.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/base.js","source":"'use strict';\n\nvar BN = require('bn.js');\nvar utils = require('../utils');\nvar getNAF = utils.getNAF;\nvar getJSF = utils.getJSF;\nvar assert = utils.assert;\n\nfunction BaseCurve(type, conf) {\n  this.type = type;\n  this.p = new BN(conf.p, 16);\n\n  // Use Montgomery, when there is no fast reduction for the prime\n  this.red = conf.prime ? BN.red(conf.prime) : BN.mont(this.p);\n\n  // Useful for many curves\n  this.zero = new BN(0).toRed(this.red);\n  this.one = new BN(1).toRed(this.red);\n  this.two = new BN(2).toRed(this.red);\n\n  // Curve configuration, optional\n  this.n = conf.n && new BN(conf.n, 16);\n  this.g = conf.g && this.pointFromJSON(conf.g, conf.gRed);\n\n  // Temporary arrays\n  this._wnafT1 = new Array(4);\n  this._wnafT2 = new Array(4);\n  this._wnafT3 = new Array(4);\n  this._wnafT4 = new Array(4);\n\n  this._bitLength = this.n ? this.n.bitLength() : 0;\n\n  // Generalized Greg Maxwell's trick\n  var adjustCount = this.n && this.p.div(this.n);\n  if (!adjustCount || adjustCount.cmpn(100) > 0) {\n    this.redN = null;\n  } else {\n    this._maxwellTrick = true;\n    this.redN = this.n.toRed(this.red);\n  }\n}\nmodule.exports = BaseCurve;\n\nBaseCurve.prototype.point = function point() {\n  throw new Error('Not implemented');\n};\n\nBaseCurve.prototype.validate = function validate() {\n  throw new Error('Not implemented');\n};\n\nBaseCurve.prototype._fixedNafMul = function _fixedNafMul(p, k) {\n  assert(p.precomputed);\n  var doubles = p._getDoubles();\n\n  var naf = getNAF(k, 1, this._bitLength);\n  var I = (1 << (doubles.step + 1)) - (doubles.step % 2 === 0 ? 2 : 1);\n  I /= 3;\n\n  // Translate into more windowed form\n  var repr = [];\n  var j;\n  var nafW;\n  for (j = 0; j < naf.length; j += doubles.step) {\n    nafW = 0;\n    for (var l = j + doubles.step - 1; l >= j; l--)\n      nafW = (nafW << 1) + naf[l];\n    repr.push(nafW);\n  }\n\n  var a = this.jpoint(null, null, null);\n  var b = this.jpoint(null, null, null);\n  for (var i = I; i > 0; i--) {\n    for (j = 0; j < repr.length; j++) {\n      nafW = repr[j];\n      if (nafW === i)\n        b = b.mixedAdd(doubles.points[j]);\n      else if (nafW === -i)\n        b = b.mixedAdd(doubles.points[j].neg());\n    }\n    a = a.add(b);\n  }\n  return a.toP();\n};\n\nBaseCurve.prototype._wnafMul = function _wnafMul(p, k) {\n  var w = 4;\n\n  // Precompute window\n  var nafPoints = p._getNAFPoints(w);\n  w = nafPoints.wnd;\n  var wnd = nafPoints.points;\n\n  // Get NAF form\n  var naf = getNAF(k, w, this._bitLength);\n\n  // Add `this`*(N+1) for every w-NAF index\n  var acc = this.jpoint(null, null, null);\n  for (var i = naf.length - 1; i >= 0; i--) {\n    // Count zeroes\n    for (var l = 0; i >= 0 && naf[i] === 0; i--)\n      l++;\n    if (i >= 0)\n      l++;\n    acc = acc.dblp(l);\n\n    if (i < 0)\n      break;\n    var z = naf[i];\n    assert(z !== 0);\n    if (p.type === 'affine') {\n      // J +- P\n      if (z > 0)\n        acc = acc.mixedAdd(wnd[(z - 1) >> 1]);\n      else\n        acc = acc.mixedAdd(wnd[(-z - 1) >> 1].neg());\n    } else {\n      // J +- J\n      if (z > 0)\n        acc = acc.add(wnd[(z - 1) >> 1]);\n      else\n        acc = acc.add(wnd[(-z - 1) >> 1].neg());\n    }\n  }\n  return p.type === 'affine' ? acc.toP() : acc;\n};\n\nBaseCurve.prototype._wnafMulAdd = function _wnafMulAdd(defW,\n  points,\n  coeffs,\n  len,\n  jacobianResult) {\n  var wndWidth = this._wnafT1;\n  var wnd = this._wnafT2;\n  var naf = this._wnafT3;\n\n  // Fill all arrays\n  var max = 0;\n  var i;\n  var j;\n  var p;\n  for (i = 0; i < len; i++) {\n    p = points[i];\n    var nafPoints = p._getNAFPoints(defW);\n    wndWidth[i] = nafPoints.wnd;\n    wnd[i] = nafPoints.points;\n  }\n\n  // Comb small window NAFs\n  for (i = len - 1; i >= 1; i -= 2) {\n    var a = i - 1;\n    var b = i;\n    if (wndWidth[a] !== 1 || wndWidth[b] !== 1) {\n      naf[a] = getNAF(coeffs[a], wndWidth[a], this._bitLength);\n      naf[b] = getNAF(coeffs[b], wndWidth[b], this._bitLength);\n      max = Math.max(naf[a].length, max);\n      max = Math.max(naf[b].length, max);\n      continue;\n    }\n\n    var comb = [\n      points[a], /* 1 */\n      null, /* 3 */\n      null, /* 5 */\n      points[b], /* 7 */\n    ];\n\n    // Try to avoid Projective points, if possible\n    if (points[a].y.cmp(points[b].y) === 0) {\n      comb[1] = points[a].add(points[b]);\n      comb[2] = points[a].toJ().mixedAdd(points[b].neg());\n    } else if (points[a].y.cmp(points[b].y.redNeg()) === 0) {\n      comb[1] = points[a].toJ().mixedAdd(points[b]);\n      comb[2] = points[a].add(points[b].neg());\n    } else {\n      comb[1] = points[a].toJ().mixedAdd(points[b]);\n      comb[2] = points[a].toJ().mixedAdd(points[b].neg());\n    }\n\n    var index = [\n      -3, /* -1 -1 */\n      -1, /* -1 0 */\n      -5, /* -1 1 */\n      -7, /* 0 -1 */\n      0, /* 0 0 */\n      7, /* 0 1 */\n      5, /* 1 -1 */\n      1, /* 1 0 */\n      3,  /* 1 1 */\n    ];\n\n    var jsf = getJSF(coeffs[a], coeffs[b]);\n    max = Math.max(jsf[0].length, max);\n    naf[a] = new Array(max);\n    naf[b] = new Array(max);\n    for (j = 0; j < max; j++) {\n      var ja = jsf[0][j] | 0;\n      var jb = jsf[1][j] | 0;\n\n      naf[a][j] = index[(ja + 1) * 3 + (jb + 1)];\n      naf[b][j] = 0;\n      wnd[a] = comb;\n    }\n  }\n\n  var acc = this.jpoint(null, null, null);\n  var tmp = this._wnafT4;\n  for (i = max; i >= 0; i--) {\n    var k = 0;\n\n    while (i >= 0) {\n      var zero = true;\n      for (j = 0; j < len; j++) {\n        tmp[j] = naf[j][i] | 0;\n        if (tmp[j] !== 0)\n          zero = false;\n      }\n      if (!zero)\n        break;\n      k++;\n      i--;\n    }\n    if (i >= 0)\n      k++;\n    acc = acc.dblp(k);\n    if (i < 0)\n      break;\n\n    for (j = 0; j < len; j++) {\n      var z = tmp[j];\n      p;\n      if (z === 0)\n        continue;\n      else if (z > 0)\n        p = wnd[j][(z - 1) >> 1];\n      else if (z < 0)\n        p = wnd[j][(-z - 1) >> 1].neg();\n\n      if (p.type === 'affine')\n        acc = acc.mixedAdd(p);\n      else\n        acc = acc.add(p);\n    }\n  }\n  // Zeroify references\n  for (i = 0; i < len; i++)\n    wnd[i] = null;\n\n  if (jacobianResult)\n    return acc;\n  else\n    return acc.toP();\n};\n\nfunction BasePoint(curve, type) {\n  this.curve = curve;\n  this.type = type;\n  this.precomputed = null;\n}\nBaseCurve.BasePoint = BasePoint;\n\nBasePoint.prototype.eq = function eq(/*other*/) {\n  throw new Error('Not implemented');\n};\n\nBasePoint.prototype.validate = function validate() {\n  return this.curve.validate(this);\n};\n\nBaseCurve.prototype.decodePoint = function decodePoint(bytes, enc) {\n  bytes = utils.toArray(bytes, enc);\n\n  var len = this.p.byteLength();\n\n  // uncompressed, hybrid-odd, hybrid-even\n  if ((bytes[0] === 0x04 || bytes[0] === 0x06 || bytes[0] === 0x07) &&\n      bytes.length - 1 === 2 * len) {\n    if (bytes[0] === 0x06)\n      assert(bytes[bytes.length - 1] % 2 === 0);\n    else if (bytes[0] === 0x07)\n      assert(bytes[bytes.length - 1] % 2 === 1);\n\n    var res =  this.point(bytes.slice(1, 1 + len),\n      bytes.slice(1 + len, 1 + 2 * len));\n\n    return res;\n  } else if ((bytes[0] === 0x02 || bytes[0] === 0x03) &&\n              bytes.length - 1 === len) {\n    return this.pointFromX(bytes.slice(1, 1 + len), bytes[0] === 0x03);\n  }\n  throw new Error('Unknown point format');\n};\n\nBasePoint.prototype.encodeCompressed = function encodeCompressed(enc) {\n  return this.encode(enc, true);\n};\n\nBasePoint.prototype._encode = function _encode(compact) {\n  var len = this.curve.p.byteLength();\n  var x = this.getX().toArray('be', len);\n\n  if (compact)\n    return [ this.getY().isEven() ? 0x02 : 0x03 ].concat(x);\n\n  return [ 0x04 ].concat(x, this.getY().toArray('be', len));\n};\n\nBasePoint.prototype.encode = function encode(enc, compact) {\n  return utils.encode(this._encode(compact), enc);\n};\n\nBasePoint.prototype.precompute = function precompute(power) {\n  if (this.precomputed)\n    return this;\n\n  var precomputed = {\n    doubles: null,\n    naf: null,\n    beta: null,\n  };\n  precomputed.naf = this._getNAFPoints(8);\n  precomputed.doubles = this._getDoubles(4, power);\n  precomputed.beta = this._getBeta();\n  this.precomputed = precomputed;\n\n  return this;\n};\n\nBasePoint.prototype._hasDoubles = function _hasDoubles(k) {\n  if (!this.precomputed)\n    return false;\n\n  var doubles = this.precomputed.doubles;\n  if (!doubles)\n    return false;\n\n  return doubles.points.length >= Math.ceil((k.bitLength() + 1) / doubles.step);\n};\n\nBasePoint.prototype._getDoubles = function _getDoubles(step, power) {\n  if (this.precomputed && this.precomputed.doubles)\n    return this.precomputed.doubles;\n\n  var doubles = [ this ];\n  var acc = this;\n  for (var i = 0; i < power; i += step) {\n    for (var j = 0; j < step; j++)\n      acc = acc.dbl();\n    doubles.push(acc);\n  }\n  return {\n    step: step,\n    points: doubles,\n  };\n};\n\nBasePoint.prototype._getNAFPoints = function _getNAFPoints(wnd) {\n  if (this.precomputed && this.precomputed.naf)\n    return this.precomputed.naf;\n\n  var res = [ this ];\n  var max = (1 << wnd) - 1;\n  var dbl = max === 1 ? null : this.dbl();\n  for (var i = 1; i < max; i++)\n    res[i] = res[i - 1].add(dbl);\n  return {\n    wnd: wnd,\n    points: res,\n  };\n};\n\nBasePoint.prototype._getBeta = function _getBeta() {\n  return null;\n};\n\nBasePoint.prototype.dblp = function dblp(k) {\n  var r = this;\n  for (var i = 0; i < k; i++)\n    r = r.dbl();\n  return r;\n};","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/edwards.js","source":"'use strict';\n\nvar utils = require('../utils');\nvar BN = require('bn.js');\nvar inherits = require('inherits');\nvar Base = require('./base');\n\nvar assert = utils.assert;\n\nfunction EdwardsCurve(conf) {\n  // NOTE: Important as we are creating point in Base.call()\n  this.twisted = (conf.a | 0) !== 1;\n  this.mOneA = this.twisted && (conf.a | 0) === -1;\n  this.extended = this.mOneA;\n\n  Base.call(this, 'edwards', conf);\n\n  this.a = new BN(conf.a, 16).umod(this.red.m);\n  this.a = this.a.toRed(this.red);\n  this.c = new BN(conf.c, 16).toRed(this.red);\n  this.c2 = this.c.redSqr();\n  this.d = new BN(conf.d, 16).toRed(this.red);\n  this.dd = this.d.redAdd(this.d);\n\n  assert(!this.twisted || this.c.fromRed().cmpn(1) === 0);\n  this.oneC = (conf.c | 0) === 1;\n}\ninherits(EdwardsCurve, Base);\nmodule.exports = EdwardsCurve;\n\nEdwardsCurve.prototype._mulA = function _mulA(num) {\n  if (this.mOneA)\n    return num.redNeg();\n  else\n    return this.a.redMul(num);\n};\n\nEdwardsCurve.prototype._mulC = function _mulC(num) {\n  if (this.oneC)\n    return num;\n  else\n    return this.c.redMul(num);\n};\n\n// Just for compatibility with Short curve\nEdwardsCurve.prototype.jpoint = function jpoint(x, y, z, t) {\n  return this.point(x, y, z, t);\n};\n\nEdwardsCurve.prototype.pointFromX = function pointFromX(x, odd) {\n  x = new BN(x, 16);\n  if (!x.red)\n    x = x.toRed(this.red);\n\n  var x2 = x.redSqr();\n  var rhs = this.c2.redSub(this.a.redMul(x2));\n  var lhs = this.one.redSub(this.c2.redMul(this.d).redMul(x2));\n\n  var y2 = rhs.redMul(lhs.redInvm());\n  var y = y2.redSqrt();\n  if (y.redSqr().redSub(y2).cmp(this.zero) !== 0)\n    throw new Error('invalid point');\n\n  var isOdd = y.fromRed().isOdd();\n  if (odd && !isOdd || !odd && isOdd)\n    y = y.redNeg();\n\n  return this.point(x, y);\n};\n\nEdwardsCurve.prototype.pointFromY = function pointFromY(y, odd) {\n  y = new BN(y, 16);\n  if (!y.red)\n    y = y.toRed(this.red);\n\n  // x^2 = (y^2 - c^2) / (c^2 d y^2 - a)\n  var y2 = y.redSqr();\n  var lhs = y2.redSub(this.c2);\n  var rhs = y2.redMul(this.d).redMul(this.c2).redSub(this.a);\n  var x2 = lhs.redMul(rhs.redInvm());\n\n  if (x2.cmp(this.zero) === 0) {\n    if (odd)\n      throw new Error('invalid point');\n    else\n      return this.point(this.zero, y);\n  }\n\n  var x = x2.redSqrt();\n  if (x.redSqr().redSub(x2).cmp(this.zero) !== 0)\n    throw new Error('invalid point');\n\n  if (x.fromRed().isOdd() !== odd)\n    x = x.redNeg();\n\n  return this.point(x, y);\n};\n\nEdwardsCurve.prototype.validate = function validate(point) {\n  if (point.isInfinity())\n    return true;\n\n  // Curve: A * X^2 + Y^2 = C^2 * (1 + D * X^2 * Y^2)\n  point.normalize();\n\n  var x2 = point.x.redSqr();\n  var y2 = point.y.redSqr();\n  var lhs = x2.redMul(this.a).redAdd(y2);\n  var rhs = this.c2.redMul(this.one.redAdd(this.d.redMul(x2).redMul(y2)));\n\n  return lhs.cmp(rhs) === 0;\n};\n\nfunction Point(curve, x, y, z, t) {\n  Base.BasePoint.call(this, curve, 'projective');\n  if (x === null && y === null && z === null) {\n    this.x = this.curve.zero;\n    this.y = this.curve.one;\n    this.z = this.curve.one;\n    this.t = this.curve.zero;\n    this.zOne = true;\n  } else {\n    this.x = new BN(x, 16);\n    this.y = new BN(y, 16);\n    this.z = z ? new BN(z, 16) : this.curve.one;\n    this.t = t && new BN(t, 16);\n    if (!this.x.red)\n      this.x = this.x.toRed(this.curve.red);\n    if (!this.y.red)\n      this.y = this.y.toRed(this.curve.red);\n    if (!this.z.red)\n      this.z = this.z.toRed(this.curve.red);\n    if (this.t && !this.t.red)\n      this.t = this.t.toRed(this.curve.red);\n    this.zOne = this.z === this.curve.one;\n\n    // Use extended coordinates\n    if (this.curve.extended && !this.t) {\n      this.t = this.x.redMul(this.y);\n      if (!this.zOne)\n        this.t = this.t.redMul(this.z.redInvm());\n    }\n  }\n}\ninherits(Point, Base.BasePoint);\n\nEdwardsCurve.prototype.pointFromJSON = function pointFromJSON(obj) {\n  return Point.fromJSON(this, obj);\n};\n\nEdwardsCurve.prototype.point = function point(x, y, z, t) {\n  return new Point(this, x, y, z, t);\n};\n\nPoint.fromJSON = function fromJSON(curve, obj) {\n  return new Point(curve, obj[0], obj[1], obj[2]);\n};\n\nPoint.prototype.inspect = function inspect() {\n  if (this.isInfinity())\n    return '<EC Point Infinity>';\n  return '<EC Point x: ' + this.x.fromRed().toString(16, 2) +\n      ' y: ' + this.y.fromRed().toString(16, 2) +\n      ' z: ' + this.z.fromRed().toString(16, 2) + '>';\n};\n\nPoint.prototype.isInfinity = function isInfinity() {\n  // XXX This code assumes that zero is always zero in red\n  return this.x.cmpn(0) === 0 &&\n    (this.y.cmp(this.z) === 0 ||\n    (this.zOne && this.y.cmp(this.curve.c) === 0));\n};\n\nPoint.prototype._extDbl = function _extDbl() {\n  // hyperelliptic.org/EFD/g1p/auto-twisted-extended-1.html\n  //     #doubling-dbl-2008-hwcd\n  // 4M + 4S\n\n  // A = X1^2\n  var a = this.x.redSqr();\n  // B = Y1^2\n  var b = this.y.redSqr();\n  // C = 2 * Z1^2\n  var c = this.z.redSqr();\n  c = c.redIAdd(c);\n  // D = a * A\n  var d = this.curve._mulA(a);\n  // E = (X1 + Y1)^2 - A - B\n  var e = this.x.redAdd(this.y).redSqr().redISub(a).redISub(b);\n  // G = D + B\n  var g = d.redAdd(b);\n  // F = G - C\n  var f = g.redSub(c);\n  // H = D - B\n  var h = d.redSub(b);\n  // X3 = E * F\n  var nx = e.redMul(f);\n  // Y3 = G * H\n  var ny = g.redMul(h);\n  // T3 = E * H\n  var nt = e.redMul(h);\n  // Z3 = F * G\n  var nz = f.redMul(g);\n  return this.curve.point(nx, ny, nz, nt);\n};\n\nPoint.prototype._projDbl = function _projDbl() {\n  // hyperelliptic.org/EFD/g1p/auto-twisted-projective.html\n  //     #doubling-dbl-2008-bbjlp\n  //     #doubling-dbl-2007-bl\n  // and others\n  // Generally 3M + 4S or 2M + 4S\n\n  // B = (X1 + Y1)^2\n  var b = this.x.redAdd(this.y).redSqr();\n  // C = X1^2\n  var c = this.x.redSqr();\n  // D = Y1^2\n  var d = this.y.redSqr();\n\n  var nx;\n  var ny;\n  var nz;\n  var e;\n  var h;\n  var j;\n  if (this.curve.twisted) {\n    // E = a * C\n    e = this.curve._mulA(c);\n    // F = E + D\n    var f = e.redAdd(d);\n    if (this.zOne) {\n      // X3 = (B - C - D) * (F - 2)\n      nx = b.redSub(c).redSub(d).redMul(f.redSub(this.curve.two));\n      // Y3 = F * (E - D)\n      ny = f.redMul(e.redSub(d));\n      // Z3 = F^2 - 2 * F\n      nz = f.redSqr().redSub(f).redSub(f);\n    } else {\n      // H = Z1^2\n      h = this.z.redSqr();\n      // J = F - 2 * H\n      j = f.redSub(h).redISub(h);\n      // X3 = (B-C-D)*J\n      nx = b.redSub(c).redISub(d).redMul(j);\n      // Y3 = F * (E - D)\n      ny = f.redMul(e.redSub(d));\n      // Z3 = F * J\n      nz = f.redMul(j);\n    }\n  } else {\n    // E = C + D\n    e = c.redAdd(d);\n    // H = (c * Z1)^2\n    h = this.curve._mulC(this.z).redSqr();\n    // J = E - 2 * H\n    j = e.redSub(h).redSub(h);\n    // X3 = c * (B - E) * J\n    nx = this.curve._mulC(b.redISub(e)).redMul(j);\n    // Y3 = c * E * (C - D)\n    ny = this.curve._mulC(e).redMul(c.redISub(d));\n    // Z3 = E * J\n    nz = e.redMul(j);\n  }\n  return this.curve.point(nx, ny, nz);\n};\n\nPoint.prototype.dbl = function dbl() {\n  if (this.isInfinity())\n    return this;\n\n  // Double in extended coordinates\n  if (this.curve.extended)\n    return this._extDbl();\n  else\n    return this._projDbl();\n};\n\nPoint.prototype._extAdd = function _extAdd(p) {\n  // hyperelliptic.org/EFD/g1p/auto-twisted-extended-1.html\n  //     #addition-add-2008-hwcd-3\n  // 8M\n\n  // A = (Y1 - X1) * (Y2 - X2)\n  var a = this.y.redSub(this.x).redMul(p.y.redSub(p.x));\n  // B = (Y1 + X1) * (Y2 + X2)\n  var b = this.y.redAdd(this.x).redMul(p.y.redAdd(p.x));\n  // C = T1 * k * T2\n  var c = this.t.redMul(this.curve.dd).redMul(p.t);\n  // D = Z1 * 2 * Z2\n  var d = this.z.redMul(p.z.redAdd(p.z));\n  // E = B - A\n  var e = b.redSub(a);\n  // F = D - C\n  var f = d.redSub(c);\n  // G = D + C\n  var g = d.redAdd(c);\n  // H = B + A\n  var h = b.redAdd(a);\n  // X3 = E * F\n  var nx = e.redMul(f);\n  // Y3 = G * H\n  var ny = g.redMul(h);\n  // T3 = E * H\n  var nt = e.redMul(h);\n  // Z3 = F * G\n  var nz = f.redMul(g);\n  return this.curve.point(nx, ny, nz, nt);\n};\n\nPoint.prototype._projAdd = function _projAdd(p) {\n  // hyperelliptic.org/EFD/g1p/auto-twisted-projective.html\n  //     #addition-add-2008-bbjlp\n  //     #addition-add-2007-bl\n  // 10M + 1S\n\n  // A = Z1 * Z2\n  var a = this.z.redMul(p.z);\n  // B = A^2\n  var b = a.redSqr();\n  // C = X1 * X2\n  var c = this.x.redMul(p.x);\n  // D = Y1 * Y2\n  var d = this.y.redMul(p.y);\n  // E = d * C * D\n  var e = this.curve.d.redMul(c).redMul(d);\n  // F = B - E\n  var f = b.redSub(e);\n  // G = B + E\n  var g = b.redAdd(e);\n  // X3 = A * F * ((X1 + Y1) * (X2 + Y2) - C - D)\n  var tmp = this.x.redAdd(this.y).redMul(p.x.redAdd(p.y)).redISub(c).redISub(d);\n  var nx = a.redMul(f).redMul(tmp);\n  var ny;\n  var nz;\n  if (this.curve.twisted) {\n    // Y3 = A * G * (D - a * C)\n    ny = a.redMul(g).redMul(d.redSub(this.curve._mulA(c)));\n    // Z3 = F * G\n    nz = f.redMul(g);\n  } else {\n    // Y3 = A * G * (D - C)\n    ny = a.redMul(g).redMul(d.redSub(c));\n    // Z3 = c * F * G\n    nz = this.curve._mulC(f).redMul(g);\n  }\n  return this.curve.point(nx, ny, nz);\n};\n\nPoint.prototype.add = function add(p) {\n  if (this.isInfinity())\n    return p;\n  if (p.isInfinity())\n    return this;\n\n  if (this.curve.extended)\n    return this._extAdd(p);\n  else\n    return this._projAdd(p);\n};\n\nPoint.prototype.mul = function mul(k) {\n  if (this._hasDoubles(k))\n    return this.curve._fixedNafMul(this, k);\n  else\n    return this.curve._wnafMul(this, k);\n};\n\nPoint.prototype.mulAdd = function mulAdd(k1, p, k2) {\n  return this.curve._wnafMulAdd(1, [ this, p ], [ k1, k2 ], 2, false);\n};\n\nPoint.prototype.jmulAdd = function jmulAdd(k1, p, k2) {\n  return this.curve._wnafMulAdd(1, [ this, p ], [ k1, k2 ], 2, true);\n};\n\nPoint.prototype.normalize = function normalize() {\n  if (this.zOne)\n    return this;\n\n  // Normalize coordinates\n  var zi = this.z.redInvm();\n  this.x = this.x.redMul(zi);\n  this.y = this.y.redMul(zi);\n  if (this.t)\n    this.t = this.t.redMul(zi);\n  this.z = this.curve.one;\n  this.zOne = true;\n  return this;\n};\n\nPoint.prototype.neg = function neg() {\n  return this.curve.point(this.x.redNeg(),\n    this.y,\n    this.z,\n    this.t && this.t.redNeg());\n};\n\nPoint.prototype.getX = function getX() {\n  this.normalize();\n  return this.x.fromRed();\n};\n\nPoint.prototype.getY = function getY() {\n  this.normalize();\n  return this.y.fromRed();\n};\n\nPoint.prototype.eq = function eq(other) {\n  return this === other ||\n         this.getX().cmp(other.getX()) === 0 &&\n         this.getY().cmp(other.getY()) === 0;\n};\n\nPoint.prototype.eqXToP = function eqXToP(x) {\n  var rx = x.toRed(this.curve.red).redMul(this.z);\n  if (this.x.cmp(rx) === 0)\n    return true;\n\n  var xc = x.clone();\n  var t = this.curve.redN.redMul(this.z);\n  for (;;) {\n    xc.iadd(this.curve.n);\n    if (xc.cmp(this.curve.p) >= 0)\n      return false;\n\n    rx.redIAdd(t);\n    if (this.x.cmp(rx) === 0)\n      return true;\n  }\n};\n\n// Compatibility with BaseCurve\nPoint.prototype.toP = Point.prototype.normalize;\nPoint.prototype.mixedAdd = Point.prototype.add;","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","./base":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/base.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/index.js","source":"'use strict';\n\nvar curve = exports;\n\ncurve.base = require('./base');\ncurve.short = require('./short');\ncurve.mont = require('./mont');\ncurve.edwards = require('./edwards');","deps":{"./base":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/base.js","./edwards":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/edwards.js","./mont":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/mont.js","./short":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/short.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/mont.js","source":"'use strict';\n\nvar BN = require('bn.js');\nvar inherits = require('inherits');\nvar Base = require('./base');\n\nvar utils = require('../utils');\n\nfunction MontCurve(conf) {\n  Base.call(this, 'mont', conf);\n\n  this.a = new BN(conf.a, 16).toRed(this.red);\n  this.b = new BN(conf.b, 16).toRed(this.red);\n  this.i4 = new BN(4).toRed(this.red).redInvm();\n  this.two = new BN(2).toRed(this.red);\n  this.a24 = this.i4.redMul(this.a.redAdd(this.two));\n}\ninherits(MontCurve, Base);\nmodule.exports = MontCurve;\n\nMontCurve.prototype.validate = function validate(point) {\n  var x = point.normalize().x;\n  var x2 = x.redSqr();\n  var rhs = x2.redMul(x).redAdd(x2.redMul(this.a)).redAdd(x);\n  var y = rhs.redSqrt();\n\n  return y.redSqr().cmp(rhs) === 0;\n};\n\nfunction Point(curve, x, z) {\n  Base.BasePoint.call(this, curve, 'projective');\n  if (x === null && z === null) {\n    this.x = this.curve.one;\n    this.z = this.curve.zero;\n  } else {\n    this.x = new BN(x, 16);\n    this.z = new BN(z, 16);\n    if (!this.x.red)\n      this.x = this.x.toRed(this.curve.red);\n    if (!this.z.red)\n      this.z = this.z.toRed(this.curve.red);\n  }\n}\ninherits(Point, Base.BasePoint);\n\nMontCurve.prototype.decodePoint = function decodePoint(bytes, enc) {\n  return this.point(utils.toArray(bytes, enc), 1);\n};\n\nMontCurve.prototype.point = function point(x, z) {\n  return new Point(this, x, z);\n};\n\nMontCurve.prototype.pointFromJSON = function pointFromJSON(obj) {\n  return Point.fromJSON(this, obj);\n};\n\nPoint.prototype.precompute = function precompute() {\n  // No-op\n};\n\nPoint.prototype._encode = function _encode() {\n  return this.getX().toArray('be', this.curve.p.byteLength());\n};\n\nPoint.fromJSON = function fromJSON(curve, obj) {\n  return new Point(curve, obj[0], obj[1] || curve.one);\n};\n\nPoint.prototype.inspect = function inspect() {\n  if (this.isInfinity())\n    return '<EC Point Infinity>';\n  return '<EC Point x: ' + this.x.fromRed().toString(16, 2) +\n      ' z: ' + this.z.fromRed().toString(16, 2) + '>';\n};\n\nPoint.prototype.isInfinity = function isInfinity() {\n  // XXX This code assumes that zero is always zero in red\n  return this.z.cmpn(0) === 0;\n};\n\nPoint.prototype.dbl = function dbl() {\n  // http://hyperelliptic.org/EFD/g1p/auto-montgom-xz.html#doubling-dbl-1987-m-3\n  // 2M + 2S + 4A\n\n  // A = X1 + Z1\n  var a = this.x.redAdd(this.z);\n  // AA = A^2\n  var aa = a.redSqr();\n  // B = X1 - Z1\n  var b = this.x.redSub(this.z);\n  // BB = B^2\n  var bb = b.redSqr();\n  // C = AA - BB\n  var c = aa.redSub(bb);\n  // X3 = AA * BB\n  var nx = aa.redMul(bb);\n  // Z3 = C * (BB + A24 * C)\n  var nz = c.redMul(bb.redAdd(this.curve.a24.redMul(c)));\n  return this.curve.point(nx, nz);\n};\n\nPoint.prototype.add = function add() {\n  throw new Error('Not supported on Montgomery curve');\n};\n\nPoint.prototype.diffAdd = function diffAdd(p, diff) {\n  // http://hyperelliptic.org/EFD/g1p/auto-montgom-xz.html#diffadd-dadd-1987-m-3\n  // 4M + 2S + 6A\n\n  // A = X2 + Z2\n  var a = this.x.redAdd(this.z);\n  // B = X2 - Z2\n  var b = this.x.redSub(this.z);\n  // C = X3 + Z3\n  var c = p.x.redAdd(p.z);\n  // D = X3 - Z3\n  var d = p.x.redSub(p.z);\n  // DA = D * A\n  var da = d.redMul(a);\n  // CB = C * B\n  var cb = c.redMul(b);\n  // X5 = Z1 * (DA + CB)^2\n  var nx = diff.z.redMul(da.redAdd(cb).redSqr());\n  // Z5 = X1 * (DA - CB)^2\n  var nz = diff.x.redMul(da.redISub(cb).redSqr());\n  return this.curve.point(nx, nz);\n};\n\nPoint.prototype.mul = function mul(k) {\n  var t = k.clone();\n  var a = this; // (N / 2) * Q + Q\n  var b = this.curve.point(null, null); // (N / 2) * Q\n  var c = this; // Q\n\n  for (var bits = []; t.cmpn(0) !== 0; t.iushrn(1))\n    bits.push(t.andln(1));\n\n  for (var i = bits.length - 1; i >= 0; i--) {\n    if (bits[i] === 0) {\n      // N * Q + Q = ((N / 2) * Q + Q)) + (N / 2) * Q\n      a = a.diffAdd(b, c);\n      // N * Q = 2 * ((N / 2) * Q + Q))\n      b = b.dbl();\n    } else {\n      // N * Q = ((N / 2) * Q + Q) + ((N / 2) * Q)\n      b = a.diffAdd(b, c);\n      // N * Q + Q = 2 * ((N / 2) * Q + Q)\n      a = a.dbl();\n    }\n  }\n  return b;\n};\n\nPoint.prototype.mulAdd = function mulAdd() {\n  throw new Error('Not supported on Montgomery curve');\n};\n\nPoint.prototype.jumlAdd = function jumlAdd() {\n  throw new Error('Not supported on Montgomery curve');\n};\n\nPoint.prototype.eq = function eq(other) {\n  return this.getX().cmp(other.getX()) === 0;\n};\n\nPoint.prototype.normalize = function normalize() {\n  this.x = this.x.redMul(this.z.redInvm());\n  this.z = this.curve.one;\n  return this;\n};\n\nPoint.prototype.getX = function getX() {\n  // Normalize coordinates\n  this.normalize();\n\n  return this.x.fromRed();\n};","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","./base":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/base.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/short.js","source":"'use strict';\n\nvar utils = require('../utils');\nvar BN = require('bn.js');\nvar inherits = require('inherits');\nvar Base = require('./base');\n\nvar assert = utils.assert;\n\nfunction ShortCurve(conf) {\n  Base.call(this, 'short', conf);\n\n  this.a = new BN(conf.a, 16).toRed(this.red);\n  this.b = new BN(conf.b, 16).toRed(this.red);\n  this.tinv = this.two.redInvm();\n\n  this.zeroA = this.a.fromRed().cmpn(0) === 0;\n  this.threeA = this.a.fromRed().sub(this.p).cmpn(-3) === 0;\n\n  // If the curve is endomorphic, precalculate beta and lambda\n  this.endo = this._getEndomorphism(conf);\n  this._endoWnafT1 = new Array(4);\n  this._endoWnafT2 = new Array(4);\n}\ninherits(ShortCurve, Base);\nmodule.exports = ShortCurve;\n\nShortCurve.prototype._getEndomorphism = function _getEndomorphism(conf) {\n  // No efficient endomorphism\n  if (!this.zeroA || !this.g || !this.n || this.p.modn(3) !== 1)\n    return;\n\n  // Compute beta and lambda, that lambda * P = (beta * Px; Py)\n  var beta;\n  var lambda;\n  if (conf.beta) {\n    beta = new BN(conf.beta, 16).toRed(this.red);\n  } else {\n    var betas = this._getEndoRoots(this.p);\n    // Choose the smallest beta\n    beta = betas[0].cmp(betas[1]) < 0 ? betas[0] : betas[1];\n    beta = beta.toRed(this.red);\n  }\n  if (conf.lambda) {\n    lambda = new BN(conf.lambda, 16);\n  } else {\n    // Choose the lambda that is matching selected beta\n    var lambdas = this._getEndoRoots(this.n);\n    if (this.g.mul(lambdas[0]).x.cmp(this.g.x.redMul(beta)) === 0) {\n      lambda = lambdas[0];\n    } else {\n      lambda = lambdas[1];\n      assert(this.g.mul(lambda).x.cmp(this.g.x.redMul(beta)) === 0);\n    }\n  }\n\n  // Get basis vectors, used for balanced length-two representation\n  var basis;\n  if (conf.basis) {\n    basis = conf.basis.map(function(vec) {\n      return {\n        a: new BN(vec.a, 16),\n        b: new BN(vec.b, 16),\n      };\n    });\n  } else {\n    basis = this._getEndoBasis(lambda);\n  }\n\n  return {\n    beta: beta,\n    lambda: lambda,\n    basis: basis,\n  };\n};\n\nShortCurve.prototype._getEndoRoots = function _getEndoRoots(num) {\n  // Find roots of for x^2 + x + 1 in F\n  // Root = (-1 +- Sqrt(-3)) / 2\n  //\n  var red = num === this.p ? this.red : BN.mont(num);\n  var tinv = new BN(2).toRed(red).redInvm();\n  var ntinv = tinv.redNeg();\n\n  var s = new BN(3).toRed(red).redNeg().redSqrt().redMul(tinv);\n\n  var l1 = ntinv.redAdd(s).fromRed();\n  var l2 = ntinv.redSub(s).fromRed();\n  return [ l1, l2 ];\n};\n\nShortCurve.prototype._getEndoBasis = function _getEndoBasis(lambda) {\n  // aprxSqrt >= sqrt(this.n)\n  var aprxSqrt = this.n.ushrn(Math.floor(this.n.bitLength() / 2));\n\n  // 3.74\n  // Run EGCD, until r(L + 1) < aprxSqrt\n  var u = lambda;\n  var v = this.n.clone();\n  var x1 = new BN(1);\n  var y1 = new BN(0);\n  var x2 = new BN(0);\n  var y2 = new BN(1);\n\n  // NOTE: all vectors are roots of: a + b * lambda = 0 (mod n)\n  var a0;\n  var b0;\n  // First vector\n  var a1;\n  var b1;\n  // Second vector\n  var a2;\n  var b2;\n\n  var prevR;\n  var i = 0;\n  var r;\n  var x;\n  while (u.cmpn(0) !== 0) {\n    var q = v.div(u);\n    r = v.sub(q.mul(u));\n    x = x2.sub(q.mul(x1));\n    var y = y2.sub(q.mul(y1));\n\n    if (!a1 && r.cmp(aprxSqrt) < 0) {\n      a0 = prevR.neg();\n      b0 = x1;\n      a1 = r.neg();\n      b1 = x;\n    } else if (a1 && ++i === 2) {\n      break;\n    }\n    prevR = r;\n\n    v = u;\n    u = r;\n    x2 = x1;\n    x1 = x;\n    y2 = y1;\n    y1 = y;\n  }\n  a2 = r.neg();\n  b2 = x;\n\n  var len1 = a1.sqr().add(b1.sqr());\n  var len2 = a2.sqr().add(b2.sqr());\n  if (len2.cmp(len1) >= 0) {\n    a2 = a0;\n    b2 = b0;\n  }\n\n  // Normalize signs\n  if (a1.negative) {\n    a1 = a1.neg();\n    b1 = b1.neg();\n  }\n  if (a2.negative) {\n    a2 = a2.neg();\n    b2 = b2.neg();\n  }\n\n  return [\n    { a: a1, b: b1 },\n    { a: a2, b: b2 },\n  ];\n};\n\nShortCurve.prototype._endoSplit = function _endoSplit(k) {\n  var basis = this.endo.basis;\n  var v1 = basis[0];\n  var v2 = basis[1];\n\n  var c1 = v2.b.mul(k).divRound(this.n);\n  var c2 = v1.b.neg().mul(k).divRound(this.n);\n\n  var p1 = c1.mul(v1.a);\n  var p2 = c2.mul(v2.a);\n  var q1 = c1.mul(v1.b);\n  var q2 = c2.mul(v2.b);\n\n  // Calculate answer\n  var k1 = k.sub(p1).sub(p2);\n  var k2 = q1.add(q2).neg();\n  return { k1: k1, k2: k2 };\n};\n\nShortCurve.prototype.pointFromX = function pointFromX(x, odd) {\n  x = new BN(x, 16);\n  if (!x.red)\n    x = x.toRed(this.red);\n\n  var y2 = x.redSqr().redMul(x).redIAdd(x.redMul(this.a)).redIAdd(this.b);\n  var y = y2.redSqrt();\n  if (y.redSqr().redSub(y2).cmp(this.zero) !== 0)\n    throw new Error('invalid point');\n\n  // XXX Is there any way to tell if the number is odd without converting it\n  // to non-red form?\n  var isOdd = y.fromRed().isOdd();\n  if (odd && !isOdd || !odd && isOdd)\n    y = y.redNeg();\n\n  return this.point(x, y);\n};\n\nShortCurve.prototype.validate = function validate(point) {\n  if (point.inf)\n    return true;\n\n  var x = point.x;\n  var y = point.y;\n\n  var ax = this.a.redMul(x);\n  var rhs = x.redSqr().redMul(x).redIAdd(ax).redIAdd(this.b);\n  return y.redSqr().redISub(rhs).cmpn(0) === 0;\n};\n\nShortCurve.prototype._endoWnafMulAdd =\n    function _endoWnafMulAdd(points, coeffs, jacobianResult) {\n      var npoints = this._endoWnafT1;\n      var ncoeffs = this._endoWnafT2;\n      for (var i = 0; i < points.length; i++) {\n        var split = this._endoSplit(coeffs[i]);\n        var p = points[i];\n        var beta = p._getBeta();\n\n        if (split.k1.negative) {\n          split.k1.ineg();\n          p = p.neg(true);\n        }\n        if (split.k2.negative) {\n          split.k2.ineg();\n          beta = beta.neg(true);\n        }\n\n        npoints[i * 2] = p;\n        npoints[i * 2 + 1] = beta;\n        ncoeffs[i * 2] = split.k1;\n        ncoeffs[i * 2 + 1] = split.k2;\n      }\n      var res = this._wnafMulAdd(1, npoints, ncoeffs, i * 2, jacobianResult);\n\n      // Clean-up references to points and coefficients\n      for (var j = 0; j < i * 2; j++) {\n        npoints[j] = null;\n        ncoeffs[j] = null;\n      }\n      return res;\n    };\n\nfunction Point(curve, x, y, isRed) {\n  Base.BasePoint.call(this, curve, 'affine');\n  if (x === null && y === null) {\n    this.x = null;\n    this.y = null;\n    this.inf = true;\n  } else {\n    this.x = new BN(x, 16);\n    this.y = new BN(y, 16);\n    // Force redgomery representation when loading from JSON\n    if (isRed) {\n      this.x.forceRed(this.curve.red);\n      this.y.forceRed(this.curve.red);\n    }\n    if (!this.x.red)\n      this.x = this.x.toRed(this.curve.red);\n    if (!this.y.red)\n      this.y = this.y.toRed(this.curve.red);\n    this.inf = false;\n  }\n}\ninherits(Point, Base.BasePoint);\n\nShortCurve.prototype.point = function point(x, y, isRed) {\n  return new Point(this, x, y, isRed);\n};\n\nShortCurve.prototype.pointFromJSON = function pointFromJSON(obj, red) {\n  return Point.fromJSON(this, obj, red);\n};\n\nPoint.prototype._getBeta = function _getBeta() {\n  if (!this.curve.endo)\n    return;\n\n  var pre = this.precomputed;\n  if (pre && pre.beta)\n    return pre.beta;\n\n  var beta = this.curve.point(this.x.redMul(this.curve.endo.beta), this.y);\n  if (pre) {\n    var curve = this.curve;\n    var endoMul = function(p) {\n      return curve.point(p.x.redMul(curve.endo.beta), p.y);\n    };\n    pre.beta = beta;\n    beta.precomputed = {\n      beta: null,\n      naf: pre.naf && {\n        wnd: pre.naf.wnd,\n        points: pre.naf.points.map(endoMul),\n      },\n      doubles: pre.doubles && {\n        step: pre.doubles.step,\n        points: pre.doubles.points.map(endoMul),\n      },\n    };\n  }\n  return beta;\n};\n\nPoint.prototype.toJSON = function toJSON() {\n  if (!this.precomputed)\n    return [ this.x, this.y ];\n\n  return [ this.x, this.y, this.precomputed && {\n    doubles: this.precomputed.doubles && {\n      step: this.precomputed.doubles.step,\n      points: this.precomputed.doubles.points.slice(1),\n    },\n    naf: this.precomputed.naf && {\n      wnd: this.precomputed.naf.wnd,\n      points: this.precomputed.naf.points.slice(1),\n    },\n  } ];\n};\n\nPoint.fromJSON = function fromJSON(curve, obj, red) {\n  if (typeof obj === 'string')\n    obj = JSON.parse(obj);\n  var res = curve.point(obj[0], obj[1], red);\n  if (!obj[2])\n    return res;\n\n  function obj2point(obj) {\n    return curve.point(obj[0], obj[1], red);\n  }\n\n  var pre = obj[2];\n  res.precomputed = {\n    beta: null,\n    doubles: pre.doubles && {\n      step: pre.doubles.step,\n      points: [ res ].concat(pre.doubles.points.map(obj2point)),\n    },\n    naf: pre.naf && {\n      wnd: pre.naf.wnd,\n      points: [ res ].concat(pre.naf.points.map(obj2point)),\n    },\n  };\n  return res;\n};\n\nPoint.prototype.inspect = function inspect() {\n  if (this.isInfinity())\n    return '<EC Point Infinity>';\n  return '<EC Point x: ' + this.x.fromRed().toString(16, 2) +\n      ' y: ' + this.y.fromRed().toString(16, 2) + '>';\n};\n\nPoint.prototype.isInfinity = function isInfinity() {\n  return this.inf;\n};\n\nPoint.prototype.add = function add(p) {\n  // O + P = P\n  if (this.inf)\n    return p;\n\n  // P + O = P\n  if (p.inf)\n    return this;\n\n  // P + P = 2P\n  if (this.eq(p))\n    return this.dbl();\n\n  // P + (-P) = O\n  if (this.neg().eq(p))\n    return this.curve.point(null, null);\n\n  // P + Q = O\n  if (this.x.cmp(p.x) === 0)\n    return this.curve.point(null, null);\n\n  var c = this.y.redSub(p.y);\n  if (c.cmpn(0) !== 0)\n    c = c.redMul(this.x.redSub(p.x).redInvm());\n  var nx = c.redSqr().redISub(this.x).redISub(p.x);\n  var ny = c.redMul(this.x.redSub(nx)).redISub(this.y);\n  return this.curve.point(nx, ny);\n};\n\nPoint.prototype.dbl = function dbl() {\n  if (this.inf)\n    return this;\n\n  // 2P = O\n  var ys1 = this.y.redAdd(this.y);\n  if (ys1.cmpn(0) === 0)\n    return this.curve.point(null, null);\n\n  var a = this.curve.a;\n\n  var x2 = this.x.redSqr();\n  var dyinv = ys1.redInvm();\n  var c = x2.redAdd(x2).redIAdd(x2).redIAdd(a).redMul(dyinv);\n\n  var nx = c.redSqr().redISub(this.x.redAdd(this.x));\n  var ny = c.redMul(this.x.redSub(nx)).redISub(this.y);\n  return this.curve.point(nx, ny);\n};\n\nPoint.prototype.getX = function getX() {\n  return this.x.fromRed();\n};\n\nPoint.prototype.getY = function getY() {\n  return this.y.fromRed();\n};\n\nPoint.prototype.mul = function mul(k) {\n  k = new BN(k, 16);\n  if (this.isInfinity())\n    return this;\n  else if (this._hasDoubles(k))\n    return this.curve._fixedNafMul(this, k);\n  else if (this.curve.endo)\n    return this.curve._endoWnafMulAdd([ this ], [ k ]);\n  else\n    return this.curve._wnafMul(this, k);\n};\n\nPoint.prototype.mulAdd = function mulAdd(k1, p2, k2) {\n  var points = [ this, p2 ];\n  var coeffs = [ k1, k2 ];\n  if (this.curve.endo)\n    return this.curve._endoWnafMulAdd(points, coeffs);\n  else\n    return this.curve._wnafMulAdd(1, points, coeffs, 2);\n};\n\nPoint.prototype.jmulAdd = function jmulAdd(k1, p2, k2) {\n  var points = [ this, p2 ];\n  var coeffs = [ k1, k2 ];\n  if (this.curve.endo)\n    return this.curve._endoWnafMulAdd(points, coeffs, true);\n  else\n    return this.curve._wnafMulAdd(1, points, coeffs, 2, true);\n};\n\nPoint.prototype.eq = function eq(p) {\n  return this === p ||\n         this.inf === p.inf &&\n             (this.inf || this.x.cmp(p.x) === 0 && this.y.cmp(p.y) === 0);\n};\n\nPoint.prototype.neg = function neg(_precompute) {\n  if (this.inf)\n    return this;\n\n  var res = this.curve.point(this.x, this.y.redNeg());\n  if (_precompute && this.precomputed) {\n    var pre = this.precomputed;\n    var negate = function(p) {\n      return p.neg();\n    };\n    res.precomputed = {\n      naf: pre.naf && {\n        wnd: pre.naf.wnd,\n        points: pre.naf.points.map(negate),\n      },\n      doubles: pre.doubles && {\n        step: pre.doubles.step,\n        points: pre.doubles.points.map(negate),\n      },\n    };\n  }\n  return res;\n};\n\nPoint.prototype.toJ = function toJ() {\n  if (this.inf)\n    return this.curve.jpoint(null, null, null);\n\n  var res = this.curve.jpoint(this.x, this.y, this.curve.one);\n  return res;\n};\n\nfunction JPoint(curve, x, y, z) {\n  Base.BasePoint.call(this, curve, 'jacobian');\n  if (x === null && y === null && z === null) {\n    this.x = this.curve.one;\n    this.y = this.curve.one;\n    this.z = new BN(0);\n  } else {\n    this.x = new BN(x, 16);\n    this.y = new BN(y, 16);\n    this.z = new BN(z, 16);\n  }\n  if (!this.x.red)\n    this.x = this.x.toRed(this.curve.red);\n  if (!this.y.red)\n    this.y = this.y.toRed(this.curve.red);\n  if (!this.z.red)\n    this.z = this.z.toRed(this.curve.red);\n\n  this.zOne = this.z === this.curve.one;\n}\ninherits(JPoint, Base.BasePoint);\n\nShortCurve.prototype.jpoint = function jpoint(x, y, z) {\n  return new JPoint(this, x, y, z);\n};\n\nJPoint.prototype.toP = function toP() {\n  if (this.isInfinity())\n    return this.curve.point(null, null);\n\n  var zinv = this.z.redInvm();\n  var zinv2 = zinv.redSqr();\n  var ax = this.x.redMul(zinv2);\n  var ay = this.y.redMul(zinv2).redMul(zinv);\n\n  return this.curve.point(ax, ay);\n};\n\nJPoint.prototype.neg = function neg() {\n  return this.curve.jpoint(this.x, this.y.redNeg(), this.z);\n};\n\nJPoint.prototype.add = function add(p) {\n  // O + P = P\n  if (this.isInfinity())\n    return p;\n\n  // P + O = P\n  if (p.isInfinity())\n    return this;\n\n  // 12M + 4S + 7A\n  var pz2 = p.z.redSqr();\n  var z2 = this.z.redSqr();\n  var u1 = this.x.redMul(pz2);\n  var u2 = p.x.redMul(z2);\n  var s1 = this.y.redMul(pz2.redMul(p.z));\n  var s2 = p.y.redMul(z2.redMul(this.z));\n\n  var h = u1.redSub(u2);\n  var r = s1.redSub(s2);\n  if (h.cmpn(0) === 0) {\n    if (r.cmpn(0) !== 0)\n      return this.curve.jpoint(null, null, null);\n    else\n      return this.dbl();\n  }\n\n  var h2 = h.redSqr();\n  var h3 = h2.redMul(h);\n  var v = u1.redMul(h2);\n\n  var nx = r.redSqr().redIAdd(h3).redISub(v).redISub(v);\n  var ny = r.redMul(v.redISub(nx)).redISub(s1.redMul(h3));\n  var nz = this.z.redMul(p.z).redMul(h);\n\n  return this.curve.jpoint(nx, ny, nz);\n};\n\nJPoint.prototype.mixedAdd = function mixedAdd(p) {\n  // O + P = P\n  if (this.isInfinity())\n    return p.toJ();\n\n  // P + O = P\n  if (p.isInfinity())\n    return this;\n\n  // 8M + 3S + 7A\n  var z2 = this.z.redSqr();\n  var u1 = this.x;\n  var u2 = p.x.redMul(z2);\n  var s1 = this.y;\n  var s2 = p.y.redMul(z2).redMul(this.z);\n\n  var h = u1.redSub(u2);\n  var r = s1.redSub(s2);\n  if (h.cmpn(0) === 0) {\n    if (r.cmpn(0) !== 0)\n      return this.curve.jpoint(null, null, null);\n    else\n      return this.dbl();\n  }\n\n  var h2 = h.redSqr();\n  var h3 = h2.redMul(h);\n  var v = u1.redMul(h2);\n\n  var nx = r.redSqr().redIAdd(h3).redISub(v).redISub(v);\n  var ny = r.redMul(v.redISub(nx)).redISub(s1.redMul(h3));\n  var nz = this.z.redMul(h);\n\n  return this.curve.jpoint(nx, ny, nz);\n};\n\nJPoint.prototype.dblp = function dblp(pow) {\n  if (pow === 0)\n    return this;\n  if (this.isInfinity())\n    return this;\n  if (!pow)\n    return this.dbl();\n\n  var i;\n  if (this.curve.zeroA || this.curve.threeA) {\n    var r = this;\n    for (i = 0; i < pow; i++)\n      r = r.dbl();\n    return r;\n  }\n\n  // 1M + 2S + 1A + N * (4S + 5M + 8A)\n  // N = 1 => 6M + 6S + 9A\n  var a = this.curve.a;\n  var tinv = this.curve.tinv;\n\n  var jx = this.x;\n  var jy = this.y;\n  var jz = this.z;\n  var jz4 = jz.redSqr().redSqr();\n\n  // Reuse results\n  var jyd = jy.redAdd(jy);\n  for (i = 0; i < pow; i++) {\n    var jx2 = jx.redSqr();\n    var jyd2 = jyd.redSqr();\n    var jyd4 = jyd2.redSqr();\n    var c = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a.redMul(jz4));\n\n    var t1 = jx.redMul(jyd2);\n    var nx = c.redSqr().redISub(t1.redAdd(t1));\n    var t2 = t1.redISub(nx);\n    var dny = c.redMul(t2);\n    dny = dny.redIAdd(dny).redISub(jyd4);\n    var nz = jyd.redMul(jz);\n    if (i + 1 < pow)\n      jz4 = jz4.redMul(jyd4);\n\n    jx = nx;\n    jz = nz;\n    jyd = dny;\n  }\n\n  return this.curve.jpoint(jx, jyd.redMul(tinv), jz);\n};\n\nJPoint.prototype.dbl = function dbl() {\n  if (this.isInfinity())\n    return this;\n\n  if (this.curve.zeroA)\n    return this._zeroDbl();\n  else if (this.curve.threeA)\n    return this._threeDbl();\n  else\n    return this._dbl();\n};\n\nJPoint.prototype._zeroDbl = function _zeroDbl() {\n  var nx;\n  var ny;\n  var nz;\n  // Z = 1\n  if (this.zOne) {\n    // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-0.html\n    //     #doubling-mdbl-2007-bl\n    // 1M + 5S + 14A\n\n    // XX = X1^2\n    var xx = this.x.redSqr();\n    // YY = Y1^2\n    var yy = this.y.redSqr();\n    // YYYY = YY^2\n    var yyyy = yy.redSqr();\n    // S = 2 * ((X1 + YY)^2 - XX - YYYY)\n    var s = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);\n    s = s.redIAdd(s);\n    // M = 3 * XX + a; a = 0\n    var m = xx.redAdd(xx).redIAdd(xx);\n    // T = M ^ 2 - 2*S\n    var t = m.redSqr().redISub(s).redISub(s);\n\n    // 8 * YYYY\n    var yyyy8 = yyyy.redIAdd(yyyy);\n    yyyy8 = yyyy8.redIAdd(yyyy8);\n    yyyy8 = yyyy8.redIAdd(yyyy8);\n\n    // X3 = T\n    nx = t;\n    // Y3 = M * (S - T) - 8 * YYYY\n    ny = m.redMul(s.redISub(t)).redISub(yyyy8);\n    // Z3 = 2*Y1\n    nz = this.y.redAdd(this.y);\n  } else {\n    // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-0.html\n    //     #doubling-dbl-2009-l\n    // 2M + 5S + 13A\n\n    // A = X1^2\n    var a = this.x.redSqr();\n    // B = Y1^2\n    var b = this.y.redSqr();\n    // C = B^2\n    var c = b.redSqr();\n    // D = 2 * ((X1 + B)^2 - A - C)\n    var d = this.x.redAdd(b).redSqr().redISub(a).redISub(c);\n    d = d.redIAdd(d);\n    // E = 3 * A\n    var e = a.redAdd(a).redIAdd(a);\n    // F = E^2\n    var f = e.redSqr();\n\n    // 8 * C\n    var c8 = c.redIAdd(c);\n    c8 = c8.redIAdd(c8);\n    c8 = c8.redIAdd(c8);\n\n    // X3 = F - 2 * D\n    nx = f.redISub(d).redISub(d);\n    // Y3 = E * (D - X3) - 8 * C\n    ny = e.redMul(d.redISub(nx)).redISub(c8);\n    // Z3 = 2 * Y1 * Z1\n    nz = this.y.redMul(this.z);\n    nz = nz.redIAdd(nz);\n  }\n\n  return this.curve.jpoint(nx, ny, nz);\n};\n\nJPoint.prototype._threeDbl = function _threeDbl() {\n  var nx;\n  var ny;\n  var nz;\n  // Z = 1\n  if (this.zOne) {\n    // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-3.html\n    //     #doubling-mdbl-2007-bl\n    // 1M + 5S + 15A\n\n    // XX = X1^2\n    var xx = this.x.redSqr();\n    // YY = Y1^2\n    var yy = this.y.redSqr();\n    // YYYY = YY^2\n    var yyyy = yy.redSqr();\n    // S = 2 * ((X1 + YY)^2 - XX - YYYY)\n    var s = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);\n    s = s.redIAdd(s);\n    // M = 3 * XX + a\n    var m = xx.redAdd(xx).redIAdd(xx).redIAdd(this.curve.a);\n    // T = M^2 - 2 * S\n    var t = m.redSqr().redISub(s).redISub(s);\n    // X3 = T\n    nx = t;\n    // Y3 = M * (S - T) - 8 * YYYY\n    var yyyy8 = yyyy.redIAdd(yyyy);\n    yyyy8 = yyyy8.redIAdd(yyyy8);\n    yyyy8 = yyyy8.redIAdd(yyyy8);\n    ny = m.redMul(s.redISub(t)).redISub(yyyy8);\n    // Z3 = 2 * Y1\n    nz = this.y.redAdd(this.y);\n  } else {\n    // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-3.html#doubling-dbl-2001-b\n    // 3M + 5S\n\n    // delta = Z1^2\n    var delta = this.z.redSqr();\n    // gamma = Y1^2\n    var gamma = this.y.redSqr();\n    // beta = X1 * gamma\n    var beta = this.x.redMul(gamma);\n    // alpha = 3 * (X1 - delta) * (X1 + delta)\n    var alpha = this.x.redSub(delta).redMul(this.x.redAdd(delta));\n    alpha = alpha.redAdd(alpha).redIAdd(alpha);\n    // X3 = alpha^2 - 8 * beta\n    var beta4 = beta.redIAdd(beta);\n    beta4 = beta4.redIAdd(beta4);\n    var beta8 = beta4.redAdd(beta4);\n    nx = alpha.redSqr().redISub(beta8);\n    // Z3 = (Y1 + Z1)^2 - gamma - delta\n    nz = this.y.redAdd(this.z).redSqr().redISub(gamma).redISub(delta);\n    // Y3 = alpha * (4 * beta - X3) - 8 * gamma^2\n    var ggamma8 = gamma.redSqr();\n    ggamma8 = ggamma8.redIAdd(ggamma8);\n    ggamma8 = ggamma8.redIAdd(ggamma8);\n    ggamma8 = ggamma8.redIAdd(ggamma8);\n    ny = alpha.redMul(beta4.redISub(nx)).redISub(ggamma8);\n  }\n\n  return this.curve.jpoint(nx, ny, nz);\n};\n\nJPoint.prototype._dbl = function _dbl() {\n  var a = this.curve.a;\n\n  // 4M + 6S + 10A\n  var jx = this.x;\n  var jy = this.y;\n  var jz = this.z;\n  var jz4 = jz.redSqr().redSqr();\n\n  var jx2 = jx.redSqr();\n  var jy2 = jy.redSqr();\n\n  var c = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a.redMul(jz4));\n\n  var jxd4 = jx.redAdd(jx);\n  jxd4 = jxd4.redIAdd(jxd4);\n  var t1 = jxd4.redMul(jy2);\n  var nx = c.redSqr().redISub(t1.redAdd(t1));\n  var t2 = t1.redISub(nx);\n\n  var jyd8 = jy2.redSqr();\n  jyd8 = jyd8.redIAdd(jyd8);\n  jyd8 = jyd8.redIAdd(jyd8);\n  jyd8 = jyd8.redIAdd(jyd8);\n  var ny = c.redMul(t2).redISub(jyd8);\n  var nz = jy.redAdd(jy).redMul(jz);\n\n  return this.curve.jpoint(nx, ny, nz);\n};\n\nJPoint.prototype.trpl = function trpl() {\n  if (!this.curve.zeroA)\n    return this.dbl().add(this);\n\n  // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-0.html#tripling-tpl-2007-bl\n  // 5M + 10S + ...\n\n  // XX = X1^2\n  var xx = this.x.redSqr();\n  // YY = Y1^2\n  var yy = this.y.redSqr();\n  // ZZ = Z1^2\n  var zz = this.z.redSqr();\n  // YYYY = YY^2\n  var yyyy = yy.redSqr();\n  // M = 3 * XX + a * ZZ2; a = 0\n  var m = xx.redAdd(xx).redIAdd(xx);\n  // MM = M^2\n  var mm = m.redSqr();\n  // E = 6 * ((X1 + YY)^2 - XX - YYYY) - MM\n  var e = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);\n  e = e.redIAdd(e);\n  e = e.redAdd(e).redIAdd(e);\n  e = e.redISub(mm);\n  // EE = E^2\n  var ee = e.redSqr();\n  // T = 16*YYYY\n  var t = yyyy.redIAdd(yyyy);\n  t = t.redIAdd(t);\n  t = t.redIAdd(t);\n  t = t.redIAdd(t);\n  // U = (M + E)^2 - MM - EE - T\n  var u = m.redIAdd(e).redSqr().redISub(mm).redISub(ee).redISub(t);\n  // X3 = 4 * (X1 * EE - 4 * YY * U)\n  var yyu4 = yy.redMul(u);\n  yyu4 = yyu4.redIAdd(yyu4);\n  yyu4 = yyu4.redIAdd(yyu4);\n  var nx = this.x.redMul(ee).redISub(yyu4);\n  nx = nx.redIAdd(nx);\n  nx = nx.redIAdd(nx);\n  // Y3 = 8 * Y1 * (U * (T - U) - E * EE)\n  var ny = this.y.redMul(u.redMul(t.redISub(u)).redISub(e.redMul(ee)));\n  ny = ny.redIAdd(ny);\n  ny = ny.redIAdd(ny);\n  ny = ny.redIAdd(ny);\n  // Z3 = (Z1 + E)^2 - ZZ - EE\n  var nz = this.z.redAdd(e).redSqr().redISub(zz).redISub(ee);\n\n  return this.curve.jpoint(nx, ny, nz);\n};\n\nJPoint.prototype.mul = function mul(k, kbase) {\n  k = new BN(k, kbase);\n\n  return this.curve._wnafMul(this, k);\n};\n\nJPoint.prototype.eq = function eq(p) {\n  if (p.type === 'affine')\n    return this.eq(p.toJ());\n\n  if (this === p)\n    return true;\n\n  // x1 * z2^2 == x2 * z1^2\n  var z2 = this.z.redSqr();\n  var pz2 = p.z.redSqr();\n  if (this.x.redMul(pz2).redISub(p.x.redMul(z2)).cmpn(0) !== 0)\n    return false;\n\n  // y1 * z2^3 == y2 * z1^3\n  var z3 = z2.redMul(this.z);\n  var pz3 = pz2.redMul(p.z);\n  return this.y.redMul(pz3).redISub(p.y.redMul(z3)).cmpn(0) === 0;\n};\n\nJPoint.prototype.eqXToP = function eqXToP(x) {\n  var zs = this.z.redSqr();\n  var rx = x.toRed(this.curve.red).redMul(zs);\n  if (this.x.cmp(rx) === 0)\n    return true;\n\n  var xc = x.clone();\n  var t = this.curve.redN.redMul(zs);\n  for (;;) {\n    xc.iadd(this.curve.n);\n    if (xc.cmp(this.curve.p) >= 0)\n      return false;\n\n    rx.redIAdd(t);\n    if (this.x.cmp(rx) === 0)\n      return true;\n  }\n};\n\nJPoint.prototype.inspect = function inspect() {\n  if (this.isInfinity())\n    return '<EC JPoint Infinity>';\n  return '<EC JPoint x: ' + this.x.toString(16, 2) +\n      ' y: ' + this.y.toString(16, 2) +\n      ' z: ' + this.z.toString(16, 2) + '>';\n};\n\nJPoint.prototype.isInfinity = function isInfinity() {\n  // XXX This code assumes that zero is always zero in red\n  return this.z.cmpn(0) === 0;\n};","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","./base":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/base.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curves.js","source":"'use strict';\n\nvar curves = exports;\n\nvar hash = require('hash.js');\nvar curve = require('./curve');\nvar utils = require('./utils');\n\nvar assert = utils.assert;\n\nfunction PresetCurve(options) {\n  if (options.type === 'short')\n    this.curve = new curve.short(options);\n  else if (options.type === 'edwards')\n    this.curve = new curve.edwards(options);\n  else\n    this.curve = new curve.mont(options);\n  this.g = this.curve.g;\n  this.n = this.curve.n;\n  this.hash = options.hash;\n\n  assert(this.g.validate(), 'Invalid curve');\n  assert(this.g.mul(this.n).isInfinity(), 'Invalid curve, G*N != O');\n}\ncurves.PresetCurve = PresetCurve;\n\nfunction defineCurve(name, options) {\n  Object.defineProperty(curves, name, {\n    configurable: true,\n    enumerable: true,\n    get: function() {\n      var curve = new PresetCurve(options);\n      Object.defineProperty(curves, name, {\n        configurable: true,\n        enumerable: true,\n        value: curve,\n      });\n      return curve;\n    },\n  });\n}\n\ndefineCurve('p192', {\n  type: 'short',\n  prime: 'p192',\n  p: 'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff',\n  a: 'ffffffff ffffffff ffffffff fffffffe ffffffff fffffffc',\n  b: '64210519 e59c80e7 0fa7e9ab 72243049 feb8deec c146b9b1',\n  n: 'ffffffff ffffffff ffffffff 99def836 146bc9b1 b4d22831',\n  hash: hash.sha256,\n  gRed: false,\n  g: [\n    '188da80e b03090f6 7cbf20eb 43a18800 f4ff0afd 82ff1012',\n    '07192b95 ffc8da78 631011ed 6b24cdd5 73f977a1 1e794811',\n  ],\n});\n\ndefineCurve('p224', {\n  type: 'short',\n  prime: 'p224',\n  p: 'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001',\n  a: 'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff fffffffe',\n  b: 'b4050a85 0c04b3ab f5413256 5044b0b7 d7bfd8ba 270b3943 2355ffb4',\n  n: 'ffffffff ffffffff ffffffff ffff16a2 e0b8f03e 13dd2945 5c5c2a3d',\n  hash: hash.sha256,\n  gRed: false,\n  g: [\n    'b70e0cbd 6bb4bf7f 321390b9 4a03c1d3 56c21122 343280d6 115c1d21',\n    'bd376388 b5f723fb 4c22dfe6 cd4375a0 5a074764 44d58199 85007e34',\n  ],\n});\n\ndefineCurve('p256', {\n  type: 'short',\n  prime: null,\n  p: 'ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff ffffffff',\n  a: 'ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff fffffffc',\n  b: '5ac635d8 aa3a93e7 b3ebbd55 769886bc 651d06b0 cc53b0f6 3bce3c3e 27d2604b',\n  n: 'ffffffff 00000000 ffffffff ffffffff bce6faad a7179e84 f3b9cac2 fc632551',\n  hash: hash.sha256,\n  gRed: false,\n  g: [\n    '6b17d1f2 e12c4247 f8bce6e5 63a440f2 77037d81 2deb33a0 f4a13945 d898c296',\n    '4fe342e2 fe1a7f9b 8ee7eb4a 7c0f9e16 2bce3357 6b315ece cbb64068 37bf51f5',\n  ],\n});\n\ndefineCurve('p384', {\n  type: 'short',\n  prime: null,\n  p: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'fffffffe ffffffff 00000000 00000000 ffffffff',\n  a: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'fffffffe ffffffff 00000000 00000000 fffffffc',\n  b: 'b3312fa7 e23ee7e4 988e056b e3f82d19 181d9c6e fe814112 0314088f ' +\n     '5013875a c656398d 8a2ed19d 2a85c8ed d3ec2aef',\n  n: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff c7634d81 ' +\n     'f4372ddf 581a0db2 48b0a77a ecec196a ccc52973',\n  hash: hash.sha384,\n  gRed: false,\n  g: [\n    'aa87ca22 be8b0537 8eb1c71e f320ad74 6e1d3b62 8ba79b98 59f741e0 82542a38 ' +\n    '5502f25d bf55296c 3a545e38 72760ab7',\n    '3617de4a 96262c6f 5d9e98bf 9292dc29 f8f41dbd 289a147c e9da3113 b5f0b8c0 ' +\n    '0a60b1ce 1d7e819d 7a431d7c 90ea0e5f',\n  ],\n});\n\ndefineCurve('p521', {\n  type: 'short',\n  prime: null,\n  p: '000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'ffffffff ffffffff ffffffff ffffffff ffffffff',\n  a: '000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'ffffffff ffffffff ffffffff ffffffff fffffffc',\n  b: '00000051 953eb961 8e1c9a1f 929a21a0 b68540ee a2da725b ' +\n     '99b315f3 b8b48991 8ef109e1 56193951 ec7e937b 1652c0bd ' +\n     '3bb1bf07 3573df88 3d2c34f1 ef451fd4 6b503f00',\n  n: '000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ' +\n     'ffffffff ffffffff fffffffa 51868783 bf2f966b 7fcc0148 ' +\n     'f709a5d0 3bb5c9b8 899c47ae bb6fb71e 91386409',\n  hash: hash.sha512,\n  gRed: false,\n  g: [\n    '000000c6 858e06b7 0404e9cd 9e3ecb66 2395b442 9c648139 ' +\n    '053fb521 f828af60 6b4d3dba a14b5e77 efe75928 fe1dc127 ' +\n    'a2ffa8de 3348b3c1 856a429b f97e7e31 c2e5bd66',\n    '00000118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd9 98f54449 ' +\n    '579b4468 17afbd17 273e662c 97ee7299 5ef42640 c550b901 ' +\n    '3fad0761 353c7086 a272c240 88be9476 9fd16650',\n  ],\n});\n\ndefineCurve('curve25519', {\n  type: 'mont',\n  prime: 'p25519',\n  p: '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed',\n  a: '76d06',\n  b: '1',\n  n: '1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed',\n  hash: hash.sha256,\n  gRed: false,\n  g: [\n    '9',\n  ],\n});\n\ndefineCurve('ed25519', {\n  type: 'edwards',\n  prime: 'p25519',\n  p: '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed',\n  a: '-1',\n  c: '1',\n  // -121665 * (121666^(-1)) (mod P)\n  d: '52036cee2b6ffe73 8cc740797779e898 00700a4d4141d8ab 75eb4dca135978a3',\n  n: '1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed',\n  hash: hash.sha256,\n  gRed: false,\n  g: [\n    '216936d3cd6e53fec0a4e231fdd6dc5c692cc7609525a7b2c9562d608f25d51a',\n\n    // 4/5\n    '6666666666666666666666666666666666666666666666666666666666666658',\n  ],\n});\n\nvar pre;\ntry {\n  pre = require('./precomputed/secp256k1');\n} catch (e) {\n  pre = undefined;\n}\n\ndefineCurve('secp256k1', {\n  type: 'short',\n  prime: 'k256',\n  p: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f',\n  a: '0',\n  b: '7',\n  n: 'ffffffff ffffffff ffffffff fffffffe baaedce6 af48a03b bfd25e8c d0364141',\n  h: '1',\n  hash: hash.sha256,\n\n  // Precomputed endomorphism\n  beta: '7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee',\n  lambda: '5363ad4cc05c30e0a5261c028812645a122e22ea20816678df02967c1b23bd72',\n  basis: [\n    {\n      a: '3086d221a7d46bcde86c90e49284eb15',\n      b: '-e4437ed6010e88286f547fa90abfe4c3',\n    },\n    {\n      a: '114ca50f7a8e2f3f657c1108d9d44cfd8',\n      b: '3086d221a7d46bcde86c90e49284eb15',\n    },\n  ],\n\n  gRed: false,\n  g: [\n    '79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798',\n    '483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8',\n    pre,\n  ],\n});","deps":{"./curve":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curve/index.js","./precomputed/secp256k1":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/precomputed/secp256k1.js","./utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","hash.js":"node_modules/hash.js/lib/hash.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/ec/index.js","source":"'use strict';\n\nvar BN = require('bn.js');\nvar HmacDRBG = require('hmac-drbg');\nvar utils = require('../utils');\nvar curves = require('../curves');\nvar rand = require('brorand');\nvar assert = utils.assert;\n\nvar KeyPair = require('./key');\nvar Signature = require('./signature');\n\nfunction EC(options) {\n  if (!(this instanceof EC))\n    return new EC(options);\n\n  // Shortcut `elliptic.ec(curve-name)`\n  if (typeof options === 'string') {\n    assert(Object.prototype.hasOwnProperty.call(curves, options),\n      'Unknown curve ' + options);\n\n    options = curves[options];\n  }\n\n  // Shortcut for `elliptic.ec(elliptic.curves.curveName)`\n  if (options instanceof curves.PresetCurve)\n    options = { curve: options };\n\n  this.curve = options.curve.curve;\n  this.n = this.curve.n;\n  this.nh = this.n.ushrn(1);\n  this.g = this.curve.g;\n\n  // Point on curve\n  this.g = options.curve.g;\n  this.g.precompute(options.curve.n.bitLength() + 1);\n\n  // Hash for function for DRBG\n  this.hash = options.hash || options.curve.hash;\n}\nmodule.exports = EC;\n\nEC.prototype.keyPair = function keyPair(options) {\n  return new KeyPair(this, options);\n};\n\nEC.prototype.keyFromPrivate = function keyFromPrivate(priv, enc) {\n  return KeyPair.fromPrivate(this, priv, enc);\n};\n\nEC.prototype.keyFromPublic = function keyFromPublic(pub, enc) {\n  return KeyPair.fromPublic(this, pub, enc);\n};\n\nEC.prototype.genKeyPair = function genKeyPair(options) {\n  if (!options)\n    options = {};\n\n  // Instantiate Hmac_DRBG\n  var drbg = new HmacDRBG({\n    hash: this.hash,\n    pers: options.pers,\n    persEnc: options.persEnc || 'utf8',\n    entropy: options.entropy || rand(this.hash.hmacStrength),\n    entropyEnc: options.entropy && options.entropyEnc || 'utf8',\n    nonce: this.n.toArray(),\n  });\n\n  var bytes = this.n.byteLength();\n  var ns2 = this.n.sub(new BN(2));\n  for (;;) {\n    var priv = new BN(drbg.generate(bytes));\n    if (priv.cmp(ns2) > 0)\n      continue;\n\n    priv.iaddn(1);\n    return this.keyFromPrivate(priv);\n  }\n};\n\nEC.prototype._truncateToN = function _truncateToN(msg, truncOnly) {\n  var delta = msg.byteLength() * 8 - this.n.bitLength();\n  if (delta > 0)\n    msg = msg.ushrn(delta);\n  if (!truncOnly && msg.cmp(this.n) >= 0)\n    return msg.sub(this.n);\n  else\n    return msg;\n};\n\nEC.prototype.sign = function sign(msg, key, enc, options) {\n  if (typeof enc === 'object') {\n    options = enc;\n    enc = null;\n  }\n  if (!options)\n    options = {};\n\n  key = this.keyFromPrivate(key, enc);\n  msg = this._truncateToN(new BN(msg, 16));\n\n  // Zero-extend key to provide enough entropy\n  var bytes = this.n.byteLength();\n  var bkey = key.getPrivate().toArray('be', bytes);\n\n  // Zero-extend nonce to have the same byte size as N\n  var nonce = msg.toArray('be', bytes);\n\n  // Instantiate Hmac_DRBG\n  var drbg = new HmacDRBG({\n    hash: this.hash,\n    entropy: bkey,\n    nonce: nonce,\n    pers: options.pers,\n    persEnc: options.persEnc || 'utf8',\n  });\n\n  // Number of bytes to generate\n  var ns1 = this.n.sub(new BN(1));\n\n  for (var iter = 0; ; iter++) {\n    var k = options.k ?\n      options.k(iter) :\n      new BN(drbg.generate(this.n.byteLength()));\n    k = this._truncateToN(k, true);\n    if (k.cmpn(1) <= 0 || k.cmp(ns1) >= 0)\n      continue;\n\n    var kp = this.g.mul(k);\n    if (kp.isInfinity())\n      continue;\n\n    var kpX = kp.getX();\n    var r = kpX.umod(this.n);\n    if (r.cmpn(0) === 0)\n      continue;\n\n    var s = k.invm(this.n).mul(r.mul(key.getPrivate()).iadd(msg));\n    s = s.umod(this.n);\n    if (s.cmpn(0) === 0)\n      continue;\n\n    var recoveryParam = (kp.getY().isOdd() ? 1 : 0) |\n                        (kpX.cmp(r) !== 0 ? 2 : 0);\n\n    // Use complement of `s`, if it is > `n / 2`\n    if (options.canonical && s.cmp(this.nh) > 0) {\n      s = this.n.sub(s);\n      recoveryParam ^= 1;\n    }\n\n    return new Signature({ r: r, s: s, recoveryParam: recoveryParam });\n  }\n};\n\nEC.prototype.verify = function verify(msg, signature, key, enc) {\n  msg = this._truncateToN(new BN(msg, 16));\n  key = this.keyFromPublic(key, enc);\n  signature = new Signature(signature, 'hex');\n\n  // Perform primitive values validation\n  var r = signature.r;\n  var s = signature.s;\n  if (r.cmpn(1) < 0 || r.cmp(this.n) >= 0)\n    return false;\n  if (s.cmpn(1) < 0 || s.cmp(this.n) >= 0)\n    return false;\n\n  // Validate signature\n  var sinv = s.invm(this.n);\n  var u1 = sinv.mul(msg).umod(this.n);\n  var u2 = sinv.mul(r).umod(this.n);\n  var p;\n\n  if (!this.curve._maxwellTrick) {\n    p = this.g.mulAdd(u1, key.getPublic(), u2);\n    if (p.isInfinity())\n      return false;\n\n    return p.getX().umod(this.n).cmp(r) === 0;\n  }\n\n  // NOTE: Greg Maxwell's trick, inspired by:\n  // https://git.io/vad3K\n\n  p = this.g.jmulAdd(u1, key.getPublic(), u2);\n  if (p.isInfinity())\n    return false;\n\n  // Compare `p.x` of Jacobian point with `r`,\n  // this will do `p.x == r * p.z^2` instead of multiplying `p.x` by the\n  // inverse of `p.z^2`\n  return p.eqXToP(r);\n};\n\nEC.prototype.recoverPubKey = function(msg, signature, j, enc) {\n  assert((3 & j) === j, 'The recovery param is more than two bits');\n  signature = new Signature(signature, enc);\n\n  var n = this.n;\n  var e = new BN(msg);\n  var r = signature.r;\n  var s = signature.s;\n\n  // A set LSB signifies that the y-coordinate is odd\n  var isYOdd = j & 1;\n  var isSecondKey = j >> 1;\n  if (r.cmp(this.curve.p.umod(this.curve.n)) >= 0 && isSecondKey)\n    throw new Error('Unable to find sencond key candinate');\n\n  // 1.1. Let x = r + jn.\n  if (isSecondKey)\n    r = this.curve.pointFromX(r.add(this.curve.n), isYOdd);\n  else\n    r = this.curve.pointFromX(r, isYOdd);\n\n  var rInv = signature.r.invm(n);\n  var s1 = n.sub(e).mul(rInv).umod(n);\n  var s2 = s.mul(rInv).umod(n);\n\n  // 1.6.1 Compute Q = r^-1 (sR -  eG)\n  //               Q = r^-1 (sR + -eG)\n  return this.g.mulAdd(s1, r, s2);\n};\n\nEC.prototype.getKeyRecoveryParam = function(e, signature, Q, enc) {\n  signature = new Signature(signature, enc);\n  if (signature.recoveryParam !== null)\n    return signature.recoveryParam;\n\n  for (var i = 0; i < 4; i++) {\n    var Qprime;\n    try {\n      Qprime = this.recoverPubKey(e, signature, i);\n    } catch (e) {\n      continue;\n    }\n\n    if (Qprime.eq(Q))\n      return i;\n  }\n  throw new Error('Unable to find valid recovery factor');\n};","deps":{"../curves":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curves.js","../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","./key":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/ec/key.js","./signature":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/ec/signature.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js","brorand":"node_modules/brorand/index.js","hmac-drbg":"node_modules/hmac-drbg/lib/hmac-drbg.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/ec/key.js","source":"'use strict';\n\nvar BN = require('bn.js');\nvar utils = require('../utils');\nvar assert = utils.assert;\n\nfunction KeyPair(ec, options) {\n  this.ec = ec;\n  this.priv = null;\n  this.pub = null;\n\n  // KeyPair(ec, { priv: ..., pub: ... })\n  if (options.priv)\n    this._importPrivate(options.priv, options.privEnc);\n  if (options.pub)\n    this._importPublic(options.pub, options.pubEnc);\n}\nmodule.exports = KeyPair;\n\nKeyPair.fromPublic = function fromPublic(ec, pub, enc) {\n  if (pub instanceof KeyPair)\n    return pub;\n\n  return new KeyPair(ec, {\n    pub: pub,\n    pubEnc: enc,\n  });\n};\n\nKeyPair.fromPrivate = function fromPrivate(ec, priv, enc) {\n  if (priv instanceof KeyPair)\n    return priv;\n\n  return new KeyPair(ec, {\n    priv: priv,\n    privEnc: enc,\n  });\n};\n\nKeyPair.prototype.validate = function validate() {\n  var pub = this.getPublic();\n\n  if (pub.isInfinity())\n    return { result: false, reason: 'Invalid public key' };\n  if (!pub.validate())\n    return { result: false, reason: 'Public key is not a point' };\n  if (!pub.mul(this.ec.curve.n).isInfinity())\n    return { result: false, reason: 'Public key * N != O' };\n\n  return { result: true, reason: null };\n};\n\nKeyPair.prototype.getPublic = function getPublic(compact, enc) {\n  // compact is optional argument\n  if (typeof compact === 'string') {\n    enc = compact;\n    compact = null;\n  }\n\n  if (!this.pub)\n    this.pub = this.ec.g.mul(this.priv);\n\n  if (!enc)\n    return this.pub;\n\n  return this.pub.encode(enc, compact);\n};\n\nKeyPair.prototype.getPrivate = function getPrivate(enc) {\n  if (enc === 'hex')\n    return this.priv.toString(16, 2);\n  else\n    return this.priv;\n};\n\nKeyPair.prototype._importPrivate = function _importPrivate(key, enc) {\n  this.priv = new BN(key, enc || 16);\n\n  // Ensure that the priv won't be bigger than n, otherwise we may fail\n  // in fixed multiplication method\n  this.priv = this.priv.umod(this.ec.curve.n);\n};\n\nKeyPair.prototype._importPublic = function _importPublic(key, enc) {\n  if (key.x || key.y) {\n    // Montgomery points only have an `x` coordinate.\n    // Weierstrass/Edwards points on the other hand have both `x` and\n    // `y` coordinates.\n    if (this.ec.curve.type === 'mont') {\n      assert(key.x, 'Need x coordinate');\n    } else if (this.ec.curve.type === 'short' ||\n               this.ec.curve.type === 'edwards') {\n      assert(key.x && key.y, 'Need both x and y coordinate');\n    }\n    this.pub = this.ec.curve.point(key.x, key.y);\n    return;\n  }\n  this.pub = this.ec.curve.decodePoint(key, enc);\n};\n\n// ECDH\nKeyPair.prototype.derive = function derive(pub) {\n  if(!pub.validate()) {\n    assert(pub.validate(), 'public point not validated');\n  }\n  return pub.mul(this.priv).getX();\n};\n\n// ECDSA\nKeyPair.prototype.sign = function sign(msg, enc, options) {\n  return this.ec.sign(msg, this, enc, options);\n};\n\nKeyPair.prototype.verify = function verify(msg, signature) {\n  return this.ec.verify(msg, signature, this);\n};\n\nKeyPair.prototype.inspect = function inspect() {\n  return '<Key priv: ' + (this.priv && this.priv.toString(16, 2)) +\n         ' pub: ' + (this.pub && this.pub.inspect()) + ' >';\n};","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/ec/signature.js","source":"'use strict';\n\nvar BN = require('bn.js');\n\nvar utils = require('../utils');\nvar assert = utils.assert;\n\nfunction Signature(options, enc) {\n  if (options instanceof Signature)\n    return options;\n\n  if (this._importDER(options, enc))\n    return;\n\n  assert(options.r && options.s, 'Signature without r or s');\n  this.r = new BN(options.r, 16);\n  this.s = new BN(options.s, 16);\n  if (options.recoveryParam === undefined)\n    this.recoveryParam = null;\n  else\n    this.recoveryParam = options.recoveryParam;\n}\nmodule.exports = Signature;\n\nfunction Position() {\n  this.place = 0;\n}\n\nfunction getLength(buf, p) {\n  var initial = buf[p.place++];\n  if (!(initial & 0x80)) {\n    return initial;\n  }\n  var octetLen = initial & 0xf;\n\n  // Indefinite length or overflow\n  if (octetLen === 0 || octetLen > 4) {\n    return false;\n  }\n\n  var val = 0;\n  for (var i = 0, off = p.place; i < octetLen; i++, off++) {\n    val <<= 8;\n    val |= buf[off];\n    val >>>= 0;\n  }\n\n  // Leading zeroes\n  if (val <= 0x7f) {\n    return false;\n  }\n\n  p.place = off;\n  return val;\n}\n\nfunction rmPadding(buf) {\n  var i = 0;\n  var len = buf.length - 1;\n  while (!buf[i] && !(buf[i + 1] & 0x80) && i < len) {\n    i++;\n  }\n  if (i === 0) {\n    return buf;\n  }\n  return buf.slice(i);\n}\n\nSignature.prototype._importDER = function _importDER(data, enc) {\n  data = utils.toArray(data, enc);\n  var p = new Position();\n  if (data[p.place++] !== 0x30) {\n    return false;\n  }\n  var len = getLength(data, p);\n  if (len === false) {\n    return false;\n  }\n  if ((len + p.place) !== data.length) {\n    return false;\n  }\n  if (data[p.place++] !== 0x02) {\n    return false;\n  }\n  var rlen = getLength(data, p);\n  if (rlen === false) {\n    return false;\n  }\n  var r = data.slice(p.place, rlen + p.place);\n  p.place += rlen;\n  if (data[p.place++] !== 0x02) {\n    return false;\n  }\n  var slen = getLength(data, p);\n  if (slen === false) {\n    return false;\n  }\n  if (data.length !== slen + p.place) {\n    return false;\n  }\n  var s = data.slice(p.place, slen + p.place);\n  if (r[0] === 0) {\n    if (r[1] & 0x80) {\n      r = r.slice(1);\n    } else {\n      // Leading zeroes\n      return false;\n    }\n  }\n  if (s[0] === 0) {\n    if (s[1] & 0x80) {\n      s = s.slice(1);\n    } else {\n      // Leading zeroes\n      return false;\n    }\n  }\n\n  this.r = new BN(r);\n  this.s = new BN(s);\n  this.recoveryParam = null;\n\n  return true;\n};\n\nfunction constructLength(arr, len) {\n  if (len < 0x80) {\n    arr.push(len);\n    return;\n  }\n  var octets = 1 + (Math.log(len) / Math.LN2 >>> 3);\n  arr.push(octets | 0x80);\n  while (--octets) {\n    arr.push((len >>> (octets << 3)) & 0xff);\n  }\n  arr.push(len);\n}\n\nSignature.prototype.toDER = function toDER(enc) {\n  var r = this.r.toArray();\n  var s = this.s.toArray();\n\n  // Pad values\n  if (r[0] & 0x80)\n    r = [ 0 ].concat(r);\n  // Pad values\n  if (s[0] & 0x80)\n    s = [ 0 ].concat(s);\n\n  r = rmPadding(r);\n  s = rmPadding(s);\n\n  while (!s[0] && !(s[1] & 0x80)) {\n    s = s.slice(1);\n  }\n  var arr = [ 0x02 ];\n  constructLength(arr, r.length);\n  arr = arr.concat(r);\n  arr.push(0x02);\n  constructLength(arr, s.length);\n  var backHalf = arr.concat(s);\n  var res = [ 0x30 ];\n  constructLength(res, backHalf.length);\n  res = res.concat(backHalf);\n  return utils.encode(res, enc);\n};","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/eddsa/index.js","source":"'use strict';\n\nvar hash = require('hash.js');\nvar curves = require('../curves');\nvar utils = require('../utils');\nvar assert = utils.assert;\nvar parseBytes = utils.parseBytes;\nvar KeyPair = require('./key');\nvar Signature = require('./signature');\n\nfunction EDDSA(curve) {\n  assert(curve === 'ed25519', 'only tested with ed25519 so far');\n\n  if (!(this instanceof EDDSA))\n    return new EDDSA(curve);\n\n  curve = curves[curve].curve;\n  this.curve = curve;\n  this.g = curve.g;\n  this.g.precompute(curve.n.bitLength() + 1);\n\n  this.pointClass = curve.point().constructor;\n  this.encodingLength = Math.ceil(curve.n.bitLength() / 8);\n  this.hash = hash.sha512;\n}\n\nmodule.exports = EDDSA;\n\n/**\n* @param {Array|String} message - message bytes\n* @param {Array|String|KeyPair} secret - secret bytes or a keypair\n* @returns {Signature} - signature\n*/\nEDDSA.prototype.sign = function sign(message, secret) {\n  message = parseBytes(message);\n  var key = this.keyFromSecret(secret);\n  var r = this.hashInt(key.messagePrefix(), message);\n  var R = this.g.mul(r);\n  var Rencoded = this.encodePoint(R);\n  var s_ = this.hashInt(Rencoded, key.pubBytes(), message)\n    .mul(key.priv());\n  var S = r.add(s_).umod(this.curve.n);\n  return this.makeSignature({ R: R, S: S, Rencoded: Rencoded });\n};\n\n/**\n* @param {Array} message - message bytes\n* @param {Array|String|Signature} sig - sig bytes\n* @param {Array|String|Point|KeyPair} pub - public key\n* @returns {Boolean} - true if public key matches sig of message\n*/\nEDDSA.prototype.verify = function verify(message, sig, pub) {\n  message = parseBytes(message);\n  sig = this.makeSignature(sig);\n  var key = this.keyFromPublic(pub);\n  var h = this.hashInt(sig.Rencoded(), key.pubBytes(), message);\n  var SG = this.g.mul(sig.S());\n  var RplusAh = sig.R().add(key.pub().mul(h));\n  return RplusAh.eq(SG);\n};\n\nEDDSA.prototype.hashInt = function hashInt() {\n  var hash = this.hash();\n  for (var i = 0; i < arguments.length; i++)\n    hash.update(arguments[i]);\n  return utils.intFromLE(hash.digest()).umod(this.curve.n);\n};\n\nEDDSA.prototype.keyFromPublic = function keyFromPublic(pub) {\n  return KeyPair.fromPublic(this, pub);\n};\n\nEDDSA.prototype.keyFromSecret = function keyFromSecret(secret) {\n  return KeyPair.fromSecret(this, secret);\n};\n\nEDDSA.prototype.makeSignature = function makeSignature(sig) {\n  if (sig instanceof Signature)\n    return sig;\n  return new Signature(this, sig);\n};\n\n/**\n* * https://tools.ietf.org/html/draft-josefsson-eddsa-ed25519-03#section-5.2\n*\n* EDDSA defines methods for encoding and decoding points and integers. These are\n* helper convenience methods, that pass along to utility functions implied\n* parameters.\n*\n*/\nEDDSA.prototype.encodePoint = function encodePoint(point) {\n  var enc = point.getY().toArray('le', this.encodingLength);\n  enc[this.encodingLength - 1] |= point.getX().isOdd() ? 0x80 : 0;\n  return enc;\n};\n\nEDDSA.prototype.decodePoint = function decodePoint(bytes) {\n  bytes = utils.parseBytes(bytes);\n\n  var lastIx = bytes.length - 1;\n  var normed = bytes.slice(0, lastIx).concat(bytes[lastIx] & ~0x80);\n  var xIsOdd = (bytes[lastIx] & 0x80) !== 0;\n\n  var y = utils.intFromLE(normed);\n  return this.curve.pointFromY(y, xIsOdd);\n};\n\nEDDSA.prototype.encodeInt = function encodeInt(num) {\n  return num.toArray('le', this.encodingLength);\n};\n\nEDDSA.prototype.decodeInt = function decodeInt(bytes) {\n  return utils.intFromLE(bytes);\n};\n\nEDDSA.prototype.isPoint = function isPoint(val) {\n  return val instanceof this.pointClass;\n};","deps":{"../curves":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/curves.js","../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","./key":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/eddsa/key.js","./signature":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/eddsa/signature.js","hash.js":"node_modules/hash.js/lib/hash.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/eddsa/key.js","source":"'use strict';\n\nvar utils = require('../utils');\nvar assert = utils.assert;\nvar parseBytes = utils.parseBytes;\nvar cachedProperty = utils.cachedProperty;\n\n/**\n* @param {EDDSA} eddsa - instance\n* @param {Object} params - public/private key parameters\n*\n* @param {Array<Byte>} [params.secret] - secret seed bytes\n* @param {Point} [params.pub] - public key point (aka `A` in eddsa terms)\n* @param {Array<Byte>} [params.pub] - public key point encoded as bytes\n*\n*/\nfunction KeyPair(eddsa, params) {\n  this.eddsa = eddsa;\n  this._secret = parseBytes(params.secret);\n  if (eddsa.isPoint(params.pub))\n    this._pub = params.pub;\n  else\n    this._pubBytes = parseBytes(params.pub);\n}\n\nKeyPair.fromPublic = function fromPublic(eddsa, pub) {\n  if (pub instanceof KeyPair)\n    return pub;\n  return new KeyPair(eddsa, { pub: pub });\n};\n\nKeyPair.fromSecret = function fromSecret(eddsa, secret) {\n  if (secret instanceof KeyPair)\n    return secret;\n  return new KeyPair(eddsa, { secret: secret });\n};\n\nKeyPair.prototype.secret = function secret() {\n  return this._secret;\n};\n\ncachedProperty(KeyPair, 'pubBytes', function pubBytes() {\n  return this.eddsa.encodePoint(this.pub());\n});\n\ncachedProperty(KeyPair, 'pub', function pub() {\n  if (this._pubBytes)\n    return this.eddsa.decodePoint(this._pubBytes);\n  return this.eddsa.g.mul(this.priv());\n});\n\ncachedProperty(KeyPair, 'privBytes', function privBytes() {\n  var eddsa = this.eddsa;\n  var hash = this.hash();\n  var lastIx = eddsa.encodingLength - 1;\n\n  var a = hash.slice(0, eddsa.encodingLength);\n  a[0] &= 248;\n  a[lastIx] &= 127;\n  a[lastIx] |= 64;\n\n  return a;\n});\n\ncachedProperty(KeyPair, 'priv', function priv() {\n  return this.eddsa.decodeInt(this.privBytes());\n});\n\ncachedProperty(KeyPair, 'hash', function hash() {\n  return this.eddsa.hash().update(this.secret()).digest();\n});\n\ncachedProperty(KeyPair, 'messagePrefix', function messagePrefix() {\n  return this.hash().slice(this.eddsa.encodingLength);\n});\n\nKeyPair.prototype.sign = function sign(message) {\n  assert(this._secret, 'KeyPair can only verify');\n  return this.eddsa.sign(message, this);\n};\n\nKeyPair.prototype.verify = function verify(message, sig) {\n  return this.eddsa.verify(message, sig, this);\n};\n\nKeyPair.prototype.getSecret = function getSecret(enc) {\n  assert(this._secret, 'KeyPair is public only');\n  return utils.encode(this.secret(), enc);\n};\n\nKeyPair.prototype.getPublic = function getPublic(enc) {\n  return utils.encode(this.pubBytes(), enc);\n};\n\nmodule.exports = KeyPair;","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/eddsa/signature.js","source":"'use strict';\n\nvar BN = require('bn.js');\nvar utils = require('../utils');\nvar assert = utils.assert;\nvar cachedProperty = utils.cachedProperty;\nvar parseBytes = utils.parseBytes;\n\n/**\n* @param {EDDSA} eddsa - eddsa instance\n* @param {Array<Bytes>|Object} sig -\n* @param {Array<Bytes>|Point} [sig.R] - R point as Point or bytes\n* @param {Array<Bytes>|bn} [sig.S] - S scalar as bn or bytes\n* @param {Array<Bytes>} [sig.Rencoded] - R point encoded\n* @param {Array<Bytes>} [sig.Sencoded] - S scalar encoded\n*/\nfunction Signature(eddsa, sig) {\n  this.eddsa = eddsa;\n\n  if (typeof sig !== 'object')\n    sig = parseBytes(sig);\n\n  if (Array.isArray(sig)) {\n    sig = {\n      R: sig.slice(0, eddsa.encodingLength),\n      S: sig.slice(eddsa.encodingLength),\n    };\n  }\n\n  assert(sig.R && sig.S, 'Signature without R or S');\n\n  if (eddsa.isPoint(sig.R))\n    this._R = sig.R;\n  if (sig.S instanceof BN)\n    this._S = sig.S;\n\n  this._Rencoded = Array.isArray(sig.R) ? sig.R : sig.Rencoded;\n  this._Sencoded = Array.isArray(sig.S) ? sig.S : sig.Sencoded;\n}\n\ncachedProperty(Signature, 'S', function S() {\n  return this.eddsa.decodeInt(this.Sencoded());\n});\n\ncachedProperty(Signature, 'R', function R() {\n  return this.eddsa.decodePoint(this.Rencoded());\n});\n\ncachedProperty(Signature, 'Rencoded', function Rencoded() {\n  return this.eddsa.encodePoint(this.R());\n});\n\ncachedProperty(Signature, 'Sencoded', function Sencoded() {\n  return this.eddsa.encodeInt(this.S());\n});\n\nSignature.prototype.toBytes = function toBytes() {\n  return this.Rencoded().concat(this.Sencoded());\n};\n\nSignature.prototype.toHex = function toHex() {\n  return utils.encode(this.toBytes(), 'hex').toUpperCase();\n};\n\nmodule.exports = Signature;","deps":{"../utils":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/precomputed/secp256k1.js","source":"module.exports = {\n  doubles: {\n    step: 4,\n    points: [\n      [\n        'e60fce93b59e9ec53011aabc21c23e97b2a31369b87a5ae9c44ee89e2a6dec0a',\n        'f7e3507399e595929db99f34f57937101296891e44d23f0be1f32cce69616821',\n      ],\n      [\n        '8282263212c609d9ea2a6e3e172de238d8c39cabd5ac1ca10646e23fd5f51508',\n        '11f8a8098557dfe45e8256e830b60ace62d613ac2f7b17bed31b6eaff6e26caf',\n      ],\n      [\n        '175e159f728b865a72f99cc6c6fc846de0b93833fd2222ed73fce5b551e5b739',\n        'd3506e0d9e3c79eba4ef97a51ff71f5eacb5955add24345c6efa6ffee9fed695',\n      ],\n      [\n        '363d90d447b00c9c99ceac05b6262ee053441c7e55552ffe526bad8f83ff4640',\n        '4e273adfc732221953b445397f3363145b9a89008199ecb62003c7f3bee9de9',\n      ],\n      [\n        '8b4b5f165df3c2be8c6244b5b745638843e4a781a15bcd1b69f79a55dffdf80c',\n        '4aad0a6f68d308b4b3fbd7813ab0da04f9e336546162ee56b3eff0c65fd4fd36',\n      ],\n      [\n        '723cbaa6e5db996d6bf771c00bd548c7b700dbffa6c0e77bcb6115925232fcda',\n        '96e867b5595cc498a921137488824d6e2660a0653779494801dc069d9eb39f5f',\n      ],\n      [\n        'eebfa4d493bebf98ba5feec812c2d3b50947961237a919839a533eca0e7dd7fa',\n        '5d9a8ca3970ef0f269ee7edaf178089d9ae4cdc3a711f712ddfd4fdae1de8999',\n      ],\n      [\n        '100f44da696e71672791d0a09b7bde459f1215a29b3c03bfefd7835b39a48db0',\n        'cdd9e13192a00b772ec8f3300c090666b7ff4a18ff5195ac0fbd5cd62bc65a09',\n      ],\n      [\n        'e1031be262c7ed1b1dc9227a4a04c017a77f8d4464f3b3852c8acde6e534fd2d',\n        '9d7061928940405e6bb6a4176597535af292dd419e1ced79a44f18f29456a00d',\n      ],\n      [\n        'feea6cae46d55b530ac2839f143bd7ec5cf8b266a41d6af52d5e688d9094696d',\n        'e57c6b6c97dce1bab06e4e12bf3ecd5c981c8957cc41442d3155debf18090088',\n      ],\n      [\n        'da67a91d91049cdcb367be4be6ffca3cfeed657d808583de33fa978bc1ec6cb1',\n        '9bacaa35481642bc41f463f7ec9780e5dec7adc508f740a17e9ea8e27a68be1d',\n      ],\n      [\n        '53904faa0b334cdda6e000935ef22151ec08d0f7bb11069f57545ccc1a37b7c0',\n        '5bc087d0bc80106d88c9eccac20d3c1c13999981e14434699dcb096b022771c8',\n      ],\n      [\n        '8e7bcd0bd35983a7719cca7764ca906779b53a043a9b8bcaeff959f43ad86047',\n        '10b7770b2a3da4b3940310420ca9514579e88e2e47fd68b3ea10047e8460372a',\n      ],\n      [\n        '385eed34c1cdff21e6d0818689b81bde71a7f4f18397e6690a841e1599c43862',\n        '283bebc3e8ea23f56701de19e9ebf4576b304eec2086dc8cc0458fe5542e5453',\n      ],\n      [\n        '6f9d9b803ecf191637c73a4413dfa180fddf84a5947fbc9c606ed86c3fac3a7',\n        '7c80c68e603059ba69b8e2a30e45c4d47ea4dd2f5c281002d86890603a842160',\n      ],\n      [\n        '3322d401243c4e2582a2147c104d6ecbf774d163db0f5e5313b7e0e742d0e6bd',\n        '56e70797e9664ef5bfb019bc4ddaf9b72805f63ea2873af624f3a2e96c28b2a0',\n      ],\n      [\n        '85672c7d2de0b7da2bd1770d89665868741b3f9af7643397721d74d28134ab83',\n        '7c481b9b5b43b2eb6374049bfa62c2e5e77f17fcc5298f44c8e3094f790313a6',\n      ],\n      [\n        '948bf809b1988a46b06c9f1919413b10f9226c60f668832ffd959af60c82a0a',\n        '53a562856dcb6646dc6b74c5d1c3418c6d4dff08c97cd2bed4cb7f88d8c8e589',\n      ],\n      [\n        '6260ce7f461801c34f067ce0f02873a8f1b0e44dfc69752accecd819f38fd8e8',\n        'bc2da82b6fa5b571a7f09049776a1ef7ecd292238051c198c1a84e95b2b4ae17',\n      ],\n      [\n        'e5037de0afc1d8d43d8348414bbf4103043ec8f575bfdc432953cc8d2037fa2d',\n        '4571534baa94d3b5f9f98d09fb990bddbd5f5b03ec481f10e0e5dc841d755bda',\n      ],\n      [\n        'e06372b0f4a207adf5ea905e8f1771b4e7e8dbd1c6a6c5b725866a0ae4fce725',\n        '7a908974bce18cfe12a27bb2ad5a488cd7484a7787104870b27034f94eee31dd',\n      ],\n      [\n        '213c7a715cd5d45358d0bbf9dc0ce02204b10bdde2a3f58540ad6908d0559754',\n        '4b6dad0b5ae462507013ad06245ba190bb4850f5f36a7eeddff2c27534b458f2',\n      ],\n      [\n        '4e7c272a7af4b34e8dbb9352a5419a87e2838c70adc62cddf0cc3a3b08fbd53c',\n        '17749c766c9d0b18e16fd09f6def681b530b9614bff7dd33e0b3941817dcaae6',\n      ],\n      [\n        'fea74e3dbe778b1b10f238ad61686aa5c76e3db2be43057632427e2840fb27b6',\n        '6e0568db9b0b13297cf674deccb6af93126b596b973f7b77701d3db7f23cb96f',\n      ],\n      [\n        '76e64113f677cf0e10a2570d599968d31544e179b760432952c02a4417bdde39',\n        'c90ddf8dee4e95cf577066d70681f0d35e2a33d2b56d2032b4b1752d1901ac01',\n      ],\n      [\n        'c738c56b03b2abe1e8281baa743f8f9a8f7cc643df26cbee3ab150242bcbb891',\n        '893fb578951ad2537f718f2eacbfbbbb82314eef7880cfe917e735d9699a84c3',\n      ],\n      [\n        'd895626548b65b81e264c7637c972877d1d72e5f3a925014372e9f6588f6c14b',\n        'febfaa38f2bc7eae728ec60818c340eb03428d632bb067e179363ed75d7d991f',\n      ],\n      [\n        'b8da94032a957518eb0f6433571e8761ceffc73693e84edd49150a564f676e03',\n        '2804dfa44805a1e4d7c99cc9762808b092cc584d95ff3b511488e4e74efdf6e7',\n      ],\n      [\n        'e80fea14441fb33a7d8adab9475d7fab2019effb5156a792f1a11778e3c0df5d',\n        'eed1de7f638e00771e89768ca3ca94472d155e80af322ea9fcb4291b6ac9ec78',\n      ],\n      [\n        'a301697bdfcd704313ba48e51d567543f2a182031efd6915ddc07bbcc4e16070',\n        '7370f91cfb67e4f5081809fa25d40f9b1735dbf7c0a11a130c0d1a041e177ea1',\n      ],\n      [\n        '90ad85b389d6b936463f9d0512678de208cc330b11307fffab7ac63e3fb04ed4',\n        'e507a3620a38261affdcbd9427222b839aefabe1582894d991d4d48cb6ef150',\n      ],\n      [\n        '8f68b9d2f63b5f339239c1ad981f162ee88c5678723ea3351b7b444c9ec4c0da',\n        '662a9f2dba063986de1d90c2b6be215dbbea2cfe95510bfdf23cbf79501fff82',\n      ],\n      [\n        'e4f3fb0176af85d65ff99ff9198c36091f48e86503681e3e6686fd5053231e11',\n        '1e63633ad0ef4f1c1661a6d0ea02b7286cc7e74ec951d1c9822c38576feb73bc',\n      ],\n      [\n        '8c00fa9b18ebf331eb961537a45a4266c7034f2f0d4e1d0716fb6eae20eae29e',\n        'efa47267fea521a1a9dc343a3736c974c2fadafa81e36c54e7d2a4c66702414b',\n      ],\n      [\n        'e7a26ce69dd4829f3e10cec0a9e98ed3143d084f308b92c0997fddfc60cb3e41',\n        '2a758e300fa7984b471b006a1aafbb18d0a6b2c0420e83e20e8a9421cf2cfd51',\n      ],\n      [\n        'b6459e0ee3662ec8d23540c223bcbdc571cbcb967d79424f3cf29eb3de6b80ef',\n        '67c876d06f3e06de1dadf16e5661db3c4b3ae6d48e35b2ff30bf0b61a71ba45',\n      ],\n      [\n        'd68a80c8280bb840793234aa118f06231d6f1fc67e73c5a5deda0f5b496943e8',\n        'db8ba9fff4b586d00c4b1f9177b0e28b5b0e7b8f7845295a294c84266b133120',\n      ],\n      [\n        '324aed7df65c804252dc0270907a30b09612aeb973449cea4095980fc28d3d5d',\n        '648a365774b61f2ff130c0c35aec1f4f19213b0c7e332843967224af96ab7c84',\n      ],\n      [\n        '4df9c14919cde61f6d51dfdbe5fee5dceec4143ba8d1ca888e8bd373fd054c96',\n        '35ec51092d8728050974c23a1d85d4b5d506cdc288490192ebac06cad10d5d',\n      ],\n      [\n        '9c3919a84a474870faed8a9c1cc66021523489054d7f0308cbfc99c8ac1f98cd',\n        'ddb84f0f4a4ddd57584f044bf260e641905326f76c64c8e6be7e5e03d4fc599d',\n      ],\n      [\n        '6057170b1dd12fdf8de05f281d8e06bb91e1493a8b91d4cc5a21382120a959e5',\n        '9a1af0b26a6a4807add9a2daf71df262465152bc3ee24c65e899be932385a2a8',\n      ],\n      [\n        'a576df8e23a08411421439a4518da31880cef0fba7d4df12b1a6973eecb94266',\n        '40a6bf20e76640b2c92b97afe58cd82c432e10a7f514d9f3ee8be11ae1b28ec8',\n      ],\n      [\n        '7778a78c28dec3e30a05fe9629de8c38bb30d1f5cf9a3a208f763889be58ad71',\n        '34626d9ab5a5b22ff7098e12f2ff580087b38411ff24ac563b513fc1fd9f43ac',\n      ],\n      [\n        '928955ee637a84463729fd30e7afd2ed5f96274e5ad7e5cb09eda9c06d903ac',\n        'c25621003d3f42a827b78a13093a95eeac3d26efa8a8d83fc5180e935bcd091f',\n      ],\n      [\n        '85d0fef3ec6db109399064f3a0e3b2855645b4a907ad354527aae75163d82751',\n        '1f03648413a38c0be29d496e582cf5663e8751e96877331582c237a24eb1f962',\n      ],\n      [\n        'ff2b0dce97eece97c1c9b6041798b85dfdfb6d8882da20308f5404824526087e',\n        '493d13fef524ba188af4c4dc54d07936c7b7ed6fb90e2ceb2c951e01f0c29907',\n      ],\n      [\n        '827fbbe4b1e880ea9ed2b2e6301b212b57f1ee148cd6dd28780e5e2cf856e241',\n        'c60f9c923c727b0b71bef2c67d1d12687ff7a63186903166d605b68baec293ec',\n      ],\n      [\n        'eaa649f21f51bdbae7be4ae34ce6e5217a58fdce7f47f9aa7f3b58fa2120e2b3',\n        'be3279ed5bbbb03ac69a80f89879aa5a01a6b965f13f7e59d47a5305ba5ad93d',\n      ],\n      [\n        'e4a42d43c5cf169d9391df6decf42ee541b6d8f0c9a137401e23632dda34d24f',\n        '4d9f92e716d1c73526fc99ccfb8ad34ce886eedfa8d8e4f13a7f7131deba9414',\n      ],\n      [\n        '1ec80fef360cbdd954160fadab352b6b92b53576a88fea4947173b9d4300bf19',\n        'aeefe93756b5340d2f3a4958a7abbf5e0146e77f6295a07b671cdc1cc107cefd',\n      ],\n      [\n        '146a778c04670c2f91b00af4680dfa8bce3490717d58ba889ddb5928366642be',\n        'b318e0ec3354028add669827f9d4b2870aaa971d2f7e5ed1d0b297483d83efd0',\n      ],\n      [\n        'fa50c0f61d22e5f07e3acebb1aa07b128d0012209a28b9776d76a8793180eef9',\n        '6b84c6922397eba9b72cd2872281a68a5e683293a57a213b38cd8d7d3f4f2811',\n      ],\n      [\n        'da1d61d0ca721a11b1a5bf6b7d88e8421a288ab5d5bba5220e53d32b5f067ec2',\n        '8157f55a7c99306c79c0766161c91e2966a73899d279b48a655fba0f1ad836f1',\n      ],\n      [\n        'a8e282ff0c9706907215ff98e8fd416615311de0446f1e062a73b0610d064e13',\n        '7f97355b8db81c09abfb7f3c5b2515888b679a3e50dd6bd6cef7c73111f4cc0c',\n      ],\n      [\n        '174a53b9c9a285872d39e56e6913cab15d59b1fa512508c022f382de8319497c',\n        'ccc9dc37abfc9c1657b4155f2c47f9e6646b3a1d8cb9854383da13ac079afa73',\n      ],\n      [\n        '959396981943785c3d3e57edf5018cdbe039e730e4918b3d884fdff09475b7ba',\n        '2e7e552888c331dd8ba0386a4b9cd6849c653f64c8709385e9b8abf87524f2fd',\n      ],\n      [\n        'd2a63a50ae401e56d645a1153b109a8fcca0a43d561fba2dbb51340c9d82b151',\n        'e82d86fb6443fcb7565aee58b2948220a70f750af484ca52d4142174dcf89405',\n      ],\n      [\n        '64587e2335471eb890ee7896d7cfdc866bacbdbd3839317b3436f9b45617e073',\n        'd99fcdd5bf6902e2ae96dd6447c299a185b90a39133aeab358299e5e9faf6589',\n      ],\n      [\n        '8481bde0e4e4d885b3a546d3e549de042f0aa6cea250e7fd358d6c86dd45e458',\n        '38ee7b8cba5404dd84a25bf39cecb2ca900a79c42b262e556d64b1b59779057e',\n      ],\n      [\n        '13464a57a78102aa62b6979ae817f4637ffcfed3c4b1ce30bcd6303f6caf666b',\n        '69be159004614580ef7e433453ccb0ca48f300a81d0942e13f495a907f6ecc27',\n      ],\n      [\n        'bc4a9df5b713fe2e9aef430bcc1dc97a0cd9ccede2f28588cada3a0d2d83f366',\n        'd3a81ca6e785c06383937adf4b798caa6e8a9fbfa547b16d758d666581f33c1',\n      ],\n      [\n        '8c28a97bf8298bc0d23d8c749452a32e694b65e30a9472a3954ab30fe5324caa',\n        '40a30463a3305193378fedf31f7cc0eb7ae784f0451cb9459e71dc73cbef9482',\n      ],\n      [\n        '8ea9666139527a8c1dd94ce4f071fd23c8b350c5a4bb33748c4ba111faccae0',\n        '620efabbc8ee2782e24e7c0cfb95c5d735b783be9cf0f8e955af34a30e62b945',\n      ],\n      [\n        'dd3625faef5ba06074669716bbd3788d89bdde815959968092f76cc4eb9a9787',\n        '7a188fa3520e30d461da2501045731ca941461982883395937f68d00c644a573',\n      ],\n      [\n        'f710d79d9eb962297e4f6232b40e8f7feb2bc63814614d692c12de752408221e',\n        'ea98e67232d3b3295d3b535532115ccac8612c721851617526ae47a9c77bfc82',\n      ],\n    ],\n  },\n  naf: {\n    wnd: 7,\n    points: [\n      [\n        'f9308a019258c31049344f85f89d5229b531c845836f99b08601f113bce036f9',\n        '388f7b0f632de8140fe337e62a37f3566500a99934c2231b6cb9fd7584b8e672',\n      ],\n      [\n        '2f8bde4d1a07209355b4a7250a5c5128e88b84bddc619ab7cba8d569b240efe4',\n        'd8ac222636e5e3d6d4dba9dda6c9c426f788271bab0d6840dca87d3aa6ac62d6',\n      ],\n      [\n        '5cbdf0646e5db4eaa398f365f2ea7a0e3d419b7e0330e39ce92bddedcac4f9bc',\n        '6aebca40ba255960a3178d6d861a54dba813d0b813fde7b5a5082628087264da',\n      ],\n      [\n        'acd484e2f0c7f65309ad178a9f559abde09796974c57e714c35f110dfc27ccbe',\n        'cc338921b0a7d9fd64380971763b61e9add888a4375f8e0f05cc262ac64f9c37',\n      ],\n      [\n        '774ae7f858a9411e5ef4246b70c65aac5649980be5c17891bbec17895da008cb',\n        'd984a032eb6b5e190243dd56d7b7b365372db1e2dff9d6a8301d74c9c953c61b',\n      ],\n      [\n        'f28773c2d975288bc7d1d205c3748651b075fbc6610e58cddeeddf8f19405aa8',\n        'ab0902e8d880a89758212eb65cdaf473a1a06da521fa91f29b5cb52db03ed81',\n      ],\n      [\n        'd7924d4f7d43ea965a465ae3095ff41131e5946f3c85f79e44adbcf8e27e080e',\n        '581e2872a86c72a683842ec228cc6defea40af2bd896d3a5c504dc9ff6a26b58',\n      ],\n      [\n        'defdea4cdb677750a420fee807eacf21eb9898ae79b9768766e4faa04a2d4a34',\n        '4211ab0694635168e997b0ead2a93daeced1f4a04a95c0f6cfb199f69e56eb77',\n      ],\n      [\n        '2b4ea0a797a443d293ef5cff444f4979f06acfebd7e86d277475656138385b6c',\n        '85e89bc037945d93b343083b5a1c86131a01f60c50269763b570c854e5c09b7a',\n      ],\n      [\n        '352bbf4a4cdd12564f93fa332ce333301d9ad40271f8107181340aef25be59d5',\n        '321eb4075348f534d59c18259dda3e1f4a1b3b2e71b1039c67bd3d8bcf81998c',\n      ],\n      [\n        '2fa2104d6b38d11b0230010559879124e42ab8dfeff5ff29dc9cdadd4ecacc3f',\n        '2de1068295dd865b64569335bd5dd80181d70ecfc882648423ba76b532b7d67',\n      ],\n      [\n        '9248279b09b4d68dab21a9b066edda83263c3d84e09572e269ca0cd7f5453714',\n        '73016f7bf234aade5d1aa71bdea2b1ff3fc0de2a887912ffe54a32ce97cb3402',\n      ],\n      [\n        'daed4f2be3a8bf278e70132fb0beb7522f570e144bf615c07e996d443dee8729',\n        'a69dce4a7d6c98e8d4a1aca87ef8d7003f83c230f3afa726ab40e52290be1c55',\n      ],\n      [\n        'c44d12c7065d812e8acf28d7cbb19f9011ecd9e9fdf281b0e6a3b5e87d22e7db',\n        '2119a460ce326cdc76c45926c982fdac0e106e861edf61c5a039063f0e0e6482',\n      ],\n      [\n        '6a245bf6dc698504c89a20cfded60853152b695336c28063b61c65cbd269e6b4',\n        'e022cf42c2bd4a708b3f5126f16a24ad8b33ba48d0423b6efd5e6348100d8a82',\n      ],\n      [\n        '1697ffa6fd9de627c077e3d2fe541084ce13300b0bec1146f95ae57f0d0bd6a5',\n        'b9c398f186806f5d27561506e4557433a2cf15009e498ae7adee9d63d01b2396',\n      ],\n      [\n        '605bdb019981718b986d0f07e834cb0d9deb8360ffb7f61df982345ef27a7479',\n        '2972d2de4f8d20681a78d93ec96fe23c26bfae84fb14db43b01e1e9056b8c49',\n      ],\n      [\n        '62d14dab4150bf497402fdc45a215e10dcb01c354959b10cfe31c7e9d87ff33d',\n        '80fc06bd8cc5b01098088a1950eed0db01aa132967ab472235f5642483b25eaf',\n      ],\n      [\n        '80c60ad0040f27dade5b4b06c408e56b2c50e9f56b9b8b425e555c2f86308b6f',\n        '1c38303f1cc5c30f26e66bad7fe72f70a65eed4cbe7024eb1aa01f56430bd57a',\n      ],\n      [\n        '7a9375ad6167ad54aa74c6348cc54d344cc5dc9487d847049d5eabb0fa03c8fb',\n        'd0e3fa9eca8726909559e0d79269046bdc59ea10c70ce2b02d499ec224dc7f7',\n      ],\n      [\n        'd528ecd9b696b54c907a9ed045447a79bb408ec39b68df504bb51f459bc3ffc9',\n        'eecf41253136e5f99966f21881fd656ebc4345405c520dbc063465b521409933',\n      ],\n      [\n        '49370a4b5f43412ea25f514e8ecdad05266115e4a7ecb1387231808f8b45963',\n        '758f3f41afd6ed428b3081b0512fd62a54c3f3afbb5b6764b653052a12949c9a',\n      ],\n      [\n        '77f230936ee88cbbd73df930d64702ef881d811e0e1498e2f1c13eb1fc345d74',\n        '958ef42a7886b6400a08266e9ba1b37896c95330d97077cbbe8eb3c7671c60d6',\n      ],\n      [\n        'f2dac991cc4ce4b9ea44887e5c7c0bce58c80074ab9d4dbaeb28531b7739f530',\n        'e0dedc9b3b2f8dad4da1f32dec2531df9eb5fbeb0598e4fd1a117dba703a3c37',\n      ],\n      [\n        '463b3d9f662621fb1b4be8fbbe2520125a216cdfc9dae3debcba4850c690d45b',\n        '5ed430d78c296c3543114306dd8622d7c622e27c970a1de31cb377b01af7307e',\n      ],\n      [\n        'f16f804244e46e2a09232d4aff3b59976b98fac14328a2d1a32496b49998f247',\n        'cedabd9b82203f7e13d206fcdf4e33d92a6c53c26e5cce26d6579962c4e31df6',\n      ],\n      [\n        'caf754272dc84563b0352b7a14311af55d245315ace27c65369e15f7151d41d1',\n        'cb474660ef35f5f2a41b643fa5e460575f4fa9b7962232a5c32f908318a04476',\n      ],\n      [\n        '2600ca4b282cb986f85d0f1709979d8b44a09c07cb86d7c124497bc86f082120',\n        '4119b88753c15bd6a693b03fcddbb45d5ac6be74ab5f0ef44b0be9475a7e4b40',\n      ],\n      [\n        '7635ca72d7e8432c338ec53cd12220bc01c48685e24f7dc8c602a7746998e435',\n        '91b649609489d613d1d5e590f78e6d74ecfc061d57048bad9e76f302c5b9c61',\n      ],\n      [\n        '754e3239f325570cdbbf4a87deee8a66b7f2b33479d468fbc1a50743bf56cc18',\n        '673fb86e5bda30fb3cd0ed304ea49a023ee33d0197a695d0c5d98093c536683',\n      ],\n      [\n        'e3e6bd1071a1e96aff57859c82d570f0330800661d1c952f9fe2694691d9b9e8',\n        '59c9e0bba394e76f40c0aa58379a3cb6a5a2283993e90c4167002af4920e37f5',\n      ],\n      [\n        '186b483d056a033826ae73d88f732985c4ccb1f32ba35f4b4cc47fdcf04aa6eb',\n        '3b952d32c67cf77e2e17446e204180ab21fb8090895138b4a4a797f86e80888b',\n      ],\n      [\n        'df9d70a6b9876ce544c98561f4be4f725442e6d2b737d9c91a8321724ce0963f',\n        '55eb2dafd84d6ccd5f862b785dc39d4ab157222720ef9da217b8c45cf2ba2417',\n      ],\n      [\n        '5edd5cc23c51e87a497ca815d5dce0f8ab52554f849ed8995de64c5f34ce7143',\n        'efae9c8dbc14130661e8cec030c89ad0c13c66c0d17a2905cdc706ab7399a868',\n      ],\n      [\n        '290798c2b6476830da12fe02287e9e777aa3fba1c355b17a722d362f84614fba',\n        'e38da76dcd440621988d00bcf79af25d5b29c094db2a23146d003afd41943e7a',\n      ],\n      [\n        'af3c423a95d9f5b3054754efa150ac39cd29552fe360257362dfdecef4053b45',\n        'f98a3fd831eb2b749a93b0e6f35cfb40c8cd5aa667a15581bc2feded498fd9c6',\n      ],\n      [\n        '766dbb24d134e745cccaa28c99bf274906bb66b26dcf98df8d2fed50d884249a',\n        '744b1152eacbe5e38dcc887980da38b897584a65fa06cedd2c924f97cbac5996',\n      ],\n      [\n        '59dbf46f8c94759ba21277c33784f41645f7b44f6c596a58ce92e666191abe3e',\n        'c534ad44175fbc300f4ea6ce648309a042ce739a7919798cd85e216c4a307f6e',\n      ],\n      [\n        'f13ada95103c4537305e691e74e9a4a8dd647e711a95e73cb62dc6018cfd87b8',\n        'e13817b44ee14de663bf4bc808341f326949e21a6a75c2570778419bdaf5733d',\n      ],\n      [\n        '7754b4fa0e8aced06d4167a2c59cca4cda1869c06ebadfb6488550015a88522c',\n        '30e93e864e669d82224b967c3020b8fa8d1e4e350b6cbcc537a48b57841163a2',\n      ],\n      [\n        '948dcadf5990e048aa3874d46abef9d701858f95de8041d2a6828c99e2262519',\n        'e491a42537f6e597d5d28a3224b1bc25df9154efbd2ef1d2cbba2cae5347d57e',\n      ],\n      [\n        '7962414450c76c1689c7b48f8202ec37fb224cf5ac0bfa1570328a8a3d7c77ab',\n        '100b610ec4ffb4760d5c1fc133ef6f6b12507a051f04ac5760afa5b29db83437',\n      ],\n      [\n        '3514087834964b54b15b160644d915485a16977225b8847bb0dd085137ec47ca',\n        'ef0afbb2056205448e1652c48e8127fc6039e77c15c2378b7e7d15a0de293311',\n      ],\n      [\n        'd3cc30ad6b483e4bc79ce2c9dd8bc54993e947eb8df787b442943d3f7b527eaf',\n        '8b378a22d827278d89c5e9be8f9508ae3c2ad46290358630afb34db04eede0a4',\n      ],\n      [\n        '1624d84780732860ce1c78fcbfefe08b2b29823db913f6493975ba0ff4847610',\n        '68651cf9b6da903e0914448c6cd9d4ca896878f5282be4c8cc06e2a404078575',\n      ],\n      [\n        '733ce80da955a8a26902c95633e62a985192474b5af207da6df7b4fd5fc61cd4',\n        'f5435a2bd2badf7d485a4d8b8db9fcce3e1ef8e0201e4578c54673bc1dc5ea1d',\n      ],\n      [\n        '15d9441254945064cf1a1c33bbd3b49f8966c5092171e699ef258dfab81c045c',\n        'd56eb30b69463e7234f5137b73b84177434800bacebfc685fc37bbe9efe4070d',\n      ],\n      [\n        'a1d0fcf2ec9de675b612136e5ce70d271c21417c9d2b8aaaac138599d0717940',\n        'edd77f50bcb5a3cab2e90737309667f2641462a54070f3d519212d39c197a629',\n      ],\n      [\n        'e22fbe15c0af8ccc5780c0735f84dbe9a790badee8245c06c7ca37331cb36980',\n        'a855babad5cd60c88b430a69f53a1a7a38289154964799be43d06d77d31da06',\n      ],\n      [\n        '311091dd9860e8e20ee13473c1155f5f69635e394704eaa74009452246cfa9b3',\n        '66db656f87d1f04fffd1f04788c06830871ec5a64feee685bd80f0b1286d8374',\n      ],\n      [\n        '34c1fd04d301be89b31c0442d3e6ac24883928b45a9340781867d4232ec2dbdf',\n        '9414685e97b1b5954bd46f730174136d57f1ceeb487443dc5321857ba73abee',\n      ],\n      [\n        'f219ea5d6b54701c1c14de5b557eb42a8d13f3abbcd08affcc2a5e6b049b8d63',\n        '4cb95957e83d40b0f73af4544cccf6b1f4b08d3c07b27fb8d8c2962a400766d1',\n      ],\n      [\n        'd7b8740f74a8fbaab1f683db8f45de26543a5490bca627087236912469a0b448',\n        'fa77968128d9c92ee1010f337ad4717eff15db5ed3c049b3411e0315eaa4593b',\n      ],\n      [\n        '32d31c222f8f6f0ef86f7c98d3a3335ead5bcd32abdd94289fe4d3091aa824bf',\n        '5f3032f5892156e39ccd3d7915b9e1da2e6dac9e6f26e961118d14b8462e1661',\n      ],\n      [\n        '7461f371914ab32671045a155d9831ea8793d77cd59592c4340f86cbc18347b5',\n        '8ec0ba238b96bec0cbdddcae0aa442542eee1ff50c986ea6b39847b3cc092ff6',\n      ],\n      [\n        'ee079adb1df1860074356a25aa38206a6d716b2c3e67453d287698bad7b2b2d6',\n        '8dc2412aafe3be5c4c5f37e0ecc5f9f6a446989af04c4e25ebaac479ec1c8c1e',\n      ],\n      [\n        '16ec93e447ec83f0467b18302ee620f7e65de331874c9dc72bfd8616ba9da6b5',\n        '5e4631150e62fb40d0e8c2a7ca5804a39d58186a50e497139626778e25b0674d',\n      ],\n      [\n        'eaa5f980c245f6f038978290afa70b6bd8855897f98b6aa485b96065d537bd99',\n        'f65f5d3e292c2e0819a528391c994624d784869d7e6ea67fb18041024edc07dc',\n      ],\n      [\n        '78c9407544ac132692ee1910a02439958ae04877151342ea96c4b6b35a49f51',\n        'f3e0319169eb9b85d5404795539a5e68fa1fbd583c064d2462b675f194a3ddb4',\n      ],\n      [\n        '494f4be219a1a77016dcd838431aea0001cdc8ae7a6fc688726578d9702857a5',\n        '42242a969283a5f339ba7f075e36ba2af925ce30d767ed6e55f4b031880d562c',\n      ],\n      [\n        'a598a8030da6d86c6bc7f2f5144ea549d28211ea58faa70ebf4c1e665c1fe9b5',\n        '204b5d6f84822c307e4b4a7140737aec23fc63b65b35f86a10026dbd2d864e6b',\n      ],\n      [\n        'c41916365abb2b5d09192f5f2dbeafec208f020f12570a184dbadc3e58595997',\n        '4f14351d0087efa49d245b328984989d5caf9450f34bfc0ed16e96b58fa9913',\n      ],\n      [\n        '841d6063a586fa475a724604da03bc5b92a2e0d2e0a36acfe4c73a5514742881',\n        '73867f59c0659e81904f9a1c7543698e62562d6744c169ce7a36de01a8d6154',\n      ],\n      [\n        '5e95bb399a6971d376026947f89bde2f282b33810928be4ded112ac4d70e20d5',\n        '39f23f366809085beebfc71181313775a99c9aed7d8ba38b161384c746012865',\n      ],\n      [\n        '36e4641a53948fd476c39f8a99fd974e5ec07564b5315d8bf99471bca0ef2f66',\n        'd2424b1b1abe4eb8164227b085c9aa9456ea13493fd563e06fd51cf5694c78fc',\n      ],\n      [\n        '336581ea7bfbbb290c191a2f507a41cf5643842170e914faeab27c2c579f726',\n        'ead12168595fe1be99252129b6e56b3391f7ab1410cd1e0ef3dcdcabd2fda224',\n      ],\n      [\n        '8ab89816dadfd6b6a1f2634fcf00ec8403781025ed6890c4849742706bd43ede',\n        '6fdcef09f2f6d0a044e654aef624136f503d459c3e89845858a47a9129cdd24e',\n      ],\n      [\n        '1e33f1a746c9c5778133344d9299fcaa20b0938e8acff2544bb40284b8c5fb94',\n        '60660257dd11b3aa9c8ed618d24edff2306d320f1d03010e33a7d2057f3b3b6',\n      ],\n      [\n        '85b7c1dcb3cec1b7ee7f30ded79dd20a0ed1f4cc18cbcfcfa410361fd8f08f31',\n        '3d98a9cdd026dd43f39048f25a8847f4fcafad1895d7a633c6fed3c35e999511',\n      ],\n      [\n        '29df9fbd8d9e46509275f4b125d6d45d7fbe9a3b878a7af872a2800661ac5f51',\n        'b4c4fe99c775a606e2d8862179139ffda61dc861c019e55cd2876eb2a27d84b',\n      ],\n      [\n        'a0b1cae06b0a847a3fea6e671aaf8adfdfe58ca2f768105c8082b2e449fce252',\n        'ae434102edde0958ec4b19d917a6a28e6b72da1834aff0e650f049503a296cf2',\n      ],\n      [\n        '4e8ceafb9b3e9a136dc7ff67e840295b499dfb3b2133e4ba113f2e4c0e121e5',\n        'cf2174118c8b6d7a4b48f6d534ce5c79422c086a63460502b827ce62a326683c',\n      ],\n      [\n        'd24a44e047e19b6f5afb81c7ca2f69080a5076689a010919f42725c2b789a33b',\n        '6fb8d5591b466f8fc63db50f1c0f1c69013f996887b8244d2cdec417afea8fa3',\n      ],\n      [\n        'ea01606a7a6c9cdd249fdfcfacb99584001edd28abbab77b5104e98e8e3b35d4',\n        '322af4908c7312b0cfbfe369f7a7b3cdb7d4494bc2823700cfd652188a3ea98d',\n      ],\n      [\n        'af8addbf2b661c8a6c6328655eb96651252007d8c5ea31be4ad196de8ce2131f',\n        '6749e67c029b85f52a034eafd096836b2520818680e26ac8f3dfbcdb71749700',\n      ],\n      [\n        'e3ae1974566ca06cc516d47e0fb165a674a3dabcfca15e722f0e3450f45889',\n        '2aeabe7e4531510116217f07bf4d07300de97e4874f81f533420a72eeb0bd6a4',\n      ],\n      [\n        '591ee355313d99721cf6993ffed1e3e301993ff3ed258802075ea8ced397e246',\n        'b0ea558a113c30bea60fc4775460c7901ff0b053d25ca2bdeee98f1a4be5d196',\n      ],\n      [\n        '11396d55fda54c49f19aa97318d8da61fa8584e47b084945077cf03255b52984',\n        '998c74a8cd45ac01289d5833a7beb4744ff536b01b257be4c5767bea93ea57a4',\n      ],\n      [\n        '3c5d2a1ba39c5a1790000738c9e0c40b8dcdfd5468754b6405540157e017aa7a',\n        'b2284279995a34e2f9d4de7396fc18b80f9b8b9fdd270f6661f79ca4c81bd257',\n      ],\n      [\n        'cc8704b8a60a0defa3a99a7299f2e9c3fbc395afb04ac078425ef8a1793cc030',\n        'bdd46039feed17881d1e0862db347f8cf395b74fc4bcdc4e940b74e3ac1f1b13',\n      ],\n      [\n        'c533e4f7ea8555aacd9777ac5cad29b97dd4defccc53ee7ea204119b2889b197',\n        '6f0a256bc5efdf429a2fb6242f1a43a2d9b925bb4a4b3a26bb8e0f45eb596096',\n      ],\n      [\n        'c14f8f2ccb27d6f109f6d08d03cc96a69ba8c34eec07bbcf566d48e33da6593',\n        'c359d6923bb398f7fd4473e16fe1c28475b740dd098075e6c0e8649113dc3a38',\n      ],\n      [\n        'a6cbc3046bc6a450bac24789fa17115a4c9739ed75f8f21ce441f72e0b90e6ef',\n        '21ae7f4680e889bb130619e2c0f95a360ceb573c70603139862afd617fa9b9f',\n      ],\n      [\n        '347d6d9a02c48927ebfb86c1359b1caf130a3c0267d11ce6344b39f99d43cc38',\n        '60ea7f61a353524d1c987f6ecec92f086d565ab687870cb12689ff1e31c74448',\n      ],\n      [\n        'da6545d2181db8d983f7dcb375ef5866d47c67b1bf31c8cf855ef7437b72656a',\n        '49b96715ab6878a79e78f07ce5680c5d6673051b4935bd897fea824b77dc208a',\n      ],\n      [\n        'c40747cc9d012cb1a13b8148309c6de7ec25d6945d657146b9d5994b8feb1111',\n        '5ca560753be2a12fc6de6caf2cb489565db936156b9514e1bb5e83037e0fa2d4',\n      ],\n      [\n        '4e42c8ec82c99798ccf3a610be870e78338c7f713348bd34c8203ef4037f3502',\n        '7571d74ee5e0fb92a7a8b33a07783341a5492144cc54bcc40a94473693606437',\n      ],\n      [\n        '3775ab7089bc6af823aba2e1af70b236d251cadb0c86743287522a1b3b0dedea',\n        'be52d107bcfa09d8bcb9736a828cfa7fac8db17bf7a76a2c42ad961409018cf7',\n      ],\n      [\n        'cee31cbf7e34ec379d94fb814d3d775ad954595d1314ba8846959e3e82f74e26',\n        '8fd64a14c06b589c26b947ae2bcf6bfa0149ef0be14ed4d80f448a01c43b1c6d',\n      ],\n      [\n        'b4f9eaea09b6917619f6ea6a4eb5464efddb58fd45b1ebefcdc1a01d08b47986',\n        '39e5c9925b5a54b07433a4f18c61726f8bb131c012ca542eb24a8ac07200682a',\n      ],\n      [\n        'd4263dfc3d2df923a0179a48966d30ce84e2515afc3dccc1b77907792ebcc60e',\n        '62dfaf07a0f78feb30e30d6295853ce189e127760ad6cf7fae164e122a208d54',\n      ],\n      [\n        '48457524820fa65a4f8d35eb6930857c0032acc0a4a2de422233eeda897612c4',\n        '25a748ab367979d98733c38a1fa1c2e7dc6cc07db2d60a9ae7a76aaa49bd0f77',\n      ],\n      [\n        'dfeeef1881101f2cb11644f3a2afdfc2045e19919152923f367a1767c11cceda',\n        'ecfb7056cf1de042f9420bab396793c0c390bde74b4bbdff16a83ae09a9a7517',\n      ],\n      [\n        '6d7ef6b17543f8373c573f44e1f389835d89bcbc6062ced36c82df83b8fae859',\n        'cd450ec335438986dfefa10c57fea9bcc521a0959b2d80bbf74b190dca712d10',\n      ],\n      [\n        'e75605d59102a5a2684500d3b991f2e3f3c88b93225547035af25af66e04541f',\n        'f5c54754a8f71ee540b9b48728473e314f729ac5308b06938360990e2bfad125',\n      ],\n      [\n        'eb98660f4c4dfaa06a2be453d5020bc99a0c2e60abe388457dd43fefb1ed620c',\n        '6cb9a8876d9cb8520609af3add26cd20a0a7cd8a9411131ce85f44100099223e',\n      ],\n      [\n        '13e87b027d8514d35939f2e6892b19922154596941888336dc3563e3b8dba942',\n        'fef5a3c68059a6dec5d624114bf1e91aac2b9da568d6abeb2570d55646b8adf1',\n      ],\n      [\n        'ee163026e9fd6fe017c38f06a5be6fc125424b371ce2708e7bf4491691e5764a',\n        '1acb250f255dd61c43d94ccc670d0f58f49ae3fa15b96623e5430da0ad6c62b2',\n      ],\n      [\n        'b268f5ef9ad51e4d78de3a750c2dc89b1e626d43505867999932e5db33af3d80',\n        '5f310d4b3c99b9ebb19f77d41c1dee018cf0d34fd4191614003e945a1216e423',\n      ],\n      [\n        'ff07f3118a9df035e9fad85eb6c7bfe42b02f01ca99ceea3bf7ffdba93c4750d',\n        '438136d603e858a3a5c440c38eccbaddc1d2942114e2eddd4740d098ced1f0d8',\n      ],\n      [\n        '8d8b9855c7c052a34146fd20ffb658bea4b9f69e0d825ebec16e8c3ce2b526a1',\n        'cdb559eedc2d79f926baf44fb84ea4d44bcf50fee51d7ceb30e2e7f463036758',\n      ],\n      [\n        '52db0b5384dfbf05bfa9d472d7ae26dfe4b851ceca91b1eba54263180da32b63',\n        'c3b997d050ee5d423ebaf66a6db9f57b3180c902875679de924b69d84a7b375',\n      ],\n      [\n        'e62f9490d3d51da6395efd24e80919cc7d0f29c3f3fa48c6fff543becbd43352',\n        '6d89ad7ba4876b0b22c2ca280c682862f342c8591f1daf5170e07bfd9ccafa7d',\n      ],\n      [\n        '7f30ea2476b399b4957509c88f77d0191afa2ff5cb7b14fd6d8e7d65aaab1193',\n        'ca5ef7d4b231c94c3b15389a5f6311e9daff7bb67b103e9880ef4bff637acaec',\n      ],\n      [\n        '5098ff1e1d9f14fb46a210fada6c903fef0fb7b4a1dd1d9ac60a0361800b7a00',\n        '9731141d81fc8f8084d37c6e7542006b3ee1b40d60dfe5362a5b132fd17ddc0',\n      ],\n      [\n        '32b78c7de9ee512a72895be6b9cbefa6e2f3c4ccce445c96b9f2c81e2778ad58',\n        'ee1849f513df71e32efc3896ee28260c73bb80547ae2275ba497237794c8753c',\n      ],\n      [\n        'e2cb74fddc8e9fbcd076eef2a7c72b0ce37d50f08269dfc074b581550547a4f7',\n        'd3aa2ed71c9dd2247a62df062736eb0baddea9e36122d2be8641abcb005cc4a4',\n      ],\n      [\n        '8438447566d4d7bedadc299496ab357426009a35f235cb141be0d99cd10ae3a8',\n        'c4e1020916980a4da5d01ac5e6ad330734ef0d7906631c4f2390426b2edd791f',\n      ],\n      [\n        '4162d488b89402039b584c6fc6c308870587d9c46f660b878ab65c82c711d67e',\n        '67163e903236289f776f22c25fb8a3afc1732f2b84b4e95dbda47ae5a0852649',\n      ],\n      [\n        '3fad3fa84caf0f34f0f89bfd2dcf54fc175d767aec3e50684f3ba4a4bf5f683d',\n        'cd1bc7cb6cc407bb2f0ca647c718a730cf71872e7d0d2a53fa20efcdfe61826',\n      ],\n      [\n        '674f2600a3007a00568c1a7ce05d0816c1fb84bf1370798f1c69532faeb1a86b',\n        '299d21f9413f33b3edf43b257004580b70db57da0b182259e09eecc69e0d38a5',\n      ],\n      [\n        'd32f4da54ade74abb81b815ad1fb3b263d82d6c692714bcff87d29bd5ee9f08f',\n        'f9429e738b8e53b968e99016c059707782e14f4535359d582fc416910b3eea87',\n      ],\n      [\n        '30e4e670435385556e593657135845d36fbb6931f72b08cb1ed954f1e3ce3ff6',\n        '462f9bce619898638499350113bbc9b10a878d35da70740dc695a559eb88db7b',\n      ],\n      [\n        'be2062003c51cc3004682904330e4dee7f3dcd10b01e580bf1971b04d4cad297',\n        '62188bc49d61e5428573d48a74e1c655b1c61090905682a0d5558ed72dccb9bc',\n      ],\n      [\n        '93144423ace3451ed29e0fb9ac2af211cb6e84a601df5993c419859fff5df04a',\n        '7c10dfb164c3425f5c71a3f9d7992038f1065224f72bb9d1d902a6d13037b47c',\n      ],\n      [\n        'b015f8044f5fcbdcf21ca26d6c34fb8197829205c7b7d2a7cb66418c157b112c',\n        'ab8c1e086d04e813744a655b2df8d5f83b3cdc6faa3088c1d3aea1454e3a1d5f',\n      ],\n      [\n        'd5e9e1da649d97d89e4868117a465a3a4f8a18de57a140d36b3f2af341a21b52',\n        '4cb04437f391ed73111a13cc1d4dd0db1693465c2240480d8955e8592f27447a',\n      ],\n      [\n        'd3ae41047dd7ca065dbf8ed77b992439983005cd72e16d6f996a5316d36966bb',\n        'bd1aeb21ad22ebb22a10f0303417c6d964f8cdd7df0aca614b10dc14d125ac46',\n      ],\n      [\n        '463e2763d885f958fc66cdd22800f0a487197d0a82e377b49f80af87c897b065',\n        'bfefacdb0e5d0fd7df3a311a94de062b26b80c61fbc97508b79992671ef7ca7f',\n      ],\n      [\n        '7985fdfd127c0567c6f53ec1bb63ec3158e597c40bfe747c83cddfc910641917',\n        '603c12daf3d9862ef2b25fe1de289aed24ed291e0ec6708703a5bd567f32ed03',\n      ],\n      [\n        '74a1ad6b5f76e39db2dd249410eac7f99e74c59cb83d2d0ed5ff1543da7703e9',\n        'cc6157ef18c9c63cd6193d83631bbea0093e0968942e8c33d5737fd790e0db08',\n      ],\n      [\n        '30682a50703375f602d416664ba19b7fc9bab42c72747463a71d0896b22f6da3',\n        '553e04f6b018b4fa6c8f39e7f311d3176290d0e0f19ca73f17714d9977a22ff8',\n      ],\n      [\n        '9e2158f0d7c0d5f26c3791efefa79597654e7a2b2464f52b1ee6c1347769ef57',\n        '712fcdd1b9053f09003a3481fa7762e9ffd7c8ef35a38509e2fbf2629008373',\n      ],\n      [\n        '176e26989a43c9cfeba4029c202538c28172e566e3c4fce7322857f3be327d66',\n        'ed8cc9d04b29eb877d270b4878dc43c19aefd31f4eee09ee7b47834c1fa4b1c3',\n      ],\n      [\n        '75d46efea3771e6e68abb89a13ad747ecf1892393dfc4f1b7004788c50374da8',\n        '9852390a99507679fd0b86fd2b39a868d7efc22151346e1a3ca4726586a6bed8',\n      ],\n      [\n        '809a20c67d64900ffb698c4c825f6d5f2310fb0451c869345b7319f645605721',\n        '9e994980d9917e22b76b061927fa04143d096ccc54963e6a5ebfa5f3f8e286c1',\n      ],\n      [\n        '1b38903a43f7f114ed4500b4eac7083fdefece1cf29c63528d563446f972c180',\n        '4036edc931a60ae889353f77fd53de4a2708b26b6f5da72ad3394119daf408f9',\n      ],\n    ],\n  },\n};","deps":{}},{"id":"node_modules/browserify-sign/node_modules/elliptic/lib/elliptic/utils.js","source":"'use strict';\n\nvar utils = exports;\nvar BN = require('bn.js');\nvar minAssert = require('minimalistic-assert');\nvar minUtils = require('minimalistic-crypto-utils');\n\nutils.assert = minAssert;\nutils.toArray = minUtils.toArray;\nutils.zero2 = minUtils.zero2;\nutils.toHex = minUtils.toHex;\nutils.encode = minUtils.encode;\n\n// Represent num in a w-NAF form\nfunction getNAF(num, w, bits) {\n  var naf = new Array(Math.max(num.bitLength(), bits) + 1);\n  naf.fill(0);\n\n  var ws = 1 << (w + 1);\n  var k = num.clone();\n\n  for (var i = 0; i < naf.length; i++) {\n    var z;\n    var mod = k.andln(ws - 1);\n    if (k.isOdd()) {\n      if (mod > (ws >> 1) - 1)\n        z = (ws >> 1) - mod;\n      else\n        z = mod;\n      k.isubn(z);\n    } else {\n      z = 0;\n    }\n\n    naf[i] = z;\n    k.iushrn(1);\n  }\n\n  return naf;\n}\nutils.getNAF = getNAF;\n\n// Represent k1, k2 in a Joint Sparse Form\nfunction getJSF(k1, k2) {\n  var jsf = [\n    [],\n    [],\n  ];\n\n  k1 = k1.clone();\n  k2 = k2.clone();\n  var d1 = 0;\n  var d2 = 0;\n  var m8;\n  while (k1.cmpn(-d1) > 0 || k2.cmpn(-d2) > 0) {\n    // First phase\n    var m14 = (k1.andln(3) + d1) & 3;\n    var m24 = (k2.andln(3) + d2) & 3;\n    if (m14 === 3)\n      m14 = -1;\n    if (m24 === 3)\n      m24 = -1;\n    var u1;\n    if ((m14 & 1) === 0) {\n      u1 = 0;\n    } else {\n      m8 = (k1.andln(7) + d1) & 7;\n      if ((m8 === 3 || m8 === 5) && m24 === 2)\n        u1 = -m14;\n      else\n        u1 = m14;\n    }\n    jsf[0].push(u1);\n\n    var u2;\n    if ((m24 & 1) === 0) {\n      u2 = 0;\n    } else {\n      m8 = (k2.andln(7) + d2) & 7;\n      if ((m8 === 3 || m8 === 5) && m14 === 2)\n        u2 = -m24;\n      else\n        u2 = m24;\n    }\n    jsf[1].push(u2);\n\n    // Second phase\n    if (2 * d1 === u1 + 1)\n      d1 = 1 - d1;\n    if (2 * d2 === u2 + 1)\n      d2 = 1 - d2;\n    k1.iushrn(1);\n    k2.iushrn(1);\n  }\n\n  return jsf;\n}\nutils.getJSF = getJSF;\n\nfunction cachedProperty(obj, name, computer) {\n  var key = '_' + name;\n  obj.prototype[name] = function cachedProperty() {\n    return this[key] !== undefined ? this[key] :\n      this[key] = computer.call(this);\n  };\n}\nutils.cachedProperty = cachedProperty;\n\nfunction parseBytes(bytes) {\n  return typeof bytes === 'string' ? utils.toArray(bytes, 'hex') :\n    bytes;\n}\nutils.parseBytes = parseBytes;\n\nfunction intFromLE(bytes) {\n  return new BN(bytes, 'hex', 'le');\n}\nutils.intFromLE = intFromLE;","deps":{"bn.js":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js","minimalistic-assert":"node_modules/minimalistic-assert/index.js","minimalistic-crypto-utils":"node_modules/minimalistic-crypto-utils/lib/utils.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/node_modules/bn.js/lib/bn.js","source":"arguments[4][\"node_modules/browserify-sign/node_modules/asn1.js/node_modules/bn.js/lib/bn.js\"][0].apply(exports,arguments)","deps":{"buffer":"node_modules/browser-resolve/empty.js"}},{"id":"node_modules/browserify-sign/node_modules/elliptic/package.json","source":"module.exports={\n  \"_args\": [\n    [\n      \"elliptic@6.5.4\",\n      \"/home/olamy/dev/sources/jenkins/blueocean-plugin/target/checkout/blueocean-pipeline-editor\"\n    ]\n  ],\n  \"_development\": true,\n  \"_from\": \"elliptic@6.5.4\",\n  \"_id\": \"elliptic@6.5.4\",\n  \"_inBundle\": false,\n  \"_integrity\": \"sha512-iLhC6ULemrljPZb+QutR5TQGB+pdW6KGD5RSegS+8sorOZT+rdQFbsQFJgvN3eRqNALqJer4oQ16YvJHlU8hzQ==\",\n  \"_location\": \"/browserify-sign/elliptic\",\n  \"_phantomChildren\": {},\n  \"_requested\": {\n    \"type\": \"version\",\n    \"registry\": true,\n    \"raw\": \"elliptic@6.5.4\",\n    \"name\": \"elliptic\",\n    \"escapedName\": \"elliptic\",\n    \"rawSpec\": \"6.5.4\",\n    \"saveSpec\": null,\n    \"fetchSpec\": \"6.5.4\"\n  },\n  \"_requiredBy\": [\n    \"/browserify-sign\"\n  ],\n  \"_resolved\": \"https://registry.npmjs.org/elliptic/-/elliptic-6.5.4.tgz\",\n  \"_spec\": \"6.5.4\",\n  \"_where\": \"/home/olamy/dev/sources/jenkins/blueocean-plugin/target/checkout/blueocean-pipeline-editor\",\n  \"author\": {\n    \"name\": \"Fedor Indutny\",\n    \"email\": \"fedor@indutny.com\"\n  },\n  \"bugs\": {\n    \"url\": \"https://github.com/indutny/elliptic/issues\"\n  },\n  \"dependencies\": {\n    \"bn.js\": \"^4.11.9\",\n    \"brorand\": \"^1.1.0\",\n    \"hash.js\": \"^1.0.0\",\n    \"hmac-drbg\": \"^1.0.1\",\n    \"inherits\": \"^2.0.4\",\n    \"minimalistic-assert\": \"^1.0.1\",\n    \"minimalistic-crypto-utils\": \"^1.0.1\"\n  },\n  \"description\": \"EC cryptography\",\n  \"devDependencies\": {\n    \"brfs\": \"^2.0.2\",\n    \"coveralls\": \"^3.1.0\",\n    \"eslint\": \"^7.6.0\",\n    \"grunt\": \"^1.2.1\",\n    \"grunt-browserify\": \"^5.3.0\",\n    \"grunt-cli\": \"^1.3.2\",\n    \"grunt-contrib-connect\": \"^3.0.0\",\n    \"grunt-contrib-copy\": \"^1.0.0\",\n    \"grunt-contrib-uglify\": \"^5.0.0\",\n    \"grunt-mocha-istanbul\": \"^5.0.2\",\n    \"grunt-saucelabs\": \"^9.0.1\",\n    \"istanbul\": \"^0.4.5\",\n    \"mocha\": \"^8.0.1\"\n  },\n  \"files\": [\n    \"lib\"\n  ],\n  \"homepage\": \"https://github.com/indutny/elliptic\",\n  \"keywords\": [\n    \"EC\",\n    \"Elliptic\",\n    \"curve\",\n    \"Cryptography\"\n  ],\n  \"license\": \"MIT\",\n  \"main\": \"lib/elliptic.js\",\n  \"name\": \"elliptic\",\n  \"repository\": {\n    \"type\": \"git\",\n    \"url\": \"git+ssh://git@github.com/indutny/elliptic.git\"\n  },\n  \"scripts\": {\n    \"lint\": \"eslint lib test\",\n    \"lint:fix\": \"npm run lint -- --fix\",\n    \"test\": \"npm run lint && npm run unit\",\n    \"unit\": \"istanbul test _mocha --reporter=spec test/index.js\",\n    \"version\": \"grunt dist && git add dist/\"\n  },\n  \"version\": \"6.5.4\"\n}","deps":{}},{"id":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js","source":"if (typeof Object.create === 'function') {\n  // implementation from standard node.js 'util' module\n  module.exports = function inherits(ctor, superCtor) {\n    if (superCtor) {\n      ctor.super_ = superCtor\n      ctor.prototype = Object.create(superCtor.prototype, {\n        constructor: {\n          value: ctor,\n          enumerable: false,\n          writable: true,\n          configurable: true\n        }\n      })\n    }\n  };\n} else {\n  // old school shim for old browsers\n  module.exports = function inherits(ctor, superCtor) {\n    if (superCtor) {\n      ctor.super_ = superCtor\n      var TempCtor = function () {}\n      TempCtor.prototype = superCtor.prototype\n      ctor.prototype = new TempCtor()\n      ctor.prototype.constructor = ctor\n    }\n  }\n}","deps":{}},{"id":"node_modules/browserify-sign/node_modules/parse-asn1/aesid.json","source":"module.exports={\"2.16.840.1.101.3.4.1.1\": \"aes-128-ecb\",\n\"2.16.840.1.101.3.4.1.2\": \"aes-128-cbc\",\n\"2.16.840.1.101.3.4.1.3\": \"aes-128-ofb\",\n\"2.16.840.1.101.3.4.1.4\": \"aes-128-cfb\",\n\"2.16.840.1.101.3.4.1.21\": \"aes-192-ecb\",\n\"2.16.840.1.101.3.4.1.22\": \"aes-192-cbc\",\n\"2.16.840.1.101.3.4.1.23\": \"aes-192-ofb\",\n\"2.16.840.1.101.3.4.1.24\": \"aes-192-cfb\",\n\"2.16.840.1.101.3.4.1.41\": \"aes-256-ecb\",\n\"2.16.840.1.101.3.4.1.42\": \"aes-256-cbc\",\n\"2.16.840.1.101.3.4.1.43\": \"aes-256-ofb\",\n\"2.16.840.1.101.3.4.1.44\": \"aes-256-cfb\"\n}","deps":{}},{"id":"node_modules/browserify-sign/node_modules/parse-asn1/asn1.js","source":"'use strict'\n\nvar asn1 = require('asn1.js')\n\nexports.certificate = require('./certificate')\n\nvar RSAPrivateKey = asn1.define('RSAPrivateKey', function () {\n  this.seq().obj(\n    this.key('version').int(),\n    this.key('modulus').int(),\n    this.key('publicExponent').int(),\n    this.key('privateExponent').int(),\n    this.key('prime1').int(),\n    this.key('prime2').int(),\n    this.key('exponent1').int(),\n    this.key('exponent2').int(),\n    this.key('coefficient').int()\n  )\n})\nexports.RSAPrivateKey = RSAPrivateKey\n\nvar RSAPublicKey = asn1.define('RSAPublicKey', function () {\n  this.seq().obj(\n    this.key('modulus').int(),\n    this.key('publicExponent').int()\n  )\n})\nexports.RSAPublicKey = RSAPublicKey\n\nvar PublicKey = asn1.define('SubjectPublicKeyInfo', function () {\n  this.seq().obj(\n    this.key('algorithm').use(AlgorithmIdentifier),\n    this.key('subjectPublicKey').bitstr()\n  )\n})\nexports.PublicKey = PublicKey\n\nvar AlgorithmIdentifier = asn1.define('AlgorithmIdentifier', function () {\n  this.seq().obj(\n    this.key('algorithm').objid(),\n    this.key('none').null_().optional(),\n    this.key('curve').objid().optional(),\n    this.key('params').seq().obj(\n      this.key('p').int(),\n      this.key('q').int(),\n      this.key('g').int()\n    ).optional()\n  )\n})\n\nvar PrivateKeyInfo = asn1.define('PrivateKeyInfo', function () {\n  this.seq().obj(\n    this.key('version').int(),\n    this.key('algorithm').use(AlgorithmIdentifier),\n    this.key('subjectPrivateKey').octstr()\n  )\n})\nexports.PrivateKey = PrivateKeyInfo\nvar EncryptedPrivateKeyInfo = asn1.define('EncryptedPrivateKeyInfo', function () {\n  this.seq().obj(\n    this.key('algorithm').seq().obj(\n      this.key('id').objid(),\n      this.key('decrypt').seq().obj(\n        this.key('kde').seq().obj(\n          this.key('id').objid(),\n          this.key('kdeparams').seq().obj(\n            this.key('salt').octstr(),\n            this.key('iters').int()\n          )\n        ),\n        this.key('cipher').seq().obj(\n          this.key('algo').objid(),\n          this.key('iv').octstr()\n        )\n      )\n    ),\n    this.key('subjectPrivateKey').octstr()\n  )\n})\n\nexports.EncryptedPrivateKey = EncryptedPrivateKeyInfo\n\nvar DSAPrivateKey = asn1.define('DSAPrivateKey', function () {\n  this.seq().obj(\n    this.key('version').int(),\n    this.key('p').int(),\n    this.key('q').int(),\n    this.key('g').int(),\n    this.key('pub_key').int(),\n    this.key('priv_key').int()\n  )\n})\nexports.DSAPrivateKey = DSAPrivateKey\n\nexports.DSAparam = asn1.define('DSAparam', function () {\n  this.int()\n})\n\nvar ECPrivateKey = asn1.define('ECPrivateKey', function () {\n  this.seq().obj(\n    this.key('version').int(),\n    this.key('privateKey').octstr(),\n    this.key('parameters').optional().explicit(0).use(ECParameters),\n    this.key('publicKey').optional().explicit(1).bitstr()\n  )\n})\nexports.ECPrivateKey = ECPrivateKey\n\nvar ECParameters = asn1.define('ECParameters', function () {\n  this.choice({\n    namedCurve: this.objid()\n  })\n})\n\nexports.signature = asn1.define('signature', function () {\n  this.seq().obj(\n    this.key('r').int(),\n    this.key('s').int()\n  )\n})","deps":{"./certificate":"node_modules/browserify-sign/node_modules/parse-asn1/certificate.js","asn1.js":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1.js"}},{"id":"node_modules/browserify-sign/node_modules/parse-asn1/certificate.js","source":"'use strict'\n\nvar asn = require('asn1.js')\n\nvar Time = asn.define('Time', function () {\n  this.choice({\n    utcTime: this.utctime(),\n    generalTime: this.gentime()\n  })\n})\n\nvar AttributeTypeValue = asn.define('AttributeTypeValue', function () {\n  this.seq().obj(\n    this.key('type').objid(),\n    this.key('value').any()\n  )\n})\n\nvar AlgorithmIdentifier = asn.define('AlgorithmIdentifier', function () {\n  this.seq().obj(\n    this.key('algorithm').objid(),\n    this.key('parameters').optional(),\n    this.key('curve').objid().optional()\n  )\n})\n\nvar SubjectPublicKeyInfo = asn.define('SubjectPublicKeyInfo', function () {\n  this.seq().obj(\n    this.key('algorithm').use(AlgorithmIdentifier),\n    this.key('subjectPublicKey').bitstr()\n  )\n})\n\nvar RelativeDistinguishedName = asn.define('RelativeDistinguishedName', function () {\n  this.setof(AttributeTypeValue)\n})\n\nvar RDNSequence = asn.define('RDNSequence', function () {\n  this.seqof(RelativeDistinguishedName)\n})\n\nvar Name = asn.define('Name', function () {\n  this.choice({\n    rdnSequence: this.use(RDNSequence)\n  })\n})\n\nvar Validity = asn.define('Validity', function () {\n  this.seq().obj(\n    this.key('notBefore').use(Time),\n    this.key('notAfter').use(Time)\n  )\n})\n\nvar Extension = asn.define('Extension', function () {\n  this.seq().obj(\n    this.key('extnID').objid(),\n    this.key('critical').bool().def(false),\n    this.key('extnValue').octstr()\n  )\n})\n\nvar TBSCertificate = asn.define('TBSCertificate', function () {\n  this.seq().obj(\n    this.key('version').explicit(0).int().optional(),\n    this.key('serialNumber').int(),\n    this.key('signature').use(AlgorithmIdentifier),\n    this.key('issuer').use(Name),\n    this.key('validity').use(Validity),\n    this.key('subject').use(Name),\n    this.key('subjectPublicKeyInfo').use(SubjectPublicKeyInfo),\n    this.key('issuerUniqueID').implicit(1).bitstr().optional(),\n    this.key('subjectUniqueID').implicit(2).bitstr().optional(),\n    this.key('extensions').explicit(3).seqof(Extension).optional()\n  )\n})\n\nvar X509Certificate = asn.define('X509Certificate', function () {\n  this.seq().obj(\n    this.key('tbsCertificate').use(TBSCertificate),\n    this.key('signatureAlgorithm').use(AlgorithmIdentifier),\n    this.key('signatureValue').bitstr()\n  )\n})\n\nmodule.exports = X509Certificate","deps":{"asn1.js":"node_modules/browserify-sign/node_modules/asn1.js/lib/asn1.js"}},{"id":"node_modules/browserify-sign/node_modules/parse-asn1/fixProc.js","source":"var findProc = /Proc-Type: 4,ENCRYPTED[\\n\\r]+DEK-Info: AES-((?:128)|(?:192)|(?:256))-CBC,([0-9A-H]+)[\\n\\r]+([0-9A-z\\n\\r+/=]+)[\\n\\r]+/m\nvar startRegex = /^-----BEGIN ((?:.*? KEY)|CERTIFICATE)-----/m\nvar fullRegex = /^-----BEGIN ((?:.*? KEY)|CERTIFICATE)-----([0-9A-z\\n\\r+/=]+)-----END \\1-----$/m\nvar evp = require('evp_bytestokey')\nvar ciphers = require('browserify-aes')\nvar Buffer = require('safe-buffer').Buffer\nmodule.exports = function (okey, password) {\n  var key = okey.toString()\n  var match = key.match(findProc)\n  var decrypted\n  if (!match) {\n    var match2 = key.match(fullRegex)\n    decrypted = Buffer.from(match2[2].replace(/[\\r\\n]/g, ''), 'base64')\n  } else {\n    var suite = 'aes' + match[1]\n    var iv = Buffer.from(match[2], 'hex')\n    var cipherText = Buffer.from(match[3].replace(/[\\r\\n]/g, ''), 'base64')\n    var cipherKey = evp(password, iv.slice(0, 8), parseInt(match[1], 10)).key\n    var out = []\n    var cipher = ciphers.createDecipheriv(suite, cipherKey, iv)\n    out.push(cipher.update(cipherText))\n    out.push(cipher.final())\n    decrypted = Buffer.concat(out)\n  }\n  var tag = key.match(startRegex)[1]\n  return {\n    tag: tag,\n    data: decrypted\n  }\n}","deps":{"browserify-aes":"node_modules/browserify-aes/browser.js","evp_bytestokey":"node_modules/evp_bytestokey/index.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-sign/node_modules/parse-asn1/index.js","source":"var asn1 = require('./asn1')\nvar aesid = require('./aesid.json')\nvar fixProc = require('./fixProc')\nvar ciphers = require('browserify-aes')\nvar compat = require('pbkdf2')\nvar Buffer = require('safe-buffer').Buffer\nmodule.exports = parseKeys\n\nfunction parseKeys (buffer) {\n  var password\n  if (typeof buffer === 'object' && !Buffer.isBuffer(buffer)) {\n    password = buffer.passphrase\n    buffer = buffer.key\n  }\n  if (typeof buffer === 'string') {\n    buffer = Buffer.from(buffer)\n  }\n\n  var stripped = fixProc(buffer, password)\n\n  var type = stripped.tag\n  var data = stripped.data\n  var subtype, ndata\n  switch (type) {\n    case 'CERTIFICATE':\n      ndata = asn1.certificate.decode(data, 'der').tbsCertificate.subjectPublicKeyInfo\n      // falls through\n    case 'PUBLIC KEY':\n      if (!ndata) {\n        ndata = asn1.PublicKey.decode(data, 'der')\n      }\n      subtype = ndata.algorithm.algorithm.join('.')\n      switch (subtype) {\n        case '1.2.840.113549.1.1.1':\n          return asn1.RSAPublicKey.decode(ndata.subjectPublicKey.data, 'der')\n        case '1.2.840.10045.2.1':\n          ndata.subjectPrivateKey = ndata.subjectPublicKey\n          return {\n            type: 'ec',\n            data: ndata\n          }\n        case '1.2.840.10040.4.1':\n          ndata.algorithm.params.pub_key = asn1.DSAparam.decode(ndata.subjectPublicKey.data, 'der')\n          return {\n            type: 'dsa',\n            data: ndata.algorithm.params\n          }\n        default: throw new Error('unknown key id ' + subtype)\n      }\n      // throw new Error('unknown key type ' + type)\n    case 'ENCRYPTED PRIVATE KEY':\n      data = asn1.EncryptedPrivateKey.decode(data, 'der')\n      data = decrypt(data, password)\n      // falls through\n    case 'PRIVATE KEY':\n      ndata = asn1.PrivateKey.decode(data, 'der')\n      subtype = ndata.algorithm.algorithm.join('.')\n      switch (subtype) {\n        case '1.2.840.113549.1.1.1':\n          return asn1.RSAPrivateKey.decode(ndata.subjectPrivateKey, 'der')\n        case '1.2.840.10045.2.1':\n          return {\n            curve: ndata.algorithm.curve,\n            privateKey: asn1.ECPrivateKey.decode(ndata.subjectPrivateKey, 'der').privateKey\n          }\n        case '1.2.840.10040.4.1':\n          ndata.algorithm.params.priv_key = asn1.DSAparam.decode(ndata.subjectPrivateKey, 'der')\n          return {\n            type: 'dsa',\n            params: ndata.algorithm.params\n          }\n        default: throw new Error('unknown key id ' + subtype)\n      }\n      // throw new Error('unknown key type ' + type)\n    case 'RSA PUBLIC KEY':\n      return asn1.RSAPublicKey.decode(data, 'der')\n    case 'RSA PRIVATE KEY':\n      return asn1.RSAPrivateKey.decode(data, 'der')\n    case 'DSA PRIVATE KEY':\n      return {\n        type: 'dsa',\n        params: asn1.DSAPrivateKey.decode(data, 'der')\n      }\n    case 'EC PRIVATE KEY':\n      data = asn1.ECPrivateKey.decode(data, 'der')\n      return {\n        curve: data.parameters.value,\n        privateKey: data.privateKey\n      }\n    default: throw new Error('unknown key type ' + type)\n  }\n}\nparseKeys.signature = asn1.signature\nfunction decrypt (data, password) {\n  var salt = data.algorithm.decrypt.kde.kdeparams.salt\n  var iters = parseInt(data.algorithm.decrypt.kde.kdeparams.iters.toString(), 10)\n  var algo = aesid[data.algorithm.decrypt.cipher.algo.join('.')]\n  var iv = data.algorithm.decrypt.cipher.iv\n  var cipherText = data.subjectPrivateKey\n  var keylen = parseInt(algo.split('-')[1], 10) / 8\n  var key = compat.pbkdf2Sync(password, salt, iters, keylen, 'sha1')\n  var cipher = ciphers.createDecipheriv(algo, key, iv)\n  var out = []\n  out.push(cipher.update(cipherText))\n  out.push(cipher.final())\n  return Buffer.concat(out)\n}","deps":{"./aesid.json":"node_modules/browserify-sign/node_modules/parse-asn1/aesid.json","./asn1":"node_modules/browserify-sign/node_modules/parse-asn1/asn1.js","./fixProc":"node_modules/browserify-sign/node_modules/parse-asn1/fixProc.js","browserify-aes":"node_modules/browserify-aes/browser.js","pbkdf2":"node_modules/pbkdf2/browser.js","safe-buffer":"node_modules/browserify-sign/node_modules/safe-buffer/index.js"}},{"id":"node_modules/browserify-sign/node_modules/readable-stream/errors-browser.js","source":"'use strict';\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }\n\nvar codes = {};\n\nfunction createErrorType(code, message, Base) {\n  if (!Base) {\n    Base = Error;\n  }\n\n  function getMessage(arg1, arg2, arg3) {\n    if (typeof message === 'string') {\n      return message;\n    } else {\n      return message(arg1, arg2, arg3);\n    }\n  }\n\n  var NodeError =\n  /*#__PURE__*/\n  function (_Base) {\n    _inheritsLoose(NodeError, _Base);\n\n    function NodeError(arg1, arg2, arg3) {\n      return _Base.call(this, getMessage(arg1, arg2, arg3)) || this;\n    }\n\n    return NodeError;\n  }(Base);\n\n  NodeError.prototype.name = Base.name;\n  NodeError.prototype.code = code;\n  codes[code] = NodeError;\n} // https://github.com/nodejs/node/blob/v10.8.0/lib/internal/errors.js\n\n\nfunction oneOf(expected, thing) {\n  if (Array.isArray(expected)) {\n    var len = expected.length;\n    expected = expected.map(function (i) {\n      return String(i);\n    });\n\n    if (len > 2) {\n      return \"one of \".concat(thing, \" \").concat(expected.slice(0, len - 1).join(', '), \", or \") + expected[len - 1];\n    } else if (len === 2) {\n      return \"one of \".concat(thing, \" \").concat(expected[0], \" or \").concat(expected[1]);\n    } else {\n      return \"of \".concat(thing, \" \").concat(expected[0]);\n    }\n  } else {\n    return \"of \".concat(thing, \" \").concat(String(expected));\n  }\n} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith\n\n\nfunction startsWith(str, search, pos) {\n  return str.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;\n} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith\n\n\nfunction endsWith(str, search, this_len) {\n  if (this_len === undefined || this_len > str.length) {\n    this_len = str.length;\n  }\n\n  return str.substring(this_len - search.length, this_len) === search;\n} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes\n\n\nfunction includes(str, search, start) {\n  if (typeof start !== 'number') {\n    start = 0;\n  }\n\n  if (start + search.length > str.length) {\n    return false;\n  } else {\n    return str.indexOf(search, start) !== -1;\n  }\n}\n\ncreateErrorType('ERR_INVALID_OPT_VALUE', function (name, value) {\n  return 'The value \"' + value + '\" is invalid for option \"' + name + '\"';\n}, TypeError);\ncreateErrorType('ERR_INVALID_ARG_TYPE', function (name, expected, actual) {\n  // determiner: 'must be' or 'must not be'\n  var determiner;\n\n  if (typeof expected === 'string' && startsWith(expected, 'not ')) {\n    determiner = 'must not be';\n    expected = expected.replace(/^not /, '');\n  } else {\n    determiner = 'must be';\n  }\n\n  var msg;\n\n  if (endsWith(name, ' argument')) {\n    // For cases like 'first argument'\n    msg = \"The \".concat(name, \" \").concat(determiner, \" \").concat(oneOf(expected, 'type'));\n  } else {\n    var type = includes(name, '.') ? 'property' : 'argument';\n    msg = \"The \\\"\".concat(name, \"\\\" \").concat(type, \" \").concat(determiner, \" \").concat(oneOf(expected, 'type'));\n  }\n\n  msg += \". Received type \".concat(typeof actual);\n  return msg;\n}, TypeError);\ncreateErrorType('ERR_STREAM_PUSH_AFTER_EOF', 'stream.push() after EOF');\ncreateErrorType('ERR_METHOD_NOT_IMPLEMENTED', function (name) {\n  return 'The ' + name + ' method is not implemented';\n});\ncreateErrorType('ERR_STREAM_PREMATURE_CLOSE', 'Premature close');\ncreateErrorType('ERR_STREAM_DESTROYED', function (name) {\n  return 'Cannot call ' + name + ' after a stream was destroyed';\n});\ncreateErrorType('ERR_MULTIPLE_CALLBACK', 'Callback called multiple times');\ncreateErrorType('ERR_STREAM_CANNOT_PIPE', 'Cannot pipe, not readable');\ncreateErrorType('ERR_STREAM_WRITE_AFTER_END', 'write after end');\ncreateErrorType('ERR_STREAM_NULL_VALUES', 'May not write null values to stream', TypeError);\ncreateErrorType('ERR_UNKNOWN_ENCODING', function (arg) {\n  return 'Unknown encoding: ' + arg;\n}, TypeError);\ncreateErrorType('ERR_STREAM_UNSHIFT_AFTER_END_EVENT', 'stream.unshift() after end event');\nmodule.exports.codes = codes;","deps":{}},{"id":"node_modules/browserify-sign/node_modules/readable-stream/lib/_stream_duplex.js","source":"(function (process){\n// Copyright Joyent, Inc. and other Node contributors.\n//\n// Permission is hereby granted, free of charge, to any person obtaining a\n// copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to permit\n// persons to whom the Software is furnished to do so, subject to the\n// following conditions:\n//\n// The above copyright notice and this permission notice shall be included\n// in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n// USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n// a duplex stream is just a stream that is both readable and writable.\n// Since JS doesn't have multiple prototypal inheritance, this class\n// prototypally inherits from Readable, and then parasitically from\n// Writable.\n\n'use strict';\n\n/*<replacement>*/\nvar objectKeys = Object.keys || function (obj) {\n  var keys = [];\n  for (var key in obj) keys.push(key);\n  return keys;\n};\n/*</replacement>*/\n\nmodule.exports = Duplex;\nvar Readable = require('./_stream_readable');\nvar Writable = require('./_stream_writable');\nrequire('inherits')(Duplex, Readable);\n{\n  // Allow the keys array to be GC'ed.\n  var keys = objectKeys(Writable.prototype);\n  for (var v = 0; v < keys.length; v++) {\n    var method = keys[v];\n    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];\n  }\n}\nfunction Duplex(options) {\n  if (!(this instanceof Duplex)) return new Duplex(options);\n  Readable.call(this, options);\n  Writable.call(this, options);\n  this.allowHalfOpen = true;\n  if (options) {\n    if (options.readable === false) this.readable = false;\n    if (options.writable === false) this.writable = false;\n    if (options.allowHalfOpen === false) {\n      this.allowHalfOpen = false;\n      this.once('end', onend);\n    }\n  }\n}\nObject.defineProperty(Duplex.prototype, 'writableHighWaterMark', {\n  // making it explicit this property is not enumerable\n  // because otherwise some prototype manipulation in\n  // userland will fail\n  enumerable: false,\n  get: function get() {\n    return this._writableState.highWaterMark;\n  }\n});\nObject.defineProperty(Duplex.prototype, 'writableBuffer', {\n  // making it explicit this property is not enumerable\n  // because otherwise some prototype manipulation in\n  // userland will fail\n  enumerable: false,\n  get: function get() {\n    return this._writableState && this._writableState.getBuffer();\n  }\n});\nObject.defineProperty(Duplex.prototype, 'writableLength', {\n  // making it explicit this property is not enumerable\n  // because otherwise some prototype manipulation in\n  // userland will fail\n  enumerable: false,\n  get: function get() {\n    return this._writableState.length;\n  }\n});\n\n// the no-half-open enforcer\nfunction onend() {\n  // If the writable side ended, then we're ok.\n  if (this._writableState.ended) return;\n\n  // no more data can be written.\n  // But allow more writes to happen in this tick.\n  process.nextTick(onEndNT, this);\n}\nfunction onEndNT(self) {\n  self.end();\n}\nObject.defineProperty(Duplex.prototype, 'destroyed', {\n  // making it explicit this property is not enumerable\n  // because otherwise some prototype manipulation in\n  // userland will fail\n  enumerable: false,\n  get: function get() {\n    if (this._readableState === undefined || this._writableState === undefined) {\n      return false;\n    }\n    return this._readableState.destroyed && this._writableState.destroyed;\n  },\n  set: function set(value) {\n    // we ignore the value if the stream\n    // has not been initialized yet\n    if (this._readableState === undefined || this._writableState === undefined) {\n      return;\n    }\n\n    // backward compatibility, the user is explicitly\n    // managing destroyed\n    this._readableState.destroyed = value;\n    this._writableState.destroyed = value;\n  }\n});\n}).call(this,require('_process'))","deps":{"./_stream_readable":"node_modules/browserify-sign/node_modules/readable-stream/lib/_stream_readable.js","./_stream_writable":"node_modules/browserify-sign/node_modules/readable-stream/lib/_stream_writable.js","_process":"node_modules/process/browser.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/readable-stream/lib/_stream_passthrough.js","source":"'use strict';\n\nmodule.exports = PassThrough;\nvar Transform = require('./_stream_transform');\nrequire('inherits')(PassThrough, Transform);\nfunction PassThrough(options) {\n  if (!(this instanceof PassThrough)) return new PassThrough(options);\n  Transform.call(this, options);\n}\nPassThrough.prototype._transform = function (chunk, encoding, cb) {\n  cb(null, chunk);\n};","deps":{"./_stream_transform":"node_modules/browserify-sign/node_modules/readable-stream/lib/_stream_transform.js","inherits":"node_modules/browserify-sign/node_modules/inherits/inherits_browser.js"}},{"id":"node_modules/browserify-sign/node_modules/readable-stream/lib/_stream_readable.js","source":"(function (process,global){\n// Copyright Joyent, Inc. and other Node contributors.\n//\n// Permission is hereby granted, free of charge, to any person obtaining a\n// copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to permit\n// persons to whom the Software is furnished to do so, subject to the\n// following conditions:\n//\n// The above copyright notice and this permission notice shall be included\n// in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLD