/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import io.jenkins.blueocean.commons.MapsHelper;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueTrendContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.RunContainerImpl;
import io.jenkins.blueocean.service.embedded.util.Disabler;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.DELETE;

@Capability(value={"hudson.model.Job"})
public class AbstractPipelineImpl
extends BluePipeline {
    private final Job job;
    protected final BlueOrganization organization;
    public static final Predicate<Run> isRunning = r -> r != null && r.isBuilding();

    protected AbstractPipelineImpl(BlueOrganization organization, Job job) {
        this.job = job;
        this.organization = organization;
    }

    public String getOrganizationName() {
        return this.organization.getName();
    }

    @NonNull
    public BlueOrganization getOrganization() {
        return this.organization;
    }

    public String getName() {
        return this.job.getName();
    }

    public String getDisplayName() {
        return this.job.getDisplayName();
    }

    public Integer getWeatherScore() {
        return this.job.getBuildHealth().getScore();
    }

    public BlueRun getLatestRun() {
        Run run = this.job.getLastBuild();
        if (run != null) {
            return new AbstractRunImpl<Run>(run, (Reachable)this, this.organization){

                @Override
                public Collection<BlueActionProxy> getActions() {
                    return Collections.emptyList();
                }

                @Override
                public BlueTestSummary getTestSummary() {
                    return null;
                }
            };
        }
        return null;
    }

    public Long getEstimatedDurationInMillis() {
        return this.job.getEstimatedDuration();
    }

    public BlueRunContainer getRuns() {
        return new RunContainerImpl(this, this.job);
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies(this.job.getAllActions(), (Reachable)this);
    }

    @Navigable
    public BlueQueueContainer getQueue() {
        return new QueueContainerImpl(this);
    }

    @WebMethod(name={""})
    @DELETE
    public void delete() throws IOException, InterruptedException {
        this.job.delete();
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestException("Must provide pipeline name");
        }
        FavoriteUtil.toggle(favoriteAction, (Item)this.job);
        return FavoriteUtil.getFavorite((Item)this.job, () -> this.getLink().ancestor());
    }

    public String getFullName() {
        return AbstractPipelineImpl.getFullName(this.organization, (Item)this.job);
    }

    public String getFullDisplayName() {
        return AbstractPipelineImpl.getFullDisplayName(this.organization, (Item)this.job);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="isDisabled will return null if the job type doesn't support it")
    public Boolean getDisabled() {
        return Disabler.isDisabled(this.job);
    }

    public void enable() throws IOException {
        if (AbstractPipelineImpl.getPermissions((AbstractItem)this.job).getOrDefault("configure", Boolean.FALSE).booleanValue()) {
            Disabler.makeDisabled(this.job, false);
        }
    }

    public void disable() throws IOException {
        if (AbstractPipelineImpl.getPermissions((AbstractItem)this.job).getOrDefault("configure", Boolean.FALSE).booleanValue()) {
            Disabler.makeDisabled(this.job, true);
        }
    }

    public static String getFullDisplayName(@Nullable BlueOrganization org, @NonNull Item item) {
        ItemGroup<?> group = AbstractPipelineImpl.getBaseGroup(org);
        String[] displayNames = Functions.getRelativeDisplayNameFrom((Item)item, group).split(" \u00bb ");
        StringBuilder encodedDisplayName = new StringBuilder();
        for (int i = 0; i < displayNames.length; ++i) {
            if (i != 0) {
                encodedDisplayName.append(String.format("/%s", Util.rawEncode((String)displayNames[i])));
                continue;
            }
            encodedDisplayName.append(String.format("%s", Util.rawEncode((String)displayNames[i])));
        }
        return encodedDisplayName.toString();
    }

    public static String getFullName(@Nullable BlueOrganization org, @NonNull Item item) {
        ItemGroup<?> group = AbstractPipelineImpl.getBaseGroup(org);
        return Functions.getRelativeNameFrom((Item)item, group);
    }

    public static ItemGroup<?> getBaseGroup(BlueOrganization org) {
        ModifiableTopLevelItemGroup group = null;
        if (org instanceof AbstractOrganization) {
            group = ((AbstractOrganization)org).getGroup();
        }
        return group;
    }

    public Link getLink() {
        return this.organization.getLink().rel("pipelines").rel(AbstractPipelineImpl.getRecursivePathFromFullName(this));
    }

    public static String getRecursivePathFromFullName(BluePipeline pipeline) {
        StringBuilder pipelinePath = new StringBuilder();
        String[] names = pipeline.getFullName().split("/");
        int count = 1;
        if (names.length > 1) {
            for (String n : names) {
                if (count == 1) {
                    pipelinePath.append(n);
                } else {
                    pipelinePath.append("/pipelines/").append(n);
                }
                ++count;
            }
        } else {
            pipelinePath.append(pipeline.getFullName());
        }
        return pipelinePath.toString();
    }

    public List<Object> getParameters() {
        return AbstractPipelineImpl.getParameterDefinitions(this.job);
    }

    public static List<Object> getParameterDefinitions(Job job) {
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        ArrayList<Object> pds = new ArrayList<Object>();
        if (pp != null) {
            pds.addAll(pp.getParameterDefinitions());
        }
        return pds;
    }

    public Job getJob() {
        return this.job;
    }

    public Map<String, Boolean> getPermissions() {
        return AbstractPipelineImpl.getPermissions((AbstractItem)this.job);
    }

    public BluePipelineScm getScm() {
        return null;
    }

    public BlueTrendContainer getTrends() {
        return new BlueTrendContainerImpl(this);
    }

    public static Map<String, Boolean> getPermissions(AbstractItem item) {
        return MapsHelper.of((Object)"create", (Object)item.getACL().hasPermission(Item.CREATE), (Object)"configure", (Object)item.getACL().hasPermission(Item.CONFIGURE), (Object)"read", (Object)item.getACL().hasPermission(Item.READ), (Object)"start", (Object)item.getACL().hasPermission(Item.BUILD), (Object)"stop", (Object)item.getACL().hasPermission(Item.CANCEL));
    }

    public boolean isFavorite() {
        User user = User.current();
        return user != null && Favorites.isFavorite((User)user, (Item)this.job);
    }

    @Extension(ordinal=0.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof Job) {
                return new AbstractPipelineImpl(organization, (Job)item);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            if (context == target && target instanceof Job) {
                return this.getPipeline(target, parent, organization);
            }
            return null;
        }
    }
}

