/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.BlueTrendFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueTrend;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class BlueTrendContainerImpl
extends BlueTrendContainer {
    private final BluePipeline pipeline;

    public BlueTrendContainerImpl(BluePipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Link getLink() {
        return this.pipeline.getLink().rel("trends");
    }

    public BlueTrend get(String name) {
        Optional<BlueTrend> trend = StreamSupport.stream(this.list().spliterator(), false).filter(blueTrend -> blueTrend != null && blueTrend.getId().equals(name)).findFirst();
        if (!trend.isPresent()) {
            throw new ServiceException.NotFoundException("not found");
        }
        return trend.get();
    }

    @NonNull
    public Iterator<BlueTrend> iterator() {
        return BlueTrendFactory.getTrends((BluePipeline)this.pipeline, (Link)this.getLink()).iterator();
    }
}

