/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.service.embedded.rest.ChangeSetResource;
import java.util.Iterator;
import java.util.LinkedList;
import jenkins.scm.RunWithSCM;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayCause;

public class ChangeSetContainerImpl
extends Container<BlueChangeSetEntry> {
    private final BlueOrganization organization;
    private final BlueRun blueRun;
    private final Run run;

    public ChangeSetContainerImpl(BlueOrganization organization, BlueRun blueRun, Run run) {
        this.organization = organization;
        this.blueRun = blueRun;
        this.run = run;
    }

    public Link getLink() {
        return this.blueRun.getLink().rel("changeSet");
    }

    public BlueChangeSetEntry get(String name) {
        Iterator<BlueChangeSetEntry> i = this.iterator();
        while (i.hasNext()) {
            BlueChangeSetEntry set = i.next();
            if (!name.equals(set.getCommitId())) continue;
            return set;
        }
        return null;
    }

    public Iterator<BlueChangeSetEntry> iterator() {
        LinkedList<BlueChangeSetEntry> changesets;
        block6: {
            int checkoutCount;
            Run run;
            block5: {
                Run originalRun;
                run = this.run;
                changesets = new LinkedList<BlueChangeSetEntry>();
                checkoutCount = 0;
                ReplayCause replayCause = (ReplayCause)run.getCause(ReplayCause.class);
                while (replayCause != null && (originalRun = this.run.getParent().getBuildByNumber(replayCause.getOriginalNumber())) != null) {
                    run = originalRun;
                    replayCause = (ReplayCause)run.getCause(ReplayCause.class);
                }
                if (!(run instanceof AbstractBuild)) break block5;
                for (ChangeLogSet cs : ((AbstractBuild)run).getChangeSets()) {
                    for (ChangeLogSet.Entry e : cs) {
                        changesets.add(new ChangeSetResource(this.organization, e, (Reachable)this).setCheckoutCount(checkoutCount));
                    }
                    ++checkoutCount;
                }
                break block6;
            }
            if (!(run instanceof RunWithSCM)) break block6;
            for (ChangeLogSet cs : ((RunWithSCM)run).getChangeSets()) {
                for (ChangeLogSet.Entry e : cs) {
                    changesets.add(new ChangeSetResource(this.organization, e, (Reachable)this).setCheckoutCount(checkoutCount));
                }
                ++checkoutCount;
            }
        }
        return changesets.iterator();
    }
}

