/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class ContainerFilter
implements ExtensionPoint {
    public abstract String getName();

    public abstract Predicate<Item> getFilter();

    public static <T extends Item> Collection<T> filter(Collection<T> items) {
        String[] filterNames = ContainerFilter.filterNames();
        if (filterNames.length == 0) {
            return items;
        }
        return ContainerFilter.filter(items, filterNames);
    }

    public static <T extends Item> Collection<T> filter(Collection<T> items, String ... filterNames) {
        Predicate<Item>[] filters = ContainerFilter.getFilters(filterNames);
        LinkedList<Item> out = new LinkedList<Item>();
        block0: for (Item item : items) {
            for (Predicate<Item> filter : filters) {
                if (!filter.test(item)) continue block0;
            }
            out.add(item);
        }
        return out;
    }

    public static <T extends Item> Collection<T> filter(Collection<T> items, int start, int limit) {
        String[] filterNames = ContainerFilter.filterNames();
        int skipped = 0;
        Predicate<Item>[] filters = ContainerFilter.getFilters(filterNames);
        LinkedList<Item> out = new LinkedList<Item>();
        block0: for (Item item : items) {
            if (out.size() == limit) break;
            for (Predicate<Item> filter : filters) {
                if (!filter.test(item)) continue block0;
            }
            if (skipped++ < start) continue;
            out.add(item);
        }
        return out;
    }

    private static Predicate<Item>[] getFilters(String ... filterNames) {
        Predicate[] filters = new Predicate[filterNames.length];
        if (filterNames.length > 0) {
            for (int i = 0; i < filterNames.length; ++i) {
                Predicate<Item> f = ContainerFilter.getItemFilter(filterNames[i]);
                if (f == null) {
                    throw new IllegalArgumentException("Invalid filter type specified.");
                }
                filters[i] = f;
            }
        }
        return filters;
    }

    private static String[] filterNames() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return new String[0];
        }
        String itemFilter = req.getParameter("filter");
        if (itemFilter == null) {
            return new String[0];
        }
        return itemFilter.split(",");
    }

    public static Predicate<Item> getItemFilter(String filterName) {
        for (ContainerFilter itemFilter : ExtensionList.lookup(ContainerFilter.class)) {
            if (!itemFilter.getName().equals(filterName)) continue;
            return itemFilter.getFilter();
        }
        return null;
    }
}

