/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.Links;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.kohsuke.stapler.export.Exported;

public class QueuedBlueRun
extends BlueRun {
    public static final String QUEUE_ID = "queueId";
    private final BlueRun.BlueRunState runState;
    private final BlueRun.BlueRunResult runResult;
    private final QueueItemImpl item;
    private final Link parent;

    public QueuedBlueRun(BlueRun.BlueRunState runState, BlueRun.BlueRunResult runResult, QueueItemImpl item, Link parent) {
        this.runState = runState;
        this.runResult = runResult;
        this.item = item;
        this.parent = parent;
    }

    public String getName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getOrganization() {
        return this.item.getOrganization();
    }

    public String getId() {
        return Integer.toString(this.item.getExpectedBuildNumber());
    }

    @Exported(name="queueId")
    public String getQueueId() {
        return this.item.getId();
    }

    public String getPipeline() {
        return this.item.getPipeline();
    }

    public Date getStartTime() {
        return null;
    }

    @NonNull
    public Container<BlueChangeSetEntry> getChangeSet() {
        return Containers.empty((Link)this.getLink());
    }

    public Date getEnQueueTime() {
        return this.item.getQueuedTime();
    }

    public Date getEndTime() {
        return null;
    }

    public Long getDurationInMillis() {
        return null;
    }

    public Long getEstimatedDurtionInMillis() {
        return null;
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.runState;
    }

    public BlueRun.BlueRunResult getResult() {
        return this.runResult;
    }

    public String getRunSummary() {
        return null;
    }

    public String getType() {
        return "QueuedItem";
    }

    public BlueRun stop(Boolean blocking, Integer timeOutInSecs) {
        this.item.delete();
        return new QueuedBlueRun(BlueRun.BlueRunState.FINISHED, BlueRun.BlueRunResult.ABORTED, this.item, this.parent);
    }

    public String getStartTimeString() {
        return null;
    }

    public String getEnQueueTimeString() {
        return null;
    }

    public String getEndTimeString() {
        return null;
    }

    public String getArtifactsZipFile() {
        return null;
    }

    public BlueArtifactContainer getArtifacts() {
        return null;
    }

    public BluePipelineNodeContainer getNodes() {
        return null;
    }

    public Collection<BlueActionProxy> getActions() {
        return Collections.emptyList();
    }

    public BluePipelineStepContainer getSteps() {
        return null;
    }

    public Object getLog() {
        return null;
    }

    public BlueRun replay() {
        return null;
    }

    public boolean isReplayable() {
        return false;
    }

    public BlueTestResultContainer getTests() {
        return null;
    }

    public BlueTestSummary getTestSummary() {
        return null;
    }

    public BlueTestSummary getBlueTestSummary() {
        return null;
    }

    public Collection<BlueRun.BlueCause> getCauses() {
        return this.item.getCauses();
    }

    public String getCauseOfBlockage() {
        return this.item.getCauseOfBlockage();
    }

    public Link getLink() {
        return this.parent.rel("runs/" + this.item.getExpectedBuildNumber());
    }

    public Links getLinks() {
        return super.getLinks().add("parent", this.parent);
    }
}

