/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.util.RunList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.model.lazy.LazyBuildMixIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class RunSearch
extends OmniSearch<BlueRun> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunSearch.class);
    public static final String COLLECT_THREADS_KEY = "blueocean.collectRuns.threads";
    private static final int COLLECT_THREADS = Integer.getInteger("blueocean.collectRuns.threads", Runtime.getRuntime().availableProcessors() / 2);

    public String getType() {
        return "run";
    }

    public Pageable<BlueRun> search(Query q) {
        String pipeline = q.param("pipeline", false);
        boolean latestOnly = (Boolean)q.param("latestOnly", Boolean.class);
        if (pipeline != null) {
            TopLevelItem p = Jenkins.get().getItem(pipeline);
            if (latestOnly) {
                BlueRun r = this.getLatestRun((Job)p);
                if (r != null) {
                    return Pageables.wrap(Collections.singletonList(r));
                }
                Pageables.empty();
            }
            if (p instanceof Job) {
                return Pageables.wrap(RunSearch.findRuns((Job)p));
            }
            throw new ServiceException.BadRequestException(String.format("Pipeline %s not found", pipeline));
        }
        if (latestOnly) {
            return Pageables.empty();
        }
        return Pageables.wrap(RunSearch.findRuns(null));
    }

    public static Iterable<BlueRun> findRuns(Job job, Link parent) {
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>();
        List pipelines = job != null ? Collections.singletonList(job) : Jenkins.get().getItems(Job.class);
        for (Job p : pipelines) {
            RunList runList = p.getBuilds();
            for (Run r : runList) {
                BlueRun run = BlueRunFactory.getRun((Run)r, () -> parent);
                if (run == null) continue;
                runs.add(run);
            }
        }
        return runs;
    }

    public static Iterable<BlueRun> findRuns(@NonNull Job job, Link parent, int start, int limit) {
        Iterator runIterator;
        if (job instanceof LazyBuildMixIn.LazyLoadingJob) {
            LazyBuildMixIn lazyLoadMixin = ((LazyBuildMixIn.LazyLoadingJob)job).getLazyBuildMixIn();
            runIterator = lazyLoadMixin.getRunMap().iterator();
        } else {
            runIterator = job.getBuilds().iterator();
        }
        return RunSearch.collectRuns(runIterator, parent, start, limit);
    }

    private static List<BlueRun> collectRuns(Iterator<? extends Run> runIterator, Link parent, int start, int limit) {
        if (COLLECT_THREADS > 1) {
            LOGGER.debug("collectRunsParallel {}", (Object)COLLECT_THREADS);
            return RunSearch.collectRunsParallel(runIterator, parent, start, limit);
        }
        return RunSearch.collectRunsSingleThread(runIterator, parent, start, limit);
    }

    private static List<BlueRun> collectRunsSingleThread(Iterator<? extends Run> runIterator, Link parent, int start, int limit) {
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>();
        int skipCount = start;
        while (runIterator.hasNext()) {
            if (skipCount > 0) {
                runIterator.next();
                --skipCount;
            } else {
                Run r = runIterator.next();
                BlueRun run = BlueRunFactory.getRun((Run)r, () -> parent);
                if (run != null) {
                    runs.add(run);
                }
            }
            if (runs.size() < limit) continue;
            return runs;
        }
        return runs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static List<BlueRun> collectRunsParallel(Iterator<? extends Run> runIterator, Link parent, int start, int limit) {
        CopyOnWriteArrayList<Callable<BlueRun>> callables = new CopyOnWriteArrayList<Callable<BlueRun>>();
        int skipCount = start;
        while (runIterator.hasNext()) {
            if (skipCount > 0) {
                runIterator.next();
                --skipCount;
            } else {
                Run r2 = runIterator.next();
                callables.add(() -> BlueRunFactory.getRun((Run)r2, () -> parent));
            }
            if (callables.size() < limit) continue;
        }
        int n = callables.size();
        LOGGER.debug("before submit size:{}", (Object)n);
        if (n < 1) {
            return Collections.emptyList();
        }
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(Math.min(n, COLLECT_THREADS), Math.min(n, COLLECT_THREADS), 60L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(n));
        ExecutorCompletionService ecs = new ExecutorCompletionService(executorService);
        for (Callable callable : callables) {
            ecs.submit(callable);
        }
        LOGGER.debug("submit done size:{}", (Object)n);
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>(n);
        try {
            void var10_13;
            boolean bl = false;
            while (var10_13 < n) {
                BlueRun r3 = (BlueRun)ecs.take().get();
                if (r3 != null) {
                    runs.add(r3);
                }
                ++var10_13;
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            executorService.shutdownNow();
        }
        LOGGER.debug("runs found:{}", (Object)runs.size());
        runs.sort(Comparator.comparing(r -> Integer.valueOf(r.getId())).reversed());
        return runs;
    }

    public static Iterable<BlueRun> findRuns(Job pipeline) {
        return RunSearch.findRuns(pipeline, null);
    }

    private BlueRun getLatestRun(Job job) {
        if (job == null) {
            return null;
        }
        BlueOrganization org = OrganizationFactory.getInstance().getContainingOrg((Item)job);
        if (org == null) {
            return null;
        }
        Run r = job.getLastBuild();
        if (r == null) {
            return null;
        }
        Resource resource = BluePipelineFactory.resolve((Item)job);
        if (resource == null) {
            return null;
        }
        return BlueRunFactory.getRun((Run)r, (Reachable)resource);
    }
}

