/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.commons.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Utils {
    public static <T> T cast(String value, Class<T> type) {
        try {
            if (String.class.isAssignableFrom(type)) {
                return (T)value;
            }
            if (Integer.class.isAssignableFrom(type)) {
                return (T)Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(type)) {
                return (T)Long.valueOf(value);
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return (T)Boolean.valueOf(value);
            }
            if (List.class.isAssignableFrom(type)) {
                String[] vs = value.split(",");
                ArrayList<String> list = new ArrayList<String>();
                for (String v : vs) {
                    list.add(v.trim());
                }
                return (T)Collections.singletonList(list);
            }
            if (Set.class.isAssignableFrom(type)) {
                String[] vs = value.split(",");
                HashSet<String> set = new HashSet<String>();
                for (String v : vs) {
                    set.add(v.trim());
                }
                return (T)Collections.singleton(set);
            }
            throw new ServiceException.UnexpectedErrorException(String.format("Unknown type %s", type));
        }
        catch (NumberFormatException e) {
            throw new ServiceException.BadRequestException(String.format("Value %s can't be converted to type: %s", value, type));
        }
    }

    public static String ensureTrailingSlash(@NonNull String path) {
        return path.charAt(path.length() - 1) == '/' ? path : path + "/";
    }

    public static <T> int skip(Iterator<T> base, int offset) {
        int i;
        Objects.requireNonNull(base);
        if (offset < 0) {
            throw new IllegalArgumentException("offest must be >= )");
        }
        for (i = 0; i < offset && base.hasNext(); ++i) {
            base.next();
        }
        return i;
    }
}

