/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueMultiBranchItem;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineFolder;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueScmSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline"})
public abstract class BlueMultiBranchPipeline
extends BluePipelineFolder
implements BlueMultiBranchItem {
    public static final String TOTAL_NUMBER_OF_BRANCHES = "totalNumberOfBranches";
    public static final String NUMBER_OF_FAILING_BRANCHES = "numberOfFailingBranches";
    public static final String NUMBER_OF_SUCCESSFUL_BRANCHES = "numberOfSuccessfulBranches";
    public static final String TOTAL_NUMBER_OF_PULL_REQUESTS = "totalNumberOfPullRequests";
    public static final String NUMBER_OF_FAILING_PULL_REQUESTS = "numberOfFailingPullRequests";
    public static final String NUMBER_OF_SUCCESSFUL_PULL_REQUESTS = "numberOfSuccessfulPullRequests";
    public static final String BRANCH_NAMES = "branchNames";
    public static final String SCM_SOURCE = "scmSource";

    @Override
    @Exported(name="totalNumberOfBranches")
    public abstract int getTotalNumberOfBranches();

    @Override
    @Exported(name="numberOfFailingBranches")
    public abstract int getNumberOfFailingBranches();

    @Override
    @Exported(name="numberOfSuccessfulBranches")
    public abstract int getNumberOfSuccessfulBranches();

    @Override
    @Exported(name="totalNumberOfPullRequests")
    public abstract int getTotalNumberOfPullRequests();

    @Override
    @Exported(name="numberOfFailingPullRequests")
    public abstract int getNumberOfFailingPullRequests();

    @Override
    @Exported(name="numberOfSuccessfulPullRequests")
    public abstract int getNumberOfSuccessfulPullRequests();

    @Override
    public abstract BluePipelineContainer getBranches();

    @Override
    @Exported(name="branchNames")
    public abstract Collection<String> getBranchNames();

    @Override
    public Iterable<String> getPipelineFolderNames() {
        return Collections.emptyList();
    }

    @Override
    public BlueRunContainer getRuns() {
        return new BlueRunContainer(){

            @Override
            public Link getLink() {
                return null;
            }

            @Override
            public BlueRun get(String name) {
                throw new ServiceException.NotFoundException(String.format("It is multi-branch project. No run with name: %s found.", name));
            }

            @Override
            public Iterator<BlueRun> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public BlueRun create(StaplerRequest request) {
                throw new ServiceException.NotImplementedException("This action is not supported");
            }
        };
    }

    @Exported(name="scmSource", inline=true)
    public abstract BlueScmSource getScmSource();
}

