/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.dev;

import hudson.PluginWrapper;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import io.jenkins.blueocean.BlueOceanUI;
import io.jenkins.blueocean.dev.RecursivePathWatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;

public class RunBundleWatches {
    public static final boolean isEnabled = new BlueOceanUI().isDevelopmentMode();
    static final List<BundleBuild> builds = new CopyOnWriteArrayList<BundleBuild>();
    static final long DEFAULT_BACK_OFF = 10000L;
    static final Pattern EXTENSIONS_TO_CAUSE_REBUILD = Pattern.compile(".*[.](js|jsx|ts|tsx|less|css|json|yaml)");
    static final RecursivePathWatcher.PathFilter PROJECT_PATH_FILTER = new RecursivePathWatcher.PathFilter(){
        private final Pattern allowedPaths = Pattern.compile("(src|less)/?.*");
        private final Pattern disallowedPaths = Pattern.compile("(src/test).*");

        @Override
        public boolean allows(Path path) {
            String unixPath = path.toString().replaceAll("\\+", "/");
            if (this.disallowedPaths.matcher(unixPath).matches()) {
                return false;
            }
            return this.allowedPaths.matcher(unixPath).matches();
        }
    };

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void startBundleWatches() {
        if (!isEnabled || Boolean.getBoolean("blueocean.features.BUNDLE_WATCH_SKIP")) {
            return;
        }
        System.out.println("Running in development mode, watching bundles...");
        boolean buildNumber = false;
        List plugins = Jenkins.get().pluginManager.getPlugins();
        for (PluginWrapper p : plugins) {
            try {
                final File projectDir = RunBundleWatches.findPluginWorkDir(new File(p.baseResourceURL.getPath()));
                if (projectDir == null) continue;
                final String path = projectDir.getCanonicalPath();
                final File packageFile = new File(projectDir, "package.json");
                final BundleBuild build = new BundleBuild();
                build.name = p.getShortName();
                System.out.println("---- Watching " + build.name + " in: " + path);
                JSONObject packageJson = JSONObject.fromObject((Object)FileUtils.readFileToString((File)packageFile));
                final String[] npmCommand = new String[]{"mvnbuild", null};
                if (packageJson.has("scripts")) {
                    JSONObject scripts = packageJson.getJSONObject("scripts");
                    if (scripts.has("mvnbuild:fast")) {
                        npmCommand[0] = "mvnbuild:fast";
                    }
                    if (scripts.has("watch")) {
                        npmCommand[1] = "watch";
                    }
                    if (scripts.has("bundle:watch")) {
                        npmCommand[1] = "bundle:watch";
                    }
                }
                if ("watch".equals(npmCommand[1]) && Boolean.getBoolean("blueocean.features.NATIVE_NPM_WATCH")) {
                    build.thread = new Thread(){

                        @Override
                        public void run() {
                            long backOff = 10000L;
                            while (true) {
                                try {
                                    HashMap<String, String> env = new HashMap<String, String>(System.getenv());
                                    String[] command = SystemUtils.IS_OS_WINDOWS ? new String[]{"cmd", "/C", "npm", "run", npmCommand[1]} : new String[]{"bash", "-c", "${0} ${1+\"$@\"}", "npm", "run", npmCommand[1]};
                                    ProcessBuilder pb = new ProcessBuilder(Arrays.asList(command)).redirectErrorStream(true).directory(projectDir);
                                    if (SystemUtils.IS_OS_WINDOWS) {
                                        pb.environment().put("Path", new File(projectDir, "node").getCanonicalPath() + ";" + (String)env.get("Path"));
                                    } else {
                                        pb.environment().put("PATH", new File(projectDir, "node").getCanonicalPath() + ":" + (String)env.get("PATH"));
                                    }
                                    final Process process = pb.start();
                                    build.destructor = new Destructor(){

                                        @Override
                                        public void destroy() {
                                            if (process.isAlive()) {
                                                try {
                                                    process.destroy();
                                                    process.destroyForcibly();
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            build.destructor = null;
                                        }
                                    };
                                    InputStream in = process.getInputStream();
                                    try (BufferedReader rdr = new BufferedReader(new InputStreamReader(in, "utf-8"));){
                                        String line;
                                        long startMillis = 0L;
                                        while ((line = rdr.readLine()) != null) {
                                            if (line.contains("Starting 'log-env'")) {
                                                startMillis = System.currentTimeMillis();
                                                build.buildCount.incrementAndGet();
                                                build.logLines.clear();
                                                System.out.println("---- Rebuilding: " + path);
                                            }
                                            build.logLines.add(new LogLine(System.currentTimeMillis(), line));
                                            if (line.contains("missing script: bundle:watch")) {
                                                System.out.println("---- Unable to find script 'bundle:watch' in: " + packageFile.getCanonicalPath());
                                                build.thread = null;
                                                return;
                                            }
                                            if (line.contains("Finished 'bundle'")) {
                                                long time;
                                                if (build.hasError) {
                                                    for (LogLine l : build.logLines) {
                                                        System.out.println(l.text);
                                                    }
                                                    build.hasError = false;
                                                }
                                                build.lastBuildTimeMillis = time = System.currentTimeMillis() - startMillis;
                                                build.buildCount.decrementAndGet();
                                                System.out.println("---- Rebuilt " + build.name + " in: " + time + "ms");
                                            }
                                            if (line.contains("Failed at the")) {
                                                System.out.println("---- Failed to build: " + build.name);
                                                build.buildCount.decrementAndGet();
                                                for (LogLine l : build.logLines) {
                                                    System.out.println(l.text);
                                                }
                                            }
                                            if (!line.contains("error") && !line.contains("Error") && !line.contains("ERROR")) continue;
                                            build.hasError = true;
                                        }
                                    }
                                }
                                catch (RuntimeException e) {
                                    e.printStackTrace();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                build.destructor = null;
                                try {
                                    Thread.sleep(backOff);
                                    backOff = (long)Math.floor(backOff * 2L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    backOff = 10000L;
                                    continue;
                                }
                                break;
                            }
                        }
                    };
                    build.thread.setDaemon(true);
                    build.thread.setName("Watching " + build.name + " for changes in: " + path);
                    build.thread.start();
                } else {
                    File watchDir = projectDir;
                    final Path watchPath = watchDir.toPath();
                    Thread fileWatchThread = new Thread(){
                        volatile Process buildProcess;

                        @Override
                        public void run() {
                            build.destructor = new Destructor(){

                                @Override
                                public void destroy() {
                                    if (buildProcess != null && buildProcess.isAlive()) {
                                        try {
                                            buildProcess.destroy();
                                            if (buildProcess != null && buildProcess.isAlive()) {
                                                buildProcess.destroyForcibly();
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    buildProcess = null;
                                    build.logLines.add(new LogLine("Process restarted."));
                                }
                            };
                            RecursivePathWatcher watcher = new RecursivePathWatcher(watchPath, PROJECT_PATH_FILTER);
                            watcher.start(new RecursivePathWatcher.PathEventHandler(){

                                @Override
                                public void accept(RecursivePathWatcher.Event event, final Path modified) {
                                    if (!EXTENSIONS_TO_CAUSE_REBUILD.matcher(modified.toString()).matches()) {
                                        return;
                                    }
                                    build.destructor.destroy();
                                    build.thread = new Thread(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         * Loose catch block
                                         */
                                        @Override
                                        public void run() {
                                            block25: {
                                                build.buildCount.incrementAndGet();
                                                long startMillis = System.currentTimeMillis();
                                                try {
                                                    HashMap<String, String> env = new HashMap<String, String>(System.getenv());
                                                    String[] command = SystemUtils.IS_OS_WINDOWS ? new String[]{"cmd", "/C", "npm", "run", npmCommand[0]} : new String[]{"bash", "-c", "${0} ${1+\"$@\"}", "npm", "run", npmCommand[0]};
                                                    System.out.println("---- Rebuilding: " + build.name + " due to change in: " + watchPath.relativize(modified));
                                                    ProcessBuilder pb = new ProcessBuilder(Arrays.asList(command)).redirectErrorStream(true).directory(projectDir);
                                                    if (SystemUtils.IS_OS_WINDOWS) {
                                                        pb.environment().put("Path", new File(projectDir, "node").getCanonicalPath() + ";" + (String)env.get("Path"));
                                                    } else {
                                                        pb.environment().put("PATH", new File(projectDir, "node").getCanonicalPath() + ":" + (String)env.get("PATH"));
                                                    }
                                                    buildProcess = pb.start();
                                                    InputStream in = buildProcess.getInputStream();
                                                    try (BufferedReader rdr = new BufferedReader(new InputStreamReader(in, "utf-8"));){
                                                        String line;
                                                        while ((line = rdr.readLine()) != null) {
                                                            build.logLines.add(new LogLine(System.currentTimeMillis(), line));
                                                            if (line.contains("missing script: mvnbuild")) {
                                                                build.hasError = true;
                                                            }
                                                            if (line.contains("Failed at the")) {
                                                                build.hasError = true;
                                                            }
                                                            if (!line.contains("error") && !line.contains("Error") && !line.contains("ERROR")) continue;
                                                            build.hasError = true;
                                                        }
                                                    }
                                                    if (buildProcess == null || buildProcess.waitFor() != 0) break block25;
                                                    build.lastBuildTimeMillis = System.currentTimeMillis() - startMillis;
                                                    System.out.println("---- Rebuilt " + build.name + " in: " + build.lastBuildTimeMillis + "ms");
                                                }
                                                catch (RuntimeException e) {
                                                    e.printStackTrace();
                                                    buildProcess = null;
                                                    build.buildCount.decrementAndGet();
                                                    if (build.hasError) {
                                                        for (LogLine l : build.logLines) {
                                                            System.out.println(l.text);
                                                        }
                                                        build.hasError = false;
                                                    }
                                                    build.logLines.clear();
                                                }
                                                catch (Exception e2) {
                                                    e2.printStackTrace();
                                                    buildProcess = null;
                                                    build.buildCount.decrementAndGet();
                                                    if (build.hasError) {
                                                        for (LogLine l : build.logLines) {
                                                            System.out.println(l.text);
                                                        }
                                                        build.hasError = false;
                                                    }
                                                    build.logLines.clear();
                                                    {
                                                        catch (Throwable throwable) {
                                                            buildProcess = null;
                                                            build.buildCount.decrementAndGet();
                                                            if (build.hasError) {
                                                                for (LogLine l : build.logLines) {
                                                                    System.out.println(l.text);
                                                                }
                                                                build.hasError = false;
                                                            }
                                                            build.logLines.clear();
                                                            throw throwable;
                                                        }
                                                    }
                                                }
                                            }
                                            buildProcess = null;
                                            build.buildCount.decrementAndGet();
                                            if (build.hasError) {
                                                for (LogLine l : build.logLines) {
                                                    System.out.println(l.text);
                                                }
                                                build.hasError = false;
                                            }
                                            build.logLines.clear();
                                        }
                                    };
                                    build.thread.setDaemon(true);
                                    build.thread.setName("Building: " + path);
                                    build.thread.start();
                                }
                            });
                        }
                    };
                    fileWatchThread.setDaemon(true);
                    fileWatchThread.setName("Watching " + build.name + " for changes in: " + path);
                    fileWatchThread.start();
                }
                builds.add(build);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static File findPluginWorkDir(File dir) {
        if (dir == null) {
            return null;
        }
        if (new File(dir, "pom.xml").exists() && new File(dir, "package.json").exists()) {
            return dir;
        }
        return RunBundleWatches.findPluginWorkDir(dir.getParentFile());
    }

    public static void waitForScriptBuilds() {
        if (!isEnabled) {
            return;
        }
        for (BundleBuild build : builds) {
            while (build.isBuilding()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class BundleBuild {
        final List<LogLine> logLines = new CopyOnWriteArrayList<LogLine>();
        String name;
        Thread thread;
        final AtomicInteger buildCount = new AtomicInteger(0);
        volatile Destructor destructor;
        volatile long lastBuildTimeMillis;
        boolean hasError = false;

        BundleBuild() {
        }

        boolean isBuilding() {
            return this.buildCount.get() > 0;
        }
    }

    private static interface Destructor {
        public void destroy();
    }

    static class LogLine {
        final long time;
        final String text;

        LogLine(String text) {
            this(System.currentTimeMillis(), text);
        }

        LogLine(long time, String text) {
            this.time = time;
            this.text = text;
        }
    }
}

