'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DownloadLink = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('./Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var object = _react.PropTypes.object,
    string = _react.PropTypes.string;

var DownloadLink = function (_Component) {
    _inherits(DownloadLink, _Component);

    function DownloadLink() {
        _classCallCheck(this, DownloadLink);

        return _possibleConstructorReturn(this, (DownloadLink.__proto__ || Object.getPrototypeOf(DownloadLink)).apply(this, arguments));
    }

    _createClass(DownloadLink, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                style = _props.style,
                fileData = _props.fileData,
                _props$title = _props.title,
                title = _props$title === undefined ? 'Download the log' : _props$title;

            if (!fileData) return null;
            var contents = fileData.contents,
                mime = fileData.mime,
                filename = fileData.filename;

            var blob = new Blob([contents], { type: mime });
            var url = URL.createObjectURL(blob);

            return _react2.default.createElement(
                'a',
                {
                    download: filename,
                    href: url,
                    title: title
                },
                _react2.default.createElement(_Icon.Icon, { style: style, icon: 'file_download' })
            );
        }
    }]);

    return DownloadLink;
}(_react.Component);

DownloadLink.propTypes = {
    fileData: object,
    style: object,
    title: string
};
exports.DownloadLink = DownloadLink;
//# sourceMappingURL=DownloadLink.js.map
