'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.List = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Utils = require('../Utils');

var _Utils2 = _interopRequireDefault(_Utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Checks whether the supplied child is scrolled above or below the parent's top/bottom edges.
 * @param parent
 * @param child
 * @returns {{above: boolean, below: boolean}}
 */
function isScrolledAboveOrBelow(parent, child) {
    var result = {
        above: false,
        below: false
    };

    var childRect = child.getBoundingClientRect();
    var parentRect = parent.getBoundingClientRect();

    if (childRect.top < parentRect.top) {
        result.above = true;
    } else if (childRect.bottom > parentRect.bottom) {
        result.below = true;
    }

    return result;
}

/**
 * Control that displays a List of items and allows for selection.
 * Functions like a list of radio buttons from a keyboard accessibility standpoint.
 * By default it uses a simple renderer that converts each object to a string.
 * A custom renderer can be provided as a single React child to the element, e.g.
 *      <List data={data}>
 *          <MyRenderer />
 *      </List>
 *
 *      function MyRenderer(props) {
 *          return (
 *              <div>{props.listIndex} {props.listItem}</div>
 *          );
 *      }
 * Custom render will receive three props: listIndex, listItem and labelFunction (from parent)
 * A keyFunction is encouraged to generate a React key for each row. Default is to use listIndex.
 *
 * @property {string} className additional "class" to add to outermost element (alongside "List")
 * @property {array} children React children
 * @property {Object} style React style object to be applied to outer element.
 * @property {array} [data] data to render in the list.
 * @property {Function} [labelFunction] converts each object to a string in the default renderer.
 * @property {Function} [keyFunction]
 * @property {boolean} [defaultStyles] set "false" to remove all default styling from the List.
 * @property {Object} [defaultSelection] item to select in the list by default
 * @property {Function} [onItemSelect] callback when an item is selected, receiving listIndex and listItem.
 */

var List = exports.List = function (_React$Component) {
    _inherits(List, _React$Component);

    function List(props) {
        _classCallCheck(this, List);

        var _this = _possibleConstructorReturn(this, (List.__proto__ || Object.getPrototypeOf(List)).call(this, props));

        _this.state = {};

        _this.groupId = _Utils2.default.randomId('List');
        return _this;
    }

    _createClass(List, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            var selectedItem = this.state.selectedItem;
            var data = nextProps.data;

            // if the selectedItem is not found in new data, discard it

            if (selectedItem && (!data || data.indexOf(selectedItem) === -1)) {
                this.setState({
                    selectedItem: undefined
                });
            }

            this._defaultSelection(nextProps);
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this._defaultSelection(this.props);
        }
    }, {
        key: '_storeSelfNode',
        value: function _storeSelfNode(node) {
            this.selfNode = node;
        }
    }, {
        key: '_defaultSelection',
        value: function _defaultSelection(nextProps) {
            if (!this.state.selectedItem && nextProps.defaultSelection) {
                this.setState({
                    selectedItem: nextProps.defaultSelection
                });
            }
        }
    }, {
        key: '_onChangeSelection',
        value: function _onChangeSelection(event, index, item) {
            // Firefox and Safari don't apply focus after "change" so force it
            if (document.activeElement !== event.currentTarget && event.currentTarget instanceof HTMLElement) {
                event.currentTarget.focus();
            }

            this.setState({
                selectedItem: item
            });

            if (this.props.onItemSelect) {
                this.props.onItemSelect(index, item);
            }
        }
    }, {
        key: '_scrollFocusedItemIntoView',
        value: function _scrollFocusedItemIntoView(event) {
            if (event.currentTarget instanceof Element && event.currentTarget.parentElement) {
                // get the .List-Item associated w/ the focused input[type="radio"]
                var parentElement = event.currentTarget.parentElement;
                var items = parentElement.getElementsByClassName('List-Item');
                this._scrollNodeIntoView(items[0]);
            }
        }
    }, {
        key: '_scrollNodeIntoView',
        value: function _scrollNodeIntoView(targetNode) {
            var position = isScrolledAboveOrBelow(this.selfNode, targetNode);

            if (position.above || position.below) {
                targetNode.scrollIntoView(position.above);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                children = _props.children,
                data = _props.data,
                disabled = _props.disabled,
                keyFunction = _props.keyFunction,
                labelFunction = _props.labelFunction;


            var childCount = _react2.default.Children.count(children);

            var childTemplate = void 0;

            if (childCount === 0) {
                childTemplate = _react2.default.createElement(DefaultRenderer, null);
            } else if (childCount === 1) {
                childTemplate = _react2.default.Children.only(children);
            } else {
                console.error('\'children\' supplied to List must be zero or one elements');
                return null;
            }

            var listClass = this.props.className || '';
            var selectedClass = this.state.selectedItem ? 'List-selected' : '';
            var defaultClass = this.props.defaultStyles ? 'u-default-list-container' : '';
            var disabledClass = disabled ? 'disabled' : '';

            return _react2.default.createElement(
                'div',
                {
                    ref: function ref(node) {
                        return _this2._storeSelfNode(node);
                    },
                    className: 'List ' + selectedClass + ' ' + listClass + ' ' + defaultClass + ' ' + disabledClass,
                    style: this.props.style
                },
                data && data.map(function (item, index) {
                    var itemSelectedClass = item === _this2.state.selectedItem ? 'List-Item-selected' : '';
                    var keyValue = keyFunction ? keyFunction(item) : index;

                    return _react2.default.createElement(
                        'label',
                        { className: 'List-Row', key: keyValue },
                        _react2.default.createElement('input', {
                            type: 'radio',
                            name: _this2.groupId,
                            className: 'List-Radio cloak',
                            onChange: function onChange(event) {
                                return _this2._onChangeSelection(event, index, item);
                            },
                            onFocus: function onFocus(event) {
                                return _this2._scrollFocusedItemIntoView(event);
                            },
                            disabled: disabled,
                            checked: !!itemSelectedClass
                        }),
                        _react2.default.createElement(
                            'div',
                            { className: 'List-Item ' + itemSelectedClass },
                            _react2.default.cloneElement(childTemplate, {
                                listIndex: index,
                                listItem: item,
                                labelFunction: labelFunction
                            })
                        )
                    );
                })
            );
        }
    }, {
        key: 'selectedIndex',
        get: function get() {
            var selectedItem = this.state.selectedItem;
            var data = this.props.data;


            return selectedItem && data ? data.indexOf(selectedItem) : -1;
        }
    }, {
        key: 'selectedItem',
        get: function get() {
            return this.state.selectedItem;
        }
    }]);

    return List;
}(_react2.default.Component);

List.defaultProps = {
    style: {},
    defaultStyles: true,
    labelFunction: itemToLabel
};


List.propTypes = {
    className: _react.PropTypes.string,
    children: _react.PropTypes.element,
    style: _react.PropTypes.object,
    data: _react.PropTypes.array,
    disabled: _react.PropTypes.bool,
    labelFunction: _react.PropTypes.func,
    keyFunction: _react.PropTypes.func,
    defaultStyles: _react.PropTypes.bool,
    defaultSelection: _react.PropTypes.any,
    onItemSelect: _react.PropTypes.func
};

function itemToLabel(item) {
    if (typeof item === 'string') {
        return item;
    } else if (item.toString) {
        return item.toString();
    }

    return '';
}

function DefaultRenderer(props) {
    return _react2.default.createElement(
        'div',
        { className: 'List-DefaultRenderer' },
        _react2.default.createElement(
            'span',
            { className: 'List-DefaultRenderer-text' },
            props.labelFunction(props.listItem)
        )
    );
}

DefaultRenderer.propTypes = {
    listIndex: _react.PropTypes.number,
    listItem: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.object]),
    labelFunction: _react.PropTypes.func
};
//# sourceMappingURL=List.js.map
