'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('LiveStatusIndicator', module).add('10s, start now', scenario1).add('60s, started 30s ago', scenario2).add('already exceeded estimate', scenario3).add('no estimate available', scenario4).add('no bg, large', scenario5);

function scenario1() {
    var started = (0, _moment2.default)().toISOString();
    return _react2.default.createElement(_components.LiveStatusIndicator, { result: 'running', startTime: started, estimatedDuration: 10000 });
}

function scenario2() {
    var started = (0, _moment2.default)().subtract(30, 'seconds').toISOString();
    return _react2.default.createElement(_components.LiveStatusIndicator, { result: 'running', startTime: started, estimatedDuration: 1000 * 60 });
}

function scenario3() {
    var started = (0, _moment2.default)().subtract(1, 'minute').toISOString();
    return _react2.default.createElement(_components.LiveStatusIndicator, { result: 'running', startTime: started, estimatedDuration: 1000 * 30 });
}

function scenario4() {
    var started = (0, _moment2.default)().subtract(1, 'minute').toISOString();
    return _react2.default.createElement(_components.LiveStatusIndicator, { result: 'running', startTime: started, estimatedDuration: -1 });
}

function scenario5() {
    var started = (0, _moment2.default)().toISOString();
    var styleContainer = {
        display: 'flex',
        justifyContent: 'space-around',
        margin: '20px'
    };
    var styleIndicator = {
        backgroundColor: '#0071C4',
        border: '1px solid black'
    };
    return _react2.default.createElement(
        'div',
        { style: styleContainer },
        _react2.default.createElement(
            'span',
            { style: styleIndicator, className: 'inverse' },
            _react2.default.createElement(_components.LiveStatusIndicator, { result: 'running', noBackground: true,
                width: '100px', height: '100px'
            })
        ),
        _react2.default.createElement(
            'span',
            { style: styleIndicator },
            _react2.default.createElement(_components.LiveStatusIndicator, { result: 'success', noBackground: true,
                startTime: started, estimatedDuration: 10000,
                width: '100px', height: '100px'
            })
        )
    );
}
//# sourceMappingURL=liveStatusIndicatorStories.js.map
