'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.IconButton = IconButton;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('../components/Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * button element with icon.
 * Use "iconName" for standard material-ui icons
 * Use "children" for custom icon. Provide element (e.g. raw svg), or React component
 *
 * @param {object} [props.children] - React element or custom component to render as icon
 * @param {string} [props.className] - custom class name for outer element
 * @param {object} [props.style] - custom style object
 * @param {string} [props.label] - button text
 * @param {string} [props.iconName] - name of material-ui icon to display
 * @param {number} [props.iconSize] - width/height of icon
 * @param {string} [props.iconFill] - color code to apply as fill
 * @param {function} [props.onClick] - onclick callback function
 * @constructor
 */
function IconButton(props) {
    function _onClick() {
        if (onClick) {
            onClick();
        }
    }

    var children = props.children,
        className = props.className,
        style = props.style,
        label = props.label,
        iconName = props.iconName,
        iconSize = props.iconSize,
        iconFill = props.iconFill,
        onClick = props.onClick;


    var icon = null;

    if (iconName) {
        icon = _react2.default.createElement(_Icon.Icon, { icon: iconName, size: iconSize ? iconSize : 20, color: iconFill });
    } else if (children) {
        // pass down props of interest to the child so it can react
        var iconProps = {
            width: iconSize,
            height: iconSize,
            size: iconSize,
            fill: iconFill
        };

        icon = _react2.default.Children.map(children, function (child) {
            return _react2.default.cloneElement(child, iconProps);
        });
    }

    var customClass = className || '';
    var iconNameClass = iconName ? 'u-icon-' + iconName : '';
    var materialClass = iconName ? 'u-material-icon' : '';
    var spacingClass = label && icon ? 'u-inner-margin' : '';

    return _react2.default.createElement(
        'button',
        { className: 'IconButton ' + customClass + ' ' + iconNameClass + ' ' + materialClass + ' ' + spacingClass, style: style, onClick: _onClick },
        _react2.default.createElement(
            'div',
            { className: 'IconButton-wrapper' },
            icon && _react2.default.createElement(
                'span',
                { className: 'IconButton-icon' },
                icon
            ),
            label && _react2.default.createElement(
                'span',
                { className: 'IconButton-text' },
                label
            )
        )
    );
}

IconButton.propTypes = {
    children: _react.PropTypes.element,
    className: _react.PropTypes.string,
    style: _react.PropTypes.object,
    label: _react.PropTypes.string,
    iconName: _react.PropTypes.string,
    iconSize: _react.PropTypes.number,
    iconFill: _react.PropTypes.string,
    onClick: _react.PropTypes.func
};
//# sourceMappingURL=IconButton.js.map
