'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReadableDate = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

require('moment/min/locales.min');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }
// needs to be loaded since the moment lib will use require which in run time will fail


/**
 * Displays a date in moment's "fromNow" format, e.g. "2 hours ago", "5 days ago" etc
 * Also displays the original date on hover.
 * Expects "date" to be passed in as ISO-8601 string with time zone info.
 * If time zone is omitted, then UTC is assumed.
 */
var ReadableDate = exports.ReadableDate = function (_Component) {
    _inherits(ReadableDate, _Component);

    function ReadableDate(props) {
        _classCallCheck(this, ReadableDate);

        // When updating, average 1s period, with jitter to spread out the work
        var _this = _possibleConstructorReturn(this, (ReadableDate.__proto__ || Object.getPrototypeOf(ReadableDate)).call(this, props));

        _this.timerPeriodMillis = 750 + Math.ceil(Math.random() * 500);
        _this.timer = 0;
        _this.state = { date: null };
        return _this;
    }

    _createClass(ReadableDate, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.handleProps(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this.handleProps(nextProps);
        }
    }, {
        key: 'handleProps',
        value: function handleProps(props) {
            var _this2 = this;

            var _props$locale = props.locale,
                locale = _props$locale === undefined ? 'en' : _props$locale;


            if (this.timer) {
                clearInterval(this.timer);
                this.timer = 0;
            }

            var date = null;

            if (props.date) {
                _moment2.default.locale(locale);
                // enforce a ISO-8601 date and try to set proper timezone
                var aMoment = (0, _moment2.default)(props.date, _moment2.default.ISO_8601).utcOffset(props.date);

                if (aMoment.isValid()) {
                    // a moment has no name.
                    date = aMoment;
                }
            }

            if (date && props.liveUpdate) {
                this.timer = setInterval(function () {
                    _this2.forceUpdate();
                }, this.timerPeriodMillis);
            }

            this.setState({ date: date });
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.timer) {
                clearInterval(this.timer);
                this.timer = 0;
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var date = this.state.date;
            var _props = this.props,
                _props$shortFormat = _props.shortFormat,
                shortFormat = _props$shortFormat === undefined ? 'MMM DD h:mma Z' : _props$shortFormat,
                _props$longFormat = _props.longFormat,
                longFormat = _props$longFormat === undefined ? 'MMM DD YYYY h:mma Z' : _props$longFormat;


            if (date) {
                var now = (0, _moment2.default)().utc();

                // only show the year if from different year
                var tooltip = date.year() !== now.year() ? date.format(longFormat) : date.format(shortFormat);

                tooltip = tooltip.replace('+00:00', 'UTC');

                return _react2.default.createElement(
                    'time',
                    { dateTime: this.props.date, title: tooltip },
                    date.fromNow()
                );
            }

            return _react2.default.createElement(
                'span',
                null,
                '-'
            );
        }
    }]);

    return ReadableDate;
}(_react.Component);

ReadableDate.propTypes = {
    date: _react.PropTypes.string,
    liveUpdate: _react.PropTypes.bool,
    longFormat: _react.PropTypes.string,
    shortFormat: _react.PropTypes.string
};
//# sourceMappingURL=ReadableDate.js.map
