'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TimeDuration = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

require('moment-duration-format');

require('moment/min/locales.min');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// So moment is properly initialized:


/**
 * Displays a millisecond duration as text in moment-duration-format's "humanize()" format,
 * e.g. "a few seconds", "2 hours", etc.
 * Set liveUpdate=true to tick the duration up as time elapses.
 *
 * Properties:
 * "millis": number or string.
 * "liveUpdate": boolean
 */
var TimeDuration = exports.TimeDuration = function (_Component) {
    _inherits(TimeDuration, _Component);

    function TimeDuration(props) {
        _classCallCheck(this, TimeDuration);

        // track how much time has elapsed since live updating tracking started
        var _this = _possibleConstructorReturn(this, (TimeDuration.__proto__ || Object.getPrototypeOf(TimeDuration)).call(this, props));

        _this.state = { elapsed: 0 };
        var _this$props$updatePer = _this.props.updatePeriod,
            updatePeriod = _this$props$updatePer === undefined ? 5000 : _this$props$updatePer;

        _this.timerPeriodMillis = typeof updatePeriod !== 'number' || isNaN(updatePeriod) ? 5000 : updatePeriod;
        _this.clearIntervalId = 0;
        return _this;
    }

    _createClass(TimeDuration, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this._handleProps(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this._handleProps(nextProps);
        }
    }, {
        key: '_handleProps',
        value: function _handleProps(props) {
            var _this2 = this;

            if (this.clearIntervalId) {
                clearInterval(this.clearIntervalId);
                this.clearIntervalId = 0;
            }

            if (props.millis >= 0 && props.liveUpdate) {
                this.clearIntervalId = setInterval(function () {
                    _this2._updateTime();
                }, this.timerPeriodMillis);
            }

            // if live update is disabled, we no longer need to track elapsed time
            if (!props.liveUpdate) {
                this.setState({
                    elapsed: 0
                });
            }
        }
    }, {
        key: '_updateTime',
        value: function _updateTime() {
            var elapsed = this.state.elapsed + this.timerPeriodMillis;
            this.setState({
                elapsed: elapsed
            });
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.clearIntervalId) {
                clearInterval(this.clearIntervalId);
                this.clearIntervalId = 0;
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var millis = parseInt(this.props.millis) + this.state.elapsed;

            if (!isNaN(millis)) {
                if (millis < 1000) {
                    return _react2.default.createElement(
                        'span',
                        null,
                        '<1s'
                    );
                }

                var _props = this.props,
                    _props$locale = _props.locale,
                    _locale = _props$locale === undefined ? 'en' : _props$locale,
                    t = _props.t;

                var duration = TimeDuration.format(millis, t, _locale);

                return _react2.default.createElement(
                    'span',
                    null,
                    duration
                );
            }

            return _react2.default.createElement(
                'span',
                null,
                '-'
            );
        }
    }], [{
        key: 'format',
        value: function format(value, t, locale) {
            var displayFormat = t('common.date.duration.display.format', { defaultValue: 'd[d] h[h] m[m] s[s]' });

            _moment2.default.locale(locale);

            if (!isNaN(value)) {
                if (value < 1000) {
                    return '<1s';
                }
                return _moment2.default.duration(value).format(displayFormat);
            } else {
                return '-';
            }
        }
    }]);

    return TimeDuration;
}(_react.Component);

TimeDuration.propTypes = {
    millis: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string]),
    updatePeriod: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string]),
    liveUpdate: _react.PropTypes.bool,
    locale: _react.PropTypes.string,
    t: _react.PropTypes.func
};
//# sourceMappingURL=TimeDuration.js.map
