'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Toaster = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsCssTransitionGroup = require('react-addons-css-transition-group');

var _reactAddonsCssTransitionGroup2 = _interopRequireDefault(_reactAddonsCssTransitionGroup);

var _Toast = require('./Toast');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Created by cmeyers on 8/17/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


/**
 * Toaster is a container for Toast instances displayed based on supplied 'toasts' prop.
 *
 * Supported props:
 * toasts - array of toast objects
 * {
 *     id: unique identifier
 *     text: string, message text to display
 *     action: string, text for action link
 *     onActionClick: function, callback to invoke when action link is clicked
 *     onDismiss: function, callback to invoke when toast is dismissed (immediately, or after timeout)
 *     dismissDelay: number, duration in millis after which to auto-dismiss this Toast
 * }
 * dismissDelay - number, default duration in millis after which to hide a Toast
 */
var Toaster = exports.Toaster = function (_Component) {
    _inherits(Toaster, _Component);

    function Toaster() {
        _classCallCheck(this, Toaster);

        var _this = _possibleConstructorReturn(this, (Toaster.__proto__ || Object.getPrototypeOf(Toaster)).call(this));

        _this.activeToasts = {};
        return _this;
    }

    _createClass(Toaster, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this._initialize(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this._initialize(nextProps);
        }
    }, {
        key: '_initialize',
        value: function _initialize(props) {
            var _this2 = this;

            if (!props.toasts) {
                return;
            }

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                var _loop = function _loop() {
                    var toast = _step.value;

                    var dismissDelay = toast.dismissDelay || props.dismissDelay || 5000;

                    // if we aren't already tracking the toast, add an auto-dismiss handler and store the timeoutId
                    if (!_this2.activeToasts[toast.id]) {
                        var timeoutId = setTimeout(function () {
                            return _this2._onDismiss(toast);
                        }, dismissDelay);
                        _this2.activeToasts[toast.id] = timeoutId;
                    }
                };

                for (var _iterator = props.toasts[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    _loop();
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    }, {
        key: '_onActionClick',
        value: function _onActionClick(toast) {
            this._cleanup(toast);

            if (toast.onActionClick) {
                toast.onActionClick();
            }

            if (this.props.onActionClick) {
                this.props.onActionClick(toast);
            }
        }
    }, {
        key: '_onDismiss',
        value: function _onDismiss(toast) {
            this._cleanup(toast);

            if (toast.onDismiss) {
                toast.onDismiss();
            }

            if (this.props.onDismiss) {
                this.props.onDismiss(toast);
            }
        }
    }, {
        key: '_cleanup',
        value: function _cleanup(toast) {
            var timeoutId = this.activeToasts[toast.id];

            if (timeoutId) {
                clearTimeout(timeoutId);
                delete this.activeToasts[toast.id];
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            return _react2.default.createElement(
                'div',
                { className: 'toaster' },
                _react2.default.createElement(
                    _reactAddonsCssTransitionGroup2.default,
                    {
                        transitionName: 'toast',
                        transitionAppear: true,
                        transitionAppearTimeout: 300,
                        transitionEnterTimeout: 300,
                        transitionLeaveTimeout: 300
                    },
                    this.props.toasts.map(function (toast) {
                        if (!toast.id) {
                            // eslint-disable-next-line no-console
                            console.warn("toast cannot be added without 'id' property", toast);
                            return null;
                        }

                        var key = toast.id;

                        return _react2.default.createElement(_Toast.Toast, {
                            key: key,
                            caption: toast.caption,
                            text: toast.text,
                            style: toast.style,
                            action: toast.action,
                            onActionClick: function onActionClick() {
                                return _this3._onActionClick(toast);
                            },
                            onDismiss: function onDismiss() {
                                return _this3._onDismiss(toast);
                            }
                        });
                    })
                )
            );
        }
    }]);

    return Toaster;
}(_react.Component);

Toaster.propTypes = {
    toasts: _react.PropTypes.array,
    onActionClick: _react.PropTypes.func,
    onDismiss: _react.PropTypes.func,
    dismissDelay: _react.PropTypes.number
};

Toaster.defaultProps = {
    toasts: []
};
//# sourceMappingURL=Toaster.js.map
