'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Checkbox = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('../Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Checkbox = exports.Checkbox = function (_Component) {
    _inherits(Checkbox, _Component);

    function Checkbox() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, Checkbox);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Checkbox.__proto__ || Object.getPrototypeOf(Checkbox)).call.apply(_ref, [this].concat(args))), _this), _this._toggle = function (e) {
            if (e.target instanceof HTMLInputElement) {
                var _checked = e.target.checked;

                _this.setState({
                    checked: _checked
                });

                if (_this.props.onToggle) {
                    _this.props.onToggle(_checked);
                }
            }
        }, _this._clicked = function (e) {
            if (e.currentTarget instanceof HTMLInputElement) {
                e.currentTarget.blur();
            }
        }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(Checkbox, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this._updateState(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(props) {
            this._updateState(props);
        }
    }, {
        key: '_updateState',
        value: function _updateState(props) {
            this.setState({
                checked: props.checked
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var extraClass = this.props.className || '';

            return _react2.default.createElement(
                'div',
                { className: 'Checkbox ' + extraClass },
                _react2.default.createElement(
                    'label',
                    { className: 'Checkbox-wrapper', onClick: function onClick(event) {
                            return event.stopPropagation();
                        } },
                    _react2.default.createElement('input', {
                        type: 'checkbox',
                        name: this.props.name,
                        onChange: this._toggle,
                        checked: this.state.checked,
                        disabled: this.props.disabled,
                        onClick: this._clicked
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'Checkbox-indicator' },
                        !this.props.children ? _react2.default.createElement(_Icon.Icon, { icon: 'NavigationCheck', size: 20 }) : this.props.children
                    ),
                    this.props.label && _react2.default.createElement(
                        'div',
                        { className: 'Checkbox-text' },
                        this.props.label
                    )
                )
            );
        }
    }, {
        key: 'checked',
        get: function get() {
            return this.state.checked;
        }
    }]);

    return Checkbox;
}(_react.Component);

Checkbox.defaultProps = {
    className: '',
    checked: false
};


Checkbox.propTypes = {
    children: _react.PropTypes.node,
    className: _react.PropTypes.string,
    label: _react.PropTypes.string,
    name: _react.PropTypes.string,
    checked: _react.PropTypes.bool,
    disabled: _react.PropTypes.bool,
    onToggle: _react.PropTypes.func
};
//# sourceMappingURL=Checkbox.js.map
