'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LiveStatusIndicator = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _StatusIndicator = require('./StatusIndicator');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * LiveStatusIndicator is a wrapper around StatusIndicator that allows
 * for an in-progress status to self update.
 *
 * Properties:
 * "estimatedDuration": time in millis over which the progress indicator will update.
 * "startTime": ISO-8601 string indicating when tracking of progress begins from.
 */
var LiveStatusIndicator = exports.LiveStatusIndicator = function (_Component) {
    _inherits(LiveStatusIndicator, _Component);

    function LiveStatusIndicator(props) {
        _classCallCheck(this, LiveStatusIndicator);

        var _this = _possibleConstructorReturn(this, (LiveStatusIndicator.__proto__ || Object.getPrototypeOf(LiveStatusIndicator)).call(this, props));

        _this.state = {
            // percentage of progress currently drawn in UI
            percentage: 0
        };

        // percentage of progress based on last check
        _this.percentage = 0;
        _this.startTime = null;
        _this.clearIntervalId = 0;
        _this.animationFrameId = 0;
        return _this;
    }

    _createClass(LiveStatusIndicator, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this._initializeProgress(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this._initializeProgress(nextProps);
        }
    }, {
        key: '_initializeProgress',
        value: function _initializeProgress(props) {
            var _this2 = this;

            // ensure we don't leak setInterval by proactively clearing it
            // the code will restart the interval if needed
            this._stopProgressUpdates();

            if (!props) {
                return;
            }

            var cleanResult = (0, _StatusIndicator.decodeResultValue)(props.result);
            // TODO: pull in validResultValues from StatusIndicator
            var isRunning = cleanResult === 'running';

            if (isRunning) {
                this.startTime = (0, _moment2.default)(props.startTime, _moment2.default.ISO_8601).utcOffset(props.startTime);

                // update the progress each second
                this.clearIntervalId = setInterval(function () {
                    _this2._updateProgress(_this2.props);
                }, 1000);

                this._updateProgress(props);
            }
        }
    }, {
        key: '_updateProgress',
        value: function _updateProgress(props) {
            var now = (0, _moment2.default)();
            var elapsed = now.diff(this.startTime);
            var estimatedDuration = props.estimatedDuration;

            if (elapsed > 0 && estimatedDuration > 0) {
                this.percentage = Math.floor(elapsed / estimatedDuration * 100);
            } else {
                // if both aren't available, set to 'indeterminate' state
                this.percentage = 101;
            }

            if (0 <= this.percentage && this.percentage <= 100) {
                this._drawProgress();
            } else {
                // set the percentage > 100 so the indeterminate spinner will display
                // no more progress updates are required
                this.setState({
                    percentage: 101
                });

                this._stopProgressUpdates();
            }
        }
    }, {
        key: '_drawProgress',
        value: function _drawProgress() {
            var _this3 = this;

            if (this.state.percentage <= this.percentage) {
                // increment the progress to trigger a rerender
                // then request another draw on next frame
                var newPercent = this.state.percentage + 1;
                this.setState({
                    percentage: newPercent
                });

                this.animationFrameId = requestAnimationFrame(function () {
                    _this3._drawProgress();
                });
            }
        }
    }, {
        key: '_stopProgressUpdates',
        value: function _stopProgressUpdates() {
            clearInterval(this.clearIntervalId);
            this.clearIntervalId = 0;
            cancelAnimationFrame(this.animationFrameId);
            this.animationFrameId = 0;
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            this._stopProgressUpdates();
        }
    }, {
        key: 'render',
        value: function render() {
            return _react2.default.createElement(_StatusIndicator.StatusIndicator, _extends({}, this.props, { percentage: this.state.percentage }));
        }
    }]);

    return LiveStatusIndicator;
}(_react.Component);

LiveStatusIndicator.propTypes = {
    result: _react.PropTypes.string,
    percentage: _react.PropTypes.number,
    width: _react.PropTypes.string,
    height: _react.PropTypes.string,
    noBackground: _react.PropTypes.bool,
    startTime: _react.PropTypes.string,
    estimatedDuration: _react.PropTypes.number
};
//# sourceMappingURL=LiveStatusIndicator.js.map
