'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SvgStatus = exports.SvgSpinner = exports.StatusIndicator = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.decodeResultValue = decodeResultValue;
exports.getGroupForResult = getGroupForResult;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SvgSpinner = require('./SvgSpinner');

var _SvgSpinner2 = _interopRequireDefault(_SvgSpinner);

var _SvgStatus = require('./SvgStatus');

var _SvgStatus2 = _interopRequireDefault(_SvgStatus);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validResultValues = {
    // Mostly from io/jenkins/blueocean/rest/model/BlueRun.java
    success: 'success',
    failure: 'failure',
    running: 'running',
    queued: 'queued',
    paused: 'paused',
    unstable: 'unstable',
    aborted: 'aborted',
    not_built: 'not_built', // May be pending, or job was ended before this point
    skipped: 'skipped', // excluded via pipeline "when" clause
    unknown: 'unknown' // bad data or client code needs updating for new values
};

// Enum type from const validResultValues


// Clean up result value, or return "invalid" value
function decodeResultValue(resultMaybe) {
    if (resultMaybe) {
        var lcResult = String(resultMaybe).toLowerCase();
        if (validResultValues.hasOwnProperty(lcResult)) {
            return validResultValues[lcResult];
        }
    }
    return 'unknown';
}

// Returns the correct <g> element for the result / progress percent.
// NB: This is also used by the PipelineGraph
function getGroupForResult(result, percentage, radius) {
    if (usesSvgSpinner(result)) {
        return _react2.default.createElement(_SvgSpinner2.default, { radius: radius, result: result, percentage: percentage });
    } else {
        return _react2.default.createElement(_SvgStatus2.default, { radius: radius, result: result });
    }
}

// indicates whether result should use the Spinner (or Status)
function usesSvgSpinner(result) {
    switch (result) {
        case 'running':
        case 'queued':
        case 'not_built':
        case 'skipped':
            return true;
        default:
            return false;
    }
}

var StatusIndicator = function (_Component) {
    _inherits(StatusIndicator, _Component);

    function StatusIndicator() {
        _classCallCheck(this, StatusIndicator);

        return _possibleConstructorReturn(this, (StatusIndicator.__proto__ || Object.getPrototypeOf(StatusIndicator)).apply(this, arguments));
    }

    _createClass(StatusIndicator, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                result = _props.result,
                percentage = _props.percentage,
                _props$width = _props.width,
                width = _props$width === undefined ? '24px' : _props$width,
                _props$height = _props.height,
                height = _props$height === undefined ? '24px' : _props$height,
                noBackground = _props.noBackground;


            var groupClasses = ['svgResultStatus', noBackground ? 'no-background' : null];

            var radius = 12; // px.
            var resultClean = decodeResultValue(result);

            var translate = 'translate(' + radius + ' ' + radius + ')';
            // SvgStatus needs to be scaled up to fill the available space when no bg is used
            var scale = noBackground && !usesSvgSpinner(resultClean) ? 'scale(2,2)' : null;

            var transforms = [translate, scale];

            return _react2.default.createElement(
                'svg',
                {
                    className: groupClasses.join(' '),
                    xmlns: 'http://www.w3.org/2000/svg',
                    viewBox: '0 0 ' + 2 * radius + ' ' + 2 * radius,
                    width: width,
                    height: height,
                    focusable: false
                },
                _react2.default.createElement(
                    'title',
                    null,
                    resultClean
                ),
                _react2.default.createElement(
                    'g',
                    { transform: transforms.join(' ') },
                    getGroupForResult(resultClean, percentage, radius)
                )
            );
        }
    }]);

    return StatusIndicator;
}(_react.Component);

StatusIndicator.validResultValues = validResultValues;


StatusIndicator.propTypes = {
    result: _react.PropTypes.string,
    percentage: _react.PropTypes.number,
    width: _react.PropTypes.string,
    height: _react.PropTypes.string,
    noBackground: _react.PropTypes.bool
};

exports.StatusIndicator = StatusIndicator;
exports.SvgSpinner = _SvgSpinner2.default;
exports.SvgStatus = _SvgStatus2.default;
//# sourceMappingURL=StatusIndicator.js.map
