'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WeatherIcon = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function getStatusClassName(successpc) {
    if (successpc < 21) return 'weather-storm';
    if (successpc < 41) return 'weather-raining';
    if (successpc < 61) return 'weather-cloudy';
    if (successpc < 81) return 'weather-partially-sunny';
    return 'weather-sunny';
}

var WeatherIcon = exports.WeatherIcon = function (_Component) {
    _inherits(WeatherIcon, _Component);

    function WeatherIcon() {
        _classCallCheck(this, WeatherIcon);

        return _possibleConstructorReturn(this, (WeatherIcon.__proto__ || Object.getPrototypeOf(WeatherIcon)).apply(this, arguments));
    }

    _createClass(WeatherIcon, [{
        key: 'render',
        value: function render() {
            var successpc = parseInt(this.props.score) || 0;
            var status = getStatusClassName(successpc);
            var classNames = 'weather-icon ' + status;

            if (this.props.size === 'large') {
                classNames += ' large-icon';
            }

            return _react2.default.createElement('svg', { title: status, className: classNames });
        }
    }]);

    return WeatherIcon;
}(_react.Component);

WeatherIcon.defaultProps = {
    size: 'default'
};
WeatherIcon.propTypes = {
    score: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string]),
    size: _react.PropTypes.string
};
//# sourceMappingURL=weather-icon.js.map
