'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('ExpandablePath', module).add('short', function () {
    var path = 'jenkins / pipeline';
    return _react2.default.createElement(_components.ExpandablePath, { path: path });
}).add('long', function () {
    var path = 'jenkins / folder1 / folder2 / pipeline';
    return _react2.default.createElement(_components.ExpandablePath, { path: path });
}).add('long, with wrap', function () {
    var path = 'jenkins / long-folder-name1 / long-folder-name2 / long-folder-name3 / long-folder-name4 / pipeline';
    return _react2.default.createElement(
        'div',
        { style: { width: 250 } },
        _react2.default.createElement(_components.ExpandablePath, { path: path })
    );
}).add('short, hide first', function () {
    var path = 'jenkins / folder1';
    return _react2.default.createElement(_components.ExpandablePath, { path: path, hideFirst: true });
}).add('long, hide first', function () {
    var path = 'jenkins / folder1 / folder2 / pipeline';
    return _react2.default.createElement(_components.ExpandablePath, { path: path, hideFirst: true });
}).add('with uri-encoded parts', function () {
    var path = 'jenkins / Pipeline%20Jobs / pipeline1';
    return _react2.default.createElement(_components.ExpandablePath, { path: path });
}).add('style: with link', function () {
    var path = 'Jenkins / folder1 / folder2 / pipeline';
    return _react2.default.createElement(
        'a',
        { href: 'http://jenkins.io', target: '_blank' },
        _react2.default.createElement(_components.ExpandablePath, { path: path })
    );
}).add('style: large', function () {
    var path = 'Jenkins / folder1 / folder2 / pipeline';
    return _react2.default.createElement(
        'div',
        { style: { fontSize: 24 } },
        _react2.default.createElement(_components.ExpandablePath, { path: path, iconSize: 28 })
    );
}).add('style: dark theme', function () {
    var path = 'Jenkins / folder1 / folder2 / pipeline';
    return _react2.default.createElement(
        'div',
        { style: { background: '#4A90E2' } },
        _react2.default.createElement(_components.ExpandablePath, { className: 'dark-theme', path: path })
    );
}).add('custom label', function () {
    var path = 'Jenkins / folder1 / folder2 / pipeline';
    path = _components.ExpandablePath.replaceLastPathElement(path, 'Fancy Pipeline Name');
    return _react2.default.createElement(
        'a',
        { href: 'http://jenkins.io', target: '_blank' },
        _react2.default.createElement(_components.ExpandablePath, { path: path })
    );
}); /**
     * Created by cmeyers on 10/4/16.
     */
//# sourceMappingURL=ExpandablePathStories.js.map
