'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('FilterableList', module).add('general', function () {
    return _react2.default.createElement(General, null);
});

var simpleData = ['A', 'B', 'C', 'D', 'EFGHIJKLMNOPQRSTUV', 'W', 'X', 'Y', 'Z'];

var detailedData = [{ name: 'Ryu', dob: '21-7-1964', height: '5\'10"', weight: '150 lbs', blood: 'O' }, { name: 'E. Honda', dob: '3-11-1960', height: '6\'2"', weight: '304 lbs', blood: 'A' }, { name: 'Blanka', dob: '12-2-1966', height: '6\'5"', weight: '218 lbs', blood: 'B' }, { name: 'Guile', dob: '23-12-1960', height: '6\'1"', weight: '191 lbs', blood: 'O' }, { name: 'Ken', dob: '14-2-1966', height: '5\'10"', weight: '169 lbs', blood: 'B' }, { name: 'Chun-Li', dob: '1-3-1968', height: '5\'8"', weight: '-', blood: 'A' }, { name: 'Zangief', dob: '1-6-1956', height: '7\'', weight: '256 lbs', blood: 'A' }, { name: 'Dhalsim', dob: '22-11-1962', height: '5\'10"', weight: '107 lbs', blood: 'O' }];

function General() {
    var heading = {
        height: 40
    };

    var outer = {
        display: 'flex',
        justifyContent: 'space-around'
    };

    var inner = {
        padding: 10,
        width: 300
    };
    var list = {
        maxHeight: 176
    };

    return _react2.default.createElement(
        'div',
        { style: outer },
        _react2.default.createElement(
            'div',
            { style: inner },
            _react2.default.createElement(
                'p',
                { style: heading },
                'Simple data'
            ),
            _react2.default.createElement(_components.FilterableList, {
                data: simpleData,
                listStyle: list
            })
        ),
        _react2.default.createElement(
            'div',
            { style: inner },
            _react2.default.createElement(
                'p',
                { style: heading },
                'Simple data, with \'placeholder\' and \'emptyText\''
            ),
            _react2.default.createElement(_components.FilterableList, {
                data: simpleData,
                listStyle: list,
                placeholder: 'Suche...',
                emptyText: 'Nichts.'
            })
        ),
        _react2.default.createElement(
            'div',
            { style: inner },
            _react2.default.createElement(
                'p',
                { style: heading },
                'Complex data, with labelFunction and filterFunction'
            ),
            _react2.default.createElement(_components.FilterableList, {
                data: detailedData,
                listStyle: list,
                labelFunction: function labelFunction(item) {
                    return item.name + ', ' + item.height + ', ' + item.weight;
                },
                filterFunction: function filterFunction(text, item) {
                    return item.name.toLowerCase().indexOf(text) !== -1;
                }
            })
        )
    );
}
//# sourceMappingURL=FilterableListStories.js.map
