'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _TruncatingLabel = require('../components/TruncatingLabel');

var _textdata = require('./data/textdata');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('Label', module).add('Basic', basic).add('Broken 1', basic2).add('Null children', empty1).add('Missing children', empty2).add('Blank children', empty3).add('Many', many);

function basic() {
    return _react2.default.createElement(
        'div',
        { style: { margin: '1em' } },
        example(210, 121, _textdata.hgw)
    );
}

function empty1() {
    return _react2.default.createElement(
        'div',
        { style: { margin: '1em' } },
        example(200, 200, null)
    );
}

function empty2() {
    return _react2.default.createElement(
        'div',
        { style: { margin: '1em' } },
        example(200, 200, undefined)
    );
}

function empty3() {
    return _react2.default.createElement(
        'div',
        { style: { margin: '1em' } },
        example(200, 200, "")
    );
}

function basic2() {

    // This was showing a failure to settle within 50 iterations in the pipeline graph

    var badString = "Das komputermaschine ist nicht auf mittengraben unt die gerfingerpoken. Watchen das blinkenlights.";

    return _react2.default.createElement(
        'div',
        { style: { margin: '1em', fontSize: '80%' } },
        example(89, 34, badString)
    );
}

function many() {
    return _react2.default.createElement(
        'div',
        { style: { margin: '1em' } },
        example(100, 100, _textdata.hgw),
        _react2.default.createElement('br', null),
        example(180, 100, _textdata.hgw),
        _react2.default.createElement('br', null),
        example(200, 100, _textdata.hgw),
        _react2.default.createElement('br', null),
        example(50, 180, _textdata.hgw),
        _react2.default.createElement('br', null),
        example(80, 80, _textdata.hgw),
        _react2.default.createElement('br', null),
        example(180, 180, _textdata.hgw)
    );
}

function example(width, height, txt) {

    var w = width + 'px';
    var h = height + 'px';

    var outer = { // We'll put the bg on this, because it's got a fixed size instead of max
        width: w,
        height: h,
        background: '#eee'
    };

    var style2 = {
        maxWidth: w,
        maxHeight: h
    };

    return _react2.default.createElement(
        'div',
        { style: outer },
        _react2.default.createElement(
            _TruncatingLabel.TruncatingLabel,
            { style: style2 },
            txt
        )
    );
}
//# sourceMappingURL=LabelStories.js.map
