'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _RadioButtonGroup = require('../components/forms/RadioButtonGroup');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('RadioButtonGroup', module).add('general', function () {
    return _react2.default.createElement(General, null);
}).add('labeling', function () {
    return _react2.default.createElement(Labeling, null);
}).add('callbacks', function () {
    return _react2.default.createElement(Callbacks, null);
}).add('sizes', function () {
    return _react2.default.createElement(Sizes, null);
});

var style = {
    padding: 10
};

var options = ['Alpha', 'Beta', 'Charlie'];

function General() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Vertical'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
                options: options
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Horizontal'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
                className: 'u-layout-horizontal',
                options: options
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Disabled'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
                options: options,
                className: 'u-layout-horizontal',
                defaultOption: 'Alpha',
                disabled: true
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Default Value'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
                options: options,
                className: 'u-layout-horizontal',
                defaultOption: 'Charlie'
            })
        )
    );
}

function Labeling() {
    var options = [{ label: 'Foo' }, { label: 'Bar' }, { label: 'Baz' }];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using labelField=\'label\''
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
                options: options,
                labelField: 'label'
            })
        ),
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using labelFunction'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
                options: options,
                labelFunction: function labelFunction(item) {
                    return '!' + item.label + '!';
                }
            })
        )
    );
}

function Callbacks() {
    return _react2.default.createElement(
        'div',
        { style: style },
        _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, {
            options: ['A', 'B', 'C'],
            onChange: function onChange(val) {
                return console.log('onChange', val);
            }
        })
    );
}

function Sizes() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using no layout'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, { options: options })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-small'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, { options: options })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-medium'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, { options: options })
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-large'
            ),
            _react2.default.createElement(_RadioButtonGroup.RadioButtonGroup, { options: options })
        )
    );
}
//# sourceMappingURL=RadioButtonGroupStories.js.map
