'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _EmptyStateView = require('../components/EmptyStateView');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('EmptyStateView', module).add('One-Liner', oneLiner).add('Content & Wide Image', contentWithWideImage).add('Content & Narrow Image', contentWithNarrowImage).add('Content & Icon', contentWithIcon).add('Content Only', contentOnly).add('Image Only', imageOnly); /* eslint-disable */


function oneLiner() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement('span', { className: 'componentdoc', 'data-docfile': 'doc-emptystate-oneliner' }),
        _react2.default.createElement(
            _EmptyStateView.EmptyStateView,
            { tightSpacing: true },
            _react2.default.createElement(
                'p',
                null,
                'There are no artifacts for this pipeline run.'
            )
        )
    );
}

function contentWithWideImage() {
    return _react2.default.createElement(
        _EmptyStateView.EmptyStateView,
        { iconName: 'branch' },
        defaultContent()
    );
}

function contentWithNarrowImage() {
    return _react2.default.createElement(
        _EmptyStateView.EmptyStateView,
        { iconName: 'goat' },
        defaultContent()
    );
}

function contentWithIcon() {
    return _react2.default.createElement(
        _EmptyStateView.EmptyStateView,
        { iconName: 'ActionDoneAll' },
        defaultContent()
    );
}

function contentOnly() {
    return _react2.default.createElement(
        _EmptyStateView.EmptyStateView,
        null,
        defaultContent()
    );
}

function imageOnly() {
    return _react2.default.createElement(_EmptyStateView.EmptyStateView, { iconName: 'shoes' });
}

function defaultContent() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'h1',
            null,
            'Push me, pull you'
        ),
        _react2.default.createElement(
            'p',
            null,
            'When a Pull Request is opened on the repository Panther, Jenkins will test it and report the status of your changes back to the pull request on Github.'
        ),
        _react2.default.createElement(
            'button',
            null,
            'Enable'
        )
    );
}
//# sourceMappingURL=emptystateview.js.map
