/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.status;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.QueueListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.checks.status.AbstractStatusChecksProperties;
import io.jenkins.plugins.checks.status.DefaultStatusCheckProperties;
import io.jenkins.plugins.checks.status.StatusChecksProperties;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.File;
import java.util.Optional;

public final class BuildStatusChecksPublisher {
    private static final JenkinsFacade JENKINS = new JenkinsFacade();
    private static final AbstractStatusChecksProperties DEFAULT_PROPERTIES = new DefaultStatusCheckProperties();

    private static void publish(ChecksPublisher publisher, ChecksStatus status, ChecksConclusion conclusion, String name) {
        publisher.publish(new ChecksDetails.ChecksDetailsBuilder().withName(name).withStatus(status).withConclusion(conclusion).build());
    }

    @Deprecated
    private static Optional<StatusChecksProperties> findDeprecatedProperties(Job<?, ?> job) {
        return JENKINS.getExtensionsFor(StatusChecksProperties.class).stream().filter(p -> p.isApplicable(job)).findFirst();
    }

    private static AbstractStatusChecksProperties findProperties(Job<?, ?> job) {
        return JENKINS.getExtensionsFor(AbstractStatusChecksProperties.class).stream().filter(p -> p.isApplicable(job)).findFirst().orElse(DEFAULT_PROPERTIES);
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run run, @CheckForNull TaskListener listener) {
            Job job = run.getParent();
            Optional deprecatedProperties = BuildStatusChecksPublisher.findDeprecatedProperties(job);
            if (deprecatedProperties.isPresent()) {
                if (!((StatusChecksProperties)deprecatedProperties.get()).isSkip(job)) {
                    BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, listener), ChecksStatus.COMPLETED, this.extractConclusion(run), ((StatusChecksProperties)deprecatedProperties.get()).getName(job));
                }
            } else {
                AbstractStatusChecksProperties properties = BuildStatusChecksPublisher.findProperties(job);
                if (!properties.isSkipped(job)) {
                    BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, listener), ChecksStatus.COMPLETED, this.extractConclusion(run), properties.getName(job));
                }
            }
        }

        private ChecksConclusion extractConclusion(Run<?, ?> run) {
            Result result = run.getResult();
            if (result == null) {
                throw new IllegalStateException("No result when the run completes, run: " + run.toString());
            }
            if (result.isBetterOrEqualTo(Result.SUCCESS)) {
                return ChecksConclusion.SUCCESS;
            }
            if (result.isBetterOrEqualTo(Result.UNSTABLE) || result.isBetterOrEqualTo(Result.FAILURE)) {
                return ChecksConclusion.FAILURE;
            }
            if (result.isBetterOrEqualTo(Result.NOT_BUILT)) {
                return ChecksConclusion.SKIPPED;
            }
            if (result.isBetterOrEqualTo(Result.ABORTED)) {
                return ChecksConclusion.CANCELED;
            }
            throw new IllegalStateException("Unsupported run result: " + result);
        }
    }

    @Extension
    public static class JobCheckoutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> run, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
            Job job = run.getParent();
            Optional deprecatedProperties = BuildStatusChecksPublisher.findDeprecatedProperties(job);
            if (deprecatedProperties.isPresent()) {
                if (!((StatusChecksProperties)deprecatedProperties.get()).isSkip(job)) {
                    BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, listener), ChecksStatus.IN_PROGRESS, ChecksConclusion.NONE, ((StatusChecksProperties)deprecatedProperties.get()).getName(job));
                }
            } else {
                AbstractStatusChecksProperties properties = BuildStatusChecksPublisher.findProperties(job);
                if (!properties.isSkipped(job)) {
                    BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, listener), ChecksStatus.IN_PROGRESS, ChecksConclusion.NONE, properties.getName(job));
                }
            }
        }
    }

    @Extension
    public static class JobScheduledListener
    extends QueueListener {
        public void onEnterWaiting(Queue.WaitingItem wi) {
            if (!(wi.task instanceof Job)) {
                return;
            }
            Job job = (Job)wi.task;
            Optional deprecatedProperties = BuildStatusChecksPublisher.findDeprecatedProperties(job);
            if (deprecatedProperties.isPresent()) {
                if (!((StatusChecksProperties)deprecatedProperties.get()).isSkip(job)) {
                    BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromJob(job, TaskListener.NULL), ChecksStatus.QUEUED, ChecksConclusion.NONE, ((StatusChecksProperties)deprecatedProperties.get()).getName(job));
                }
            } else {
                AbstractStatusChecksProperties properties = BuildStatusChecksPublisher.findProperties(job);
                if (!properties.isSkipped(job)) {
                    BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromJob(job, TaskListener.NULL), ChecksStatus.QUEUED, ChecksConclusion.NONE, properties.getName(job));
                }
            }
        }
    }
}

